;;; -*- Mode: LISP; Syntax: COMMON-LISP; Package: XIT; Base: 10; -*-
;;;___________________________________________________________________________
;;;
;;;                       System: 
;;;                       Module: 
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Hubertus Hohl
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/examples/initialization.lisp
;;; File Creation Date: 10/08/91 09:52:43
;;; Last Modification Time: 12/08/92 12:15:17
;;; Last Modification By: Hubertus Hohl
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;;___________________________________________________________________________

(in-package :xit)


(push (system-pathname :xit-examples "bitmaps/") *bitmap-directory*)


(define-resources
  (* intel-example-window background) "white"
  (* intel-example-window border-width) 1
  (* intel-example-window title-font) '(:face :bolditalic)

  (* layouter-example-window border-width) 1
  (* layouter-example-window title-font) '(:face :bold :size 12)

  (* menu-example-dispel height) 30
  (* menu-example-dispel width) 100
  (* background-menu menu-example-dispel width) 30
  (* background-menu menu-example-dispel border-width) 1

  (* intel-example-icon-menu background) "white" 
  (* intel-example-icon-menu border-width) 1
  (* xit-examples x) 5
  (* xit-examples y) 50

  (* demo-window x) 150
  (* demo-window y) 50
  (* demo-window width) 150
  (* demo-window height) 100
  (* demo-window border-width) 2
  (* demo-window cursor) "hand2-cursor"
  )

(setq icon-menu
     (make-window 'intel-example-icon-menu
		   :name 'xit-examples
		   :title "XIT Examples"))

(setq demo-window
     (make-window 'intel-example-window
		   :name 'demo-window
		   :window-icon-pos :constrained
		   :title "Demo Window"))


(update-state *display*)
(process-all-events *display*)
