dnl Copyright (C) 1993-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible, Marcus Daniels.

AC_PREREQ(2.13)

AC_DEFUN([CL_FPU_CONTROL],
[dnl Check for Linux with <fpu_control.h> and fpu_control_t or __setfpucw().
dnl glibc versions since October 1998 define fpu_control_t. Earlier versions
dnl define and declare __setfpucw(). Very early Linux libc versions have none,
dnl and __fpu_control is of type `unsigned short'.
CL_COMPILE_CHECK([fpu_control_t], cl_cv_type_fpu_control_t,
[#include <fpu_control.h>], [fpu_control_t x;],
AC_DEFINE(HAVE_FPU_CONTROL_T))
CL_COMPILE_CHECK([__setfpucw], cl_cv_func_setfpucw,
[#include <fpu_control.h>], [__setfpucw(_FPU_IEEE);],
AC_DEFINE(HAVE_SETFPUCW))
])
