/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2018, 2024 (c)
 * 
 *    file: module_perl.c
 *    This file is part of mino.
 *
 *    mino is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino.  If not, see <http://www.gnu.org/licenses/>.
 */    
#include "modules.h"

char *ext_perl[] = { "pl", "PL" };
wchar_t *keyword_perl[] = {
      //PERL functions
      L"-A",
      L"-B",
      L"-b",
      L"-C",
      L"-c",
      L"-d",
      L"-e",
      L"-f",
      L"-g",
      L"-k",
      L"-l",
      L"-M",
      L"-O",
      L"-o",
      L"-p",
      L"-r",
      L"-R",
      L"-s",
      L"-S",
      L"-T",
      L"-t",
      L"-u",
      L"-w",
      L"-W",
      L"-X",
      L"-x",
      L"-z",
      L"abs",
      L"accept",
      L"alarm",
      L"atan2",
      L"AUTOLOAD",
      L"BEGIN",
      L"bind",
      L"binmode",
      L"bless",
      L"break",
      L"caller",
      L"chdir",
      L"CHECK",
      L"chmod",
      L"chomp",
      L"chop",
      L"chown",
      L"chr",
      L"chroot",
      L"close",
      L"closedir",
      L"connect",
      L"cos",
      L"crypt",
      L"dbmclose",
      L"dbmopen",
      L"defined",
      L"delete",
      L"DESTROY",
      L"die",
      L"dump",
      L"each",
      L"END",
      L"endgrent",
      L"endhostent",
      L"endprotoent",
      L"endpwent",
      L"endservent",
      L"eof",
      L"eval",
      L"exec",
      L"exists",
      L"exit",
      L"fcntl",
      L"fileno",
      L"flock",
      L"fork",
      L"format",
      L"formline",
      L"getc",
      L"getgrent",
      L"getgrgid",
      L"getgrnam",
      L"gethostbyaddr",
      L"gethostbyname",
      L"gethostent",
      L"getlogin",
      L"getnetbyaddr",
      L"getnetbyname",
      L"getnetent",
      L"getpeername",
      L"getpgrp",
      L"getppid",
      L"getpriority",
      L"getprotobyname",
      L"getprotobynumber",
      L"getprotoent",
      L"getpwent",
      L"getpwnam",
      L"getpwuid",
      L"getservbyname",
      L"getservbyport",
      L"getservent",
      L"getsockname",
      L"getsockopt",
      L"glob",
      L"gmtime",
      L"goto",
      L"grep",
      L"hex",
      L"index",
      L"INIT",
      L"int",
      L"ioctl",
      L"join",
      L"keys",
      L"kill",
      L"last",
      L"lc",
      L"lcfirst",
      L"length",
      L"link",
      L"listen",
      L"local",
      L"localtime",
      L"log",
      L"lstat",
      L"map",
      L"mkdir",
      L"msgctl",
      L"msgget",
      L"msgrcv",
      L"msgsnd",
      L"my",
      L"next",
      L"not",
      L"oct",
      L"open",
      L"opendir",
      L"ord",
      L"our",
      L"pack",
      L"pipe",
      L"pop",
      L"pos",
      L"print",
      L"printf",
      L"prototype",
      L"push",
      L"quotemeta",
      L"rand",
      L"read",
      L"readdir",
      L"readline",
      L"readlink",
      L"readpipe",
      L"recv",
      L"redo",
      L"ref",
      L"rename",
      L"require",
      L"reset",
      L"return",
      L"reverse",
      L"rewinddir",
      L"rindex",
      L"rmdir",
      L"say",
      L"scalar",
      L"seek",
      L"seekdir",
      L"select",
      L"semctl",
      L"semget",
      L"semop",
      L"send",
      L"setgrent",
      L"sethostent",
      L"setnetent",
      L"setpgrp",
      L"setpriority",
      L"setprotoent",
      L"setpwent",
      L"setservent",
      L"setsockopt",
      L"shift",
      L"shmctl",
      L"shmget",
      L"shmread",
      L"shmwrite",
      L"shutdown",
      L"sin",
      L"sleep",
      L"socket",
      L"socketpair",
      L"sort",
      L"splice",
      L"split",
      L"sprintf",
      L"sqrt",
      L"srand",
      L"stat",
      L"state",
      L"study",
      L"substr",
      L"symlink",
      L"syscall",
      L"sysopen",
      L"sysread",
      L"sysseek",
      L"system",
      L"syswrite",
      L"tell",
      L"telldir",
      L"tie",
      L"tied",
      L"time",
      L"times",
      L"truncate",
      L"uc",
      L"ucfirst",
      L"umask",
      L"undef",
      L"UNITCHECK",
      L"unlink",
      L"unpack",
      L"unshift",
      L"untie",
      L"use",
      L"utime",
      L"values",
      L"vec",
      L"wait",
      L"waitpid",
      L"wantarray",
      L"warn",
      L"write",
      //PERL syntax
      L"__DATA__",
      L"__END__",
      L"__FILE__",
      L"__LINE__",
      L"__PACKAGE__",
      L"and",
      L"cmp",
      L"continue",
      L"CORE",
      L"do",
      L"else",
      L"elsif",
      L"eq",
      L"exp",
      L"for",
      L"foreach",
      L"ge",
      L"gt",
      L"if",
      L"le",
      L"lock",
      L"lt",
      L"m",
      L"ne",
      L"no",
      L"or",
      L"package",
      L"q",
      L"qq",
      L"qr",
      L"qw",
      L"qx",
      L"s",
      L"sub",
      L"tr",
      L"unless",
      L"until",
      L"while",
      L"xor",
      L"y",
      //PERL variables
      L"$!",
      L"$\"",
      L"$#",
      L"$$",
      L"$%",
      L"$&",
      L"$'",
      L"$(",
      L"$)",
      L"$*",
      L"$+",
      L"$,",
      L"$-",
      L"$.",
      L"$/",
      L"$0",
      L"$:",
      L"$;",
      L"$<",
      L"$=",
      L"$>",
      L"$?",
      L"$@",
      L"$[",
      L"$\\",
      L"$]",
      L"$^",
      L"$^A",
      L"$^C",
      L"$^CHILD_ERROR_NATIVE",
      L"$^D",
      L"$^E",
      L"$^ENCODING",
      L"$^F",
      L"$^H",
      L"$^I",
      L"$^L",
      L"$^M",
      L"$^N",
      L"$^O",
      L"$^OPEN",
      L"$^P",
      L"$^R",
      L"$^RE_DEBUG_FLAGS",
      L"$^RE_TRIE_MAXBUF",
      L"$^S",
      L"$^T",
      L"$^TAINT",
      L"$^UNICODE",
      L"$^UTF8LOCALE",
      L"$^V",
      L"$^W",
      L"$^WARNING_BITS",
      L"$^WIDE_SYSTEM_CALLS",
      L"$^X",
      L"$_",
      L"$`",
      L"$a",
      L"$ACCUMULATOR",
      L"$ARG",
      L"$ARGV",
      L"$b",
      L"$BASETIME",
      L"$CHILD_ERROR",
      L"$COMPILING",
      L"$DEBUGGING",
      L"$EFFECTIVE_GROUP_ID",
      L"$EFFECTIVE_USER_ID",
      L"$EGID",
      L"$ERRNO",
      L"$EUID",
      L"$EVAL_ERROR",
      L"$EXCEPTIONS_BEING_CAUGHT",
      L"$EXECUTABLE_NAME",
      L"$EXTENDED_OS_ERROR",
      L"$FORMAT_FORMFEED",
      L"$FORMAT_LINE_BREAK_CHARACTERS",
      L"$FORMAT_LINES_LEFT",
      L"$FORMAT_LINES_PER_PAGE",
      L"$FORMAT_NAME",
      L"$FORMAT_PAGE_NUMBER",
      L"$FORMAT_TOP_NAME",
      L"$GID",
      L"$INPLACE_Mino",
      L"$INPUT_LINE_NUMBER",
      L"$INPUT_RECORD_SEPARATOR",
      L"$LAST_MATCH_END",
      L"$LAST_PAREN_MATCH",
      L"$LAST_REGEXP_CODE_RESULT",
      L"$LIST_SEPARATOR",
      L"$MATCH",
      L"$MULTILINE_MATCHING",
      L"$NR",
      L"$OFMT",
      L"$OFS",
      L"$ORS",
      L"$OS_ERROR",
      L"$OSNAME",
      L"$OUTPUT_AUTO_FLUSH",
      L"$OUTPUT_FIELD_SEPARATOR",
      L"$OUTPUT_RECORD_SEPARATOR",
      L"$PERL_VERSION",
      L"$PERLDB",
      L"$PID",
      L"$POSMATCH",
      L"$PREMATCH",
      L"$PROCESS_ID",
      L"$PROGRAM_NAME",
      L"$REAL_GROUP_ID",
      L"$REAL_USER_ID",
      L"$RS",
      L"$SUBSCRIPT_SEPARATOR",
      L"$SUBSEP",
      L"$SYSTEM_FD_MAX",
      L"$UID",
      L"$WARNING",
      L"$|",
      L"$~",
      L"%!",
      L"%^H",
      L"%ENV",
      L"%INC",
      L"%OVERLOAD",
      L"%SIG",
      L"@+",
      L"@-",
      L"@_",
      L"@ARGV",
      L"@INC",
      L"@LAST_MATCH_START",
      //PERL file handles
      L"ARGV",
      L"ARGVOUT",
      L"STDERR",
      L"STDIN",
      L"STDOUT",
};

struct modulestruct module_perl =
{
    .extsCount      = 2,
    .exts           = ext_perl,
    .keywordCount   = 409,
    .keywords       = keyword_perl,
    .mlCommentStart = NULL,
    .mlCommentEnd   = NULL,
    .slCommentStart = L"#",
    .caseSensitive  = 1,
};

