<?xml version='1.0' encoding='UTF-8'?>
<!--

  Convert a jMemorize flashcard file to an ignuit flashcard file.
  Command line usage:

  xsltproc -novalid -o outfile.xml jMemorize.xsl infile.jml

  trm 2008-01-18
  trm 2009-03-24 - Preserve category names.

-->
<xsl:stylesheet version='1.0'
  xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

  <xsl:output method='xml' indent='yes' encoding='UTF-8' />

  <xsl:template match='Card'>
    <card>
      <front>
        <xsl:value-of select='@Frontside' />
      </front>
      <back>
        <xsl:value-of select='@Backside' />
      </back>
    </card>
  </xsl:template>

  <xsl:template match='Deck'>
    <xsl:if test="descendant::*">
      <category>
        <xsl:attribute name='title'>
          <xsl:value-of select='../@name' />
        </xsl:attribute>
        <xsl:apply-templates />
      </category>
    </xsl:if>
  </xsl:template>

  <xsl:template match='/Lesson'>
    <deck>
      <xsl:attribute name='version'>
        <xsl:text>1</xsl:text>
      </xsl:attribute>
      <xsl:attribute name='title'>
        <xsl:text>Imported jMemorize File</xsl:text>
      </xsl:attribute>
      <xsl:attribute name='style'>
        <xsl:text>1</xsl:text>
      </xsl:attribute>

      <xsl:apply-templates />

    </deck>
  </xsl:template>

</xsl:stylesheet>
