/* -*-C-*-

DO NOT EDIT: this file was generated by a program.

Copyright (C) 2018 Massachusetts Institute of Technology

This is free software; see the source for copying conditions. There is NO
warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

*/

/* Instructions for SVM version 1 */

#ifndef SCM_SVM1_DEFNS_H
#define SCM_SVM1_DEFNS_H 1

#define SVM1_REG_INTERPRETER_REGISTER_BLOCK 0
#define SVM1_REG_STACK_POINTER 1
#define SVM1_REG_FREE_POINTER 2
#define SVM1_REG_VALUE 3
#define SVM1_REG_DYNAMIC_LINK 4

#define SVM1_ADDR_START_CODE 0x01
#define SVM1_ADDR_END_CODE 0x23

#define SVM1_ADDR_BINDINGS(binder) \
  binder (SVM1_ADDR_INDIR, indir); \
  binder (SVM1_ADDR_OFFSET_S8_B, offset_s8_b); \
  binder (SVM1_ADDR_OFFSET_S8_W, offset_s8_w); \
  binder (SVM1_ADDR_OFFSET_S8_F, offset_s8_f); \
  binder (SVM1_ADDR_OFFSET_S16_B, offset_s16_b); \
  binder (SVM1_ADDR_OFFSET_S16_W, offset_s16_w); \
  binder (SVM1_ADDR_OFFSET_S16_F, offset_s16_f); \
  binder (SVM1_ADDR_OFFSET_S32_B, offset_s32_b); \
  binder (SVM1_ADDR_OFFSET_S32_W, offset_s32_w); \
  binder (SVM1_ADDR_OFFSET_S32_F, offset_s32_f); \
  binder (SVM1_ADDR_INDEX_B_B, index_b_b); \
  binder (SVM1_ADDR_INDEX_B_W, index_b_w); \
  binder (SVM1_ADDR_INDEX_B_F, index_b_f); \
  binder (SVM1_ADDR_INDEX_W_B, index_w_b); \
  binder (SVM1_ADDR_INDEX_W_W, index_w_w); \
  binder (SVM1_ADDR_INDEX_W_F, index_w_f); \
  binder (SVM1_ADDR_INDEX_F_B, index_f_b); \
  binder (SVM1_ADDR_INDEX_F_W, index_f_w); \
  binder (SVM1_ADDR_INDEX_F_F, index_f_f); \
  binder (SVM1_ADDR_PREDEC_B, predec_b); \
  binder (SVM1_ADDR_PREDEC_W, predec_w); \
  binder (SVM1_ADDR_PREDEC_F, predec_f); \
  binder (SVM1_ADDR_PREINC_B, preinc_b); \
  binder (SVM1_ADDR_PREINC_W, preinc_w); \
  binder (SVM1_ADDR_PREINC_F, preinc_f); \
  binder (SVM1_ADDR_POSTDEC_B, postdec_b); \
  binder (SVM1_ADDR_POSTDEC_W, postdec_w); \
  binder (SVM1_ADDR_POSTDEC_F, postdec_f); \
  binder (SVM1_ADDR_POSTINC_B, postinc_b); \
  binder (SVM1_ADDR_POSTINC_W, postinc_w); \
  binder (SVM1_ADDR_POSTINC_F, postinc_f); \
  binder (SVM1_ADDR_PCR_S8, pcr_s8); \
  binder (SVM1_ADDR_PCR_S16, pcr_s16); \
  binder (SVM1_ADDR_PCR_S32, pcr_s32)

#define SVM1_ADDR_INDIR 0x01
#define DECODE_SVM1_ADDR_INDIR(base) \
  DECODE_WORD_REGISTER (base)

#define SVM1_ADDR_OFFSET_S8_B 0x02
#define DECODE_SVM1_ADDR_OFFSET_S8_B(base, offset) \
  DECODE_WORD_REGISTER (base); \
  DECODE_SIGNED_8 (offset)

#define SVM1_ADDR_OFFSET_S8_W 0x03
#define DECODE_SVM1_ADDR_OFFSET_S8_W(base, offset) \
  DECODE_WORD_REGISTER (base); \
  DECODE_SIGNED_8 (offset)

#define SVM1_ADDR_OFFSET_S8_F 0x04
#define DECODE_SVM1_ADDR_OFFSET_S8_F(base, offset) \
  DECODE_WORD_REGISTER (base); \
  DECODE_SIGNED_8 (offset)

#define SVM1_ADDR_OFFSET_S16_B 0x05
#define DECODE_SVM1_ADDR_OFFSET_S16_B(base, offset) \
  DECODE_WORD_REGISTER (base); \
  DECODE_SIGNED_16 (offset)

#define SVM1_ADDR_OFFSET_S16_W 0x06
#define DECODE_SVM1_ADDR_OFFSET_S16_W(base, offset) \
  DECODE_WORD_REGISTER (base); \
  DECODE_SIGNED_16 (offset)

#define SVM1_ADDR_OFFSET_S16_F 0x07
#define DECODE_SVM1_ADDR_OFFSET_S16_F(base, offset) \
  DECODE_WORD_REGISTER (base); \
  DECODE_SIGNED_16 (offset)

#define SVM1_ADDR_OFFSET_S32_B 0x08
#define DECODE_SVM1_ADDR_OFFSET_S32_B(base, offset) \
  DECODE_WORD_REGISTER (base); \
  DECODE_SIGNED_32 (offset)

#define SVM1_ADDR_OFFSET_S32_W 0x09
#define DECODE_SVM1_ADDR_OFFSET_S32_W(base, offset) \
  DECODE_WORD_REGISTER (base); \
  DECODE_SIGNED_32 (offset)

#define SVM1_ADDR_OFFSET_S32_F 0x0a
#define DECODE_SVM1_ADDR_OFFSET_S32_F(base, offset) \
  DECODE_WORD_REGISTER (base); \
  DECODE_SIGNED_32 (offset)

#define SVM1_ADDR_INDEX_B_B 0x0b
#define DECODE_SVM1_ADDR_INDEX_B_B(base, offset, index) \
  DECODE_WORD_REGISTER (base); \
  DECODE_UNSIGNED_8 (offset); \
  DECODE_WORD_REGISTER (index)

#define SVM1_ADDR_INDEX_B_W 0x0c
#define DECODE_SVM1_ADDR_INDEX_B_W(base, offset, index) \
  DECODE_WORD_REGISTER (base); \
  DECODE_UNSIGNED_8 (offset); \
  DECODE_WORD_REGISTER (index)

#define SVM1_ADDR_INDEX_B_F 0x0d
#define DECODE_SVM1_ADDR_INDEX_B_F(base, offset, index) \
  DECODE_WORD_REGISTER (base); \
  DECODE_UNSIGNED_8 (offset); \
  DECODE_WORD_REGISTER (index)

#define SVM1_ADDR_INDEX_W_B 0x0e
#define DECODE_SVM1_ADDR_INDEX_W_B(base, offset, index) \
  DECODE_WORD_REGISTER (base); \
  DECODE_UNSIGNED_8 (offset); \
  DECODE_WORD_REGISTER (index)

#define SVM1_ADDR_INDEX_W_W 0x0f
#define DECODE_SVM1_ADDR_INDEX_W_W(base, offset, index) \
  DECODE_WORD_REGISTER (base); \
  DECODE_UNSIGNED_8 (offset); \
  DECODE_WORD_REGISTER (index)

#define SVM1_ADDR_INDEX_W_F 0x10
#define DECODE_SVM1_ADDR_INDEX_W_F(base, offset, index) \
  DECODE_WORD_REGISTER (base); \
  DECODE_UNSIGNED_8 (offset); \
  DECODE_WORD_REGISTER (index)

#define SVM1_ADDR_INDEX_F_B 0x11
#define DECODE_SVM1_ADDR_INDEX_F_B(base, offset, index) \
  DECODE_WORD_REGISTER (base); \
  DECODE_UNSIGNED_8 (offset); \
  DECODE_WORD_REGISTER (index)

#define SVM1_ADDR_INDEX_F_W 0x12
#define DECODE_SVM1_ADDR_INDEX_F_W(base, offset, index) \
  DECODE_WORD_REGISTER (base); \
  DECODE_UNSIGNED_8 (offset); \
  DECODE_WORD_REGISTER (index)

#define SVM1_ADDR_INDEX_F_F 0x13
#define DECODE_SVM1_ADDR_INDEX_F_F(base, offset, index) \
  DECODE_WORD_REGISTER (base); \
  DECODE_UNSIGNED_8 (offset); \
  DECODE_WORD_REGISTER (index)

#define SVM1_ADDR_PREDEC_B 0x14
#define DECODE_SVM1_ADDR_PREDEC_B(base) \
  DECODE_WORD_REGISTER (base)

#define SVM1_ADDR_PREDEC_W 0x15
#define DECODE_SVM1_ADDR_PREDEC_W(base) \
  DECODE_WORD_REGISTER (base)

#define SVM1_ADDR_PREDEC_F 0x16
#define DECODE_SVM1_ADDR_PREDEC_F(base) \
  DECODE_WORD_REGISTER (base)

#define SVM1_ADDR_PREINC_B 0x17
#define DECODE_SVM1_ADDR_PREINC_B(base) \
  DECODE_WORD_REGISTER (base)

#define SVM1_ADDR_PREINC_W 0x18
#define DECODE_SVM1_ADDR_PREINC_W(base) \
  DECODE_WORD_REGISTER (base)

#define SVM1_ADDR_PREINC_F 0x19
#define DECODE_SVM1_ADDR_PREINC_F(base) \
  DECODE_WORD_REGISTER (base)

#define SVM1_ADDR_POSTDEC_B 0x1a
#define DECODE_SVM1_ADDR_POSTDEC_B(base) \
  DECODE_WORD_REGISTER (base)

#define SVM1_ADDR_POSTDEC_W 0x1b
#define DECODE_SVM1_ADDR_POSTDEC_W(base) \
  DECODE_WORD_REGISTER (base)

#define SVM1_ADDR_POSTDEC_F 0x1c
#define DECODE_SVM1_ADDR_POSTDEC_F(base) \
  DECODE_WORD_REGISTER (base)

#define SVM1_ADDR_POSTINC_B 0x1d
#define DECODE_SVM1_ADDR_POSTINC_B(base) \
  DECODE_WORD_REGISTER (base)

#define SVM1_ADDR_POSTINC_W 0x1e
#define DECODE_SVM1_ADDR_POSTINC_W(base) \
  DECODE_WORD_REGISTER (base)

#define SVM1_ADDR_POSTINC_F 0x1f
#define DECODE_SVM1_ADDR_POSTINC_F(base) \
  DECODE_WORD_REGISTER (base)

#define SVM1_ADDR_PCR_S8 0x20
#define DECODE_SVM1_ADDR_PCR_S8(value) \
  DECODE_SIGNED_8 (value)

#define SVM1_ADDR_PCR_S16 0x21
#define DECODE_SVM1_ADDR_PCR_S16(value) \
  DECODE_SIGNED_16 (value)

#define SVM1_ADDR_PCR_S32 0x22
#define DECODE_SVM1_ADDR_PCR_S32(value) \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_START_CODE 0x01
#define SVM1_INST_END_CODE 0xcd

#define SVM1_INST_BINDINGS(binder) \
  binder (SVM1_INST_STORE_B_WR_ADDR, store_b_wr_addr); \
  binder (SVM1_INST_STORE_W_WR_ADDR, store_w_wr_addr); \
  binder (SVM1_INST_STORE_F_FR_ADDR, store_f_fr_addr); \
  binder (SVM1_INST_LOAD_B_WR_ADDR, load_b_wr_addr); \
  binder (SVM1_INST_LOAD_W_WR_ADDR, load_w_wr_addr); \
  binder (SVM1_INST_LOAD_F_FR_ADDR, load_f_fr_addr); \
  binder (SVM1_INST_LOAD_ADDRESS_ADDR, load_address_addr); \
  binder (SVM1_INST_LOAD_IMMEDIATE_WR_S8, load_immediate_wr_s8); \
  binder (SVM1_INST_LOAD_IMMEDIATE_WR_S16, load_immediate_wr_s16); \
  binder (SVM1_INST_LOAD_IMMEDIATE_WR_S32, load_immediate_wr_s32); \
  binder (SVM1_INST_LOAD_IMMEDIATE_FR_FLT, load_immediate_fr_flt); \
  binder (SVM1_INST_COPY_BLOCK_U8_W, copy_block_u8_w); \
  binder (SVM1_INST_COPY_BLOCK_WR_W, copy_block_wr_w); \
  binder (SVM1_INST_LOAD_NON_POINTER_TC_S8, load_non_pointer_tc_s8); \
  binder (SVM1_INST_LOAD_NON_POINTER_WR_S8, load_non_pointer_wr_s8); \
  binder (SVM1_INST_LOAD_NON_POINTER_TC_S16, load_non_pointer_tc_s16); \
  binder (SVM1_INST_LOAD_NON_POINTER_WR_S16, load_non_pointer_wr_s16); \
  binder (SVM1_INST_LOAD_NON_POINTER_TC_S32, load_non_pointer_tc_s32); \
  binder (SVM1_INST_LOAD_NON_POINTER_WR_S32, load_non_pointer_wr_s32); \
  binder (SVM1_INST_LOAD_NON_POINTER_TC_WR, load_non_pointer_tc_wr); \
  binder (SVM1_INST_LOAD_NON_POINTER, load_non_pointer); \
  binder (SVM1_INST_LOAD_POINTER_TC_WR, load_pointer_tc_wr); \
  binder (SVM1_INST_LOAD_POINTER, load_pointer); \
  binder (SVM1_INST_JUMP_PCR_S8, jump_pcr_s8); \
  binder (SVM1_INST_JUMP_PCR_S16, jump_pcr_s16); \
  binder (SVM1_INST_JUMP_PCR_S32, jump_pcr_s32); \
  binder (SVM1_INST_JUMP_INDIR_WR, jump_indir_wr); \
  binder (SVM1_INST_IJUMP_U8, ijump_u8); \
  binder (SVM1_INST_IJUMP_U16, ijump_u16); \
  binder (SVM1_INST_IJUMP_U32, ijump_u32); \
  binder (SVM1_INST_ICALL_U8, icall_u8); \
  binder (SVM1_INST_ICALL_U16, icall_u16); \
  binder (SVM1_INST_ICALL_U32, icall_u32); \
  binder (SVM1_INST_ENTER_CLOSURE, enter_closure); \
  binder (SVM1_INST_CJUMP_EQ_WR_WR_PCR_S8, cjump_eq_wr_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_NEQ_WR_WR_PCR_S8, cjump_neq_wr_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_LT_WR_WR_PCR_S8, cjump_lt_wr_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_GE_WR_WR_PCR_S8, cjump_ge_wr_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_GT_WR_WR_PCR_S8, cjump_gt_wr_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_LE_WR_WR_PCR_S8, cjump_le_wr_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_SLT_WR_WR_PCR_S8, cjump_slt_wr_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_SGE_WR_WR_PCR_S8, cjump_sge_wr_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_SGT_WR_WR_PCR_S8, cjump_sgt_wr_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_SLE_WR_WR_PCR_S8, cjump_sle_wr_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_EQ_WR_WR_PCR_S16, cjump_eq_wr_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_NEQ_WR_WR_PCR_S16, cjump_neq_wr_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_LT_WR_WR_PCR_S16, cjump_lt_wr_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_GE_WR_WR_PCR_S16, cjump_ge_wr_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_GT_WR_WR_PCR_S16, cjump_gt_wr_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_LE_WR_WR_PCR_S16, cjump_le_wr_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_SLT_WR_WR_PCR_S16, cjump_slt_wr_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_SGE_WR_WR_PCR_S16, cjump_sge_wr_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_SGT_WR_WR_PCR_S16, cjump_sgt_wr_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_SLE_WR_WR_PCR_S16, cjump_sle_wr_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_EQ_WR_WR_PCR_S32, cjump_eq_wr_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_NEQ_WR_WR_PCR_S32, cjump_neq_wr_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_LT_WR_WR_PCR_S32, cjump_lt_wr_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_GE_WR_WR_PCR_S32, cjump_ge_wr_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_GT_WR_WR_PCR_S32, cjump_gt_wr_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_LE_WR_WR_PCR_S32, cjump_le_wr_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_SLT_WR_WR_PCR_S32, cjump_slt_wr_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_SGE_WR_WR_PCR_S32, cjump_sge_wr_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_SGT_WR_WR_PCR_S32, cjump_sgt_wr_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_SLE_WR_WR_PCR_S32, cjump_sle_wr_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_EQ_WR_PCR_S8, cjump_eq_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_NEQ_WR_PCR_S8, cjump_neq_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_SLT_WR_PCR_S8, cjump_slt_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_SGE_WR_PCR_S8, cjump_sge_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_SGT_WR_PCR_S8, cjump_sgt_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_SLE_WR_PCR_S8, cjump_sle_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_EQ_WR_PCR_S16, cjump_eq_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_NEQ_WR_PCR_S16, cjump_neq_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_SLT_WR_PCR_S16, cjump_slt_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_SGE_WR_PCR_S16, cjump_sge_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_SGT_WR_PCR_S16, cjump_sgt_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_SLE_WR_PCR_S16, cjump_sle_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_EQ_WR_PCR_S32, cjump_eq_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_NEQ_WR_PCR_S32, cjump_neq_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_SLT_WR_PCR_S32, cjump_slt_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_SGE_WR_PCR_S32, cjump_sge_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_SGT_WR_PCR_S32, cjump_sgt_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_SLE_WR_PCR_S32, cjump_sle_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_FIX_WR_PCR_S8, cjump_fix_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_NFIX_WR_PCR_S8, cjump_nfix_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_IFIX_WR_PCR_S8, cjump_ifix_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_NIFIX_WR_PCR_S8, cjump_nifix_wr_pcr_s8); \
  binder (SVM1_INST_CJUMP_FIX_WR_PCR_S16, cjump_fix_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_NFIX_WR_PCR_S16, cjump_nfix_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_IFIX_WR_PCR_S16, cjump_ifix_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_NIFIX_WR_PCR_S16, cjump_nifix_wr_pcr_s16); \
  binder (SVM1_INST_CJUMP_FIX_WR_PCR_S32, cjump_fix_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_NFIX_WR_PCR_S32, cjump_nfix_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_IFIX_WR_PCR_S32, cjump_ifix_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_NIFIX_WR_PCR_S32, cjump_nifix_wr_pcr_s32); \
  binder (SVM1_INST_CJUMP_EQ_FR_FR_PCR_S8, cjump_eq_fr_fr_pcr_s8); \
  binder (SVM1_INST_CJUMP_NEQ_FR_FR_PCR_S8, cjump_neq_fr_fr_pcr_s8); \
  binder (SVM1_INST_CJUMP_LT_FR_FR_PCR_S8, cjump_lt_fr_fr_pcr_s8); \
  binder (SVM1_INST_CJUMP_GT_FR_FR_PCR_S8, cjump_gt_fr_fr_pcr_s8); \
  binder (SVM1_INST_CJUMP_LE_FR_FR_PCR_S8, cjump_le_fr_fr_pcr_s8); \
  binder (SVM1_INST_CJUMP_GE_FR_FR_PCR_S8, cjump_ge_fr_fr_pcr_s8); \
  binder (SVM1_INST_CJUMP_CMP_FR_FR_PCR_S8, cjump_cmp_fr_fr_pcr_s8); \
  binder (SVM1_INST_CJUMP_NCMP_FR_FR_PCR_S8, cjump_ncmp_fr_fr_pcr_s8); \
  binder (SVM1_INST_CJUMP_EQ_FR_FR_PCR_S16, cjump_eq_fr_fr_pcr_s16); \
  binder (SVM1_INST_CJUMP_NEQ_FR_FR_PCR_S16, cjump_neq_fr_fr_pcr_s16); \
  binder (SVM1_INST_CJUMP_LT_FR_FR_PCR_S16, cjump_lt_fr_fr_pcr_s16); \
  binder (SVM1_INST_CJUMP_GT_FR_FR_PCR_S16, cjump_gt_fr_fr_pcr_s16); \
  binder (SVM1_INST_CJUMP_LE_FR_FR_PCR_S16, cjump_le_fr_fr_pcr_s16); \
  binder (SVM1_INST_CJUMP_GE_FR_FR_PCR_S16, cjump_ge_fr_fr_pcr_s16); \
  binder (SVM1_INST_CJUMP_CMP_FR_FR_PCR_S16, cjump_cmp_fr_fr_pcr_s16); \
  binder (SVM1_INST_CJUMP_NCMP_FR_FR_PCR_S16, cjump_ncmp_fr_fr_pcr_s16); \
  binder (SVM1_INST_CJUMP_EQ_FR_FR_PCR_S32, cjump_eq_fr_fr_pcr_s32); \
  binder (SVM1_INST_CJUMP_NEQ_FR_FR_PCR_S32, cjump_neq_fr_fr_pcr_s32); \
  binder (SVM1_INST_CJUMP_LT_FR_FR_PCR_S32, cjump_lt_fr_fr_pcr_s32); \
  binder (SVM1_INST_CJUMP_GT_FR_FR_PCR_S32, cjump_gt_fr_fr_pcr_s32); \
  binder (SVM1_INST_CJUMP_LE_FR_FR_PCR_S32, cjump_le_fr_fr_pcr_s32); \
  binder (SVM1_INST_CJUMP_GE_FR_FR_PCR_S32, cjump_ge_fr_fr_pcr_s32); \
  binder (SVM1_INST_CJUMP_CMP_FR_FR_PCR_S32, cjump_cmp_fr_fr_pcr_s32); \
  binder (SVM1_INST_CJUMP_NCMP_FR_FR_PCR_S32, cjump_ncmp_fr_fr_pcr_s32); \
  binder (SVM1_INST_CJUMP_EQ_FR_PCR_S8, cjump_eq_fr_pcr_s8); \
  binder (SVM1_INST_CJUMP_NEQ_FR_PCR_S8, cjump_neq_fr_pcr_s8); \
  binder (SVM1_INST_CJUMP_LT_FR_PCR_S8, cjump_lt_fr_pcr_s8); \
  binder (SVM1_INST_CJUMP_GT_FR_PCR_S8, cjump_gt_fr_pcr_s8); \
  binder (SVM1_INST_CJUMP_LE_FR_PCR_S8, cjump_le_fr_pcr_s8); \
  binder (SVM1_INST_CJUMP_GE_FR_PCR_S8, cjump_ge_fr_pcr_s8); \
  binder (SVM1_INST_CJUMP_CMP_FR_PCR_S8, cjump_cmp_fr_pcr_s8); \
  binder (SVM1_INST_CJUMP_NCMP_FR_PCR_S8, cjump_ncmp_fr_pcr_s8); \
  binder (SVM1_INST_CJUMP_EQ_FR_PCR_S16, cjump_eq_fr_pcr_s16); \
  binder (SVM1_INST_CJUMP_NEQ_FR_PCR_S16, cjump_neq_fr_pcr_s16); \
  binder (SVM1_INST_CJUMP_LT_FR_PCR_S16, cjump_lt_fr_pcr_s16); \
  binder (SVM1_INST_CJUMP_GT_FR_PCR_S16, cjump_gt_fr_pcr_s16); \
  binder (SVM1_INST_CJUMP_LE_FR_PCR_S16, cjump_le_fr_pcr_s16); \
  binder (SVM1_INST_CJUMP_GE_FR_PCR_S16, cjump_ge_fr_pcr_s16); \
  binder (SVM1_INST_CJUMP_CMP_FR_PCR_S16, cjump_cmp_fr_pcr_s16); \
  binder (SVM1_INST_CJUMP_NCMP_FR_PCR_S16, cjump_ncmp_fr_pcr_s16); \
  binder (SVM1_INST_CJUMP_EQ_FR_PCR_S32, cjump_eq_fr_pcr_s32); \
  binder (SVM1_INST_CJUMP_NEQ_FR_PCR_S32, cjump_neq_fr_pcr_s32); \
  binder (SVM1_INST_CJUMP_LT_FR_PCR_S32, cjump_lt_fr_pcr_s32); \
  binder (SVM1_INST_CJUMP_GT_FR_PCR_S32, cjump_gt_fr_pcr_s32); \
  binder (SVM1_INST_CJUMP_LE_FR_PCR_S32, cjump_le_fr_pcr_s32); \
  binder (SVM1_INST_CJUMP_GE_FR_PCR_S32, cjump_ge_fr_pcr_s32); \
  binder (SVM1_INST_CJUMP_CMP_FR_PCR_S32, cjump_cmp_fr_pcr_s32); \
  binder (SVM1_INST_CJUMP_NCMP_FR_PCR_S32, cjump_ncmp_fr_pcr_s32); \
  binder (SVM1_INST_TRAP_TRAP_0, trap_trap_0); \
  binder (SVM1_INST_TRAP_TRAP_1_WR, trap_trap_1_wr); \
  binder (SVM1_INST_TRAP_TRAP_2_WR, trap_trap_2_wr); \
  binder (SVM1_INST_TRAP_TRAP_3_WR, trap_trap_3_wr); \
  binder (SVM1_INST_INTERRUPT_TEST_PROCEDURE, interrupt_test_procedure); \
  binder (SVM1_INST_INTERRUPT_TEST_DYNAMIC_LINK, interrupt_test_dynamic_link); \
  binder (SVM1_INST_INTERRUPT_TEST_IC_PROCEDURE, interrupt_test_ic_procedure); \
  binder (SVM1_INST_INTERRUPT_TEST_CONTINUATION, interrupt_test_continuation); \
  binder (SVM1_INST_POP_RETURN, pop_return); \
  binder (SVM1_INST_FLONUM_HEADER_U8, flonum_header_u8); \
  binder (SVM1_INST_FLONUM_HEADER_U16, flonum_header_u16); \
  binder (SVM1_INST_FLONUM_HEADER_U32, flonum_header_u32); \
  binder (SVM1_INST_FLONUM_HEADER, flonum_header); \
  binder (SVM1_INST_COPY_WR, copy_wr); \
  binder (SVM1_INST_COPY_FR, copy_fr); \
  binder (SVM1_INST_NEGATE_WR, negate_wr); \
  binder (SVM1_INST_NEGATE_FR, negate_fr); \
  binder (SVM1_INST_INCREMENT_WR, increment_wr); \
  binder (SVM1_INST_INCREMENT_FR, increment_fr); \
  binder (SVM1_INST_DECREMENT_WR, decrement_wr); \
  binder (SVM1_INST_DECREMENT_FR, decrement_fr); \
  binder (SVM1_INST_ABS_WR, abs_wr); \
  binder (SVM1_INST_ABS_FR, abs_fr); \
  binder (SVM1_INST_OBJECT_TYPE, object_type); \
  binder (SVM1_INST_OBJECT_DATUM, object_datum); \
  binder (SVM1_INST_OBJECT_ADDRESS, object_address); \
  binder (SVM1_INST_FIXNUM_TO_INTEGER, fixnum_to_integer); \
  binder (SVM1_INST_INTEGER_TO_FIXNUM, integer_to_fixnum); \
  binder (SVM1_INST_NOT, not); \
  binder (SVM1_INST_FLONUM_ALIGN, flonum_align); \
  binder (SVM1_INST_FLONUM_LENGTH, flonum_length); \
  binder (SVM1_INST_SQRT, sqrt); \
  binder (SVM1_INST_ROUND, round); \
  binder (SVM1_INST_CEILING, ceiling); \
  binder (SVM1_INST_FLOOR, floor); \
  binder (SVM1_INST_TRUNCATE, truncate); \
  binder (SVM1_INST_LOG, log); \
  binder (SVM1_INST_EXP, exp); \
  binder (SVM1_INST_COS, cos); \
  binder (SVM1_INST_SIN, sin); \
  binder (SVM1_INST_TAN, tan); \
  binder (SVM1_INST_ACOS, acos); \
  binder (SVM1_INST_ASIN, asin); \
  binder (SVM1_INST_ATAN, atan); \
  binder (SVM1_INST_ADD_WR, add_wr); \
  binder (SVM1_INST_ADD_FR, add_fr); \
  binder (SVM1_INST_SUBTRACT_WR, subtract_wr); \
  binder (SVM1_INST_SUBTRACT_FR, subtract_fr); \
  binder (SVM1_INST_MULTIPLY_WR, multiply_wr); \
  binder (SVM1_INST_MULTIPLY_FR, multiply_fr); \
  binder (SVM1_INST_PRODUCT, product); \
  binder (SVM1_INST_QUOTIENT, quotient); \
  binder (SVM1_INST_REMAINDER, remainder); \
  binder (SVM1_INST_LSH, lsh); \
  binder (SVM1_INST_AND, and); \
  binder (SVM1_INST_ANDC, andc); \
  binder (SVM1_INST_OR, or); \
  binder (SVM1_INST_XOR, xor); \
  binder (SVM1_INST_MAX_UNSIGNED, max_unsigned); \
  binder (SVM1_INST_MIN_UNSIGNED, min_unsigned); \
  binder (SVM1_INST_DIVIDE, divide); \
  binder (SVM1_INST_ATAN2, atan2)

#define SVM1_INST_STORE_B_WR_ADDR 0x01
#define DECODE_SVM1_INST_STORE_B_WR_ADDR(source, target) \
  DECODE_WORD_REGISTER (source); \
  DECODE_ADDRESS (target)

#define SVM1_INST_STORE_W_WR_ADDR 0x02
#define DECODE_SVM1_INST_STORE_W_WR_ADDR(source, target) \
  DECODE_WORD_REGISTER (source); \
  DECODE_ADDRESS (target)

#define SVM1_INST_STORE_F_FR_ADDR 0x03
#define DECODE_SVM1_INST_STORE_F_FR_ADDR(source, target) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_ADDRESS (target)

#define SVM1_INST_LOAD_B_WR_ADDR 0x04
#define DECODE_SVM1_INST_LOAD_B_WR_ADDR(target, source) \
  DECODE_WORD_REGISTER (target); \
  DECODE_ADDRESS (source)

#define SVM1_INST_LOAD_W_WR_ADDR 0x05
#define DECODE_SVM1_INST_LOAD_W_WR_ADDR(target, source) \
  DECODE_WORD_REGISTER (target); \
  DECODE_ADDRESS (source)

#define SVM1_INST_LOAD_F_FR_ADDR 0x06
#define DECODE_SVM1_INST_LOAD_F_FR_ADDR(target, source) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_ADDRESS (source)

#define SVM1_INST_LOAD_ADDRESS_ADDR 0x07
#define DECODE_SVM1_INST_LOAD_ADDRESS_ADDR(target, source) \
  DECODE_WORD_REGISTER (target); \
  DECODE_ADDRESS (source)

#define SVM1_INST_LOAD_IMMEDIATE_WR_S8 0x08
#define DECODE_SVM1_INST_LOAD_IMMEDIATE_WR_S8(target, value_1) \
  DECODE_WORD_REGISTER (target); \
  DECODE_SIGNED_8 (value_1)

#define SVM1_INST_LOAD_IMMEDIATE_WR_S16 0x09
#define DECODE_SVM1_INST_LOAD_IMMEDIATE_WR_S16(target, value_1) \
  DECODE_WORD_REGISTER (target); \
  DECODE_SIGNED_16 (value_1)

#define SVM1_INST_LOAD_IMMEDIATE_WR_S32 0x0a
#define DECODE_SVM1_INST_LOAD_IMMEDIATE_WR_S32(target, value_1) \
  DECODE_WORD_REGISTER (target); \
  DECODE_SIGNED_32 (value_1)

#define SVM1_INST_LOAD_IMMEDIATE_FR_FLT 0x0b
#define DECODE_SVM1_INST_LOAD_IMMEDIATE_FR_FLT(target, value) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT (value)

#define SVM1_INST_COPY_BLOCK_U8_W 0x0c
#define DECODE_SVM1_INST_COPY_BLOCK_U8_W(to, from, size) \
  DECODE_WORD_REGISTER (to); \
  DECODE_WORD_REGISTER (from); \
  DECODE_UNSIGNED_8 (size)

#define SVM1_INST_COPY_BLOCK_WR_W 0x0d
#define DECODE_SVM1_INST_COPY_BLOCK_WR_W(to, from, size) \
  DECODE_WORD_REGISTER (to); \
  DECODE_WORD_REGISTER (from); \
  DECODE_WORD_REGISTER (size)

#define SVM1_INST_LOAD_NON_POINTER_TC_S8 0x0e
#define DECODE_SVM1_INST_LOAD_NON_POINTER_TC_S8(target, type_1, value) \
  DECODE_WORD_REGISTER (target); \
  DECODE_TYPE_WORD (type_1); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_LOAD_NON_POINTER_WR_S8 0x0f
#define DECODE_SVM1_INST_LOAD_NON_POINTER_WR_S8(target, source, value) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_LOAD_NON_POINTER_TC_S16 0x10
#define DECODE_SVM1_INST_LOAD_NON_POINTER_TC_S16(target, type_1, value) \
  DECODE_WORD_REGISTER (target); \
  DECODE_TYPE_WORD (type_1); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_LOAD_NON_POINTER_WR_S16 0x11
#define DECODE_SVM1_INST_LOAD_NON_POINTER_WR_S16(target, source, value) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_LOAD_NON_POINTER_TC_S32 0x12
#define DECODE_SVM1_INST_LOAD_NON_POINTER_TC_S32(target, type_1, value) \
  DECODE_WORD_REGISTER (target); \
  DECODE_TYPE_WORD (type_1); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_LOAD_NON_POINTER_WR_S32 0x13
#define DECODE_SVM1_INST_LOAD_NON_POINTER_WR_S32(target, source, value) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_LOAD_NON_POINTER_TC_WR 0x14
#define DECODE_SVM1_INST_LOAD_NON_POINTER_TC_WR(target, type_1, datum) \
  DECODE_WORD_REGISTER (target); \
  DECODE_TYPE_WORD (type_1); \
  DECODE_WORD_REGISTER (datum)

#define SVM1_INST_LOAD_NON_POINTER 0x15
#define DECODE_SVM1_INST_LOAD_NON_POINTER(target, source, datum) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source); \
  DECODE_WORD_REGISTER (datum)

#define SVM1_INST_LOAD_POINTER_TC_WR 0x16
#define DECODE_SVM1_INST_LOAD_POINTER_TC_WR(target, type_1, address) \
  DECODE_WORD_REGISTER (target); \
  DECODE_TYPE_WORD (type_1); \
  DECODE_WORD_REGISTER (address)

#define SVM1_INST_LOAD_POINTER 0x17
#define DECODE_SVM1_INST_LOAD_POINTER(target, source, address) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source); \
  DECODE_WORD_REGISTER (address)

#define SVM1_INST_JUMP_PCR_S8 0x18
#define DECODE_SVM1_INST_JUMP_PCR_S8(value) \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_JUMP_PCR_S16 0x19
#define DECODE_SVM1_INST_JUMP_PCR_S16(value) \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_JUMP_PCR_S32 0x1a
#define DECODE_SVM1_INST_JUMP_PCR_S32(value) \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_JUMP_INDIR_WR 0x1b
#define DECODE_SVM1_INST_JUMP_INDIR_WR(address) \
  DECODE_WORD_REGISTER (address)

#define SVM1_INST_IJUMP_U8 0x1c
#define DECODE_SVM1_INST_IJUMP_U8(value) \
  DECODE_UNSIGNED_8 (value)

#define SVM1_INST_IJUMP_U16 0x1d
#define DECODE_SVM1_INST_IJUMP_U16(value) \
  DECODE_UNSIGNED_16 (value)

#define SVM1_INST_IJUMP_U32 0x1e
#define DECODE_SVM1_INST_IJUMP_U32(value) \
  DECODE_UNSIGNED_32 (value)

#define SVM1_INST_ICALL_U8 0x1f
#define DECODE_SVM1_INST_ICALL_U8(value) \
  DECODE_UNSIGNED_8 (value)

#define SVM1_INST_ICALL_U16 0x20
#define DECODE_SVM1_INST_ICALL_U16(value) \
  DECODE_UNSIGNED_16 (value)

#define SVM1_INST_ICALL_U32 0x21
#define DECODE_SVM1_INST_ICALL_U32(value) \
  DECODE_UNSIGNED_32 (value)

#define SVM1_INST_ENTER_CLOSURE 0x22
#define DECODE_SVM1_INST_ENTER_CLOSURE(index) \
  DECODE_UNSIGNED_16 (index)

#define SVM1_INST_CJUMP_EQ_WR_WR_PCR_S8 0x23
#define DECODE_SVM1_INST_CJUMP_EQ_WR_WR_PCR_S8(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_NEQ_WR_WR_PCR_S8 0x24
#define DECODE_SVM1_INST_CJUMP_NEQ_WR_WR_PCR_S8(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_LT_WR_WR_PCR_S8 0x25
#define DECODE_SVM1_INST_CJUMP_LT_WR_WR_PCR_S8(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_GE_WR_WR_PCR_S8 0x26
#define DECODE_SVM1_INST_CJUMP_GE_WR_WR_PCR_S8(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_GT_WR_WR_PCR_S8 0x27
#define DECODE_SVM1_INST_CJUMP_GT_WR_WR_PCR_S8(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_LE_WR_WR_PCR_S8 0x28
#define DECODE_SVM1_INST_CJUMP_LE_WR_WR_PCR_S8(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_SLT_WR_WR_PCR_S8 0x29
#define DECODE_SVM1_INST_CJUMP_SLT_WR_WR_PCR_S8(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_SGE_WR_WR_PCR_S8 0x2a
#define DECODE_SVM1_INST_CJUMP_SGE_WR_WR_PCR_S8(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_SGT_WR_WR_PCR_S8 0x2b
#define DECODE_SVM1_INST_CJUMP_SGT_WR_WR_PCR_S8(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_SLE_WR_WR_PCR_S8 0x2c
#define DECODE_SVM1_INST_CJUMP_SLE_WR_WR_PCR_S8(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_EQ_WR_WR_PCR_S16 0x2d
#define DECODE_SVM1_INST_CJUMP_EQ_WR_WR_PCR_S16(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_NEQ_WR_WR_PCR_S16 0x2e
#define DECODE_SVM1_INST_CJUMP_NEQ_WR_WR_PCR_S16(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_LT_WR_WR_PCR_S16 0x2f
#define DECODE_SVM1_INST_CJUMP_LT_WR_WR_PCR_S16(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_GE_WR_WR_PCR_S16 0x30
#define DECODE_SVM1_INST_CJUMP_GE_WR_WR_PCR_S16(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_GT_WR_WR_PCR_S16 0x31
#define DECODE_SVM1_INST_CJUMP_GT_WR_WR_PCR_S16(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_LE_WR_WR_PCR_S16 0x32
#define DECODE_SVM1_INST_CJUMP_LE_WR_WR_PCR_S16(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_SLT_WR_WR_PCR_S16 0x33
#define DECODE_SVM1_INST_CJUMP_SLT_WR_WR_PCR_S16(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_SGE_WR_WR_PCR_S16 0x34
#define DECODE_SVM1_INST_CJUMP_SGE_WR_WR_PCR_S16(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_SGT_WR_WR_PCR_S16 0x35
#define DECODE_SVM1_INST_CJUMP_SGT_WR_WR_PCR_S16(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_SLE_WR_WR_PCR_S16 0x36
#define DECODE_SVM1_INST_CJUMP_SLE_WR_WR_PCR_S16(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_EQ_WR_WR_PCR_S32 0x37
#define DECODE_SVM1_INST_CJUMP_EQ_WR_WR_PCR_S32(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_NEQ_WR_WR_PCR_S32 0x38
#define DECODE_SVM1_INST_CJUMP_NEQ_WR_WR_PCR_S32(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_LT_WR_WR_PCR_S32 0x39
#define DECODE_SVM1_INST_CJUMP_LT_WR_WR_PCR_S32(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_GE_WR_WR_PCR_S32 0x3a
#define DECODE_SVM1_INST_CJUMP_GE_WR_WR_PCR_S32(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_GT_WR_WR_PCR_S32 0x3b
#define DECODE_SVM1_INST_CJUMP_GT_WR_WR_PCR_S32(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_LE_WR_WR_PCR_S32 0x3c
#define DECODE_SVM1_INST_CJUMP_LE_WR_WR_PCR_S32(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_SLT_WR_WR_PCR_S32 0x3d
#define DECODE_SVM1_INST_CJUMP_SLT_WR_WR_PCR_S32(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_SGE_WR_WR_PCR_S32 0x3e
#define DECODE_SVM1_INST_CJUMP_SGE_WR_WR_PCR_S32(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_SGT_WR_WR_PCR_S32 0x3f
#define DECODE_SVM1_INST_CJUMP_SGT_WR_WR_PCR_S32(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_SLE_WR_WR_PCR_S32 0x40
#define DECODE_SVM1_INST_CJUMP_SLE_WR_WR_PCR_S32(source1, source2, value) \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_EQ_WR_PCR_S8 0x41
#define DECODE_SVM1_INST_CJUMP_EQ_WR_PCR_S8(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_NEQ_WR_PCR_S8 0x42
#define DECODE_SVM1_INST_CJUMP_NEQ_WR_PCR_S8(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_SLT_WR_PCR_S8 0x43
#define DECODE_SVM1_INST_CJUMP_SLT_WR_PCR_S8(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_SGE_WR_PCR_S8 0x44
#define DECODE_SVM1_INST_CJUMP_SGE_WR_PCR_S8(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_SGT_WR_PCR_S8 0x45
#define DECODE_SVM1_INST_CJUMP_SGT_WR_PCR_S8(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_SLE_WR_PCR_S8 0x46
#define DECODE_SVM1_INST_CJUMP_SLE_WR_PCR_S8(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_EQ_WR_PCR_S16 0x47
#define DECODE_SVM1_INST_CJUMP_EQ_WR_PCR_S16(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_NEQ_WR_PCR_S16 0x48
#define DECODE_SVM1_INST_CJUMP_NEQ_WR_PCR_S16(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_SLT_WR_PCR_S16 0x49
#define DECODE_SVM1_INST_CJUMP_SLT_WR_PCR_S16(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_SGE_WR_PCR_S16 0x4a
#define DECODE_SVM1_INST_CJUMP_SGE_WR_PCR_S16(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_SGT_WR_PCR_S16 0x4b
#define DECODE_SVM1_INST_CJUMP_SGT_WR_PCR_S16(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_SLE_WR_PCR_S16 0x4c
#define DECODE_SVM1_INST_CJUMP_SLE_WR_PCR_S16(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_EQ_WR_PCR_S32 0x4d
#define DECODE_SVM1_INST_CJUMP_EQ_WR_PCR_S32(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_NEQ_WR_PCR_S32 0x4e
#define DECODE_SVM1_INST_CJUMP_NEQ_WR_PCR_S32(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_SLT_WR_PCR_S32 0x4f
#define DECODE_SVM1_INST_CJUMP_SLT_WR_PCR_S32(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_SGE_WR_PCR_S32 0x50
#define DECODE_SVM1_INST_CJUMP_SGE_WR_PCR_S32(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_SGT_WR_PCR_S32 0x51
#define DECODE_SVM1_INST_CJUMP_SGT_WR_PCR_S32(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_SLE_WR_PCR_S32 0x52
#define DECODE_SVM1_INST_CJUMP_SLE_WR_PCR_S32(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_FIX_WR_PCR_S8 0x53
#define DECODE_SVM1_INST_CJUMP_FIX_WR_PCR_S8(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_NFIX_WR_PCR_S8 0x54
#define DECODE_SVM1_INST_CJUMP_NFIX_WR_PCR_S8(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_IFIX_WR_PCR_S8 0x55
#define DECODE_SVM1_INST_CJUMP_IFIX_WR_PCR_S8(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_NIFIX_WR_PCR_S8 0x56
#define DECODE_SVM1_INST_CJUMP_NIFIX_WR_PCR_S8(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_FIX_WR_PCR_S16 0x57
#define DECODE_SVM1_INST_CJUMP_FIX_WR_PCR_S16(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_NFIX_WR_PCR_S16 0x58
#define DECODE_SVM1_INST_CJUMP_NFIX_WR_PCR_S16(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_IFIX_WR_PCR_S16 0x59
#define DECODE_SVM1_INST_CJUMP_IFIX_WR_PCR_S16(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_NIFIX_WR_PCR_S16 0x5a
#define DECODE_SVM1_INST_CJUMP_NIFIX_WR_PCR_S16(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_FIX_WR_PCR_S32 0x5b
#define DECODE_SVM1_INST_CJUMP_FIX_WR_PCR_S32(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_NFIX_WR_PCR_S32 0x5c
#define DECODE_SVM1_INST_CJUMP_NFIX_WR_PCR_S32(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_IFIX_WR_PCR_S32 0x5d
#define DECODE_SVM1_INST_CJUMP_IFIX_WR_PCR_S32(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_NIFIX_WR_PCR_S32 0x5e
#define DECODE_SVM1_INST_CJUMP_NIFIX_WR_PCR_S32(source, value) \
  DECODE_WORD_REGISTER (source); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_EQ_FR_FR_PCR_S8 0x5f
#define DECODE_SVM1_INST_CJUMP_EQ_FR_FR_PCR_S8(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_NEQ_FR_FR_PCR_S8 0x60
#define DECODE_SVM1_INST_CJUMP_NEQ_FR_FR_PCR_S8(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_LT_FR_FR_PCR_S8 0x61
#define DECODE_SVM1_INST_CJUMP_LT_FR_FR_PCR_S8(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_GT_FR_FR_PCR_S8 0x62
#define DECODE_SVM1_INST_CJUMP_GT_FR_FR_PCR_S8(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_LE_FR_FR_PCR_S8 0x63
#define DECODE_SVM1_INST_CJUMP_LE_FR_FR_PCR_S8(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_GE_FR_FR_PCR_S8 0x64
#define DECODE_SVM1_INST_CJUMP_GE_FR_FR_PCR_S8(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_CMP_FR_FR_PCR_S8 0x65
#define DECODE_SVM1_INST_CJUMP_CMP_FR_FR_PCR_S8(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_NCMP_FR_FR_PCR_S8 0x66
#define DECODE_SVM1_INST_CJUMP_NCMP_FR_FR_PCR_S8(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_EQ_FR_FR_PCR_S16 0x67
#define DECODE_SVM1_INST_CJUMP_EQ_FR_FR_PCR_S16(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_NEQ_FR_FR_PCR_S16 0x68
#define DECODE_SVM1_INST_CJUMP_NEQ_FR_FR_PCR_S16(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_LT_FR_FR_PCR_S16 0x69
#define DECODE_SVM1_INST_CJUMP_LT_FR_FR_PCR_S16(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_GT_FR_FR_PCR_S16 0x6a
#define DECODE_SVM1_INST_CJUMP_GT_FR_FR_PCR_S16(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_LE_FR_FR_PCR_S16 0x6b
#define DECODE_SVM1_INST_CJUMP_LE_FR_FR_PCR_S16(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_GE_FR_FR_PCR_S16 0x6c
#define DECODE_SVM1_INST_CJUMP_GE_FR_FR_PCR_S16(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_CMP_FR_FR_PCR_S16 0x6d
#define DECODE_SVM1_INST_CJUMP_CMP_FR_FR_PCR_S16(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_NCMP_FR_FR_PCR_S16 0x6e
#define DECODE_SVM1_INST_CJUMP_NCMP_FR_FR_PCR_S16(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_EQ_FR_FR_PCR_S32 0x6f
#define DECODE_SVM1_INST_CJUMP_EQ_FR_FR_PCR_S32(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_NEQ_FR_FR_PCR_S32 0x70
#define DECODE_SVM1_INST_CJUMP_NEQ_FR_FR_PCR_S32(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_LT_FR_FR_PCR_S32 0x71
#define DECODE_SVM1_INST_CJUMP_LT_FR_FR_PCR_S32(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_GT_FR_FR_PCR_S32 0x72
#define DECODE_SVM1_INST_CJUMP_GT_FR_FR_PCR_S32(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_LE_FR_FR_PCR_S32 0x73
#define DECODE_SVM1_INST_CJUMP_LE_FR_FR_PCR_S32(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_GE_FR_FR_PCR_S32 0x74
#define DECODE_SVM1_INST_CJUMP_GE_FR_FR_PCR_S32(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_CMP_FR_FR_PCR_S32 0x75
#define DECODE_SVM1_INST_CJUMP_CMP_FR_FR_PCR_S32(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_NCMP_FR_FR_PCR_S32 0x76
#define DECODE_SVM1_INST_CJUMP_NCMP_FR_FR_PCR_S32(source1, source2, value) \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_EQ_FR_PCR_S8 0x77
#define DECODE_SVM1_INST_CJUMP_EQ_FR_PCR_S8(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_NEQ_FR_PCR_S8 0x78
#define DECODE_SVM1_INST_CJUMP_NEQ_FR_PCR_S8(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_LT_FR_PCR_S8 0x79
#define DECODE_SVM1_INST_CJUMP_LT_FR_PCR_S8(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_GT_FR_PCR_S8 0x7a
#define DECODE_SVM1_INST_CJUMP_GT_FR_PCR_S8(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_LE_FR_PCR_S8 0x7b
#define DECODE_SVM1_INST_CJUMP_LE_FR_PCR_S8(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_GE_FR_PCR_S8 0x7c
#define DECODE_SVM1_INST_CJUMP_GE_FR_PCR_S8(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_CMP_FR_PCR_S8 0x7d
#define DECODE_SVM1_INST_CJUMP_CMP_FR_PCR_S8(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_NCMP_FR_PCR_S8 0x7e
#define DECODE_SVM1_INST_CJUMP_NCMP_FR_PCR_S8(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_8 (value)

#define SVM1_INST_CJUMP_EQ_FR_PCR_S16 0x7f
#define DECODE_SVM1_INST_CJUMP_EQ_FR_PCR_S16(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_NEQ_FR_PCR_S16 0x80
#define DECODE_SVM1_INST_CJUMP_NEQ_FR_PCR_S16(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_LT_FR_PCR_S16 0x81
#define DECODE_SVM1_INST_CJUMP_LT_FR_PCR_S16(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_GT_FR_PCR_S16 0x82
#define DECODE_SVM1_INST_CJUMP_GT_FR_PCR_S16(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_LE_FR_PCR_S16 0x83
#define DECODE_SVM1_INST_CJUMP_LE_FR_PCR_S16(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_GE_FR_PCR_S16 0x84
#define DECODE_SVM1_INST_CJUMP_GE_FR_PCR_S16(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_CMP_FR_PCR_S16 0x85
#define DECODE_SVM1_INST_CJUMP_CMP_FR_PCR_S16(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_NCMP_FR_PCR_S16 0x86
#define DECODE_SVM1_INST_CJUMP_NCMP_FR_PCR_S16(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_16 (value)

#define SVM1_INST_CJUMP_EQ_FR_PCR_S32 0x87
#define DECODE_SVM1_INST_CJUMP_EQ_FR_PCR_S32(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_NEQ_FR_PCR_S32 0x88
#define DECODE_SVM1_INST_CJUMP_NEQ_FR_PCR_S32(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_LT_FR_PCR_S32 0x89
#define DECODE_SVM1_INST_CJUMP_LT_FR_PCR_S32(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_GT_FR_PCR_S32 0x8a
#define DECODE_SVM1_INST_CJUMP_GT_FR_PCR_S32(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_LE_FR_PCR_S32 0x8b
#define DECODE_SVM1_INST_CJUMP_LE_FR_PCR_S32(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_GE_FR_PCR_S32 0x8c
#define DECODE_SVM1_INST_CJUMP_GE_FR_PCR_S32(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_CMP_FR_PCR_S32 0x8d
#define DECODE_SVM1_INST_CJUMP_CMP_FR_PCR_S32(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_CJUMP_NCMP_FR_PCR_S32 0x8e
#define DECODE_SVM1_INST_CJUMP_NCMP_FR_PCR_S32(source, value) \
  DECODE_FLOAT_REGISTER (source); \
  DECODE_SIGNED_32 (value)

#define SVM1_INST_TRAP_TRAP_0 0x8f
#define DECODE_SVM1_INST_TRAP_TRAP_0(code) \
  DECODE_TRAP_0 (code)

#define SVM1_INST_TRAP_TRAP_1_WR 0x90
#define DECODE_SVM1_INST_TRAP_TRAP_1_WR(code, arg0) \
  DECODE_TRAP_1 (code); \
  DECODE_WORD_REGISTER (arg0)

#define SVM1_INST_TRAP_TRAP_2_WR 0x91
#define DECODE_SVM1_INST_TRAP_TRAP_2_WR(code, arg0, arg1) \
  DECODE_TRAP_2 (code); \
  DECODE_WORD_REGISTER (arg0); \
  DECODE_WORD_REGISTER (arg1)

#define SVM1_INST_TRAP_TRAP_3_WR 0x92
#define DECODE_SVM1_INST_TRAP_TRAP_3_WR(code, arg0, arg1, arg2) \
  DECODE_TRAP_3 (code); \
  DECODE_WORD_REGISTER (arg0); \
  DECODE_WORD_REGISTER (arg1); \
  DECODE_WORD_REGISTER (arg2)

#define SVM1_INST_INTERRUPT_TEST_PROCEDURE 0x93

#define SVM1_INST_INTERRUPT_TEST_DYNAMIC_LINK 0x94

#define SVM1_INST_INTERRUPT_TEST_IC_PROCEDURE 0x95

#define SVM1_INST_INTERRUPT_TEST_CONTINUATION 0x96

#define SVM1_INST_POP_RETURN 0x97

#define SVM1_INST_FLONUM_HEADER_U8 0x98
#define DECODE_SVM1_INST_FLONUM_HEADER_U8(target, value) \
  DECODE_WORD_REGISTER (target); \
  DECODE_UNSIGNED_8 (value)

#define SVM1_INST_FLONUM_HEADER_U16 0x99
#define DECODE_SVM1_INST_FLONUM_HEADER_U16(target, value) \
  DECODE_WORD_REGISTER (target); \
  DECODE_UNSIGNED_16 (value)

#define SVM1_INST_FLONUM_HEADER_U32 0x9a
#define DECODE_SVM1_INST_FLONUM_HEADER_U32(target, value) \
  DECODE_WORD_REGISTER (target); \
  DECODE_UNSIGNED_32 (value)

#define SVM1_INST_FLONUM_HEADER 0x9b
#define DECODE_SVM1_INST_FLONUM_HEADER(target, n_elts) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (n_elts)

#define SVM1_INST_COPY_WR 0x9c
#define DECODE_SVM1_INST_COPY_WR(target, source) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source)

#define SVM1_INST_COPY_FR 0x9d
#define DECODE_SVM1_INST_COPY_FR(target, source) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source)

#define SVM1_INST_NEGATE_WR 0x9e
#define DECODE_SVM1_INST_NEGATE_WR(target, source) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source)

#define SVM1_INST_NEGATE_FR 0x9f
#define DECODE_SVM1_INST_NEGATE_FR(target, source) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source)

#define SVM1_INST_INCREMENT_WR 0xa0
#define DECODE_SVM1_INST_INCREMENT_WR(target, source) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source)

#define SVM1_INST_INCREMENT_FR 0xa1
#define DECODE_SVM1_INST_INCREMENT_FR(target, source) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source)

#define SVM1_INST_DECREMENT_WR 0xa2
#define DECODE_SVM1_INST_DECREMENT_WR(target, source) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source)

#define SVM1_INST_DECREMENT_FR 0xa3
#define DECODE_SVM1_INST_DECREMENT_FR(target, source) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source)

#define SVM1_INST_ABS_WR 0xa4
#define DECODE_SVM1_INST_ABS_WR(target, source) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source)

#define SVM1_INST_ABS_FR 0xa5
#define DECODE_SVM1_INST_ABS_FR(target, source) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source)

#define SVM1_INST_OBJECT_TYPE 0xa6
#define DECODE_SVM1_INST_OBJECT_TYPE(target, source) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source)

#define SVM1_INST_OBJECT_DATUM 0xa7
#define DECODE_SVM1_INST_OBJECT_DATUM(target, source) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source)

#define SVM1_INST_OBJECT_ADDRESS 0xa8
#define DECODE_SVM1_INST_OBJECT_ADDRESS(target, source) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source)

#define SVM1_INST_FIXNUM_TO_INTEGER 0xa9
#define DECODE_SVM1_INST_FIXNUM_TO_INTEGER(target, source) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source)

#define SVM1_INST_INTEGER_TO_FIXNUM 0xaa
#define DECODE_SVM1_INST_INTEGER_TO_FIXNUM(target, source) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source)

#define SVM1_INST_NOT 0xab
#define DECODE_SVM1_INST_NOT(target, source) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source)

#define SVM1_INST_FLONUM_ALIGN 0xac
#define DECODE_SVM1_INST_FLONUM_ALIGN(target, source) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source)

#define SVM1_INST_FLONUM_LENGTH 0xad
#define DECODE_SVM1_INST_FLONUM_LENGTH(target, source) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source)

#define SVM1_INST_SQRT 0xae
#define DECODE_SVM1_INST_SQRT(target, source) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source)

#define SVM1_INST_ROUND 0xaf
#define DECODE_SVM1_INST_ROUND(target, source) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source)

#define SVM1_INST_CEILING 0xb0
#define DECODE_SVM1_INST_CEILING(target, source) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source)

#define SVM1_INST_FLOOR 0xb1
#define DECODE_SVM1_INST_FLOOR(target, source) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source)

#define SVM1_INST_TRUNCATE 0xb2
#define DECODE_SVM1_INST_TRUNCATE(target, source) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source)

#define SVM1_INST_LOG 0xb3
#define DECODE_SVM1_INST_LOG(target, source) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source)

#define SVM1_INST_EXP 0xb4
#define DECODE_SVM1_INST_EXP(target, source) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source)

#define SVM1_INST_COS 0xb5
#define DECODE_SVM1_INST_COS(target, source) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source)

#define SVM1_INST_SIN 0xb6
#define DECODE_SVM1_INST_SIN(target, source) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source)

#define SVM1_INST_TAN 0xb7
#define DECODE_SVM1_INST_TAN(target, source) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source)

#define SVM1_INST_ACOS 0xb8
#define DECODE_SVM1_INST_ACOS(target, source) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source)

#define SVM1_INST_ASIN 0xb9
#define DECODE_SVM1_INST_ASIN(target, source) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source)

#define SVM1_INST_ATAN 0xba
#define DECODE_SVM1_INST_ATAN(target, source) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source)

#define SVM1_INST_ADD_WR 0xbb
#define DECODE_SVM1_INST_ADD_WR(target, source1, source2) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2)

#define SVM1_INST_ADD_FR 0xbc
#define DECODE_SVM1_INST_ADD_FR(target, source1, source2) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2)

#define SVM1_INST_SUBTRACT_WR 0xbd
#define DECODE_SVM1_INST_SUBTRACT_WR(target, source1, source2) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2)

#define SVM1_INST_SUBTRACT_FR 0xbe
#define DECODE_SVM1_INST_SUBTRACT_FR(target, source1, source2) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2)

#define SVM1_INST_MULTIPLY_WR 0xbf
#define DECODE_SVM1_INST_MULTIPLY_WR(target, source1, source2) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2)

#define SVM1_INST_MULTIPLY_FR 0xc0
#define DECODE_SVM1_INST_MULTIPLY_FR(target, source1, source2) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2)

#define SVM1_INST_PRODUCT 0xc1
#define DECODE_SVM1_INST_PRODUCT(target, source1, source2) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2)

#define SVM1_INST_QUOTIENT 0xc2
#define DECODE_SVM1_INST_QUOTIENT(target, source1, source2) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2)

#define SVM1_INST_REMAINDER 0xc3
#define DECODE_SVM1_INST_REMAINDER(target, source1, source2) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2)

#define SVM1_INST_LSH 0xc4
#define DECODE_SVM1_INST_LSH(target, source1, source2) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2)

#define SVM1_INST_AND 0xc5
#define DECODE_SVM1_INST_AND(target, source1, source2) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2)

#define SVM1_INST_ANDC 0xc6
#define DECODE_SVM1_INST_ANDC(target, source1, source2) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2)

#define SVM1_INST_OR 0xc7
#define DECODE_SVM1_INST_OR(target, source1, source2) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2)

#define SVM1_INST_XOR 0xc8
#define DECODE_SVM1_INST_XOR(target, source1, source2) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2)

#define SVM1_INST_MAX_UNSIGNED 0xc9
#define DECODE_SVM1_INST_MAX_UNSIGNED(target, source1, source2) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2)

#define SVM1_INST_MIN_UNSIGNED 0xca
#define DECODE_SVM1_INST_MIN_UNSIGNED(target, source1, source2) \
  DECODE_WORD_REGISTER (target); \
  DECODE_WORD_REGISTER (source1); \
  DECODE_WORD_REGISTER (source2)

#define SVM1_INST_DIVIDE 0xcb
#define DECODE_SVM1_INST_DIVIDE(target, source1, source2) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2)

#define SVM1_INST_ATAN2 0xcc
#define DECODE_SVM1_INST_ATAN2(target, source1, source2) \
  DECODE_FLOAT_REGISTER (target); \
  DECODE_FLOAT_REGISTER (source1); \
  DECODE_FLOAT_REGISTER (source2)

#define SVM1_TRAP_0_START_CODE 0x01
#define SVM1_TRAP_0_END_CODE 0x20

#define SVM1_TRAP_0_BINDINGS(binder) \
  binder (SVM1_TRAP_0_ADD, add); \
  binder (SVM1_TRAP_0_DECREMENT, decrement); \
  binder (SVM1_TRAP_0_DIVIDE, divide); \
  binder (SVM1_TRAP_0_EQUAL_P, equal_p); \
  binder (SVM1_TRAP_0_GREATER_P, greater_p); \
  binder (SVM1_TRAP_0_INCREMENT, increment); \
  binder (SVM1_TRAP_0_LESS_P, less_p); \
  binder (SVM1_TRAP_0_MODULO, modulo); \
  binder (SVM1_TRAP_0_MULTIPLY, multiply); \
  binder (SVM1_TRAP_0_NEGATIVE_P, negative_p); \
  binder (SVM1_TRAP_0_OPERATOR_1_0, operator_1_0); \
  binder (SVM1_TRAP_0_OPERATOR_2_0, operator_2_0); \
  binder (SVM1_TRAP_0_OPERATOR_2_1, operator_2_1); \
  binder (SVM1_TRAP_0_OPERATOR_3_0, operator_3_0); \
  binder (SVM1_TRAP_0_OPERATOR_3_1, operator_3_1); \
  binder (SVM1_TRAP_0_OPERATOR_3_2, operator_3_2); \
  binder (SVM1_TRAP_0_OPERATOR_4_0, operator_4_0); \
  binder (SVM1_TRAP_0_OPERATOR_4_1, operator_4_1); \
  binder (SVM1_TRAP_0_OPERATOR_4_2, operator_4_2); \
  binder (SVM1_TRAP_0_OPERATOR_4_3, operator_4_3); \
  binder (SVM1_TRAP_0_OPERATOR_APPLY, operator_apply); \
  binder (SVM1_TRAP_0_OPERATOR_LEXPR, operator_lexpr); \
  binder (SVM1_TRAP_0_OPERATOR_LOOKUP, operator_lookup); \
  binder (SVM1_TRAP_0_OPERATOR_PRIMITIVE, operator_primitive); \
  binder (SVM1_TRAP_0_POSITIVE_P, positive_p); \
  binder (SVM1_TRAP_0_QUOTIENT, quotient); \
  binder (SVM1_TRAP_0_REFLECT_TO_INTERFACE, reflect_to_interface); \
  binder (SVM1_TRAP_0_REMAINDER, remainder); \
  binder (SVM1_TRAP_0_RETURN_TO_INTERPRETER, return_to_interpreter); \
  binder (SVM1_TRAP_0_SUBTRACT, subtract); \
  binder (SVM1_TRAP_0_ZERO_P, zero_p)

#define SVM1_TRAP_0_ADD 0x01
#define SVM1_TRAP_0_DECREMENT 0x02
#define SVM1_TRAP_0_DIVIDE 0x03
#define SVM1_TRAP_0_EQUAL_P 0x04
#define SVM1_TRAP_0_GREATER_P 0x05
#define SVM1_TRAP_0_INCREMENT 0x06
#define SVM1_TRAP_0_LESS_P 0x07
#define SVM1_TRAP_0_MODULO 0x08
#define SVM1_TRAP_0_MULTIPLY 0x09
#define SVM1_TRAP_0_NEGATIVE_P 0x0a
#define SVM1_TRAP_0_OPERATOR_1_0 0x0b
#define SVM1_TRAP_0_OPERATOR_2_0 0x0c
#define SVM1_TRAP_0_OPERATOR_2_1 0x0d
#define SVM1_TRAP_0_OPERATOR_3_0 0x0e
#define SVM1_TRAP_0_OPERATOR_3_1 0x0f
#define SVM1_TRAP_0_OPERATOR_3_2 0x10
#define SVM1_TRAP_0_OPERATOR_4_0 0x11
#define SVM1_TRAP_0_OPERATOR_4_1 0x12
#define SVM1_TRAP_0_OPERATOR_4_2 0x13
#define SVM1_TRAP_0_OPERATOR_4_3 0x14
#define SVM1_TRAP_0_OPERATOR_APPLY 0x15
#define SVM1_TRAP_0_OPERATOR_LEXPR 0x16
#define SVM1_TRAP_0_OPERATOR_LOOKUP 0x17
#define SVM1_TRAP_0_OPERATOR_PRIMITIVE 0x18
#define SVM1_TRAP_0_POSITIVE_P 0x19
#define SVM1_TRAP_0_QUOTIENT 0x1a
#define SVM1_TRAP_0_REFLECT_TO_INTERFACE 0x1b
#define SVM1_TRAP_0_REMAINDER 0x1c
#define SVM1_TRAP_0_RETURN_TO_INTERPRETER 0x1d
#define SVM1_TRAP_0_SUBTRACT 0x1e
#define SVM1_TRAP_0_ZERO_P 0x1f

#define SVM1_TRAP_1_START_CODE 0x01
#define SVM1_TRAP_1_END_CODE 0x07

#define SVM1_TRAP_1_BINDINGS(binder) \
  binder (SVM1_TRAP_1_ERROR, error); \
  binder (SVM1_TRAP_1_LOOKUP, lookup); \
  binder (SVM1_TRAP_1_PRIMITIVE_APPLY, primitive_apply); \
  binder (SVM1_TRAP_1_PRIMITIVE_LEXPR_APPLY, primitive_lexpr_apply); \
  binder (SVM1_TRAP_1_SAFE_LOOKUP, safe_lookup); \
  binder (SVM1_TRAP_1_UNASSIGNED_P, unassigned_p)

#define SVM1_TRAP_1_ERROR 0x01
#define SVM1_TRAP_1_LOOKUP 0x02
#define SVM1_TRAP_1_PRIMITIVE_APPLY 0x03
#define SVM1_TRAP_1_PRIMITIVE_LEXPR_APPLY 0x04
#define SVM1_TRAP_1_SAFE_LOOKUP 0x05
#define SVM1_TRAP_1_UNASSIGNED_P 0x06

#define SVM1_TRAP_2_START_CODE 0x01
#define SVM1_TRAP_2_END_CODE 0x05

#define SVM1_TRAP_2_BINDINGS(binder) \
  binder (SVM1_TRAP_2_APPLY, apply); \
  binder (SVM1_TRAP_2_ASSIGNMENT, assignment); \
  binder (SVM1_TRAP_2_LEXPR_APPLY, lexpr_apply); \
  binder (SVM1_TRAP_2_PRIMITIVE_ERROR, primitive_error)

#define SVM1_TRAP_2_APPLY 0x01
#define SVM1_TRAP_2_ASSIGNMENT 0x02
#define SVM1_TRAP_2_LEXPR_APPLY 0x03
#define SVM1_TRAP_2_PRIMITIVE_ERROR 0x04

#define SVM1_TRAP_3_START_CODE 0x01
#define SVM1_TRAP_3_END_CODE 0x03

#define SVM1_TRAP_3_BINDINGS(binder) \
  binder (SVM1_TRAP_3_CACHE_REFERENCE_APPLY, cache_reference_apply); \
  binder (SVM1_TRAP_3_LINK, link)

#define SVM1_TRAP_3_CACHE_REFERENCE_APPLY 0x01
#define SVM1_TRAP_3_LINK 0x02

#endif /* not SCM_SVM1_DEFNS_H */
