/*------------------------->  ANSI C - sourcefile  <-------------------------*/
/* Copyright (C) 2000 by K Hopper, University of Waikato, New Zealand        */
/* This file is part of the GNU Sather library. It is free software; you may */
/* redistribute  and/or modify it under the terms of the GNU Library General */
/* Public  License (LGPL)  as published  by the  Free  Software  Foundation; */
/* either version 2 of the license, or (at your option) any later version.   */
/* This  library  is distributed  in the  hope that it will  be  useful, but */
/* WITHOUT ANY WARRANTY without even the implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE. See Doc/LGPL for more details.       */
/* The license text is also available from:  Free Software Foundation, Inc., */
/* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA                     */
/*------------>  Please email comments to <bug-sather@gnu.org>  <------------*/

/* - - - - -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

          This file contains the Posix OS file/directory interface to the
     Sather file system services for use by the Sather implementation.

          The services specified here are only required when a Sather program
     makes use of files and directories.

          Version 2.0 Oct 98.  Copyright K Hopper, U of Waikato
          
                          Development History
                          -------------------

        Date           Who By         Detail
        ----           ------         ------

        15 Oct 98        kh       Original from Sather 1.2 distribution.

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 

#include <unistd.h>

/*  all Unix system calls -- open, close, access, chmod, etc etc */

#include <fcntl.h>

/* Just control defines */

#include <stdio.h>

/* fopen, fclose, fread, fxxx plus defines  */

#include <dirent.h>

/* opendir, readdir, rewinddir, closedir */

#include <sys/stat.h>

/* structure def for stat calls */

#include <errno.h>
#include "sather.h"

/* - - - - -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

          The seven routines below are provided purely to make the Sather/C
     interface a little easier for these particular services.

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 
char* read_dir(EXT_OB dirp) {
     struct dirent *entry ;

     while (1) {

         entry = readdir(dirp) ;

         if (entry == NULL) {
              return NULL ;
         }

         return entry->d_name ;
         }
     }


EXT_OB get_cwd() {
     char *buffer = getcwd(0,0);  /* using a GNU extension to standard getcwd */
     char *Xbuffer;
     if(!buffer)
     	  return 0; /* Must be a ENOACCESS - perhaps, the CWD does not exist any more... */
     Xbuffer = ZALLOC(strlen(buffer)+1) ;
     strcpy(Xbuffer,buffer) ;
     free(buffer) ;
     return Xbuffer ;
     }


EXT_OB get_std_channel(int code) {

     /*        This routine returns numeric values from 'defines' */

     switch (code) {

     case 1 : return stdin ;
     case 2 : return stdout ;
     case 3 : return stderr ;
          default : return (void *)-1 ;
          }
     }


struct stat *file_stat(
                      char *name,
                      struct stat *tuple) {
     int res ;

     res = stat(name, tuple) ;

     if (res < 0) {
          return 0 ;
          } ;
     return (struct stat *)res ;
     }

int fyle_error(FILE *p) {
     return ferror(p);
     }

EXT_OB error_message(void) {
     return strerror(errno) ;
     }

int file_exists(char *name) {
     struct stat dummy;
    
     return stat(name, &dummy);
     }
