/* Copyright (C) 1991, 1992, 1993 Aladdin Enterprises.  All rights reserved.
   Distributed by Free Software Foundation, Inc.

This file is part of Ghostscript.

Ghostscript is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
to anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.  Refer
to the Ghostscript General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Ghostscript, but only under the conditions described in the Ghostscript
General Public License.  A copy of this license is supposed to have been
given to you along with Ghostscript so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.  */

/* nalloc.h */
/* Library client interface for new Ghostscript allocator */

/* Define the type for the size of an object. */
typedef uint usize_t;

/* Define the type for identifying an allocator client. */
typedef const char _ds *client_name_t;

/* Define the type for an allocator instance. */
struct alloc_state_s;
typedef struct alloc_state_s _ds *as_ptr_t;

/* Define the type for a structure descriptor. */
struct struct_type_s;
typedef const struct struct_type_s _ds *at_ptr_t;

/* Define the type for allocator statistics. */
typedef struct alloc_status_s {
	ulong allocated;
	ulong used;
} alloc_status_t;

/* Define the allocator client procedures */
typedef struct alloc_procs_s alloc_procs_t;
struct alloc_procs_s {

		/* Allocate a structure */
#define alloc_proc_alloc_struct(proc)\
  void *proc(P3(as_ptr_t, at_ptr_t, client_name_t))
	alloc_proc_alloc_struct((*alloc_struct));
#define gs_alloc_struct(ap,tp,cn) (*(ap)->procs.alloc_struct)(ap,tp,cn)

		/* Allocate (aligned) bytes */
#define alloc_proc_alloc_bytes(proc)\
  byte *proc(P4(as_ptr_t, uint, uint, client_name_t))
	alloc_proc_alloc_bytes((*alloc_bytes));
#define gs_alloc_bytes(ap,es,n,cn) (*(ap)->procs.alloc_bytes)(ap,es,n,cn)

		/* Change the size of a byte object */
#define alloc_proc_resize(proc)\
  byte *proc(P5(as_ptr_t, byte *, uint, uint, client_name_t))
	alloc_proc_resize((*resize));
#define gs_resize(ap,p,es,n,cn) (*(ap)->procs.resize)(ap,p,es,n,cn)

		/* Free an object (structure or bytes) */
#define alloc_proc_free(proc)\
  void proc(P3(as_ptr_t, void *, client_name_t))
	alloc_proc_free((*free));
#define gs_free(ap,p,cn) (*(ap)->procs.free)(ap,p,cn)

		/* Report status (assigned, used) */
#define alloc_proc_status(proc)\
  void proc(P2(as_ptr_t, alloc_status_t *))
	alloc_proc_status((*status));
#define gs_alloc_status(ap,s) (*(ap)->procs.status)(ap,s)

};

/* Define the generic allocator state. */
/* "Subclasses" will extend this. */
#define alloc_state_common\
	alloc_procs_t procs;\
	as_ptr_t parent		/* for chunks & large blocks */
struct alloc_state_s {
	alloc_state_common;
};

/* Define the standard Ghostscript allocator implementation. */
extern const alloc_procs_t gs_alloc_std_procs;

/* ====== Root-registering clients ====== */
union struct_header_s;

/* Chunks are "objects", i.e. they have a header that identifies */
/* which implementation is being used. */
typedef struct chunk_s chunk_t;
typedef struct chunk_locator_s chunk_locator_t;
typedef chunk_locator_t _ss *cl_ptr_t;

/* Define the type for a pointer descriptor. */
typedef struct ptr_procs_s {

		/* Mark the referent of a pointer. */
#define ptr_proc_mark(proc)\
  bool proc(P1(void *))
	ptr_proc_mark((*mark));

		/* Relocate a pointer. */
#define ptr_proc_reloc(proc)\
  void *proc(P2(void *, cl_ptr_t))
	ptr_proc_reloc((*reloc));

} ptr_procs_t;
typedef const ptr_procs_t _ds *ptr_type_t;

/* Define the pointer type for ordinary structure pointers. */
extern const ptr_procs_t ptr_struct_procs;
#define ptr_struct_type (&ptr_struct_procs)

/* Define the type for a GC root. */
typedef struct gc_root_s gc_root_t;
struct gc_root_s {
  gc_root_t *next;
  ptr_type_t ptype;
  void **p;
};

/* Register/unregister a root. */
void gs_struct_root_register(P3(as_ptr_t, gc_root_t *, void **));
void gs_root_unregister(P2(as_ptr_t, gc_root_t *));

/* ====== Structure-defining clients ====== */
/* These are clients who define new types of structure. */

/* Object contents enumerator type */
#define mark_enum_proc(proc)\
  ptr_type_t proc(P3(void *ptr, uint index, void ***pep))

/* Object type */
typedef struct struct_type_s {
  usize_t size;
  const char _ds *sname;
  mark_enum_proc((*gc_mark_proc));
  void (*pre_gc_proc)(P1(void *));
  void (*post_gc_proc)(P1(void *));
  void (*finalize_proc)(P1(void *));
} struct_type_t;
/* Default object procedures. */
extern	mark_enum_proc(no_gc_mark_proc);
extern	void	no_pre_gc_proc(P1(void *)),
		no_post_gc_proc(P1(void *)),
		no_finalize_proc(P1(void *));
/* Macros for defining structure types. */
#define struct_type(stype, sname, mark, pre, post, finalize)\
  { sizeof(stype), sname, mark, pre, post, finalize }
#define simple_struct_type(stype, sname, proc)\
  struct_type(stype, sname, proc, no_pre_gc_proc, no_post_gc_proc, no_finalize_proc)
#define data_struct_type(stype, sname)\
  simple_struct_type(stype, sname, no_gc_mark_proc)

/*
 * The pointers in most structures consist only of a fixed set.
 * We provide some macros to simplify defining structures like this.
 */
/*
 * The structure of the mark procedure is stylized:
 *	ptr_type_t proc(void *ptr, uint index, void ***pep)
 *	{	switch_indexN(stype, member1, ..., memberN);
 *	}
 */
#ifdef offset_of
		/* Implement using a table of offsets. */
#define _si_begin()\
  static int offsets[] = {
#define _si_case(i,stype,m)\
  offset_of(stype, m),
#define _si_end()\
  0 };\
  if ( index >= countof(offsets) ) return NULL;\
  else { *pep = (void **)((char *)ptr + offsets[index]); return ptr_struct_type; }
#else		/* !defined(offset_of) */
		/* Implement using a switch. */
#define _si_begin()\
  switch ( index ) {
#define _si_case(i,stype,m)\
  case i: *pep = (void **)&((stype *)ptr)->m; break;
#define _si_end()\
  default: return NULL;\
  } return ptr_struct_type
#endif

#define _si_case2(i,stype,m1,m2)\
  _si_case(i,stype,m1) _si_case(i+1,stype,m2)
#define _si_case4(i,stype,m1,m2,m3,m4)\
  _si_case2(i,stype,m1,m2) _si_case2(i+2,stype,m3,m4)
#define switch_index0(stype)\
  _si_begin()_si_end()
#define switch_index1(stype,m1)\
  _si_begin()_si_case(0,stype,m1)_si_end()
#define switch_index2(stype,m1,m2)\
  _si_begin()_si_case2(0,stype,m1,m2)_si_end()
#define switch_index3(stype,m1,m2,m3)\
  _si_begin()_si_case2(0,stype,m1,m2)_si_case(2,stype,m3)_si_end()
#define switch_index4(stype,m1,m2,m3,m4)\
  _si_begin()_si_case4(0,stype,m1,m2,m3,m4)_si_end()
#define switch_index5(stype,m1,m2,m3,m4,m5)\
  _si_begin()_si_case4(0,stype,m1,m2,m3,m4)_si_case(4,stype,m5)_si_end()
#define switch_index6(stype,m1,m2,m3,m4,m5,m6)\
  _si_begin()_si_case4(0,stype,m1,m2,m3,m4)_si_case2(4,stype,m5,m6)_si_end()
