.TH VECT2GP 1 "Aug 1 1993"

.SH NAME
vect2gp \- a filter to convert vector data into a Gnuplot script

.SH SYNOPSIS

.B vect2gp
[
.B var1=arg1 var2=arg2 ...
] [ "vector-file" ] [ > "Gnuplot-command-file" ]
.br
.SH DESCRIPTION
.I vect2gp
is a self containd 
.B awk
script which converts vector data into a command script which
.I Gnuplot3.0
or greater will translate into a vector map on a
variety of terminals. The sizes of vectors are determined
automatically unless otherwise designated. A couple of
vectors are shown in the bottom left margin of your map as
"
.I reference
" vectors.

Let me call the horizontal component of the vector "u", and
the vertical one "v" in this document. See the 
.B OPTIONS
section for more details, and 
.B EXAMPLES
senction for gettin started. In addition, the format of vecter 
file is described in 
.B INPUT FILE
section and, come comment of the output is in 
.B OUTPUT FILE
section.

.SH OPTIONS

If options are given in the following format:
.br
.B variable1='argument1' variable2='argument2' .....
.br
then variables are set to the corresponding arguments.
Since 
.I vect2gp
is a self contained 
.B awk
script, the format of how to designate options might vary 
depending on which 
.B awk
you are using,and other options for 
.B awk
are also acceptable: see the bottom part of
this section and a manual for 
.B nawk
for more
information.

.TP 4
.B ref='value':
The size of the 
.I reference
vectors. If this is given, then
"uref" and "vref" are set as "uref" = "vref" = "ref". Note
that if the option "mag" is not designated, "ref" also
determines the scale of u and v. See also "mag", for more
information.
.TP 4
.B uref='value' (vref='value'):
The length of the reference vector for u(v). Default is the
maximum of the absolute value of u(v), unless "ref" is
given.
.TP 4
.B x0='value' (y0='value'):
The position of initial (bottom left) point is defined as (x0,y0).
Default: '1' for both.
.TP 4
.B dx='value' (dy='value'):
The datum position difference from the next datum
in the x(y)-direction. Default: '1'
.TP 4
.B mag='value':
.I Magnifying factors
of u and v against dx and dy. If this is
given, then "xmag" and "ymag" are set as "xmag" = "ymag" =
"mag". Default value is automatically determined as,
.br
 "mag"= 0.9*min(abs("uref"/"dx"), abs("vref"/"dy")).
.br
.TP 4
.B xmag='value' (ymag='value'):
Magnifying factor of u(v) against dx(dy). The actual length
L of u(v) on your picture is determined as,
.br
    L[u] = u * "xmag" * (the length of dx on picture).
.br
    L[v] = v * "ymag" * (the length of dy on picture).
.br
 Default: "mag" for both.
.TP 4
.B title='string':
 The figure 
.IR title.
Default: 'Gnu-plot VECTOR map'.
.TP 4
.B xlabel='string' (ylabel='string'):
The label for the x-axis(y-axis). Default: 'X'('Y').
.TP 4
.B margin='value':
The ratio of the margin size to that of the vector field map.
Default: '0.1'.
.TP 4
.B unit='string':
The 
.I unit name
of vector u and v. If this is given, then
"uunit" and "vunit" are set as "uunit" = "vunit" = "unit".
These names are printed by the reference vectors.
Default: empty.
.TP 4
.B uunit='string' (vunit='string'):
The unit name of the u(v) component of given vectors. This
unit string is printed by the reference vector.
Default: "unit" or empty
.TP 4
.B xref='value' (yref='value'):
The position of the reference vectors are determined as (x,y)
= ( "xref","yref" ). Default point is set in a left bottom
area in the margin.
.TP 4
.B time='FLAG':
Flag for 
.IR time-stamp.
When "time" is set to 'on' or 'ON', the
time is printed. Otherwise, no time-stamp is printed. Default: 'on'
.TP 4
.B -d'delimiter':
The field separator of the input file. This is exactly the
same option as "FS"='delimiter'. This is an option for nawk.
.TP 4
.B FS='delimiter':
The field separator of the input file. This separates u and
v. This is an option for nawk. Default: <space> or/and
<tabular> .
.TP 4
.B RS='delimiter':
The record separator of the input file. This separates
lines of input file. This is an option for nawk. Default:
<new-line>

.SH INPUT FILE
the vector file format

The format of the vector data file is basically similar to
that of 
.I splot 
command of 
.IR Gnuplot.
There are three types of lines.

.I Regular Line
should contain u and v separated by tabular or space:
.I Break Line
should contain no datum except for tabular and space:
.I Comment Line
which begins with "#" is ignored.

When regular line is read, u and v is read and x is incremented;
while break line appears, y is incremented.

You may change the 
.I delimiters
of the input file by designating them
as described in the bottom part of the options section.

To show that a datum is 
.I Not Available 
at any datum point, set "NA"
for u or/and v. When a u or v component of a datum is set as NA,
there appears no spot nor arrow at the corresponding point in your
vector map.

When both u and v equal to 
.IR zero ,
only a tiny spot appears at the
corresponding point with no arrowhead, if you use do_arrow() routine
in this package. Ask your superuser if you are not sure at this.
For more information about do_arrow(), see the notes section.

The following is an example of data file.

.RS 8
# vect.dat : sample data for vect2gp
.br
0 0
.br
0 1
.br
NA 2
.br
0 3

1 1
.br
1 2
.br
1 3
.br
1 4

2 1
.br
2 1.5
.br
2 2
.br
2 2.5

3 0
.br
3 1
.br
3 2
.RS -8

Note that the number of data in every block is not necessarily equal:
for example, the bottom block consists of only 3 sets of data.

.SH OUTPUT FILE
the Gnuplot command file

The output of "vect2gp" is a set of 
.I Gnuplot-3.x
commands.
You may easily read and modify this file with a Gnuplot manual.
It would not be difficult to superpose your graph onto the given
vector map.

Note that the 
.I bottom 4 lines
in the output file exist only to print
out the vector map with nothing else on your map. So, when you wish to
superpose your vector map on another picture, such as a geographical
map or contour lines, you should comment out the 4 lines in your output
file and add the script for your superposing picture.

.SH EXAMPLES

Here are some examples to help you get familiar with using vect2gp.
I personally recommend you to try in the following order.
A sample data file of "vect.dat" is shown in INPUT FILE section of
this note.

  vect2gp vect.dat > vect.gp

.RS 6
Each component of u and v is magnified automatically.
.RS -6

  vect2gp ref=3.0 vect.dat > sample2.gp

.RS 6
The size of the reference vectors for u and v are set to 3.0.
The magnification factors of u and v are determined by this value.
.RS -6

  vect2gp ref=3.0 unit='[m/s]' \\ 
.br
  x0=100 dx=10  y0=50 dy=5 vect.dat > sample3.gp

.RS 6
The same to the second sample except for x-y scaling.
The initial value of x is set to 100 and x is incremented by 10
to the next datum. In addition, the initial value of y is set
to 50 and y will increase by 5 for the next set of data.
.RS -6

  vect2gp mag=1.2 ref=3.0 unit='[m/s]' \\ 
.br
  x0=100 dx=10  y0=50 dy=5  \\ 
.br
  title='Flow pattern 1' xlabel='X [m]' ylabel='Y [m]' \\ 
.br
  time='no' vect.dat > sample4.gp

.RS 6
The same to the previous sample except for explicitly given
magnification factor and better presentation options.
.RS -6

.SH NOTES

Although Gnuplot-3.x has a command to 
.I draw arrows
, it is designed
to add arrows as a part of comments. So the original function to
draw arrows is not fine enough for vector maps, especially for
small arrows. If you also feel the same, I advice you to replace
the function of do_arrow() in the term.c of Gnuplot distribution,
to another do_arrow() included in the file 
.I ray_do_arrow.c
which is
a part of this package.

.SH AUTHOR

Yasu-hiro Yamazaki
.br
     hiro@rainbow.physics.utoronto.ca
.br
     hiro@ice3.ori.u-tokyo.ac.jp
.br
Send any comment or BUG report to the address above.

.SH BUGS

Lack of error check routines !
.br
Lack of 3 dimensional support (?)
.br
Lack of the support for "free position vector map".

.SH FILES

/usr/bin/nawk
.br
ray_do_arrow.c

.SH SEE ALSO

nawk(1), gnuplot(1)
.br
A printed manual for Gnuplot3.x

