/* Conversion of files between different charsets and usages.
   Copyright (C) 1993 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1993.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* Define for using new double step code.  */
#define USE_DOUBLE_STEP 1

#include "recode.h"

#ifdef USE_DOUBLE_STEP

/* RFC 1345 style description for NeXTSTEP (non official).  */

/* In the following table, these codes are not represented:

	Dec Oct     Character

	166 246     florin
	169 251     single quote
	172 254     gouillemot single left
	173 255     gouillemot single right
	184 270     single quote base
	185 271     double qoute base
	205 315     hungarian umlaut
*/

static DOUBLE_TABLE table =
  {
    "NUSHSXEXETEQAKBLBSHTLFVTFFCRSOSIDLD1D2D3D4NKSYEBCNEMSBECFSGSRSUS",
    "SP! \" NbDO% & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? ",
    "AtA B C D E F G H I J K L M N O P Q R S T U V W X Y Z <(//)>'>_ ",
    "'!a b c d e f g h i j k l m n o p q r s t u v w x y z (!!!!)'?DT",
    "NSA!A'A>A?A:AAC,E!E'E>E:I!I'I>I:D-N?O!O'O>O?O:U!U'U>U:Y'THMy*X-:",
    "Co!ICtPd/fYe  SECu  \"6<<    fiflRg-N/-/=.MBBPISb    \"9>>.3%0NO?I",
    "1S'!'''>'?'m'('.':2S'0',3S  ';'<-M+-141234a!a'a>a?a:aac,e!e'e>e:",
    "i!AEi'-ai>i:d-n?L/O/OE-oo!o'o>o?o:aeu!u'u>i.u:y'l/o/oessthy:    ",
  };

#else /* not USE_DOUBLE_STEP */

/* Data for NeXTSTEP to ISO Latin-1 code conversions.  */

static KNOWN_PAIR known_pairs[] =
  {
    {128, 160},			/* non-breakable space */
    {129, 192},			/* A with accent grave */
    {130, 193},			/* A with accent acute */
    {131, 194},			/* A with circumflex  */
    {132, 195},			/* A with tilde */
    {133, 196},			/* A with dieresis  */
    {134, 197},			/* A with ring  */
    {135, 199},			/* C with cedilla */
    {136, 200},			/* E with accent grave */
    {137, 201},			/* E with accent acute */
    {138, 202},			/* E with circumflex */
    {139, 203},			/* E with dieresis */
    {140, 204},			/* I with accent grave */
    {141, 205},			/* I with accent acute */
    {142, 206},			/* I with circumflex */
    {143, 207},			/* I with dieresis */
    {144, 208},			/* capital icelandic Eth */
    {145, 209},			/* N with tilde */
    {146, 210},			/* O with accent grave */
    {147, 211},			/* O with accent acute */
    {148, 212},			/* O with circumflex */
    {149, 213},			/* O with tilde */
    {150, 214},			/* O with dieresis */
    {151, 217},			/* U with accent grave */
    {152, 218},			/* U with accent acute */
    {153, 219},			/* U with circumflex */
    {154, 220},			/* U with dieresis */
    {155, 221},			/* Y with accent acute */
    {156, 222},			/* capital icelandig thorn */
    {157, 181},			/* greek letter mu (micro sign) */
    {158, 215},			/* multiply */
    {159, 247},			/* divide */
    {160, 169},			/* copyright */
    {161, 161},			/* inverted exclamation mark */
    {162, 162},			/* cent sign */
    {163, 163},			/* pound sterling sign */

    {165, 165},			/* yen sign  */

    {167, 167},			/* section (german paragraph) */
    {168, 164},			/* currency sign */

    {171, 171},			/* gouillemot left */

    {176, 174},			/* registered trademark */

    {180, 183},			/* centered period */
    {181, 166},			/* broken bar */
    {182, 182},			/* paragraph sign */

    {187, 187},			/* gouillemot right */

    {190, 172},			/* logical not */
    {191, 191},			/* inverted question mark */
    {192, 185},			/* superscript one */

    {194, 180},			/* accent acute */

    {197, 175},			/* macron */

    {200, 168},			/* dieresis */
    {201, 178},			/* superscript two */
    {202, 176},			/* ring */
    {203, 184},			/* cedilla */
    {204, 179},			/* superscript 3 */

    {209, 177},			/* plusminus */
    {210, 188},			/* 1/4 */
    {211, 189},			/* 1/2 */
    {212, 190},			/* 3/4 */
    {213, 224},			/* a with accent grave */
    {214, 225},			/* a with accent acute */
    {215, 226},			/* a with circumflex */
    {216, 227},			/* a with tilde */
    {217, 228},			/* a with dieresis */
    {218, 229},			/* a with ring */
    {219, 231},			/* c with cedilla */
    {220, 232},			/* e with accent grave */
    {221, 233},			/* e with accent acute */
    {222, 234},			/* e with circumflex */
    {223, 235},			/* e with dieresis */
    {224, 236},			/* i with accent grave */
    {225, 198},			/* AE */
    {226, 237},			/* i with accent acute */
    {227, 170},			/* feminine ordinal indicator */
    {228, 238},			/* i with circumflex */
    {229, 239},			/* i with dieresis */
    {230, 240},			/* small icelandic eth */
    {231, 241},			/* n with tilde */

    {233, 216},			/* O with slash */

    {235, 186},			/* masculine ordinal indicator */
    {236, 242},			/* o with accent grave */
    {237, 243},			/* o with accent acute */
    {238, 244},			/* o with circumflex */
    {239, 245},			/* o with tilde */
    {240, 246},			/* o with dieresis */
    {241, 230},			/* ae */
    {242, 249},			/* u with accent grave */
    {243, 250},			/* u with accent acute */
    {244, 251},			/* u with circumflex */

    {246, 252},			/* u with dieresis */
    {247, 253},			/* y with accent acute */

    {249, 248},			/* o with slash */

    {251, 223},			/* german sz */
    {252, 254},			/* small icelandic thorn */
    {253, 255},			/* y with dieresis */
  };
#define NUMBER_OF_PAIRS (sizeof (known_pairs) / sizeof (KNOWN_PAIR))

static void
init_latin1_nextstep (STEP *step)
{
  complete_pairs (step, 1, known_pairs, NUMBER_OF_PAIRS, 1);
}

static void
init_nextstep_latin1 (STEP *step)
{
  complete_pairs (step, 1, known_pairs, NUMBER_OF_PAIRS, 0);
}

#endif /* not USE_DOUBLE_STEP */

void
module_nextstep (void)
{

#ifdef USE_DOUBLE_STEP

  declare_double_step (&table, "NeXTSTEP", 2);

#else /* not USE_DOUBLE_STEP */

  declare_step ("latin1", "nextstep",
		strict_mapping ? ONE_TO_MANY : REVERSIBLE,
		init_latin1_nextstep, NULL);
  declare_step ("nextstep", "latin1",
		strict_mapping ? ONE_TO_MANY : REVERSIBLE,
		init_nextstep_latin1, NULL);

#endif /* not USE_DOUBLE_STEP */

}
