/* CSL - Common Sound Layer
 * Copyright (C) 2000-2001 Stefan Westerfeld and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __ARTS_SOUND_SERVER_H__
#define __ARTS_SOUND_SERVER_H__


#include "artsmcopmarshal.h"
#include "artsmcopdispatcher.h"
#include "csldefs.h"

typedef struct _ArtsSoundServer ArtsSoundServer;

ArtsSoundServer*	_arts_sound_server_from_reference (ArtsMcopDispatcher       *dispatcher,
							       ArtsMcopObjectReference  *reference,
							       CslBool                  need_copy);
long			_arts_sound_server_play	      (ArtsSoundServer      *server,
							       const char              *filename);
ArtsMcopObjectReference *_arts_sound_server_create_object  (ArtsSoundServer      *server,
							       const char              *name);

#endif /* __ARTS_SOUND_SERVER_H__ */
