/* CSL - Common Sound Layer
 * Copyright (C) 2000-2001 Stefan Westerfeld and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "playsample_impl.h"
#include "adapter_impl.h"
#include "artsflow.h"
#include "debug.h"
#include "convert.h"
#include "connect.h"

using namespace Arts;
using namespace CSL;
using namespace std;

/* PlaySample: */
PlaySample_impl::PlaySample_impl(Adapter_impl *adapter,
								 const string& filename,
								 const string& role, const string& title,
								 long ID)
	:_ID(ID), adapter(adapter)
{
	wav.filename(filename);
	play.title(title);
	play.autoRestoreID(role);
	connect(wav,play);
	connect(wav,"finished_changed",self(),"finished");
	wav.start();
	play.start();
}

void PlaySample_impl::finished(bool f)
{
	if(f)
		adapter->sampleDone(self());
}

bool PlaySample_impl::finished()
{
	return wav.finished();
}
