/* CSL - Common Sound Layer
 * Copyright (C) 2001 Jeff Tranter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * This shows using the csl_driver_init_mutex() call. For a more
 * complete example, which actually uses threads, see cslmutex.c
 */

#include <stdio.h>
#include <csl/csl.h>

static void lock(CslMutex *mutex)
{
	printf("in lock()\n");
}

static void unlock(CslMutex *mutex)
{
	printf("in unlock()\n");
}

static void destroy(CslMutex *mutex)
{
	printf("in destroy()\n");
}

int main()
{
	CslDriver *driver;
	CslErrorType err;
	CslMutex mutex;

	/* point mutex to appropriate functions */
	mutex.lock = lock;
	mutex.unlock = unlock;
	mutex.destroy = destroy;
	
	printf("Calling csl_driver_init_mutex\n");
	err = csl_driver_init_mutex(NULL, CSL_DRIVER_CAP_PCM, &mutex, &driver);
	if (err == 0)
	{
		printf("succeeded\n");
	} else {
		printf("failed, error was \"%s\" (%d)\n", csl_strerror(err), err);
	}

	if (driver != NULL)
	{
		printf("Calling csl_driver_shutdown\n");
		csl_driver_shutdown(driver);
	}

	return 0;
}
