/* minibuf.c generated by valac 0.56.17, the Vala compiler
 * generated from minibuf.vala, do not modify */

/* Minibuffer facility functions

   Copyright (c) 1997-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdarg.h>
#include <gee.h>
#include <errno.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;
#define _history_unref0(var) ((var == NULL) ? NULL : (var = (history_unref (var), NULL)))

#define TYPE_WINDOW (window_get_type ())
#define WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WINDOW, Window))
#define WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WINDOW, WindowClass))
#define IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WINDOW))
#define IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WINDOW))
#define WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WINDOW, WindowClass))

typedef struct _Window Window;
typedef struct _WindowClass WindowClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_COMPLETION (completion_get_type ())
#define COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION, Completion))
#define COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION, CompletionClass))
#define IS_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION))
#define IS_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION))
#define COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION, CompletionClass))

typedef struct _Completion Completion;
typedef struct _CompletionClass CompletionClass;
#define _completion_unref0(var) ((var == NULL) ? NULL : (var = (completion_unref (var), NULL)))
typedef struct _CompletionPrivate CompletionPrivate;

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;
typedef enum  {
	COMPLETION_FLAGS_POPPEDUP = 1 << 0,
	COMPLETION_FLAGS_CLOSE = 1 << 1,
	COMPLETION_FLAGS_FILENAME = 1 << 2
} CompletionFlags;

#define COMPLETION_TYPE_FLAGS (completion_flags_get_type ())
typedef enum  {
	COMPLETION_CODE_notmatched,
	COMPLETION_CODE_matched,
	COMPLETION_CODE_matchednonunique,
	COMPLETION_CODE_nonunique
} CompletionCode;

#define COMPLETION_TYPE_CODE (completion_code_get_type ())
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Completion {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CompletionPrivate * priv;
	gchar* match;
	Buffer* old_bp;
	GeeSortedSet* completions;
	GeeSortedSet* matches;
	glong matchsize;
	CompletionFlags flags;
	gchar* path;
};

struct _CompletionClass {
	GTypeClass parent_class;
	void (*finalize) (Completion *self);
};

VALA_EXTERN History* minibuf_files_history;
History* minibuf_files_history = NULL;
VALA_EXTERN gchar* minibuf_contents;
gchar* minibuf_contents = NULL;
VALA_EXTERN Window* cur_wp;

VALA_EXTERN gpointer history_ref (gpointer instance);
VALA_EXTERN void history_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_history (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_history (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_history (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_history (const GValue* value);
VALA_EXTERN GType history_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (History, history_unref)
VALA_EXTERN void minibuf_init (void);
VALA_EXTERN History* history_new (void);
VALA_EXTERN History* history_construct (GType object_type);
VALA_EXTERN gboolean minibuf_no_error (void);
VALA_EXTERN void minibuf_refresh (void);
VALA_EXTERN gpointer window_ref (gpointer instance);
VALA_EXTERN void window_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_window (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_window (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_window (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_window (const GValue* value);
VALA_EXTERN GType window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Window, window_unref)
VALA_EXTERN void term_minibuf_write (const gchar* s);
VALA_EXTERN void term_redraw_cursor (void);
VALA_EXTERN void term_refresh (void);
VALA_EXTERN void minibuf_vwrite (const gchar* fmt,
                     va_list ap);
VALA_EXTERN void minibuf_write (const gchar* fmt,
                    ...);
VALA_EXTERN void minibuf_error (const gchar* fmt,
                    ...);
VALA_EXTERN void ding (void);
VALA_EXTERN gchar* minibuf_read (const gchar* fmt,
                     const gchar* value,
                     ...);
VALA_EXTERN gpointer completion_ref (gpointer instance);
VALA_EXTERN void completion_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_completion (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_completion (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_completion (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_completion (const GValue* value);
VALA_EXTERN GType completion_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Completion, completion_unref)
VALA_EXTERN gchar* term_minibuf_read (const gchar* prompt,
                          const gchar* val,
                          glong pos,
                          Completion* cp,
                          History* hp);
VALA_EXTERN glong minibuf_read_number (const gchar* fmt,
                           ...);
VALA_EXTERN gboolean funcall (const gchar* name,
                  glong* maybe_uniarg,
                  GeeQueue* args);
VALA_EXTERN gchar* minibuf_read_filename (const gchar* fmt,
                              const gchar* value,
                              const gchar* file,
                              ...);
VALA_EXTERN gchar* expand_path (const gchar* path);
VALA_EXTERN gchar* compact_path (const gchar* in_path);
VALA_EXTERN Completion* completion_new (gboolean fileflag);
VALA_EXTERN Completion* completion_construct (GType object_type,
                                  gboolean fileflag);
VALA_EXTERN void history_add_element (History* self,
                          const gchar* s);
VALA_EXTERN gboolean* minibuf_read_yesno (const gchar* fmt,
                              ...);
VALA_EXTERN gpointer buffer_ref (gpointer instance);
VALA_EXTERN void buffer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_buffer (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_buffer (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_buffer (const GValue* value);
VALA_EXTERN GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
VALA_EXTERN GType completion_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* minibuf_vread_completion (const gchar* fmt,
                                 const gchar* val,
                                 Completion* cp,
                                 History* hp,
                                 const gchar* empty_err,
                                 const gchar* invalid_err,
                                 va_list ap);
static gboolean* _bool_dup (gboolean* self);
VALA_EXTERN gchar* minibuf_read_completion (const gchar* fmt,
                                const gchar* val,
                                Completion* cp,
                                History* hp,
                                ...);
VALA_EXTERN GType completion_code_get_type (void) G_GNUC_CONST ;
VALA_EXTERN CompletionCode completion_try (Completion* self,
                               const gchar* in_search,
                               gboolean popup_when_complete);
VALA_EXTERN void minibuf_clear (void);
VALA_EXTERN void waitkey (void);

void
minibuf_init (void)
{
	History* _tmp0_;
#line 31 "src/minibuf.vala"
	_tmp0_ = history_new ();
#line 31 "src/minibuf.vala"
	_history_unref0 (minibuf_files_history);
#line 31 "src/minibuf.vala"
	minibuf_files_history = _tmp0_;
#line 265 "minibuf.c"
}

gboolean
minibuf_no_error (void)
{
	const gchar* _tmp0_;
	gboolean result;
#line 35 "src/minibuf.vala"
	_tmp0_ = minibuf_contents;
#line 35 "src/minibuf.vala"
	result = _tmp0_ == NULL;
#line 35 "src/minibuf.vala"
	return result;
#line 279 "minibuf.c"
}

void
minibuf_refresh (void)
{
	Window* _tmp0_;
#line 39 "src/minibuf.vala"
	_tmp0_ = cur_wp;
#line 39 "src/minibuf.vala"
	if (_tmp0_ != NULL) {
#line 290 "minibuf.c"
		const gchar* _tmp1_;
#line 40 "src/minibuf.vala"
		_tmp1_ = minibuf_contents;
#line 40 "src/minibuf.vala"
		if (_tmp1_ != NULL) {
#line 296 "minibuf.c"
			const gchar* _tmp2_;
#line 41 "src/minibuf.vala"
			_tmp2_ = minibuf_contents;
#line 41 "src/minibuf.vala"
			term_minibuf_write (_tmp2_);
#line 302 "minibuf.c"
		}
#line 44 "src/minibuf.vala"
		term_redraw_cursor ();
#line 45 "src/minibuf.vala"
		term_refresh ();
#line 308 "minibuf.c"
	}
}

void
minibuf_vwrite (const gchar* fmt,
                va_list ap)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
#line 49 "src/minibuf.vala"
	g_return_if_fail (fmt != NULL);
#line 50 "src/minibuf.vala"
	_tmp0_ = g_strdup_vprintf (fmt, ap);
#line 50 "src/minibuf.vala"
	s = _tmp0_;
#line 51 "src/minibuf.vala"
	_tmp2_ = minibuf_contents;
#line 51 "src/minibuf.vala"
	if (_tmp2_ == NULL) {
#line 51 "src/minibuf.vala"
		_tmp1_ = TRUE;
#line 332 "minibuf.c"
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
#line 51 "src/minibuf.vala"
		_tmp3_ = s;
#line 51 "src/minibuf.vala"
		_tmp4_ = minibuf_contents;
#line 51 "src/minibuf.vala"
		_tmp1_ = g_strcmp0 (_tmp3_, _tmp4_) != 0;
#line 342 "minibuf.c"
	}
#line 51 "src/minibuf.vala"
	if (_tmp1_) {
#line 346 "minibuf.c"
		const gchar* _tmp5_;
		gchar* _tmp6_;
#line 52 "src/minibuf.vala"
		_tmp5_ = s;
#line 52 "src/minibuf.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 52 "src/minibuf.vala"
		_g_free0 (minibuf_contents);
#line 52 "src/minibuf.vala"
		minibuf_contents = _tmp6_;
#line 53 "src/minibuf.vala"
		minibuf_refresh ();
#line 359 "minibuf.c"
	}
#line 49 "src/minibuf.vala"
	_g_free0 (s);
#line 363 "minibuf.c"
}

void
minibuf_write (const gchar* fmt,
               ...)
{
	va_list _tmp0_ = {0};
#line 60 "src/minibuf.vala"
	g_return_if_fail (fmt != NULL);
#line 61 "src/minibuf.vala"
	va_start (_tmp0_, fmt);
#line 61 "src/minibuf.vala"
	minibuf_vwrite (fmt, _tmp0_);
#line 61 "src/minibuf.vala"
	va_end (_tmp0_);
#line 379 "minibuf.c"
}

void
minibuf_error (const gchar* fmt,
               ...)
{
	va_list _tmp0_ = {0};
#line 67 "src/minibuf.vala"
	g_return_if_fail (fmt != NULL);
#line 68 "src/minibuf.vala"
	va_start (_tmp0_, fmt);
#line 68 "src/minibuf.vala"
	minibuf_vwrite (fmt, _tmp0_);
#line 68 "src/minibuf.vala"
	va_end (_tmp0_);
#line 69 "src/minibuf.vala"
	ding ();
#line 397 "minibuf.c"
}

gchar*
minibuf_read (const gchar* fmt,
              const gchar* value,
              ...)
{
	const gchar* _tmp0_ = NULL;
	va_list _tmp1_ = {0};
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
#line 75 "src/minibuf.vala"
	g_return_val_if_fail (fmt != NULL, NULL);
#line 76 "src/minibuf.vala"
	_tmp0_ = value;
#line 76 "src/minibuf.vala"
	if (_tmp0_ == NULL) {
#line 76 "src/minibuf.vala"
		_tmp0_ = "";
#line 420 "minibuf.c"
	}
#line 76 "src/minibuf.vala"
	va_start (_tmp1_, value);
#line 76 "src/minibuf.vala"
	_tmp2_ = g_strdup_vprintf (fmt, _tmp1_);
#line 76 "src/minibuf.vala"
	_tmp3_ = _tmp2_;
#line 76 "src/minibuf.vala"
	_tmp4_ = term_minibuf_read (_tmp3_, _tmp0_, G_MAXLONG, NULL, NULL);
#line 76 "src/minibuf.vala"
	_tmp5_ = _tmp4_;
#line 76 "src/minibuf.vala"
	_g_free0 (_tmp3_);
#line 76 "src/minibuf.vala"
	va_end (_tmp1_);
#line 76 "src/minibuf.vala"
	result = _tmp5_;
#line 76 "src/minibuf.vala"
	return result;
#line 440 "minibuf.c"
}

static gboolean
long_try_parse (const gchar* str,
                glong* _result_,
                const gchar** unparsed,
                guint _base)
{
	glong _vala__result_ = 0L;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
#line 319 "glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, FALSE);
#line 321 "glib-2.0.vapi"
	errno = 0;
#line 322 "glib-2.0.vapi"
	_tmp1_ = strtol (str, &_tmp0_, (gint) _base);
#line 322 "glib-2.0.vapi"
	endptr = _tmp0_;
#line 322 "glib-2.0.vapi"
	_vala__result_ = _tmp1_;
#line 323 "glib-2.0.vapi"
	_tmp2_ = endptr;
#line 323 "glib-2.0.vapi"
	_tmp3_ = strlen (str);
#line 323 "glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 323 "glib-2.0.vapi"
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
#line 476 "minibuf.c"
		gboolean _tmp5_ = FALSE;
#line 324 "glib-2.0.vapi"
		_vala_unparsed = "";
#line 325 "glib-2.0.vapi"
		if (errno != ERANGE) {
#line 325 "glib-2.0.vapi"
			_tmp5_ = errno != EINVAL;
#line 484 "minibuf.c"
		} else {
#line 325 "glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 488 "minibuf.c"
		}
#line 325 "glib-2.0.vapi"
		result = _tmp5_;
#line 325 "glib-2.0.vapi"
		if (_result_) {
#line 325 "glib-2.0.vapi"
			*_result_ = _vala__result_;
#line 496 "minibuf.c"
		}
#line 325 "glib-2.0.vapi"
		if (unparsed) {
#line 325 "glib-2.0.vapi"
			*unparsed = _vala_unparsed;
#line 502 "minibuf.c"
		}
#line 325 "glib-2.0.vapi"
		return result;
#line 506 "minibuf.c"
	} else {
		gchar* _tmp6_;
#line 327 "glib-2.0.vapi"
		_tmp6_ = endptr;
#line 327 "glib-2.0.vapi"
		_vala_unparsed = (const gchar*) _tmp6_;
#line 328 "glib-2.0.vapi"
		result = FALSE;
#line 328 "glib-2.0.vapi"
		if (_result_) {
#line 328 "glib-2.0.vapi"
			*_result_ = _vala__result_;
#line 519 "minibuf.c"
		}
#line 328 "glib-2.0.vapi"
		if (unparsed) {
#line 328 "glib-2.0.vapi"
			*unparsed = _vala_unparsed;
#line 525 "minibuf.c"
		}
#line 328 "glib-2.0.vapi"
		return result;
#line 529 "minibuf.c"
	}
}

glong
minibuf_read_number (const gchar* fmt,
                     ...)
{
	gulong n = 0UL;
	gchar* buf = NULL;
	va_list _tmp0_ = {0};
	gchar* _tmp1_;
	gchar* _tmp2_;
	glong result;
#line 82 "src/minibuf.vala"
	g_return_val_if_fail (fmt != NULL, 0L);
#line 83 "src/minibuf.vala"
	n = (gulong) 0;
#line 84 "src/minibuf.vala"
	va_start (_tmp0_, fmt);
#line 84 "src/minibuf.vala"
	_tmp1_ = g_strdup_vprintf (fmt, _tmp0_);
#line 84 "src/minibuf.vala"
	_tmp2_ = _tmp1_;
#line 84 "src/minibuf.vala"
	va_end (_tmp0_);
#line 84 "src/minibuf.vala"
	buf = _tmp2_;
#line 557 "minibuf.c"
	{
		gboolean _tmp3_ = FALSE;
#line 86 "src/minibuf.vala"
		_tmp3_ = TRUE;
#line 86 "src/minibuf.vala"
		while (TRUE) {
#line 564 "minibuf.c"
			gchar* a = NULL;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			const gchar* _tmp10_;
			glong _tmp11_ = 0L;
			gboolean _tmp12_;
#line 86 "src/minibuf.vala"
			if (!_tmp3_) {
#line 102 "src/minibuf.vala"
				if (!FALSE) {
#line 102 "src/minibuf.vala"
					break;
#line 581 "minibuf.c"
				}
			}
#line 86 "src/minibuf.vala"
			_tmp3_ = FALSE;
#line 87 "src/minibuf.vala"
			_tmp4_ = buf;
#line 87 "src/minibuf.vala"
			_tmp5_ = minibuf_read ("%s", "", _tmp4_, NULL);
#line 87 "src/minibuf.vala"
			a = _tmp5_;
#line 88 "src/minibuf.vala"
			_tmp6_ = a;
#line 88 "src/minibuf.vala"
			if (_tmp6_ == NULL) {
#line 89 "src/minibuf.vala"
				n = (gulong) G_MAXLONG;
#line 90 "src/minibuf.vala"
				funcall ("keyboard-quit", NULL, NULL);
#line 91 "src/minibuf.vala"
				_g_free0 (a);
#line 91 "src/minibuf.vala"
				break;
#line 604 "minibuf.c"
			}
#line 93 "src/minibuf.vala"
			_tmp7_ = a;
#line 93 "src/minibuf.vala"
			_tmp8_ = strlen (_tmp7_);
#line 93 "src/minibuf.vala"
			_tmp9_ = _tmp8_;
#line 93 "src/minibuf.vala"
			if (_tmp9_ == 0) {
#line 94 "src/minibuf.vala"
				n = (gulong) (G_MAXLONG - 1);
#line 95 "src/minibuf.vala"
				_g_free0 (a);
#line 95 "src/minibuf.vala"
				break;
#line 620 "minibuf.c"
			}
#line 97 "src/minibuf.vala"
			_tmp10_ = a;
#line 97 "src/minibuf.vala"
			_tmp12_ = long_try_parse (_tmp10_, &_tmp11_, NULL, (guint) 10);
#line 97 "src/minibuf.vala"
			n = (gulong) _tmp11_;
#line 97 "src/minibuf.vala"
			if (_tmp12_ == FALSE) {
#line 98 "src/minibuf.vala"
				minibuf_write ("Please enter a number.", NULL);
#line 99 "src/minibuf.vala"
				ding ();
#line 100 "src/minibuf.vala"
				_g_free0 (a);
#line 100 "src/minibuf.vala"
				continue;
#line 638 "minibuf.c"
			}
#line 86 "src/minibuf.vala"
			_g_free0 (a);
#line 642 "minibuf.c"
		}
	}
#line 104 "src/minibuf.vala"
	result = (glong) n;
#line 104 "src/minibuf.vala"
	_g_free0 (buf);
#line 104 "src/minibuf.vala"
	return result;
#line 651 "minibuf.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
#line 1283 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1284 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1284 "glib-2.0.vapi"
	result = _tmp0_;
#line 1284 "glib-2.0.vapi"
	return result;
#line 668 "minibuf.c"
}

gchar*
minibuf_read_filename (const gchar* fmt,
                       const gchar* value,
                       const gchar* file,
                       ...)
{
	gchar* p = NULL;
	gchar* a = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* result;
#line 110 "src/minibuf.vala"
	g_return_val_if_fail (fmt != NULL, NULL);
#line 110 "src/minibuf.vala"
	g_return_val_if_fail (value != NULL, NULL);
#line 111 "src/minibuf.vala"
	p = NULL;
#line 113 "src/minibuf.vala"
	_tmp0_ = g_strdup (value);
#line 113 "src/minibuf.vala"
	a = _tmp0_;
#line 114 "src/minibuf.vala"
	if (file == NULL) {
#line 698 "minibuf.c"
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 114 "src/minibuf.vala"
		_tmp3_ = a;
#line 114 "src/minibuf.vala"
		_tmp4_ = strlen (_tmp3_);
#line 114 "src/minibuf.vala"
		_tmp5_ = _tmp4_;
#line 114 "src/minibuf.vala"
		_tmp2_ = _tmp5_ > 0;
#line 710 "minibuf.c"
	} else {
#line 114 "src/minibuf.vala"
		_tmp2_ = FALSE;
#line 714 "minibuf.c"
	}
#line 114 "src/minibuf.vala"
	if (_tmp2_) {
#line 718 "minibuf.c"
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
#line 114 "src/minibuf.vala"
		_tmp6_ = a;
#line 114 "src/minibuf.vala"
		_tmp7_ = a;
#line 114 "src/minibuf.vala"
		_tmp8_ = strlen (_tmp7_);
#line 114 "src/minibuf.vala"
		_tmp9_ = _tmp8_;
#line 114 "src/minibuf.vala"
		_tmp1_ = string_get (_tmp6_, (glong) (_tmp9_ - 1)) != '/';
#line 733 "minibuf.c"
	} else {
#line 114 "src/minibuf.vala"
		_tmp1_ = FALSE;
#line 737 "minibuf.c"
	}
#line 114 "src/minibuf.vala"
	if (_tmp1_) {
#line 741 "minibuf.c"
		const gchar* _tmp10_;
		gchar* _tmp11_;
#line 115 "src/minibuf.vala"
		_tmp10_ = a;
#line 115 "src/minibuf.vala"
		_tmp11_ = g_strconcat (_tmp10_, "/", NULL);
#line 115 "src/minibuf.vala"
		_g_free0 (a);
#line 115 "src/minibuf.vala"
		a = _tmp11_;
#line 752 "minibuf.c"
	}
#line 117 "src/minibuf.vala"
	_tmp12_ = a;
#line 117 "src/minibuf.vala"
	_tmp13_ = expand_path (_tmp12_);
#line 117 "src/minibuf.vala"
	_g_free0 (a);
#line 117 "src/minibuf.vala"
	a = _tmp13_;
#line 117 "src/minibuf.vala"
	_tmp14_ = a;
#line 117 "src/minibuf.vala"
	if (_tmp14_ != NULL) {
#line 766 "minibuf.c"
		gchar* buf = NULL;
		va_list _tmp15_ = {0};
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		Completion* cp = NULL;
		Completion* _tmp20_;
		glong pos = 0L;
		const gchar* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		Completion* _tmp28_;
		History* _tmp29_;
		gchar* _tmp30_;
		gboolean _tmp31_ = FALSE;
		const gchar* _tmp32_;
#line 118 "src/minibuf.vala"
		va_start (_tmp15_, file);
#line 118 "src/minibuf.vala"
		_tmp16_ = g_strdup_vprintf (fmt, _tmp15_);
#line 118 "src/minibuf.vala"
		_tmp17_ = _tmp16_;
#line 118 "src/minibuf.vala"
		va_end (_tmp15_);
#line 118 "src/minibuf.vala"
		buf = _tmp17_;
#line 120 "src/minibuf.vala"
		_tmp18_ = a;
#line 120 "src/minibuf.vala"
		_tmp19_ = compact_path (_tmp18_);
#line 120 "src/minibuf.vala"
		_g_free0 (a);
#line 120 "src/minibuf.vala"
		a = _tmp19_;
#line 122 "src/minibuf.vala"
		_tmp20_ = completion_new (TRUE);
#line 122 "src/minibuf.vala"
		cp = _tmp20_;
#line 123 "src/minibuf.vala"
		_tmp21_ = a;
#line 123 "src/minibuf.vala"
		_tmp22_ = strlen (_tmp21_);
#line 123 "src/minibuf.vala"
		_tmp23_ = _tmp22_;
#line 123 "src/minibuf.vala"
		pos = (glong) _tmp23_;
#line 124 "src/minibuf.vala"
		if (file != NULL) {
#line 818 "minibuf.c"
			gint _tmp24_;
			gint _tmp25_;
#line 125 "src/minibuf.vala"
			_tmp24_ = strlen (file);
#line 125 "src/minibuf.vala"
			_tmp25_ = _tmp24_;
#line 125 "src/minibuf.vala"
			pos -= (glong) _tmp25_;
#line 827 "minibuf.c"
		}
#line 126 "src/minibuf.vala"
		_tmp26_ = buf;
#line 126 "src/minibuf.vala"
		_tmp27_ = a;
#line 126 "src/minibuf.vala"
		_tmp28_ = cp;
#line 126 "src/minibuf.vala"
		_tmp29_ = minibuf_files_history;
#line 126 "src/minibuf.vala"
		_tmp30_ = term_minibuf_read (_tmp26_, _tmp27_, pos, _tmp28_, _tmp29_);
#line 126 "src/minibuf.vala"
		_g_free0 (p);
#line 126 "src/minibuf.vala"
		p = _tmp30_;
#line 128 "src/minibuf.vala"
		_tmp32_ = p;
#line 128 "src/minibuf.vala"
		if (_tmp32_ != NULL) {
#line 847 "minibuf.c"
			const gchar* _tmp33_;
			gchar* _tmp34_;
			const gchar* _tmp35_;
#line 128 "src/minibuf.vala"
			_tmp33_ = p;
#line 128 "src/minibuf.vala"
			_tmp34_ = expand_path (_tmp33_);
#line 128 "src/minibuf.vala"
			_g_free0 (p);
#line 128 "src/minibuf.vala"
			p = _tmp34_;
#line 128 "src/minibuf.vala"
			_tmp35_ = p;
#line 128 "src/minibuf.vala"
			_tmp31_ = _tmp35_ != NULL;
#line 863 "minibuf.c"
		} else {
#line 128 "src/minibuf.vala"
			_tmp31_ = FALSE;
#line 867 "minibuf.c"
		}
#line 128 "src/minibuf.vala"
		if (_tmp31_) {
#line 871 "minibuf.c"
			History* _tmp36_;
			const gchar* _tmp37_;
#line 129 "src/minibuf.vala"
			_tmp36_ = minibuf_files_history;
#line 129 "src/minibuf.vala"
			_tmp37_ = p;
#line 129 "src/minibuf.vala"
			history_add_element (_tmp36_, _tmp37_);
#line 880 "minibuf.c"
		}
#line 117 "src/minibuf.vala"
		_completion_unref0 (cp);
#line 117 "src/minibuf.vala"
		_g_free0 (buf);
#line 886 "minibuf.c"
	}
#line 132 "src/minibuf.vala"
	result = p;
#line 132 "src/minibuf.vala"
	_g_free0 (a);
#line 132 "src/minibuf.vala"
	return result;
#line 894 "minibuf.c"
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
#line 147 "src/minibuf.vala"
	dup = g_new0 (gboolean, 1);
#line 147 "src/minibuf.vala"
	memcpy (dup, self, sizeof (gboolean));
#line 147 "src/minibuf.vala"
	return dup;
#line 907 "minibuf.c"
}

static gpointer
__bool_dup0 (gpointer self)
{
#line 147 "src/minibuf.vala"
	return self ? _bool_dup (self) : NULL;
#line 915 "minibuf.c"
}

gboolean*
minibuf_read_yesno (const gchar* fmt,
                    ...)
{
	gchar* errmsg = NULL;
	gchar* _tmp0_;
	Completion* cp = NULL;
	Completion* _tmp1_;
	gboolean* ret = NULL;
	Completion* _tmp2_;
	GeeSortedSet* _tmp3_;
	Completion* _tmp4_;
	GeeSortedSet* _tmp5_;
	gchar* ms = NULL;
	Completion* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	va_list _tmp9_ = {0};
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gboolean* result;
#line 135 "src/minibuf.vala"
	g_return_val_if_fail (fmt != NULL, NULL);
#line 136 "src/minibuf.vala"
	_tmp0_ = g_strdup ("Please answer yes or no.");
#line 136 "src/minibuf.vala"
	errmsg = _tmp0_;
#line 137 "src/minibuf.vala"
	_tmp1_ = completion_new (FALSE);
#line 137 "src/minibuf.vala"
	cp = _tmp1_;
#line 138 "src/minibuf.vala"
	ret = NULL;
#line 140 "src/minibuf.vala"
	_tmp2_ = cp;
#line 140 "src/minibuf.vala"
	_tmp3_ = _tmp2_->completions;
#line 140 "src/minibuf.vala"
	gee_collection_add ((GeeCollection*) _tmp3_, "no");
#line 141 "src/minibuf.vala"
	_tmp4_ = cp;
#line 141 "src/minibuf.vala"
	_tmp5_ = _tmp4_->completions;
#line 141 "src/minibuf.vala"
	gee_collection_add ((GeeCollection*) _tmp5_, "yes");
#line 143 "src/minibuf.vala"
	_tmp6_ = cp;
#line 143 "src/minibuf.vala"
	_tmp7_ = errmsg;
#line 143 "src/minibuf.vala"
	_tmp8_ = errmsg;
#line 143 "src/minibuf.vala"
	va_start (_tmp9_, fmt);
#line 143 "src/minibuf.vala"
	_tmp10_ = minibuf_vread_completion (fmt, "", _tmp6_, NULL, _tmp7_, _tmp8_, _tmp9_);
#line 143 "src/minibuf.vala"
	_tmp11_ = _tmp10_;
#line 143 "src/minibuf.vala"
	va_end (_tmp9_);
#line 143 "src/minibuf.vala"
	ms = _tmp11_;
#line 145 "src/minibuf.vala"
	_tmp12_ = ms;
#line 145 "src/minibuf.vala"
	if (_tmp12_ != NULL) {
#line 984 "minibuf.c"
		Completion* _tmp13_;
		GeeSortedSet* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gboolean _tmp17_;
		gboolean* _tmp18_;
#line 146 "src/minibuf.vala"
		_tmp13_ = cp;
#line 146 "src/minibuf.vala"
		_tmp14_ = _tmp13_->completions;
#line 146 "src/minibuf.vala"
		_tmp15_ = ms;
#line 146 "src/minibuf.vala"
		_vala_assert (gee_collection_contains ((GeeCollection*) _tmp14_, _tmp15_), "cp.completions.contains (ms)");
#line 147 "src/minibuf.vala"
		_tmp16_ = ms;
#line 147 "src/minibuf.vala"
		_tmp17_ = g_strcmp0 (_tmp16_, "yes") == 0;
#line 147 "src/minibuf.vala"
		_tmp18_ = __bool_dup0 (&_tmp17_);
#line 147 "src/minibuf.vala"
		_g_free0 (ret);
#line 147 "src/minibuf.vala"
		ret = _tmp18_;
#line 1009 "minibuf.c"
	}
#line 150 "src/minibuf.vala"
	result = ret;
#line 150 "src/minibuf.vala"
	_g_free0 (ms);
#line 150 "src/minibuf.vala"
	_completion_unref0 (cp);
#line 150 "src/minibuf.vala"
	_g_free0 (errmsg);
#line 150 "src/minibuf.vala"
	return result;
#line 1021 "minibuf.c"
}

gchar*
minibuf_read_completion (const gchar* fmt,
                         const gchar* val,
                         Completion* cp,
                         History* hp,
                         ...)
{
	va_list _tmp0_ = {0};
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
#line 153 "src/minibuf.vala"
	g_return_val_if_fail (fmt != NULL, NULL);
#line 153 "src/minibuf.vala"
	g_return_val_if_fail (val != NULL, NULL);
#line 154 "src/minibuf.vala"
	va_start (_tmp0_, hp);
#line 154 "src/minibuf.vala"
	_tmp1_ = g_strdup_vprintf (fmt, _tmp0_);
#line 154 "src/minibuf.vala"
	_tmp2_ = _tmp1_;
#line 154 "src/minibuf.vala"
	_tmp3_ = term_minibuf_read (_tmp2_, val, G_MAXLONG, cp, hp);
#line 154 "src/minibuf.vala"
	_tmp4_ = _tmp3_;
#line 154 "src/minibuf.vala"
	_g_free0 (_tmp2_);
#line 154 "src/minibuf.vala"
	va_end (_tmp0_);
#line 154 "src/minibuf.vala"
	result = _tmp4_;
#line 154 "src/minibuf.vala"
	return result;
#line 1059 "minibuf.c"
}

gchar*
minibuf_vread_completion (const gchar* fmt,
                          const gchar* val,
                          Completion* cp,
                          History* hp,
                          const gchar* empty_err,
                          const gchar* invalid_err,
                          va_list ap)
{
	gchar* ms = NULL;
	gchar* buf = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 160 "src/minibuf.vala"
	g_return_val_if_fail (fmt != NULL, NULL);
#line 160 "src/minibuf.vala"
	g_return_val_if_fail (val != NULL, NULL);
#line 160 "src/minibuf.vala"
	g_return_val_if_fail (cp != NULL, NULL);
#line 160 "src/minibuf.vala"
	g_return_val_if_fail (empty_err != NULL, NULL);
#line 160 "src/minibuf.vala"
	g_return_val_if_fail (invalid_err != NULL, NULL);
#line 163 "src/minibuf.vala"
	ms = NULL;
#line 164 "src/minibuf.vala"
	_tmp0_ = g_strdup_vprintf (fmt, ap);
#line 164 "src/minibuf.vala"
	buf = _tmp0_;
#line 1091 "minibuf.c"
	{
		gboolean _tmp1_ = FALSE;
#line 166 "src/minibuf.vala"
		_tmp1_ = TRUE;
#line 166 "src/minibuf.vala"
		while (TRUE) {
#line 1098 "minibuf.c"
			const gchar* _tmp2_;
			gchar* _tmp3_;
			const gchar* _tmp4_;
#line 166 "src/minibuf.vala"
			if (!_tmp1_) {
#line 1104 "minibuf.c"
			}
#line 166 "src/minibuf.vala"
			_tmp1_ = FALSE;
#line 167 "src/minibuf.vala"
			_tmp2_ = buf;
#line 167 "src/minibuf.vala"
			_tmp3_ = term_minibuf_read (_tmp2_, val, G_MAXLONG, cp, hp);
#line 167 "src/minibuf.vala"
			_g_free0 (ms);
#line 167 "src/minibuf.vala"
			ms = _tmp3_;
#line 169 "src/minibuf.vala"
			_tmp4_ = ms;
#line 169 "src/minibuf.vala"
			if (_tmp4_ == NULL) {
#line 170 "src/minibuf.vala"
				funcall ("keyboard-quit", NULL, NULL);
#line 171 "src/minibuf.vala"
				break;
#line 1124 "minibuf.c"
			} else {
				const gchar* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
#line 172 "src/minibuf.vala"
				_tmp5_ = ms;
#line 172 "src/minibuf.vala"
				_tmp6_ = strlen (_tmp5_);
#line 172 "src/minibuf.vala"
				_tmp7_ = _tmp6_;
#line 172 "src/minibuf.vala"
				if (_tmp7_ == 0) {
#line 173 "src/minibuf.vala"
					minibuf_error ("%s", empty_err, NULL);
#line 174 "src/minibuf.vala"
					_g_free0 (ms);
#line 174 "src/minibuf.vala"
					ms = NULL;
#line 175 "src/minibuf.vala"
					break;
#line 1145 "minibuf.c"
				} else {
					const gchar* _tmp8_;
					GeeSortedSet* _tmp11_;
					const gchar* _tmp12_;
#line 178 "src/minibuf.vala"
					_tmp8_ = ms;
#line 178 "src/minibuf.vala"
					if (completion_try (cp, _tmp8_, FALSE) == COMPLETION_CODE_matched) {
#line 1154 "minibuf.c"
						const gchar* _tmp9_;
						gchar* _tmp10_;
#line 179 "src/minibuf.vala"
						_tmp9_ = cp->match;
#line 179 "src/minibuf.vala"
						_tmp10_ = g_strdup (_tmp9_);
#line 179 "src/minibuf.vala"
						_g_free0 (ms);
#line 179 "src/minibuf.vala"
						ms = _tmp10_;
#line 1165 "minibuf.c"
					}
#line 181 "src/minibuf.vala"
					_tmp11_ = cp->completions;
#line 181 "src/minibuf.vala"
					_tmp12_ = ms;
#line 181 "src/minibuf.vala"
					if (gee_collection_contains ((GeeCollection*) _tmp11_, _tmp12_)) {
#line 182 "src/minibuf.vala"
						if (hp != NULL) {
#line 1175 "minibuf.c"
							const gchar* _tmp13_;
#line 183 "src/minibuf.vala"
							_tmp13_ = ms;
#line 183 "src/minibuf.vala"
							history_add_element (hp, _tmp13_);
#line 1181 "minibuf.c"
						}
#line 184 "src/minibuf.vala"
						minibuf_clear ();
#line 185 "src/minibuf.vala"
						break;
#line 1187 "minibuf.c"
					} else {
						const gchar* _tmp14_;
#line 187 "src/minibuf.vala"
						_tmp14_ = ms;
#line 187 "src/minibuf.vala"
						minibuf_error (invalid_err, _tmp14_, NULL);
#line 188 "src/minibuf.vala"
						waitkey ();
#line 1196 "minibuf.c"
					}
				}
			}
		}
	}
#line 193 "src/minibuf.vala"
	result = ms;
#line 193 "src/minibuf.vala"
	_g_free0 (buf);
#line 193 "src/minibuf.vala"
	return result;
#line 1208 "minibuf.c"
}

void
minibuf_clear (void)
{
#line 200 "src/minibuf.vala"
	term_minibuf_write ("");
#line 1216 "minibuf.c"
}

