/* funcs.c generated by valac 0.56.17, the Vala compiler
 * generated from funcs.vala, do not modify */

/* Miscellaneous Emacs functions

   Copyright (c) 1997-2021 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <estr.h>
#include <gee.h>
#include <signal.h>

#define GETKEY_DEFAULT -1
#define KBD_CTRL ((Keystroke) 01000)
#define KBD_CANCEL (KBD_CTRL | 'g')
#define KBD_META ((Keystroke) 02000)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef void (*BufferWriter) (gpointer user_data);

#define TYPE_WINDOW (window_get_type ())
#define WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WINDOW, Window))
#define WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WINDOW, WindowClass))
#define IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WINDOW))
#define IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WINDOW))
#define WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WINDOW, WindowClass))

typedef struct _Window Window;
typedef struct _WindowClass WindowClass;

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;
#define _window_unref0(var) ((var == NULL) ? NULL : (var = (window_unref (var), NULL)))
#define _buffer_unref0(var) ((var == NULL) ? NULL : (var = (buffer_unref (var), NULL)))
#define _immutable_estr_unref0(var) ((var == NULL) ? NULL : (var = (immutable_estr_unref (var), NULL)))
typedef struct _BufferPrivate BufferPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;

#define TYPE_UNDO (undo_get_type ())
#define UNDO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO, Undo))
#define UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO, UndoClass))
#define IS_UNDO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO))
#define IS_UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO))
#define UNDO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO, UndoClass))

typedef struct _Undo Undo;
typedef struct _UndoClass UndoClass;

#define TYPE_VAR_ENTRY (var_entry_get_type ())
#define VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAR_ENTRY, VarEntry))
#define VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAR_ENTRY, VarEntryClass))
#define IS_VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAR_ENTRY))
#define IS_VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAR_ENTRY))
#define VAR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAR_ENTRY, VarEntryClass))

typedef struct _VarEntry VarEntry;
typedef struct _VarEntryClass VarEntryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _WindowPrivate WindowPrivate;

#define TYPE_REGION (region_get_type ())
#define REGION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGION, Region))
#define REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGION, RegionClass))
#define IS_REGION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGION))
#define IS_REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGION))
#define REGION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGION, RegionClass))

typedef struct _Region Region;
typedef struct _RegionClass RegionClass;
#define _region_unref0(var) ((var == NULL) ? NULL : (var = (region_unref (var), NULL)))
typedef gboolean (*MovementNDelegate) (gpointer user_data, glong uniarg);
#define _marker_unref0(var) ((var == NULL) ? NULL : (var = (marker_unref (var), NULL)))
typedef gboolean (*Function) (glong uniarg, GeeQueue* args);
typedef gboolean (*MovementDelegate) (gpointer user_data);
typedef enum  {
	CASE_upper = 1,
	CASE_lower,
	CASE_capitalized
} Case;

#define TYPE_CASE (case_get_type ())
typedef gchar (*CharTransform) (gchar c, gpointer user_data);

#define TYPE_LISP_FUNC (lisp_func_get_type ())
#define LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISP_FUNC, LispFunc))
#define LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISP_FUNC, LispFuncClass))
#define IS_LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISP_FUNC))
#define IS_LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISP_FUNC))
#define LISP_FUNC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISP_FUNC, LispFuncClass))

typedef struct _LispFunc LispFunc;
typedef struct _LispFuncClass LispFuncClass;
#define _lisp_func_unref0(var) ((var == NULL) ? NULL : (var = (lisp_func_unref (var), NULL)))
typedef enum  {
	FLAGS_NEED_RESYNC = 1 << 0,
	FLAGS_SET_UNIARG = 1 << 1,
	FLAGS_UNIARG_EMPTY = 1 << 2,
	FLAGS_DEFINING_MACRO = 1 << 3
} Flags;

#define TYPE_FLAGS (flags_get_type ())
typedef guint Keystroke;
typedef struct _LispFuncPrivate LispFuncPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Buffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BufferPrivate * priv;
	gchar* name;
	gchar* filename;
	Buffer* next;
	gsize goalc;
	Marker* mark;
	Marker* markers;
	GList* last_undop;
	GList* next_undop;
	GHashTable* vars;
	gboolean modified;
	gboolean nosave;
	gboolean needname;
	gboolean temporary;
	gboolean readonly;
	gboolean backup;
	gboolean noundo;
	gboolean autofill;
	gboolean isearch;
	gboolean mark_active;
	gchar* dir;
};

struct _BufferClass {
	GTypeClass parent_class;
	void (*finalize) (Buffer *self);
	gsize (*get_length) (Buffer* self);
	const gchar* (*get_eol) (Buffer* self);
};

struct _Window {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WindowPrivate * priv;
	Window* next;
	Buffer* bp;
	gsize topdelta;
	gsize start_column;
	Marker* saved_pt;
	gsize fwidth;
	gsize fheight;
	gsize ewidth;
	gsize eheight;
	gboolean all_displayed;
	gsize lastpointn;
};

struct _WindowClass {
	GTypeClass parent_class;
	void (*finalize) (Window *self);
};

struct _LispFunc {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LispFuncPrivate * priv;
	gchar* name;
	Function func;
	gboolean interactive;
	gchar* doc;
};

struct _LispFuncClass {
	GTypeClass parent_class;
	void (*finalize) (LispFunc *self);
};

VALA_EXTERN Window* cur_wp;
VALA_EXTERN Buffer* cur_bp;
VALA_EXTERN Buffer* head_bp;
VALA_EXTERN Flags lastflag;
VALA_EXTERN Flags thisflag;
VALA_EXTERN gint last_uniarg;

VALA_EXTERN void write_temp_buffer (const gchar* name,
                        gboolean show,
                        BufferWriter func,
                        gpointer func_target);
VALA_EXTERN gpointer window_ref (gpointer instance);
VALA_EXTERN void window_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_window (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_window (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_window (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_window (const GValue* value);
VALA_EXTERN GType window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Window, window_unref)
VALA_EXTERN gpointer buffer_ref (gpointer instance);
VALA_EXTERN void buffer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_buffer (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_buffer (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_buffer (const GValue* value);
VALA_EXTERN GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
VALA_EXTERN Window* window_find (const gchar* name);
VALA_EXTERN void window_set_current (Window* self);
VALA_EXTERN Buffer* buffer_find (const gchar* name);
VALA_EXTERN Window* popup_window (void);
VALA_EXTERN Buffer* buffer_new (Estr* es);
VALA_EXTERN Buffer* buffer_construct (GType object_type,
                          Estr* es);
VALA_EXTERN gpointer marker_ref (gpointer instance);
VALA_EXTERN void marker_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_marker (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_marker (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_marker (const GValue* value);
VALA_EXTERN GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
VALA_EXTERN gpointer undo_ref (gpointer instance);
VALA_EXTERN void undo_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_undo (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_undo (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_undo (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_undo (const GValue* value);
VALA_EXTERN GType undo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Undo, undo_unref)
VALA_EXTERN gpointer var_entry_ref (gpointer instance);
VALA_EXTERN void var_entry_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_var_entry (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_var_entry (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_var_entry (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_var_entry (const GValue* value);
VALA_EXTERN GType var_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VarEntry, var_entry_unref)
VALA_EXTERN void buffer_switch_to (Buffer* self);
VALA_EXTERN void buffer_kill (Buffer* self);
VALA_EXTERN void buffer_set_temporary (Buffer* self);
VALA_EXTERN gboolean funcall (const gchar* name,
                  glong* maybe_uniarg,
                  GeeQueue* args);
VALA_EXTERN gboolean iswordchar (gchar c);
VALA_EXTERN gboolean isopenbracketchar (gchar c,
                            gboolean single_quote,
                            gboolean double_quote);
VALA_EXTERN gboolean isclosebracketchar (gchar c,
                             gboolean single_quote,
                             gboolean double_quote);
VALA_EXTERN void estr_append_region (Estr* es);
VALA_EXTERN gpointer region_ref (gpointer instance);
VALA_EXTERN void region_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_region (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_region (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_region (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_region (const GValue* value);
VALA_EXTERN GType region_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Region, region_unref)
VALA_EXTERN ImmutableEstr* buffer_get_region (Buffer* self,
                                  Region* r);
VALA_EXTERN Region* region_calculate (void);
VALA_EXTERN gboolean transpose_subr (MovementNDelegate move_func,
                         gpointer move_func_target);
VALA_EXTERN gboolean buffer_move_char (Buffer* self,
                           glong offset);
VALA_EXTERN gboolean buffer_eolp (Buffer* self);
VALA_EXTERN gboolean buffer_move_line (Buffer* self,
                           glong n);
VALA_EXTERN gsize buffer_line_o (Buffer* self);
VALA_EXTERN void minibuf_error (const gchar* fmt,
                    ...);
VALA_EXTERN void push_mark (void);
VALA_EXTERN Marker* marker_point (void);
VALA_EXTERN void pop_mark (void);
VALA_EXTERN void buffer_goto_offset (Buffer* self,
                         gsize o);
VALA_EXTERN gsize marker_get_o (Marker* self);
VALA_EXTERN void marker_unchain (Marker* self);
VALA_EXTERN const gchar* buffer_get_eol (Buffer* self);
VALA_EXTERN void set_mark (void);
VALA_EXTERN gboolean buffer_insert_estr (Buffer* self,
                             ImmutableEstr* es);
VALA_EXTERN gboolean transpose (glong uniarg,
                    MovementNDelegate move,
                    gpointer move_target);
VALA_EXTERN gboolean buffer_warn_if_readonly (Buffer* self);
VALA_EXTERN gboolean mark (glong uniarg,
               Function func);
VALA_EXTERN gboolean move_paragraph (glong uniarg,
                         MovementDelegate forward,
                         gpointer forward_target,
                         MovementDelegate backward,
                         gpointer backward_target,
                         Function line_extremum);
VALA_EXTERN gboolean buffer_is_empty_line (Buffer* self);
VALA_EXTERN GType case_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* recase (const gchar* s,
               Case rcase);
VALA_EXTERN gboolean setcase_word (Case rcase);
VALA_EXTERN gchar buffer_following_char (Buffer* self);
VALA_EXTERN gboolean buffer_move_word (Buffer* self,
                           glong dir);
VALA_EXTERN gsize buffer_get_pt (Buffer* self);
VALA_EXTERN gsize buffer_line_len (Buffer* self,
                       gsize o);
VALA_EXTERN gchar buffer_get_char (Buffer* self,
                       gsize o);
VALA_EXTERN gboolean buffer_replace_estr (Buffer* self,
                              gsize del,
                              ImmutableEstr* es);
VALA_EXTERN gboolean setcase_word_lowercase (void);
VALA_EXTERN gboolean setcase_word_uppercase (void);
VALA_EXTERN gboolean setcase_word_capitalize (void);
VALA_EXTERN gboolean setcase_region (CharTransform func,
                         gpointer func_target);
VALA_EXTERN gboolean buffer_warn_if_no_mark (Buffer* self);
VALA_EXTERN gsize region_get_start (Region* self);
VALA_EXTERN gsize region_size (Region* self);
VALA_EXTERN gboolean buffer_delete_char (Buffer* self);
VALA_EXTERN gboolean buffer_insert_char (Buffer* self,
                             gchar c);
VALA_EXTERN void funcs_init (void);
static gboolean __lambda46_ (glong uniarg,
                      GeeQueue* args);
static void __lambda47_ (void);
VALA_EXTERN void bprintf (const gchar* fmt,
              ...);
VALA_EXTERN gsize buffer_get_length (Buffer* self);
VALA_EXTERN gchar* compact_path (const gchar* in_path);
VALA_EXTERN gboolean insert_newline (void);
static void ___lambda47__buffer_writer (gpointer self);
static gboolean ___lambda46__function (glong uniarg,
                                GeeQueue* args);
VALA_EXTERN LispFunc* lisp_func_new (const gchar* name,
                         Function func,
                         gboolean interactive,
                         const gchar* doc);
VALA_EXTERN LispFunc* lisp_func_construct (GType object_type,
                               const gchar* name,
                               Function func,
                               gboolean interactive,
                               const gchar* doc);
VALA_EXTERN gpointer lisp_func_ref (gpointer instance);
VALA_EXTERN void lisp_func_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_lisp_func (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_lisp_func (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_lisp_func (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_lisp_func (const GValue* value);
VALA_EXTERN GType lisp_func_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LispFunc, lisp_func_unref)
static gboolean __lambda48_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda48__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda49_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda49__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda50_ (glong uniarg,
                      GeeQueue* args);
VALA_EXTERN GType flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean noarg (GeeQueue* args);
VALA_EXTERN glong minibuf_read_number (const gchar* fmt,
                           ...);
VALA_EXTERN void minibuf_write (const gchar* fmt,
                    ...);
VALA_EXTERN const gchar* get_variable (const gchar* name);
VALA_EXTERN void set_variable (const gchar* name,
                   const gchar* val);
static gboolean ___lambda50__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda51_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda51__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda52_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda52__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda53_ (glong uniarg,
                      GeeQueue* args);
VALA_EXTERN void marker_set_o (Marker* self,
                   gsize value);
static gboolean ___lambda53__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda54_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda54__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda55_ (glong uniarg,
                      GeeQueue* args);
VALA_EXTERN Keystroke getkey_unfiltered (gint mode);
VALA_EXTERN void minibuf_clear (void);
static gboolean ___lambda55__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda56_ (glong uniarg,
                      GeeQueue* args);
VALA_EXTERN void pushkey (Keystroke key);
VALA_EXTERN Keystroke lastkey (void);
VALA_EXTERN Keystroke binding_completion (const gchar* a);
VALA_EXTERN void ungetkey (Keystroke key);
static gboolean ___lambda56__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda57_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda57__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda58_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda58__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda59_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda59__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda60_ (glong uniarg,
                      GeeQueue* args);
VALA_EXTERN gboolean move_with_uniarg (glong uniarg,
                           MovementNDelegate move,
                           gpointer move_target);
static gboolean ___lambda60__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda61_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda61__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda62_ (glong uniarg,
                      GeeQueue* args);
VALA_EXTERN gboolean buffer_move_sexp (Buffer* self,
                           glong dir);
static gboolean ___lambda62__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda63_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda63__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda64_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda64__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda65_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda65__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda66_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda66__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda67_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda67__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda68_ (glong uniarg,
                      GeeQueue* args);
VALA_EXTERN LispFunc* lisp_func_find (const gchar* name);
static gboolean ___lambda68__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda69_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda69__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda70_ (glong uniarg,
                      GeeQueue* args);
VALA_EXTERN gboolean int_or_uniarg (GeeQueue* args,
                        glong* n,
                        glong uniarg);
static gboolean ___lambda70__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda71_ (glong uniarg,
                      GeeQueue* args);
static gboolean __lambda72_ (void);
static gboolean ___lambda72__movement_delegate (gpointer self);
static gboolean __lambda73_ (void);
static gboolean ___lambda73__movement_delegate (gpointer self);
static gboolean ___lambda71__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda74_ (glong uniarg,
                      GeeQueue* args);
static gboolean __lambda75_ (void);
static gboolean ___lambda75__movement_delegate (gpointer self);
static gboolean __lambda76_ (void);
static gboolean ___lambda76__movement_delegate (gpointer self);
static gboolean ___lambda74__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda77_ (glong uniarg,
                      GeeQueue* args);
VALA_EXTERN LispFunc* last_command (void);
static gboolean ___lambda77__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda78_ (glong uniarg,
                      GeeQueue* args);
VALA_EXTERN gsize buffer_end_of_line (Buffer* self,
                          gsize o);
static gboolean* _bool_dup (gboolean* self);
VALA_EXTERN gboolean* fill_break_line (void);
static gboolean _bool_equal (const gboolean * s1,
                      const gboolean * s2);
static gboolean ___lambda78__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda79_ (glong uniarg,
                      GeeQueue* args);
VALA_EXTERN gboolean execute_with_uniarg (glong uniarg,
                              MovementDelegate forward,
                              gpointer forward_target,
                              MovementDelegate backward,
                              gpointer backward_target);
static gboolean _setcase_word_lowercase_movement_delegate (gpointer self);
static gboolean ___lambda79__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda80_ (glong uniarg,
                      GeeQueue* args);
static gboolean _setcase_word_uppercase_movement_delegate (gpointer self);
static gboolean ___lambda80__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda81_ (glong uniarg,
                      GeeQueue* args);
static gboolean _setcase_word_capitalize_movement_delegate (gpointer self);
static gboolean ___lambda81__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda82_ (glong uniarg,
                      GeeQueue* args);
static gchar __lambda83_ (gchar c);
static gchar ___lambda83__char_transform (gchar c,
                                   gpointer self);
static gboolean ___lambda82__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda84_ (glong uniarg,
                      GeeQueue* args);
static gchar __lambda85_ (gchar c);
static gchar ___lambda85__char_transform (gchar c,
                                   gpointer self);
static gboolean ___lambda84__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda86_ (glong uniarg,
                      GeeQueue* args);
VALA_EXTERN gboolean region_delete (Region* self);
static gboolean ___lambda86__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda87_ (glong uniarg,
                      GeeQueue* args);
VALA_EXTERN Region* region_new (gsize o1,
                    gsize o2);
VALA_EXTERN Region* region_construct (GType object_type,
                          gsize o1,
                          gsize o2);
VALA_EXTERN gboolean buffer_is_blank_line (Buffer* self);
VALA_EXTERN void region_set_start (Region* self,
                       gsize value);
VALA_EXTERN gsize buffer_next_line (Buffer* self,
                        gsize o);
VALA_EXTERN void region_set_end (Region* self,
                     gsize value);
VALA_EXTERN gsize region_get_end (Region* self);
VALA_EXTERN gboolean intercalate_newline (void);
static gboolean ___lambda87__function (glong uniarg,
                                GeeQueue* args);

static gpointer
_window_ref0 (gpointer self)
{
#line 24 "src/funcs.vala"
	return self ? window_ref (self) : NULL;
#line 656 "funcs.c"
}

static gpointer
_buffer_ref0 (gpointer self)
{
#line 25 "src/funcs.vala"
	return self ? buffer_ref (self) : NULL;
#line 664 "funcs.c"
}

void
write_temp_buffer (const gchar* name,
                   gboolean show,
                   BufferWriter func,
                   gpointer func_target)
{
	Window* old_wp = NULL;
	Window* _tmp0_;
	Window* _tmp1_;
	Buffer* old_bp = NULL;
	Buffer* _tmp2_;
	Buffer* _tmp3_;
	Window* wp = NULL;
	Window* _tmp4_;
	gboolean _tmp5_ = FALSE;
	Buffer* new_bp = NULL;
	Estr* _tmp18_;
	Estr* _tmp19_;
	Buffer* _tmp20_;
	Buffer* _tmp21_;
	Buffer* _tmp22_;
	Buffer* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	Buffer* _tmp26_;
	Buffer* _tmp27_;
	Buffer* _tmp28_;
	Window* _tmp29_;
	Buffer* _tmp30_;
	Buffer* _tmp31_;
	Buffer* _tmp32_;
	Buffer* _tmp33_;
	Buffer* _tmp34_;
	Buffer* _tmp35_;
	Buffer* _tmp36_;
	Buffer* _tmp37_;
	Window* _tmp38_;
#line 22 "src/funcs.vala"
	g_return_if_fail (name != NULL);
#line 24 "src/funcs.vala"
	_tmp0_ = cur_wp;
#line 24 "src/funcs.vala"
	_tmp1_ = _window_ref0 (_tmp0_);
#line 24 "src/funcs.vala"
	old_wp = _tmp1_;
#line 25 "src/funcs.vala"
	_tmp2_ = cur_bp;
#line 25 "src/funcs.vala"
	_tmp3_ = _buffer_ref0 (_tmp2_);
#line 25 "src/funcs.vala"
	old_bp = _tmp3_;
#line 26 "src/funcs.vala"
	_tmp4_ = window_find (name);
#line 26 "src/funcs.vala"
	wp = _tmp4_;
#line 27 "src/funcs.vala"
	if (show) {
#line 724 "funcs.c"
		Window* _tmp6_;
#line 27 "src/funcs.vala"
		_tmp6_ = wp;
#line 27 "src/funcs.vala"
		_tmp5_ = _tmp6_ != NULL;
#line 730 "funcs.c"
	} else {
#line 27 "src/funcs.vala"
		_tmp5_ = FALSE;
#line 734 "funcs.c"
	}
#line 27 "src/funcs.vala"
	if (_tmp5_) {
#line 738 "funcs.c"
		Window* _tmp7_;
#line 28 "src/funcs.vala"
		_tmp7_ = wp;
#line 28 "src/funcs.vala"
		window_set_current (_tmp7_);
#line 744 "funcs.c"
	} else {
		Buffer* bp = NULL;
		Buffer* _tmp8_;
		Buffer* _tmp11_;
		Buffer* _tmp17_;
#line 30 "src/funcs.vala"
		_tmp8_ = buffer_find (name);
#line 30 "src/funcs.vala"
		bp = _tmp8_;
#line 31 "src/funcs.vala"
		if (show) {
#line 756 "funcs.c"
			Window* _tmp9_;
			Window* _tmp10_;
#line 32 "src/funcs.vala"
			_tmp9_ = popup_window ();
#line 32 "src/funcs.vala"
			_tmp10_ = _tmp9_;
#line 32 "src/funcs.vala"
			window_set_current (_tmp10_);
#line 32 "src/funcs.vala"
			_window_unref0 (_tmp10_);
#line 767 "funcs.c"
		}
#line 33 "src/funcs.vala"
		_tmp11_ = bp;
#line 33 "src/funcs.vala"
		if (_tmp11_ == NULL) {
#line 773 "funcs.c"
			Estr* _tmp12_;
			Estr* _tmp13_;
			Buffer* _tmp14_;
			Buffer* _tmp15_;
			gchar* _tmp16_;
#line 34 "src/funcs.vala"
			_tmp12_ = estr_of_empty (IMMUTABLE_ESTR_eol_lf);
#line 34 "src/funcs.vala"
			_tmp13_ = _tmp12_;
#line 34 "src/funcs.vala"
			_tmp14_ = buffer_new (_tmp13_);
#line 34 "src/funcs.vala"
			_buffer_unref0 (bp);
#line 34 "src/funcs.vala"
			bp = _tmp14_;
#line 34 "src/funcs.vala"
			_immutable_estr_unref0 (_tmp13_);
#line 35 "src/funcs.vala"
			_tmp15_ = bp;
#line 35 "src/funcs.vala"
			_tmp16_ = g_strdup (name);
#line 35 "src/funcs.vala"
			_g_free0 (_tmp15_->name);
#line 35 "src/funcs.vala"
			_tmp15_->name = _tmp16_;
#line 799 "funcs.c"
		}
#line 37 "src/funcs.vala"
		_tmp17_ = bp;
#line 37 "src/funcs.vala"
		buffer_switch_to (_tmp17_);
#line 27 "src/funcs.vala"
		_buffer_unref0 (bp);
#line 807 "funcs.c"
	}
#line 41 "src/funcs.vala"
	_tmp18_ = estr_of_empty (IMMUTABLE_ESTR_eol_lf);
#line 41 "src/funcs.vala"
	_tmp19_ = _tmp18_;
#line 41 "src/funcs.vala"
	_tmp20_ = buffer_new (_tmp19_);
#line 41 "src/funcs.vala"
	_tmp21_ = _tmp20_;
#line 41 "src/funcs.vala"
	_immutable_estr_unref0 (_tmp19_);
#line 41 "src/funcs.vala"
	new_bp = _tmp21_;
#line 42 "src/funcs.vala"
	_tmp22_ = new_bp;
#line 42 "src/funcs.vala"
	_tmp23_ = cur_bp;
#line 42 "src/funcs.vala"
	_tmp24_ = _tmp23_->name;
#line 42 "src/funcs.vala"
	_tmp25_ = g_strdup (_tmp24_);
#line 42 "src/funcs.vala"
	_g_free0 (_tmp22_->name);
#line 42 "src/funcs.vala"
	_tmp22_->name = _tmp25_;
#line 43 "src/funcs.vala"
	_tmp26_ = cur_bp;
#line 43 "src/funcs.vala"
	buffer_kill (_tmp26_);
#line 44 "src/funcs.vala"
	_tmp27_ = new_bp;
#line 44 "src/funcs.vala"
	_tmp28_ = _buffer_ref0 (_tmp27_);
#line 44 "src/funcs.vala"
	_buffer_unref0 (cur_bp);
#line 44 "src/funcs.vala"
	cur_bp = _tmp28_;
#line 45 "src/funcs.vala"
	_tmp29_ = cur_wp;
#line 45 "src/funcs.vala"
	_tmp30_ = cur_bp;
#line 45 "src/funcs.vala"
	_tmp31_ = _buffer_ref0 (_tmp30_);
#line 45 "src/funcs.vala"
	_buffer_unref0 (_tmp29_->bp);
#line 45 "src/funcs.vala"
	_tmp29_->bp = _tmp31_;
#line 48 "src/funcs.vala"
	_tmp32_ = cur_bp;
#line 48 "src/funcs.vala"
	_tmp32_->needname = TRUE;
#line 49 "src/funcs.vala"
	_tmp33_ = cur_bp;
#line 49 "src/funcs.vala"
	_tmp33_->noundo = TRUE;
#line 50 "src/funcs.vala"
	_tmp34_ = cur_bp;
#line 50 "src/funcs.vala"
	_tmp34_->nosave = TRUE;
#line 51 "src/funcs.vala"
	_tmp35_ = cur_bp;
#line 51 "src/funcs.vala"
	buffer_set_temporary (_tmp35_);
#line 54 "src/funcs.vala"
	func (func_target);
#line 56 "src/funcs.vala"
	funcall ("beginning-of-buffer", NULL, NULL);
#line 57 "src/funcs.vala"
	_tmp36_ = cur_bp;
#line 57 "src/funcs.vala"
	_tmp36_->readonly = TRUE;
#line 58 "src/funcs.vala"
	_tmp37_ = cur_bp;
#line 58 "src/funcs.vala"
	_tmp37_->modified = FALSE;
#line 61 "src/funcs.vala"
	_tmp38_ = old_wp;
#line 61 "src/funcs.vala"
	window_set_current (_tmp38_);
#line 64 "src/funcs.vala"
	if (!show) {
#line 889 "funcs.c"
		Buffer* _tmp39_;
#line 65 "src/funcs.vala"
		_tmp39_ = old_bp;
#line 65 "src/funcs.vala"
		buffer_switch_to (_tmp39_);
#line 895 "funcs.c"
	}
#line 22 "src/funcs.vala"
	_buffer_unref0 (new_bp);
#line 22 "src/funcs.vala"
	_window_unref0 (wp);
#line 22 "src/funcs.vala"
	_buffer_unref0 (old_bp);
#line 22 "src/funcs.vala"
	_window_unref0 (old_wp);
#line 905 "funcs.c"
}

/***********************************************************************
                          Move through words
***********************************************************************/
gboolean
iswordchar (gchar c)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 72 "src/funcs.vala"
	if (g_ascii_isalnum (c)) {
#line 72 "src/funcs.vala"
		_tmp0_ = TRUE;
#line 920 "funcs.c"
	} else {
#line 72 "src/funcs.vala"
		_tmp0_ = c == '$';
#line 924 "funcs.c"
	}
#line 72 "src/funcs.vala"
	result = _tmp0_;
#line 72 "src/funcs.vala"
	return result;
#line 930 "funcs.c"
}

/***********************************************************************
               Move through balanced expressions (sexps)
***********************************************************************/
gboolean
isopenbracketchar (gchar c,
                   gboolean single_quote,
                   gboolean double_quote)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean result;
#line 79 "src/funcs.vala"
	if (c == '(') {
#line 79 "src/funcs.vala"
		_tmp3_ = TRUE;
#line 950 "funcs.c"
	} else {
#line 79 "src/funcs.vala"
		_tmp3_ = c == '[';
#line 954 "funcs.c"
	}
#line 79 "src/funcs.vala"
	if (_tmp3_) {
#line 79 "src/funcs.vala"
		_tmp2_ = TRUE;
#line 960 "funcs.c"
	} else {
#line 79 "src/funcs.vala"
		_tmp2_ = c == '{';
#line 964 "funcs.c"
	}
#line 79 "src/funcs.vala"
	if (_tmp2_) {
#line 79 "src/funcs.vala"
		_tmp1_ = TRUE;
#line 970 "funcs.c"
	} else {
		gboolean _tmp4_ = FALSE;
#line 80 "src/funcs.vala"
		if (c == '\"') {
#line 80 "src/funcs.vala"
			_tmp4_ = !double_quote;
#line 977 "funcs.c"
		} else {
#line 80 "src/funcs.vala"
			_tmp4_ = FALSE;
#line 981 "funcs.c"
		}
#line 80 "src/funcs.vala"
		_tmp1_ = _tmp4_;
#line 985 "funcs.c"
	}
#line 79 "src/funcs.vala"
	if (_tmp1_) {
#line 79 "src/funcs.vala"
		_tmp0_ = TRUE;
#line 991 "funcs.c"
	} else {
		gboolean _tmp5_ = FALSE;
#line 81 "src/funcs.vala"
		if (c == '\'') {
#line 81 "src/funcs.vala"
			_tmp5_ = !single_quote;
#line 998 "funcs.c"
		} else {
#line 81 "src/funcs.vala"
			_tmp5_ = FALSE;
#line 1002 "funcs.c"
		}
#line 81 "src/funcs.vala"
		_tmp0_ = _tmp5_;
#line 1006 "funcs.c"
	}
#line 79 "src/funcs.vala"
	result = _tmp0_;
#line 79 "src/funcs.vala"
	return result;
#line 1012 "funcs.c"
}

gboolean
isclosebracketchar (gchar c,
                    gboolean single_quote,
                    gboolean double_quote)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean result;
#line 85 "src/funcs.vala"
	if (c == ')') {
#line 85 "src/funcs.vala"
		_tmp3_ = TRUE;
#line 1029 "funcs.c"
	} else {
#line 85 "src/funcs.vala"
		_tmp3_ = c == ']';
#line 1033 "funcs.c"
	}
#line 85 "src/funcs.vala"
	if (_tmp3_) {
#line 85 "src/funcs.vala"
		_tmp2_ = TRUE;
#line 1039 "funcs.c"
	} else {
#line 85 "src/funcs.vala"
		_tmp2_ = c == '}';
#line 1043 "funcs.c"
	}
#line 85 "src/funcs.vala"
	if (_tmp2_) {
#line 85 "src/funcs.vala"
		_tmp1_ = TRUE;
#line 1049 "funcs.c"
	} else {
		gboolean _tmp4_ = FALSE;
#line 86 "src/funcs.vala"
		if (c == '\"') {
#line 86 "src/funcs.vala"
			_tmp4_ = double_quote;
#line 1056 "funcs.c"
		} else {
#line 86 "src/funcs.vala"
			_tmp4_ = FALSE;
#line 1060 "funcs.c"
		}
#line 86 "src/funcs.vala"
		_tmp1_ = _tmp4_;
#line 1064 "funcs.c"
	}
#line 85 "src/funcs.vala"
	if (_tmp1_) {
#line 85 "src/funcs.vala"
		_tmp0_ = TRUE;
#line 1070 "funcs.c"
	} else {
		gboolean _tmp5_ = FALSE;
#line 87 "src/funcs.vala"
		if (c == '\'') {
#line 87 "src/funcs.vala"
			_tmp5_ = single_quote;
#line 1077 "funcs.c"
		} else {
#line 87 "src/funcs.vala"
			_tmp5_ = FALSE;
#line 1081 "funcs.c"
		}
#line 87 "src/funcs.vala"
		_tmp0_ = _tmp5_;
#line 1085 "funcs.c"
	}
#line 85 "src/funcs.vala"
	result = _tmp0_;
#line 85 "src/funcs.vala"
	return result;
#line 1091 "funcs.c"
}

/***********************************************************************
                          Transpose functions
***********************************************************************/
void
estr_append_region (Estr* es)
{
	Buffer* _tmp0_;
	Buffer* _tmp1_;
	Region* _tmp2_;
	Region* _tmp3_;
	ImmutableEstr* _tmp4_;
	ImmutableEstr* _tmp5_;
#line 93 "src/funcs.vala"
	g_return_if_fail (es != NULL);
#line 94 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 94 "src/funcs.vala"
	_tmp0_->mark_active = TRUE;
#line 95 "src/funcs.vala"
	_tmp1_ = cur_bp;
#line 95 "src/funcs.vala"
	_tmp2_ = region_calculate ();
#line 95 "src/funcs.vala"
	_tmp3_ = _tmp2_;
#line 95 "src/funcs.vala"
	_tmp4_ = buffer_get_region (_tmp1_, _tmp3_);
#line 95 "src/funcs.vala"
	_tmp5_ = _tmp4_;
#line 95 "src/funcs.vala"
	estr_cat (es, _tmp5_);
#line 95 "src/funcs.vala"
	_immutable_estr_unref0 (_tmp5_);
#line 95 "src/funcs.vala"
	_region_unref0 (_tmp3_);
#line 1128 "funcs.c"
}

gboolean
transpose_subr (MovementNDelegate move_func,
                gpointer move_func_target)
{
	gboolean _tmp0_ = FALSE;
	Buffer* _tmp1_;
	MovementNDelegate _tmp2_;
	gpointer _tmp2__target;
	GDestroyNotify _tmp2__target_destroy_notify;
	gboolean _tmp3_;
	gboolean _tmp5_ = FALSE;
	Buffer* _tmp6_;
	MovementNDelegate _tmp7_;
	gpointer _tmp7__target;
	GDestroyNotify _tmp7__target_destroy_notify;
	gboolean _tmp8_;
	Marker* m1 = NULL;
	Marker* _tmp10_;
	gboolean _tmp11_ = FALSE;
	Buffer* _tmp20_;
	Marker* _tmp21_;
	gsize _tmp22_;
	gsize _tmp23_;
	Estr* es1 = NULL;
	Buffer* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	Estr* _tmp27_;
	Estr* _tmp28_;
	Estr* es2 = NULL;
	Marker* m2 = NULL;
	Buffer* _tmp29_;
	MovementNDelegate _tmp30_;
	gpointer _tmp30__target;
	GDestroyNotify _tmp30__target_destroy_notify;
	gboolean _tmp31_;
	Buffer* _tmp39_;
	Marker* _tmp40_;
	gsize _tmp41_;
	gsize _tmp42_;
	Marker* _tmp43_;
	Buffer* _tmp44_;
	Estr* _tmp45_;
	Estr* _tmp46_;
	Marker* _tmp53_;
	Buffer* _tmp54_;
	Buffer* _tmp55_;
	MovementNDelegate _tmp56_;
	gpointer _tmp56__target;
	GDestroyNotify _tmp56__target_destroy_notify;
	gboolean _tmp57_;
	gboolean result;
#line 100 "src/funcs.vala"
	_tmp1_ = cur_bp;
#line 100 "src/funcs.vala"
	_tmp2_ = (MovementNDelegate) buffer_move_char;
#line 100 "src/funcs.vala"
	_tmp2__target = buffer_ref (_tmp1_);
#line 100 "src/funcs.vala"
	_tmp2__target_destroy_notify = buffer_unref;
#line 100 "src/funcs.vala"
	_tmp3_ = move_func == _tmp2_;
#line 100 "src/funcs.vala"
	(_tmp2__target_destroy_notify == NULL) ? NULL : (_tmp2__target_destroy_notify (_tmp2__target), NULL);
#line 100 "src/funcs.vala"
	_tmp2_ = NULL;
#line 100 "src/funcs.vala"
	_tmp2__target = NULL;
#line 100 "src/funcs.vala"
	_tmp2__target_destroy_notify = NULL;
#line 100 "src/funcs.vala"
	if (_tmp3_) {
#line 1203 "funcs.c"
		Buffer* _tmp4_;
#line 100 "src/funcs.vala"
		_tmp4_ = cur_bp;
#line 100 "src/funcs.vala"
		_tmp0_ = buffer_eolp (_tmp4_);
#line 1209 "funcs.c"
	} else {
#line 100 "src/funcs.vala"
		_tmp0_ = FALSE;
#line 1213 "funcs.c"
	}
#line 100 "src/funcs.vala"
	if (_tmp0_) {
#line 101 "src/funcs.vala"
		move_func (move_func_target, (glong) -1);
#line 1219 "funcs.c"
	}
#line 104 "src/funcs.vala"
	_tmp6_ = cur_bp;
#line 104 "src/funcs.vala"
	_tmp7_ = (MovementNDelegate) buffer_move_line;
#line 104 "src/funcs.vala"
	_tmp7__target = buffer_ref (_tmp6_);
#line 104 "src/funcs.vala"
	_tmp7__target_destroy_notify = buffer_unref;
#line 104 "src/funcs.vala"
	_tmp8_ = move_func == _tmp7_;
#line 104 "src/funcs.vala"
	(_tmp7__target_destroy_notify == NULL) ? NULL : (_tmp7__target_destroy_notify (_tmp7__target), NULL);
#line 104 "src/funcs.vala"
	_tmp7_ = NULL;
#line 104 "src/funcs.vala"
	_tmp7__target = NULL;
#line 104 "src/funcs.vala"
	_tmp7__target_destroy_notify = NULL;
#line 104 "src/funcs.vala"
	if (_tmp8_) {
#line 1241 "funcs.c"
		Buffer* _tmp9_;
#line 104 "src/funcs.vala"
		_tmp9_ = cur_bp;
#line 104 "src/funcs.vala"
		_tmp5_ = buffer_line_o (_tmp9_) == ((gsize) 0);
#line 1247 "funcs.c"
	} else {
#line 104 "src/funcs.vala"
		_tmp5_ = FALSE;
#line 1251 "funcs.c"
	}
#line 104 "src/funcs.vala"
	if (_tmp5_) {
#line 105 "src/funcs.vala"
		move_func (move_func_target, (glong) 1);
#line 1257 "funcs.c"
	}
#line 108 "src/funcs.vala"
	if (!move_func (move_func_target, (glong) -1)) {
#line 109 "src/funcs.vala"
		minibuf_error ("Beginning of buffer", NULL);
#line 110 "src/funcs.vala"
		result = FALSE;
#line 110 "src/funcs.vala"
		return result;
#line 1267 "funcs.c"
	}
#line 114 "src/funcs.vala"
	push_mark ();
#line 115 "src/funcs.vala"
	_tmp10_ = marker_point ();
#line 115 "src/funcs.vala"
	m1 = _tmp10_;
#line 118 "src/funcs.vala"
	if (!move_func (move_func_target, (glong) 1)) {
#line 118 "src/funcs.vala"
		_tmp11_ = TRUE;
#line 1279 "funcs.c"
	} else {
#line 118 "src/funcs.vala"
		_tmp11_ = !move_func (move_func_target, (glong) 1);
#line 1283 "funcs.c"
	}
#line 118 "src/funcs.vala"
	if (_tmp11_) {
#line 1287 "funcs.c"
		Buffer* _tmp12_;
		MovementNDelegate _tmp13_;
		gpointer _tmp13__target;
		GDestroyNotify _tmp13__target_destroy_notify;
		gboolean _tmp14_;
#line 119 "src/funcs.vala"
		_tmp12_ = cur_bp;
#line 119 "src/funcs.vala"
		_tmp13_ = (MovementNDelegate) buffer_move_line;
#line 119 "src/funcs.vala"
		_tmp13__target = buffer_ref (_tmp12_);
#line 119 "src/funcs.vala"
		_tmp13__target_destroy_notify = buffer_unref;
#line 119 "src/funcs.vala"
		_tmp14_ = move_func == _tmp13_;
#line 119 "src/funcs.vala"
		(_tmp13__target_destroy_notify == NULL) ? NULL : (_tmp13__target_destroy_notify (_tmp13__target), NULL);
#line 119 "src/funcs.vala"
		_tmp13_ = NULL;
#line 119 "src/funcs.vala"
		_tmp13__target = NULL;
#line 119 "src/funcs.vala"
		_tmp13__target_destroy_notify = NULL;
#line 119 "src/funcs.vala"
		if (_tmp14_) {
#line 121 "src/funcs.vala"
			funcall ("end-of-line", NULL, NULL);
#line 122 "src/funcs.vala"
			funcall ("newline", NULL, NULL);
#line 1317 "funcs.c"
		} else {
			Buffer* _tmp15_;
			Marker* _tmp16_;
			gsize _tmp17_;
			gsize _tmp18_;
			Marker* _tmp19_;
#line 124 "src/funcs.vala"
			pop_mark ();
#line 125 "src/funcs.vala"
			_tmp15_ = cur_bp;
#line 125 "src/funcs.vala"
			_tmp16_ = m1;
#line 125 "src/funcs.vala"
			_tmp17_ = marker_get_o (_tmp16_);
#line 125 "src/funcs.vala"
			_tmp18_ = _tmp17_;
#line 125 "src/funcs.vala"
			buffer_goto_offset (_tmp15_, _tmp18_);
#line 126 "src/funcs.vala"
			minibuf_error ("End of buffer", NULL);
#line 128 "src/funcs.vala"
			_tmp19_ = m1;
#line 128 "src/funcs.vala"
			marker_unchain (_tmp19_);
#line 129 "src/funcs.vala"
			result = FALSE;
#line 129 "src/funcs.vala"
			_marker_unref0 (m1);
#line 129 "src/funcs.vala"
			return result;
#line 1348 "funcs.c"
		}
	}
#line 133 "src/funcs.vala"
	_tmp20_ = cur_bp;
#line 133 "src/funcs.vala"
	_tmp21_ = m1;
#line 133 "src/funcs.vala"
	_tmp22_ = marker_get_o (_tmp21_);
#line 133 "src/funcs.vala"
	_tmp23_ = _tmp22_;
#line 133 "src/funcs.vala"
	buffer_goto_offset (_tmp20_, _tmp23_);
#line 136 "src/funcs.vala"
	move_func (move_func_target, (glong) 1);
#line 139 "src/funcs.vala"
	_tmp24_ = cur_bp;
#line 139 "src/funcs.vala"
	_tmp25_ = buffer_get_eol (_tmp24_);
#line 139 "src/funcs.vala"
	_tmp26_ = _tmp25_;
#line 139 "src/funcs.vala"
	_tmp27_ = estr_of_empty (_tmp26_);
#line 139 "src/funcs.vala"
	es1 = _tmp27_;
#line 140 "src/funcs.vala"
	_tmp28_ = es1;
#line 140 "src/funcs.vala"
	estr_append_region (_tmp28_);
#line 142 "src/funcs.vala"
	funcall ("delete-region", NULL, NULL);
#line 145 "src/funcs.vala"
	move_func (move_func_target, (glong) 1);
#line 148 "src/funcs.vala"
	es2 = NULL;
#line 150 "src/funcs.vala"
	_tmp29_ = cur_bp;
#line 150 "src/funcs.vala"
	_tmp30_ = (MovementNDelegate) buffer_move_line;
#line 150 "src/funcs.vala"
	_tmp30__target = buffer_ref (_tmp29_);
#line 150 "src/funcs.vala"
	_tmp30__target_destroy_notify = buffer_unref;
#line 150 "src/funcs.vala"
	_tmp31_ = move_func == _tmp30_;
#line 150 "src/funcs.vala"
	(_tmp30__target_destroy_notify == NULL) ? NULL : (_tmp30__target_destroy_notify (_tmp30__target), NULL);
#line 150 "src/funcs.vala"
	_tmp30_ = NULL;
#line 150 "src/funcs.vala"
	_tmp30__target = NULL;
#line 150 "src/funcs.vala"
	_tmp30__target_destroy_notify = NULL;
#line 150 "src/funcs.vala"
	if (_tmp31_) {
#line 1403 "funcs.c"
		Marker* _tmp32_;
#line 151 "src/funcs.vala"
		_tmp32_ = marker_point ();
#line 151 "src/funcs.vala"
		_marker_unref0 (m2);
#line 151 "src/funcs.vala"
		m2 = _tmp32_;
#line 1411 "funcs.c"
	} else {
		Marker* _tmp33_;
		Buffer* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		Estr* _tmp37_;
		Estr* _tmp38_;
#line 154 "src/funcs.vala"
		set_mark ();
#line 157 "src/funcs.vala"
		move_func (move_func_target, (glong) -1);
#line 158 "src/funcs.vala"
		_tmp33_ = marker_point ();
#line 158 "src/funcs.vala"
		_marker_unref0 (m2);
#line 158 "src/funcs.vala"
		m2 = _tmp33_;
#line 161 "src/funcs.vala"
		_tmp34_ = cur_bp;
#line 161 "src/funcs.vala"
		_tmp35_ = buffer_get_eol (_tmp34_);
#line 161 "src/funcs.vala"
		_tmp36_ = _tmp35_;
#line 161 "src/funcs.vala"
		_tmp37_ = estr_of_empty (_tmp36_);
#line 161 "src/funcs.vala"
		_immutable_estr_unref0 (es2);
#line 161 "src/funcs.vala"
		es2 = _tmp37_;
#line 162 "src/funcs.vala"
		_tmp38_ = es2;
#line 162 "src/funcs.vala"
		estr_append_region (_tmp38_);
#line 163 "src/funcs.vala"
		funcall ("delete-region", NULL, NULL);
#line 1447 "funcs.c"
	}
#line 167 "src/funcs.vala"
	_tmp39_ = cur_bp;
#line 167 "src/funcs.vala"
	_tmp40_ = m2;
#line 167 "src/funcs.vala"
	_tmp41_ = marker_get_o (_tmp40_);
#line 167 "src/funcs.vala"
	_tmp42_ = _tmp41_;
#line 167 "src/funcs.vala"
	buffer_goto_offset (_tmp39_, _tmp42_);
#line 168 "src/funcs.vala"
	_tmp43_ = m2;
#line 168 "src/funcs.vala"
	marker_unchain (_tmp43_);
#line 169 "src/funcs.vala"
	_tmp44_ = cur_bp;
#line 169 "src/funcs.vala"
	_tmp45_ = es1;
#line 169 "src/funcs.vala"
	buffer_insert_estr (_tmp44_, (ImmutableEstr*) _tmp45_);
#line 172 "src/funcs.vala"
	_tmp46_ = es2;
#line 172 "src/funcs.vala"
	if (_tmp46_ != NULL) {
#line 1473 "funcs.c"
		Buffer* _tmp47_;
		Marker* _tmp48_;
		gsize _tmp49_;
		gsize _tmp50_;
		Buffer* _tmp51_;
		Estr* _tmp52_;
#line 173 "src/funcs.vala"
		_tmp47_ = cur_bp;
#line 173 "src/funcs.vala"
		_tmp48_ = m1;
#line 173 "src/funcs.vala"
		_tmp49_ = marker_get_o (_tmp48_);
#line 173 "src/funcs.vala"
		_tmp50_ = _tmp49_;
#line 173 "src/funcs.vala"
		buffer_goto_offset (_tmp47_, _tmp50_);
#line 174 "src/funcs.vala"
		_tmp51_ = cur_bp;
#line 174 "src/funcs.vala"
		_tmp52_ = es2;
#line 174 "src/funcs.vala"
		buffer_insert_estr (_tmp51_, (ImmutableEstr*) _tmp52_);
#line 1496 "funcs.c"
	}
#line 176 "src/funcs.vala"
	_tmp53_ = m1;
#line 176 "src/funcs.vala"
	marker_unchain (_tmp53_);
#line 179 "src/funcs.vala"
	pop_mark ();
#line 180 "src/funcs.vala"
	_tmp54_ = cur_bp;
#line 180 "src/funcs.vala"
	_tmp54_->mark_active = FALSE;
#line 183 "src/funcs.vala"
	_tmp55_ = cur_bp;
#line 183 "src/funcs.vala"
	_tmp56_ = (MovementNDelegate) buffer_move_line;
#line 183 "src/funcs.vala"
	_tmp56__target = buffer_ref (_tmp55_);
#line 183 "src/funcs.vala"
	_tmp56__target_destroy_notify = buffer_unref;
#line 183 "src/funcs.vala"
	_tmp57_ = move_func != _tmp56_;
#line 183 "src/funcs.vala"
	(_tmp56__target_destroy_notify == NULL) ? NULL : (_tmp56__target_destroy_notify (_tmp56__target), NULL);
#line 183 "src/funcs.vala"
	_tmp56_ = NULL;
#line 183 "src/funcs.vala"
	_tmp56__target = NULL;
#line 183 "src/funcs.vala"
	_tmp56__target_destroy_notify = NULL;
#line 183 "src/funcs.vala"
	if (_tmp57_) {
#line 184 "src/funcs.vala"
		move_func (move_func_target, (glong) 1);
#line 1530 "funcs.c"
	}
#line 186 "src/funcs.vala"
	result = TRUE;
#line 186 "src/funcs.vala"
	_marker_unref0 (m2);
#line 186 "src/funcs.vala"
	_immutable_estr_unref0 (es2);
#line 186 "src/funcs.vala"
	_immutable_estr_unref0 (es1);
#line 186 "src/funcs.vala"
	_marker_unref0 (m1);
#line 186 "src/funcs.vala"
	return result;
#line 1544 "funcs.c"
}

gboolean
transpose (glong uniarg,
           MovementNDelegate move,
           gpointer move_target)
{
	Buffer* _tmp0_;
	gboolean ret = FALSE;
	gboolean result;
#line 190 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 190 "src/funcs.vala"
	if (buffer_warn_if_readonly (_tmp0_)) {
#line 191 "src/funcs.vala"
		result = FALSE;
#line 191 "src/funcs.vala"
		return result;
#line 1563 "funcs.c"
	}
#line 193 "src/funcs.vala"
	ret = TRUE;
#line 1567 "funcs.c"
	{
		gulong uni = 0UL;
#line 194 "src/funcs.vala"
		uni = (gulong) 0;
#line 1572 "funcs.c"
		{
			gboolean _tmp1_ = FALSE;
#line 194 "src/funcs.vala"
			_tmp1_ = TRUE;
#line 194 "src/funcs.vala"
			while (TRUE) {
#line 1579 "funcs.c"
				gboolean _tmp3_ = FALSE;
#line 194 "src/funcs.vala"
				if (!_tmp1_) {
#line 1583 "funcs.c"
					gulong _tmp2_;
#line 194 "src/funcs.vala"
					uni = uni + 1;
#line 194 "src/funcs.vala"
					_tmp2_ = uni;
#line 1589 "funcs.c"
				}
#line 194 "src/funcs.vala"
				_tmp1_ = FALSE;
#line 194 "src/funcs.vala"
				if (ret) {
#line 194 "src/funcs.vala"
					_tmp3_ = uni < ((gulong) labs (uniarg));
#line 1597 "funcs.c"
				} else {
#line 194 "src/funcs.vala"
					_tmp3_ = FALSE;
#line 1601 "funcs.c"
				}
#line 194 "src/funcs.vala"
				if (!_tmp3_) {
#line 194 "src/funcs.vala"
					break;
#line 1607 "funcs.c"
				}
#line 195 "src/funcs.vala"
				ret = transpose_subr (move, move_target);
#line 1611 "funcs.c"
			}
		}
	}
#line 197 "src/funcs.vala"
	result = ret;
#line 197 "src/funcs.vala"
	return result;
#line 1619 "funcs.c"
}

gboolean
mark (glong uniarg,
      Function func)
{
	gboolean ok = FALSE;
	gboolean result;
#line 202 "src/funcs.vala"
	funcall ("set-mark-command", NULL, NULL);
#line 203 "src/funcs.vala"
	ok = func (uniarg, NULL);
#line 204 "src/funcs.vala"
	if (ok) {
#line 205 "src/funcs.vala"
		funcall ("exchange-point-and-mark", NULL, NULL);
#line 1636 "funcs.c"
	}
#line 206 "src/funcs.vala"
	result = ok;
#line 206 "src/funcs.vala"
	return result;
#line 1642 "funcs.c"
}

gboolean
move_paragraph (glong uniarg,
                MovementDelegate forward,
                gpointer forward_target,
                MovementDelegate backward,
                gpointer backward_target,
                Function line_extremum)
{
	Buffer* _tmp5_;
	gboolean result;
#line 211 "src/funcs.vala"
	if (uniarg < ((glong) 0)) {
#line 212 "src/funcs.vala"
		uniarg = -uniarg;
#line 213 "src/funcs.vala"
		forward = backward;
#line 213 "src/funcs.vala"
		forward_target = backward_target;
#line 1663 "funcs.c"
	}
#line 216 "src/funcs.vala"
	while (TRUE) {
#line 1667 "funcs.c"
		glong _tmp0_;
#line 216 "src/funcs.vala"
		_tmp0_ = uniarg;
#line 216 "src/funcs.vala"
		uniarg = _tmp0_ - 1;
#line 216 "src/funcs.vala"
		if (!(_tmp0_ > ((glong) 0))) {
#line 216 "src/funcs.vala"
			break;
#line 1677 "funcs.c"
		}
#line 217 "src/funcs.vala"
		while (TRUE) {
#line 1681 "funcs.c"
			gboolean _tmp1_ = FALSE;
			Buffer* _tmp2_;
#line 217 "src/funcs.vala"
			_tmp2_ = cur_bp;
#line 217 "src/funcs.vala"
			if (buffer_is_empty_line (_tmp2_)) {
#line 217 "src/funcs.vala"
				_tmp1_ = forward (forward_target);
#line 1690 "funcs.c"
			} else {
#line 217 "src/funcs.vala"
				_tmp1_ = FALSE;
#line 1694 "funcs.c"
			}
#line 217 "src/funcs.vala"
			if (!_tmp1_) {
#line 217 "src/funcs.vala"
				break;
#line 1700 "funcs.c"
			}
		}
#line 219 "src/funcs.vala"
		while (TRUE) {
#line 1705 "funcs.c"
			gboolean _tmp3_ = FALSE;
			Buffer* _tmp4_;
#line 219 "src/funcs.vala"
			_tmp4_ = cur_bp;
#line 219 "src/funcs.vala"
			if (!buffer_is_empty_line (_tmp4_)) {
#line 219 "src/funcs.vala"
				_tmp3_ = forward (forward_target);
#line 1714 "funcs.c"
			} else {
#line 219 "src/funcs.vala"
				_tmp3_ = FALSE;
#line 1718 "funcs.c"
			}
#line 219 "src/funcs.vala"
			if (!_tmp3_) {
#line 219 "src/funcs.vala"
				break;
#line 1724 "funcs.c"
			}
		}
	}
#line 223 "src/funcs.vala"
	_tmp5_ = cur_bp;
#line 223 "src/funcs.vala"
	if (buffer_is_empty_line (_tmp5_)) {
#line 224 "src/funcs.vala"
		funcall ("beginning-of-line", NULL, NULL);
#line 1734 "funcs.c"
	} else {
#line 226 "src/funcs.vala"
		line_extremum ((glong) 1, NULL);
#line 1738 "funcs.c"
	}
#line 228 "src/funcs.vala"
	result = TRUE;
#line 228 "src/funcs.vala"
	return result;
#line 1744 "funcs.c"
}

static GType
case_get_type_once (void)
{
	static const GEnumValue values[] = {{CASE_upper, "CASE_upper", "upper"}, {CASE_lower, "CASE_lower", "lower"}, {CASE_capitalized, "CASE_capitalized", "capitalized"}, {0, NULL, NULL}};
	GType case_type_id;
	case_type_id = g_enum_register_static ("Case", values);
	return case_type_id;
}

GType
case_get_type (void)
{
	static volatile gsize case_type_id__once = 0;
	if (g_once_init_enter (&case_type_id__once)) {
		GType case_type_id;
		case_type_id = case_get_type_once ();
		g_once_init_leave (&case_type_id__once, case_type_id);
	}
	return case_type_id__once;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
#line 1283 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1284 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1284 "glib-2.0.vapi"
	result = _tmp0_;
#line 1284 "glib-2.0.vapi"
	return result;
#line 1782 "funcs.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1501 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1501 "glib-2.0.vapi"
	end = _tmp0_;
#line 1502 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1502 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1503 "glib-2.0.vapi"
		result = maxlen;
#line 1503 "glib-2.0.vapi"
		return result;
#line 1805 "funcs.c"
	} else {
		gchar* _tmp2_;
#line 1505 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1505 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1505 "glib-2.0.vapi"
		return result;
#line 1814 "funcs.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1512 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1514 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 1833 "funcs.c"
	} else {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1837 "funcs.c"
	}
#line 1514 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1516 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 1843 "funcs.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1518 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1518 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1518 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 1853 "funcs.c"
	}
#line 1521 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1522 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1523 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 1861 "funcs.c"
	} else {
#line 1525 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 1865 "funcs.c"
	}
#line 1527 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1528 "glib-2.0.vapi"
		len = string_length - offset;
#line 1871 "funcs.c"
	}
#line 1530 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1531 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1531 "glib-2.0.vapi"
	result = _tmp3_;
#line 1531 "glib-2.0.vapi"
	return result;
#line 1881 "funcs.c"
}

gchar*
recase (const gchar* s,
        Case rcase)
{
	gchar* _tmp12_;
	gchar* result;
#line 237 "src/funcs.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 238 "src/funcs.vala"
	switch (rcase) {
#line 238 "src/funcs.vala"
		case CASE_upper:
#line 1896 "funcs.c"
		{
			gchar* _tmp0_;
#line 240 "src/funcs.vala"
			_tmp0_ = g_utf8_strup (s, (gssize) -1);
#line 240 "src/funcs.vala"
			result = _tmp0_;
#line 240 "src/funcs.vala"
			return result;
#line 1905 "funcs.c"
		}
#line 238 "src/funcs.vala"
		case CASE_lower:
#line 1909 "funcs.c"
		{
			gchar* _tmp1_;
#line 242 "src/funcs.vala"
			_tmp1_ = g_utf8_strdown (s, (gssize) -1);
#line 242 "src/funcs.vala"
			result = _tmp1_;
#line 242 "src/funcs.vala"
			return result;
#line 1918 "funcs.c"
		}
#line 238 "src/funcs.vala"
		case CASE_capitalized:
#line 1922 "funcs.c"
		{
			{
				gchar* ret = NULL;
				gchar* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
#line 244 "src/funcs.vala"
				_tmp2_ = g_strdup ("");
#line 244 "src/funcs.vala"
				ret = _tmp2_;
#line 245 "src/funcs.vala"
				_tmp3_ = strlen (s);
#line 245 "src/funcs.vala"
				_tmp4_ = _tmp3_;
#line 245 "src/funcs.vala"
				if (_tmp4_ > 0) {
#line 1939 "funcs.c"
					gchar* _tmp5_;
					gint _tmp6_;
					gint _tmp7_;
#line 246 "src/funcs.vala"
					_tmp5_ = g_strdup_printf ("%c", g_ascii_toupper (string_get (s, (glong) 0)));
#line 246 "src/funcs.vala"
					_g_free0 (ret);
#line 246 "src/funcs.vala"
					ret = _tmp5_;
#line 247 "src/funcs.vala"
					_tmp6_ = strlen (s);
#line 247 "src/funcs.vala"
					_tmp7_ = _tmp6_;
#line 247 "src/funcs.vala"
					if (_tmp7_ > 1) {
#line 1955 "funcs.c"
						const gchar* _tmp8_;
						gchar* _tmp9_;
						gchar* _tmp10_;
						gchar* _tmp11_;
#line 248 "src/funcs.vala"
						_tmp8_ = ret;
#line 248 "src/funcs.vala"
						_tmp9_ = string_substring (s, (glong) 1, (glong) -1);
#line 248 "src/funcs.vala"
						_tmp10_ = _tmp9_;
#line 248 "src/funcs.vala"
						_tmp11_ = g_strconcat (_tmp8_, _tmp10_, NULL);
#line 248 "src/funcs.vala"
						_g_free0 (ret);
#line 248 "src/funcs.vala"
						ret = _tmp11_;
#line 248 "src/funcs.vala"
						_g_free0 (_tmp10_);
#line 1974 "funcs.c"
					}
				}
#line 250 "src/funcs.vala"
				result = ret;
#line 250 "src/funcs.vala"
				return result;
#line 1981 "funcs.c"
			}
		}
		default:
#line 238 "src/funcs.vala"
		break;
#line 1987 "funcs.c"
	}
#line 254 "src/funcs.vala"
	_vala_assert (FALSE, "false");
#line 255 "src/funcs.vala"
	_tmp12_ = g_strdup (s);
#line 255 "src/funcs.vala"
	result = _tmp12_;
#line 255 "src/funcs.vala"
	return result;
#line 1997 "funcs.c"
}

gboolean
setcase_word (Case rcase)
{
	Buffer* _tmp0_;
	gchar* a = NULL;
	gchar* _tmp4_;
	gchar c = '\0';
	const gchar* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	Buffer* _tmp37_;
	gboolean result;
#line 259 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 259 "src/funcs.vala"
	if (!iswordchar (buffer_following_char (_tmp0_))) {
#line 2016 "funcs.c"
		gboolean _tmp1_ = FALSE;
		Buffer* _tmp2_;
#line 260 "src/funcs.vala"
		_tmp2_ = cur_bp;
#line 260 "src/funcs.vala"
		if (!buffer_move_word (_tmp2_, (glong) 1)) {
#line 260 "src/funcs.vala"
			_tmp1_ = TRUE;
#line 2025 "funcs.c"
		} else {
			Buffer* _tmp3_;
#line 260 "src/funcs.vala"
			_tmp3_ = cur_bp;
#line 260 "src/funcs.vala"
			_tmp1_ = !buffer_move_word (_tmp3_, (glong) -1);
#line 2032 "funcs.c"
		}
#line 260 "src/funcs.vala"
		if (_tmp1_) {
#line 261 "src/funcs.vala"
			result = FALSE;
#line 261 "src/funcs.vala"
			return result;
#line 2040 "funcs.c"
		}
	}
#line 263 "src/funcs.vala"
	_tmp4_ = g_strdup ("");
#line 263 "src/funcs.vala"
	a = _tmp4_;
#line 264 "src/funcs.vala"
	c = (gchar) 0;
#line 2049 "funcs.c"
	{
		gsize i = 0UL;
		Buffer* _tmp5_;
		gsize _tmp6_;
		gsize _tmp7_;
		Buffer* _tmp8_;
#line 265 "src/funcs.vala"
		_tmp5_ = cur_bp;
#line 265 "src/funcs.vala"
		_tmp6_ = buffer_get_pt (_tmp5_);
#line 265 "src/funcs.vala"
		_tmp7_ = _tmp6_;
#line 265 "src/funcs.vala"
		_tmp8_ = cur_bp;
#line 265 "src/funcs.vala"
		i = _tmp7_ - buffer_line_o (_tmp8_);
#line 2066 "funcs.c"
		{
			gboolean _tmp9_ = FALSE;
#line 265 "src/funcs.vala"
			_tmp9_ = TRUE;
#line 265 "src/funcs.vala"
			while (TRUE) {
#line 2073 "funcs.c"
				gboolean _tmp11_ = FALSE;
				Buffer* _tmp12_;
				Buffer* _tmp13_;
				gsize _tmp14_;
				gsize _tmp15_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
#line 265 "src/funcs.vala"
				if (!_tmp9_) {
#line 2085 "funcs.c"
					gsize _tmp10_;
#line 268 "src/funcs.vala"
					_tmp10_ = i;
#line 268 "src/funcs.vala"
					i = _tmp10_ + 1;
#line 2091 "funcs.c"
				}
#line 265 "src/funcs.vala"
				_tmp9_ = FALSE;
#line 266 "src/funcs.vala"
				_tmp12_ = cur_bp;
#line 266 "src/funcs.vala"
				_tmp13_ = cur_bp;
#line 266 "src/funcs.vala"
				_tmp14_ = buffer_get_pt (_tmp13_);
#line 266 "src/funcs.vala"
				_tmp15_ = _tmp14_;
#line 266 "src/funcs.vala"
				if (i < buffer_line_len (_tmp12_, _tmp15_)) {
#line 2105 "funcs.c"
					Buffer* _tmp16_;
					Buffer* _tmp17_;
#line 267 "src/funcs.vala"
					_tmp16_ = cur_bp;
#line 267 "src/funcs.vala"
					_tmp17_ = cur_bp;
#line 267 "src/funcs.vala"
					c = buffer_get_char (_tmp16_, buffer_line_o (_tmp17_) + i);
#line 267 "src/funcs.vala"
					_tmp11_ = iswordchar (c);
#line 2116 "funcs.c"
				} else {
#line 266 "src/funcs.vala"
					_tmp11_ = FALSE;
#line 2120 "funcs.c"
				}
#line 266 "src/funcs.vala"
				if (!_tmp11_) {
#line 266 "src/funcs.vala"
					break;
#line 2126 "funcs.c"
				}
#line 269 "src/funcs.vala"
				_tmp18_ = a;
#line 269 "src/funcs.vala"
				_tmp19_ = g_strdup_printf ("%c", (gchar) c);
#line 269 "src/funcs.vala"
				_tmp20_ = _tmp19_;
#line 269 "src/funcs.vala"
				_tmp21_ = g_strconcat (_tmp18_, _tmp20_, NULL);
#line 269 "src/funcs.vala"
				_g_free0 (a);
#line 269 "src/funcs.vala"
				a = _tmp21_;
#line 269 "src/funcs.vala"
				_g_free0 (_tmp20_);
#line 2142 "funcs.c"
			}
		}
	}
#line 271 "src/funcs.vala"
	_tmp22_ = a;
#line 271 "src/funcs.vala"
	_tmp23_ = strlen (_tmp22_);
#line 271 "src/funcs.vala"
	_tmp24_ = _tmp23_;
#line 271 "src/funcs.vala"
	if (_tmp24_ > 0) {
#line 2154 "funcs.c"
		Buffer* _tmp25_;
		const gchar* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		const gchar* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		ImmutableEstr* _tmp35_;
		ImmutableEstr* _tmp36_;
#line 272 "src/funcs.vala"
		_tmp25_ = cur_bp;
#line 272 "src/funcs.vala"
		_tmp26_ = a;
#line 272 "src/funcs.vala"
		_tmp27_ = strlen (_tmp26_);
#line 272 "src/funcs.vala"
		_tmp28_ = _tmp27_;
#line 272 "src/funcs.vala"
		_tmp29_ = a;
#line 272 "src/funcs.vala"
		_tmp30_ = recase (_tmp29_, rcase);
#line 272 "src/funcs.vala"
		_tmp31_ = _tmp30_;
#line 272 "src/funcs.vala"
		_tmp32_ = a;
#line 272 "src/funcs.vala"
		_tmp33_ = strlen (_tmp32_);
#line 272 "src/funcs.vala"
		_tmp34_ = _tmp33_;
#line 272 "src/funcs.vala"
		_tmp35_ = immutable_estr_of (_tmp31_, (gsize) _tmp34_, IMMUTABLE_ESTR_eol_lf);
#line 272 "src/funcs.vala"
		_tmp36_ = _tmp35_;
#line 272 "src/funcs.vala"
		buffer_replace_estr (_tmp25_, (gsize) _tmp28_, _tmp36_);
#line 272 "src/funcs.vala"
		_immutable_estr_unref0 (_tmp36_);
#line 272 "src/funcs.vala"
		_g_free0 (_tmp31_);
#line 2197 "funcs.c"
	}
#line 274 "src/funcs.vala"
	_tmp37_ = cur_bp;
#line 274 "src/funcs.vala"
	_tmp37_->modified = TRUE;
#line 276 "src/funcs.vala"
	result = TRUE;
#line 276 "src/funcs.vala"
	_g_free0 (a);
#line 276 "src/funcs.vala"
	return result;
#line 2209 "funcs.c"
}

gboolean
setcase_word_lowercase (void)
{
	gboolean result;
#line 280 "src/funcs.vala"
	result = setcase_word (CASE_lower);
#line 280 "src/funcs.vala"
	return result;
#line 2220 "funcs.c"
}

gboolean
setcase_word_uppercase (void)
{
	gboolean result;
#line 284 "src/funcs.vala"
	result = setcase_word (CASE_upper);
#line 284 "src/funcs.vala"
	return result;
#line 2231 "funcs.c"
}

gboolean
setcase_word_capitalize (void)
{
	gboolean result;
#line 288 "src/funcs.vala"
	result = setcase_word (CASE_capitalized);
#line 288 "src/funcs.vala"
	return result;
#line 2242 "funcs.c"
}

gboolean
setcase_region (CharTransform func,
                gpointer func_target)
{
	gboolean _tmp0_ = FALSE;
	Buffer* _tmp1_;
	Region* r = NULL;
	Region* _tmp3_;
	Marker* m = NULL;
	Marker* _tmp4_;
	Buffer* _tmp5_;
	Region* _tmp6_;
	gsize _tmp7_;
	gsize _tmp8_;
	Buffer* _tmp15_;
	Marker* _tmp16_;
	gsize _tmp17_;
	gsize _tmp18_;
	Marker* _tmp19_;
	gboolean result;
#line 296 "src/funcs.vala"
	_tmp1_ = cur_bp;
#line 296 "src/funcs.vala"
	if (buffer_warn_if_readonly (_tmp1_)) {
#line 296 "src/funcs.vala"
		_tmp0_ = TRUE;
#line 2271 "funcs.c"
	} else {
		Buffer* _tmp2_;
#line 296 "src/funcs.vala"
		_tmp2_ = cur_bp;
#line 296 "src/funcs.vala"
		_tmp0_ = buffer_warn_if_no_mark (_tmp2_);
#line 2278 "funcs.c"
	}
#line 296 "src/funcs.vala"
	if (_tmp0_) {
#line 297 "src/funcs.vala"
		result = FALSE;
#line 297 "src/funcs.vala"
		return result;
#line 2286 "funcs.c"
	}
#line 299 "src/funcs.vala"
	_tmp3_ = region_calculate ();
#line 299 "src/funcs.vala"
	r = _tmp3_;
#line 300 "src/funcs.vala"
	_tmp4_ = marker_point ();
#line 300 "src/funcs.vala"
	m = _tmp4_;
#line 301 "src/funcs.vala"
	_tmp5_ = cur_bp;
#line 301 "src/funcs.vala"
	_tmp6_ = r;
#line 301 "src/funcs.vala"
	_tmp7_ = region_get_start (_tmp6_);
#line 301 "src/funcs.vala"
	_tmp8_ = _tmp7_;
#line 301 "src/funcs.vala"
	buffer_goto_offset (_tmp5_, _tmp8_);
#line 2306 "funcs.c"
	{
		gsize n = 0UL;
		Region* _tmp9_;
#line 302 "src/funcs.vala"
		_tmp9_ = r;
#line 302 "src/funcs.vala"
		n = region_size (_tmp9_);
#line 2314 "funcs.c"
		{
			gboolean _tmp10_ = FALSE;
#line 302 "src/funcs.vala"
			_tmp10_ = TRUE;
#line 302 "src/funcs.vala"
			while (TRUE) {
#line 2321 "funcs.c"
				gchar c = '\0';
				Buffer* _tmp12_;
				Buffer* _tmp13_;
				Buffer* _tmp14_;
#line 302 "src/funcs.vala"
				if (!_tmp10_) {
#line 2328 "funcs.c"
					gsize _tmp11_;
#line 302 "src/funcs.vala"
					_tmp11_ = n;
#line 302 "src/funcs.vala"
					n = _tmp11_ - 1;
#line 2334 "funcs.c"
				}
#line 302 "src/funcs.vala"
				_tmp10_ = FALSE;
#line 302 "src/funcs.vala"
				if (!(n > ((gsize) 0))) {
#line 302 "src/funcs.vala"
					break;
#line 2342 "funcs.c"
				}
#line 303 "src/funcs.vala"
				_tmp12_ = cur_bp;
#line 303 "src/funcs.vala"
				c = func (buffer_following_char (_tmp12_), func_target);
#line 304 "src/funcs.vala"
				_tmp13_ = cur_bp;
#line 304 "src/funcs.vala"
				buffer_delete_char (_tmp13_);
#line 305 "src/funcs.vala"
				_tmp14_ = cur_bp;
#line 305 "src/funcs.vala"
				buffer_insert_char (_tmp14_, c);
#line 2356 "funcs.c"
			}
		}
	}
#line 307 "src/funcs.vala"
	_tmp15_ = cur_bp;
#line 307 "src/funcs.vala"
	_tmp16_ = m;
#line 307 "src/funcs.vala"
	_tmp17_ = marker_get_o (_tmp16_);
#line 307 "src/funcs.vala"
	_tmp18_ = _tmp17_;
#line 307 "src/funcs.vala"
	buffer_goto_offset (_tmp15_, _tmp18_);
#line 308 "src/funcs.vala"
	_tmp19_ = m;
#line 308 "src/funcs.vala"
	marker_unchain (_tmp19_);
#line 310 "src/funcs.vala"
	result = TRUE;
#line 310 "src/funcs.vala"
	_marker_unref0 (m);
#line 310 "src/funcs.vala"
	_region_unref0 (r);
#line 310 "src/funcs.vala"
	return result;
#line 2382 "funcs.c"
}

static void
__lambda47_ (void)
{
	Window* _tmp0_;
	Buffer* bp = NULL;
	Window* _tmp1_;
	Buffer* _tmp2_;
	Buffer* _tmp3_;
	Buffer* _tmp4_;
#line 323 "src/funcs.vala"
	bprintf ("CRM Buffer                Size  Mode             File\n", NULL);
#line 324 "src/funcs.vala"
	bprintf ("--- ------                ----  ----             ----\n", NULL);
#line 327 "src/funcs.vala"
	_tmp0_ = cur_wp;
#line 327 "src/funcs.vala"
	_vala_assert (_tmp0_ != NULL, "cur_wp != null");
#line 328 "src/funcs.vala"
	_tmp1_ = cur_wp;
#line 328 "src/funcs.vala"
	_tmp2_ = _tmp1_->bp;
#line 328 "src/funcs.vala"
	_tmp3_ = _buffer_ref0 (_tmp2_);
#line 328 "src/funcs.vala"
	bp = _tmp3_;
#line 329 "src/funcs.vala"
	_tmp4_ = bp;
#line 329 "src/funcs.vala"
	_vala_assert (_tmp4_ != NULL, "bp != null");
#line 2414 "funcs.c"
	{
		gboolean _tmp5_ = FALSE;
#line 330 "src/funcs.vala"
		_tmp5_ = TRUE;
#line 330 "src/funcs.vala"
		while (TRUE) {
#line 2421 "funcs.c"
			gboolean _tmp9_ = FALSE;
			Buffer* _tmp10_;
			Buffer* _tmp11_;
			Buffer* _tmp33_;
			Buffer* _tmp34_;
			Buffer* _tmp35_;
			Buffer* _tmp36_;
#line 330 "src/funcs.vala"
			if (!_tmp5_) {
#line 2431 "funcs.c"
				Buffer* _tmp6_;
				Window* _tmp7_;
				Buffer* _tmp8_;
#line 346 "src/funcs.vala"
				_tmp6_ = bp;
#line 346 "src/funcs.vala"
				_tmp7_ = cur_wp;
#line 346 "src/funcs.vala"
				_tmp8_ = _tmp7_->bp;
#line 346 "src/funcs.vala"
				if (!(_tmp6_ != _tmp8_)) {
#line 346 "src/funcs.vala"
					break;
#line 2445 "funcs.c"
				}
			}
#line 330 "src/funcs.vala"
			_tmp5_ = FALSE;
#line 333 "src/funcs.vala"
			_tmp10_ = cur_bp;
#line 333 "src/funcs.vala"
			_tmp11_ = bp;
#line 333 "src/funcs.vala"
			if (_tmp10_ != _tmp11_) {
#line 2456 "funcs.c"
				Buffer* _tmp12_;
				const gchar* _tmp13_;
#line 333 "src/funcs.vala"
				_tmp12_ = bp;
#line 333 "src/funcs.vala"
				_tmp13_ = _tmp12_->name;
#line 333 "src/funcs.vala"
				_tmp9_ = string_get (_tmp13_, (glong) 0) != ' ';
#line 2465 "funcs.c"
			} else {
#line 333 "src/funcs.vala"
				_tmp9_ = FALSE;
#line 2469 "funcs.c"
			}
#line 333 "src/funcs.vala"
			if (_tmp9_) {
#line 2473 "funcs.c"
				gchar _tmp14_ = '\0';
				Window* _tmp15_;
				Buffer* _tmp16_;
				Buffer* _tmp17_;
				gchar _tmp18_ = '\0';
				Buffer* _tmp19_;
				gchar _tmp20_ = '\0';
				Buffer* _tmp21_;
				Buffer* _tmp22_;
				const gchar* _tmp23_;
				Buffer* _tmp24_;
				gsize _tmp25_;
				gsize _tmp26_;
				Buffer* _tmp27_;
				const gchar* _tmp28_;
#line 335 "src/funcs.vala"
				_tmp15_ = cur_wp;
#line 335 "src/funcs.vala"
				_tmp16_ = _tmp15_->bp;
#line 335 "src/funcs.vala"
				_tmp17_ = bp;
#line 335 "src/funcs.vala"
				if (_tmp16_ == _tmp17_) {
#line 335 "src/funcs.vala"
					_tmp14_ = '.';
#line 2499 "funcs.c"
				} else {
#line 335 "src/funcs.vala"
					_tmp14_ = ' ';
#line 2503 "funcs.c"
				}
#line 336 "src/funcs.vala"
				_tmp19_ = bp;
#line 336 "src/funcs.vala"
				if (_tmp19_->readonly) {
#line 336 "src/funcs.vala"
					_tmp18_ = '%';
#line 2511 "funcs.c"
				} else {
#line 336 "src/funcs.vala"
					_tmp18_ = ' ';
#line 2515 "funcs.c"
				}
#line 337 "src/funcs.vala"
				_tmp21_ = bp;
#line 337 "src/funcs.vala"
				if (_tmp21_->modified) {
#line 337 "src/funcs.vala"
					_tmp20_ = '*';
#line 2523 "funcs.c"
				} else {
#line 337 "src/funcs.vala"
					_tmp20_ = ' ';
#line 2527 "funcs.c"
				}
#line 334 "src/funcs.vala"
				_tmp22_ = bp;
#line 334 "src/funcs.vala"
				_tmp23_ = _tmp22_->name;
#line 334 "src/funcs.vala"
				_tmp24_ = bp;
#line 334 "src/funcs.vala"
				_tmp25_ = buffer_get_length (_tmp24_);
#line 334 "src/funcs.vala"
				_tmp26_ = _tmp25_;
#line 334 "src/funcs.vala"
				bprintf ("%c%c%c %-19s %6zu  %-17s", _tmp14_, _tmp18_, _tmp20_, _tmp23_, _tmp26_, "Fundamental", NULL);
#line 339 "src/funcs.vala"
				_tmp27_ = bp;
#line 339 "src/funcs.vala"
				_tmp28_ = _tmp27_->filename;
#line 339 "src/funcs.vala"
				if (_tmp28_ != NULL) {
#line 2547 "funcs.c"
					Buffer* _tmp29_;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
#line 340 "src/funcs.vala"
					_tmp29_ = bp;
#line 340 "src/funcs.vala"
					_tmp30_ = _tmp29_->filename;
#line 340 "src/funcs.vala"
					_tmp31_ = compact_path (_tmp30_);
#line 340 "src/funcs.vala"
					_tmp32_ = _tmp31_;
#line 340 "src/funcs.vala"
					bprintf ("%s", _tmp32_, NULL);
#line 340 "src/funcs.vala"
					_g_free0 (_tmp32_);
#line 2564 "funcs.c"
				}
#line 341 "src/funcs.vala"
				insert_newline ();
#line 2568 "funcs.c"
			}
#line 343 "src/funcs.vala"
			_tmp33_ = bp;
#line 343 "src/funcs.vala"
			_tmp34_ = _tmp33_->next;
#line 343 "src/funcs.vala"
			_tmp35_ = _buffer_ref0 (_tmp34_);
#line 343 "src/funcs.vala"
			_buffer_unref0 (bp);
#line 343 "src/funcs.vala"
			bp = _tmp35_;
#line 344 "src/funcs.vala"
			_tmp36_ = bp;
#line 344 "src/funcs.vala"
			if (_tmp36_ == NULL) {
#line 2584 "funcs.c"
				Buffer* _tmp37_;
				Buffer* _tmp38_;
#line 345 "src/funcs.vala"
				_tmp37_ = head_bp;
#line 345 "src/funcs.vala"
				_tmp38_ = _buffer_ref0 (_tmp37_);
#line 345 "src/funcs.vala"
				_buffer_unref0 (bp);
#line 345 "src/funcs.vala"
				bp = _tmp38_;
#line 2595 "funcs.c"
			}
		}
	}
#line 321 "src/funcs.vala"
	_buffer_unref0 (bp);
#line 2601 "funcs.c"
}

static void
___lambda47__buffer_writer (gpointer self)
{
#line 318 "src/funcs.vala"
	__lambda47_ ();
#line 2609 "funcs.c"
}

static gboolean
__lambda46_ (glong uniarg,
             GeeQueue* args)
{
	gboolean result;
#line 318 "src/funcs.vala"
	write_temp_buffer ("*Buffer List*", TRUE, ___lambda47__buffer_writer, NULL);
#line 348 "src/funcs.vala"
	result = TRUE;
#line 348 "src/funcs.vala"
	return result;
#line 2623 "funcs.c"
}

static gboolean
___lambda46__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda46_ (uniarg, args);
#line 315 "src/funcs.vala"
	return result;
#line 2634 "funcs.c"
}

static gboolean
__lambda48_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	Buffer* _tmp1_;
	gboolean result;
#line 362 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 362 "src/funcs.vala"
	_tmp1_ = cur_bp;
#line 362 "src/funcs.vala"
	_tmp0_->readonly = !_tmp1_->readonly;
#line 363 "src/funcs.vala"
	result = TRUE;
#line 363 "src/funcs.vala"
	return result;
#line 2654 "funcs.c"
}

static gboolean
___lambda48__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda48_ (uniarg, args);
#line 359 "src/funcs.vala"
	return result;
#line 2665 "funcs.c"
}

static gboolean
__lambda49_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	Buffer* _tmp1_;
	gboolean result;
#line 372 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 372 "src/funcs.vala"
	_tmp1_ = cur_bp;
#line 372 "src/funcs.vala"
	_tmp0_->autofill = !_tmp1_->autofill;
#line 373 "src/funcs.vala"
	result = TRUE;
#line 373 "src/funcs.vala"
	return result;
#line 2685 "funcs.c"
}

static gboolean
___lambda49__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda49_ (uniarg, args);
#line 369 "src/funcs.vala"
	return result;
#line 2696 "funcs.c"
}

static gboolean
__lambda50_ (glong uniarg,
             GeeQueue* args)
{
	gboolean ok = FALSE;
	gsize o = 0UL;
	Buffer* _tmp0_;
	gsize _tmp1_;
	gsize _tmp2_;
	Buffer* _tmp3_;
	glong _tmp4_ = 0L;
	glong fill_col = 0L;
	gchar* buf = NULL;
	gboolean result;
#line 384 "src/funcs.vala"
	ok = TRUE;
#line 385 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 385 "src/funcs.vala"
	_tmp1_ = buffer_get_pt (_tmp0_);
#line 385 "src/funcs.vala"
	_tmp2_ = _tmp1_;
#line 385 "src/funcs.vala"
	_tmp3_ = cur_bp;
#line 385 "src/funcs.vala"
	o = _tmp2_ - buffer_line_o (_tmp3_);
#line 386 "src/funcs.vala"
	if ((lastflag & FLAGS_UNIARG_EMPTY) == FLAGS_UNIARG_EMPTY) {
#line 386 "src/funcs.vala"
		_tmp4_ = (glong) o;
#line 2729 "funcs.c"
	} else {
#line 386 "src/funcs.vala"
		_tmp4_ = uniarg;
#line 2733 "funcs.c"
	}
#line 386 "src/funcs.vala"
	fill_col = _tmp4_;
#line 387 "src/funcs.vala"
	buf = NULL;
#line 389 "src/funcs.vala"
	if (noarg (args)) {
#line 390 "src/funcs.vala"
		fill_col = minibuf_read_number ("Set fill-column to (default %zu): ", o, NULL);
#line 391 "src/funcs.vala"
		if (fill_col == G_MAXLONG) {
#line 392 "src/funcs.vala"
			result = FALSE;
#line 392 "src/funcs.vala"
			_g_free0 (buf);
#line 392 "src/funcs.vala"
			return result;
#line 2751 "funcs.c"
		} else {
#line 393 "src/funcs.vala"
			if (fill_col == (G_MAXLONG - 1)) {
#line 394 "src/funcs.vala"
				fill_col = (glong) o;
#line 2757 "funcs.c"
			}
		}
	}
#line 397 "src/funcs.vala"
	if (args != NULL) {
#line 2763 "funcs.c"
		gboolean _tmp5_;
		gboolean _tmp6_;
#line 398 "src/funcs.vala"
		_tmp5_ = gee_collection_get_is_empty ((GeeCollection*) args);
#line 398 "src/funcs.vala"
		_tmp6_ = _tmp5_;
#line 398 "src/funcs.vala"
		if (!_tmp6_) {
#line 2772 "funcs.c"
			gpointer _tmp7_;
#line 399 "src/funcs.vala"
			_tmp7_ = gee_queue_poll (args);
#line 399 "src/funcs.vala"
			_g_free0 (buf);
#line 399 "src/funcs.vala"
			buf = (gchar*) _tmp7_;
#line 2780 "funcs.c"
		} else {
#line 401 "src/funcs.vala"
			minibuf_error ("set-fill-column requires an explicit argument", NULL);
#line 402 "src/funcs.vala"
			ok = FALSE;
#line 2786 "funcs.c"
		}
	} else {
		gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
#line 405 "src/funcs.vala"
		_tmp8_ = g_strdup_printf ("%li", fill_col);
#line 405 "src/funcs.vala"
		_g_free0 (buf);
#line 405 "src/funcs.vala"
		buf = _tmp8_;
#line 407 "src/funcs.vala"
		_tmp9_ = buf;
#line 407 "src/funcs.vala"
		_tmp10_ = get_variable ("fill-column");
#line 407 "src/funcs.vala"
		minibuf_write ("Fill column set to %s (was %s)", _tmp9_, _tmp10_, NULL);
#line 2804 "funcs.c"
	}
#line 411 "src/funcs.vala"
	if (ok) {
#line 2808 "funcs.c"
		const gchar* _tmp11_;
#line 412 "src/funcs.vala"
		_tmp11_ = buf;
#line 412 "src/funcs.vala"
		set_variable ("fill-column", _tmp11_);
#line 2814 "funcs.c"
	}
#line 413 "src/funcs.vala"
	result = ok;
#line 413 "src/funcs.vala"
	_g_free0 (buf);
#line 413 "src/funcs.vala"
	return result;
#line 2822 "funcs.c"
}

static gboolean
___lambda50__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda50_ (uniarg, args);
#line 381 "src/funcs.vala"
	return result;
#line 2833 "funcs.c"
}

static gboolean
__lambda51_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	gboolean result;
#line 424 "src/funcs.vala"
	set_mark ();
#line 425 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 425 "src/funcs.vala"
	_tmp0_->mark_active = TRUE;
#line 426 "src/funcs.vala"
	result = TRUE;
#line 426 "src/funcs.vala"
	return result;
#line 2852 "funcs.c"
}

static gboolean
___lambda51__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda51_ (uniarg, args);
#line 421 "src/funcs.vala"
	return result;
#line 2863 "funcs.c"
}

static gboolean
__lambda52_ (glong uniarg,
             GeeQueue* args)
{
	gboolean result;
#line 435 "src/funcs.vala"
	funcall ("set-mark", NULL, NULL);
#line 436 "src/funcs.vala"
	minibuf_write ("Mark set", NULL);
#line 437 "src/funcs.vala"
	result = TRUE;
#line 437 "src/funcs.vala"
	return result;
#line 2879 "funcs.c"
}

static gboolean
___lambda52__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda52_ (uniarg, args);
#line 432 "src/funcs.vala"
	return result;
#line 2890 "funcs.c"
}

static gboolean
__lambda53_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	Marker* _tmp1_;
	gsize o = 0UL;
	Buffer* _tmp2_;
	gsize _tmp3_;
	gsize _tmp4_;
	Buffer* _tmp5_;
	Buffer* _tmp6_;
	Marker* _tmp7_;
	gsize _tmp8_;
	gsize _tmp9_;
	Buffer* _tmp10_;
	Marker* _tmp11_;
	Buffer* _tmp12_;
	gboolean result;
#line 446 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 446 "src/funcs.vala"
	_tmp1_ = _tmp0_->mark;
#line 446 "src/funcs.vala"
	if (_tmp1_ == NULL) {
#line 447 "src/funcs.vala"
		minibuf_error ("No mark set in this buffer", NULL);
#line 448 "src/funcs.vala"
		result = FALSE;
#line 448 "src/funcs.vala"
		return result;
#line 2924 "funcs.c"
	}
#line 451 "src/funcs.vala"
	_tmp2_ = cur_bp;
#line 451 "src/funcs.vala"
	_tmp3_ = buffer_get_pt (_tmp2_);
#line 451 "src/funcs.vala"
	_tmp4_ = _tmp3_;
#line 451 "src/funcs.vala"
	o = _tmp4_;
#line 452 "src/funcs.vala"
	_tmp5_ = cur_bp;
#line 452 "src/funcs.vala"
	_tmp6_ = cur_bp;
#line 452 "src/funcs.vala"
	_tmp7_ = _tmp6_->mark;
#line 452 "src/funcs.vala"
	_tmp8_ = marker_get_o (_tmp7_);
#line 452 "src/funcs.vala"
	_tmp9_ = _tmp8_;
#line 452 "src/funcs.vala"
	buffer_goto_offset (_tmp5_, _tmp9_);
#line 453 "src/funcs.vala"
	_tmp10_ = cur_bp;
#line 453 "src/funcs.vala"
	_tmp11_ = _tmp10_->mark;
#line 453 "src/funcs.vala"
	marker_set_o (_tmp11_, o);
#line 454 "src/funcs.vala"
	_tmp12_ = cur_bp;
#line 454 "src/funcs.vala"
	_tmp12_->mark_active = TRUE;
#line 455 "src/funcs.vala"
	thisflag = thisflag | FLAGS_NEED_RESYNC;
#line 456 "src/funcs.vala"
	result = TRUE;
#line 456 "src/funcs.vala"
	return result;
#line 2962 "funcs.c"
}

static gboolean
___lambda53__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda53_ (uniarg, args);
#line 443 "src/funcs.vala"
	return result;
#line 2973 "funcs.c"
}

static gboolean
__lambda54_ (glong uniarg,
             GeeQueue* args)
{
	gboolean result;
#line 465 "src/funcs.vala"
	funcall ("end-of-buffer", NULL, NULL);
#line 466 "src/funcs.vala"
	funcall ("set-mark-command", NULL, NULL);
#line 467 "src/funcs.vala"
	funcall ("beginning-of-buffer", NULL, NULL);
#line 468 "src/funcs.vala"
	result = TRUE;
#line 468 "src/funcs.vala"
	return result;
#line 2991 "funcs.c"
}

static gboolean
___lambda54__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda54_ (uniarg, args);
#line 462 "src/funcs.vala"
	return result;
#line 3002 "funcs.c"
}

static gboolean
__lambda55_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	gboolean result;
#line 477 "src/funcs.vala"
	minibuf_write ("C-q-", NULL);
#line 478 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 478 "src/funcs.vala"
	buffer_insert_char (_tmp0_, (gchar) getkey_unfiltered (GETKEY_DEFAULT));
#line 479 "src/funcs.vala"
	minibuf_clear ();
#line 480 "src/funcs.vala"
	result = TRUE;
#line 480 "src/funcs.vala"
	return result;
#line 3023 "funcs.c"
}

static gboolean
___lambda55__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda55_ (uniarg, args);
#line 474 "src/funcs.vala"
	return result;
#line 3034 "funcs.c"
}

static gboolean
__lambda56_ (glong uniarg,
             GeeQueue* args)
{
	gboolean ok = FALSE;
	gint i = 0;
	gint arg = 0;
	gint sgn = 0;
	gchar* a = NULL;
	gchar* _tmp0_;
	gboolean result;
#line 490 "src/funcs.vala"
	ok = TRUE;
#line 491 "src/funcs.vala"
	i = 0;
#line 491 "src/funcs.vala"
	arg = 1;
#line 491 "src/funcs.vala"
	sgn = 1;
#line 492 "src/funcs.vala"
	_tmp0_ = g_strdup ("");
#line 492 "src/funcs.vala"
	a = _tmp0_;
#line 495 "src/funcs.vala"
	pushkey (lastkey ());
#line 497 "src/funcs.vala"
	thisflag = thisflag | FLAGS_UNIARG_EMPTY;
#line 3064 "funcs.c"
	{
		gboolean _tmp1_ = FALSE;
#line 499 "src/funcs.vala"
		_tmp1_ = TRUE;
#line 499 "src/funcs.vala"
		while (TRUE) {
#line 3071 "funcs.c"
			Keystroke key = 0U;
			const gchar* _tmp2_;
#line 499 "src/funcs.vala"
			if (!_tmp1_) {
#line 3076 "funcs.c"
			}
#line 499 "src/funcs.vala"
			_tmp1_ = FALSE;
#line 500 "src/funcs.vala"
			_tmp2_ = a;
#line 500 "src/funcs.vala"
			key = binding_completion (_tmp2_);
#line 503 "src/funcs.vala"
			if (key == KBD_CANCEL) {
#line 504 "src/funcs.vala"
				ok = funcall ("keyboard-quit", NULL, NULL);
#line 505 "src/funcs.vala"
				break;
#line 3090 "funcs.c"
			} else {
#line 506 "src/funcs.vala"
				if (g_ascii_isdigit ((gchar) (key & 0xff))) {
#line 3094 "funcs.c"
					gint digit = 0;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gint _tmp16_;
#line 508 "src/funcs.vala"
					digit = (gint) ((key & 0xff) - '0');
#line 509 "src/funcs.vala"
					thisflag = thisflag & (~FLAGS_UNIARG_EMPTY);
#line 511 "src/funcs.vala"
					if ((key & KBD_META) != ((Keystroke) 0)) {
#line 3109 "funcs.c"
						const gchar* _tmp3_;
						gint _tmp4_;
						gint _tmp5_;
						const gchar* _tmp8_;
						gchar* _tmp9_;
#line 512 "src/funcs.vala"
						_tmp3_ = a;
#line 512 "src/funcs.vala"
						_tmp4_ = strlen (_tmp3_);
#line 512 "src/funcs.vala"
						_tmp5_ = _tmp4_;
#line 512 "src/funcs.vala"
						if (_tmp5_ > 0) {
#line 3123 "funcs.c"
							const gchar* _tmp6_;
							gchar* _tmp7_;
#line 513 "src/funcs.vala"
							_tmp6_ = a;
#line 513 "src/funcs.vala"
							_tmp7_ = g_strconcat (_tmp6_, " ", NULL);
#line 513 "src/funcs.vala"
							_g_free0 (a);
#line 513 "src/funcs.vala"
							a = _tmp7_;
#line 3134 "funcs.c"
						}
#line 514 "src/funcs.vala"
						_tmp8_ = a;
#line 514 "src/funcs.vala"
						_tmp9_ = g_strconcat (_tmp8_, "ESC", NULL);
#line 514 "src/funcs.vala"
						_g_free0 (a);
#line 514 "src/funcs.vala"
						a = _tmp9_;
#line 3144 "funcs.c"
					}
#line 517 "src/funcs.vala"
					_tmp10_ = a;
#line 517 "src/funcs.vala"
					_tmp11_ = g_strdup_printf ("%i", digit);
#line 517 "src/funcs.vala"
					_tmp12_ = _tmp11_;
#line 517 "src/funcs.vala"
					_tmp13_ = g_strconcat (" ", _tmp12_, NULL);
#line 517 "src/funcs.vala"
					_tmp14_ = _tmp13_;
#line 517 "src/funcs.vala"
					_tmp15_ = g_strconcat (_tmp10_, _tmp14_, NULL);
#line 517 "src/funcs.vala"
					_g_free0 (a);
#line 517 "src/funcs.vala"
					a = _tmp15_;
#line 517 "src/funcs.vala"
					_g_free0 (_tmp14_);
#line 517 "src/funcs.vala"
					_g_free0 (_tmp12_);
#line 519 "src/funcs.vala"
					if (i == 0) {
#line 520 "src/funcs.vala"
						arg = digit;
#line 3170 "funcs.c"
					} else {
#line 522 "src/funcs.vala"
						arg = (arg * 10) + digit;
#line 3174 "funcs.c"
					}
#line 524 "src/funcs.vala"
					_tmp16_ = i;
#line 524 "src/funcs.vala"
					i = _tmp16_ + 1;
#line 3180 "funcs.c"
				} else {
#line 525 "src/funcs.vala"
					if (key == (KBD_CTRL | 'u')) {
#line 3184 "funcs.c"
						const gchar* _tmp17_;
						gchar* _tmp18_;
#line 526 "src/funcs.vala"
						_tmp17_ = a;
#line 526 "src/funcs.vala"
						_tmp18_ = g_strconcat (_tmp17_, "C-u", NULL);
#line 526 "src/funcs.vala"
						_g_free0 (a);
#line 526 "src/funcs.vala"
						a = _tmp18_;
#line 527 "src/funcs.vala"
						if (i == 0) {
#line 528 "src/funcs.vala"
							arg *= 4;
#line 3199 "funcs.c"
						} else {
#line 530 "src/funcs.vala"
							break;
#line 3203 "funcs.c"
						}
					} else {
						gboolean _tmp19_ = FALSE;
#line 531 "src/funcs.vala"
						if ((key & (~KBD_META)) == ((Keystroke) '-')) {
#line 531 "src/funcs.vala"
							_tmp19_ = i == 0;
#line 3211 "funcs.c"
						} else {
#line 531 "src/funcs.vala"
							_tmp19_ = FALSE;
#line 3215 "funcs.c"
						}
#line 531 "src/funcs.vala"
						if (_tmp19_) {
#line 532 "src/funcs.vala"
							if (sgn > 0) {
#line 3221 "funcs.c"
								const gchar* _tmp20_;
								gchar* _tmp21_;
#line 533 "src/funcs.vala"
								sgn = -sgn;
#line 534 "src/funcs.vala"
								_tmp20_ = a;
#line 534 "src/funcs.vala"
								_tmp21_ = g_strconcat (_tmp20_, " -", NULL);
#line 534 "src/funcs.vala"
								_g_free0 (a);
#line 534 "src/funcs.vala"
								a = _tmp21_;
#line 536 "src/funcs.vala"
								arg = 1;
#line 537 "src/funcs.vala"
								thisflag = thisflag & (~FLAGS_UNIARG_EMPTY);
#line 3238 "funcs.c"
							}
						} else {
#line 540 "src/funcs.vala"
							ungetkey (key);
#line 541 "src/funcs.vala"
							break;
#line 3245 "funcs.c"
						}
					}
				}
			}
		}
	}
#line 545 "src/funcs.vala"
	if (ok) {
#line 546 "src/funcs.vala"
		last_uniarg = arg * sgn;
#line 547 "src/funcs.vala"
		thisflag = thisflag | FLAGS_SET_UNIARG;
#line 548 "src/funcs.vala"
		minibuf_clear ();
#line 3260 "funcs.c"
	}
#line 551 "src/funcs.vala"
	result = ok;
#line 551 "src/funcs.vala"
	_g_free0 (a);
#line 551 "src/funcs.vala"
	return result;
#line 3268 "funcs.c"
}

static gboolean
___lambda56__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda56_ (uniarg, args);
#line 487 "src/funcs.vala"
	return result;
#line 3279 "funcs.c"
}

static gboolean
__lambda57_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	Buffer* _tmp1_;
	gboolean result;
#line 565 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 565 "src/funcs.vala"
	_tmp1_ = cur_bp;
#line 565 "src/funcs.vala"
	buffer_goto_offset (_tmp0_, buffer_line_o (_tmp1_));
#line 566 "src/funcs.vala"
	while (TRUE) {
#line 3297 "funcs.c"
		gboolean _tmp2_ = FALSE;
		Buffer* _tmp3_;
		Buffer* _tmp5_;
#line 566 "src/funcs.vala"
		_tmp3_ = cur_bp;
#line 566 "src/funcs.vala"
		if (!buffer_eolp (_tmp3_)) {
#line 3305 "funcs.c"
			Buffer* _tmp4_;
#line 566 "src/funcs.vala"
			_tmp4_ = cur_bp;
#line 566 "src/funcs.vala"
			_tmp2_ = g_ascii_isspace (buffer_following_char (_tmp4_));
#line 3311 "funcs.c"
		} else {
#line 566 "src/funcs.vala"
			_tmp2_ = FALSE;
#line 3315 "funcs.c"
		}
#line 566 "src/funcs.vala"
		if (!_tmp2_) {
#line 566 "src/funcs.vala"
			break;
#line 3321 "funcs.c"
		}
#line 567 "src/funcs.vala"
		_tmp5_ = cur_bp;
#line 567 "src/funcs.vala"
		buffer_move_char (_tmp5_, (glong) 1);
#line 3327 "funcs.c"
	}
#line 568 "src/funcs.vala"
	result = TRUE;
#line 568 "src/funcs.vala"
	return result;
#line 3333 "funcs.c"
}

static gboolean
___lambda57__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda57_ (uniarg, args);
#line 562 "src/funcs.vala"
	return result;
#line 3344 "funcs.c"
}

static gboolean
__lambda58_ (glong uniarg,
             GeeQueue* args)
{
	gboolean result;
#line 577 "src/funcs.vala"
	raise ((gint) SIGTSTP);
#line 578 "src/funcs.vala"
	result = TRUE;
#line 578 "src/funcs.vala"
	return result;
#line 3358 "funcs.c"
}

static gboolean
___lambda58__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda58_ (uniarg, args);
#line 574 "src/funcs.vala"
	return result;
#line 3369 "funcs.c"
}

static gboolean
__lambda59_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	gboolean result;
#line 587 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 587 "src/funcs.vala"
	_tmp0_->mark_active = FALSE;
#line 588 "src/funcs.vala"
	minibuf_error ("Quit", NULL);
#line 589 "src/funcs.vala"
	result = FALSE;
#line 589 "src/funcs.vala"
	return result;
#line 3388 "funcs.c"
}

static gboolean
___lambda59__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda59_ (uniarg, args);
#line 584 "src/funcs.vala"
	return result;
#line 3399 "funcs.c"
}

static gboolean
__lambda60_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	gboolean result;
#line 598 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 598 "src/funcs.vala"
	result = move_with_uniarg (uniarg, (MovementNDelegate) buffer_move_word, _tmp0_);
#line 598 "src/funcs.vala"
	return result;
#line 3414 "funcs.c"
}

static gboolean
___lambda60__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda60_ (uniarg, args);
#line 595 "src/funcs.vala"
	return result;
#line 3425 "funcs.c"
}

static gboolean
__lambda61_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	gboolean result;
#line 608 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 608 "src/funcs.vala"
	result = move_with_uniarg (-uniarg, (MovementNDelegate) buffer_move_word, _tmp0_);
#line 608 "src/funcs.vala"
	return result;
#line 3440 "funcs.c"
}

static gboolean
___lambda61__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda61_ (uniarg, args);
#line 605 "src/funcs.vala"
	return result;
#line 3451 "funcs.c"
}

static gboolean
__lambda62_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	gboolean result;
#line 619 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 619 "src/funcs.vala"
	result = move_with_uniarg (uniarg, (MovementNDelegate) buffer_move_sexp, _tmp0_);
#line 619 "src/funcs.vala"
	return result;
#line 3466 "funcs.c"
}

static gboolean
___lambda62__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda62_ (uniarg, args);
#line 616 "src/funcs.vala"
	return result;
#line 3477 "funcs.c"
}

static gboolean
__lambda63_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	gboolean result;
#line 630 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 630 "src/funcs.vala"
	result = move_with_uniarg (-uniarg, (MovementNDelegate) buffer_move_sexp, _tmp0_);
#line 630 "src/funcs.vala"
	return result;
#line 3492 "funcs.c"
}

static gboolean
___lambda63__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda63_ (uniarg, args);
#line 627 "src/funcs.vala"
	return result;
#line 3503 "funcs.c"
}

static gboolean
__lambda64_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	gboolean result;
#line 641 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 641 "src/funcs.vala"
	result = transpose (uniarg, (MovementNDelegate) buffer_move_char, _tmp0_);
#line 641 "src/funcs.vala"
	return result;
#line 3518 "funcs.c"
}

static gboolean
___lambda64__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda64_ (uniarg, args);
#line 638 "src/funcs.vala"
	return result;
#line 3529 "funcs.c"
}

static gboolean
__lambda65_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	gboolean result;
#line 653 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 653 "src/funcs.vala"
	result = transpose (uniarg, (MovementNDelegate) buffer_move_word, _tmp0_);
#line 653 "src/funcs.vala"
	return result;
#line 3544 "funcs.c"
}

static gboolean
___lambda65__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda65_ (uniarg, args);
#line 650 "src/funcs.vala"
	return result;
#line 3555 "funcs.c"
}

static gboolean
__lambda66_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	gboolean result;
#line 666 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 666 "src/funcs.vala"
	result = transpose (uniarg, (MovementNDelegate) buffer_move_sexp, _tmp0_);
#line 666 "src/funcs.vala"
	return result;
#line 3570 "funcs.c"
}

static gboolean
___lambda66__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda66_ (uniarg, args);
#line 663 "src/funcs.vala"
	return result;
#line 3581 "funcs.c"
}

static gboolean
__lambda67_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	gboolean result;
#line 675 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 675 "src/funcs.vala"
	result = transpose (uniarg, (MovementNDelegate) buffer_move_line, _tmp0_);
#line 675 "src/funcs.vala"
	return result;
#line 3596 "funcs.c"
}

static gboolean
___lambda67__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda67_ (uniarg, args);
#line 672 "src/funcs.vala"
	return result;
#line 3607 "funcs.c"
}

static gboolean
__lambda68_ (glong uniarg,
             GeeQueue* args)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	Function _tmp2_;
	gboolean _tmp3_;
	gboolean result;
#line 686 "src/funcs.vala"
	_tmp0_ = lisp_func_find ("forward-word");
#line 686 "src/funcs.vala"
	_tmp1_ = _tmp0_;
#line 686 "src/funcs.vala"
	_tmp2_ = _tmp1_->func;
#line 686 "src/funcs.vala"
	_tmp3_ = mark (uniarg, _tmp2_);
#line 686 "src/funcs.vala"
	_lisp_func_unref0 (_tmp1_);
#line 686 "src/funcs.vala"
	result = _tmp3_;
#line 686 "src/funcs.vala"
	return result;
#line 3633 "funcs.c"
}

static gboolean
___lambda68__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda68_ (uniarg, args);
#line 683 "src/funcs.vala"
	return result;
#line 3644 "funcs.c"
}

static gboolean
__lambda69_ (glong uniarg,
             GeeQueue* args)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	Function _tmp2_;
	gboolean _tmp3_;
	gboolean result;
#line 695 "src/funcs.vala"
	_tmp0_ = lisp_func_find ("forward-sexp");
#line 695 "src/funcs.vala"
	_tmp1_ = _tmp0_;
#line 695 "src/funcs.vala"
	_tmp2_ = _tmp1_->func;
#line 695 "src/funcs.vala"
	_tmp3_ = mark (uniarg, _tmp2_);
#line 695 "src/funcs.vala"
	_lisp_func_unref0 (_tmp1_);
#line 695 "src/funcs.vala"
	result = _tmp3_;
#line 695 "src/funcs.vala"
	return result;
#line 3670 "funcs.c"
}

static gboolean
___lambda69__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda69_ (uniarg, args);
#line 692 "src/funcs.vala"
	return result;
#line 3681 "funcs.c"
}

static gboolean
__lambda70_ (glong uniarg,
             GeeQueue* args)
{
	gboolean ok = FALSE;
	glong n = 0L;
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 706 "src/funcs.vala"
	ok = TRUE;
#line 707 "src/funcs.vala"
	n = (glong) 1;
#line 708 "src/funcs.vala"
	if (!noarg (args)) {
#line 3698 "funcs.c"
		gboolean _tmp1_;
#line 709 "src/funcs.vala"
		_tmp1_ = int_or_uniarg (args, &n, uniarg);
#line 709 "src/funcs.vala"
		_tmp0_ = !_tmp1_;
#line 3704 "funcs.c"
	} else {
#line 708 "src/funcs.vala"
		_tmp0_ = FALSE;
#line 3708 "funcs.c"
	}
#line 708 "src/funcs.vala"
	if (_tmp0_) {
#line 710 "src/funcs.vala"
		ok = FALSE;
#line 3714 "funcs.c"
	}
#line 711 "src/funcs.vala"
	if (ok) {
#line 3718 "funcs.c"
		Buffer* _tmp2_;
#line 712 "src/funcs.vala"
		funcall ("beginning-of-line", NULL, NULL);
#line 713 "src/funcs.vala"
		_tmp2_ = cur_bp;
#line 713 "src/funcs.vala"
		ok = buffer_move_line (_tmp2_, n);
#line 3726 "funcs.c"
	}
#line 715 "src/funcs.vala"
	result = ok;
#line 715 "src/funcs.vala"
	return result;
#line 3732 "funcs.c"
}

static gboolean
___lambda70__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda70_ (uniarg, args);
#line 703 "src/funcs.vala"
	return result;
#line 3743 "funcs.c"
}

static gboolean
__lambda72_ (void)
{
	Buffer* _tmp0_;
	gboolean result;
#line 726 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 726 "src/funcs.vala"
	result = buffer_move_line (_tmp0_, (glong) -1);
#line 726 "src/funcs.vala"
	return result;
#line 3757 "funcs.c"
}

static gboolean
___lambda72__movement_delegate (gpointer self)
{
	gboolean result;
	result = __lambda72_ ();
#line 725 "src/funcs.vala"
	return result;
#line 3767 "funcs.c"
}

static gboolean
__lambda73_ (void)
{
	Buffer* _tmp0_;
	gboolean result;
#line 727 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 727 "src/funcs.vala"
	result = buffer_move_line (_tmp0_, (glong) 1);
#line 727 "src/funcs.vala"
	return result;
#line 3781 "funcs.c"
}

static gboolean
___lambda73__movement_delegate (gpointer self)
{
	gboolean result;
	result = __lambda73_ ();
#line 725 "src/funcs.vala"
	return result;
#line 3791 "funcs.c"
}

static gboolean
__lambda71_ (glong uniarg,
             GeeQueue* args)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	Function _tmp2_;
	gboolean _tmp3_;
	gboolean result;
#line 725 "src/funcs.vala"
	_tmp0_ = lisp_func_find ("beginning-of-line");
#line 725 "src/funcs.vala"
	_tmp1_ = _tmp0_;
#line 725 "src/funcs.vala"
	_tmp2_ = _tmp1_->func;
#line 725 "src/funcs.vala"
	_tmp3_ = move_paragraph (uniarg, ___lambda72__movement_delegate, NULL, ___lambda73__movement_delegate, NULL, _tmp2_);
#line 725 "src/funcs.vala"
	_lisp_func_unref0 (_tmp1_);
#line 725 "src/funcs.vala"
	result = _tmp3_;
#line 725 "src/funcs.vala"
	return result;
#line 3817 "funcs.c"
}

static gboolean
___lambda71__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda71_ (uniarg, args);
#line 722 "src/funcs.vala"
	return result;
#line 3828 "funcs.c"
}

static gboolean
__lambda75_ (void)
{
	Buffer* _tmp0_;
	gboolean result;
#line 738 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 738 "src/funcs.vala"
	result = buffer_move_line (_tmp0_, (glong) 1);
#line 738 "src/funcs.vala"
	return result;
#line 3842 "funcs.c"
}

static gboolean
___lambda75__movement_delegate (gpointer self)
{
	gboolean result;
	result = __lambda75_ ();
#line 737 "src/funcs.vala"
	return result;
#line 3852 "funcs.c"
}

static gboolean
__lambda76_ (void)
{
	Buffer* _tmp0_;
	gboolean result;
#line 739 "src/funcs.vala"
	_tmp0_ = cur_bp;
#line 739 "src/funcs.vala"
	result = buffer_move_line (_tmp0_, (glong) -1);
#line 739 "src/funcs.vala"
	return result;
#line 3866 "funcs.c"
}

static gboolean
___lambda76__movement_delegate (gpointer self)
{
	gboolean result;
	result = __lambda76_ ();
#line 737 "src/funcs.vala"
	return result;
#line 3876 "funcs.c"
}

static gboolean
__lambda74_ (glong uniarg,
             GeeQueue* args)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	Function _tmp2_;
	gboolean _tmp3_;
	gboolean result;
#line 737 "src/funcs.vala"
	_tmp0_ = lisp_func_find ("end-of-line");
#line 737 "src/funcs.vala"
	_tmp1_ = _tmp0_;
#line 737 "src/funcs.vala"
	_tmp2_ = _tmp1_->func;
#line 737 "src/funcs.vala"
	_tmp3_ = move_paragraph (uniarg, ___lambda75__movement_delegate, NULL, ___lambda76__movement_delegate, NULL, _tmp2_);
#line 737 "src/funcs.vala"
	_lisp_func_unref0 (_tmp1_);
#line 737 "src/funcs.vala"
	result = _tmp3_;
#line 737 "src/funcs.vala"
	return result;
#line 3902 "funcs.c"
}

static gboolean
___lambda74__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda74_ (uniarg, args);
#line 734 "src/funcs.vala"
	return result;
#line 3913 "funcs.c"
}

static gboolean
__lambda77_ (glong uniarg,
             GeeQueue* args)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
#line 749 "src/funcs.vala"
	_tmp0_ = last_command ();
#line 749 "src/funcs.vala"
	_tmp1_ = _tmp0_;
#line 749 "src/funcs.vala"
	_tmp2_ = lisp_func_find ("mark-paragraph");
#line 749 "src/funcs.vala"
	_tmp3_ = _tmp2_;
#line 749 "src/funcs.vala"
	_tmp4_ = _tmp1_ == _tmp3_;
#line 749 "src/funcs.vala"
	_lisp_func_unref0 (_tmp3_);
#line 749 "src/funcs.vala"
	_lisp_func_unref0 (_tmp1_);
#line 749 "src/funcs.vala"
	if (_tmp4_) {
#line 750 "src/funcs.vala"
		funcall ("exchange-point-and-mark", NULL, NULL);
#line 751 "src/funcs.vala"
		funcall ("forward-paragraph", &uniarg, NULL);
#line 752 "src/funcs.vala"
		funcall ("exchange-point-and-mark", NULL, NULL);
#line 3948 "funcs.c"
	} else {
#line 754 "src/funcs.vala"
		funcall ("forward-paragraph", &uniarg, NULL);
#line 755 "src/funcs.vala"
		funcall ("set-mark-command", NULL, NULL);
#line 756 "src/funcs.vala"
		funcall ("backward-paragraph", &uniarg, NULL);
#line 3956 "funcs.c"
	}
#line 758 "src/funcs.vala"
	result = TRUE;
#line 758 "src/funcs.vala"
	return result;
#line 3962 "funcs.c"
}

static gboolean
___lambda77__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda77_ (uniarg, args);
#line 746 "src/funcs.vala"
	return result;
#line 3973 "funcs.c"
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
#line 789 "src/funcs.vala"
	dup = g_new0 (gboolean, 1);
#line 789 "src/funcs.vala"
	memcpy (dup, self, sizeof (gboolean));
#line 789 "src/funcs.vala"
	return dup;
#line 3986 "funcs.c"
}

static gpointer
__bool_dup0 (gpointer self)
{
#line 789 "src/funcs.vala"
	return self ? _bool_dup (self) : NULL;
#line 3994 "funcs.c"
}

static gboolean
_bool_equal (const gboolean * s1,
             const gboolean * s2)
{
#line 790 "src/funcs.vala"
	if (s1 == s2) {
#line 790 "src/funcs.vala"
		return TRUE;
#line 4005 "funcs.c"
	}
#line 790 "src/funcs.vala"
	if (s1 == NULL) {
#line 790 "src/funcs.vala"
		return FALSE;
#line 4011 "funcs.c"
	}
#line 790 "src/funcs.vala"
	if (s2 == NULL) {
#line 790 "src/funcs.vala"
		return FALSE;
#line 4017 "funcs.c"
	}
#line 790 "src/funcs.vala"
	return (*s1) == (*s2);
#line 4021 "funcs.c"
}

static gboolean
__lambda78_ (glong uniarg,
             GeeQueue* args)
{
	gboolean ok = FALSE;
	Marker* m = NULL;
	Marker* _tmp0_;
	Buffer* _tmp1_;
	Marker* m_end = NULL;
	Marker* _tmp3_;
	Buffer* _tmp4_;
	Marker* _tmp14_;
	gboolean* ret = NULL;
	gboolean _tmp15_;
	gboolean* _tmp16_;
	gboolean* _tmp20_;
	Buffer* _tmp21_;
	Marker* _tmp22_;
	gsize _tmp23_;
	gsize _tmp24_;
	Marker* _tmp25_;
	gboolean result;
#line 768 "src/funcs.vala"
	ok = TRUE;
#line 769 "src/funcs.vala"
	_tmp0_ = marker_point ();
#line 769 "src/funcs.vala"
	m = _tmp0_;
#line 771 "src/funcs.vala"
	funcall ("forward-paragraph", NULL, NULL);
#line 772 "src/funcs.vala"
	_tmp1_ = cur_bp;
#line 772 "src/funcs.vala"
	if (buffer_is_empty_line (_tmp1_)) {
#line 4058 "funcs.c"
		Buffer* _tmp2_;
#line 773 "src/funcs.vala"
		_tmp2_ = cur_bp;
#line 773 "src/funcs.vala"
		buffer_move_line (_tmp2_, (glong) -1);
#line 4064 "funcs.c"
	}
#line 774 "src/funcs.vala"
	_tmp3_ = marker_point ();
#line 774 "src/funcs.vala"
	m_end = _tmp3_;
#line 776 "src/funcs.vala"
	funcall ("backward-paragraph", NULL, NULL);
#line 777 "src/funcs.vala"
	_tmp4_ = cur_bp;
#line 777 "src/funcs.vala"
	if (buffer_is_empty_line (_tmp4_)) {
#line 4076 "funcs.c"
		Buffer* _tmp5_;
#line 779 "src/funcs.vala"
		_tmp5_ = cur_bp;
#line 779 "src/funcs.vala"
		buffer_move_line (_tmp5_, (glong) 1);
#line 4082 "funcs.c"
	}
#line 781 "src/funcs.vala"
	while (TRUE) {
#line 4086 "funcs.c"
		Buffer* _tmp6_;
		Buffer* _tmp7_;
		gsize _tmp8_;
		gsize _tmp9_;
		Marker* _tmp10_;
		gsize _tmp11_;
		gsize _tmp12_;
		Buffer* _tmp13_;
#line 781 "src/funcs.vala"
		_tmp6_ = cur_bp;
#line 781 "src/funcs.vala"
		_tmp7_ = cur_bp;
#line 781 "src/funcs.vala"
		_tmp8_ = buffer_get_pt (_tmp7_);
#line 781 "src/funcs.vala"
		_tmp9_ = _tmp8_;
#line 781 "src/funcs.vala"
		_tmp10_ = m_end;
#line 781 "src/funcs.vala"
		_tmp11_ = marker_get_o (_tmp10_);
#line 781 "src/funcs.vala"
		_tmp12_ = _tmp11_;
#line 781 "src/funcs.vala"
		if (!(buffer_end_of_line (_tmp6_, _tmp9_) < _tmp12_)) {
#line 781 "src/funcs.vala"
			break;
#line 4113 "funcs.c"
		}
#line 782 "src/funcs.vala"
		funcall ("end-of-line", NULL, NULL);
#line 783 "src/funcs.vala"
		_tmp13_ = cur_bp;
#line 783 "src/funcs.vala"
		buffer_delete_char (_tmp13_);
#line 784 "src/funcs.vala"
		funcall ("just-one-space", NULL, NULL);
#line 4123 "funcs.c"
	}
#line 786 "src/funcs.vala"
	_tmp14_ = m_end;
#line 786 "src/funcs.vala"
	marker_unchain (_tmp14_);
#line 788 "src/funcs.vala"
	funcall ("end-of-line", NULL, NULL);
#line 789 "src/funcs.vala"
	_tmp15_ = FALSE;
#line 789 "src/funcs.vala"
	_tmp16_ = __bool_dup0 (&_tmp15_);
#line 789 "src/funcs.vala"
	ret = _tmp16_;
#line 790 "src/funcs.vala"
	while (TRUE) {
#line 4139 "funcs.c"
		gboolean* _tmp17_;
		gboolean* _tmp18_;
		gboolean _tmp19_;
#line 790 "src/funcs.vala"
		_tmp17_ = fill_break_line ();
#line 790 "src/funcs.vala"
		_g_free0 (ret);
#line 790 "src/funcs.vala"
		ret = _tmp17_;
#line 790 "src/funcs.vala"
		_tmp18_ = ret;
#line 790 "src/funcs.vala"
		_tmp19_ = TRUE;
#line 790 "src/funcs.vala"
		if (!(_bool_equal (_tmp18_, &_tmp19_) == TRUE)) {
#line 790 "src/funcs.vala"
			break;
#line 4157 "funcs.c"
		}
	}
#line 792 "src/funcs.vala"
	_tmp20_ = ret;
#line 792 "src/funcs.vala"
	if (_tmp20_ == NULL) {
#line 793 "src/funcs.vala"
		ok = FALSE;
#line 4166 "funcs.c"
	}
#line 795 "src/funcs.vala"
	_tmp21_ = cur_bp;
#line 795 "src/funcs.vala"
	_tmp22_ = m;
#line 795 "src/funcs.vala"
	_tmp23_ = marker_get_o (_tmp22_);
#line 795 "src/funcs.vala"
	_tmp24_ = _tmp23_;
#line 795 "src/funcs.vala"
	buffer_goto_offset (_tmp21_, _tmp24_);
#line 796 "src/funcs.vala"
	_tmp25_ = m;
#line 796 "src/funcs.vala"
	marker_unchain (_tmp25_);
#line 798 "src/funcs.vala"
	result = ok;
#line 798 "src/funcs.vala"
	_g_free0 (ret);
#line 798 "src/funcs.vala"
	_marker_unref0 (m_end);
#line 798 "src/funcs.vala"
	_marker_unref0 (m);
#line 798 "src/funcs.vala"
	return result;
#line 4192 "funcs.c"
}

static gboolean
___lambda78__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda78_ (uniarg, args);
#line 765 "src/funcs.vala"
	return result;
#line 4203 "funcs.c"
}

static gboolean
_setcase_word_lowercase_movement_delegate (gpointer self)
{
	gboolean result;
	result = setcase_word_lowercase ();
#line 813 "src/funcs.vala"
	return result;
#line 4213 "funcs.c"
}

static gboolean
__lambda79_ (glong uniarg,
             GeeQueue* args)
{
	gboolean ok = FALSE;
	glong arg = 0L;
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 807 "src/funcs.vala"
	ok = TRUE;
#line 808 "src/funcs.vala"
	arg = (glong) 1;
#line 809 "src/funcs.vala"
	if (!noarg (args)) {
#line 4230 "funcs.c"
		gboolean _tmp1_;
#line 810 "src/funcs.vala"
		_tmp1_ = int_or_uniarg (args, &arg, uniarg);
#line 810 "src/funcs.vala"
		_tmp0_ = !_tmp1_;
#line 4236 "funcs.c"
	} else {
#line 809 "src/funcs.vala"
		_tmp0_ = FALSE;
#line 4240 "funcs.c"
	}
#line 809 "src/funcs.vala"
	if (_tmp0_) {
#line 811 "src/funcs.vala"
		ok = FALSE;
#line 4246 "funcs.c"
	}
#line 812 "src/funcs.vala"
	if (ok) {
#line 813 "src/funcs.vala"
		ok = execute_with_uniarg (arg, _setcase_word_lowercase_movement_delegate, NULL, NULL, NULL);
#line 4252 "funcs.c"
	}
#line 814 "src/funcs.vala"
	result = ok;
#line 814 "src/funcs.vala"
	return result;
#line 4258 "funcs.c"
}

static gboolean
___lambda79__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda79_ (uniarg, args);
#line 804 "src/funcs.vala"
	return result;
#line 4269 "funcs.c"
}

static gboolean
_setcase_word_uppercase_movement_delegate (gpointer self)
{
	gboolean result;
	result = setcase_word_uppercase ();
#line 829 "src/funcs.vala"
	return result;
#line 4279 "funcs.c"
}

static gboolean
__lambda80_ (glong uniarg,
             GeeQueue* args)
{
	gboolean ok = FALSE;
	glong arg = 0L;
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 823 "src/funcs.vala"
	ok = TRUE;
#line 824 "src/funcs.vala"
	arg = (glong) 1;
#line 825 "src/funcs.vala"
	if (!noarg (args)) {
#line 4296 "funcs.c"
		gboolean _tmp1_;
#line 826 "src/funcs.vala"
		_tmp1_ = int_or_uniarg (args, &arg, uniarg);
#line 826 "src/funcs.vala"
		_tmp0_ = !_tmp1_;
#line 4302 "funcs.c"
	} else {
#line 825 "src/funcs.vala"
		_tmp0_ = FALSE;
#line 4306 "funcs.c"
	}
#line 825 "src/funcs.vala"
	if (_tmp0_) {
#line 827 "src/funcs.vala"
		ok = FALSE;
#line 4312 "funcs.c"
	}
#line 828 "src/funcs.vala"
	if (ok) {
#line 829 "src/funcs.vala"
		ok = execute_with_uniarg (arg, _setcase_word_uppercase_movement_delegate, NULL, NULL, NULL);
#line 4318 "funcs.c"
	}
#line 830 "src/funcs.vala"
	result = ok;
#line 830 "src/funcs.vala"
	return result;
#line 4324 "funcs.c"
}

static gboolean
___lambda80__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda80_ (uniarg, args);
#line 820 "src/funcs.vala"
	return result;
#line 4335 "funcs.c"
}

static gboolean
_setcase_word_capitalize_movement_delegate (gpointer self)
{
	gboolean result;
	result = setcase_word_capitalize ();
#line 845 "src/funcs.vala"
	return result;
#line 4345 "funcs.c"
}

static gboolean
__lambda81_ (glong uniarg,
             GeeQueue* args)
{
	gboolean ok = FALSE;
	glong arg = 0L;
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 839 "src/funcs.vala"
	ok = TRUE;
#line 840 "src/funcs.vala"
	arg = (glong) 1;
#line 841 "src/funcs.vala"
	if (!noarg (args)) {
#line 4362 "funcs.c"
		gboolean _tmp1_;
#line 842 "src/funcs.vala"
		_tmp1_ = int_or_uniarg (args, &arg, uniarg);
#line 842 "src/funcs.vala"
		_tmp0_ = !_tmp1_;
#line 4368 "funcs.c"
	} else {
#line 841 "src/funcs.vala"
		_tmp0_ = FALSE;
#line 4372 "funcs.c"
	}
#line 841 "src/funcs.vala"
	if (_tmp0_) {
#line 843 "src/funcs.vala"
		ok = FALSE;
#line 4378 "funcs.c"
	}
#line 844 "src/funcs.vala"
	if (ok) {
#line 845 "src/funcs.vala"
		ok = execute_with_uniarg (arg, _setcase_word_capitalize_movement_delegate, NULL, NULL, NULL);
#line 4384 "funcs.c"
	}
#line 846 "src/funcs.vala"
	result = ok;
#line 846 "src/funcs.vala"
	return result;
#line 4390 "funcs.c"
}

static gboolean
___lambda81__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda81_ (uniarg, args);
#line 836 "src/funcs.vala"
	return result;
#line 4401 "funcs.c"
}

static gchar
__lambda83_ (gchar c)
{
	gchar result;
#line 857 "src/funcs.vala"
	result = g_ascii_toupper (c);
#line 857 "src/funcs.vala"
	return result;
#line 4412 "funcs.c"
}

static gchar
___lambda83__char_transform (gchar c,
                             gpointer self)
{
	gchar result;
	result = __lambda83_ (c);
#line 857 "src/funcs.vala"
	return result;
#line 4423 "funcs.c"
}

static gboolean
__lambda82_ (glong uniarg,
             GeeQueue* args)
{
	gboolean result;
#line 857 "src/funcs.vala"
	result = setcase_region (___lambda83__char_transform, NULL);
#line 857 "src/funcs.vala"
	return result;
#line 4435 "funcs.c"
}

static gboolean
___lambda82__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda82_ (uniarg, args);
#line 854 "src/funcs.vala"
	return result;
#line 4446 "funcs.c"
}

static gchar
__lambda85_ (gchar c)
{
	gchar result;
#line 866 "src/funcs.vala"
	result = g_ascii_tolower (c);
#line 866 "src/funcs.vala"
	return result;
#line 4457 "funcs.c"
}

static gchar
___lambda85__char_transform (gchar c,
                             gpointer self)
{
	gchar result;
	result = __lambda85_ (c);
#line 866 "src/funcs.vala"
	return result;
#line 4468 "funcs.c"
}

static gboolean
__lambda84_ (glong uniarg,
             GeeQueue* args)
{
	gboolean result;
#line 866 "src/funcs.vala"
	result = setcase_region (___lambda85__char_transform, NULL);
#line 866 "src/funcs.vala"
	return result;
#line 4480 "funcs.c"
}

static gboolean
___lambda84__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda84_ (uniarg, args);
#line 863 "src/funcs.vala"
	return result;
#line 4491 "funcs.c"
}

static gboolean
__lambda86_ (glong uniarg,
             GeeQueue* args)
{
	gboolean ok = FALSE;
	gboolean _tmp0_ = FALSE;
	Buffer* _tmp1_;
	gboolean result;
#line 875 "src/funcs.vala"
	ok = TRUE;
#line 876 "src/funcs.vala"
	_tmp1_ = cur_bp;
#line 876 "src/funcs.vala"
	if (buffer_warn_if_no_mark (_tmp1_)) {
#line 876 "src/funcs.vala"
		_tmp0_ = TRUE;
#line 4510 "funcs.c"
	} else {
		Region* _tmp2_;
		Region* _tmp3_;
#line 876 "src/funcs.vala"
		_tmp2_ = region_calculate ();
#line 876 "src/funcs.vala"
		_tmp3_ = _tmp2_;
#line 876 "src/funcs.vala"
		_tmp0_ = !region_delete (_tmp3_);
#line 876 "src/funcs.vala"
		_region_unref0 (_tmp3_);
#line 4522 "funcs.c"
	}
#line 876 "src/funcs.vala"
	if (_tmp0_) {
#line 877 "src/funcs.vala"
		ok = FALSE;
#line 4528 "funcs.c"
	} else {
		Buffer* _tmp4_;
#line 879 "src/funcs.vala"
		_tmp4_ = cur_bp;
#line 879 "src/funcs.vala"
		_tmp4_->mark_active = FALSE;
#line 4535 "funcs.c"
	}
#line 880 "src/funcs.vala"
	result = ok;
#line 880 "src/funcs.vala"
	return result;
#line 4541 "funcs.c"
}

static gboolean
___lambda86__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda86_ (uniarg, args);
#line 872 "src/funcs.vala"
	return result;
#line 4552 "funcs.c"
}

static gboolean
__lambda87_ (glong uniarg,
             GeeQueue* args)
{
	Marker* m = NULL;
	Marker* _tmp0_;
	Region* r = NULL;
	Buffer* _tmp1_;
	Buffer* _tmp2_;
	Region* _tmp3_;
	gboolean _tmp4_ = FALSE;
	Buffer* _tmp25_;
	Marker* _tmp26_;
	gsize _tmp27_;
	gsize _tmp28_;
	gboolean singleblank = FALSE;
	Buffer* _tmp29_;
	gboolean _tmp67_ = FALSE;
	Region* _tmp68_;
	gsize _tmp69_;
	gsize _tmp70_;
	Buffer* _tmp71_;
	gsize _tmp72_;
	gsize _tmp73_;
	gboolean at_eob = FALSE;
	Region* _tmp86_;
	gsize _tmp87_;
	gsize _tmp88_;
	Region* _tmp89_;
	gsize _tmp90_;
	gsize _tmp91_;
	Marker* _tmp93_;
	Buffer* _tmp94_;
	gboolean result;
#line 889 "src/funcs.vala"
	_tmp0_ = marker_point ();
#line 889 "src/funcs.vala"
	m = _tmp0_;
#line 890 "src/funcs.vala"
	_tmp1_ = cur_bp;
#line 890 "src/funcs.vala"
	_tmp2_ = cur_bp;
#line 890 "src/funcs.vala"
	_tmp3_ = region_new (buffer_line_o (_tmp1_), buffer_line_o (_tmp2_));
#line 890 "src/funcs.vala"
	r = _tmp3_;
#line 893 "src/funcs.vala"
	if (funcall ("forward-line", NULL, NULL)) {
#line 4603 "funcs.c"
		Buffer* _tmp5_;
#line 893 "src/funcs.vala"
		_tmp5_ = cur_bp;
#line 893 "src/funcs.vala"
		_tmp4_ = buffer_is_blank_line (_tmp5_);
#line 4609 "funcs.c"
	} else {
#line 893 "src/funcs.vala"
		_tmp4_ = FALSE;
#line 4613 "funcs.c"
	}
#line 893 "src/funcs.vala"
	if (_tmp4_) {
#line 4617 "funcs.c"
		Region* _tmp6_;
		Buffer* _tmp7_;
		gsize _tmp8_;
		gsize _tmp9_;
		Region* _tmp18_;
		Region* _tmp19_;
		gsize _tmp20_;
		gsize _tmp21_;
		Buffer* _tmp22_;
		gsize _tmp23_;
		gsize _tmp24_;
#line 894 "src/funcs.vala"
		_tmp6_ = r;
#line 894 "src/funcs.vala"
		_tmp7_ = cur_bp;
#line 894 "src/funcs.vala"
		_tmp8_ = buffer_get_pt (_tmp7_);
#line 894 "src/funcs.vala"
		_tmp9_ = _tmp8_;
#line 894 "src/funcs.vala"
		region_set_start (_tmp6_, _tmp9_);
#line 4639 "funcs.c"
		{
			gboolean _tmp10_ = FALSE;
#line 895 "src/funcs.vala"
			_tmp10_ = TRUE;
#line 895 "src/funcs.vala"
			while (TRUE) {
#line 4646 "funcs.c"
				Region* _tmp13_;
				Buffer* _tmp14_;
				Buffer* _tmp15_;
				gsize _tmp16_;
				gsize _tmp17_;
#line 895 "src/funcs.vala"
				if (!_tmp10_) {
#line 4654 "funcs.c"
					gboolean _tmp11_ = FALSE;
#line 897 "src/funcs.vala"
					if (funcall ("forward-line", NULL, NULL)) {
#line 4658 "funcs.c"
						Buffer* _tmp12_;
#line 897 "src/funcs.vala"
						_tmp12_ = cur_bp;
#line 897 "src/funcs.vala"
						_tmp11_ = buffer_is_blank_line (_tmp12_);
#line 4664 "funcs.c"
					} else {
#line 897 "src/funcs.vala"
						_tmp11_ = FALSE;
#line 4668 "funcs.c"
					}
#line 897 "src/funcs.vala"
					if (!_tmp11_) {
#line 897 "src/funcs.vala"
						break;
#line 4674 "funcs.c"
					}
				}
#line 895 "src/funcs.vala"
				_tmp10_ = FALSE;
#line 896 "src/funcs.vala"
				_tmp13_ = r;
#line 896 "src/funcs.vala"
				_tmp14_ = cur_bp;
#line 896 "src/funcs.vala"
				_tmp15_ = cur_bp;
#line 896 "src/funcs.vala"
				_tmp16_ = buffer_get_pt (_tmp15_);
#line 896 "src/funcs.vala"
				_tmp17_ = _tmp16_;
#line 896 "src/funcs.vala"
				region_set_end (_tmp13_, buffer_next_line (_tmp14_, _tmp17_));
#line 4691 "funcs.c"
			}
		}
#line 898 "src/funcs.vala"
		_tmp18_ = r;
#line 898 "src/funcs.vala"
		_tmp19_ = r;
#line 898 "src/funcs.vala"
		_tmp20_ = region_get_end (_tmp19_);
#line 898 "src/funcs.vala"
		_tmp21_ = _tmp20_;
#line 898 "src/funcs.vala"
		_tmp22_ = cur_bp;
#line 898 "src/funcs.vala"
		_tmp23_ = buffer_get_length (_tmp22_);
#line 898 "src/funcs.vala"
		_tmp24_ = _tmp23_;
#line 898 "src/funcs.vala"
		region_set_end (_tmp18_, MIN (_tmp21_, _tmp24_));
#line 4710 "funcs.c"
	}
#line 900 "src/funcs.vala"
	_tmp25_ = cur_bp;
#line 900 "src/funcs.vala"
	_tmp26_ = m;
#line 900 "src/funcs.vala"
	_tmp27_ = marker_get_o (_tmp26_);
#line 900 "src/funcs.vala"
	_tmp28_ = _tmp27_;
#line 900 "src/funcs.vala"
	buffer_goto_offset (_tmp25_, _tmp28_);
#line 903 "src/funcs.vala"
	singleblank = TRUE;
#line 904 "src/funcs.vala"
	_tmp29_ = cur_bp;
#line 904 "src/funcs.vala"
	if (buffer_is_blank_line (_tmp29_)) {
#line 4728 "funcs.c"
		Region* _tmp30_;
		Region* _tmp31_;
		gsize _tmp32_;
		gsize _tmp33_;
		Buffer* _tmp34_;
		Buffer* _tmp35_;
		gsize _tmp36_;
		gsize _tmp37_;
		Buffer* _tmp44_;
		Marker* _tmp45_;
		gsize _tmp46_;
		gsize _tmp47_;
		gboolean _tmp48_ = FALSE;
		Region* _tmp49_;
		gsize _tmp50_;
		gsize _tmp51_;
		Buffer* _tmp52_;
		Region* _tmp60_;
		Region* _tmp61_;
		gsize _tmp62_;
		gsize _tmp63_;
		Buffer* _tmp64_;
		gsize _tmp65_;
		gsize _tmp66_;
#line 905 "src/funcs.vala"
		_tmp30_ = r;
#line 905 "src/funcs.vala"
		_tmp31_ = r;
#line 905 "src/funcs.vala"
		_tmp32_ = region_get_end (_tmp31_);
#line 905 "src/funcs.vala"
		_tmp33_ = _tmp32_;
#line 905 "src/funcs.vala"
		_tmp34_ = cur_bp;
#line 905 "src/funcs.vala"
		_tmp35_ = cur_bp;
#line 905 "src/funcs.vala"
		_tmp36_ = buffer_get_pt (_tmp35_);
#line 905 "src/funcs.vala"
		_tmp37_ = _tmp36_;
#line 905 "src/funcs.vala"
		region_set_end (_tmp30_, MAX (_tmp33_, buffer_next_line (_tmp34_, _tmp37_)));
#line 4771 "funcs.c"
		{
			gboolean _tmp38_ = FALSE;
#line 906 "src/funcs.vala"
			_tmp38_ = TRUE;
#line 906 "src/funcs.vala"
			while (TRUE) {
#line 4778 "funcs.c"
				Region* _tmp42_;
				Buffer* _tmp43_;
#line 906 "src/funcs.vala"
				if (!_tmp38_) {
#line 4783 "funcs.c"
					gboolean _tmp39_ = FALSE;
					glong _tmp40_;
#line 908 "src/funcs.vala"
					_tmp40_ = (glong) -1;
#line 908 "src/funcs.vala"
					if (funcall ("forward-line", &_tmp40_, NULL)) {
#line 4790 "funcs.c"
						Buffer* _tmp41_;
#line 908 "src/funcs.vala"
						_tmp41_ = cur_bp;
#line 908 "src/funcs.vala"
						_tmp39_ = buffer_is_blank_line (_tmp41_);
#line 4796 "funcs.c"
					} else {
#line 908 "src/funcs.vala"
						_tmp39_ = FALSE;
#line 4800 "funcs.c"
					}
#line 908 "src/funcs.vala"
					if (!_tmp39_) {
#line 908 "src/funcs.vala"
						break;
#line 4806 "funcs.c"
					}
				}
#line 906 "src/funcs.vala"
				_tmp38_ = FALSE;
#line 907 "src/funcs.vala"
				_tmp42_ = r;
#line 907 "src/funcs.vala"
				_tmp43_ = cur_bp;
#line 907 "src/funcs.vala"
				region_set_start (_tmp42_, buffer_line_o (_tmp43_));
#line 4817 "funcs.c"
			}
		}
#line 909 "src/funcs.vala"
		_tmp44_ = cur_bp;
#line 909 "src/funcs.vala"
		_tmp45_ = m;
#line 909 "src/funcs.vala"
		_tmp46_ = marker_get_o (_tmp45_);
#line 909 "src/funcs.vala"
		_tmp47_ = _tmp46_;
#line 909 "src/funcs.vala"
		buffer_goto_offset (_tmp44_, _tmp47_);
#line 910 "src/funcs.vala"
		_tmp49_ = r;
#line 910 "src/funcs.vala"
		_tmp50_ = region_get_start (_tmp49_);
#line 910 "src/funcs.vala"
		_tmp51_ = _tmp50_;
#line 910 "src/funcs.vala"
		_tmp52_ = cur_bp;
#line 910 "src/funcs.vala"
		if (_tmp51_ != buffer_line_o (_tmp52_)) {
#line 910 "src/funcs.vala"
			_tmp48_ = TRUE;
#line 4842 "funcs.c"
		} else {
			Region* _tmp53_;
			gsize _tmp54_;
			gsize _tmp55_;
			Buffer* _tmp56_;
			Buffer* _tmp57_;
			gsize _tmp58_;
			gsize _tmp59_;
#line 911 "src/funcs.vala"
			_tmp53_ = r;
#line 911 "src/funcs.vala"
			_tmp54_ = region_get_end (_tmp53_);
#line 911 "src/funcs.vala"
			_tmp55_ = _tmp54_;
#line 911 "src/funcs.vala"
			_tmp56_ = cur_bp;
#line 911 "src/funcs.vala"
			_tmp57_ = cur_bp;
#line 911 "src/funcs.vala"
			_tmp58_ = buffer_get_pt (_tmp57_);
#line 911 "src/funcs.vala"
			_tmp59_ = _tmp58_;
#line 911 "src/funcs.vala"
			_tmp48_ = _tmp55_ > buffer_next_line (_tmp56_, _tmp59_);
#line 4867 "funcs.c"
		}
#line 910 "src/funcs.vala"
		if (_tmp48_) {
#line 912 "src/funcs.vala"
			singleblank = FALSE;
#line 4873 "funcs.c"
		}
#line 913 "src/funcs.vala"
		_tmp60_ = r;
#line 913 "src/funcs.vala"
		_tmp61_ = r;
#line 913 "src/funcs.vala"
		_tmp62_ = region_get_end (_tmp61_);
#line 913 "src/funcs.vala"
		_tmp63_ = _tmp62_;
#line 913 "src/funcs.vala"
		_tmp64_ = cur_bp;
#line 913 "src/funcs.vala"
		_tmp65_ = buffer_get_length (_tmp64_);
#line 913 "src/funcs.vala"
		_tmp66_ = _tmp65_;
#line 913 "src/funcs.vala"
		region_set_end (_tmp60_, MIN (_tmp63_, _tmp66_));
#line 4891 "funcs.c"
	}
#line 917 "src/funcs.vala"
	_tmp68_ = r;
#line 917 "src/funcs.vala"
	_tmp69_ = region_get_end (_tmp68_);
#line 917 "src/funcs.vala"
	_tmp70_ = _tmp69_;
#line 917 "src/funcs.vala"
	_tmp71_ = cur_bp;
#line 917 "src/funcs.vala"
	_tmp72_ = buffer_get_length (_tmp71_);
#line 917 "src/funcs.vala"
	_tmp73_ = _tmp72_;
#line 917 "src/funcs.vala"
	if (_tmp70_ == _tmp73_) {
#line 4907 "funcs.c"
		Region* _tmp74_;
		gsize _tmp75_;
		gsize _tmp76_;
#line 917 "src/funcs.vala"
		_tmp74_ = r;
#line 917 "src/funcs.vala"
		_tmp75_ = region_get_start (_tmp74_);
#line 917 "src/funcs.vala"
		_tmp76_ = _tmp75_;
#line 917 "src/funcs.vala"
		_tmp67_ = _tmp76_ > ((gsize) 0);
#line 4919 "funcs.c"
	} else {
#line 917 "src/funcs.vala"
		_tmp67_ = FALSE;
#line 4923 "funcs.c"
	}
#line 917 "src/funcs.vala"
	at_eob = _tmp67_;
#line 918 "src/funcs.vala"
	if (at_eob) {
#line 4929 "funcs.c"
		Region* _tmp77_;
		Region* _tmp78_;
		gsize _tmp79_;
		gsize _tmp80_;
		Buffer* _tmp81_;
		const gchar* _tmp82_;
		const gchar* _tmp83_;
		gint _tmp84_;
		gint _tmp85_;
#line 919 "src/funcs.vala"
		_tmp77_ = r;
#line 919 "src/funcs.vala"
		_tmp78_ = r;
#line 919 "src/funcs.vala"
		_tmp79_ = region_get_start (_tmp78_);
#line 919 "src/funcs.vala"
		_tmp80_ = _tmp79_;
#line 919 "src/funcs.vala"
		_tmp81_ = cur_bp;
#line 919 "src/funcs.vala"
		_tmp82_ = buffer_get_eol (_tmp81_);
#line 919 "src/funcs.vala"
		_tmp83_ = _tmp82_;
#line 919 "src/funcs.vala"
		_tmp84_ = strlen (_tmp83_);
#line 919 "src/funcs.vala"
		_tmp85_ = _tmp84_;
#line 919 "src/funcs.vala"
		region_set_start (_tmp77_, _tmp80_ - _tmp85_);
#line 4959 "funcs.c"
	}
#line 922 "src/funcs.vala"
	_tmp86_ = r;
#line 922 "src/funcs.vala"
	_tmp87_ = region_get_start (_tmp86_);
#line 922 "src/funcs.vala"
	_tmp88_ = _tmp87_;
#line 922 "src/funcs.vala"
	_tmp89_ = r;
#line 922 "src/funcs.vala"
	_tmp90_ = region_get_end (_tmp89_);
#line 922 "src/funcs.vala"
	_tmp91_ = _tmp90_;
#line 922 "src/funcs.vala"
	if (_tmp88_ < _tmp91_) {
#line 4975 "funcs.c"
		Region* _tmp92_;
#line 923 "src/funcs.vala"
		_tmp92_ = r;
#line 923 "src/funcs.vala"
		region_delete (_tmp92_);
#line 4981 "funcs.c"
	}
#line 926 "src/funcs.vala"
	if (!singleblank) {
#line 927 "src/funcs.vala"
		if (!at_eob) {
#line 928 "src/funcs.vala"
			intercalate_newline ();
#line 4989 "funcs.c"
		} else {
#line 930 "src/funcs.vala"
			insert_newline ();
#line 4993 "funcs.c"
		}
	}
#line 933 "src/funcs.vala"
	_tmp93_ = m;
#line 933 "src/funcs.vala"
	marker_unchain (_tmp93_);
#line 934 "src/funcs.vala"
	_tmp94_ = cur_bp;
#line 934 "src/funcs.vala"
	_tmp94_->mark_active = FALSE;
#line 936 "src/funcs.vala"
	result = TRUE;
#line 936 "src/funcs.vala"
	_region_unref0 (r);
#line 936 "src/funcs.vala"
	_marker_unref0 (m);
#line 936 "src/funcs.vala"
	return result;
#line 5012 "funcs.c"
}

static gboolean
___lambda87__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda87_ (uniarg, args);
#line 886 "src/funcs.vala"
	return result;
#line 5023 "funcs.c"
}

void
funcs_init (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
	LispFunc* _tmp4_;
	LispFunc* _tmp5_;
	LispFunc* _tmp6_;
	LispFunc* _tmp7_;
	LispFunc* _tmp8_;
	LispFunc* _tmp9_;
	LispFunc* _tmp10_;
	LispFunc* _tmp11_;
	LispFunc* _tmp12_;
	LispFunc* _tmp13_;
	LispFunc* _tmp14_;
	LispFunc* _tmp15_;
	LispFunc* _tmp16_;
	LispFunc* _tmp17_;
	LispFunc* _tmp18_;
	LispFunc* _tmp19_;
	LispFunc* _tmp20_;
	LispFunc* _tmp21_;
	LispFunc* _tmp22_;
	LispFunc* _tmp23_;
	LispFunc* _tmp24_;
	LispFunc* _tmp25_;
	LispFunc* _tmp26_;
	LispFunc* _tmp27_;
	LispFunc* _tmp28_;
	LispFunc* _tmp29_;
	LispFunc* _tmp30_;
	LispFunc* _tmp31_;
	LispFunc* _tmp32_;
	LispFunc* _tmp33_;
	LispFunc* _tmp34_;
	LispFunc* _tmp35_;
	LispFunc* _tmp36_;
	LispFunc* _tmp37_;
	LispFunc* _tmp38_;
	LispFunc* _tmp39_;
	LispFunc* _tmp40_;
	LispFunc* _tmp41_;
	LispFunc* _tmp42_;
	LispFunc* _tmp43_;
	LispFunc* _tmp44_;
	LispFunc* _tmp45_;
	LispFunc* _tmp46_;
	LispFunc* _tmp47_;
	LispFunc* _tmp48_;
	LispFunc* _tmp49_;
	LispFunc* _tmp50_;
	LispFunc* _tmp51_;
	LispFunc* _tmp52_;
	LispFunc* _tmp53_;
	LispFunc* _tmp54_;
	LispFunc* _tmp55_;
	LispFunc* _tmp56_;
	LispFunc* _tmp57_;
	LispFunc* _tmp58_;
	LispFunc* _tmp59_;
	LispFunc* _tmp60_;
	LispFunc* _tmp61_;
	LispFunc* _tmp62_;
	LispFunc* _tmp63_;
	LispFunc* _tmp64_;
	LispFunc* _tmp65_;
	LispFunc* _tmp66_;
	LispFunc* _tmp67_;
	LispFunc* _tmp68_;
	LispFunc* _tmp69_;
#line 315 "src/funcs.vala"
	_tmp0_ = lisp_func_new ("list-buffers", ___lambda46__function, TRUE, "Display a list of names of existing buffers.\n" \
"The list is displayed in a buffer named `*Buffer List*'.\n" \
"Note that buffers with names starting with spaces are omitted.\n" \
"\n" \
"The \\\"R\\\" column has a \\\"%\\\" if the buffer is read-only.\n" \
"The \\\"M\\\" column has a \\\"*\\\" if it is modified.");
#line 315 "src/funcs.vala"
	_tmp1_ = _tmp0_;
#line 315 "src/funcs.vala"
	_lisp_func_unref0 (_tmp1_);
#line 359 "src/funcs.vala"
	_tmp2_ = lisp_func_new ("toggle-read-only", ___lambda48__function, TRUE, "Change whether this buffer is visiting its file read-only.");
#line 359 "src/funcs.vala"
	_tmp3_ = _tmp2_;
#line 359 "src/funcs.vala"
	_lisp_func_unref0 (_tmp3_);
#line 369 "src/funcs.vala"
	_tmp4_ = lisp_func_new ("auto-fill-mode", ___lambda49__function, TRUE, "Toggle Auto Fill mode.\n" \
"In Auto Fill mode, inserting a space at a column beyond `fill-column'\n" \
"automatically breaks the line at a previous space.");
#line 369 "src/funcs.vala"
	_tmp5_ = _tmp4_;
#line 369 "src/funcs.vala"
	_lisp_func_unref0 (_tmp5_);
#line 381 "src/funcs.vala"
	_tmp6_ = lisp_func_new ("set-fill-column", ___lambda50__function, TRUE, "Set `fill-column' to specified argument.\n" \
"Use C-u followed by a number to specify a column.\n" \
"Just C-u as argument means to use the current column.");
#line 381 "src/funcs.vala"
	_tmp7_ = _tmp6_;
#line 381 "src/funcs.vala"
	_lisp_func_unref0 (_tmp7_);
#line 421 "src/funcs.vala"
	_tmp8_ = lisp_func_new ("set-mark", ___lambda51__function, FALSE, "Set this buffer's mark to point.");
#line 421 "src/funcs.vala"
	_tmp9_ = _tmp8_;
#line 421 "src/funcs.vala"
	_lisp_func_unref0 (_tmp9_);
#line 432 "src/funcs.vala"
	_tmp10_ = lisp_func_new ("set-mark-command", ___lambda52__function, TRUE, "Set the mark where point is.");
#line 432 "src/funcs.vala"
	_tmp11_ = _tmp10_;
#line 432 "src/funcs.vala"
	_lisp_func_unref0 (_tmp11_);
#line 443 "src/funcs.vala"
	_tmp12_ = lisp_func_new ("exchange-point-and-mark", ___lambda53__function, TRUE, "Put the mark where point is now, and point where the mark is now.");
#line 443 "src/funcs.vala"
	_tmp13_ = _tmp12_;
#line 443 "src/funcs.vala"
	_lisp_func_unref0 (_tmp13_);
#line 462 "src/funcs.vala"
	_tmp14_ = lisp_func_new ("mark-whole-buffer", ___lambda54__function, TRUE, "Put point at beginning and mark at end of buffer.");
#line 462 "src/funcs.vala"
	_tmp15_ = _tmp14_;
#line 462 "src/funcs.vala"
	_lisp_func_unref0 (_tmp15_);
#line 474 "src/funcs.vala"
	_tmp16_ = lisp_func_new ("quoted-insert", ___lambda55__function, TRUE, "Read next input character and insert it.\n" \
"This is useful for inserting control characters.");
#line 474 "src/funcs.vala"
	_tmp17_ = _tmp16_;
#line 474 "src/funcs.vala"
	_lisp_func_unref0 (_tmp17_);
#line 487 "src/funcs.vala"
	_tmp18_ = lisp_func_new ("universal-argument", ___lambda56__function, TRUE, "Begin a numeric argument for the following command.\n" \
"Digits or minus sign following \\\\[universal-argument] make up the nu" \
"meric argument.\n" \
"\\\\[universal-argument] following the digits or minus sign ends the a" \
"rgument.\n" \
"\\\\[universal-argument] without digits or minus sign provides 4 as ar" \
"gument.\n" \
"Repeating \\\\[universal-argument] without digits or minus sign\n" \
" multiplies the argument by 4 each time.");
#line 487 "src/funcs.vala"
	_tmp19_ = _tmp18_;
#line 487 "src/funcs.vala"
	_lisp_func_unref0 (_tmp19_);
#line 562 "src/funcs.vala"
	_tmp20_ = lisp_func_new ("back-to-indentation", ___lambda57__function, TRUE, "Move point to the first non-whitespace character on this line.");
#line 562 "src/funcs.vala"
	_tmp21_ = _tmp20_;
#line 562 "src/funcs.vala"
	_lisp_func_unref0 (_tmp21_);
#line 574 "src/funcs.vala"
	_tmp22_ = lisp_func_new ("suspend-emacs", ___lambda58__function, TRUE, "Stop Zile and return to superior process.");
#line 574 "src/funcs.vala"
	_tmp23_ = _tmp22_;
#line 574 "src/funcs.vala"
	_lisp_func_unref0 (_tmp23_);
#line 584 "src/funcs.vala"
	_tmp24_ = lisp_func_new ("keyboard-quit", ___lambda59__function, TRUE, "Cancel current command.");
#line 584 "src/funcs.vala"
	_tmp25_ = _tmp24_;
#line 584 "src/funcs.vala"
	_lisp_func_unref0 (_tmp25_);
#line 595 "src/funcs.vala"
	_tmp26_ = lisp_func_new ("forward-word", ___lambda60__function, TRUE, "Move point forward one word (backward if the argument is negative).\n" \
"With argument, do this that many times.");
#line 595 "src/funcs.vala"
	_tmp27_ = _tmp26_;
#line 595 "src/funcs.vala"
	_lisp_func_unref0 (_tmp27_);
#line 605 "src/funcs.vala"
	_tmp28_ = lisp_func_new ("backward-word", ___lambda61__function, TRUE, "Move backward until encountering the end of a word (forward if the\n" \
"argument is negative).\n" \
"With argument, do this that many times.");
#line 605 "src/funcs.vala"
	_tmp29_ = _tmp28_;
#line 605 "src/funcs.vala"
	_lisp_func_unref0 (_tmp29_);
#line 616 "src/funcs.vala"
	_tmp30_ = lisp_func_new ("forward-sexp", ___lambda62__function, TRUE, "Move forward across one balanced expression (sexp).\n" \
"With argument, do it that many times.  Negative arg -N means\n" \
"move backward across N balanced expressions.");
#line 616 "src/funcs.vala"
	_tmp31_ = _tmp30_;
#line 616 "src/funcs.vala"
	_lisp_func_unref0 (_tmp31_);
#line 627 "src/funcs.vala"
	_tmp32_ = lisp_func_new ("backward-sexp", ___lambda63__function, TRUE, "Move backward across one balanced expression (sexp).\n" \
"With argument, do it that many times.  Negative arg -N means\n" \
"move forward across N balanced expressions.");
#line 627 "src/funcs.vala"
	_tmp33_ = _tmp32_;
#line 627 "src/funcs.vala"
	_lisp_func_unref0 (_tmp33_);
#line 638 "src/funcs.vala"
	_tmp34_ = lisp_func_new ("transpose-chars", ___lambda64__function, TRUE, "Interchange characters around point, moving forward one character.\n" \
"With prefix arg ARG, effect is to take character before point\n" \
"and drag it forward past ARG other characters (backward if ARG negativ" \
"e).\n" \
"If no argument and at end of line, the previous two chars are exchange" \
"d.");
#line 638 "src/funcs.vala"
	_tmp35_ = _tmp34_;
#line 638 "src/funcs.vala"
	_lisp_func_unref0 (_tmp35_);
#line 650 "src/funcs.vala"
	_tmp36_ = lisp_func_new ("transpose-words", ___lambda65__function, TRUE, "Interchange words around point, leaving point at end of them.\n" \
"With prefix arg ARG, effect is to take word before or around point\n" \
"and drag it forward past ARG other words (backward if ARG negative).\n" \
"If ARG is zero, the words around or after point and around or after ma" \
"rk\n" \
"are interchanged.");
#line 650 "src/funcs.vala"
	_tmp37_ = _tmp36_;
#line 650 "src/funcs.vala"
	_lisp_func_unref0 (_tmp37_);
#line 663 "src/funcs.vala"
	_tmp38_ = lisp_func_new ("transpose-sexps", ___lambda66__function, TRUE, "Like `transpose-words', but applies to sexps.");
#line 663 "src/funcs.vala"
	_tmp39_ = _tmp38_;
#line 663 "src/funcs.vala"
	_lisp_func_unref0 (_tmp39_);
#line 672 "src/funcs.vala"
	_tmp40_ = lisp_func_new ("transpose-lines", ___lambda67__function, TRUE, "Exchange current line and previous line, leaving point after both.\n" \
"With argument ARG, takes previous line and moves it past ARG lines.\n" \
"With argument 0, interchanges line point is in with line mark is in.");
#line 672 "src/funcs.vala"
	_tmp41_ = _tmp40_;
#line 672 "src/funcs.vala"
	_lisp_func_unref0 (_tmp41_);
#line 683 "src/funcs.vala"
	_tmp42_ = lisp_func_new ("mark-word", ___lambda68__function, TRUE, "Set mark argument words away from point.");
#line 683 "src/funcs.vala"
	_tmp43_ = _tmp42_;
#line 683 "src/funcs.vala"
	_lisp_func_unref0 (_tmp43_);
#line 692 "src/funcs.vala"
	_tmp44_ = lisp_func_new ("mark-sexp", ___lambda69__function, TRUE, "Set mark ARG sexps from point.\n" \
"The place mark goes is the same place \\\\[forward-sexp] would\n" \
"move to with the same argument.");
#line 692 "src/funcs.vala"
	_tmp45_ = _tmp44_;
#line 692 "src/funcs.vala"
	_lisp_func_unref0 (_tmp45_);
#line 703 "src/funcs.vala"
	_tmp46_ = lisp_func_new ("forward-line", ___lambda70__function, TRUE, "Move N lines forward (backward if N is negative).\n" \
"Precisely, if point is on line I, move to the start of line I + N.");
#line 703 "src/funcs.vala"
	_tmp47_ = _tmp46_;
#line 703 "src/funcs.vala"
	_lisp_func_unref0 (_tmp47_);
#line 722 "src/funcs.vala"
	_tmp48_ = lisp_func_new ("backward-paragraph", ___lambda71__function, TRUE, "Move backward to start of paragraph.  With argument N, do it N times.");
#line 722 "src/funcs.vala"
	_tmp49_ = _tmp48_;
#line 722 "src/funcs.vala"
	_lisp_func_unref0 (_tmp49_);
#line 734 "src/funcs.vala"
	_tmp50_ = lisp_func_new ("forward-paragraph", ___lambda74__function, TRUE, "Move forward to end of paragraph.  With argument N, do it N times.");
#line 734 "src/funcs.vala"
	_tmp51_ = _tmp50_;
#line 734 "src/funcs.vala"
	_lisp_func_unref0 (_tmp51_);
#line 746 "src/funcs.vala"
	_tmp52_ = lisp_func_new ("mark-paragraph", ___lambda77__function, TRUE, "Put point at beginning of this paragraph, mark at end.\n" \
"The paragraph marked is the one that contains point or follows point.");
#line 746 "src/funcs.vala"
	_tmp53_ = _tmp52_;
#line 746 "src/funcs.vala"
	_lisp_func_unref0 (_tmp53_);
#line 765 "src/funcs.vala"
	_tmp54_ = lisp_func_new ("fill-paragraph", ___lambda78__function, TRUE, "Fill paragraph at or after point.");
#line 765 "src/funcs.vala"
	_tmp55_ = _tmp54_;
#line 765 "src/funcs.vala"
	_lisp_func_unref0 (_tmp55_);
#line 804 "src/funcs.vala"
	_tmp56_ = lisp_func_new ("downcase-word", ___lambda79__function, TRUE, "Convert following word (or ARG words) to lower case, moving over.");
#line 804 "src/funcs.vala"
	_tmp57_ = _tmp56_;
#line 804 "src/funcs.vala"
	_lisp_func_unref0 (_tmp57_);
#line 820 "src/funcs.vala"
	_tmp58_ = lisp_func_new ("upcase-word", ___lambda80__function, TRUE, "Convert following word (or ARG words) to upper case, moving over.");
#line 820 "src/funcs.vala"
	_tmp59_ = _tmp58_;
#line 820 "src/funcs.vala"
	_lisp_func_unref0 (_tmp59_);
#line 836 "src/funcs.vala"
	_tmp60_ = lisp_func_new ("capitalize-word", ___lambda81__function, TRUE, "Capitalize the following word (or ARG words), moving over.\n" \
"This gives the word(s) a first character in upper case\n" \
"and the rest lower case.");
#line 836 "src/funcs.vala"
	_tmp61_ = _tmp60_;
#line 836 "src/funcs.vala"
	_lisp_func_unref0 (_tmp61_);
#line 854 "src/funcs.vala"
	_tmp62_ = lisp_func_new ("upcase-region", ___lambda82__function, TRUE, "Convert the region to upper case.");
#line 854 "src/funcs.vala"
	_tmp63_ = _tmp62_;
#line 854 "src/funcs.vala"
	_lisp_func_unref0 (_tmp63_);
#line 863 "src/funcs.vala"
	_tmp64_ = lisp_func_new ("downcase-region", ___lambda84__function, TRUE, "Convert the region to lower case.");
#line 863 "src/funcs.vala"
	_tmp65_ = _tmp64_;
#line 863 "src/funcs.vala"
	_lisp_func_unref0 (_tmp65_);
#line 872 "src/funcs.vala"
	_tmp66_ = lisp_func_new ("delete-region", ___lambda86__function, TRUE, "Delete the text between point and mark.");
#line 872 "src/funcs.vala"
	_tmp67_ = _tmp66_;
#line 872 "src/funcs.vala"
	_lisp_func_unref0 (_tmp67_);
#line 886 "src/funcs.vala"
	_tmp68_ = lisp_func_new ("delete-blank-lines", ___lambda87__function, TRUE, "On blank line, delete all surrounding blank lines, leaving just one.\n" \
"On isolated blank line, delete that one.\n" \
"On nonblank line, delete any immediately following blank lines.");
#line 886 "src/funcs.vala"
	_tmp69_ = _tmp68_;
#line 886 "src/funcs.vala"
	_lisp_func_unref0 (_tmp69_);
#line 5309 "funcs.c"
}

