;;; DO NOT MODIFY THIS FILE
(if (featurep 'dired-autoloads) (error "Already loaded"))

;;;### (autoloads nil "_pkg" "dired/_pkg.el")

(package-provide 'dired :version 1.18 :author-version "7.15" :type 'regular)

;;;***

;;;### (autoloads (diff-backup diff) "diff" "dired/diff.el")

(defcustom diff-switches "-c" "*A list of switches (strings) to pass to the diff program." :type '(choice string (repeat string)) :group 'diff)

(autoload 'diff "diff" "\
Find and display the differences between OLD and NEW files.
Interactively you are prompted with the current buffer's file name for NEW
and what appears to be its backup for OLD." t nil)

(autoload 'diff-backup "diff" "\
Diff this file with its backup file or vice versa.
Uses the latest backup, if there are several numerical backups.
If this file is a backup, diff it with its original.
The backup file is the first file given to `diff'." t nil)

;;;***

;;;### (autoloads (dired-compress-subdir-files dired-do-compress) "dired-cmpr" "dired/dired-cmpr.el")

(autoload 'dired-do-compress "dired-cmpr" "\
Compress or uncompress marked (or next ARG) files.
With a zero prefix, prompts for a new value of `dired-compression-method'." t nil)

(autoload 'dired-compress-subdir-files "dired-cmpr" "\
Compress all uncompressed files in the current subdirectory.
With a prefix argument uncompresses all compressed files." t nil)

;;;***

;;;### (autoloads (dired-epatch dired-ediff dired-emerge-with-ancestor dired-emerge dired-backup-diff dired-diff) "dired-diff" "dired/dired-diff.el")

(autoload 'dired-diff "dired-diff" "\
Compare file at point with file FILE using `diff'.
FILE defaults to the file at the mark.
The prompted-for file is the first file given to `diff'.
With a prefix allows the switches for the diff program to be edited." t nil)

(autoload 'dired-backup-diff "dired-diff" "\
Diff this file with its backup file or vice versa.
Uses the latest backup, if there are several numerical backups.
If this file is a backup, diff it with its original.
The backup file is the first file given to `diff'." t nil)

(autoload 'dired-emerge "dired-diff" "\
Merge file at point with FILE using `emerge'.
FILE defaults to the file at the mark." t nil)

(autoload 'dired-emerge-with-ancestor "dired-diff" "\
Merge file at point with FILE, using a common ANCESTOR file.
FILE defaults to the file at the mark." t nil)

(autoload 'dired-ediff "dired-diff" "\
Ediff file at point with FILE.
FILE defaults to the file at the mark.
`ediff-directories' is used if both files are directories." t nil)

(autoload 'dired-epatch "dired-diff" "\
Patch file at point using `epatch'." t nil)

;;;***

;;;### (autoloads (dired-do-grep) "dired-grep" "dired/dired-grep.el")

(autoload 'dired-do-grep "dired-grep" "\
Grep marked files for a pattern. With a  prefix prompts for grep flags." t nil)

;;;***

;;;### (autoloads (dired-report-bug dired-summary dired-apropos dired-describe-mode) "dired-help" "dired/dired-help.el")

(autoload 'dired-describe-mode "dired-help" "\
Detailed description of dired mode.
With a prefix, runs the info documentation browser for dired." t nil)

(autoload 'dired-apropos "dired-help" "\
Does command apropos for dired commands.
With prefix does apropos for dired variables." t nil)

(autoload 'dired-summary "dired-help" "\
Display summary of basic dired commands in the minibuffer." t nil)

(autoload 'dired-report-bug "dired-help" "\
Submit a bug report for dired." t nil)

;;;***

;;;### (autoloads (dired-mark-files-compilation-buffer dired-mark-files-from-other-dired-buffer) "dired-mob" "dired/dired-mob.el")

(autoload 'dired-mark-files-from-other-dired-buffer "dired-mob" "\
Mark files that are marked in the other Dired buffer.
I.e, mark those files in this Dired buffer that have the same
non-directory part as the marked files in the Dired buffer in the other 
window." t nil)

(autoload 'dired-mark-files-compilation-buffer "dired-mob" "\
Mark the files mentioned in the `*compilation*' buffer.
With a prefix, you may specify the other buffer." t nil)

;;;***

;;;### (autoloads (dired-downcase dired-upcase dired-do-relsymlink-regexp dired-do-symlink-regexp dired-do-hardlink-regexp dired-do-copy-regexp dired-do-rename-regexp dired-cleanup dired-flag-extension dired-mark-extension dired-flag-files-regexp dired-mark-files-regexp) "dired-rgxp" "dired/dired-rgxp.el")

(autoload 'dired-mark-files-regexp "dired-rgxp" "\
\\<dired-mode-map>Mark all files matching REGEXP for use in later commands.

A prefix argument \\[universal-argument] means to unmark them instead.

A prefix argument 0 means to mark the files that would me omitted by \\[dired-omit-toggle].
A prefix argument 1 means to unmark the files that would be omitted by \\[dired-omit-toggle].

REGEXP is an Emacs regexp, not a shell wildcard.  Thus, use \"\\.o$\" for
object files--just `.o' will mark more than you might think.  The files \".\"
and \"..\" are never marked.
" t nil)

(autoload 'dired-flag-files-regexp "dired-rgxp" "\
In dired, flag all files containing the specified REGEXP for deletion.
The match is against the non-directory part of the filename.  Use `^'
  and `$' to anchor matches.  Exclude subdirs by hiding them.
`.' and `..' are never flagged." t nil)

(autoload 'dired-mark-extension "dired-rgxp" "\
Mark all files with a certain extension for use in later commands.
A `.' is not prepended to the string entered." t nil)

(autoload 'dired-flag-extension "dired-rgxp" "\
In dired, flag all files with a certain extension for deletion.
A `.' is not prepended to the string entered." t nil)

(autoload 'dired-cleanup "dired-rgxp" "\
Flag for deletion dispensable files created by PROGRAM.
See variable `dired-cleanup-alist'." t nil)

(autoload 'dired-do-rename-regexp "dired-rgxp" "\
Rename marked files containing REGEXP to NEWNAME.
As each match is found, the user must type a character saying
  what to do with it.  For directions, type \\[help-command] at that time.
NEWNAME may contain \\=\\<n> or \\& as in `query-replace-regexp'.
REGEXP defaults to the last regexp used.
With a zero prefix arg, renaming by regexp affects the complete
  pathname - usually only the non-directory part of file names is used
  and changed." t nil)

(autoload 'dired-do-copy-regexp "dired-rgxp" "\
Copy all marked files containing REGEXP to NEWNAME.
See function `dired-rename-regexp' for more info." t nil)

(autoload 'dired-do-hardlink-regexp "dired-rgxp" "\
Hardlink all marked files containing REGEXP to NEWNAME.
See function `dired-rename-regexp' for more info." t nil)

(autoload 'dired-do-symlink-regexp "dired-rgxp" "\
Symlink all marked files containing REGEXP to NEWNAME.
See function `dired-rename-regexp' for more info." t nil)

(autoload 'dired-do-relsymlink-regexp "dired-rgxp" "\
RelSymlink all marked files containing REGEXP to NEWNAME.
See functions `dired-rename-regexp' and `dired-do-relsymlink'
  for more info." t nil)

(autoload 'dired-upcase "dired-rgxp" "\
Rename all marked (or next ARG) files to upper case." t nil)

(autoload 'dired-downcase "dired-rgxp" "\
Rename all marked (or next ARG) files to lower case." t nil)

;;;***

;;;### (autoloads (dired-mark-sexp) "dired-sex" "dired/dired-sex.el")

(autoload 'dired-mark-sexp "dired-sex" "\
Mark files for which PREDICATE returns non-nil.
With a prefix arg, unflag those files instead.

PREDICATE is a lisp expression that can refer to the following symbols:

    inode  [integer] the inode of the file (only for ls -i output)
    s      [integer] the size of the file for ls -s output
	             (usually in blocks or, with -k, in KByte)
    mode   [string]  file permission bits, e.g. \"-rw-r--r--\"
    nlink  [integer] number of links to file
    uid    [string]  owner
    gid    [string]  group  (If the gid is not displayed by ls,
	             this will still be set (to the same as uid))
    size   [integer] file size in bytes
    time   [string]  the time that ls displays, e.g. \"Feb 12 14:17\"
    name   [string]  the name of the file
    sym    [string]  if file is a symbolic link, the linked-to name, else nil.

For example, use

        (equal 0 size)

to mark all zero length files." t nil)

;;;***

;;;### (autoloads (dired-do-print dired-do-background-shell-command dired-do-shell-command dired-run-shell-command) "dired-shell" "dired/dired-shell.el")

(autoload 'dired-run-shell-command "dired-shell" nil nil nil)

(autoload 'dired-do-shell-command "dired-shell" "\
Run a shell command COMMAND on the marked files.
If no files are marked or a non-zero numeric prefix arg is given,
the next ARG files are used.  Use prefix 1 to indicate the current file.

Normally the shell command is executed in the current dired subdirectory.
This is the directory in the dired buffer which currently contains the point.
One shell command is run for all of the files.
e.g. cmd file1 file2 file3 ... 
If the total length of of the command exceeds 10000 characters, the files will
be bunched to forms commands shorter than this length, and successive commands
will be sent.

With a prefix of \\[universal-argument], a separate command for each file will
be executed.

With a prefix of \\[universal-argument] \\[universal-argument], a
separate command will be sent for each file, and the command will be
executed in the directory of that file.  The explicit command will be
of the form

                      cd dir; cmd file

When prompting for the shell command, dired will always indicate the directory
in which the command will be executed.

With a prefix of \\[universal-argument] \\[universal-argument]
\\[universal-argument], a eparate command will be sent for each file,
and the command will be executed in the dwim directory.

The following documentation depends on the settings of `dired-file-wildcard',
`dired-shell-command-separators', `dired-trans-map', `dired-shell-prefix',
`dired-shell-separator', and `dired-shell-postfix'. See the documentation for
these variables. Below, I will assume default settings for these variables.

If the shell command contains a *, then the list of files is substituted for *.
The filenames will be written as relative to the directory in which the shell
command is executing. If there is no *, and the command does not end in &, 
then the files are appended to the end of the command. If the command ends in
a &, then the files are inserted before the &.

If `dired-use-file-transformers' is non-nil, then certain 2-character
sequences represent parts of the file name.
The default transformers are:
*f = full file name
*n = file name without directory
*d = file name's directory 
     This will end in a \"/\" in unix.
*e = file names extension
     By default this the part of the file name without directory, which
     proceeds the first \".\". If \".\" is the first character of the name,
     then this \".\" is ignored. The definition of extension can
     be customized with `dired-filename-re-ext'.
*b = file base name
     This is the part of the file name without directory that precedes
     the extension.
*v = file name with out version control extension (i.e. \",v\")
*z = file name without compression extension
     (i.e. \".Z\", \".z\", or \".gz\")

Shell commands are divided into words separated by spaces. Then for each
word the file name transformers are applied to the list of files, the result
concatenated together and substituted for the word in the shell command.

For example
   cmd -a *f -b *d*b.fizzle applied to /foo/bar and /la/di/da results in
   cmd -a /foo/bar /la/di/da -b /foo/bar.fizzle /la/di/da.fizzle

The \"on-each\" prefixes \\[universal-argument] and 0, also apply while
using file transformers. As well, when using file-transformers * still
represents the file name relative to the current directory. Not that this
differs from *f, which always represents the full pathname.

A \"\\\" can always be used to quote any character having special meaning.
For example, if the current directory is /la, then *n applied
to /la/di/da returns la, whereas *\\n returns di/dan. Similarly,
\"*d\\ *n\" returns \"/la/di da\".

The prefix character for file name transformers is always the same as
`dired-file-wildcard'." t nil)

(autoload 'dired-do-background-shell-command "dired-shell" "\
Like \\[dired-do-shell-command], but starts command in background.
Note that you can type input to the command in its buffer.
This requires background.el from the comint package to work." t nil)

(autoload 'dired-do-print "dired-shell" "\
Print the marked (or next ARG) files.
Uses the shell command coming from variable `dired-print-program-alist'." t nil)

;;;***

;;;### (autoloads (dired-do-uucode) "dired-uu" "dired/dired-uu.el")

(autoload 'dired-do-uucode "dired-uu" "\
Uuencode or uudecode marked (or next ARG) files." t nil)

;;;***

;;;### (autoloads (dired-virtual) "dired-vir" "dired/dired-vir.el")

(autoload 'dired-virtual "dired-vir" "\
Put this buffer into Virtual Dired mode.

In Virtual Dired mode, all commands that do not actually consult the
filesystem will work.

This is useful if you want to peruse and move around in an ls -lR
output file, for example one you got from an ftp server.  With
efs, you can even dired a directory containing an ls-lR file,
visit that file and turn on virtual dired mode.  But don't try to save
this file, as dired-virtual indents the listing and thus changes the
buffer.

If you have save a Dired buffer in a file you can use \\[dired-virtual] to
resume it in a later session.

Type \\<dired-mode-map>\\[revert-buffer] in the
Virtual Dired buffer and answer `y' to convert the virtual to a real
dired buffer again.  You don't have to do this, though: you can relist
single subdirs using \\[dired-do-redisplay].
" t nil)

;;;***

;;;### (autoloads (dired-rmail dired-vm dired-read-mail) "dired-xy" "dired/dired-xy.el")

(autoload 'dired-read-mail "dired-xy" "\
Reads the current file as a mail folder.
Uses the setting of `dired-mail-reader' to determine which reader to use.
Possibilities are VM or RMAIL. With a prefix arg, visits the folder read-only;
this only works with VM." t nil)

(autoload 'dired-vm "dired-xy" "\
Run VM on this file.
With prefix arg, visit folder read-only (this requires at least VM 5).
See also variable `dired-vm-read-only-folders'." t nil)

(autoload 'dired-rmail "dired-xy" "\
Run RMAIL on this file." t nil)

;;;***

;;;### (autoloads (dired-jump-back-other-frame dired-jump-back-other-window dired-jump-back dired-noselect dired-other-frame dired-other-window dired default-directory) "dired" "dired/dired.el")

(autoload 'default-directory "dired" "\
 Returns the default-directory for the current buffer.
Will use the variable default-directory-function if it non-nil." nil nil)

(defcustom dired-compression-method 'gzip "*Type of compression program to use.\nGive as a symbol.\nCurrently-recognized methods are: gzip pack compact compress.\nTo change this variable use \\[dired-do-compress] with a zero prefix." :type '(choice (const gzip) (const pack) (const pack) (const compact) (const compress)) :group 'dired-programs)

(defvar dired-compression-method-alist '((gzip ".gz" ("gzip") ("gzip" "-d") "-f") (compress ".Z" ("compress" "-f") ("compress" "-d") "-f") (pack ".z" ("pack" "-f") ("unpack")) (compact ".C" ("compact") ("uncompact")) (bzip2 ".bz2" ("bzip2") ("bunzip2") "-f")) "\
*Association list of compression method descriptions.
 Each element of the table should be a list of the form

     (compress-type extension (compress-args) (decompress-args) force-flag)

 where
   `compress-type' is a unique symbol in the alist to which
      `dired-compression-method' can be set;
   `extension' is the file extension (as a string) used by files compressed
      by this method;
   `compress-args' is a list of the path of the compression program and
      flags to pass as separate arguments;
   `decompress-args' is a list of the path of the decompression
      program and flags to pass as separate arguments.
   `force-flag' is the switch to pass to the command to force overwriting
      of existing files.

 For example:

   (setq dired-compression-method-alist
         (cons '(frobnicate \".frob\" (\"frob\") (\"frob\" \"-d\") \"-f\")
               dired-compression-method-alist))
   => ((frobnicate \".frob\" (\"frob\") (\"frob\" \"-d\"))
       (gzip \".gz\" (\"gzip\") (\"gunzip\"))
       ...)

 See also: dired-compression-method <V>")

(defcustom dired-ls-program "ls" "*Absolute or relative name of the ls program used by dired." :type 'string :group 'dired-programs)

(defcustom dired-listing-switches "-al" "*Switches passed to ls for dired. MUST contain the `l' option.\nCan contain even `F', `b', `i' and `s'." :type '(choice string (repeat string)) :group 'dired-programs)

(defcustom dired-use-ls-dired (and (string-match "gnu" system-configuration) (or (and (featurep 'xemacs) (fboundp 'emacs-version>=) (emacs-version>= 21 5)) (and (boundp 'emacs-major-version) (boundp 'emacs-minor-version) (or (> emacs-major-version 21) (and (= emacs-major-version 21) (>= emacs-minor-version 4)))))) "Non-nil means Dired should use `ls --dired'." :type 'boolean :group 'dired-programs)

(defcustom dired-chown-program (if (memq system-type '(hpux dgux usg-unix-v linux)) "chown" "/etc/chown") "*Name of chown command (usually `chown' or `/etc/chown')." :type 'string :group 'dired-programs)

(defcustom dired-gnutar-program nil "*If non-nil, name of the GNU tar executable (e.g. \"tar\" or \"gnutar\").\nGNU tar's `z' switch is used for compressed tar files.\nIf you don't have GNU tar, set this to nil: a pipe using `zcat' is then used." :type '(choice string (const nil)) :group 'dired-programs)

(defcustom dired-unshar-program nil "*Set to the name of the unshar program, if you have it." :type '(choice string (const nil)) :group 'dired-programs)

(defcustom dired-local-variables-file ".dired" "*If non-nil, filename for local variables for Dired.\nIf Dired finds a file with that name in the current directory, it will\ntemporarily insert it into the dired buffer and run `hack-local-variables'.\n\nType \\[info] and `g' `(emacs)File Variables' `RET' for more info on\nlocal variables." :type 'string :group 'dired-behavior)

(defcustom dired-kept-versions 2 "*When cleaning directory, number of versions to keep." :type 'integer :group 'dired-behavior)

(defcustom dired-find-subdir nil "*Determines whether dired tries to lookup a subdir in existing buffers.\nIf non-nil, dired does not make a new buffer for a directory if it can be\nfound (perhaps as subdir) in some existing dired buffer. If there are several\ndired buffers for a directory, then the most recently used one is chosen.\n\nDired avoids switching to the current buffer, so that if you have\na normal and a wildcard buffer for the same directory, C-x d RET will\ntoggle between those two." :type 'boolean :group 'dired-behavior)

(defcustom dired-use-file-transformers t "*Determines whether dired uses file transformers.\nIf non-nil `dired-do-shell-command' will apply file transformers to file names.\nSee \\[describe-function] for dired-do-shell-command for more information." :type 'boolean :group 'dired-behavior)

(defcustom dired-dwim-target nil "*If non-nil, dired tries to guess a default target directory.\nThis means that if there is a dired buffer displayed in the next window,\nuse its current subdir, instead of the current subdir of this dired buffer.\nThe target is put in the prompt for file copy, rename, etc." :type 'boolean :group 'dired-behavior)

(defcustom dired-copy-preserve-time t "*If non-nil, Dired preserves the last-modified time in a file copy.\n(This works on only some systems.)\\<dired-mode-map>\nUse `\\[dired-do-copy]' with a zero prefix argument to toggle its value." :type 'boolean :group 'dired-behavior)

(defcustom dired-no-confirm nil "*If non-nil, a list of symbols for commands dired should not confirm.\nIt can be a sublist of\n\n  '(byte-compile chgrp chmod chown compress copy delete hardlink load\n    move print shell symlink uncompress recursive-delete kill-file-buffer\n    kill-dired-buffer patch create-top-dir revert-subdirs)\n\nThe meanings of most of the symbols are obvious.  A few exceptions:\n\n    'compress applies to compression or decompression by any of the\n     compression program in `dired-compression-method-alist'.\n\n    'kill-dired-buffer applies to offering to kill dired buffers for\n     directories which have been deleted.\n\n    'kill-file-buffer applies to offering to kill buffers visiting files\n     which have been deleted.\n\n    'recursive-delete applies to recursively deleting non-empty\n     directories, and all of their contents.\n\n    'create-top-dir applies to `dired-up-directory' creating a new top level\n     directory for the dired buffer.\n\n    'revert-subdirs applies to re-reading subdirectories which have\n     been modified on disk.\n\nNote that this list also applies to remote files accessed with efs\nor ange-ftp." :type '(set (const byte-compile) (const chgrp) (const chmod) (const chown) (const compress) (const copy) (const delete) (const hardlink) (const load) (const move) (const print) (const shell) (const symlink) (const uncompress) (const recursive-delete) (const recursive-copy) (const kill-file-buffer) (const kill-dired-buffer) (const patch) (const create-top-dir) (const revert-subdirs)) :group 'dired-behavior)

(defcustom dired-backup-if-overwrite nil "*Non-nil if Dired should ask about making backups before overwriting files.\nSpecial value 'always suppresses confirmation." :type 'boolean :group 'dired-behavior)

(defcustom dired-omit-files nil "*If non-nil un-interesting files will be omitted from this dired buffer.\nUse \\[dired-omit-toggle] to see these files. (buffer local)" :type 'boolean :group 'dired-behavior)

(defcustom dired-mail-reader 'vm "*Mail reader used by dired for dired-read-mail (\\[dired-read-mail]).\nThe symbols 'rmail and 'vm are the only two allowed values." :type '(choice (const rmail) (const vm)) :group 'dired-behavior)

(defcustom dired-refresh-automatically t "*If non-nil, refresh dired buffers automatically after file operations." :type 'boolean :group 'dired-behavior)

(defcustom dired-find-file-compare-truenames t "If nil, set find-file-compare-truenames to nil while opening dired buffer" :type 'boolean :group 'dired-behavior)
(define-key ctl-x-map "d" 'dired)

(autoload 'dired "dired" "\
\"Edit\" directory DIRNAME--delete, rename, print, etc. some files in it.
Optional second argument SWITCHES specifies the `ls' options used.
\(Interactively, use a prefix argument to be able to specify SWITCHES.)
Dired displays a list of files in DIRNAME (which may also have
shell wildcards appended to select certain files).  If DIRNAME is a cons,
its first element is taken as the directory name and the resr as an explicit
list of files to make directory entries for.
\\<dired-mode-map>You can move around in it with the usual commands.
You can flag files for deletion with \\[dired-flag-file-deletion] and then
delete them by typing \\[dired-expunge-deletions].
Type \\[dired-describe-mode] after entering dired for more info.

If DIRNAME is already in a dired buffer, that buffer is used without refresh." t nil)
(define-key ctl-x-4-map "d" 'dired-other-window)

(autoload 'dired-other-window "dired" "\
\"Edit\" directory DIRNAME.  Like `dired' but selects in another window." t nil)
(define-key ctl-x-5-map "d" 'dired-other-frame)

(autoload 'dired-other-frame "dired" "\
\"Edit\" directory DIRNAME.  Like `dired' but makes a new frame." t nil)

(autoload 'dired-noselect "dired" "\
Like `dired' but returns the dired buffer as value, does not select it." nil nil)
(define-key ctl-x-map "\C-j" 'dired-jump-back)

(autoload 'dired-jump-back "dired" "\
Jump back to dired.
If in a file, dired the current directory and move to file's line.
If in dired already, pop up a level and goto old directory's line.
In case the proper dired file line cannot be found, refresh the dired
  buffer and try again." t nil)
(define-key ctl-x-4-map "\C-j" 'dired-jump-back-other-window)

(autoload 'dired-jump-back-other-window "dired" "\
Like \\[dired-jump-back], but to other window." t nil)
(define-key ctl-x-5-map "\C-j" 'dired-jump-back-other-frame)

(autoload 'dired-jump-back-other-frame "dired" "\
Like \\[dired-jump-back], but in another frame." t nil)

;;;***

(provide 'dired-autoloads)
