;;; DO NOT MODIFY THIS FILE
(if (featurep 'ede-autoloads) (error "Already loaded"))

;;;### (autoloads nil "_pkg" "ede/_pkg.el")

(package-provide 'ede :version 1.01 :author-version "1.0pre4" :type 'regular)

;;;***

;;;### (autoloads (ede-pmake-varname) "ede-pmake" "ede/ede-pmake.el")

(autoload 'ede-pmake-varname "ede-pmake" "\
Convert OBJ into a variable name name, which converts .  to _." nil nil)

;;;***

;;;### (autoloads nil "ede-proj" "ede/ede-proj.el")

(add-to-list 'auto-mode-alist '("Project\\.ede" . emacs-lisp-mode))

;;;***

;;;### (autoloads (ede-simple-load ede-simple-projectfile-for-dir) "ede-simple" "ede/ede-simple.el")

(autoload 'ede-simple-projectfile-for-dir "ede-simple" "\
Return a full file name to the project file stored in the current directory.
The directory has three parts:
  <STORAGE ROOT>/<PROJ DIR AS FILE>/ProjSimple.ede" nil nil)

(autoload 'ede-simple-load "ede-simple" "\
Load a project of type `Simple' for the directory DIR.
Return nil if there isn't one." nil nil)

(defclass ede-simple-project (eieio-persistent ede-project) ((extension :initform ".ede") (file-header-line :initform ";; EDE Simple Project")) "EDE Simple project class.\nEach directory needs a a project file to control it.")

;;;***

;;;### (autoloads (ede-update-version) "ede-util" "ede/ede-util.el")

(autoload 'ede-update-version "ede-util" "\
Update the current projects main version number.
Argument NEWVERSION is the version number to use in the current project." t nil)

;;;***

;;;### (autoloads (ede-target-parent ede-parent-project ede-load-project-file ede-documentation-files ede-compile-target ede-remove-file) "ede" "ede/ede.el")

(defclass ede-project-autoload nil ((name :initarg :name :documentation "Name of this project type") (file :initarg :file :documentation "The lisp file belonging to this class.") (proj-file :initarg :proj-file :documentation "Name of a project file of this type.") (initializers :initarg :initializers :initform nil :documentation "Initializers passed to the project object.\nThese are used so there can be multiple types of projects\nassociated with a single object class, based on the initilizeres used.") (load-type :initarg :load-type :documentation "Fn symbol used to load this project file.") (class-sym :initarg :class-sym :documentation "Symbol representing the project class to use.") (new-p :initarg :new-p :initform t :documentation "Non-nil if this is an option when a user creates a project.")) "Class representing minimal knowledge set to run preliminary EDE functions.\nWhen more advanced functionality is needed from a project type, that projects\ntype is required and the load function used.")

(defclass ede-target (eieio-speedbar-directory-button) ((buttonface :initform speedbar-file-face) (name :initarg :name :type string :custom string :label "Name" :group (default name) :documentation "Name of this target.") (path :initarg :path :type string :documentation "The path to the sources of this target.\nRelative to the path of the project it belongs to.") (source :initarg :source :initform nil :type list :custom (repeat (string :tag "File")) :label "Source Files" :group (default source) :documentation "Source files in this target.") (versionsource :initarg :versionsource :initform nil :type list :custom (repeat (string :tag "File")) :label "Source Files with Version String" :group (source) :documentation "Source files with a version string in them.\nThese files are checked for a version string whenever the EDE version\nof the master project is changed.  When strings are found, the version\npreviously there is updated.") (sourcetype :allocation :class :type list :documentation "A list of `ede-sourcecode' objects this class will handle.\nThis is used to match target objects with the compilers they can use, and\nwhich files this object is interested in." :accessor ede-object-sourcecode) (keybindings :allocation :class :initform (("D" . ede-debug-target)) :documentation "Keybindings specialized to this type of target." :accessor ede-object-keybindings) (menu :allocation :class :initform (["Debug target" ede-debug-target (and ede-object (obj-of-class-p ede-object ede-target))]) :documentation "Menu specialized to this type of target." :accessor ede-object-menu)) "A top level target to build.")

(defclass ede-project (ede-project-placeholder) ((subproj :initform nil :type list :documentation "Sub projects controlled by this project.\nFor Automake based projects, each directory is treated as a project.") (targets :initarg :targets :type list :custom (repeat (object :objectcreatefcn ede-new-target-custom)) :label "Local Targets" :group (targets) :documentation "List of top level targets in this project.") (web-site-url :initarg :web-site-url :initform "" :type string :custom string :label "Web Site URL" :group name :documentation "URL to this projects web site.\nThis is a URL to be sent to a web site for documentation.") (web-site-directory :initarg :web-site-directory :initform "" :custom string :label "Web Page Directory" :group name :documentation "A directory where web pages can be found by Emacs.\nFor remote locations use a path compatible with ange-ftp or EFS.\nYou can also use TRAMP for use with rcp & scp.") (web-site-file :initarg :web-site-file :initform "" :custom string :label "Web Page File" :group name :documentation "A file which contains the home page for this project.\nThis file can be relative to slot `web-site-directory'.\nThis can be a local file, use ange-ftp, EFS, or TRAMP.") (ftp-site :initarg :ftp-site :initform "" :type string :custom string :label "FTP site" :group name :documentation "FTP site where this project's distribution can be found.\nThis FTP site should be in Emacs form, as needed by `ange-ftp', but can\nalso be of a form used by TRAMP for use with scp, or rcp.") (ftp-upload-site :initarg :ftp-upload-site :initform "" :type string :custom string :label "FTP Upload site" :group name :documentation "FTP Site to upload new distributions to.\nThis FTP site should be in Emacs form as needed by `ange-ftp'.\nIf this slot is nil, then use `ftp-site' instead.") (configurations :initarg :configurations :initform ("debug" "release") :type list :custom (repeat string) :label "Configuration Options" :group (settings) :documentation "List of available configuration types.\nIndividual target/project types can form associations between a configuration,\nand target specific elements such as build variables.") (configuration-default :initarg :configuration-default :initform "debug" :custom string :label "Current Configuration" :group (settings) :documentation "The default configuration.") (local-variables :initarg :local-variables :initform nil :custom (repeat (cons (sexp :tag "Variable") (sexp :tag "Value"))) :label "Project Local Variables" :group (settings) :documentation "Project local variables") (keybindings :allocation :class :initform (("D" . ede-debug-target)) :documentation "Keybindings specialized to this type of target." :accessor ede-object-keybindings) (menu :allocation :class :initform (["Update Version" ede-update-version ede-object] ["Version Control Status" ede-vc-project-directory ede-object] ["Edit Project Homepage" ede-edit-web-page (and ede-object (oref (ede-toplevel) web-site-file))] ["Browse Project URL" ede-web-browse-home (and ede-object (not (string= "" (oref (ede-toplevel) web-site-url))))] "--" ["Rescan Project Files" ede-rescan-toplevel t] ["Edit Projectfile" ede-edit-file-target (and ede-object (or (listp ede-object) (not (obj-of-class-p ede-object ede-project))))]) :documentation "Menu specialized to this type of target." :accessor ede-object-menu)) "Top level EDE project specification.\nAll specific project types must derive from this project.")

(defvar ede-projects nil "\
A list of all active projects currently loaded in Emacs.")

(defvar ede-minor-mode nil "\
Non-nil in EDE controlled buffers.")

(autoload 'ede-remove-file "ede" "\
Remove the current file from targets.
Optional argument FORCE forces the file to be removed without asking." t nil)

(autoload 'ede-compile-target "ede" "\
Compile the current buffer's associated target." t nil)

(defmethod project-edit-file-target ((ot ede-target)) "Edit the target OT associated w/ this file." (find-file (oref (ede-current-project) file)))

(defmethod project-compile-project ((obj ede-project) &optional command) "Compile the entire current project OBJ.\nArgument COMMAND is the command to use when compiling." (error "compile-project not supported by %s" (object-name obj)))

(defmethod project-compile-target ((obj ede-target) &optional command) "Compile the current target OBJ.\nArgument COMMAND is the command to use for compiling the target." (error "compile-target not supported by %s" (object-name obj)))

(defmethod project-make-dist ((this ede-project)) "Build a distribution for the project based on THIS project." (error "Make-dist not supported by %s" (object-name this)))

(defmethod ede-name ((this ede-target)) "Return the name of THIS targt." (oref this name))

(defmethod ede-description ((this ede-project)) "Return a description suitible for the minibuffer about THIS." (format "Project %s: %d subprojects, %d targets." (ede-name this) (length (oref this subproj)) (length (oref this targets))))

(autoload 'ede-documentation-files "ede" "\
Return the documentation files for the current buffer.
Not all buffers need documentations, so return nil if no applicable.
Some projects may have multiple documentation files, so return a list." nil nil)

(autoload 'ede-load-project-file "ede" "\
Project file independent way to read in FILE." nil nil)

(autoload 'ede-parent-project "ede" "\
Return the project belonging to the parent directory.
nil if there is no previous directory.
Optional argument OBJ is an object to find the parent of." nil nil)

(autoload 'ede-target-parent "ede" "\
Return the project which is the parent of TARGET.
It is recommended you track the project a different way as this function
could become slow in time." nil nil)

;;;***

(provide 'ede-autoloads)
