;;; semantic-c-by.el --- Generated parser support file

;; Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007 Eric M. Ludlam

;; Author: Eric M. Ludlam <zappo@projectile.siege-engine.com>
;; Created: 2007-06-05 21:47:07-0400
;; Keywords: syntax
;; X-RCS: $Id: semantic-c-by.el,v 1.1 2007/11/26 15:11:54 michaels Exp $

;; This file is not part of GNU Emacs.
;;
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or (at
;; your option) any later version.
;;
;; This software is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
;; Boston, MA 02110-1301, USA.

;;; Commentary:
;;
;; PLEASE DO NOT MANUALLY EDIT THIS FILE!  It is automatically
;; generated from the grammar file c.by.

;;; History:
;;

;;; Code:

;;; Prologue
;;

;;; Declarations
;;
(defconst semantic-c-by--keyword-table
  (semantic-lex-make-keyword-table
   '(("include" . INCLUDE)
     ("extern" . EXTERN)
     ("static" . STATIC)
     ("const" . CONST)
     ("volatile" . VOLATILE)
     ("register" . REGISTER)
     ("signed" . SIGNED)
     ("unsigned" . UNSIGNED)
     ("inline" . INLINE)
     ("virtual" . VIRTUAL)
     ("mutable" . MUTABLE)
     ("struct" . STRUCT)
     ("union" . UNION)
     ("enum" . ENUM)
     ("typedef" . TYPEDEF)
     ("class" . CLASS)
     ("typename" . TYPENAME)
     ("namespace" . NAMESPACE)
     ("using" . USING)
     ("template" . TEMPLATE)
     ("throw" . THROW)
     ("reentrant" . REENTRANT)
     ("try" . TRY)
     ("catch" . CATCH)
     ("operator" . OPERATOR)
     ("public" . PUBLIC)
     ("private" . PRIVATE)
     ("protected" . PROTECTED)
     ("friend" . FRIEND)
     ("if" . IF)
     ("else" . ELSE)
     ("do" . DO)
     ("while" . WHILE)
     ("for" . FOR)
     ("switch" . SWITCH)
     ("case" . CASE)
     ("default" . DEFAULT)
     ("return" . RETURN)
     ("break" . BREAK)
     ("continue" . CONTINUE)
     ("sizeof" . SIZEOF)
     ("void" . VOID)
     ("char" . CHAR)
     ("wchar_t" . WCHAR)
     ("short" . SHORT)
     ("int" . INT)
     ("long" . LONG)
     ("float" . FLOAT)
     ("double" . DOUBLE)
     ("bool" . BOOL)
     ("_P" . UNDERP)
     ("__P" . UNDERUNDERP)
     ("__attribute__" . __ATTRIBUTE__))
   '(("__attribute__" summary "<cdecl> __attribute__ ((<attributeoption>))")
     ("__P" summary "Common macro to eliminate prototype compatibility on some compilers")
     ("_P" summary "Common macro to eliminate prototype compatibility on some compilers")
     ("bool" summary "Primitive boolean type")
     ("double" summary "Primitive floating-point type (double-precision 64-bit IEEE 754)")
     ("float" summary "Primitive floating-point type (single-precision 32-bit IEEE 754)")
     ("long" summary "Integral primitive type (-9223372036854775808 to 9223372036854775807)")
     ("int" summary "Integral Primitive Type: (-2147483648 to 2147483647)")
     ("short" summary "Integral Primitive Type: (-32768 to 32767)")
     ("wchar_t" summary "Wide Character Type")
     ("char" summary "Integral Character Type: (0 to 256)")
     ("void" summary "Built in typeless type: void")
     ("sizeof" summary "Compile time macro: sizeof(<type or variable>) // size in bytes")
     ("continue" summary "Non-local continue within a loop (for, do/while): continue;")
     ("break" summary "Non-local exit within a loop or switch (for, do/while, switch): break;")
     ("return" summary "return <value>;")
     ("default" summary "switch (<variable>) { case <constvalue>: code; ... default: code; }")
     ("case" summary "switch (<variable>) { case <constvalue>: code; ... default: code; }")
     ("switch" summary "switch (<variable>) { case <constvalue>: code; ... default: code; }")
     ("for" summary "for(<init>; <condition>; <increment>) { code }")
     ("while" summary "do { code } while (<condition>); or while (<condition>) { code };")
     ("do" summary " do { code } while (<condition>);")
     ("else" summary "if (<condition>) { code } [ else { code } ]")
     ("if" summary "if (<condition>) { code } [ else { code } ]")
     ("catch" summary "try { <body> } catch { <catch code> }")
     ("try" summary "try { <body> } catch { <catch code> }")
     ("reentrant" summary "<type> <methoddef> (<method args>) reentrant ...")
     ("throw" summary "<type> <methoddef> (<method args>) throw (<exception>) ...")
     ("template" summary "template <class TYPE ...> TYPE_OR_FUNCTION")
     ("using" summary "using <namespace>;")
     ("namespace" summary "Namespace Declaration: namespace <name> { ... };")
     ("typename" summary "typename is used to handle a qualified name as a typename;")
     ("class" summary "Class Declaration: class <name>[:parents] { ... };")
     ("typedef" summary "Arbitrary Type Declaration: typedef <typedeclaration> <name>;")
     ("enum" summary "Enumeration Type Declaration: enum [name] { ... };")
     ("union" summary "Union Type Declaration: union [name] { ... };")
     ("struct" summary "Structure Type Declaration: struct [name] { ... };")
     ("mutable" summary "Member Declaration Modifier: mutable <type> <name> ...")
     ("virtual" summary "Method Modifier: virtual <type> <name>(...) ...")
     ("inline" summary "Function Modifier: inline <return  type> <name>(...) {...};")
     ("unsigned" summary "Numeric Type Modifier: unsigned <numeric type> <name> ...")
     ("signed" summary "Numeric Type Modifier: signed <numeric type> <name> ...")
     ("register" summary "Declaration Modifier: register <type> <name> ...")
     ("volatile" summary "Declaration Modifier: volatile <type> <name> ...")
     ("const" summary "Declaration Modifier: const <type> <name> ...")
     ("static" summary "Declaration Modifier: static <type> <name> ...")
     ("extern" summary "Declaration Modifier: extern <type> <name> ...")))
  "Table of language keywords.")

(defconst semantic-c-by--token-table
  (semantic-lex-make-type-table
   '(("semantic-list"
      (BRACKETS . "\\[\\]")
      (PARENS . "()")
      (VOID_BLCK . "^(void)$")
      (BRACE_BLCK . "^{")
      (PAREN_BLCK . "^(")
      (BRACK_BLCK . "\\[.*\\]$"))
     ("close-paren"
      (RBRACE . "}")
      (RPAREN . ")"))
     ("open-paren"
      (LBRACE . "{")
      (LPAREN . "("))
     ("symbol"
      (RESTRICT . "\\<\\(__\\)?restrict\\>"))
     ("number"
      (ZERO . "^0$"))
     ("string"
      (C . "\"C\""))
     ("punctuation"
      (OPSTART . "[-+*/%^|&]")
      (OR . "\\`[|]\\'")
      (HAT . "\\`\\^\\'")
      (MOD . "\\`[%]\\'")
      (TILDE . "\\`[~]\\'")
      (COMA . "\\`[,]\\'")
      (GREATER . "\\`[>]\\'")
      (LESS . "\\`[<]\\'")
      (EQUAL . "\\`[=]\\'")
      (BANG . "\\`[!]\\'")
      (MINUS . "\\`[-]\\'")
      (PLUS . "\\`[+]\\'")
      (DIVIDE . "\\`[/]\\'")
      (AMPERSAND . "\\`[&]\\'")
      (STAR . "\\`[*]\\'")
      (SEMICOLON . "\\`[;]\\'")
      (COLON . "\\`[:]\\'")
      (PERIOD . "\\`[.]\\'")
      (HASH . "\\`[#]\\'")))
   'nil)
  "Table of lexical tokens.")

(defconst semantic-c-by--parse-table
  `(
    (bovine-toplevel 
     (declaration)
     ) ;; end bovine-toplevel

    (bovine-inner-scope 
     (codeblock)
     ) ;; end bovine-inner-scope

    (declaration
     (macro)
     (type)
     (define)
     (var-or-fun)
     (extern-c)
     (template)
     (using)
     ) ;; end declaration

    (codeblock
     (define)
     (codeblock-var-or-fun)
     (type)
     ) ;; end codeblock

    (extern-c-contents
     (open-paren
      ,(semantic-lambda
	(list nil))
      )
     (declaration)
     (close-paren
      ,(semantic-lambda
	(list nil))
      )
     ) ;; end extern-c-contents

    (extern-c
     (EXTERN
      string
      "\"C\""
      semantic-list
      ,(semantic-lambda
	(semantic-tag
	 "C"
	 'extern :members
	 (semantic-parse-region
	  (car
	   (nth 2 vals))
	  (cdr
	   (nth 2 vals))
	  'extern-c-contents
	  1)))
      )
     (EXTERN
      string
      "\"C\""
      ,(semantic-lambda
	(list nil))
      )
     ) ;; end extern-c

    (macro-expression-list
     (expression
      macro-expression-list
      punctuation
      "\\`[;]\\'"
      ,(semantic-lambda
	(list nil))
      )
     (expression
      ,(semantic-lambda
	(list nil))
      )
     ) ;; end macro-expression-list

    (macro-def
     (macro-expression-list
      ,(semantic-lambda
	(list nil))
      )
     (expression
      ,(semantic-lambda
	(list nil))
      )
     ( ;;EMPTY
      )
     ) ;; end macro-def

    (macro
     (spp-macro-def
      opt-define-arglist
      macro-def
      ,(semantic-lambda
	(semantic-tag-new-variable
	 (nth 0 vals) nil
	 (nth 2 vals) :constant-flag t))
      )
     (punctuation
      "\\`[#]\\'"
      macro-or-include
      ,(semantic-lambda
	(nth 1 vals))
      )
     ) ;; end macro

    (macro-or-include
     (INCLUDE
      system-include
      ,(semantic-lambda
	(semantic-tag-new-include
	 (substring
	  (nth 1 vals)
	  1
	  (1-
	   (length
	    (nth 1 vals)))) t))
      )
     (INCLUDE
      string
      ,(semantic-lambda
	(semantic-tag-new-include
	 (read
	  (nth 1 vals)) nil))
      )
     ) ;; end macro-or-include

    (opt-define-arglist
     (semantic-list
      ,(semantic-lambda
	(list nil))
      )
     ( ;;EMPTY
      )
     ) ;; end opt-define-arglist

    (define
      (spp-macro-def
       opt-define-arglist
       macro-def
       ,(semantic-lambda
	 (semantic-tag-new-variable
	  (nth 0 vals) nil
	  (nth 2 vals) :constant-flag t))
       )
      (spp-macro-undef
       ,(semantic-lambda
	 (list nil))
       )
      )	;; end define

    (unionparts
     (semantic-list
      ,(semantic-lambda
	(semantic-parse-region
	 (car
	  (nth 0 vals))
	 (cdr
	  (nth 0 vals))
	 'classsubparts
	 1))
      )
     ) ;; end unionparts

    (opt-symbol
     (symbol)
     ( ;;EMPTY
      )
     ) ;; end opt-symbol

    (classsubparts
     (open-paren
      "{"
      ,(semantic-lambda
	(list nil))
      )
     (close-paren
      "}"
      ,(semantic-lambda
	(list nil))
      )
     (class-protection
      opt-symbol
      punctuation
      "\\`[:]\\'"
      ,(semantic-lambda
	(semantic-tag
	 (car
	  (nth 0 vals))
	 'label))
      )
     (var-or-fun)
     (type)
     (define)
     (template)
     ( ;;EMPTY
      )
     ) ;; end classsubparts

    (opt-class-parents
     (punctuation
      "\\`[:]\\'"
      class-parents
      opt-template-specifier
      ,(semantic-lambda
	(list
	 (nth 1 vals)))
      )
     ( ;;EMPTY
      ,(semantic-lambda)
      )
     ) ;; end opt-class-parents

    (class-parents
     (opt-class-protection
      opt-class-declmods
      namespace-symbol
      punctuation
      "\\`[,]\\'"
      class-parents
      ,(semantic-lambda
	(cons
	 (nth 2 vals)
	 (nth 4 vals)))
      )
     (opt-class-protection
      opt-class-declmods
      namespace-symbol
      ,(semantic-lambda
	(nth 2 vals))
      )
     ) ;; end class-parents

    (opt-class-declmods
     (class-declmods
      opt-class-declmods
      ,(semantic-lambda
	(list nil))
      )
     ( ;;EMPTY
      )
     ) ;; end opt-class-declmods

    (class-declmods
     (VIRTUAL)
     ) ;; end class-declmods

    (class-protection
     (PUBLIC)
     (PRIVATE)
     (PROTECTED)
     ) ;; end class-protection

    (opt-class-protection
     (class-protection
      ,(semantic-lambda
	(nth 0 vals))
      )
     ( ;;EMPTY
      )
     ) ;; end opt-class-protection

    (namespaceparts
     (semantic-list
      ,(semantic-lambda
	(semantic-parse-region
	 (car
	  (nth 0 vals))
	 (cdr
	  (nth 0 vals))
	 'namespacesubparts
	 1))
      )
     ) ;; end namespaceparts

    (namespacesubparts
     (open-paren
      "{"
      ,(semantic-lambda
	(list nil))
      )
     (close-paren
      "}"
      ,(semantic-lambda
	(list nil))
      )
     (type)
     (var-or-fun)
     (define)
     (class-protection
      punctuation
      "\\`[:]\\'"
      ,(semantic-lambda
	(semantic-tag
	 (car
	  (nth 0 vals))
	 'label))
      )
     (template)
     (using)
     ( ;;EMPTY
      )
     ) ;; end namespacesubparts

    (enumparts
     (semantic-list
      ,(semantic-lambda
	(semantic-parse-region
	 (car
	  (nth 0 vals))
	 (cdr
	  (nth 0 vals))
	 'enumsubparts
	 1))
      )
     ) ;; end enumparts

    (enumsubparts
     (symbol
      opt-assign
      ,(semantic-lambda
	(semantic-tag-new-variable
	 (nth 0 vals)
	 "int"
	 (car
	  (nth 1 vals)) :constant-flag t))
      )
     (open-paren
      "{"
      ,(semantic-lambda
	(list nil))
      )
     (close-paren
      "}"
      ,(semantic-lambda
	(list nil))
      )
     (punctuation
      "\\`[,]\\'"
      ,(semantic-lambda
	(list nil))
      )
     ) ;; end enumsubparts

    (opt-name
     (symbol)
     ( ;;EMPTY
      ,(semantic-lambda
	(list
	 ""))
      )
     ) ;; end opt-name

    (opt-class-declmods
     (symbol
      declespec
      semantic-list)
     (symbol)
     ( ;;EMPTY
      )
     ) ;; end opt-class-declmods

    (typesimple
     (struct-or-class
      opt-class
      opt-name
      opt-template-specifier
      opt-class-parents
      semantic-list
      ,(semantic-lambda
	(semantic-tag-new-type
	 (car
	  (nth 2 vals))
	 (car
	  (nth 0 vals))
	 (let
	     (
	      (semantic-c-classname
	       (cons
		(car
		 (nth 2 vals))
		(car
		 (nth 0 vals)))))
	   (semantic-parse-region
	    (car
	     (nth 5 vals))
	    (cdr
	     (nth 5 vals))
	    'classsubparts
	    1))
	 (nth 4 vals) :template-specifier
	 (nth 3 vals) :parent
	 (car
	  (nth 1 vals))))
      )
     (struct-or-class
      opt-class
      opt-name
      opt-template-specifier
      opt-class-parents
      ,(semantic-lambda
	(semantic-tag-new-type
	 (car
	  (nth 2 vals))
	 (car
	  (nth 0 vals)) nil
	 (nth 4 vals) :template-specifier
	 (nth 3 vals) :prototype t :parent
	 (car
	  (nth 1 vals))))
      )
     (UNION
      opt-class
      opt-name
      unionparts
      ,(semantic-lambda
	(semantic-tag-new-type
	 (car
	  (nth 2 vals))
	 (nth 0 vals)
	 (nth 3 vals) nil :parent
	 (car
	  (nth 1 vals))))
      )
     (ENUM
      opt-class
      opt-name
      enumparts
      ,(semantic-lambda
	(semantic-tag-new-type
	 (car
	  (nth 2 vals))
	 (nth 0 vals)
	 (nth 3 vals) nil :parent
	 (car
	  (nth 1 vals))))
      )
     (TYPEDEF
      declmods
      typeformbase
      cv-declmods
      typedef-symbol-list
      ,(semantic-lambda
	(semantic-tag-new-type
	 (nth 4 vals)
	 (nth 0 vals) nil
	 (list
	  (nth 2 vals))))
      )
     ) ;; end typesimple

    (typedef-symbol-list
     (typedefname
      punctuation
      "\\`[,]\\'"
      typedef-symbol-list
      ,(semantic-lambda
	(cons
	 (nth 0 vals)
	 (nth 2 vals)))
      )
     (typedefname
      ,(semantic-lambda
	(list
	 (nth 0 vals)))
      )
     ) ;; end typedef-symbol-list

    (typedefname
     (opt-stars
      symbol
      opt-bits
      opt-array
      ,(semantic-lambda
	(list
	 (nth 0 vals)
	 (nth 1 vals)))
      )
     ) ;; end typedefname

    (struct-or-class
     (STRUCT)
     (CLASS)
     ) ;; end struct-or-class

    (type
     (typesimple
      opt-attribute
      punctuation
      "\\`[;]\\'"
      ,(semantic-lambda
	(nth 0 vals))
      )
     (NAMESPACE
      symbol
      namespaceparts
      ,(semantic-lambda
	(semantic-tag-new-type
	 (nth 1 vals)
	 (nth 0 vals)
	 (nth 2 vals) nil))
      )
     (NAMESPACE
      namespaceparts
      ,(semantic-lambda
	(semantic-tag-new-type
	 "unnamed"
	 (nth 0 vals)
	 (nth 1 vals) nil))
      )
     ) ;; end type

    (opt-attribute
     (__ATTRIBUTE__
      semantic-list
      ,(semantic-lambda
	(list nil))
      )
     ( ;;EMPTY
      ,(semantic-lambda
	(list nil))
      )
     ) ;; end opt-attribute

    (using
     (USING
      typeformbase
      punctuation
      "\\`[;]\\'"
      ,(semantic-lambda
	(list nil))
      )
     (USING
      NAMESPACE
      typeformbase
      punctuation
      "\\`[;]\\'"
      ,(semantic-lambda
	(list nil))
      )
     ) ;; end using

    (template
     (TEMPLATE
      template-specifier
      opt-friend
      template-definition
      ,(semantic-lambda
	(semantic-c-reconstitute-template
	 (nth 3 vals)
	 (nth 1 vals)))
      )
     ) ;; end template

    (opt-friend
     (FRIEND)
     ( ;;EMPTY
      )
     ) ;; end opt-friend

    (opt-template-specifier
     (template-specifier
      ,(semantic-lambda
	(nth 0 vals))
      )
     ( ;;EMPTY
      ,(semantic-lambda)
      )
     ) ;; end opt-template-specifier

    (template-specifier
     (punctuation
      "\\`[<]\\'"
      template-specifier-types
      punctuation
      "\\`[>]\\'"
      ,(semantic-lambda
	(nth 1 vals))
      )
     ) ;; end template-specifier

    (template-specifier-types
     (template-var
      template-specifier-type-list
      ,(semantic-lambda
	(cons
	 (nth 0 vals)
	 (nth 1 vals)))
      )
     ( ;;EMPTY
      )
     ) ;; end template-specifier-types

    (template-specifier-type-list
     (punctuation
      "\\`[,]\\'"
      template-specifier-types
      ,(semantic-lambda
	(nth 1 vals))
      )
     ( ;;EMPTY
      ,(semantic-lambda)
      )
     ) ;; end template-specifier-type-list

    (template-var
     (template-type
      opt-template-equal
      ,(semantic-lambda
	(cons
	 (car
	  (nth 0 vals))
	 (cdr
	  (nth 0 vals))))
      )
     (string
      ,(semantic-lambda
	(list
	 (nth 0 vals)))
      )
     (number
      ,(semantic-lambda
	(list
	 (nth 0 vals)))
      )
     (opt-stars
      opt-ref
      namespace-symbol
      ,(semantic-lambda
	(nth 2 vals))
      )
     ) ;; end template-var

    (opt-template-equal
     (punctuation
      "\\`[=]\\'"
      symbol
      punctuation
      "\\`[<]\\'"
      template-specifier-types
      punctuation
      "\\`[>]\\'"
      ,(semantic-lambda
	(list
	 (nth 1 vals)))
      )
     (punctuation
      "\\`[=]\\'"
      symbol
      ,(semantic-lambda
	(list
	 (nth 1 vals)))
      )
     ( ;;EMPTY
      ,(semantic-lambda)
      )
     ) ;; end opt-template-equal

    (template-type
     (CLASS
      symbol
      ,(semantic-lambda
	(semantic-tag-new-type
	 (nth 1 vals)
	 "class" nil nil))
      )
     (STRUCT
      symbol
      ,(semantic-lambda
	(semantic-tag-new-type
	 (nth 1 vals)
	 "struct" nil nil))
      )
     (TYPENAME
      symbol
      ,(semantic-lambda
	(semantic-tag-new-type
	 (nth 1 vals)
	 "class" nil nil))
      )
     (declmods
      typeformbase
      cv-declmods
      opt-stars
      opt-ref
      variablearg-opt-name
      ,(semantic-lambda
	(semantic-tag-new-type
	 (car
	  (nth 1 vals)) nil nil nil :constant-flag
	 (if
	     (member
	      "const"
	      (append
	       (nth 0 vals)
	       (nth 2 vals))) t nil) :typemodifiers
	 (delete
	  "const"
	  (append
	   (nth 0 vals)
	   (nth 2 vals))) :reference
	 (car
	  (nth 4 vals)) :pointer
	 (car
	  (nth 3 vals))))
      )
     ) ;; end template-type

    (template-definition
     (type
      ,(semantic-lambda
	(nth 0 vals))
      )
     (var-or-fun
      ,(semantic-lambda
	(nth 0 vals))
      )
     ) ;; end template-definition

    (opt-stars
     (punctuation
      "\\`[*]\\'"
      opt-starmod
      opt-stars
      ,(semantic-lambda
	(list
	 (1+
	  (car
	   (nth 2 vals)))))
      )
     ( ;;EMPTY
      ,(semantic-lambda
	(list
	 0))
      )
     ) ;; end opt-stars

    (opt-starmod
     (STARMOD
      opt-starmod
      ,(semantic-lambda
	(cons
	 (car
	  (nth 0 vals))
	 (nth 1 vals)))
      )
     ( ;;EMPTY
      ,(semantic-lambda)
      )
     ) ;; end opt-starmod

    (STARMOD
     (CONST)
     ) ;; end STARMOD

    (declmods
     (DECLMOD
      declmods
      ,(semantic-lambda
	(cons
	 (car
	  (nth 0 vals))
	 (nth 1 vals)))
      )
     (DECLMOD
      ,(semantic-lambda
	(nth 0 vals))
      )
     ( ;;EMPTY
      ,(semantic-lambda)
      )
     ) ;; end declmods

    (DECLMOD
     (EXTERN)
     (STATIC)
     (CVDECLMOD)
     (INLINE)
     (REGISTER)
     (FRIEND)
     (TYPENAME)
     (METADECLMOD)
     (VIRTUAL)
     ) ;; end DECLMOD

    (metadeclmod
     (METADECLMOD
      ,(semantic-lambda)
      )
     ( ;;EMPTY
      ,(semantic-lambda)
      )
     ) ;; end metadeclmod

    (CVDECLMOD
     (CONST)
     (VOLATILE)
     ) ;; end CVDECLMOD

    (cv-declmods
     (CVDECLMOD
      cv-declmods
      ,(semantic-lambda
	(cons
	 (car
	  (nth 0 vals))
	 (nth 1 vals)))
      )
     (CVDECLMOD
      ,(semantic-lambda
	(nth 0 vals))
      )
     ( ;;EMPTY
      ,(semantic-lambda)
      )
     ) ;; end cv-declmods

    (METADECLMOD
     (VIRTUAL)
     (MUTABLE)
     ) ;; end METADECLMOD

    (opt-ref
     (punctuation
      "\\`[&]\\'"
      ,(semantic-lambda
	(list
	 1))
      )
     ( ;;EMPTY
      ,(semantic-lambda
	(list
	 0))
      )
     ) ;; end opt-ref

    (typeformbase
     (typesimple
      ,(semantic-lambda
	(nth 0 vals))
      )
     (STRUCT
      symbol
      ,(semantic-lambda
	(semantic-tag-new-type
	 (nth 1 vals)
	 (nth 0 vals) nil nil))
      )
     (UNION
      symbol
      ,(semantic-lambda
	(semantic-tag-new-type
	 (nth 1 vals)
	 (nth 0 vals) nil nil))
      )
     (ENUM
      symbol
      ,(semantic-lambda
	(semantic-tag-new-type
	 (nth 1 vals)
	 (nth 0 vals) nil nil))
      )
     (builtintype
      ,(semantic-lambda
	(nth 0 vals))
      )
     (namespace-symbol
      ,(semantic-lambda
	(semantic-tag-new-type
	 (car
	  (nth 0 vals))
	 "class" nil nil))
      )
     (symbol
      ,(semantic-lambda
	(list
	 (nth 0 vals)))
      )
     ) ;; end typeformbase

    (signedmod
     (UNSIGNED)
     (SIGNED)
     ) ;; end signedmod

    (builtintype-types
     (VOID)
     (CHAR)
     (WCHAR)
     (SHORT
      INT
      ,(semantic-lambda
	(list
	 (concat
	  (nth 0 vals)
	  " "
	  (nth 1 vals))))
      )
     (SHORT)
     (INT)
     (LONG
      INT
      ,(semantic-lambda
	(list
	 (concat
	  (nth 0 vals)
	  " "
	  (nth 1 vals))))
      )
     (FLOAT)
     (DOUBLE)
     (BOOL)
     (LONG
      DOUBLE
      ,(semantic-lambda
	(list
	 (concat
	  (nth 0 vals)
	  " "
	  (nth 1 vals))))
      )
     (LONG
      LONG
      ,(semantic-lambda
	(list
	 (concat
	  (nth 0 vals)
	  " "
	  (nth 1 vals))))
      )
     (LONG)
     ) ;; end builtintype-types

    (builtintype
     (signedmod
      builtintype-types
      ,(semantic-lambda
	(list
	 (concat
	  (car
	   (nth 0 vals))
	  " "
	  (car
	   (nth 1 vals)))))
      )
     (builtintype-types
      ,(semantic-lambda
	(nth 0 vals))
      )
     (signedmod
      ,(semantic-lambda
	(list
	 (concat
	  (car
	   (nth 0 vals))
	  " int")))
      )
     ) ;; end builtintype

    (codeblock-var-or-fun
     (declmods
      typeformbase
      declmods
      opt-ref
      var-or-func-decl
      ,(semantic-lambda
	(semantic-c-reconstitute-token
	 (nth 4 vals)
	 (nth 0 vals)
	 (nth 1 vals)))
      )
     ) ;; end codeblock-var-or-fun

    (var-or-fun
     (codeblock-var-or-fun
      ,(semantic-lambda
	(nth 0 vals))
      )
     (declmods
      var-or-func-decl
      ,(semantic-lambda
	(semantic-c-reconstitute-token
	 (nth 1 vals)
	 (nth 0 vals) nil))
      )
     ) ;; end var-or-fun

    (var-or-func-decl
     (func-decl
      ,(semantic-lambda
	(nth 0 vals))
      )
     (var-decl
      ,(semantic-lambda
	(nth 0 vals))
      )
     ) ;; end var-or-func-decl

    (func-decl
     (opt-stars
      opt-class
      opt-destructor
      functionname
      opt-template-specifier
      opt-under-p
      arg-list
      opt-post-fcn-modifiers
      opt-throw
      opt-initializers
      fun-or-proto-end
      ,(semantic-lambda
	(nth 3 vals)
	(list
	 'function
	 (nth 1 vals)
	 (nth 2 vals)
	 (nth 6 vals)
	 (nth 8 vals)
	 (nth 7 vals))
	(nth 0 vals)
	(nth 10 vals))
      )
     (opt-stars
      opt-class
      opt-destructor
      functionname
      opt-template-specifier
      opt-under-p
      opt-post-fcn-modifiers
      opt-throw
      opt-initializers
      fun-try-end
      ,(semantic-lambda
	(nth 3 vals)
	(list
	 'function
	 (nth 1 vals)
	 (nth 2 vals) nil
	 (nth 7 vals)
	 (nth 6 vals))
	(nth 0 vals)
	(nth 9 vals))
      )
     ) ;; end func-decl

    (var-decl
     (varnamelist
      punctuation
      "\\`[;]\\'"
      ,(semantic-lambda
	(list
	 (nth 0 vals)
	 'variable))
      )
     ) ;; end var-decl

    (opt-under-p
     (UNDERP
      ,(semantic-lambda
	(list nil))
      )
     (UNDERUNDERP
      ,(semantic-lambda
	(list nil))
      )
     ( ;;EMPTY
      )
     ) ;; end opt-under-p

    (opt-initializers
     (punctuation
      "\\`[:]\\'"
      namespace-symbol
      semantic-list
      opt-initializers)
     (punctuation
      "\\`[,]\\'"
      namespace-symbol
      semantic-list
      opt-initializers)
     ( ;;EMPTY
      )
     ) ;; end opt-initializers

    (opt-post-fcn-modifiers
     (post-fcn-modifiers
      opt-post-fcn-modifiers
      ,(semantic-lambda
	(cons
	 (nth 0 vals)
	 (nth 1 vals)))
      )
     ( ;;EMPTY
      ,(semantic-lambda
	(list nil))
      )
     ) ;; end opt-post-fcn-modifiers

    (post-fcn-modifiers
     (REENTRANT)
     (CONST)
     ) ;; end post-fcn-modifiers

    (opt-throw
     (THROW
      semantic-list
      ,(lambda (vals start end)
	 (semantic-bovinate-from-nonterminal
	  (car
	   (nth 1 vals))
	  (cdr
	   (nth 1 vals))
	  'throw-exception-list))
      )
     ( ;;EMPTY
      )
     ) ;; end opt-throw

    (throw-exception-list
     (namespace-symbol
      punctuation
      "\\`[,]\\'"
      throw-exception-list
      ,(semantic-lambda
	(cons
	 (car
	  (nth 0 vals))
	 (nth 2 vals)))
      )
     (namespace-symbol
      close-paren
      ")"
      ,(semantic-lambda
	(nth 0 vals))
      )
     (symbol
      close-paren
      ")"
      ,(semantic-lambda
	(list
	 (nth 0 vals)))
      )
     (open-paren
      "("
      throw-exception-list
      ,(semantic-lambda
	(nth 1 vals))
      )
     (close-paren
      ")"
      ,(semantic-lambda)
      )
     ) ;; end throw-exception-list

    (opt-bits
     (punctuation
      "\\`[:]\\'"
      number
      ,(semantic-lambda
	(list
	 (nth 1 vals)))
      )
     ( ;;EMPTY
      ,(semantic-lambda
	(list nil))
      )
     ) ;; end opt-bits

    (opt-array
     (semantic-list
      "\\[.*\\]$"
      opt-array
      ,(semantic-lambda
	(list
	 (cons
	  1
	  (car
	   (nth 1 vals)))))
      )
     ( ;;EMPTY
      ,(semantic-lambda
	(list nil))
      )
     ) ;; end opt-array

    (opt-assign
     (punctuation
      "\\`[=]\\'"
      expression
      ,(semantic-lambda
	(list
	 (nth 1 vals)))
      )
     ( ;;EMPTY
      ,(semantic-lambda
	(list nil))
      )
     ) ;; end opt-assign

    (opt-restrict
     (symbol
      "\\<\\(__\\)?restrict\\>")
     ( ;;EMPTY
      )
     ) ;; end opt-restrict

    (varname
     (opt-stars
      opt-restrict
      namespace-symbol
      opt-bits
      opt-array
      opt-assign
      ,(semantic-lambda
	(nth 2 vals)
	(nth 0 vals)
	(nth 3 vals)
	(nth 4 vals)
	(nth 5 vals))
      )
     ) ;; end varname

    (variablearg
     (declmods
      typeformbase
      cv-declmods
      opt-ref
      variablearg-opt-name
      ,(semantic-lambda
	(semantic-tag-new-variable
	 (list
	  (nth 4 vals))
	 (nth 1 vals) nil :constant-flag
	 (if
	     (member
	      "const"
	      (append
	       (nth 0 vals)
	       (nth 2 vals))) t nil) :typemodifiers
	 (delete
	  "const"
	  (append
	   (nth 0 vals)
	   (nth 2 vals))) :reference
	 (car
	  (nth 3 vals))))
      )
     ) ;; end variablearg

    (variablearg-opt-name
     (varname
      ,(semantic-lambda
	(nth 0 vals))
      )
     (opt-stars
      ,(semantic-lambda
	(list
	 "")
	(nth 0 vals)
	(list nil nil nil))
      )
     ) ;; end variablearg-opt-name

    (varnamelist
     (varname
      punctuation
      "\\`[,]\\'"
      varnamelist
      ,(semantic-lambda
	(cons
	 (nth 0 vals)
	 (nth 2 vals)))
      )
     (varname
      ,(semantic-lambda
	(list
	 (nth 0 vals)))
      )
     ) ;; end varnamelist

    (namespace-symbol
     (symbol
      opt-template-specifier
      punctuation
      "\\`[:]\\'"
      punctuation
      "\\`[:]\\'"
      namespace-symbol
      ,(semantic-lambda
	(list
	 (concat
	  (nth 0 vals)
	  "::"
	  (car
	   (nth 4 vals)))))
      )
     (symbol
      opt-template-specifier
      ,(semantic-lambda
	(list
	 (nth 0 vals)))
      )
     ) ;; end namespace-symbol

    (namespace-opt-class
     (symbol
      punctuation
      "\\`[:]\\'"
      punctuation
      "\\`[:]\\'"
      namespace-opt-class
      ,(semantic-lambda
	(list
	 (concat
	  (nth 0 vals)
	  "::"
	  (car
	   (nth 3 vals)))))
      )
     (symbol
      opt-template-specifier
      punctuation
      "\\`[:]\\'"
      punctuation
      "\\`[:]\\'"
      ,(semantic-lambda
	(list
	 (nth 0 vals)))
      )
     ) ;; end namespace-opt-class

    (opt-class
     (namespace-opt-class
      ,(semantic-lambda
	(nth 0 vals))
      )
     ( ;;EMPTY
      ,(semantic-lambda
	(list nil))
      )
     ) ;; end opt-class

    (opt-destructor
     (punctuation
      "\\`[~]\\'"
      ,(semantic-lambda
	(list t))
      )
     ( ;;EMPTY
      ,(semantic-lambda
	(list nil))
      )
     ) ;; end opt-destructor

    (arg-list
     (semantic-list
      "^("
      knr-arguments
      ,(semantic-lambda
	(nth 1 vals))
      )
     (semantic-list
      "^("
      ,(semantic-lambda
	(semantic-parse-region
	 (car
	  (nth 0 vals))
	 (cdr
	  (nth 0 vals))
	 'arg-sub-list
	 1))
      )
     (semantic-list
      "^(void)$"
      ,(semantic-lambda)
      )
     ) ;; end arg-list

    (knr-arguments
     (variablearg
      punctuation
      "\\`[;]\\'"
      knr-arguments
      ,(semantic-lambda
	(cons
	 (car
	  (semantic-expand-c-tag
	   (nth 0 vals)))
	 (nth 2 vals)))
      )
     (variablearg
      punctuation
      "\\`[;]\\'"
      ,(semantic-lambda
	(list
	 (car
	  (semantic-expand-c-tag
	   (nth 0 vals)))))
      )
     ) ;; end knr-arguments

    (arg-sub-list
     (variablearg
      ,(semantic-lambda
	(nth 0 vals))
      )
     (punctuation
      "\\`[.]\\'"
      punctuation
      "\\`[.]\\'"
      punctuation
      "\\`[.]\\'"
      close-paren
      ")"
      ,(semantic-lambda
	(semantic-tag-new-variable
	 "..."
	 "vararg" nil))
      )
     (punctuation
      "\\`[,]\\'"
      ,(semantic-lambda
	(list nil))
      )
     (open-paren
      "("
      ,(semantic-lambda
	(list nil))
      )
     (close-paren
      ")"
      ,(semantic-lambda
	(list nil))
      )
     ) ;; end arg-sub-list

    (operatorsym
     (punctuation
      "\\`[<]\\'"
      punctuation
      "\\`[<]\\'"
      punctuation
      "\\`[=]\\'"
      ,(semantic-lambda
	(list
	 "<<="))
      )
     (punctuation
      "\\`[>]\\'"
      punctuation
      "\\`[>]\\'"
      punctuation
      "\\`[=]\\'"
      ,(semantic-lambda
	(list
	 ">>="))
      )
     (punctuation
      "\\`[<]\\'"
      punctuation
      "\\`[<]\\'"
      ,(semantic-lambda
	(list
	 "<<"))
      )
     (punctuation
      "\\`[>]\\'"
      punctuation
      "\\`[>]\\'"
      ,(semantic-lambda
	(list
	 ">>"))
      )
     (punctuation
      "\\`[=]\\'"
      punctuation
      "\\`[=]\\'"
      ,(semantic-lambda
	(list
	 "=="))
      )
     (punctuation
      "\\`[<]\\'"
      punctuation
      "\\`[=]\\'"
      ,(semantic-lambda
	(list
	 "<="))
      )
     (punctuation
      "\\`[>]\\'"
      punctuation
      "\\`[=]\\'"
      ,(semantic-lambda
	(list
	 ">="))
      )
     (punctuation
      "\\`[!]\\'"
      punctuation
      "\\`[=]\\'"
      ,(semantic-lambda
	(list
	 "!="))
      )
     (punctuation
      "\\`[+]\\'"
      punctuation
      "\\`[=]\\'"
      ,(semantic-lambda
	(list
	 "+="))
      )
     (punctuation
      "\\`[-]\\'"
      punctuation
      "\\`[=]\\'"
      ,(semantic-lambda
	(list
	 "-="))
      )
     (punctuation
      "\\`[*]\\'"
      punctuation
      "\\`[=]\\'"
      ,(semantic-lambda
	(list
	 "*="))
      )
     (punctuation
      "\\`[/]\\'"
      punctuation
      "\\`[=]\\'"
      ,(semantic-lambda
	(list
	 "/="))
      )
     (punctuation
      "\\`[%]\\'"
      punctuation
      "\\`[=]\\'"
      ,(semantic-lambda
	(list
	 "%="))
      )
     (punctuation
      "\\`[&]\\'"
      punctuation
      "\\`[=]\\'"
      ,(semantic-lambda
	(list
	 "&="))
      )
     (punctuation
      "\\`[|]\\'"
      punctuation
      "\\`[=]\\'"
      ,(semantic-lambda
	(list
	 "|="))
      )
     (punctuation
      "\\`[-]\\'"
      punctuation
      "\\`[>]\\'"
      punctuation
      "\\`[*]\\'"
      ,(semantic-lambda
	(list
	 "->*"))
      )
     (punctuation
      "\\`[-]\\'"
      punctuation
      "\\`[>]\\'"
      ,(semantic-lambda
	(list
	 "->"))
      )
     (semantic-list
      "()"
      ,(semantic-lambda
	(list
	 "()"))
      )
     (semantic-list
      "\\[\\]"
      ,(semantic-lambda
	(list
	 "[]"))
      )
     (punctuation
      "\\`[<]\\'")
     (punctuation
      "\\`[>]\\'")
     (punctuation
      "\\`[*]\\'")
     (punctuation
      "\\`[+]\\'"
      punctuation
      "\\`[+]\\'"
      ,(semantic-lambda
	(list
	 "++"))
      )
     (punctuation
      "\\`[+]\\'")
     (punctuation
      "\\`[-]\\'"
      punctuation
      "\\`[-]\\'"
      ,(semantic-lambda
	(list
	 "--"))
      )
     (punctuation
      "\\`[-]\\'")
     (punctuation
      "\\`[&]\\'"
      punctuation
      "\\`[&]\\'"
      ,(semantic-lambda
	(list
	 "&&"))
      )
     (punctuation
      "\\`[&]\\'")
     (punctuation
      "\\`[|]\\'"
      punctuation
      "\\`[|]\\'"
      ,(semantic-lambda
	(list
	 "||"))
      )
     (punctuation
      "\\`[|]\\'")
     (punctuation
      "\\`[/]\\'")
     (punctuation
      "\\`[=]\\'")
     (punctuation
      "\\`[!]\\'")
     (punctuation
      "\\`[~]\\'")
     (punctuation
      "\\`[%]\\'")
     (punctuation
      "\\`[,]\\'")
     (punctuation
      "\\`\\^\\'"
      punctuation
      "\\`[=]\\'"
      ,(semantic-lambda
	(list
	 "^="))
      )
     (punctuation
      "\\`\\^\\'")
     ) ;; end operatorsym

    (functionname
     (OPERATOR
      operatorsym
      ,(semantic-lambda
	(nth 1 vals))
      )
     (semantic-list
      ,(lambda (vals start end)
	 (semantic-bovinate-from-nonterminal
	  (car
	   (nth 0 vals))
	  (cdr
	   (nth 0 vals))
	  'function-pointer))
      )
     (symbol
      ,(semantic-lambda
	(list
	 (nth 0 vals)))
      )
     ) ;; end functionname

    (function-pointer
     (open-paren
      "("
      punctuation
      "\\`[*]\\'"
      symbol
      close-paren
      ")"
      ,(semantic-lambda
	(list
	 (concat
	  "*"
	  (nth 2 vals))))
      )
     ) ;; end function-pointer

    (fun-or-proto-end
     (opt-attribute
      punctuation
      "\\`[;]\\'"
      ,(semantic-lambda
	(list t))
      )
     (semantic-list
      ,(semantic-lambda
	(list nil))
      )
     (punctuation
      "\\`[=]\\'"
      number
      "^0$"
      punctuation
      "\\`[;]\\'"
      ,(semantic-lambda
	(list ':pure-virtual-flag))
      )
     (fun-try-end
      ,(semantic-lambda
	(list nil))
      )
     ) ;; end fun-or-proto-end

    (fun-try-end
     (TRY
      opt-initializers
      semantic-list
      "^{"
      fun-try-several-catches
      ,(semantic-lambda
	(list nil))
      )
     ) ;; end fun-try-end

    (fun-try-several-catches
     (CATCH
      semantic-list
      "^("
      semantic-list
      "^{"
      fun-try-several-catches
      ,(semantic-lambda)
      )
     (CATCH
      semantic-list
      "^{"
      fun-try-several-catches
      ,(semantic-lambda)
      )
     ( ;;EMPTY
      ,(semantic-lambda)
      )
     ) ;; end fun-try-several-catches

    (type-cast
     (semantic-list
      ,(lambda (vals start end)
	 (semantic-bovinate-from-nonterminal
	  (car
	   (nth 0 vals))
	  (cdr
	   (nth 0 vals))
	  'type-cast-list))
      )
     ) ;; end type-cast

    (type-cast-list
     (open-paren
      typeformbase
      close-paren)
     ) ;; end type-cast-list

    (function-call
     (namespace-symbol
      punctuation
      "\\`[.]\\'"
      function-call)
     (namespace-symbol
      punctuation
      "\\`[-]\\'"
      punctuation
      "\\`[>]\\'"
      function-call)
     (namespace-symbol
      semantic-list)
     ) ;; end function-call

    (string-seq
     (string
      string-seq
      ,(semantic-lambda
	(list
	 (concat
	  (nth 0 vals)
	  (car
	   (nth 1 vals)))))
      )
     (string
      ,(semantic-lambda
	(list
	 (nth 0 vals)))
      )
     ) ;; end string-seq

    (expression
     (number
      ,(semantic-lambda
	(list
	 (identity start)
	 (identity end)))
      )
     (function-call
      ,(semantic-lambda
	(list
	 (identity start)
	 (identity end)))
      )
     (namespace-symbol
      ,(semantic-lambda
	(list
	 (identity start)
	 (identity end)))
      )
     (string-seq
      ,(semantic-lambda
	(list
	 (identity start)
	 (identity end)))
      )
     (type-cast
      expression
      ,(semantic-lambda
	(list
	 (identity start)
	 (identity end)))
      )
     (semantic-list
      ,(semantic-lambda
	(list
	 (identity start)
	 (identity end)))
      )
     (punctuation
      "[-+*/%^|&]"
      expression
      ,(semantic-lambda
	(list
	 (identity start)
	 (identity end)))
      )
     ) ;; end expression
    )
  "Parser table.")

(defun semantic-c-by--install-parser ()
  "Setup the Semantic Parser."
  (setq semantic--parse-table semantic-c-by--parse-table
	semantic-debug-parser-source "c.by"
	semantic-debug-parser-class 'semantic-bovine-debug-parser
	semantic-flex-keywords-obarray semantic-c-by--keyword-table
	semantic-equivalent-major-modes '(c-mode c++-mode)
	))


;;; Analyzers
;;
(require 'semantic-lex)


;;; Epilogue
;;

(provide 'semantic-c-by)

;;; semantic-c-by.el ends here
