;; erc-menu.el -- Menu-bar definitions for the Emacs IRC Client

;; Copyright (C) 2002  Free Software Foundation, Inc.

;; Author: Mario Lang <mlang@delysid.org>
;; Keywords: comm, processes, menu
;; URL: http://www.emacswiki.org/cgi-bin/wiki.pl?ErcMenu

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; Loading this file defines a menu for ERC.

;;; Code:

(require 'erc)
(require 'easymenu)

(defvar erc-menu-definition
  (list "IRC"
	["Connect to server..." erc-select t]
	["Disconnect from server..." erc-quit-server erc-connected]
	"-"
	["Join channel..." erc-join-channel t]
	["Leave this channel..." erc-part-from-channel channel-members]
	["List users in channel" erc-channel-names channel-members]
	["Set topic..." erc-set-topic
   (and channel-members
        (or (not (member "t" channel-modes))
            (nth 1 (assoc (erc-current-nick) channel-members))))]
  (list "Channel modes"
        ["Change mode..." erc-insert-mode-command
         (and channel-members (nth 1 (assoc (erc-current-nick) channel-members)))]
        ["No external send" (erc-toggle-channel-mode "n")
         :active (and channel-members
                      (nth 1 (assoc (erc-current-nick) channel-members)))
         :style toggle :selected (member "n" channel-modes)]
        ["Topic set by channel op" (erc-toggle-channel-mode "t")
         :style toggle :selected (member "t" channel-modes)
         :active (and channel-members
                      (nth 1 (assoc (erc-current-nick) channel-members)))]
        ["Invite only" (erc-toggle-channel-mode "i")
         :style toggle :selected (member "i" channel-modes)
         :active (and channel-members
                      (nth 1 (assoc (erc-current-nick) channel-members)))]
        ["Private" (erc-toggle-channel-mode "p")
         :style toggle :selected (member "p" channel-modes)
         :active (and channel-members
                      (nth 1 (assoc (erc-current-nick) channel-members)))]
        ["Secret" (erc-toggle-channel-mode "s")
         :style toggle :selected (member "s" channel-modes)
         :active (and channel-members
                      (nth 1 (assoc (erc-current-nick) channel-members)))]
        ["Moderated" (erc-toggle-channel-mode "m")
         :style toggle :selected (member "m" channel-modes)
         :active (and channel-members
                      (nth 1 (assoc (erc-current-nick) channel-members)))]
        ["Set a limit..." erc-set-channel-limit
         (and channel-members (nth 1 (assoc (erc-current-nick) channel-members)))]
        ["Set a key..." erc-set-channel-key
         (and channel-members (nth 1 (assoc (erc-current-nick) channel-members)))])
	"-"
  (list "Pals, fools and other keywords"
        ["Add pal..." erc-add-pal]
        ["Delete pal..." erc-delete-pal]
        ["Add fool..." erc-add-fool]
        ["Delete fool..." erc-delete-fool]
        ["Add keyword..." erc-add-keyword]
        ["Delete keyword..." erc-delete-keyword]
        ["Add dangerous host..." erc-add-dangerous-host]
        ["Delete dangerous host..." erc-delete-dangerous-host])
	"-"
	["Input action..." erc-input-action (erc-default-target)]
	(list "IRC services"
	      ["Identify to NickServ..." erc-nickserv-identify
         (functionp 'erc-nickserv-identify)])
	"-"
	["Track hidden channel buffers" erc-track-modified-channels-mode
	 :style toggle :selected (and (boundp 'erc-track-modified-channels-mode)
                                erc-track-modified-channels-mode)
   :active (boundp 'erc-track-modified-channels-mode)]
	"-"
	["Customize ERC" (customize-group 'erc) t]
	"-"
	["Show ERC version" erc-version t]
	)
  "ERC menu definition.")

(easy-menu-define erc-menu erc-mode-map "ERC menu" erc-menu-definition)
(easy-menu-add erc-menu erc-mode-map)

(provide 'erc-menu)

;;; erc-menu.el ends here
