;;; xlib-vidmode.el --- XF86VidMode extension support.

;; Copyright (C) 2004 by Free Software Foundation, Inc.

;; Author: Zajcev Evgeny <zevlg@yandex.ru>
;; Created: Fri Jan 16 18:39:44 MSK 2004
;; Keywords: xlib, xwem
;; X-CVS: $Id: xlib-vidmode.el,v 1.1 2004/03/22 17:36:25 lg Exp $

;; This file is part of XWEM.

;; XWEM is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; XWEM is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Synched up with: Not in FSF

;;; Commentary:

;; 

;;; Code:
(defconst X-XF86VidMode-major 2 "Major version of VidMode extension.")
(defconst X-XF86VidMode-minor 1 "Minor version of VidMode extension.")

(defconst X-XF86VidMode-op-QueryVersion	0)
(defconst X-XF86VidMode-op-GetModeLine 1 "Opcode to fetch current modeline from server.")
(defconst X-XF86VidMode-op-ModModeLine 2)
(defconst X-XF86VidMode-op-SwitchMode 3)
(defconst X-XF86VidMode-op-GetMonitor 4)
(defconst X-XF86VidMode-op-LockModeSwitch 5)
(defconst X-XF86VidMode-op-GetAllModeLines 6)
(defconst X-XF86VidMode-op-AddModeLine	7)
(defconst X-XF86VidMode-op-DeleteModeLine 8)
(defconst X-XF86VidMode-op-ValidateModeLine 9)
(defconst X-XF86VidMode-op-SwitchToMode	10)
(defconst X-XF86VidMode-op-GetViewPort	11)
(defconst X-XF86VidMode-op-SetViewPort	12)

;; new for version 2.x of this extension
(defconst X-XF86VidMode-op-GetDotClocks	13)
(defconst X-XF86VidMode-op-SetClientVersion 14)
(defconst X-XF86VidMode-op-SetGamma 15 "Opcode to set new gamma.")
(defconst X-XF86VidMode-op-GetGamma 16 "Opcode to fetch current gamma.")
(defconst X-XF86VidMode-op-GetGammaRamp	17)
(defconst X-XF86VidMode-op-SetGammaRamp	18)
(defconst X-XF86VidMode-op-GetGammaRampSize 19)


;;; Functions
(defun X-XF86VidModeQueryVersion (xdpy)
  "On display XDPY query for version of XF86VidMode extension."
  (X-Dpy-p xdpy 'X-XF86VidModeQueryVersion)

  (let* ((xin-ext (X-Dpy-get-extension xdpy "XFree86-VidModeExtension" 'X-XF86VidModeQueryVersion))
	 (ListOfFields
	  (list (vector 1 (nth 4 xin-ext)) ; opcode
		[1 X-XF86VidMode-op-QueryVersion]
		[2 1]))			; length
	 (msg (X-Create-message ListOfFields))
	 (ReceiveFields
	  (list [1 success]		;success field
		nil
		(list [1 nil]		;not used
		      [2 integerp]	;sequence number
		      [4 nil]		;length
		      [2 integerp]	;major version
		      [2 integerp]	;minor version
		      [20 nil]))))	;pad
    (X-Dpy-send-read xdpy msg ReceiveFields)))

(defun X-XF86VidModeGetModeline (xdpy &optional screen-num)
  "On display XDPY using XF86VidMode extension fetch current modeline."
  (X-Dpy-p xdpy 'X-XF86VidModeGetModeline)

  (let* ((xin-ext (X-Dpy-get-extension xdpy "XFree86-VidModeExtension" 'X-XF86VidModeGetModeline))
	 (ListOfFields
	  (list (vector 1 (nth 4 xin-ext)) ; opcode
		[1 X-XF86VidMode-op-GetModeLine]
		[2 2]			; length
		[2 (or screen-num 0)]	; screen
		[2 nil]))		; pad
	 (msg (X-Create-message ListOfFields))
	 (ReceiveFields
	  (list [1 success]		;success field
		nil
		(list [1 nil]		;not used
		      [2 integerp]	;sequence number
		      [4 nil]		;length
		      [4 integerp]	;dotclock
		      [2 integerp]	;hdisplay
		      [2 integerp]	;hsyncstart
		      [2 integerp]	;hsyncend
		      [2 integerp]	;htotal
		      [2 integerp]	;hskew
		      [2 integerp]	;vdisplay
		      [2 integerp]	;vsyncstart
		      [2 integerp]	;vsyncend
		      [2 integerp]	;vtotal
		      [2 nil]		; pad
		      [4 integerp]))))	; flags
    (X-Dpy-send-read xdpy msg ReceiveFields)))


(defun X-XF86VidModeGetGamma (xdpy &optional screen-num)
  "On display XDPY using XF86VidMode extension fetch current gamma."
  (X-Dpy-p xdpy 'X-XF86VidModeGetGamma)

  (let* ((xin-ext (X-Dpy-get-extension xdpy "XFree86-VidModeExtension" 'X-XF86VidModeGetGamma))
	 (ListOfFields
	  (list (vector 1 (nth 4 xin-ext)) ; opcode
		[1 X-XF86VidMode-op-GetGamma]
		[2 8]			; length
		[2 (or screen-num 0)]	; screen
		[2 nil]			; pad
		[24 nil]))		;pad
	 (msg (X-Create-message ListOfFields))
	 (ReceiveFields
	  (list [1 success]		;success field
		nil
		(list [1 nil]		;not used
		      [2 integerp]	;sequence number
		      [4 nil]		;length
		      [4 integerp]	;red gamma
		      [4 integerp]	;green gamma
		      [4 integerp]	;blue gamma
		      [12 nil]))))	;pad
    (X-Dpy-send-read xdpy msg ReceiveFields)))

(defun X-XF86VidModeSetGamma (xdpy r g b &optional screen-num)
  "On display XDPY using XF86VidMode extension fetch current gamma."
  (X-Dpy-p xdpy 'X-XF86VidModeSetGamma)

  (let* ((xin-ext (X-Dpy-get-extension xdpy "XFree86-VidModeExtension" 'X-XF86VidModeSetGamma))
	 (ListOfFields
	  (list (vector 1 (nth 4 xin-ext)) ; opcode
		[1 X-XF86VidMode-op-SetGamma]
		[2 8]			; length
		[2 (or screen-num 0)]	; screen
		[2 nil]			; pad
		[4 (* 10000 r)]		; red gamma
		[4 (* 10000 g)]		; green gamma
		[4 (* 10000 b)]		; blue gamma
		[12 nil]))		;pad
	 (msg (X-Create-message ListOfFields)))
    (X-Dpy-send xdpy msg)))

;; TODO: write other functions
  


(provide 'xlib-vidmode)

;;; xlib-vidmode.el ends here
