#! /bin/zsh -f

# Written by SL Baur <steve@xemacs.org>
# December, 1998
# This file is part of XEmacs and is used by the maintainers
#  for creating distributions

# CleanDist:  Fetch a brand new distribution tree
# Usage:  CleanDist MAJOR MINOR

setopt extendedglob
set -e # Exit at the first sign of trouble

if [ $# != 3 ]; then
	echo "Usage: $0: MAJOR MINOR RELOAD"
	exit 1
fi

MAJOR=$1
MINOR=$2
RELOAD=$3

export BUILDDIR=xemacs-${MAJOR}.${MINOR}

case ${MAJOR}.${MINOR} in
21.0) release= ;;
21.2) release=-rrelease-21-2 ;;
esac

# First remove the results of the previous build if they are still present
if [ -d ${BUILDDIR} ]; then
	if [ -f ${BUILDDIR}/Makefile ]; then
		(cd ${BUILDDIR}; make distclean)
	fi
	[ "$RELOAD" = t ] && cvs -Q release -d ${BUILDDIR}
fi

# Second checkout what will become the next version
[ "$RELOAD" = t ] && cvs checkout ${release} -d ${BUILDDIR} xemacs

exit 0
