/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.CallStack;
import bsh.Capabilities;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.NameSpace;
import bsh.Reflect;
import bsh.SimpleNode;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class This
implements Serializable,
Runnable {
    NameSpace namespace;
    transient Interpreter declaringInterpreter;
    transient CallStack callstack;

    static This getThis(NameSpace nameSpace, Interpreter interpreter) {
        try {
            if (Capabilities.canGenerateInterfaces()) {
                return (This)Reflect.constructObject("bsh.XThis", new Object[]{nameSpace, interpreter});
            }
            if (Capabilities.haveSwing()) {
                return (This)Reflect.constructObject("bsh.JThis", new Object[]{nameSpace, interpreter});
            }
            return new This(nameSpace, interpreter);
        }
        catch (Exception exception) {
            throw new InterpreterError("internal error 1 in This: " + exception);
        }
    }

    public Object getInterface(Class clazz) throws EvalError {
        if (clazz.isInstance(this)) {
            return this;
        }
        throw new EvalError("Dynamic proxy mechanism not available. Cannot construct interface type: " + clazz);
    }

    protected This(NameSpace nameSpace, Interpreter interpreter) {
        this.namespace = nameSpace;
        this.declaringInterpreter = interpreter;
        this.initCallStack(nameSpace);
    }

    public NameSpace getNameSpace() {
        return this.namespace;
    }

    public String toString() {
        return "'this' reference to Bsh object: " + this.namespace.name;
    }

    public void run() {
        try {
            this.invokeMethod("run", new Object[0]);
        }
        catch (EvalError evalError) {
            this.declaringInterpreter.error("Exception in runnable:" + evalError);
        }
    }

    public Object invokeMethod(String string, Object[] objectArray) throws EvalError {
        return this.invokeMethod(string, objectArray, this.declaringInterpreter, null, null);
    }

    public Object invokeMethod(String string, Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode) throws EvalError {
        return this.namespace.invokeMethod(string, objectArray, interpreter, callStack, simpleNode);
    }

    public static void bind(This this_, NameSpace nameSpace, Interpreter interpreter) {
        this_.namespace.setParent(nameSpace);
        this_.declaringInterpreter = interpreter;
        this_.initCallStack(nameSpace);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        NameSpace nameSpace = this.namespace.getParent();
        this.namespace.prune();
        objectOutputStream.defaultWriteObject();
        this.namespace.setParent(nameSpace);
    }

    private final void initCallStack(NameSpace nameSpace) {
        this.callstack = new CallStack();
        this.callstack.push(nameSpace);
    }
}

