/*
 * Decompiled with CFR 0.152.
 */
package jde.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DynamicClassLoader
extends ClassLoader {
    public static final String CLASS_PATH = System.getProperty("java.class.path");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final char PACKAGE_SEPARATOR = '.';
    public static final String CLASS_FILE_TYPE = "class";

    public Class loadClass(String argClassName) throws ClassNotFoundException {
        byte[] classBytes = null;
        if (argClassName.startsWith("java.") || argClassName.startsWith("javax.")) {
            return Class.forName(argClassName);
        }
        String className = argClassName.replace('.', FILE_SEPARATOR.charAt(0));
        className = className + ".class";
        StringTokenizer st = new StringTokenizer(CLASS_PATH, PATH_SEPARATOR);
        while (st.hasMoreTokens()) {
            File file = new File(st.nextToken());
            try {
                ZipFile zf;
                if (!(file.isDirectory() ? (classBytes = this.loadFile(file = new File(file, className))) != null : (classBytes = this.loadFile(zf = new ZipFile(file), className)) != null)) continue;
                break;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (classBytes != null) {
            Class<?> c;
            try {
                c = this.defineClass(argClassName, classBytes, 0, classBytes.length);
            }
            catch (SecurityException e) {
                c = Class.forName(argClassName);
            }
            catch (ClassFormatError e) {
                c = Class.forName(argClassName);
            }
            catch (NoClassDefFoundError e) {
                c = Class.forName(argClassName);
            }
            return c;
        }
        try {
            return Class.forName(argClassName);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException(argClassName);
        }
    }

    /*
     * Loose catch block
     */
    private byte[] loadFile(File argFile) {
        byte[] b;
        block11: {
            b = null;
            FileInputStream in = null;
            if (argFile.exists()) {
                in = new FileInputStream(argFile);
                b = new byte[(int)argFile.length()];
                ((InputStream)in).read(b);
                Object var7_4 = null;
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e2) {}
                break block11;
                {
                    catch (FileNotFoundException e) {
                        b = null;
                        Object var7_5 = null;
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e2) {}
                        break block11;
                    }
                    catch (IOException e) {
                        b = null;
                        Object var7_6 = null;
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return b;
    }

    /*
     * Loose catch block
     */
    private byte[] loadFile(ZipFile argFile, String argClassName) {
        byte[] b;
        block9: {
            block8: {
                argClassName = argClassName.replace(FILE_SEPARATOR.charAt(0), '/');
                b = null;
                ZipEntry ze = argFile.getEntry(argClassName);
                if (ze == null) break block8;
                InputStream in = argFile.getInputStream(ze);
                b = new byte[(int)ze.getSize()];
                in.read(b);
            }
            Object var8_6 = null;
            try {
                argFile.close();
            }
            catch (IOException e2) {}
            break block9;
            {
                catch (IOException e) {
                    b = null;
                    Object var8_7 = null;
                    try {
                        argFile.close();
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    argFile.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return b;
    }
}

