;;; ucs-cyril.el --- UCS table of Cyrillic

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, charset, MULE, Cyrillic

;; This file is part of XEmacs-UCS

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Code:

(require 'ucs-util)

(ucs-set-char #x0401 ?$(C,'(B) ; KS0-C-2C27
(ucs-set-char #x0401 ?$(@''(B) ; J78-@-2727
(ucs-set-char #x0401 ?$(A''(B) ; GB0-A-2727
(ucs-set-char #x0401 ?$(B''(B) ; J83-B-2727
(ucs-set-char #x0401 ?-L) ; CYRILLIC CAPITAL LETTER IO-A

(ucs-set-char #x0402 ?$(D'B(B) ; J90-D-2742
(ucs-set-char #x0402 ?-L) ; CYRILLIC CAPITAL LETTER DJE-A

(ucs-set-char #x0403 ?$(D'C(B) ; J90-D-2743
(ucs-set-char #x0403 ?-L) ; CYRILLIC CAPITAL LETTER GJE-A

(ucs-set-char #x0404 ?$(D'D(B) ; J90-D-2744
(ucs-set-char #x0404 ?-L) ; CYRILLIC CAPITAL LETTER UKRAINIAN IE-A

(ucs-set-char #x0405 ?$(D'E(B) ; J90-D-2745
(ucs-set-char #x0405 ?-L) ; CYRILLIC CAPITAL LETTER DZE-A

(ucs-set-char #x0406 ?$(D'F(B) ; J90-D-2746
(ucs-set-char #x0406 ?-L) ; CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I-A

(ucs-set-char #x0407 ?$(D'G(B) ; J90-D-2747
(ucs-set-char #x0407 ?-L) ; CYRILLIC CAPITAL LETTER YI-A

(ucs-set-char #x0408 ?$(D'H(B) ; J90-D-2748
(ucs-set-char #x0408 ?-L) ; CYRILLIC CAPITAL LETTER JE-A

(ucs-set-char #x0409 ?$(D'I(B) ; J90-D-2749
(ucs-set-char #x0409 ?-L) ; CYRILLIC CAPITAL LETTER LJE-A

(ucs-set-char #x040A ?$(D'J(B) ; J90-D-274A
(ucs-set-char #x040A ?-L) ; CYRILLIC CAPITAL LETTER NJE-A

(ucs-set-char #x040B ?$(D'K(B) ; J90-D-274B
(ucs-set-char #x040B ?-L) ; CYRILLIC CAPITAL LETTER TSHE-A

(ucs-set-char #x040C ?$(D'L(B) ; J90-D-274C
(ucs-set-char #x040C ?-L) ; CYRILLIC CAPITAL LETTER KJE-A

(ucs-set-char #x040E ?$(D'M(B) ; J90-D-274D
(ucs-set-char #x040E ?-L) ; CYRILLIC CAPITAL LETTER SHORT U-A

(ucs-set-char #x040F ?$(D'N(B) ; J90-D-274E
(ucs-set-char #x040F ?-L) ; CYRILLIC CAPITAL LETTER DZHE-A

(ucs-set-char #x0410 ?$(C,!(B) ; KS0-C-2C21
(ucs-set-char #x0410 ?$(@'!(B) ; J78-@-2721
(ucs-set-char #x0410 ?$(A'!(B) ; GB0-A-2721
(ucs-set-char #x0410 ?$(B'!(B) ; J83-B-2721
(ucs-set-char #x0410 ?-L) ; CYRILLIC CAPITAL LETTER A-A

(ucs-set-char #x0411 ?$(C,"(B) ; KS0-C-2C22
(ucs-set-char #x0411 ?$(@'"(B) ; J78-@-2722
(ucs-set-char #x0411 ?$(A'"(B) ; GB0-A-2722
(ucs-set-char #x0411 ?$(B'"(B) ; J83-B-2722
(ucs-set-char #x0411 ?-L) ; CYRILLIC CAPITAL LETTER BE-A

(ucs-set-char #x0412 ?$(C,#(B) ; KS0-C-2C23
(ucs-set-char #x0412 ?$(@'#(B) ; J78-@-2723
(ucs-set-char #x0412 ?$(A'#(B) ; GB0-A-2723
(ucs-set-char #x0412 ?$(B'#(B) ; J83-B-2723
(ucs-set-char #x0412 ?-L) ; CYRILLIC CAPITAL LETTER VE-A

(ucs-set-char #x0413 ?$(C,$(B) ; KS0-C-2C24
(ucs-set-char #x0413 ?$(@'$(B) ; J78-@-2724
(ucs-set-char #x0413 ?$(A'$(B) ; GB0-A-2724
(ucs-set-char #x0413 ?$(B'$(B) ; J83-B-2724
(ucs-set-char #x0413 ?-L) ; CYRILLIC CAPITAL LETTER GHE-A

(ucs-set-char #x0414 ?$(C,%(B) ; KS0-C-2C25
(ucs-set-char #x0414 ?$(@'%(B) ; J78-@-2725
(ucs-set-char #x0414 ?$(A'%(B) ; GB0-A-2725
(ucs-set-char #x0414 ?$(B'%(B) ; J83-B-2725
(ucs-set-char #x0414 ?-L) ; CYRILLIC CAPITAL LETTER DE-A

(ucs-set-char #x0415 ?$(C,&(B) ; KS0-C-2C26
(ucs-set-char #x0415 ?$(@'&(B) ; J78-@-2726
(ucs-set-char #x0415 ?$(A'&(B) ; GB0-A-2726
(ucs-set-char #x0415 ?$(B'&(B) ; J83-B-2726
(ucs-set-char #x0415 ?-L) ; CYRILLIC CAPITAL LETTER IE-A

(ucs-set-char #x0416 ?$(C,((B) ; KS0-C-2C28
(ucs-set-char #x0416 ?$(@'((B) ; J78-@-2728
(ucs-set-char #x0416 ?$(A'((B) ; GB0-A-2728
(ucs-set-char #x0416 ?$(B'((B) ; J83-B-2728
(ucs-set-char #x0416 ?-L) ; CYRILLIC CAPITAL LETTER ZHE-A

(ucs-set-char #x0417 ?$(C,)(B) ; KS0-C-2C29
(ucs-set-char #x0417 ?$(@')(B) ; J78-@-2729
(ucs-set-char #x0417 ?$(A')(B) ; GB0-A-2729
(ucs-set-char #x0417 ?$(B')(B) ; J83-B-2729
(ucs-set-char #x0417 ?-L) ; CYRILLIC CAPITAL LETTER ZE-A

(ucs-set-char #x0418 ?$(C,*(B) ; KS0-C-2C2A
(ucs-set-char #x0418 ?$(@'*(B) ; J78-@-272A
(ucs-set-char #x0418 ?$(A'*(B) ; GB0-A-272A
(ucs-set-char #x0418 ?$(B'*(B) ; J83-B-272A
(ucs-set-char #x0418 ?-L) ; CYRILLIC CAPITAL LETTER I-A

(ucs-set-char #x0419 ?$(C,+(B) ; KS0-C-2C2B
(ucs-set-char #x0419 ?$(@'+(B) ; J78-@-272B
(ucs-set-char #x0419 ?$(A'+(B) ; GB0-A-272B
(ucs-set-char #x0419 ?$(B'+(B) ; J83-B-272B
(ucs-set-char #x0419 ?-L) ; CYRILLIC CAPITAL LETTER SHORT I-A

(ucs-set-char #x041A ?$(C,,(B) ; KS0-C-2C2C
(ucs-set-char #x041A ?$(@',(B) ; J78-@-272C
(ucs-set-char #x041A ?$(A',(B) ; GB0-A-272C
(ucs-set-char #x041A ?$(B',(B) ; J83-B-272C
(ucs-set-char #x041A ?-L) ; CYRILLIC CAPITAL LETTER KA-A

(ucs-set-char #x041B ?$(C,-(B) ; KS0-C-2C2D
(ucs-set-char #x041B ?$(@'-(B) ; J78-@-272D
(ucs-set-char #x041B ?$(A'-(B) ; GB0-A-272D
(ucs-set-char #x041B ?$(B'-(B) ; J83-B-272D
(ucs-set-char #x041B ?-L) ; CYRILLIC CAPITAL LETTER EL-A

(ucs-set-char #x041C ?$(C,.(B) ; KS0-C-2C2E
(ucs-set-char #x041C ?$(@'.(B) ; J78-@-272E
(ucs-set-char #x041C ?$(A'.(B) ; GB0-A-272E
(ucs-set-char #x041C ?$(B'.(B) ; J83-B-272E
(ucs-set-char #x041C ?-L) ; CYRILLIC CAPITAL LETTER EM-A

(ucs-set-char #x041D ?$(C,/(B) ; KS0-C-2C2F
(ucs-set-char #x041D ?$(@'/(B) ; J78-@-272F
(ucs-set-char #x041D ?$(A'/(B) ; GB0-A-272F
(ucs-set-char #x041D ?$(B'/(B) ; J83-B-272F
(ucs-set-char #x041D ?-L) ; CYRILLIC CAPITAL LETTER EN-A

(ucs-set-char #x041E ?$(C,0(B) ; KS0-C-2C30
(ucs-set-char #x041E ?$(@'0(B) ; J78-@-2730
(ucs-set-char #x041E ?$(A'0(B) ; GB0-A-2730
(ucs-set-char #x041E ?$(B'0(B) ; J83-B-2730
(ucs-set-char #x041E ?-L) ; CYRILLIC CAPITAL LETTER O-A

(ucs-set-char #x041F ?$(C,1(B) ; KS0-C-2C31
(ucs-set-char #x041F ?$(@'1(B) ; J78-@-2731
(ucs-set-char #x041F ?$(A'1(B) ; GB0-A-2731
(ucs-set-char #x041F ?$(B'1(B) ; J83-B-2731
(ucs-set-char #x041F ?-L) ; CYRILLIC CAPITAL LETTER PE-A

(ucs-set-char #x0420 ?$(C,2(B) ; KS0-C-2C32
(ucs-set-char #x0420 ?$(@'2(B) ; J78-@-2732
(ucs-set-char #x0420 ?$(A'2(B) ; GB0-A-2732
(ucs-set-char #x0420 ?$(B'2(B) ; J83-B-2732
(ucs-set-char #x0420 ?-L) ; CYRILLIC CAPITAL LETTER ER-A

(ucs-set-char #x0421 ?$(C,3(B) ; KS0-C-2C33
(ucs-set-char #x0421 ?$(@'3(B) ; J78-@-2733
(ucs-set-char #x0421 ?$(A'3(B) ; GB0-A-2733
(ucs-set-char #x0421 ?$(B'3(B) ; J83-B-2733
(ucs-set-char #x0421 ?-L) ; CYRILLIC CAPITAL LETTER ES-A

(ucs-set-char #x0422 ?$(C,4(B) ; KS0-C-2C34
(ucs-set-char #x0422 ?$(@'4(B) ; J78-@-2734
(ucs-set-char #x0422 ?$(A'4(B) ; GB0-A-2734
(ucs-set-char #x0422 ?$(B'4(B) ; J83-B-2734
(ucs-set-char #x0422 ?-L) ; CYRILLIC CAPITAL LETTER TE-A

(ucs-set-char #x0423 ?$(C,5(B) ; KS0-C-2C35
(ucs-set-char #x0423 ?$(@'5(B) ; J78-@-2735
(ucs-set-char #x0423 ?$(A'5(B) ; GB0-A-2735
(ucs-set-char #x0423 ?$(B'5(B) ; J83-B-2735
(ucs-set-char #x0423 ?-L) ; CYRILLIC CAPITAL LETTER U-A

(ucs-set-char #x0424 ?$(C,6(B) ; KS0-C-2C36
(ucs-set-char #x0424 ?$(@'6(B) ; J78-@-2736
(ucs-set-char #x0424 ?$(A'6(B) ; GB0-A-2736
(ucs-set-char #x0424 ?$(B'6(B) ; J83-B-2736
(ucs-set-char #x0424 ?-L) ; CYRILLIC CAPITAL LETTER EF-A

(ucs-set-char #x0425 ?$(C,7(B) ; KS0-C-2C37
(ucs-set-char #x0425 ?$(@'7(B) ; J78-@-2737
(ucs-set-char #x0425 ?$(A'7(B) ; GB0-A-2737
(ucs-set-char #x0425 ?$(B'7(B) ; J83-B-2737
(ucs-set-char #x0425 ?-L) ; CYRILLIC CAPITAL LETTER HA-A

(ucs-set-char #x0426 ?$(C,8(B) ; KS0-C-2C38
(ucs-set-char #x0426 ?$(@'8(B) ; J78-@-2738
(ucs-set-char #x0426 ?$(A'8(B) ; GB0-A-2738
(ucs-set-char #x0426 ?$(B'8(B) ; J83-B-2738
(ucs-set-char #x0426 ?-L) ; CYRILLIC CAPITAL LETTER TSE-A

(ucs-set-char #x0427 ?$(C,9(B) ; KS0-C-2C39
(ucs-set-char #x0427 ?$(@'9(B) ; J78-@-2739
(ucs-set-char #x0427 ?$(A'9(B) ; GB0-A-2739
(ucs-set-char #x0427 ?$(B'9(B) ; J83-B-2739
(ucs-set-char #x0427 ?-L) ; CYRILLIC CAPITAL LETTER CHE-A

(ucs-set-char #x0428 ?$(C,:(B) ; KS0-C-2C3A
(ucs-set-char #x0428 ?$(@':(B) ; J78-@-273A
(ucs-set-char #x0428 ?$(A':(B) ; GB0-A-273A
(ucs-set-char #x0428 ?$(B':(B) ; J83-B-273A
(ucs-set-char #x0428 ?-L) ; CYRILLIC CAPITAL LETTER SHA-A

(ucs-set-char #x0429 ?$(C,;(B) ; KS0-C-2C3B
(ucs-set-char #x0429 ?$(@';(B) ; J78-@-273B
(ucs-set-char #x0429 ?$(A';(B) ; GB0-A-273B
(ucs-set-char #x0429 ?$(B';(B) ; J83-B-273B
(ucs-set-char #x0429 ?-L) ; CYRILLIC CAPITAL LETTER SHCHA-A

(ucs-set-char #x042A ?$(C,<(B) ; KS0-C-2C3C
(ucs-set-char #x042A ?$(@'<(B) ; J78-@-273C
(ucs-set-char #x042A ?$(A'<(B) ; GB0-A-273C
(ucs-set-char #x042A ?$(B'<(B) ; J83-B-273C
(ucs-set-char #x042A ?-L) ; CYRILLIC CAPITAL LETTER HARD SIGN-A

(ucs-set-char #x042B ?$(C,=(B) ; KS0-C-2C3D
(ucs-set-char #x042B ?$(@'=(B) ; J78-@-273D
(ucs-set-char #x042B ?$(A'=(B) ; GB0-A-273D
(ucs-set-char #x042B ?$(B'=(B) ; J83-B-273D
(ucs-set-char #x042B ?-L) ; CYRILLIC CAPITAL LETTER YERU-A

(ucs-set-char #x042C ?$(C,>(B) ; KS0-C-2C3E
(ucs-set-char #x042C ?$(@'>(B) ; J78-@-273E
(ucs-set-char #x042C ?$(A'>(B) ; GB0-A-273E
(ucs-set-char #x042C ?$(B'>(B) ; J83-B-273E
(ucs-set-char #x042C ?-L) ; CYRILLIC CAPITAL LETTER SOFT SIGN-A

(ucs-set-char #x042D ?$(C,?(B) ; KS0-C-2C3F
(ucs-set-char #x042D ?$(@'?(B) ; J78-@-273F
(ucs-set-char #x042D ?$(A'?(B) ; GB0-A-273F
(ucs-set-char #x042D ?$(B'?(B) ; J83-B-273F
(ucs-set-char #x042D ?-L) ; CYRILLIC CAPITAL LETTER E-A

(ucs-set-char #x042E ?$(C,@(B) ; KS0-C-2C40
(ucs-set-char #x042E ?$(@'@(B) ; J78-@-2740
(ucs-set-char #x042E ?$(A'@(B) ; GB0-A-2740
(ucs-set-char #x042E ?$(B'@(B) ; J83-B-2740
(ucs-set-char #x042E ?-L) ; CYRILLIC CAPITAL LETTER YU-A

(ucs-set-char #x042F ?$(C,A(B) ; KS0-C-2C41
(ucs-set-char #x042F ?$(@'A(B) ; J78-@-2741
(ucs-set-char #x042F ?$(A'A(B) ; GB0-A-2741
(ucs-set-char #x042F ?$(B'A(B) ; J83-B-2741
(ucs-set-char #x042F ?-L) ; CYRILLIC CAPITAL LETTER YA-A

(ucs-set-char #x0430 ?$(C,Q(B) ; KS0-C-2C51
(ucs-set-char #x0430 ?$(@'Q(B) ; J78-@-2751
(ucs-set-char #x0430 ?$(A'Q(B) ; GB0-A-2751
(ucs-set-char #x0430 ?$(B'Q(B) ; J83-B-2751
(ucs-set-char #x0430 ?-L) ; CYRILLIC SMALL LETTER A-A

(ucs-set-char #x0431 ?$(C,R(B) ; KS0-C-2C52
(ucs-set-char #x0431 ?$(@'R(B) ; J78-@-2752
(ucs-set-char #x0431 ?$(A'R(B) ; GB0-A-2752
(ucs-set-char #x0431 ?$(B'R(B) ; J83-B-2752
(ucs-set-char #x0431 ?-L) ; CYRILLIC SMALL LETTER BE-A

(ucs-set-char #x0432 ?$(C,S(B) ; KS0-C-2C53
(ucs-set-char #x0432 ?$(@'S(B) ; J78-@-2753
(ucs-set-char #x0432 ?$(A'S(B) ; GB0-A-2753
(ucs-set-char #x0432 ?$(B'S(B) ; J83-B-2753
(ucs-set-char #x0432 ?-L) ; CYRILLIC SMALL LETTER VE-A

(ucs-set-char #x0433 ?$(C,T(B) ; KS0-C-2C54
(ucs-set-char #x0433 ?$(@'T(B) ; J78-@-2754
(ucs-set-char #x0433 ?$(A'T(B) ; GB0-A-2754
(ucs-set-char #x0433 ?$(B'T(B) ; J83-B-2754
(ucs-set-char #x0433 ?-L) ; CYRILLIC SMALL LETTER GHE-A

(ucs-set-char #x0434 ?$(C,U(B) ; KS0-C-2C55
(ucs-set-char #x0434 ?$(@'U(B) ; J78-@-2755
(ucs-set-char #x0434 ?$(A'U(B) ; GB0-A-2755
(ucs-set-char #x0434 ?$(B'U(B) ; J83-B-2755
(ucs-set-char #x0434 ?-L) ; CYRILLIC SMALL LETTER DE-A

(ucs-set-char #x0435 ?$(C,V(B) ; KS0-C-2C56
(ucs-set-char #x0435 ?$(@'V(B) ; J78-@-2756
(ucs-set-char #x0435 ?$(A'V(B) ; GB0-A-2756
(ucs-set-char #x0435 ?$(B'V(B) ; J83-B-2756
(ucs-set-char #x0435 ?-L) ; CYRILLIC SMALL LETTER IE-A

(ucs-set-char #x0436 ?$(C,X(B) ; KS0-C-2C58
(ucs-set-char #x0436 ?$(@'X(B) ; J78-@-2758
(ucs-set-char #x0436 ?$(A'X(B) ; GB0-A-2758
(ucs-set-char #x0436 ?$(B'X(B) ; J83-B-2758
(ucs-set-char #x0436 ?-L) ; CYRILLIC SMALL LETTER ZHE-A

(ucs-set-char #x0437 ?$(C,Y(B) ; KS0-C-2C59
(ucs-set-char #x0437 ?$(@'Y(B) ; J78-@-2759
(ucs-set-char #x0437 ?$(A'Y(B) ; GB0-A-2759
(ucs-set-char #x0437 ?$(B'Y(B) ; J83-B-2759
(ucs-set-char #x0437 ?-L) ; CYRILLIC SMALL LETTER ZE-A

(ucs-set-char #x0438 ?$(C,Z(B) ; KS0-C-2C5A
(ucs-set-char #x0438 ?$(@'Z(B) ; J78-@-275A
(ucs-set-char #x0438 ?$(A'Z(B) ; GB0-A-275A
(ucs-set-char #x0438 ?$(B'Z(B) ; J83-B-275A
(ucs-set-char #x0438 ?-L) ; CYRILLIC SMALL LETTER I-A

(ucs-set-char #x0439 ?$(C,[(B) ; KS0-C-2C5B
(ucs-set-char #x0439 ?$(@'[(B) ; J78-@-275B
(ucs-set-char #x0439 ?$(A'[(B) ; GB0-A-275B
(ucs-set-char #x0439 ?$(B'[(B) ; J83-B-275B
(ucs-set-char #x0439 ?-L) ; CYRILLIC SMALL LETTER SHORT I-A

(ucs-set-char #x043A ?$(C,\(B) ; KS0-C-2C5C
(ucs-set-char #x043A ?$(@'\(B) ; J78-@-275C
(ucs-set-char #x043A ?$(A'\(B) ; GB0-A-275C
(ucs-set-char #x043A ?$(B'\(B) ; J83-B-275C
(ucs-set-char #x043A ?-L) ; CYRILLIC SMALL LETTER KA-A

(ucs-set-char #x043B ?$(C,](B) ; KS0-C-2C5D
(ucs-set-char #x043B ?$(@'](B) ; J78-@-275D
(ucs-set-char #x043B ?$(A'](B) ; GB0-A-275D
(ucs-set-char #x043B ?$(B'](B) ; J83-B-275D
(ucs-set-char #x043B ?-L) ; CYRILLIC SMALL LETTER EL-A

(ucs-set-char #x043C ?$(C,^(B) ; KS0-C-2C5E
(ucs-set-char #x043C ?$(@'^(B) ; J78-@-275E
(ucs-set-char #x043C ?$(A'^(B) ; GB0-A-275E
(ucs-set-char #x043C ?$(B'^(B) ; J83-B-275E
(ucs-set-char #x043C ?-L) ; CYRILLIC SMALL LETTER EM-A

(ucs-set-char #x043D ?$(C,_(B) ; KS0-C-2C5F
(ucs-set-char #x043D ?$(@'_(B) ; J78-@-275F
(ucs-set-char #x043D ?$(A'_(B) ; GB0-A-275F
(ucs-set-char #x043D ?$(B'_(B) ; J83-B-275F
(ucs-set-char #x043D ?-L) ; CYRILLIC SMALL LETTER EN-A

(ucs-set-char #x043E ?$(C,`(B) ; KS0-C-2C60
(ucs-set-char #x043E ?$(@'`(B) ; J78-@-2760
(ucs-set-char #x043E ?$(A'`(B) ; GB0-A-2760
(ucs-set-char #x043E ?$(B'`(B) ; J83-B-2760
(ucs-set-char #x043E ?-L) ; CYRILLIC SMALL LETTER O-A

(ucs-set-char #x043F ?$(C,a(B) ; KS0-C-2C61
(ucs-set-char #x043F ?$(@'a(B) ; J78-@-2761
(ucs-set-char #x043F ?$(A'a(B) ; GB0-A-2761
(ucs-set-char #x043F ?$(B'a(B) ; J83-B-2761
(ucs-set-char #x043F ?-L) ; CYRILLIC SMALL LETTER PE-A

(ucs-set-char #x0440 ?$(C,b(B) ; KS0-C-2C62
(ucs-set-char #x0440 ?$(@'b(B) ; J78-@-2762
(ucs-set-char #x0440 ?$(A'b(B) ; GB0-A-2762
(ucs-set-char #x0440 ?$(B'b(B) ; J83-B-2762
(ucs-set-char #x0440 ?-L) ; CYRILLIC SMALL LETTER ER-A

(ucs-set-char #x0441 ?$(C,c(B) ; KS0-C-2C63
(ucs-set-char #x0441 ?$(@'c(B) ; J78-@-2763
(ucs-set-char #x0441 ?$(A'c(B) ; GB0-A-2763
(ucs-set-char #x0441 ?$(B'c(B) ; J83-B-2763
(ucs-set-char #x0441 ?-L) ; CYRILLIC SMALL LETTER ES-A

(ucs-set-char #x0442 ?$(C,d(B) ; KS0-C-2C64
(ucs-set-char #x0442 ?$(@'d(B) ; J78-@-2764
(ucs-set-char #x0442 ?$(A'd(B) ; GB0-A-2764
(ucs-set-char #x0442 ?$(B'd(B) ; J83-B-2764
(ucs-set-char #x0442 ?-L) ; CYRILLIC SMALL LETTER TE-A

(ucs-set-char #x0443 ?$(C,e(B) ; KS0-C-2C65
(ucs-set-char #x0443 ?$(@'e(B) ; J78-@-2765
(ucs-set-char #x0443 ?$(A'e(B) ; GB0-A-2765
(ucs-set-char #x0443 ?$(B'e(B) ; J83-B-2765
(ucs-set-char #x0443 ?-L) ; CYRILLIC SMALL LETTER U-A

(ucs-set-char #x0444 ?$(C,f(B) ; KS0-C-2C66
(ucs-set-char #x0444 ?$(@'f(B) ; J78-@-2766
(ucs-set-char #x0444 ?$(A'f(B) ; GB0-A-2766
(ucs-set-char #x0444 ?$(B'f(B) ; J83-B-2766
(ucs-set-char #x0444 ?-L) ; CYRILLIC SMALL LETTER EF-A

(ucs-set-char #x0445 ?$(C,g(B) ; KS0-C-2C67
(ucs-set-char #x0445 ?$(@'g(B) ; J78-@-2767
(ucs-set-char #x0445 ?$(A'g(B) ; GB0-A-2767
(ucs-set-char #x0445 ?$(B'g(B) ; J83-B-2767
(ucs-set-char #x0445 ?-L) ; CYRILLIC SMALL LETTER HA-A

(ucs-set-char #x0446 ?$(C,h(B) ; KS0-C-2C68
(ucs-set-char #x0446 ?$(@'h(B) ; J78-@-2768
(ucs-set-char #x0446 ?$(A'h(B) ; GB0-A-2768
(ucs-set-char #x0446 ?$(B'h(B) ; J83-B-2768
(ucs-set-char #x0446 ?-L) ; CYRILLIC SMALL LETTER TSE-A

(ucs-set-char #x0447 ?$(C,i(B) ; KS0-C-2C69
(ucs-set-char #x0447 ?$(@'i(B) ; J78-@-2769
(ucs-set-char #x0447 ?$(A'i(B) ; GB0-A-2769
(ucs-set-char #x0447 ?$(B'i(B) ; J83-B-2769
(ucs-set-char #x0447 ?-L) ; CYRILLIC SMALL LETTER CHE-A

(ucs-set-char #x0448 ?$(C,j(B) ; KS0-C-2C6A
(ucs-set-char #x0448 ?$(@'j(B) ; J78-@-276A
(ucs-set-char #x0448 ?$(A'j(B) ; GB0-A-276A
(ucs-set-char #x0448 ?$(B'j(B) ; J83-B-276A
(ucs-set-char #x0448 ?-L) ; CYRILLIC SMALL LETTER SHA-A

(ucs-set-char #x0449 ?$(C,k(B) ; KS0-C-2C6B
(ucs-set-char #x0449 ?$(@'k(B) ; J78-@-276B
(ucs-set-char #x0449 ?$(A'k(B) ; GB0-A-276B
(ucs-set-char #x0449 ?$(B'k(B) ; J83-B-276B
(ucs-set-char #x0449 ?-L) ; CYRILLIC SMALL LETTER SHCHA-A

(ucs-set-char #x044A ?$(C,l(B) ; KS0-C-2C6C
(ucs-set-char #x044A ?$(@'l(B) ; J78-@-276C
(ucs-set-char #x044A ?$(A'l(B) ; GB0-A-276C
(ucs-set-char #x044A ?$(B'l(B) ; J83-B-276C
(ucs-set-char #x044A ?-L) ; CYRILLIC SMALL LETTER HARD SIGN-A

(ucs-set-char #x044B ?$(C,m(B) ; KS0-C-2C6D
(ucs-set-char #x044B ?$(@'m(B) ; J78-@-276D
(ucs-set-char #x044B ?$(A'm(B) ; GB0-A-276D
(ucs-set-char #x044B ?$(B'm(B) ; J83-B-276D
(ucs-set-char #x044B ?-L) ; CYRILLIC SMALL LETTER YERU-A

(ucs-set-char #x044C ?$(C,n(B) ; KS0-C-2C6E
(ucs-set-char #x044C ?$(@'n(B) ; J78-@-276E
(ucs-set-char #x044C ?$(A'n(B) ; GB0-A-276E
(ucs-set-char #x044C ?$(B'n(B) ; J83-B-276E
(ucs-set-char #x044C ?-L) ; CYRILLIC SMALL LETTER SOFT SIGN-A

(ucs-set-char #x044D ?$(C,o(B) ; KS0-C-2C6F
(ucs-set-char #x044D ?$(@'o(B) ; J78-@-276F
(ucs-set-char #x044D ?$(A'o(B) ; GB0-A-276F
(ucs-set-char #x044D ?$(B'o(B) ; J83-B-276F
(ucs-set-char #x044D ?-L) ; CYRILLIC SMALL LETTER E-A

(ucs-set-char #x044E ?$(C,p(B) ; KS0-C-2C70
(ucs-set-char #x044E ?$(@'p(B) ; J78-@-2770
(ucs-set-char #x044E ?$(A'p(B) ; GB0-A-2770
(ucs-set-char #x044E ?$(B'p(B) ; J83-B-2770
(ucs-set-char #x044E ?-L) ; CYRILLIC SMALL LETTER YU-A

(ucs-set-char #x044F ?$(C,q(B) ; KS0-C-2C71
(ucs-set-char #x044F ?$(@'q(B) ; J78-@-2771
(ucs-set-char #x044F ?$(A'q(B) ; GB0-A-2771
(ucs-set-char #x044F ?$(B'q(B) ; J83-B-2771
(ucs-set-char #x044F ?-L) ; CYRILLIC SMALL LETTER YA-A

(ucs-set-char #x0451 ?$(C,W(B) ; KS0-C-2C57
(ucs-set-char #x0451 ?$(@'W(B) ; J78-@-2757
(ucs-set-char #x0451 ?$(A'W(B) ; GB0-A-2757
(ucs-set-char #x0451 ?$(B'W(B) ; J83-B-2757
(ucs-set-char #x0451 ?-L) ; CYRILLIC SMALL LETTER IO-A

(ucs-set-char #x0452 ?$(D'r(B) ; J90-D-2772
(ucs-set-char #x0452 ?-L) ; CYRILLIC SMALL LETTER DJE-A

(ucs-set-char #x0453 ?$(D's(B) ; J90-D-2773
(ucs-set-char #x0453 ?-L) ; CYRILLIC SMALL LETTER GJE-A

(ucs-set-char #x0454 ?$(D't(B) ; J90-D-2774
(ucs-set-char #x0454 ?-L) ; CYRILLIC SMALL LETTER UKRAINIAN IE-A

(ucs-set-char #x0455 ?$(D'u(B) ; J90-D-2775
(ucs-set-char #x0455 ?-L) ; CYRILLIC SMALL LETTER DZE-A

(ucs-set-char #x0456 ?$(D'v(B) ; J90-D-2776
(ucs-set-char #x0456 ?-L) ; CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I-A

(ucs-set-char #x0457 ?$(D'w(B) ; J90-D-2777
(ucs-set-char #x0457 ?-L) ; CYRILLIC SMALL LETTER YI-A

(ucs-set-char #x0458 ?$(D'x(B) ; J90-D-2778
(ucs-set-char #x0458 ?-L) ; CYRILLIC SMALL LETTER JE-A

(ucs-set-char #x0459 ?$(D'y(B) ; J90-D-2779
(ucs-set-char #x0459 ?-L) ; CYRILLIC SMALL LETTER LJE-A

(ucs-set-char #x045A ?$(D'z(B) ; J90-D-277A
(ucs-set-char #x045A ?-L) ; CYRILLIC SMALL LETTER NJE-A

(ucs-set-char #x045B ?$(D'{(B) ; J90-D-277B
(ucs-set-char #x045B ?-L) ; CYRILLIC SMALL LETTER TSHE-A

(ucs-set-char #x045C ?$(D'|(B) ; J90-D-277C
(ucs-set-char #x045C ?-L) ; CYRILLIC SMALL LETTER KJE-A

(ucs-set-char #x045E ?$(D'}(B) ; J90-D-277D
(ucs-set-char #x045E ?-L) ; CYRILLIC SMALL LETTER SHORT U-A

(ucs-set-char #x045F ?$(D'~(B) ; J90-D-277E
(ucs-set-char #x045F ?-L) ; CYRILLIC SMALL LETTER DZHE-A

;;; ucs-cyril.el ends here
