(require 'quail)
;; # HANYU input table for cxterm
;; AUTHOR:      Chue Chi To ($(07C,6Fq(B)
;; DATE:        28 NOV 1994
;; ENCODE:	BIG5
;; MULTICHOICE:	YES
;; PROMPT:	$(0&d'GTT&,!J6AQo!K(B
;; # define keys
;; VALIDINPUTKEY:	abcdefghijklmnopqrstuvwxyz/?;:'"\|[{]}`~!@#$%^&*()-_=+
;; SELECTKEY:	1\040
;; SELECTKEY:	2
;; SELECTKEY:	3
;; SELECTKEY:	4
;; SELECTKEY:	5
;; SELECTKEY:	6
;; SELECTKEY:	7
;; SELECTKEY:	8
;; SELECTKEY:	9
;; SELECTKEY:	0
;; BACKSPACE:	\010\177
;; DELETEALL:	\015\025
;; MOVERIGHT:	.>
;; MOVELEFT:	,<
;; REPEATKEY:	\020\022
;; # the following line must not be removed
;; BEGINDICTIONARY
(quail-define-package
 "chinese-b5-tsangchi" "Chinese-BIG5" "$(06A(BB"
 t
 "$(0&d'GTT&,!J6AQo!K(BBIG5

	$(0KHM$6AQoTT&,WoOu(B

   [Q $(0'D(B] [W $(0(q(B] [E $(0'V(B] [R $(0&H(B] [T $(0'>(B] [Y $(0&4(B] [U $(0&U(B] [I $(0'B(B] [O $(0&*(B] [P $(0'A(B]

    [A $(0'K(B] [S $(0&T(B] [D $(0'N(B] [F $(0'W(B] [G $(0&I(B] [H $(0*M(B] [J $(0&3(B] [L $(0&d(B]
	
      [Z  ] [X $(0[E(B] [C $(01[(B] [V $(0&M(B] [B $(0'M(B] [N $(0&_(B] [M $(0&"(B] 
"
 '(
  ("." . quail-next-translation-block)
  ("," . quail-prev-translation-block)
  )
 nil nil)

(quail-define-rules
;; #
("a"	"$(0'K'L(B")
("aa"	"$(0/z$(1'.(B")
("ab"	"$(0/}(B")
("ad"	"$(00<(B")
("af"	"$(1'z's(B")
("aj"	"$(0*/(B")
("ak"	"$(1$=(B")
("am"	"$(0(Z(B")
("an"	"$(01](B")
("au"	"$(0'<$(1$>(B")
("av"	"$(0*c(B")
("aaa"	"$(0A_(B")
("aamh"	"$(0FC(B")
("aaph"	"$(1<K(B")
("aapv"	"$(0FD(B")
("aate"	"$(0Z;(B")
("aayf"	"$(1WE(B")
("abu"	"$(02$(B")
("abac"	"$(0K&(B")
("abbe"	"$(0Uq(B")
("abbt"	"$(0GB(B")
("abhaf"	"$(1p#(B")
("abik"	"$(1=s(B")
("abjj"	"$(0F@F>(B")
("abjcm"	"$(1WG(B")
("abme"	"$(0FA(B")
("abms"	"$(0=,(B")
("abof"	"$(1Pn(B")
("abuu"	"$(15n(B")
("acim"	"$(1J_(B")
("acnh"	"$(15p(B")
("acsh"	"$(1'2(B")
("adhl"	"$(0A](B")
("adhaf"	"$(1p"(B")
("admq"	"$(1CI(B")
("adwf"	"$(1CH(B")
("aenl"	"$(1NY(B")
("aff"	"$(1<J(B")
("afbf"	"$(1p:(B")
("afdq"	"$(1WD(B")
("afhhh"	"$(0N`(B")
("afmu"	"$(07p(B")
("afmbc"	"$(0]C^P(B")
("afno"	"$(1au(B")
("agbt"	"$(1W@(B")
("agdi"	"$(07m(B")
("aggu"	"$(0Ro(B")
("ahe"	"$(1'((B")
("ahs"	"$(1'*$(03U(B")
("aht"	"$(00$(B")
("ahbr"	"$(07r$(1/Y(B")
("ahbu"	"$(04`(B")
("ahgf"	"$(1ah(B")
("ahhl"	"$(1*x(B")
("ahln"	"$(06L(B")
("ahml"	"$(00"(B")
("ahog"	"$(1<I(B")
("ahoo"	"$(1Pm(B")
("ahor"	"$(0Ad(B")
("ahqm"	"$(03T(B")
("ahqo"	"$(1*t(B")
("ahsk"	"$(1\~(B")
("ahvl"	"$(0/|(B")
("ahxu"	"$(1<M(B")
("aice"	"$(15o(B")
("aihs"	"$(1/W(B")
("aijb"	"$(15m(B")
("aimvu"	"$(03N(B")
("aine"	"$(1*y(B")
("aisl"	"$(0+<(B")
("aitc"	"$(0Z:(B")
("ajd"	"$(03R(B")
("ajv"	"$(07o(B")
("ajbj"	"$(1CM(B")
("ajii"	"$(1Pp(B")
("ajka"	"$(0Aa(B")
("ajmm"	"$(0FB(B")
("ajmu"	"$(15l(B")
("ajnu"	"$(1<F(B")
("akn"	"$(1"N(B")
("akcf"	"$(0Rs(B")
("akkb"	"$(0=*(B")
("akll"	"$(1*r(B")
("aklu"	"$(1<H(B")
("akms"	"$(1/X(B")
("alg"	"$(1.N(B")
("albk"	"$(03Q(B")
("alln"	"$(1*o(B")
("almo"	"$(07t(B")
("alnc"	"$(1WA(B")
("amd"	"$(1$;(B")
("amg"	"$(0/w(B")
("ami"	"$(1B|(B")
("amj"	"$(0,U$(1$:(B")
("amk"	"$(00#(B")
("amo"	"$(1',(B")
("amam"	"$(07s(B")
("ambb"	"$(1ai(B")
("ambc"	"$(1CK(B")
("ambg"	"$(1i"(B")
("ambi"	"$(0Rr(B")
("amcw"	"$(07q(B")
("amhaf"	"$(1\1(B")
("amhqu"	"$(1K5(B")
("amig"	"$(1/V(B")
("amks"	"$(1*z(B")
("ammk"	"$(1CN(B")
("ammp"	"$(0^;(B")
("ammr"	"$(0='(B")
("ammv"	"$(0=((B")
("amob"	"$(1*v(B")
("amsh"	"$(1*q(B")
("amtb"	"$(1eY(B")
("amwg"	"$(0DY(B")
("amwj"	"$(1WB(B")
("amyo"	"$(03S(B")
("ana"	"$(0Dg(B")
("anb"	"$(0Dh(B")
("and"	"$(0Df(B")
("anf"	"$(1=k(B")
("anm"	"$(05o(B")
("ano"	"$(1'K$(0:a(B")
("anp"	"$(0A-(B")
("anr"	"$(0;C(B")
("anaa"	"$(1[W(B")
("anau"	"$(0=&;)(B")
("anasm"	"$(1d;(B")
("anayk"	"$(1[V(B")
("anbbe"	"$(1[X(B")
("anbue"	"$(1`@(B")
("anbuk"	"$(1`?(B")
("ancru"	"$(0Qf(B")
("andh"	"$(0?q(B")
("andmq"	"$(0W}(B")
("andwf"	"$(0W|(B")
("anehr"	"$(0Wz(B")
("anfbg"	"$(1gg(B")
("anfbw"	"$(1l](B")
("angg"	"$(0M\(B")
("angit"	"$(0Y_(B")
("anhe"	"$(1'/(B")
("anhx"	"$(1US(B")
("anher"	"$(0M^(B")
("anhpa"	"$(1[Z(B")
("anhqu"	"$(1AC(B")
("anhud"	"$(1d=(B")
("anit"	"$(1HW(B")
("aniav"	"$(1UP(B")
("anirm"	"$(1[T(B")
("anjbc"	"$(0Ya(B")
("anjka"	"$(1[S(B")
("anki"	"$(0Di(B")
("anklu"	"$(1[U(B")
("anlmc"	"$(1jU(B")
("anlmi"	"$(0M](B")
("anmg"	"$(0Dd(B")
("anmj"	"$(1:,(B")
("anmt"	"$(0De(B")
("anmfj"	"$(1HX(B")
("anmjk"	"$(1jT(B")
("anmmm"	"$(1:+(B")
("anmnr"	"$(1HV(B")
("anmwg"	"$(1`>(B")
("annhx"	"$(0Tp(B")
("annkg"	"$(1UR(B")
("annok"	"$(0W{(B")
("anog"	"$(1[Y(B")
("anoi"	"$(0M_(B")
("anok"	"$(1CG(B")
("anomm"	"$(1jV(B")
("anomr"	"$(0M`(B")
("anph"	"$(1HU(B")
("anqou"	"$(1gf(B")
("anrhr"	"$(0Qe(B")
("anrrj"	"$(0\P(B")
("anrrr"	"$(0W~(B")
("ansj"	"$(0LM(B")
("ansqf"	"$(0Y`(B")
("ansrj"	"$(0]=(B")
("antcu"	"$(1`=(B")
("antuo"	"$(0Yb(B")
("anumt"	"$(1d<(B")
("anvit"	"$(0[C(B")
("anwd"	"$(1UQ(B")
("anwl"	"$(0IQ(B")
("anwlv"	"$(1l\(B")
("anyk"	"$(0Dc(B")
("anygq"	"$(1l[(B")
("anyhn"	"$(1AB(B")
("anyhs"	"$(1AA(B")
("anymr"	"$(1TH(B")
("anysy"	"$(1[R(B")
("anyta"	"$(1`<(B")
("anyvo"	"$(0M[(B")
("aop"	"$(0;3(B")
("aodmq"	"$(1dQ(B")
("aofh"	"$(1BR(B")
("aohaf"	"$(1k4(B")
("aoii"	"$(03W(B")
("aoin"	"$(1'1(B")
("aombc"	"$(0Yo(B")
("aowy"	"$(0=)(B")
("api"	"$(1$<(B")
("app"	"$(0/{(B")
("apr"	"$(1*u(B")
("apu"	"$(1'0(B")
("aphh"	"$(1')$(0/y(B")
("apim"	"$(0/~(B")
("apvo"	"$(03X(B")
("aqka"	"$(1CL(B")
("aqmb"	"$(0A^(B")
("arf"	"$(0FzF}(B")
("armd"	"$(1.#(B")
("arrj"	"$(1WF(B")
("arrk"	"$(1p;(B")
("arye"	"$(0F?(B")
("asf"	"$(1Di(B")
("asp"	"$(1*p(B")
("ashr"	"$(03P(B")
("asje"	"$(0@3(B")
("asmg"	"$(0XL(B")
("astr"	"$(0O4(B")
("atak"	"$(1Pr(B")
("atbc"	"$(1<L(B")
("atbo"	"$(1ag(B")
("atce"	"$(0O3(B")
("atcr"	"$(1_X(B")
("atgs"	"$(0[r(B")
("atlb"	"$(1Pq(B")
("atlf"	"$(1i!(B")
("atlo"	"$(1Pl(B")
("atmj"	"$(0Rq(B")
("aug"	"$(1:k(B")
("auu"	"$(1*s#f(B")
("auam"	"$(0K%(B")
("auhqu"	"$(1D)(B")
("auks"	"$(13q(B")
("aumt"	"$(1Ja(B")
("aunl"	"$(1@y(B")
("aunwf"	"$(1k!(B")
("avhl"	"$(1WC(B")
("avhaf"	"$(1m+nkk5(B")
("avhqu"	"$(1D'(B")
("avno"	"$(0FY(B")
("awla"	"$(0Up(B")
("awle"	"$(0;8(B")
("ayk"	"$(1'+''(B")
("ayt"	"$(03V(B")
("aybp"	"$(1h~(B")
("aydk"	"$(1W?(B")
("ayhs"	"$(1'&(B")
("ayoj"	"$(1<G(B")
("ayrb"	"$(1J`(B")
("ayrf"	"$(0A`Ac(B")
("ayrv"	"$(0\p(B")
("aysd"	"$(1CF(B")
("ayta"	"$(0F=(B")
("aytg"	"$(1W>(B")
("aytj"	"$(1Po(B")
("ayvi"	"$(1*n(B")
("b"	"$(0'M(B")
("bb"	"$(00&(B")
("bd"	"$(01Z(B")
("bf"	"$(00g(B")
("bg"	"$(0-?(B")
("bm"	"$(0'c->$(1!*(B")
("bn"	"$(1!h(B")
("bq"	"$(0(o(B")
("bt"	"$(0'v(x(B")
("bu"	"$(0(y(B")
("bv"	"$(0+u(B")
("by"	"$(0&f(B")
("bau"	"$(012(B")
("bahm"	"$(0H%(B")
("bamh"	"$(0H$(B")
("bayc"	"$(06D(B")
("bbb"	"$(0:m(B")
("bbe"	"$(0.@(B")
("bbr"	"$(1)L(B")
("bbu"	"$(0E+(B")
("bbbr"	"$(1FI(B")
("bbbuu"	"$(1g$(B")
("bbdi"	"$(18O(B")
("bbdhe"	"$(1U|(B")
("bbggu"	"$(1nS(B")
("bbhf"	"$(0[\(B")
("bbhaf"	"$(1m,(B")
("bbher"	"$(0U2(B")
("bbhhj"	"$(1df(B")
("bbhne"	"$(0Mt(B")
("bbibi"	"$(1ju(B")
("bbijc"	"$(1lp(B")
("bbjr"	"$(0R!(B")
("bbjhr"	"$(1h0(B")
("bbjmc"	"$(1pd(B")
("bbjti"	"$(0_0(B")
("bbkms"	"$(1[y(B")
("bbkni"	"$(1Hq(B")
("bbln"	"$(13p(B")
("bblwv"	"$(0]I(B")
("bbmj"	"$(1Hp(B")
("bbmr"	"$(09`(B")
("bbmbc"	"$(1gv(B")
("bbmlk"	"$(1`q(B")
("bbnd"	"$(18P(B")
("bbnq"	"$(0CV(B")
("bboll"	"$(1OD(B")
("bbpe"	"$(0Ey(B")
("bbtt"	"$(1[w(B")
("bbtmt"	"$(0^)(B")
("bbtqm"	"$(1jt(B")
("bbtwt"	"$(0^V(B")
("bbug"	"$(1mt(B")
("bbul"	"$(1V>(B")
("bbuu"	"$(0?=(B")
("bbwd"	"$(0Yy(B")
("bbwli"	"$(0^W(B")
("bbyck"	"$(1[v(B")
("bbyhn"	"$(0Ms(B")
("bbykb"	"$(0^U(B")
("bbymp"	"$(1[x(B")
("bbyrb"	"$(1js(B")
("bbytj"	"$(0[0(B")
("bbyvo"	"$(0U1(B")
("bcj"	"$(1(O(B")
("bcr"	"$(1#,(B")
("bcv"	"$(0UP(B")
("bcabu"	"$(1Z_(B")
("bcaph"	"$(0Q2(B")
("bcbcc"	"$(1lC(B")
("bcbcd"	"$(1TX(B")
("bcbgr"	"$(1TU(B")
("bcbjj"	"$(1Za(B")
("bcbuc"	"$(1N>(B")
("bcbuu"	"$(1_G(B")
("bccwa"	"$(0[%(B")
("bcdh"	"$(0:C(B")
("bcff"	"$(1TY(B")
("bcgwc"	"$(0]v(B")
("bche"	"$(0?J(B")
("bchaf"	"$(1e$(B")
("bcher"	"$(0Hw(B")
("bchio"	"$(0D;(B")
("bchpm"	"$(1@P(B")
("bchqm"	"$(1@R(B")
("bcii"	"$(0Q-(B")
("bcij"	"$(0Hq(B")
("bcir"	"$(0D5(B")
("bcibi"	"$(0WW(B")
("bciih"	"$(1cc(B")
("bcije"	"$(1N=(B")
("bcikk"	"$(1g7(B")
("bcims"	"$(0]/(B")
("bcjir"	"$(1Zc(B")
("bcjka"	"$(0Q/(B")
("bcjmn"	"$(0D2(B")
("bckb"	"$(0Ht(B")
("bcll"	"$(1N?(B")
("bcln"	"$(02-(B")
("bclmt"	"$(1lB(B")
("bcmj"	"$(0-9(B")
("bcmmv"	"$(0M5(B")
("bcmpm"	"$(0Q,(B")
("bcmvn"	"$(1f'(B")
("bcmwj"	"$(1g9(B")
("bcnl"	"$(13=H-(B")
("bcncr"	"$(0\F(B")
("bcok"	"$(0<v(B")
("bcoju"	"$(0\.(B")
("bcomf"	"$(0M6(B")
("bcpd"	"$(13&(B")
("bcqka"	"$(1Zb(B")
("bcrl"	"$(0H'(B")
("bcru"	"$(0>l(B")
("bcrhu"	"$(1@O(B")
("bcrxu"	"$(1p*(B")
("bcsmv"	"$(0Q.(B")
("bctbc"	"$(1TT(B")
("bctct"	"$(1_d(B")
("bcttb"	"$(0WU(B")
("bctxc"	"$(0WS(B")
("bcyr"	"$(0D3(B")
("bcyhn"	"$(19W(B")
("bcymr"	"$(1lA(B")
("bcyoj"	"$(1TS(B")
("bcytr"	"$(0Q*(B")
("bcyvo"	"$(0Hx(B")
("bdi"	"$(0-=(B")
("bdu"	"$(0-g(B")
("bdhhh"	"$(0<4(B")
("bdnl"	"$(13?(B")
("bdoe"	"$(0PN(B")
("beee"	"$(1?4(B")
("behaf"	"$(1k7(B")
("bfd"	"$(1%N(B")
("bfp"	"$(0[m(B")
("bfq"	"$(05)(B")
("bfu"	"$(13O(B")
("bfbg"	"$(0PL(B")
("bfcb"	"$(1M2(B")
("bfdq"	"$(1YU(B")
("bfhvf"	"$(0Sm(B")
("bfmu"	"$(09[(B")
("bfqc"	"$(0WV(B")
("bfqe"	"$(0OZ(B")
("bfqf"	"$(1YC$(0\W(B")
("bfqg"	"$(1B.(B")
("bfqi"	"$(1Z3(B")
("bfqr"	"$(0WN(B")
("bfqs"	"$(0@:(B")
("bfqu"	"$(1?1(B")
("bfqv"	"$(1BA(B")
("bgi"	"$(1,z(B")
("bgr"	"$(0.S(B")
("bggu"	"$(1YV(B")
("bghqu"	"$(1mW(B")
("bgte"	"$(1^W(B")
("bgth"	"$(0Sz(B")
("bha"	"$(1-'(B")
("bhn"	"$(0*[&~(B")
("bhs"	"$(1-#(B")
("bhx"	"$(09k(B")
("bhae"	"$(0H*(B")
("bhbue"	"$(1qy(B")
("bhbvk"	"$(1_b(B")
("bhdh"	"$(0:A(B")
("bhdv"	"$(1?5(B")
("bhdw"	"$(1YZ(B")
("bher"	"$(09c(B")
("bhgf"	"$(1bm(B")
("bhhh"	"$(1$y(B")
("bhhj"	"$(0CQ(B")
("bhhv"	"$(09d(B")
("bhhau"	"$(0M3(B")
("bhher"	"$(0Hp(B")
("bhhhj"	"$(1TR(B")
("bhhwp"	"$(1_c(B")
("bhjc"	"$(1@M(B")
("bhje"	"$(1FE(B")
("bhjg"	"$(0H((B")
("bhjm"	"$(1FH(B")
("bhju"	"$(1FG(B")
("bhlq"	"$(1Ga(B")
("bhlwv"	"$(1c`(B")
("bhma"	"$(0Ho(B")
("bhmj"	"$(13%(B")
("bhml"	"$(1(P(B")
("bhmam"	"$(1G`(B")
("bhne"	"$(015(B")
("bhob"	"$(19V(B")
("bhod"	"$(1Gb(B")
("bhon"	"$(123(B")
("bhomn"	"$(1Z^(B")
("bhpi"	"$(0:B(B")
("bhpm"	"$(054(B")
("bhqm"	"$(1-$(B")
("bhqo"	"$(1-!(B")
("bhrrj"	"$(1g6(B")
("bhrye"	"$(1Z\(B")
("bhshr"	"$(0D1(B")
("bhsrr"	"$(1c^(B")
("bhtw"	"$(0TJ(B")
("bhtak"	"$(1c_(B")
("bhuc"	"$(0^E(B")
("bhuu"	"$(1@NY[(B")
("bhumb"	"$(1Z](B")
("bhvo"	"$(1-+(B")
("bhwg"	"$(0M2(B")
("bhwp"	"$(1M1(B")
("bhxo"	"$(0CT(B")
("bir"	"$(051(B")
("bibi"	"$(0LT(B")
("bice"	"$(18T5r(B")
("bijb"	"$(0>i(B")
("bije"	"$(18L(B")
("bikk"	"$(1,|(B")
("bioi"	"$(0CM(B")
("bipc"	"$(0Sy(B")
("bipf"	"$(1fP(B")
("biypu"	"$(1Si(B")
("bjb"	"$(011(B")
("bje"	"$(013(B")
("bjv"	"$(12.(B")
("bjbd"	"$(0>j(B")
("bjbj"	"$(1F?(B")
("bjcg"	"$(1S)(B")
("bjcm"	"$(0CK(B")
("bjdhe"	"$(1L+(B")
("bjhaf"	"$(1k*(B")
("bjii"	"$(1S+(B")
("bjlmi"	"$(1fs(B")
("bjmc"	"$(0Y-(B")
("bjmu"	"$(18J(B")
("bjmbc"	"$(1dU(B")
("bjnl"	"$(1@v(B")
("bjnu"	"$(0CJ(B")
("bjtc"	"$(1YW(B")
("bjti"	"$(1fO(B")
("bjwj"	"$(05](B")
("bkf"	"$(0BT(B")
("bki"	"$(014(B")
("bkk"	"$(1"i(B")
("bkn"	"$(09](B")
("bks"	"$(0*Z(B")
("bkcf"	"$(1YY(B")
("bkcor"	"$(0WQ(B")
("bkhaf"	"$(1k3(B")
("bklu"	"$(0CR(B")
("bkms"	"$(09h(B")
("bkni"	"$(1$x(B")
("bknl"	"$(1@|(B")
("bkog"	"$(0Yg(B")
("bkoo"	"$(18K(B")
("bln"	"$(0)I(B")
("blbk"	"$(1-*(B")
("blln"	"$(1,y(B")
("blmo"	"$(122/[(B")
("blmy"	"$(0CS(B")
("blwl"	"$(1,}(B")
("blwv"	"$(1S-(B")
("blxh"	"$(1-((B")
("bmj"	"$(0-<(B")
("bmr"	"$(0)R(B")
("bmbb"	"$(1bk(B")
("bmbg"	"$(1ia(B")
("bmbl"	"$(120(B")
("bmfm"	"$(05+(B")
("bmig"	"$(121(B")
("bmke"	"$(04<(B")
("bmks"	"$(0+8(B")
("bmln"	"$(1#/(B")
("bmmc"	"$(0.'(B")
("bmmo"	"$(06E(B")
("bmmu"	"$(1'4(B")
("bmmv"	"$(0>o(B")
("bmog"	"$(1H](B")
("bmrb"	"$(0LS(B")
("bmrt"	"$(0>n(B")
("bmrw"	"$(1F=(B")
("bmso"	"$(0?I(B")
("bmui"	"$(02&(B")
("bmvm"	"$(18M(B")
("bmwf"	"$(0PQ(B")
("bmwv"	"$(0H#(B")
("bnd"	"$(0+x(B")
("bnau"	"$(18S(B")
("bncr"	"$(0W%(B")
("bnii"	"$(1S.(B")
("bnkg"	"$(18R(B")
("bnkq"	"$(0H"(B")
("bnlii"	"$(1l6(B")
("bnmu"	"$(09a(B")
("bnui"	"$(06C(B")
("bob"	"$(1(Q(B")
("bog"	"$(1?6(B")
("bon"	"$(1$w(B")
("boae"	"$(0H)(B")
("bobo"	"$(1/Z(B")
("bodi"	"$(1-&(B")
("bogf"	"$(1Y](B")
("bogs"	"$(1^Z(B")
("bohh"	"$(1-)(B")
("boin"	"$(1(N(B")
("boip"	"$(1?7(B")
("boma"	"$(0W'(B")
("bomn"	"$(1FF(B")
("bomo"	"$(0W&(B")
("bommf"	"$(0>C(B")
("bomrt"	"$(1G[(B")
("boog"	"$(18Q(B")
("bopd"	"$(1-"(B")
("botf"	"$(1Y\(B")
("bowy"	"$(18V(B")
("bpa"	"$(09\(B")
("bpr"	"$(1*|-%(B")
("bpu"	"$(016(B")
("bpru"	"$(052(B")
("bpuk"	"$(09b(B")
("bqu"	"$(0(p(B")
("bqkk"	"$(1F<(B")
("bqmf"	"$(1M.(B")
("brc"	"$(1,{(B")
("bri"	"$(1/2(B")
("brhg"	"$(18N(B")
("brhaf"	"$(1hV(B")
("brhhh"	"$(0<5(B")
("brog"	"$(0Tt(B")
("brrd"	"$(1^X(B")
("brsmm"	"$(1M&(B")
("bsd"	"$(00i(B")
("bss"	"$(0'z(B")
("bsef"	"$(1hW(B")
("bshh"	"$(1%%(B")
("bshi"	"$(1$u(B")
("bsjr"	"$(1?3(B")
("bsle"	"$(00%(B")
("bsmg"	"$(1F@(B")
("bsmh"	"$(0PO(B")
("bsmv"	"$(0CO(B")
("bta"	"$(1?2(B")
("btk"	"$(07w(B")
("btt"	"$(09g(B")
("btu"	"$(0/&(B")
("btab"	"$(0R7(B")
("btak"	"$(0PM(B")
("btbc"	"$(0CP(B")
("btbo"	"$(0XM(B")
("btct"	"$(1M-(B")
("btgr"	"$(0Sx(B")
("btis"	"$(0]q(B")
("btlf"	"$(1ib(B")
("btlk"	"$(1CO(B")
("btln"	"$(0+5(B")
("btmd"	"$(1F>(B")
("btmbc"	"$(1[f(B")
("btoe"	"$(1bl(B")
("btwv"	"$(0W$(B")
("btyj"	"$(1YX(B")
("btyv"	"$(01-(B")
("buc"	"$(0-K(B")
("buu"	"$(1,~*{(B")
("buav"	"$(0>:(B")
("buamj"	"$(1>D(B")
("buamo"	"$(1L-(B")
("buana"	"$(1]j(B")
("buank"	"$(1q+(B")
("bubd"	"$(0GJ(B")
("bubac"	"$(0Oy(B")
("bubbq"	"$(0VJ(B")
("bubgr"	"$(1EJ(B")
("bubsd"	"$(0GK(B")
("bubuk"	"$(1L,(B")
("bubuu"	"$(1N0>C(B")
("buce"	"$(1FC(B")
("bucim"	"$(1RI(B")
("bucms"	"$(1,I(B")
("bucnh"	"$(1>A(B")
("bucsh"	"$(04c(B")
("budoo"	"$(0GF(B")
("bufb"	"$(1>B(B")
("bufd"	"$(17M(B")
("buff"	"$(1EC(B")
("bufh"	"$(04d(B")
("bufbf"	"$(1q*(B")
("bufbg"	"$(0SP(B")
("bufdq"	"$(1]g(B")
("bufqu"	"$(1EB(B")
("bugg"	"$(17N(B")
("bugce"	"$(1ED(B")
("bugcg"	"$(0GE(B")
("bugit"	"$(0Ox(B")
("buhe"	"$(1,F(B")
("buhu"	"$(0-E(B")
("buhaf"	"$(0]P$(1Xk(B")
("buhdf"	"$(1L.(B")
("buhgf"	"$(1f+(B")
("buhhj"	"$(0GL(B")
("buhhv"	"$(17S(B")
("buhio"	"$(08|(B")
("buhjm"	"$(0Kv(B")
("buhju"	"$(1L4(B")
("buhml"	"$(1,J(B")
("buhni"	"$(1gz(B")
("buhok"	"$(1iz(B")
("buhoo"	"$(1Xf(B")
("buhpa"	"$(1EG(B")
("buhqi"	"$(1>G(B")
("buhqo"	"$(116(B")
("buhqu"	"$(1,G(B")
("buhsk"	"$(1EI(B")
("buhus"	"$(1iF(B")
("buhvf"	"$(1^F(B")
("buhxe"	"$(1RF(B")
("buhxu"	"$(0GM(B")
("buik"	"$(1,!(B")
("buir"	"$(119(B")
("buiv"	"$(114(B")
("buihq"	"$(0><(B")
("buitc"	"$(1iD(B")
("bujd"	"$(112(B")
("bujbc"	"$(0Oz(B")
("bujka"	"$(0GH(B")
("bujlo"	"$(0GD(B")
("bujmc"	"$(1f)Xb(B")
("bujmn"	"$(111(B")
("bujmu"	"$(1>@(B")
("bujnu"	"$(1E@(B")
("bujqr"	"$(0Ov(B")
("bukn"	"$(17O(B")
("bukcf"	"$(0VL(B")
("bukkb"	"$(1>F(B")
("buln"	"$(06M(B")
("bulbu"	"$(1,C(B")
("bullp"	"$(1Xh(B")
("bulmc"	"$(1]k(B")
("bulmi"	"$(1M|(B")
("bulmo"	"$(0>=(B")
("bulwl"	"$(115(B")
("bulwv"	"$(1Xe(B")
("bumd"	"$(1(:(B")
("bumj"	"$(1(;(B")
("bumn"	"$(0-2(B")
("bumbg"	"$(1ko(B")
("bumgg"	"$(1EE(B")
("bumjk"	"$(0VI(B")
("bumls"	"$(1,E(B")
("bummi"	"$(1,D(B")
("bumwf"	"$(0SR(B")
("bumwj"	"$(1]h(B")
("bumym"	"$(113(B")
("bunau"	"$(1>H(B")
("bunbe"	"$(1iE(B")
("buncr"	"$(0Xn(B")
("bunhb"	"$(1]i(B")
("bunin"	"$(17V(B")
("bunir"	"$(17R(B")
("bunok"	"$(0Kt(B")
("bunot"	"$(0VH(B")
("buog"	"$(1S/$(0GNXm(B")
("buon"	"$(1(<(B")
("buoge"	"$(1iG(B")
("buogf"	"$(0VK(B")
("buohh"	"$(118(B")
("buoma"	"$(1bC(B")
("buomb"	"$(1EH(B")
("buomn"	"$(1L0(B")
("buomo"	"$(0Xo(B")
("buotf"	"$(1]l(B")
("bupa"	"$(17Q(B")
("bupu"	"$(04^(B")
("bupim"	"$(1,H(B")
("buqmb"	"$(0GC(B")
("buqou"	"$(1Xd(B")
("burb"	"$(1>E(B")
("burrd"	"$(1bB(B")
("burvp"	"$(08{(B")
("busj"	"$(17P(B")
("bushr"	"$(11<(B")
("busmg"	"$(0>;(B")
("busyi"	"$(0_4(B")
("butk"	"$(17L(B")
("butq"	"$(17U(B")
("butw"	"$(0Ks(B")
("butak"	"$(1Xj(B")
("butbo"	"$(0ZT(B")
("butco"	"$(1]n(B")
("butlb"	"$(0SQ(B")
("butmj"	"$(1]m(B")
("butrg"	"$(1o<(B")
("buvfb"	"$(1f*(B")
("buvis"	"$(117(B")
("buvml"	"$(0Ip(B")
("buvne"	"$(1EF(B")
("buwd"	"$(0B{(B")
("buyv"	"$(1(9(B")
("buybp"	"$(0\{(B")
("buyfd"	"$(0Ow(B")
("buyoj"	"$(1EA(B")
("buytg"	"$(0VG(B")
("buytj"	"$(1Xi(B")
("buyub"	"$(1Xc(B")
("buyvi"	"$(08y(B")
("bvg"	"$(0RK(B")
("bvp"	"$(0U_(B")
("bvhl"	"$(1Y^(B")
("bvhaf"	"$(0_F(B")
("bvik"	"$(06s(B")
("bvnl"	"$(1@}(B")
("bvno"	"$(1FD(B")
("bvvv"	"$(0Zi(B")
("bvvw"	"$(0H+(B")
("bwk"	"$(09_(B")
("bwl"	"$(050(B")
("bwp"	"$(0H&(B")
("bwim"	"$(1S,(B")
("bwlb"	"$(1FA(B")
("bwli"	"$(0V;$(1^Y(B")
("bwmv"	"$(1FB(B")
("bwot"	"$(1M/(B")
("byx"	"$(0Y,(B")
("byav"	"$(0LU(B")
("bybb"	"$(1^[(B")
("bybp"	"$(0[s(B")
("bybs"	"$(0LQ(B")
("byhn"	"$(1(M(B")
("byhr"	"$(1M0(B")
("byhs"	"$(019(B")
("byhaf"	"$(1V:(B")
("byhhh"	"$(0,0(B")
("byia"	"$(1YT(B")
("byij"	"$(1S*(B")
("byln"	"$(1!~(B")
("byoj"	"$(1?8(B")
("byok"	"$(0CL(B")
("bypo"	"$(1^V(B")
("bypt"	"$(0\0(B")
("byrn"	"$(18U(B")
("byta"	"$(1F;(B")
("bytg"	"$(1Y_WH(B")
("bytp"	"$(0V}(B")
("bytoe"	"$(1dC(B")
("byvg"	"$(0V~(B")
("byvi"	"$(1,x(B")
("byvo"	"$(12/(B")
("bywm"	"$(1^U(B")
("c"	"$(01[(B")
("ca"	"$(1A;(B")
("cb"	"$(1A>(B")
("cf"	"$(1A,(B")
("cg"	"$(1:'(B")
("ci"	"$(0&}(B")
("cj"	"$(0:](B")
("ck"	"$(19~$(0'Y(B")
("cl"	"$(0&:(B")
("cm"	"$(0?o(B")
("cn"	"$(1-b(B")
("cp"	"$(1A+(B")
("cr"	"$(0?l(B")
("cu"	"$(1-c(B")
("cv"	"$(1:$(B")
("cw"	"$(0IO(B")
("cy"	"$(0:`(B")
("caa"	"$(1[F(B")
("cam"	"$(1HB(B")
("can"	"$(1[7(B")
("cau"	"$(1A2(B")
("cav"	"$(0MQ(B")
("cafu"	"$(1d6(B")
("camh"	"$(0Wx(B")
("camj"	"$(0Qd(B")
("camo"	"$(1`%(B")
("camvn"	"$(1]](B")
("canl"	"$(1U!(B")
("canw"	"$(1qD(B")
("caph"	"$(0Tg(B")
("capp"	"$(0Tm(B")
("capv"	"$(1`4(B")
("casm"	"$(1d((B")
("cate"	"$(0^N(B")
("cawe"	"$(0[;(B")
("cbb"	"$(1[L(B")
("cbm"	"$(1HD(B")
("cbu"	"$(1HC(B")
("cbbe"	"$(1lY(B")
("cbbr"	"$(0Wr(B")
("cbcn"	"$(1`"(B")
("cbdi"	"$(1U:(B")
("cbgr"	"$(1[8(B")
("cbjj"	"$(1`/(B")
("cbme"	"$(0Ww(B")
("cbmr"	"$(0MR(B")
("cbms"	"$(0Q](B")
("cbsd"	"$(0Ti(B")
("cbtu"	"$(0Tf(B")
("cbuc"	"$(0Qb(B")
("cbue"	"$(1r2(B")
("cbuu"	"$(1UH(B")
("ccc"	"$(1pZ(B")
("cci"	"$(1A6(B")
("ccr"	"$(0IF(B")
("ccnh"	"$(0QY(B")
("ccor"	"$(1U?(B")
("ccru"	"$(0Q_(B")
("ccsh"	"$(1A?(B")
("cdh"	"$(1:)(B")
("cdk"	"$(1A1(B")
("cdl"	"$(1UE(B")
("cdhe"	"$(0IN(B")
("cdmq"	"$(1`1(B")
("cdoo"	"$(1[1(B")
("cdwf"	"$(0Wp(B")
("cea"	"$(1[J(B")
("cei"	"$(0?k(B")
("ceah"	"$(1j7(B")
("ceed"	"$(1d1(B")
("ceee"	"$(1[4(B")
("cehv"	"$(1_z(B")
("cfb"	"$(0QZ(B")
("cfd"	"$(1Na(B")
("cff"	"$(1[-(B")
("cfh"	"$(0DZ(B")
("cfq"	"$(1HI(B")
("cfbc"	"$(0YV(B")
("cfbd"	"$(1jN(B")
("cfbf"	"$(1r0(B")
("cfbg"	"$(0[:(B")
("cfbr"	"$(1[E(B")
("cfbu"	"$(1d5(B")
("cfbw"	"$(0]9(B")
("cfdq"	"$(1j9(B")
("cffd"	"$(1n>(B")
("cffs"	"$(1jI(B")
("cfmu"	"$(1N|(B")
("cfqu"	"$(1[,(B")
("cgg"	"$(1Nv(B")
("cgi"	"$(1HM(B")
("cgp"	"$(1UD(B")
("cgr"	"$(1Nw(B")
("cgce"	"$(1[C(B")
("cgcg"	"$(1[B(B")
("cggu"	"$(0\N(B")
("cgit"	"$(1d4(B")
("cgni"	"$(0]|(B")
("cgrv"	"$(1d3(B")
("cha"	"$(0II(B")
("chd"	"$(1HR(B")
("che"	"$(0Db(B")
("chab"	"$(0Tk(B")
("chag"	"$(1`((B")
("chdb"	"$(1jO(B")
("chdf"	"$(0Wu(B")
("chdh"	"$(1rH(B")
("chdn"	"$(1UJ(B")
("chdw"	"$(1jF(B")
("chej"	"$(0Qa(B")
("cher"	"$(0MU(B")
("chey"	"$(1HS(B")
("chgi"	"$(1O!(B")
("chgr"	"$(1U<(B")
("chgu"	"$(0MZ(B")
("chhe"	"$(1o](B")
("chhh"	"$(1:#(B")
("chhj"	"$(1[:(B")
("chhl"	"$(0IP(B")
("chhw"	"$(1d-(B")
("chhaf"	"$(1V8d|(B")
("chjd"	"$(0MT(B")
("chje"	"$(0Wv(B")
("chjg"	"$(0Wt(B")
("chjm"	"$(0Ws(B")
("chjr"	"$(1Nc(B")
("chju"	"$(1`:(B")
("chjx"	"$(1_|(B")
("chlc"	"$(1o[(B")
("chln"	"$(02((B")
("chlo"	"$(1A5(B")
("chml"	"$(1A4(B")
("chmr"	"$(1Nm(B")
("chmbc"	"$(0Id(B")
("chni"	"$(0?p(B")
("chnl"	"$(1%-(B")
("chok"	"$(1'#(B")
("choo"	"$(1gZ(B")
("chpa"	"$(1[N(B")
("chqi"	"$(1U>(B")
("chqm"	"$(1HP(B")
("chrf"	"$(0YW(B")
("chuc"	"$(0_>(B")
("chud"	"$(0YX(B")
("chup"	"$(1d8(B")
("chvo"	"$(1HT(B")
("chwp"	"$(1d,(B")
("chxe"	"$(1d+(B")
("chxh"	"$(1UK(B")
("cii"	"$(0Te(B")
("cip"	"$(19}(B")
("cir"	"$(1HH(B")
("civ"	"$(1H=(B")
("ciav"	"$(1U/(B")
("cibi"	"$(1d&(B")
("cice"	"$(1UI(B")
("cihf"	"$(1gS(B")
("cihm"	"$(1Nx(B")
("cihq"	"$(1N}(B")
("cihr"	"$(1`!(B")
("cihs"	"$(1Np(B")
("cihu"	"$(1A=(B")
("ciih"	"$(1gc(B")
("ciil"	"$(1_{(B")
("cijb"	"$(0Q[(B")
("cijc"	"$(1H<(B")
("cije"	"$(1U3(B")
("cikk"	"$(0IB(B")
("cilb"	"$(1gO(B")
("cile"	"$(1g](B")
("cill"	"$(1Nr(B")
("cilr"	"$(1d.(B")
("cimn"	"$(1,;(B")
("cimbc"	"$(0Ie(B")
("cine"	"$(1Nt(B")
("cipf"	"$(0^L(B")
("cipm"	"$(1Nu(B")
("cipp"	"$(1U5(B")
("cism"	"$(09S(B")
("citc"	"$(0]6(B")
("cite"	"$(0Wl(B")
("citf"	"$(1g^(B")
("cixp"	"$(1g_(B")
("cjp"	"$(1H6(B")
("cjr"	"$(0I@(B")
("cjv"	"$(0MX(B")
("cjbc"	"$(0YY(B")
("cjbd"	"$(1UC(B")
("cjbf"	"$(1d2(B")
("cjcr"	"$(0YT(B")
("cjig"	"$(0]8(B")
("cjii"	"$(1g`(B")
("cjip"	"$(1jL(B")
("cjka"	"$(1[0(B")
("cjki"	"$(1U.(B")
("cjkp"	"$(1Ne(B")
("cjks"	"$(0Q\(B")
("cjmc"	"$(1n8g\(B")
("cjmf"	"$(1[<(B")
("cjmm"	"$(1`-(B")
("cjmo"	"$(0T`$(1d"(B")
("cjmu"	"$(1UA(B")
("cjnu"	"$(1[=(B")
("cjpn"	"$(1n<(B")
("cjrr"	"$(1[*(B")
("cjtc"	"$(1lS(B")
("cjto"	"$(1qG(B")
("ckb"	"$(1Ng(B")
("cki"	"$(1A:A/(B")
("ckn"	"$(1Ns3H(B")
("ckau"	"$(00j(B")
("ckce"	"$(1gY(B")
("ckcf"	"$(1j?(B")
("ckgg"	"$(1`3(B")
("ckhml"	"$(0/u(B")
("ckjt"	"$(1[3(B")
("cklb"	"$(0IC(B")
("ckld"	"$(1Nz(B")
("ckmf"	"$(1[2(B")
("ckmr"	"$(0Tl(B")
("ckms"	"$(1N{(B")
("ckmgc"	"$(0:_(B")
("cknin"	"$(08W(B")
("ckoo"	"$(1U4(B")
("cksjl"	"$(0G&(B")
("cln"	"$(0:^(B")
("clw"	"$(0IE(B")
("clx"	"$(0\O(B")
("clbk"	"$(1HE(B")
("clbu"	"$(1A9(B")
("clll"	"$(0?n(B")
("clmc"	"$(1jD(B")
("clmo"	"$(1Nj(B")
("clnc"	"$(1j@(B")
("clwv"	"$(0[@(B")
("cma"	"$(1Ny(B")
("cmd"	"$(1:%(B")
("cmj"	"$(19|(B")
("cmn"	"$(0:\(B")
("cmp"	"$(1W.(B")
("cmr"	"$(1HN(B")
("cmt"	"$(1A-(B")
("cmbb"	"$(1n9(B")
("cmbc"	"$(1`U(B")
("cmbw"	"$(0]7(B")
("cmfb"	"$(1n?(B")
("cmfe"	"$(1U0(B")
("cmfj"	"$(1Nf(B")
("cmgi"	"$(1H9(B")
("cmgr"	"$(1p\(B")
("cmhaf"	"$(1m8(B")
("cmig"	"$(1Nh(B")
("cmlm"	"$(1[/(B")
("cmmr"	"$(1U2(B")
("cmms"	"$(1:&(B")
("cmmv"	"$(1UF(B")
("cmnr"	"$(1H;(B")
("cmrb"	"$(0Y\(B")
("cmrt"	"$(1U1(B")
("cmtn"	"$(1Nb(B")
("cmua"	"$(1j>(B")
("cmvi"	"$(1d$(B")
("cmvm"	"$(1UG(B")
("cmvs"	"$(0&|(B")
("cmwf"	"$(0[=(B")
("cmwj"	"$(1j<(B")
("cmym"	"$(1H:(B")
("cmys"	"$(0D\(B")
("cnd"	"$(1:((B")
("cng"	"$(0D[(B")
("cni"	"$(1:"(B")
("cnl"	"$(1A0"?(B")
("cnn"	"$(13F(B")
("cno"	"$(0B$(B")
("cnao"	"$(1jP(B")
("cnau"	"$(1Nk(B")
("cndt"	"$(0Tc(B")
("cnhb"	"$(1jB(B")
("cnhd"	"$(1`0(B")
("cnhe"	"$(1A3(B")
("cnhs"	"$(13G(B")
("cnhx"	"$(1[9(B")
("cnii"	"$(1gU(B")
("cnin"	"$(1Nl(B")
("cnir"	"$(0MS(B")
("cnkg"	"$(1U;(B")
("cnkm"	"$(1[;(B")
("cnkq"	"$(0Wo(B")
("cnlh"	"$(1jM$(0,/(B")
("cnlr"	"$(1[5(B")
("cnoe"	"$(1jJ(B")
("cnot"	"$(1jA(B")
("cnri"	"$(1qF(B")
("cob"	"$(0D](B")
("cod"	"$(1O"(B")
("cog"	"$(0Tj(B")
("con"	"$(1:!(B")
("cop"	"$(0Nl(B")
("cor"	"$(0-H(B")
("coae"	"$(1`'(B")
("cogd"	"$(1jQ(B")
("cogf"	"$(1jG(B")
("cogj"	"$(1d7(B")
("cogs"	"$(0]<(B")
("cohg"	"$(1O#(B")
("coii"	"$(0IJ(B")
("coim"	"$(1qE(B")
("coin"	"$(0D`(B")
("coir"	"$(1UL$(0Y^(B")
("colb"	"$(1HQ(B")
("colh"	"$(1`9(B")
("colmi"	"$(1_;(B")
("comb"	"$(1[O$(0_-(B")
("comg"	"$(0MV(B")
("como"	"$(1lZ(B")
("comr"	"$(1Nn(B")
("cond"	"$(1d*(B")
("conk"	"$(1`)(B")
("coog"	"$(0Q`(B")
("cowy"	"$(1U=(B")
("cph"	"$(0IL(B")
("cpi"	"$(0?m(B")
("cpp"	"$(1A.(B")
("cpr"	"$(0IH(B")
("cpu"	"$(0D_(B")
("cpim"	"$(0D^(B")
("cpou"	"$(1[M(B")
("cppa"	"$(1_~(B")
("cpru"	"$(0IG(B")
("cptd"	"$(1`2(B")
("cpyr"	"$(1`8(B")
("cqd"	"$(1N~(B")
("cqo"	"$(0Da(B")
("cqhk"	"$(0Wq(B")
("cqjm"	"$(1gQ(B")
("cqmb"	"$(1[.(B")
("cqmv"	"$(0Ta(B")
("crb"	"$(1U9(B")
("crp"	"$(1a\(B")
("crhr"	"$(0Q^(B")
("crhu"	"$(0+,(B")
("crhaf"	"$(1e((B")
("crjcm"	"$(1TP(B")
("crki"	"$(19R(B")
("crmjk"	"$(1g3(B")
("crnl"	"$(13B(B")
("crno"	"$(0=D(B")
("crnq"	"$(19S(B")
("croir"	"$(1N:(B")
("crrd"	"$(1lT(B")
("crrs"	"$(0Wy(B")
("crsl"	"$(024(B")
("crsmh"	"$(1c\(B")
("crtc"	"$(1GZ(B")
("cruc"	"$(1jK(B")
("crvk"	"$(1U7(B")
("crvp"	"$(1HK(B")
("crye"	"$(1`#(B")
("crybp"	"$(1oT(B")
("csh"	"$(0'"(B")
("csj"	"$(1Nd(B")
("csp"	"$(1H?(B")
("css"	"$(0IM(B")
("cseg"	"$(0[A(B")
("cshc"	"$(0?O(B")
("cshf"	"$(1'{(B")
("cshg"	"$(1#L(B")
("cshp"	"$(0/D(B")
("cshr"	"$(1H@(B")
("csht"	"$(04Z$(1#r(B")
("cshu"	"$(0,&(B")
("csit"	"$(0]}(B")
("csje"	"$(1[A(B")
("csjj"	"$(0_6(B")
("csjr"	"$(0Tb(B")
("cslb"	"$(1HL(B")
("csme"	"$(1U6(B")
("csmh"	"$(1gT(B")
("csmr"	"$(1HJ(B")
("csmv"	"$(1[@(B")
("csqf"	"$(1d%(B")
("csrr"	"$(1gR(B")
("cssr"	"$(1UB(B")
("csyi"	"$(1r:(B")
("cta"	"$(0Td(B")
("ctm"	"$(0IA(B")
("ctt"	"$(0MY(B")
("ctw"	"$(0Wn(B")
("ctak"	"$(1gW(B")
("ctbc"	"$(1[I(B")
("ctbk"	"$(1j=(B")
("ctca"	"$(1j:(B")
("ctco"	"$(1jE(B")
("ctct"	"$(0Y[(B")
("ctei"	"$(1qC(B")
("ctgi"	"$(1nA(B")
("ctgk"	"$(0Wm(B")
("ctgt"	"$(1n@(B")
("ctgu"	"$(1[?(B")
("ctis"	"$(1qe(B")
("ctmc"	"$(1[D(B")
("ctmj"	"$(1jC(B")
("ctmv"	"$(1_}(B")
("ctoe"	"$(1n:(B")
("ctop"	"$(1[H(B")
("ctor"	"$(1d'(B")
("ctpd"	"$(1lW(B")
("ctqm"	"$(1d/(B")
("ctrg"	"$(1qf(B")
("ctsr"	"$(1`7(B")
("ctub"	"$(1d0(B")
("ctvi"	"$(1_y(B")
("ctwi"	"$(1j;(B")
("ctxc"	"$(1d#(B")
("ctyj"	"$(1o\(B")
("ctyv"	"$(1U8(B")
("cuce"	"$(1`&(B")
("cuhqu"	"$(10#(B")
("cumj"	"$(1[K(B")
("cumt"	"$(1d)(B")
("cuob"	"$(1qc(B")
("cuog"	"$(1gX(B")
("cuok"	"$(15j(B")
("cvr"	"$(1No(B")
("cvfr"	"$(1jR(B")
("cvid"	"$(0^M(B")
("cvii"	"$(1jH(B")
("cvio"	"$(1HG(B")
("cvmi"	"$(0[?(B")
("cvne"	"$(0Th(B")
("cvvv"	"$(1o^(B")
("cvvw"	"$(0To(B")
("cwa"	"$(0Ae(B")
("cwd"	"$(1[6(B")
("cwg"	"$(0Qc(B")
("cwk"	"$(1Ni(B")
("cwl"	"$(0ID(B")
("cwp"	"$(1`$(B")
("cwjr"	"$(0Tn(B")
("cwlg"	"$(0_@(B")
("cwli"	"$(0];(B")
("cwlj"	"$(0]:(B")
("cwlv"	"$(1lP(B")
("cwmv"	"$(1`5(B")
("cwtj"	"$(1ga(B")
("cwvf"	"$(0[>(B")
("cwwg"	"$(1qd(B")
("cwyi"	"$(1HF(B")
("cye"	"$(1A<(B")
("cyg"	"$(1H7(B")
("cyj"	"$(1A7(B")
("cyr"	"$(1HA(B")
("cyx"	"$(1n=(B")
("cybb"	"$(1lU`.(B")
("cybc"	"$(1`6(B")
("cybk"	"$(1r1(B")
("cybp"	"$(1p[(B")
("cybs"	"$(0YU(B")
("cycb"	"$(0[6(B")
("cyck"	"$(0MP(B")
("cydk"	"$(1j8(B")
("cygq"	"$(1lR(B")
("cyhm"	"$(0[7(B")
("cyhn"	"$(1A8(B")
("cyhr"	"$(0Y](B")
("cyhs"	"$(1A*(B")
("cyhv"	"$(1N`(B")
("cyib"	"$(1[>(B")
("cyiu"	"$(1H>(B")
("cyjj"	"$(0[9(B")
("cylb"	"$(1H8(B")
("cymb"	"$(1[G(B")
("cymh"	"$(1lX(B")
("cymy"	"$(1HO(B")
("cypd"	"$(1gV(B")
("cypo"	"$(1lO(B")
("cypp"	"$(1oZ(B")
("cyps"	"$(1lV(B")
("cypt"	"$(0^p(B")
("cyrb"	"$(0YZ(B")
("cyrd"	"$(1[+(B")
("cyrv"	"$(0_,(B")
("cysk"	"$(0[8(B")
("cyso"	"$(1gP(B")
("cytg"	"$(0\M(B")
("cytj"	"$(0QX(B")
("cyto"	"$(1lQ(B")
("cytp"	"$(1lN(B")
("cytu"	"$(0[5(B")
("cyvi"	"$(0IK(B")
("cywi"	"$(1gb(B")
("d"	"$(0'N(B")
("da"	"$(00,(B")
("db"	"$(1"U(B")
("dc"	"$(1"W(B")
("dd"	"$(000(B")
("df"	"$(002(B")
("dg"	"$(0,\(B")
("dh"	"$(0&`(B")
("di"	"$(0&Q(B")
("dj"	"$(0(^(B")
("dk"	"$(1!<$B(B")
("dl"	"$(0,W(B")
("dm"	"$(0(\,a(B")
("dp"	"$(1'A"V(B")
("dq"	"$(1'F(B")
("dr"	"$(0,Y(B")
("du"	"$(0(_(B")
("dw"	"$(00*(B")
("dy"	"$(0*7(B")
("dam"	"$(03h$(1+?(B")
("dau"	"$(00-(B")
("dav"	"$(07~(B")
("dafu"	"$(1K+(B")
("dagi"	"$(1Ju(B")
("dahu"	"$(0FW(B")
("dail"	"$(15{(B")
("daiu"	"$(0FN(B")
("damh"	"$(0FO(B")
("damj"	"$(0=3(B")
("dang"	"$(1Wf(B")
("danr"	"$(0Z>(B")
("danw"	"$(0\r(B")
("dapp"	"$(0Ax(B")
("dapv"	"$(1Ca(B")
("dasm"	"$(0K0(B")
("dawe"	"$(1Q#(B")
("dbb"	"$(0A}(B")
("dbd"	"$(1<b(B")
("dbm"	"$(1++(B")
("dbo"	"$(1I%(B")
("dbt"	"$(03a(B")
("dbu"	"$(04_(B")
("dbv"	"$(16"(B")
("dbac"	"$(1Jh(B")
("dbbb"	"$(1Jt(B")
("dbcd"	"$(1<r(B")
("dbcv"	"$(0\q(B")
("dbdb"	"$(0AlAm(B")
("dbgr"	"$(1<y(B")
("dbhx"	"$(1Jw(B")
("dbjj"	"$(1CS(B")
("dbkf"	"$(1WZ(B")
("dbln"	"$(0./(B")
("dbmc"	"$(1<a(B")
("dbme"	"$(1Cd(B")
("dbmr"	"$(08*(B")
("dbnd"	"$(16#(B")
("dbou"	"$(0K9(B")
("dbsd"	"$(1<v(B")
("dbse"	"$(1<w(B")
("dbtu"	"$(1<`(B")
("dbuc"	"$(160(B")
("dbug"	"$(1mT(B")
("dbvk"	"$(1Jx(B")
("dci"	"$(005(B")
("dcav"	"$(1at(B")
("dchd"	"$(1<|(B")
("dcip"	"$(1<~(B")
("dcms"	"$(1'?(B")
("dcnh"	"$(0=/(B")
("dcru"	"$(16$(B")
("dcsh"	"$(1'@(B")
("dcwa"	"$(1WL(B")
("ddb"	"$(1/f(B")
("ddd"	"$(0Aq(B")
("ddf"	"$(0BP(B")
("ddg"	"$(145(B")
("ddh"	"$(0,Z(B")
("ddi"	"$(0,[(B")
("ddj"	"$(1+"(B")
("ddk"	"$(0O>(B")
("ddl"	"$(16,(B")
("ddp"	"$(0Ua(B")
("ddv"	"$(0;c(B")
("ddw"	"$(1E.$(0Ao(B")
("ddam"	"$(1CZ(B")
("ddbuh"	"$(0_I(B")
("ddcsh"	"$(1<m(B")
("dddo"	"$(1]4(B")
("ddec"	"$(1ar(B")
("ddhe"	"$(1+'(B")
("ddhh"	"$(0<3(B")
("ddhni"	"$(1]7$(0=2(B")
("ddixp"	"$(0[_(B")
("ddkq"	"$(0Z8(B")
("ddkli"	"$(1l5(B")
("ddkmr"	"$(0\!(B")
("ddln"	"$(1Cr(B")
("ddlo"	"$(1Px(B")
("ddmq"	"$(1Cw(B")
("ddmmf"	"$(0G\(B")
("ddnl"	"$(19p(B")
("ddnyo"	"$(0FH(B")
("ddoo"	"$(1<\(B")
("ddoin"	"$(1<l(B")
("ddwf"	"$(0FV(B")
("dei"	"$(1$D(B")
("deee"	"$(1<_(B")
("defh"	"$(16)(B")
("deid"	"$(0OC(B")
("demj"	"$(1(8(B")
("dembc"	"$(0Mj(B")
("depru"	"$(08u(B")
("dfb"	"$(0=0(B")
("dff"	"$(1<U(B")
("dfh"	"$(00;(B")
("dfq"	"$(1+!(B")
("dfbd"	"$(1Wd(B")
("dfbf"	"$(1p<(B")
("dfbg"	"$(1Q3(B")
("dfbh"	"$(1We(B")
("dfbw"	"$(0Us(B")
("dfdq"	"$(1WK(B")
("dffn"	"$(1W`(B")
("dffs"	"$(1W_(B")
("dfle"	"$(0X"(B")
("dfmu"	"$(1/l(B")
("dfqu"	"$(1<T(B")
("dgb"	"$(1+,(B")
("dgg"	"$(08!(B")
("dgr"	"$(08"(B")
("dgce"	"$(1<V(B")
("dggi"	"$(1Pw(B")
("dggu"	"$(0S$(B")
("dgit"	"$(1Jm(B")
("dgni"	"$(0XT(B")
("dgov"	"$(1WO(B")
("dgow"	"$(0Ux(B")
("dgrg"	"$(0XU(B")
("dgrv"	"$(1Jl(B")
("dgti"	"$(0Rz(B")
("dgwc"	"$(0Z=(B")
("dha"	"$(03j(B")
("dhe"	"$(0(w03(B")
("dhi"	"$(0K3(B")
("dhn"	"$(1"T(B")
("dhs"	"$(03k(B")
("dhab"	"$(0A|(B")
("dhag"	"$(1Cz(B")
("dhaj"	"$(1Jz(B")
("dhal"	"$(0Uw(B")
("dhbul"	"$(1\C(B")
("dhcq"	"$(1k`(B")
("dhdf"	"$(1Cf(B")
("dhdw"	"$(1Wg(B")
("dhej"	"$(166(B")
("dher"	"$(08,(B")
("dhey"	"$(1+C(B")
("dhge"	"$(1]+(B")
("dhgr"	"$(16%(B")
("dhhh"	"$(0,_(B")
("dhhi"	"$(0K5(B")
("dhhj"	"$(1<f(B")
("dhhl"	"$(03l(B")
("dhhw"	"$(0K2(B")
("dhhaf"	"$(1pt(B")
("dhij"	"$(1an(B")
("dhio"	"$(1+B(B")
("dhja"	"$(1am(B")
("dhjd"	"$(08.(B")
("dhje"	"$(1Cg(B")
("dhjm"	"$(1Ce(B")
("dhjr"	"$(1/n(B")
("dhju"	"$(1Cj(B")
("dhkb"	"$(0R~(B")
("dhlb"	"$(1Ci(B")
("dhlc"	"$(1ee(B")
("dhml"	"$(006(B")
("dhmu"	"$(0=>(B")
("dhmy"	"$(03p(B")
("dhne"	"$(1'H(B")
("dhni"	"$(1$H$(0FS(B")
("dhon"	"$(1C{$(082(B")
("dhoo"	"$(0OA(B")
("dhpa"	"$(1<zWY(B")
("dhpm"	"$(03o(B")
("dhqo"	"$(1+3(B")
("dhqu"	"$(1'<(B")
("dhsb"	"$(1Ck(B")
("dhsk"	"$(0Ut(B")
("dhsu"	"$(1Q9(B")
("dhuc"	"$(1o1(B")
("dhus"	"$(1e_(B")
("dhuu"	"$(0S!(B")
("dhvo"	"$(1+7(B")
("dhxo"	"$(1<d(B")
("dhyg"	"$(1Q7(B")
("dhyu"	"$(1J{(B")
("dii"	"$(0Ar(B")
("dip"	"$(1$A(B")
("dit"	"$(0=8(B")
("diav"	"$(15s(B")
("dibi"	"$(1Jn(B")
("dice"	"$(0=;(B")
("digi"	"$(0Z<(B")
("dihf"	"$(0OB(B")
("dihr"	"$(1Cs(B")
("diih"	"$(1Q&(B")
("diil"	"$(0FF(B")
("dije"	"$(0=C(B")
("dikk"	"$(1+<(B")
("dilb"	"$(1Q,(B")
("dill"	"$(1/q(B")
("diln"	"$(1!L(B")
("dilr"	"$(1Jf(B")
("dimo"	"$(1/r(B")
("dine"	"$(1e[(B")
("ding"	"$(1K!(B")
("dipc"	"$(1WM(B")
("dipm"	"$(1/a(B")
("dirm"	"$(1<Z(B")
("djc"	"$(1+:(B")
("dje"	"$(00/(B")
("djk"	"$(0,](B")
("djp"	"$(1*}(B")
("djr"	"$(03`(B")
("djv"	"$(1/^(B")
("djbc"	"$(1K&(B")
("djbd"	"$(16*(B")
("djbj"	"$(0FJ(B")
("djbm"	"$(0Ay(B")
("djcm"	"$(1<O(B")
("djcr"	"$(0K)(B")
("djcs"	"$(0K((B")
("djhr"	"$(1Cn(B")
("djii"	"$(1Q0(B")
("djip"	"$(1Wc(B")
("djji"	"$(1WR(B")
("djka"	"$(0A~(B")
("djkp"	"$(1/`(B")
("djks"	"$(1/_(B")
("djlv"	"$(0Au(B")
("djmc"	"$(0XN(B")
("djmf"	"$(0Aj(B")
("djmm"	"$(1CP(B")
("djmo"	"$(1<q(B")
("djmu"	"$(0=B(B")
("djpa"	"$(1Jk(B")
("djpn"	"$(0XR(B")
("djrb"	"$(1Ct(B")
("djrj"	"$(1WQ(B")
("djrr"	"$(0Ai(B")
("djtc"	"$(1WN(B")
("dkb"	"$(1/j(B")
("dkn"	"$(1/b"Q(B")
("dkp"	"$(1W%(B")
("dks"	"$(1"R(B")
("dkce"	"$(1Q$(B")
("dkcf"	"$(1WT(B")
("dkgg"	"$(1Cu(B")
("dkhf"	"$(167(B")
("dkhaf"	"$(1nq(B")
("dkkb"	"$(165(B")
("dkkk"	"$(1Q1(B")
("dkld"	"$(1/h(B")
("dkmr"	"$(0An(B")
("dkms"	"$(1/t(B")
("dkmym"	"$(0Rm(B")
("dkok"	"$(1Jg(B")
("dkoo"	"$(15v(B")
("dkso"	"$(1P}(B")
("dksr"	"$(1ap+((B")
("dld"	"$(169(B")
("dle"	"$(0Av(B")
("dlp"	"$(1;n(B")
("dlw"	"$(03g(B")
("dlx"	"$(1WV(B")
("dlbk"	"$(1+.(B")
("dlbu"	"$(00)(B")
("dlha"	"$(1E=(B")
("dlksf"	"$(1k,(B")
("dlln"	"$(1+*$(02+(B")
("dllmi"	"$(1Mz(B")
("dlmc"	"$(1WW(B")
("dlmo"	"$(08-(B")
("dlmy"	"$(1<x(B")
("dlno"	"$(16;(B")
("dlok"	"$(0<z(B")
("dlshc"	"$(0TK(B")
("dlwl"	"$(1+@(B")
("dlws"	"$(15~(B")
("dlwv"	"$(0O=(B")
("dlxl"	"$(1<{(B")
("dmd"	"$(1$?(B")
("dmf"	"$(001(B")
("dmg"	"$(004(B")
("dmj"	"$(0,`(B")
("dmn"	"$(1"P(B")
("dmr"	"$(1+&(B")
("dmt"	"$(1'5(B")
("dmu"	"$(1$C(B")
("dmam"	"$(07}(B")
("dmbb"	"$(1al(B")
("dmbc"	"$(0K,(B")
("dmbe"	"$(1e\(B")
("dmbl"	"$(1/i(B")
("dmbm"	"$(1r,(B")
("dmbr"	"$(0\s(B")
("dmbs"	"$(1Pu(B")
("dmbw"	"$(1]1(B")
("dmcw"	"$(1/d(B")
("dmdm"	"$(1i%(B")
("dmem"	"$(0FL(B")
("dmfb"	"$(1aq(B")
("dmfj"	"$(03m(B")
("dmfm"	"$(1+%(B")
("dmfn"	"$(1]3(B")
("dmfr"	"$(15x(B")
("dmgr"	"$(1i)(B")
("dmgt"	"$(15t(B")
("dmhf"	"$(1K%(B")
("dmia"	"$(1K'(B")
("dmig"	"$(1/k(B")
("dmjk"	"$(0R{(B")
("dmlk"	"$(0=7(B")
("dmlm"	"$(1<W(B")
("dmmf"	"$(1+8(B")
("dmmi"	"$(1'B(B")
("dmmp"	"$(0^<(B")
("dmmr"	"$(0=6(B")
("dmms"	"$(1$@(B")
("dmmu"	"$(1'6(B")
("dmmv"	"$(15w(B")
("dmnl"	"$(1/c(B")
("dmnn"	"$(1/g(B")
("dmnr"	"$(03c(B")
("dmob"	"$(03d(B")
("dmrq"	"$(05v(B")
("dmrt"	"$(16+(B")
("dmrw"	"$(1CW(B")
("dmso"	"$(1<](B")
("dmsu"	"$(1'D(B")
("dmsmm"	"$(18C(B")
("dmto"	"$(1WS(B")
("dmue"	"$(1Jp(B")
("dmvh"	"$(1'8(B")
("dmvm"	"$(16-'C(B")
("dmvs"	"$(0*6(B")
("dmvvq"	"$(1FJ(B")
("dmwc"	"$(1]&(B")
("dmwf"	"$(1Py$(0O:(B")
("dmwj"	"$(1WP(B")
("dmwm"	"$(1]2(B")
("dnd"	"$(0,X$(1$F(B")
("dng"	"$(1':(B")
("dno"	"$(1'>(B")
("dnq"	"$(1C>(B")
("dnao"	"$(0R}(B")
("dnbg"	"$(16&(B")
("dnbj"	"$(1Q%(B")
("dnbq"	"$(1])(B")
("dncr"	"$(0U{(B")
("dndf"	"$(1K)(B")
("dnfd"	"$(1i*(B")
("dnhb"	"$(0Ry(B")
("dnhd"	"$(1C]C\(B")
("dnhe"	"$(1'G(B")
("dnib"	"$(0=4(B")
("dnin"	"$(00:81(B")
("dnkg"	"$(0=9(B")
("dnkm"	"$(1<e(B")
("dnkq"	"$(1C[(B")
("dnlb"	"$(0R|(B")
("dnlw"	"$(1Q2(B")
("dnmu"	"$(08/(B")
("dnob"	"$(1C^(B")
("dnok"	"$(1Cv(B")
("dnot"	"$(0Rw(B")
("dnqd"	"$(1Jy(B")
("dnri"	"$(1k_(B")
("dnst"	"$(0FT(B")
("dnwa"	"$(0Z?(B")
("dob"	"$(1';(B")
("doe"	"$(16((B")
("dog"	"$(0A{(B")
("doj"	"$(007(B")
("dok"	"$(008(B")
("don"	"$(1$G(B")
("doo"	"$(0-u(B")
("dop"	"$(1'I(B")
("dobg"	"$(0K/(B")
("doby"	"$(1/m(B")
("dobuc"	"$(1TW(B")
("dodi"	"$(1+6(B")
("dogf"	"$(0S"(B")
("dogj"	"$(0K1(B")
("dogs"	"$(1]*(B")
("dohaf"	"$(1hO(B")
("doii"	"$(1+D(B")
("doik"	"$(1>!(B")
("doim"	"$(1k^(B")
("doin"	"$(1'J(B")
("doip"	"$(1<g(B")
("doir"	"$(16'$(0K4(B")
("dokr"	"$(1<}(B")
("dolb"	"$(1Q8(B")
("doma"	"$(0Uv(B")
("domb"	"$(1<h(B")
("domd"	"$(168(B")
("domg"	"$(080(B")
("domk"	"$(1Ch(B")
("domn"	"$(0FU(B")
("domo"	"$(0Uu(B")
("donl"	"$(19q(B")
("doog"	"$(16:(B")
("dopd"	"$(1+4(B")
("dowy"	"$(0==(B")
("doyb"	"$(1],(B")
("dpa"	"$(1/o/u(B")
("dpd"	"$(1$E(B")
("dph"	"$(1*~(B")
("dpi"	"$(1'=$(0,b(B")
("dpp"	"$(00.(B")
("dpr"	"$(03i(B")
("dpt"	"$(1+$(B")
("dpu"	"$(1'9(B")
("dpfd"	"$(1<c(B")
("dpht"	"$(1K"(B")
("dpim"	"$(1'E(B")
("dppa"	"$(0FI(B")
("dppg"	"$(15u(B")
("dpru"	"$(1+5(B")
("dptd"	"$(1CX(B")
("dqo"	"$(1'7(B")
("dqbhx"	"$(0[I(B")
("dqbjj"	"$(1dP(B")
("dqdj"	"$(1O3(B")
("dqgwc"	"$(1pb(B")
("dqhk"	"$(0FK(B")
("dqhaj"	"$(1gs(B")
("dqikk"	"$(1O4(B")
("dqjl"	"$(0=<(B")
("dqjm"	"$(1Pv(B")
("dqka"	"$(1CV(B")
("dqkd"	"$(0K.(B")
("dqkk"	"$(1CU(B")
("dqkq"	"$(0At(B")
("dqkx"	"$(0O8(B")
("dqmb"	"$(1<s(B")
("dqmc"	"$(1Q.(B")
("dqmf"	"$(1K$(B")
("dqnl"	"$(1@z(B")
("dqnhd"	"$(1dR(B")
("dqou"	"$(1Q-(B")
("dqomr"	"$(1U^(B")
("dqptd"	"$(1dS(B")
("dqshi"	"$(0Dz(B")
("dqsmv"	"$(1`P(B")
("dqtmj"	"$(1la(B")
("dqttb"	"$(1gq(B")
("dqwli"	"$(1nC(B")
("dqwot"	"$(1gr(B")
("dqyrd"	"$(1`O(B")
("drb"	"$(161(B")
("drc"	"$(1+/(B")
("drhg"	"$(15|(B")
("drhr"	"$(162(B")
("drhs"	"$(1+A(B")
("drhu"	"$(1+0(B")
("drms"	"$(1+-(B")
("drrd"	"$(0Uy(B")
("drrj"	"$(1WX(B")
("drsh"	"$(03f(B")
("drsj"	"$(0FQ(B")
("drye"	"$(1C`(B")
("dsj"	"$(1/s(B")
("dsp"	"$(1+)(B")
("dss"	"$(1+#(B")
("dsu"	"$(0,^(B")
("dsav"	"$(1Cq(B")
("dsfb"	"$(1Jr(B")
("dsit"	"$(0XQ(B")
("dsje"	"$(1<Y(B")
("dsjl"	"$(0FM(B")
("dsjr"	"$(1<^(B")
("dskr"	"$(16.(B")
("dslc"	"$(0XP(B")
("dsly"	"$(1Jq(B")
("dsma"	"$(1P~(B")
("dsme"	"$(15z(B")
("dsmg"	"$(07|XS(B")
("dsmh"	"$(1Q!(B")
("dsmm"	"$(08#(B")
("dsmr"	"$(1+=(B")
("dsmv"	"$(1<X(B")
("dsnd"	"$(1Wb(B")
("dsno"	"$(03b(B")
("dsqf"	"$(1K#(B")
("dsql"	"$(16/(B")
("dsrg"	"$(1]%(B")
("dsrr"	"$(0O9(B")
("dssr"	"$(15y(B")
("dstv"	"$(1K((B")
("dswu"	"$(0_$(B")
("dsyi"	"$(1q#(B")
("dsyq"	"$(1WU(B")
("dta"	"$(1<[(B")
("dtc"	"$(1/e(B")
("dtk"	"$(1/](B")
("dtm"	"$(03e(B")
("dtt"	"$(1/\(B")
("dtak"	"$(0O<(B")
("dtaw"	"$(1q%(B")
("dtbo"	"$(0XO(B")
("dtce"	"$(1mV(B")
("dtco"	"$(0Ru(B")
("dtcw"	"$(1CT(B")
("dtei"	"$(1k](B")
("dtge"	"$(0O5(B")
("dtgf"	"$(1J}(B")
("dtgi"	"$(1]$(B")
("dtgo"	"$(1]/(B")
("dtgr"	"$(1W](B")
("dthj"	"$(1Q4(B")
("dtjr"	"$(0FX(B")
("dtkr"	"$(1C_(B")
("dtlb"	"$(1P{(B")
("dtlm"	"$(1P|(B")
("dtlx"	"$(1i'(B")
("dtmc"	"$(0RxAw(B")
("dtmj"	"$(0Rv(B")
("dtmv"	"$(1CY(B")
("dtoe"	"$(1as(B")
("dtor"	"$(1Jo(B")
("dtpa"	"$(1K,(B")
("dtqm"	"$(1Ji(B")
("dtrg"	"$(0]c(B")
("dtsj"	"$(1K*(B")
("dtsr"	"$(1e^(B")
("dttb"	"$(0K-(B")
("dttc"	"$(1<S(B")
("dtwa"	"$(0O;(B")
("dtwi"	"$(0Rt(B")
("dtxc"	"$(1J~(B")
("dup"	"$(0Ex(B")
("duu"	"$(1+2(B")
("duch"	"$(164(B")
("dulmi"	"$(191(B")
("dumb"	"$(1Cy(B")
("dumt"	"$(1Jv(B")
("duob"	"$(1mU(B")
("duon"	"$(15}(B")
("duvif"	"$(0>U(B")
("dvl"	"$(1"S(B")
("dvfo"	"$(1ef(B")
("dvid"	"$(1e`(B")
("dvii"	"$(0S#(B")
("dvis"	"$(1+E(B")
("dvmg"	"$(163(B")
("dvno"	"$(1Cc(B")
("dvoi"	"$(1q&(B")
("dvvd"	"$(1Q'(B")
("dvvw"	"$(1<i(B")
("dwc"	"$(1+1(B")
("dwd"	"$(0Ap=5(B")
("dwf"	"$(03^(B")
("dwg"	"$(16!(B")
("dwl"	"$(03n(B")
("dwp"	"$(1Cx(B")
("dwhd"	"$(1<u(B")
("dwhaf"	"$(1h_(B")
("dwim"	"$(1Q6(B")
("dwjr"	"$(1<t(B")
("dwlg"	"$(1o3(B")
("dwlj"	"$(1]((B")
("dwls"	"$(0FR(B")
("dwly"	"$(1]6(B")
("dwmv"	"$(1Cb(B")
("dwvf"	"$(1Q5(B")
("dwwf"	"$(1q$(B")
("dwww"	"$(1e](B")
("dyg"	"$(03[(B")
("dyj"	"$(009(B")
("dyr"	"$(1+>(B")
("dyt"	"$(1+;(B")
("dyx"	"$(1aj(B")
("dyaj"	"$(0As(B")
("dybb"	"$(1Co]'(B")
("dybc"	"$(0FP(B")
("dybp"	"$(1i#(B")
("dybs"	"$(0K'(B")
("dycb"	"$(1Ps(B")
("dyck"	"$(07y(B")
("dydk"	"$(1W^(B")
("dydl"	"$(0O7(B")
("dydu"	"$(0[t(B")
("dyfe"	"$(0Az(B")
("dyhh"	"$(1Cp(B")
("dyhn"	"$(00'(B")
("dyhr"	"$(0K6(B")
("dyhs"	"$(00((B")
("dyia"	"$(1WI(B")
("dyiu"	"$(08$(B")
("dyjj"	"$(1Pz(B")
("dylb"	"$(03Y(B")
("dymh"	"$(1]5(B")
("dymu"	"$(1ed(B")
("dynv"	"$(1Wa(B")
("dyoj"	"$(1<p(B")
("dypk"	"$(1Js(B")
("dypm"	"$(1Q"(B")
("dypt"	"$(1i&(B")
("dyra"	"$(1eZ(B")
("dyrb"	"$(0K*(B")
("dyrf"	"$(1<o(B")
("dyrn"	"$(1CQ(B")
("dyro"	"$(1ao(B")
("dyrv"	"$(1ka(B")
("dysd"	"$(1CR(B")
("dysr"	"$(1ak(B")
("dysy"	"$(1<R(B")
("dytg"	"$(1WJ(B")
("dytj"	"$(0O6=1(B")
("dyto"	"$(1]"(B")
("dytp"	"$(1]!(B")
("dytr"	"$(1<P(B")
("dytu"	"$(1Q+]0(B")
("dytv"	"$(1<Q(B")
("dyub"	"$(1Pt(B")
("dyut"	"$(1Q*(B")
("dyvo"	"$(07z(B")
("dywd"	"$(1]#(B")
("dywm"	"$(0Ur(B")
("dywv"	"$(1Jei$(B")
("e"	"$(0'V(B")
("ea"	"$(0,s$(1$T'P(B")
("ec"	"$(1!a$(0=n(B")
("ed"	"$(0,p(B")
("ee"	"$(1'e(B")
("eg"	"$(1!P(B")
("ei"	"$(0&G(B")
("ej"	"$(0(e(B")
("ek"	"$(1"\(B")
("el"	"$(0,t(B")
("em"	"$(0*A(B")
("ep"	"$(0,i(B")
("er"	"$(1#F(B")
("eu"	"$(0*D(B")
("ev"	"$(0*>(B")
("ew"	"$(1'\(B")
("eaa"	"$(16d(B")
("eag"	"$(08N(B")
("eam"	"$(1'm(B")
("eafc"	"$(1q]p?(B")
("eafu"	"$(1D;(B")
("eagi"	"$(1DK(B")
("eahm"	"$(1=Z(B")
("eahu"	"$(0BK(B")
("eaiu"	"$(0BG(B")
("eamh"	"$(0B>(B")
("eami"	"$(16a(B")
("eamj"	"$(108(B")
("eamk"	"$(16b(B")
("eamo"	"$(1=G(B")
("eana"	"$(0OX(B")
("eand"	"$(1QQ(B")
("eane"	"$(1i9(B")
("eang"	"$(0OW(B")
("eanj"	"$(1o5(B")
("eank"	"$(1Qh(B")
("eanw"	"$(0[u(B")
("eapp"	"$(0=\(B")
("eapv"	"$(0B?(B")
("eate"	"$(0X^(B")
("eavf"	"$(0V/(B")
("eawe"	"$(0KQ(B")
("eayf"	"$(1Qd(B")
("ebb"	"$(16W(B")
("ebm"	"$(00U(B")
("ebp"	"$(0XB$(1aT(B")
("ebr"	"$(1'[(B")
("ebv"	"$(10K(B")
("ebac"	"$(1D0(B")
("ebau"	"$(16X(B")
("ebbb"	"$(0Fm(B")
("ebbr"	"$(0B=(B")
("ebbu"	"$(1K_(B")
("ebcd"	"$(0=f(B")
("ebci"	"$(0X](B")
("ebcn"	"$(0BB(B")
("ebcr"	"$(1DE0J(B")
("ebcv"	"$(1i/(B")
("ebgr"	"$(16i(B")
("ebhg"	"$(0=c(B")
("ebhu"	"$(0,k(B")
("ebhx"	"$(0Fq(B")
("ebjj"	"$(0BE(B")
("ebkf"	"$(1pl(B")
("ebme"	"$(0BL(B")
("ebmp"	"$(1]C(B")
("ebmr"	"$(04#(B")
("ebnd"	"$(08G(B")
("ebof"	"$(1K`(B")
("ebsd"	"$(0=h(B")
("ebuc"	"$(107(B")
("ebug"	"$(1keX-(B")
("ebuh"	"$(0BA(B")
("ebuk"	"$(1=F(B")
("ebul"	"$(1Wy(B")
("ebuu"	"$(10F(B")
("ebvk"	"$(0Fr(B")
("ebwi"	"$(1i1(B")
("ebyh"	"$(10L(B")
("ecc"	"$(1`;(B")
("ecr"	"$(00Y(B")
("ecim"	"$(1DC(B")
("eckg"	"$(1D@(B")
("ecnh"	"$(08=(B")
("ecor"	"$(08I(B")
("ecru"	"$(10<(B")
("ecsh"	"$(0,y(B")
("ecst"	"$(1=Q(B")
("ecwa"	"$(1Qa(B")
("edd"	"$(0=U(B")
("edg"	"$(0EV(B")
("edj"	"$(00N(B")
("edk"	"$(0,o(B")
("edl"	"$(104(B")
("edm"	"$(1'j(B")
("edw"	"$(16M(B")
("edam"	"$(0B5(B")
("edbt"	"$(17K(B")
("edbu"	"$(0B8(B")
("edci"	"$(0=Y(B")
("eddf"	"$(1X*(B")
("eddg"	"$(1KZ(B")
("eddh"	"$(1rB(B")
("eddn"	"$(1K[(B")
("eddo"	"$(1Wu(B")
("edgg"	"$(1DH(B")
("edhe"	"$(00M(B")
("edhl"	"$(0=^(B")
("edlc"	"$(0ZB(B")
("edlo"	"$(0KL(B")
("edmf"	"$(1=9(B")
("edmq"	"$(1=?(B")
("edmbc"	"$(1gu(B")
("edoe"	"$(0KK(B")
("edoo"	"$(16N(B")
("edwf"	"$(1=6(B")
("eea"	"$(16U(B")
("eee"	"$(1=.(B")
("eei"	"$(1"](B")
("eev"	"$(0;h(B")
("eeed"	"$(08'(B")
("eeeee"	"$(1<;(B")
("eeeef"	"$(1hR(B")
("eeeen"	"$(1..(B")
("eeeeo"	"$(1=$(B")
("eeeeu"	"$(1=+(B")
("eeii"	"$(1D:(B")
("eemr"	"$(1ES(B")
("eetb"	"$(1b&(B")
("efb"	"$(08>(B")
("eff"	"$(0=N(B")
("efh"	"$(0,h(B")
("efq"	"$(1'S(B")
("efbg"	"$(1K](B")
("efbk"	"$(1K@(B")
("efbr"	"$(0=O(B")
("efbw"	"$(1X,(B")
("efdc"	"$(1i,(B")
("efdq"	"$(1QF(B")
("effe"	"$(1]=(B")
("efff"	"$(1el(B")
("effg"	"$(1a|(B")
("effr"	"$(1i-(B")
("effs"	"$(1QG(B")
("efhu"	"$(1=B(B")
("efmu"	"$(04-(B")
("efqf"	"$(1Q_(B")
("egg"	"$(1+TB8(B")
("egi"	"$(00O(B")
("egj"	"$(0Fn(B")
("egr"	"$(1+b(B")
("egce"	"$(16K(B")
("egcg"	"$(16`(B")
("egde"	"$(1]Ea}(B")
("egfe"	"$(1en(B")
("eggu"	"$(0OO(B")
("egit"	"$(0Fi(B")
("eglc"	"$(10E(B")
("egni"	"$(0V((B")
("egow"	"$(1Ww(B")
("egrv"	"$(1DG(B")
("egsk"	"$(1KX(B")
("egth"	"$(0OT(B")
("egti"	"$(1QJ(B")
("egtj"	"$(16J(B")
("egwc"	"$(0X\(B")
("eha"	"$(00](B")
("ehe"	"$(1$[(B")
("ehf"	"$(0S>(B")
("ehi"	"$(1DB(B")
("ehk"	"$(0,w(B")
("ehq"	"$(15K(B")
("ehv"	"$(06t(B")
("ehag"	"$(0BN(B")
("ehaj"	"$(1DD(B")
("ehal"	"$(1X#(B")
("ehar"	"$(1QZ(B")
("ehbk"	"$(0S/(B")
("ehbn"	"$(16Y(B")
("ehbt"	"$(0VF42(B")
("ehbu"	"$(041$(1o6(B")
("ehby"	"$(1+_(B")
("ehcn"	"$(0X_(B")
("ehdb"	"$(1QV(B")
("ehde"	"$(1Qk(B")
("ehdf"	"$(1=M(B")
("ehdn"	"$(10=(B")
("ehdp"	"$(1DP(B")
("ehdw"	"$(0OY(B")
("eheq"	"$(1+](B")
("eher"	"$(04)(B")
("ehet"	"$(1b'(B")
("ehgr"	"$(08J(B")
("ehgu"	"$(04$(B")
("ehhl"	"$(00a(B")
("ehhv"	"$(04'(B")
("ehhw"	"$(0Fo(B")
("ehio"	"$(00\(B")
("ehjd"	"$(1+[(B")
("ehjg"	"$(0BM(B")
("ehjr"	"$(04%(B")
("ehkp"	"$(0=Q(B")
("ehlq"	"$(1Qi(B")
("ehml"	"$(0-"(B")
("ehmo"	"$(1X"(B")
("ehmr"	"$(1>S+m(B")
("ehmy"	"$(1'b(B")
("ehmgi"	"$(1]S(B")
("ehni"	"$(1=O$(0*H(B")
("ehnn"	"$(1+j(B")
("ehnwf"	"$(0Z!(B")
("ehoe"	"$(1Q[(B")
("ehon"	"$(1+n(B")
("ehoo"	"$(1KSKT(B")
("ehpa"	"$(16\(B")
("ehpm"	"$(00`(B")
("ehqi"	"$(10M(B")
("ehqj"	"$(0BC(B")
("ehqm"	"$(1'o(B")
("ehqo"	"$(1'^(B")
("ehrb"	"$(1DQ(B")
("ehsd"	"$(16](B")
("ehsk"	"$(0S0=b(B")
("ehsu"	"$(0KU(B")
("ehuc"	"$(1erm[(B")
("ehuk"	"$(0Ft(B")
("ehul"	"$(1]D(B")
("ehvo"	"$(1'a(B")
("ehvp"	"$(1$Z(B")
("ehxe"	"$(1DA(B")
("ehxf"	"$(0O](B")
("ehxu"	"$(16j(B")
("ehyhv"	"$(0HN(B")
("eid"	"$(0=.(B")
("eii"	"$(0=R(B")
("eik"	"$(1$R(B")
("eir"	"$(00Z(B")
("eiv"	"$(1'X(B")
("eiav"	"$(08<(B")
("eibi"	"$(0Fh(B")
("eice"	"$(08H(B")
("eidy"	"$(1mY(B")
("eifd"	"$(0Gl(B")
("eihf"	"$(0Fg(B")
("eihq"	"$(1+i(B")
("eihr"	"$(0B6(B")
("eihu"	"$(1$W(B")
("eiih"	"$(0KW(B")
("eijb"	"$(08@(B")
("eijc"	"$(1'W(B")
("eikf"	"$(1=3(B")
("eikk"	"$(1'Y(B")
("eiku"	"$(1$P(B")
("eilb"	"$(1KW(B")
("eile"	"$(1K>(B")
("eill"	"$(03{(B")
("eilr"	"$(1D.(B")
("eilmi"	"$(0:*(B")
("eine"	"$(00E(B")
("eioc"	"$(1X'(B")
("eiok"	"$(10A(B")
("eipf"	"$(1ay(B")
("eirm"	"$(16L(B")
("eirp"	"$(1X+(B")
("eitc"	"$(1ax$(0S((B")
("eite"	"$(0B/(B")
("eiwg"	"$(1az(B")
("eixp"	"$(1K?(B")
("ejb"	"$(0,m(B")
("ejc"	"$(1'Q(B")
("ejd"	"$(10C$(00^(B")
("eje"	"$(1$\(B")
("ejp"	"$(00F(B")
("ejr"	"$(00J(B")
("ejv"	"$(1+`(B")
("ejbc"	"$(0Ff(B")
("ejbd"	"$(10.(B")
("ejbj"	"$(1=<(B")
("ejbm"	"$(16O(B")
("ejbv"	"$(1q'(B")
("ejcb"	"$(0OR(B")
("ejck"	"$(1=R(B")
("ejcm"	"$(16H(B")
("ejco"	"$(1D+(B")
("ejcr"	"$(0Fb(B")
("ejds"	"$(0B9(B")
("ejhf"	"$(0XY(B")
("ejhq"	"$(10,(B")
("ejhw"	"$(0XZ(B")
("ejic"	"$(1i7(B")
("ejii"	"$(1KA(B")
("ejik"	"$(10D(B")
("ejip"	"$(1Qc(B")
("ejir"	"$(1=5(B")
("ejjb"	"$(0OS(B")
("ejjj"	"$(1]?Wv(B")
("ejjl"	"$(0KM(B")
("ejjm"	"$(0ZC(B")
("ejjn"	"$(1KC(B")
("ejka"	"$(0=`(B")
("ejkd"	"$(105(B")
("ejki"	"$(10+(B")
("ejks"	"$(1+c(B")
("ejlv"	"$(0=_(B")
("ejmc"	"$(0V$K>(B")
("ejme"	"$(1K8(B")
("ejmf"	"$(0=L(B")
("ejmm"	"$(0B0(B")
("ejmn"	"$(1'g(B")
("ejmo"	"$(16E(B")
("ejmu"	"$(10*(B")
("ejnu"	"$(16G(B")
("ejpn"	"$(0V#(B")
("ejpu"	"$(1K7(B")
("ejqp"	"$(1es(B")
("ejrb"	"$(0B:(B")
("ejrr"	"$(16F(B")
("ejtc"	"$(1QH(B")
("ejye"	"$(1K9(B")
("ejyj"	"$(0Fa(B")
("ekb"	"$(04,(B")
("ekc"	"$(1U@(B")
("ekf"	"$(1+e(B")
("eki"	"$(0,q$(1$S(B")
("ekn"	"$(1+S!b(B")
("eks"	"$(1!c(B")
("ekcf"	"$(0OM(B")
("ekhr"	"$(0KT(B")
("ekjt"	"$(16P(B")
("ekkb"	"$(10;$(0=i(B")
("ekkk"	"$(1K\(B")
("ekld"	"$(1+W(B")
("eklu"	"$(0=Z(B")
("ekms"	"$(1+U(B")
("ekni"	"$(0*G(B")
("ekoo"	"$(08M(B")
("ekpb"	"$(0KJ(B")
("eksr"	"$(1'k(B")
("elg"	"$(1.S(B")
("elq"	"$(03~(B")
("elw"	"$(00S(B")
("elx"	"$(1QP(B")
("elbk"	"$(00X(B")
("elbu"	"$(0,j(B")
("elgm"	"$(1QO(B")
("elhi"	"$(1pe(B")
("elim"	"$(1mZ=I(B")
("elll"	"$(1"`$Y(B")
("elln"	"$(00Q(B")
("ellp"	"$(1KI(B")
("elmc"	"$(0OV(B")
("elmo"	"$(04/(B")
("elmt"	"$(1]@(B")
("elvu"	"$(1=](B")
("elwp"	"$(04.(B")
("elws"	"$(10G(B")
("elwv"	"$(1KH(B")
("elxh"	"$(1'`(B")
("elxl"	"$(0=](B")
("emd"	"$(0*@(B")
("emg"	"$(0,n(B")
("emj"	"$(0*?(B")
("emn"	"$(0(f(B")
("emr"	"$(1'l(B")
("emt"	"$(1$M(B")
("emam"	"$(04+(B")
("embb"	"$(0^aV-(B")
("embe"	"$(1b"(B")
("embg"	"$(1em(B")
("embi"	"$(1X(Qbeu(B")
("embk"	"$(1==(B")
("embl"	"$(1+f(B")
("embu"	"$(1i6(B")
("emcw"	"$(1+V$(0:Y(B")
("emdm"	"$(0ZD(B")
("emfb"	"$(1]>(B")
("emfj"	"$(1'T(B")
("emgg"	"$(0=V(B")
("emgh"	"$(1X)(B")
("emhf"	"$(0X1Fd(B")
("emia"	"$(1DI(B")
("emig"	"$(1+d(B")
("emjk"	"$(1QK(B")
("emlk"	"$(102(B")
("emls"	"$(0,~(B")
("emmc"	"$(1QI(B")
("emmf"	"$(1'U(B")
("emmi"	"$(1$O(B")
("emmp"	"$(0]e(B")
("emmr"	"$(103(B")
("emms"	"$(0*E(B")
("emmu"	"$(0,l(B")
("emnn"	"$(04!(B")
("emnr"	"$(00I(B")
("emoa"	"$(1b$(B")
("emrb"	"$(1D6(B")
("emrr"	"$(1D7(B")
("emrt"	"$(101(B")
("emrw"	"$(1=7(B")
("emso"	"$(0=m(B")
("emtb"	"$(1b!(B")
("emua"	"$(0OQ(B")
("emub"	"$(1kd(B")
("emvb"	"$(1KD(B")
("emvg"	"$(0Fj(B")
("emvi"	"$(1D8(B")
("emvm"	"$(0,}8?(B")
("emwd"	"$(0Fs(B")
("emwf"	"$(0KG(B")
("emwg"	"$(1=X$(0B;(B")
("emwj"	"$(0OP(B")
("emwl"	"$(0BI(B")
("emyf"	"$(1KY(B")
("end"	"$(03Z(B")
("ene"	"$(0,u(B")
("eni"	"$(0*C0P(B")
("enj"	"$(0*F(B")
("enao"	"$(1QW(B")
("enau"	"$(10>(B")
("enbk"	"$(0BH(B")
("enbq"	"$(1X$(B")
("enbs"	"$(0B1(B")
("encr"	"$(0S1(B")
("enhb"	"$(1QN(B")
("enhe"	"$(0,x(B")
("enhx"	"$(16[(B")
("enib"	"$(08K(B")
("enii"	"$(1KF(B")
("enin"	"$(1'f(B")
("enir"	"$(1+\(B")
("enkm"	"$(0=I(B")
("enkq"	"$(1=W(B")
("enlb"	"$(1eo(B")
("enlc"	"$(1b#(B")
("enld"	"$(1D9(B")
("enls"	"$(1'Z(B")
("enmb"	"$(0[v(B")
("enmm"	"$(0Fk(B")
("enmu"	"$(1+k(B")
("ennc"	"$(0S3(B")
("enob"	"$(1=A(B")
("enoe"	"$(0OL(B")
("enok"	"$(1=@(B")
("enot"	"$(0OK(B")
("enqd"	"$(1DN(B")
("enri"	"$(1i4(B")
("ensj"	"$(1=>(B")
("ensv"	"$(0KN(B")
("enue"	"$(0=a(B")
("enwf"	"$(0KV(B")
("eob"	"$(1$V(B")
("eog"	"$(0=g(B")
("eoj"	"$(1$](B")
("eon"	"$(1"^(B")
("eop"	"$(1$^(B")
("eoah"	"$(1Ka(B")
("eobt"	"$(0Bz(B")
("eodi"	"$(1'_(B")
("eodk"	"$(1KQ(B")
("eogd"	"$(1QY(B")
("eogf"	"$(1QX(B")
("eohh"	"$(1'c(B")
("eoii"	"$(00b(B")
("eoik"	"$(1+^(B")
("eoim"	"$(1i2(B")
("eoip"	"$(16^(B")
("eoir"	"$(0Fp(B")
("eokf"	"$(1i3(B")
("eolb"	"$(1KUKR(B")
("eold"	"$(0KX(B")
("eolk"	"$(10?(B")
("eoma"	"$(1X%(B")
("eomb"	"$(1i5$(0=e(B")
("eomd"	"$(10@(B")
("eomm"	"$(1Q\(B")
("eomn"	"$(0BD,v(B")
("eomo"	"$(1X2(B")
("eomr"	"$(04&$(16k(B")
("eomt"	"$(1=P(B")
("eond"	"$(1DO(B")
("eoob"	"$(1DR(B")
("eook"	"$(0[w(B")
("eora"	"$(1Qj(B")
("eosk"	"$(1+l(B")
("eotf"	"$(1QU(B")
("eoto"	"$(0V0(B")
("eowy"	"$(08B(B")
("epa"	"$(040(B")
("epd"	"$(03q*B(B")
("eph"	"$(00G(B")
("epi"	"$(1"_(B")
("epl"	"$(10)(B")
("epp"	"$(0-!(B")
("epr"	"$(1'](B")
("ept"	"$(00R(B")
("epu"	"$(0,r(B")
("epfd"	"$(16h(B")
("ephh"	"$(1$X(B")
("ephp"	"$(16Z(B")
("ephr"	"$(1=2(B")
("epou"	"$(0=d(B")
("eppa"	"$(1=;(B")
("epru"	"$(00[(B")
("epsh"	"$(1$Q(B")
("eptd"	"$(1=8(B")
("epuk"	"$(04((B")
("epyr"	"$(1=N(B")
("eqg"	"$(1:w(B")
("eqhf"	"$(0ON(B")
("eqhl"	"$(08C(B")
("eqjr"	"$(1=L(B")
("eqka"	"$(1=V(B")
("eqkd"	"$(1D4(B")
("eqke"	"$(1DF(B")
("eqkk"	"$(0B2(B")
("eqmb"	"$(0=S(B")
("eqmc"	"$(0KE(B")
("eqmf"	"$(1D5(B")
("eqor"	"$(1=:(B")
("erb"	"$(08D(B")
("erp"	"$(1;^(B")
("eru"	"$(1"[(B")
("erau"	"$(08O(B")
("erbc"	"$(1DM(B")
("erhg"	"$(10:(B")
("erhu"	"$(00T(B")
("erji"	"$(1Wz(B")
("ermr"	"$(1W{(B")
("erpa"	"$(0BJ(B")
("errd"	"$(0S*(B")
("errj"	"$(1QS(B")
("ersj"	"$(1=Y(B")
("eruc"	"$(0O\(B")
("ervk"	"$(10H(B")
("ervp"	"$(00_(B")
("erxu"	"$(0S4(B")
("eryo"	"$(109(B")
("esd"	"$(0B3(B")
("esj"	"$(04"(B")
("esp"	"$(00H(B")
("ess"	"$(1'i(B")
("esu"	"$(0(g(B")
("esbn"	"$(0=X(B")
("esce"	"$(0S)(B")
("eshr"	"$(00L(B")
("eshu"	"$(100(B")
("esim"	"$(0V+(B")
("esip"	"$(08L(B")
("esit"	"$(0V)(B")
("esja"	"$(1KJ(B")
("esjj"	"$(1kc(B")
("esjr"	"$(16_(B")
("eskr"	"$(10/(B")
("esll"	"$(10-(B")
("esmb"	"$(0KF(B")
("esmc"	"$(1i.(B")
("esme"	"$(08A(B")
("esmg"	"$(0V*B4$(1+R(B")
("esmh"	"$(1KE(B")
("esmi"	"$(0O[(B")
("esmj"	"$(1]G(B")
("esmr"	"$(1'h(B")
("esnd"	"$(0OU(B")
("esqf"	"$(1DJ(B")
("esrj"	"$(1Wx(B")
("esrr"	"$(1KB(B")
("esuu"	"$(16Q(B")
("eswu"	"$(1p@(B")
("esyi"	"$(1p=(B")
("etc"	"$(03|(B")
("etk"	"$(1+a(B")
("etm"	"$(1'V(B")
("etq"	"$(03z(B")
("ett"	"$(1$N+Q(B")
("etw"	"$(1+g=[(B")
("etak"	"$(0KD(B")
("etaw"	"$(1p>(B")
("etbc"	"$(16S(B")
("etbn"	"$(0B.(B")
("etbo"	"$(0V'(B")
("etca"	"$(1Q`(B")
("etcd"	"$(1X1(B")
("etcf"	"$(1]F(B")
("etcl"	"$(1QL(B")
("etct"	"$(0F_(B")
("etcu"	"$(0B,(B")
("etge"	"$(0KC(B")
("etgf"	"$(1D2(B")
("etgi"	"$(1]B(B")
("etgk"	"$(1=4(B")
("etgt"	"$(1]A(B")
("etif"	"$(1i8(B")
("etit"	"$(1KM(B")
("etkr"	"$(1=C(B")
("etlb"	"$(0KI(B")
("etlk"	"$(1=\(B")
("etlo"	"$(0KH(B")
("etlx"	"$(0ZA(B")
("etmc"	"$(1QM$(0=T(B")
("etmj"	"$(1Qg(B")
("etmr"	"$(1=D(B")
("etmv"	"$(0B7(B")
("etoe"	"$(0V.(B")
("etog"	"$(0]f(B")
("etov"	"$(1a{(B")
("etpp"	"$(1X/(B")
("etqm"	"$(1D3(B")
("etrg"	"$(0\u(B")
("etst"	"$(1kh(B")
("ettb"	"$(0Fe(B")
("ettc"	"$(16I(B")
("etub"	"$(0F`(B")
("etvi"	"$(0BF(B")
("etvp"	"$(1]H(B")
("etwa"	"$(0KP(B")
("etwb"	"$(1X.(B")
("etwi"	"$(1a~(B")
("etwt"	"$(0S.(B")
("etwv"	"$(0S+(B")
("etxc"	"$(1D1(B")
("etym"	"$(16g(B")
("etys"	"$(16f(B")
("euc"	"$(1`*`+(B")
("euu"	"$(1'n(B")
("eubb"	"$(1KO(B")
("eugk"	"$(1QT(B")
("eujt"	"$(1kb(B")
("eumb"	"$(0B@(B")
("eumf"	"$(1=K(B")
("eumi"	"$(1D>(B")
("eumt"	"$(1D=(B")
("euog"	"$(1KP(B")
("euon"	"$(08P(B")
("eutt"	"$(1rA(B")
("euuk"	"$(1D?(B")
("evr"	"$(1+Y(B")
("evfd"	"$(0_3(B")
("evfg"	"$(0V1(B")
("evfn"	"$(0_%(B")
("evid"	"$(1b%(B")
("evis"	"$(1'p(B")
("evne"	"$(16V(B")
("evug"	"$(1kf(B")
("evvd"	"$(1KV(B")
("evvw"	"$(0=j(B")
("ewb"	"$(0B<(B")
("ewc"	"$(00V(B")
("ewd"	"$(10I6c(B")
("ewg"	"$(08E(B")
("ewk"	"$(1+h(B")
("ewo"	"$(00W(B")
("ewr"	"$(1+Z(B")
("ewdq"	"$(1Qf(B")
("ewfq"	"$(1DL(B")
("ewgf"	"$(1QR(B")
("ewim"	"$(1K^(B")
("ewjr"	"$(0=[(B")
("ewlb"	"$(1=H(B")
("ewli"	"$(0S-(B")
("ewlj"	"$(0S,(B")
("ewln"	"$(1i0(B")
("ewlo"	"$(1KN(B")
("ewlv"	"$(0S5(B")
("ewml"	"$(16R(B")
("ewmo"	"$(1D<(B")
("ewmv"	"$(1=J(B")
("ewno"	"$(1eg(B")
("ewot"	"$(0Fl(B")
("ewtc"	"$(1Qe(B")
("ewtj"	"$(1KG(B")
("ewvf"	"$(0KR(B")
("ewwg"	"$(1kg(B")
("eyg"	"$(00D(B")
("eyk"	"$(0,|(B")
("eyr"	"$(00K(B")
("eyt"	"$(00C(B")
("eyv"	"$(1"Z(B")
("eyx"	"$(0V%(B")
("eyy"	"$(0,z(B")
("eyaj"	"$(16T(B")
("eybb"	"$(1=SW|(B")
("eybc"	"$(1=E(B")
("eybg"	"$(1mX(B")
("eybk"	"$(0KS(B")
("eybp"	"$(1ek(B")
("eybs"	"$(0Fc(B")
("eybu"	"$(0V,(B")
("eycb"	"$(0KA(B")
("eyck"	"$(1+P(B")
("eycv"	"$(0K?(B")
("eydk"	"$(1Q^(B")
("eydl"	"$(1K<(B")
("eydu"	"$(1ej(B")
("eyed"	"$(1X0(B")
("eyem"	"$(1eq(B")
("eyfe"	"$(0=W(B")
("eyhc"	"$(0ZE(B")
("eyhm"	"$(1K=(B")
("eyhn"	"$(0,{(B")
("eyhs"	"$(1$L(B")
("eyib"	"$(106(B")
("eyiu"	"$(03}(B")
("eyjc"	"$(1qq(B")
("eyjj"	"$(0KO(B")
("eylc"	"$(1ep(B")
("eylh"	"$(08F(B")
("eylm"	"$(1$U(B")
("eymh"	"$(1X!(B")
("eymp"	"$(1+X(B")
("eyoj"	"$(0=l(B")
("eyok"	"$(0=M(B")
("eypd"	"$(1KK(B")
("eypk"	"$(1W~(B")
("eypo"	"$(1W}(B")
("eypp"	"$(0X[(B")
("eypt"	"$(0ZF(B")
("eypu"	"$(16e(B")
("eyrb"	"$(1D-(B")
("eyrd"	"$(0=K(B")
("eyrf"	"$(0=J(B")
("eyrj"	"$(1K;(B")
("eyrn"	"$(1=1$(0Z@(B")
("eyro"	"$(0V&(B")
("eyru"	"$(1=T(B")
("eyrv"	"$(1i+(B")
("eysd"	"$(0B-$(1=U(B")
("eyso"	"$(0KB(B")
("eysy"	"$(0=P(B")
("eyta"	"$(1=/(B")
("eytb"	"$(1=0(B")
("eytg"	"$(0OJ(B")
("eytj"	"$(0K=(B")
("eytp"	"$(1X&(B")
("eytr"	"$(0=k(B")
("eyub"	"$(0K@(B")
("eyuh"	"$(1KL(B")
("eyvg"	"$(1Wt(B")
("eyvi"	"$(1'R(B")
("eyvw"	"$(1D/(B")
("eywi"	"$(0KY(B")
("eywm"	"$(0S2(B")
("eywv"	"$(1etD,(B")
("f"	"$(0'W(B")
("fb"	"$(0-:(B")
("fd"	"$(1'w$(0*N(B")
("ff"	"$(00d(B")
("fg"	"$(0-#(B")
("fh"	"$(0'8(B")
("fk"	"$(0){(B")
("fm"	"$(1$_(B")
("fo"	"$(1!=(B")
("fq"	"$(0(%(B")
("fab"	"$(1=i(B")
("fam"	"$(1+p(B")
("fafu"	"$(1Ke(B")
("fahm"	"$(1Db(B")
("faht"	"$(1=j(B")
("fahu"	"$(1DY(B")
("famh"	"$(0F|(B")
("famj"	"$(0=q(B")
("fank"	"$(1X@(B")
("fanp"	"$(0S?(B")
("fanw"	"$(0\v(B")
("fanx"	"$(1i:(B")
("fapp"	"$(0BV(B")
("fate"	"$(0ZG(B")
("fawe"	"$(1Q|(B")
("fayt"	"$(0F{(B")
("fbr"	"$(0/!47(B")
("fbac"	"$(1Kc(B")
("fbbe"	"$(1]N(B")
("fbhaf"	"$(1m0(B")
("fbjj"	"$(1DS(B")
("fbkf"	"$(0S@(B")
("fbln"	"$(02)(B")
("fbme"	"$(0G%(B")
("fbmr"	"$(10Y(B")
("fbnd"	"$(16r(B")
("fbok"	"$(0<rAU(B")
("fbrd"	"$(0Ak(B")
("fbrg"	"$(0;Y(B")
("fbrq"	"$(0A@(B")
("fbrw"	"$(0G6(B")
("fbrbc"	"$(0Q+(B")
("fbrhu"	"$(1."(B")
("fbrlb"	"$(0<'(B")
("fbrmh"	"$(1=m(B")
("fbrmn"	"$(1E*(B")
("fbrpa"	"$(0J*(B")
("fbrwf"	"$(0\^(B")
("fbryv"	"$(0Lw(B")
("fbwi"	"$(1ki(B")
("fbyh"	"$(16w(B")
("fcb"	"$(09f(B")
("fci"	"$(1'y(B")
("fcnh"	"$(16m(B")
("fcor"	"$(16z(B")
("fdj"	"$(1(I(B")
("fdk"	"$(1'q(B")
("fdv"	"$(1,h(B")
("fdy"	"$(10W(B")
("fdau"	"$(11m(B")
("fdamg"	"$(0X}(B")
("fdbm"	"$(0>P(B")
("fdbt"	"$(18'(B")
("fdbmr"	"$(1>p(B")
("fdbuu"	"$(1E}(B")
("fdcsh"	"$(09@(B")
("fddh"	"$(1r7(B")
("fddi"	"$(1,i(B")
("fddj"	"$(18&(B")
("fdeii"	"$(1Y4(B")
("fdha"	"$(0>Q(B")
("fdhe"	"$(11l(B")
("fdhj"	"$(1,k(B")
("fdhhj"	"$(1Lj(B")
("fdhoa"	"$(1Rk(B")
("fdhqu"	"$(11q(B")
("fdhuk"	"$(1Y5(B")
("fdig"	"$(1rL(B")
("fdibi"	"$(1Y6(B")
("fdiih"	"$(0Vc(B")
("fdile"	"$(0V](B")
("fdilr"	"$(0Sh(B")
("fdixp"	"$(1a7(B")
("fdjk"	"$(1,j(B")
("fdjmf"	"$(0L4(B")
("fdjrb"	"$(0P6(B")
("fdma"	"$(1>o(B")
("fdmq"	"$(1DU(B")
("fdmbb"	"$(0\((B")
("fdmcw"	"$(1>n(B")
("fdmlk"	"$(0Gm(B")
("fdmtb"	"$(1ku(B")
("fdnd"	"$(04w(B")
("fdng"	"$(11p(B")
("fdnj"	"$(1,g(B")
("fdnl"	"$(11o(B")
("fdnhd"	"$(1Ri(B")
("fdnii"	"$(1^<(B")
("fdnmm"	"$(1Y7(B")
("fdnob"	"$(1Rj(B")
("fdok"	"$(07i(B")
("fdon"	"$(1,f(B")
("fdphh"	"$(11r(B")
("fdqmb"	"$(0L5(B")
("fdss"	"$(18$(B")
("fdsit"	"$(1iY(B")
("fdsmv"	"$(1Lg(B")
("fdtak"	"$(0V`(B")
("fdtaw"	"$(1qs(B")
("fdtbn"	"$(1Rl(B")
("fdtgf"	"$(0Sg(B")
("fdthb"	"$(1Y3(B")
("fdtwa"	"$(0Va(B")
("fdwd"	"$(1Lh(B")
("fdwf"	"$(0Fy(B")
("fdwg"	"$(1E|(B")
("fdwji"	"$(0\)(B")
("fdwla"	"$(1f;(B")
("fdwtc"	"$(0V_(B")
("fdyj"	"$(07j(B")
("fdyr"	"$(18%(B")
("fdyt"	"$(0>O(B")
("fdyhr"	"$(0Vb(B")
("fdyoj"	"$(0L3(B")
("ffe"	"$(0V4(B")
("fff"	"$(1=c(B")
("ffh"	"$(00e(B")
("ffbb"	"$(1M3(B")
("ffbc"	"$(1d9(B")
("ffbd"	"$(0K+(B")
("ffbe"	"$(1K6(B")
("ffbf"	"$(0K_$(1pA(B")
("ffbg"	"$(0E_(B")
("ffbv"	"$(1BD(B")
("ffbbu"	"$(1_I(B")
("ffbhf"	"$(0]N(B")
("ffbhq"	"$(0Kb(B")
("ffbks"	"$(0@9(B")
("ffbli"	"$(0T.(B")
("ffbmf"	"$(1RX(B")
("ffbmg"	"$(0Of(B")
("ffbmn"	"$(1R7(B")
("ffbmw"	"$(1_u(B")
("ffbnj"	"$(1DZ(B")
("ffbou"	"$(1YK(B")
("ffbrr"	"$(0V3(B")
("ffbuu"	"$(1T9(B")
("ffbvf"	"$(0Sk(B")
("ffbyr"	"$(1_W(B")
("ffbyv"	"$(1ZA(B")
("ffdq"	"$(0S8(B")
("fffd"	"$(1b+X<(B")
("ffff"	"$(1XC(B")
("ffln"	"$(1.*(B")
("ffmbc"	"$(1`Wkw(B")
("ffnl"	"$(19m(B")
("ffno"	"$(1="(B")
("ffye"	"$(1<?(B")
("ffyr"	"$(1DT(B")
("ffypu"	"$(1c((B")
("fgg"	"$(10O(B")
("fggu"	"$(0S9(B")
("fgit"	"$(1Kj(B")
("fgni"	"$(1b,(B")
("fhs"	"$(049(B")
("fhag"	"$(0F~(B")
("fhbk"	"$(0V:(B")
("fhbt"	"$(10[(B")
("fhbu"	"$(04](B")
("fhdf"	"$(1Dh(B")
("fhdn"	"$(1Qy(B")
("fhdw"	"$(1X;(B")
("fhej"	"$(0=r(B")
("fher"	"$(08T(B")
("fhey"	"$(1+v(B")
("fhge"	"$(0V8(B")
("fhgf"	"$(0X`(B")
("fhgu"	"$(10Z(B")
("fhjg"	"$(1Dg(B")
("fhkb"	"$(1XB(B")
("fhks"	"$(0)J(B")
("fhlo"	"$(1=b(B")
("fhml"	"$(1'r(B")
("fhon"	"$(10\(B")
("fhsb"	"$(1D\(B")
("fhsm"	"$(0K\(B")
("fhsu"	"$(1Qr(B")
("fhup"	"$(0K^(B")
("fhwp"	"$(1Qz(B")
("fiav"	"$(16l(B")
("fice"	"$(16q(B")
("fihr"	"$(1D`(B")
("fijb"	"$(16t(B")
("filr"	"$(1Ki(B")
("filii"	"$(1qv(B")
("fipf"	"$(1ex(B")
("fipm"	"$(10V(B")
("fitc"	"$(1ew(B")
("fixp"	"$(1Qt(B")
("fjcm"	"$(1=f(B")
("fjcr"	"$(0KZ(B")
("fjhp"	"$(10T(B")
("fjks"	"$(08S(B")
("fjmu"	"$(16n(B")
("fjnu"	"$(1=e(B")
("fkb"	"$(10X(B")
("fkn"	"$(0Jd(B")
("fkp"	"$(1PC(B")
("fkt"	"$(0Jc(B")
("fkv"	"$(1I\(B")
("fkbu"	"$(0SS(B")
("fkcf"	"$(0S=(B")
("fkgg"	"$(1Da(B")
("fkhaf"	"$(1no(B")
("fkhqu"	"$(0S'(B")
("fkik"	"$(1R!(B")
("fkkb"	"$(0=s(B")
("fklb"	"$(0J](B")
("fklmi"	"$(1_=(B")
("fkmbc"	"$(0[K(B")
("fkmnp"	"$(0Uo(B")
("fknwf"	"$(0^+(B")
("fkrau"	"$(1cw(B")
("fkryo"	"$(1cq(B")
("fksb"	"$(1Kk(B")
("fksc"	"$(1]L(B")
("flx"	"$(1X?(B")
("flbk"	"$(1+u(B")
("flii"	"$(1m\(B")
("flmo"	"$(10P(B")
("flmt"	"$(0Xa(B")
("flwv"	"$(1Qx(B")
("fmu"	"$(0)=(B")
("fmam"	"$(10N(B")
("fmbb"	"$(0Xc(B")
("fmbc"	"$(0Fw(B")
("fmbm"	"$(1r-(B")
("fmmr"	"$(16u(B")
("fmob"	"$(045(B")
("fmso"	"$(16v(B")
("fmua"	"$(1X6(B")
("fmvm"	"$(16p(B")
("fmwf"	"$(1Qn(B")
("fmwg"	"$(0Fv(B")
("fmwj"	"$(1X4(B")
("fmym"	"$(1+t(B")
("fng"	"$(1'v(B")
("fno"	"$(00f(B")
("fnq"	"$(1C!(B")
("fnbk"	"$(0G!(B")
("fnhb"	"$(1X>(B")
("fnhd"	"$(1DV(B")
("fnhx"	"$(0BR(B")
("fnkg"	"$(16|(B")
("fnkm"	"$(1=a(B")
("fnkq"	"$(1D^(B")
("fnot"	"$(0S:(B")
("fog"	"$(0?{(B")
("fogf"	"$(1X:(B")
("foii"	"$(1+w(B")
("foir"	"$(16yKl(B")
("foma"	"$(0V9(B")
("fomb"	"$(1kj(B")
("fomg"	"$(10](B")
("fomr"	"$(10^(B")
("fond"	"$(1Kg(B")
("fowy"	"$(16{(B")
("fpd"	"$(1$`(B")
("fpi"	"$(0-$(B")
("fpu"	"$(1'x(B")
("fpru"	"$(04:(B")
("fptd"	"$(1DW(B")
("fqn"	"$(1*>(B")
("fqq"	"$(07U(B")
("fqu"	"$(1AW(B")
("fqbu"	"$(0>8(B")
("fqdmq"	"$(1U_(B")
("fqhe"	"$(026(B")
("fqhq"	"$(10d(B")
("fqlb"	"$(1*4(B")
("fqln"	"$(0+3(B")
("fqmbc"	"$(1O5(B")
("fqmso"	"$(0Hn(B")
("fqmvn"	"$(1]\(B")
("fqnl"	"$(0QP(B")
("fqnbg"	"$(1GI(B")
("fqsh"	"$(0.-(B")
("fqsu"	"$(0.;(B")
("fqsmm"	"$(1bh(B")
("fqvv"	"$(1Li(B")
("fqvif"	"$(1>y(B")
("fqymu"	"$(1mD(B")
("frb"	"$(16x(B")
("frbc"	"$(1Kd(B")
("frhu"	"$(1+q(B")
("frrd"	"$(0V6(B")
("frrj"	"$(1X8(B")
("frrr"	"$(1Dc(B")
("frye"	"$(0G#(B")
("fsh"	"$(1"a(B")
("fss"	"$(046(B")
("fseg"	"$(1Qv(B")
("fshr"	"$(04;(B")
("fsit"	"$(1b((B")
("fsma"	"$(1Qp(B")
("fsmg"	"$(1b)(B")
("fsmi"	"$(1X7(B")
("fsmt"	"$(1Qw(B")
("fsrr"	"$(1Qo(B")
("fssr"	"$(16o(B")
("fswu"	"$(1q((B")
("fta"	"$(1=h(B")
("ftc"	"$(10`$(08R(B")
("ftq"	"$(08Q(B")
("ftcw"	"$(1D](B")
("ftgi"	"$(1]K(B")
("ftgs"	"$(1i;(B")
("ftlj"	"$(1D_(B")
("ftlk"	"$(1De(B")
("ftlo"	"$(1Qm(B")
("ftmc"	"$(1X5(B")
("ftmd"	"$(0Fx(B")
("ftmj"	"$(1X9(B")
("ftmv"	"$(1DX(B")
("ftrg"	"$(1m](B")
("ftwb"	"$(1]M(B")
("ftwi"	"$(1X=(B")
("fubjj"	"$(0QB(B")
("fumb"	"$(1Df(B")
("fusmg"	"$(0\/(B")
("fvid"	"$(0ZH(B")
("fwb"	"$(1Dd(B")
("fwgg"	"$(1e{(B")
("fwli"	"$(0V7(B")
("fwlj"	"$(1]I(B")
("fwmv"	"$(0G$(B")
("fwmbc"	"$(1qI(B")
("fwot"	"$(1Kf(B")
("fwtc"	"$(1XA(B")
("fwtj"	"$(1Qq(B")
("fyg"	"$(1+o(B")
("fyj"	"$(1't(B")
("fyk"	"$(1'u(B")
("fyaj"	"$(1=`(B")
("fycb"	"$(1Qs(B")
("fydk"	"$(0S7(B")
("fyed"	"$(0V5(B")
("fyhn"	"$(00c(B")
("fyia"	"$(0S6(B")
("fynb"	"$(1Qu(B")
("fyoj"	"$(1=^(B")
("fyok"	"$(1=g(B")
("fypt"	"$(0[x(B")
("fyrb"	"$(1Kb(B")
("fyrd"	"$(1=_(B")
("fyrv"	"$(1kk(B")
("fyto"	"$(0V2(B")
("fytp"	"$(1]J(B")
("fytr"	"$(0BO(B")
("fyvi"	"$(043(B")
("fyvo"	"$(10U(B")
("g"	"$(0&I(B")
("gb"	"$(0'u(B")
("gg"	"$(0)e(B")
("gi"	"$(0(+(B")
("gp"	"$(0,6(B")
("gr"	"$(0)P(B")
("gu"	"$(1!:(B")
("gam"	"$(0.](B")
("gav"	"$(02P(B")
("gagi"	"$(0E^(B")
("gahu"	"$(1:o(B")
("gamh"	"$(0@\(B")
("gamo"	"$(0@](B")
("ganx"	"$(1eG(B")
("gaph"	"$(14;(B")
("gapv"	"$(1:i(B")
("gasm"	"$(0EZ(B")
("gawe"	"$(1ID(B")
("gbb"	"$(14<(B")
("gbd"	"$(14N(B")
("gbr"	"$(1%x(B")
("gby"	"$(0+a(B")
("gbac"	"$(1B*(B")
("gbbr"	"$(0@a(B")
("gbcd"	"$(142(B")
("gbdi"	"$(1.P(B")
("gbhne"	"$(1_K(B")
("gblm"	"$(0@d(B")
("gbmc"	"$(14I(B")
("gbmm"	"$(1B:(B")
("gbmo"	"$(0EW(B")
("gbmr"	"$(1)V(B")
("gbmt"	"$(0@c(B")
("gbnd"	"$(1.Q(B")
("gbsd"	"$(14M(B")
("gbtu"	"$(14:(B")
("gcg"	"$(1%~(B")
("gcbuu"	"$(1n$(B")
("gcdhe"	"$(1iB(B")
("gcglc"	"$(0M7(B")
("gche"	"$(1&$(B")
("gcim"	"$(1B1(B")
("gcilr"	"$(1_e(B")
("gcjka"	"$(0Q5(B")
("gclmi"	"$(1Gd(B")
("gcnl"	"$(0:W(B")
("gcnau"	"$(1Ge(B")
("gcok"	"$(0?Q(B")
("gcrxu"	"$(1e1(B")
("gcrye"	"$(1Ze(B")
("gcsh"	"$(1#N(B")
("gcsle"	"$(0?P(B")
("gcwa"	"$(0NA(B")
("gcybc"	"$(1Zd(B")
("gdi"	"$(0)z(B")
("gdw"	"$(14D(B")
("gdhe"	"$(0.\(B")
("gdhne"	"$(1Jj$(0P'(B")
("gdwf"	"$(1:m(B")
("gec"	"$(1gd(B")
("gee"	"$(1Q](B")
("gep"	"$(1J,(B")
("gebu"	"$(0Xl(B")
("geeii"	"$(1p+(B")
("gefbg"	"$(1py(B")
("gehda"	"$(0\U(B")
("gehey"	"$(0Z*(B")
("gehhj"	"$(0]T(B")
("gehkb"	"$(1o4(B")
("gehor"	"$(1m>(B")
("gelmi"	"$(1Z:(B")
("gelxl"	"$(1m?(B")
("gemr"	"$(0SV(B")
("geoju"	"$(0Vu(B")
("gesj"	"$(0Vy(B")
("gesmv"	"$(1m@(B")
("geymr"	"$(1cU(B")
("geyta"	"$(1j\(B")
("gff"	"$(14@(B")
("gfq"	"$(1&!(B")
("gfcb"	"$(1B/(B")
("gfhne"	"$(1Y=m&(B")
("gfmu"	"$(1)](B")
("gfno"	"$(0B"(B")
("gfqu"	"$(143(B")
("ggg"	"$(1)_(B")
("ggp"	"$(1/"(B")
("ggy"	"$(0.:(B")
("ggce"	"$(14F(B")
("ggdi"	"$(02m(B")
("ggff"	"$(1X3(B")
("gggu"	"$(1Ot$(0@Z(B")
("gghaf"	"$(1hL(B")
("ggkni"	"$(144(B")
("ggln"	"$(1%R(B")
("ggni"	"$(1\W(B")
("ggnl"	"$(1-Z(B")
("ggow"	"$(1rJ(B")
("ghi"	"$(0E\(B")
("ghag"	"$(1:u(B")
("ghbk"	"$(1VX(B")
("ghdw"	"$(0NF(B")
("ghfd"	"$(1%z(B")
("ghgf"	"$(0UO(B")
("ghhj"	"$(0;W(B")
("ghhw"	"$(1B0(B")
("ghjg"	"$(1:s(B")
("ghjm"	"$(1:j(B")
("ghml"	"$(0+g(B")
("ghmr"	"$(02R(B")
("ghmy"	"$(0._(B")
("ghmvn"	"$(1]_(B")
("ghnd"	"$(1)Y(B")
("ghni"	"$(1:t(B")
("ghpm"	"$(1%|(B")
("ghrf"	"$(0E](B")
("ghrj"	"$(0;V(B")
("ghsk"	"$(1VU(B")
("ghvp"	"$(1#J(B")
("ghxu"	"$(14P(B")
("gid"	"$(1Q((B")
("gif"	"$(0O`(B")
("gig"	"$(0J=(B")
("gip"	"$(1PE(B")
("giq"	"$(0Nx$(1PW(B")
("giav"	"$(1.M(B")
("giapv"	"$(1Jb(B")
("gibt"	"$(08w(B")
("gibuc"	"$(1cb(B")
("gihq"	"$(1Do(B")
("gihr"	"$(1:p(B")
("gihs"	"$(02S(B")
("gihab"	"$(0UZ(B")
("gihaf"	"$(1np(B")
("giih"	"$(1IG(B")
("gijb"	"$(06l(B")
("giks"	"$(0E=+7(B")
("gilb"	"$(1I?(B")
("gilr"	"$(0EU(B")
("gilmi"	"$(1_6(B")
("ginl"	"$(1-[(B")
("ginn"	"$(1.W(B")
("giok"	"$(06n(B")
("girm"	"$(0;R(B")
("girxu"	"$(1e0(B")
("gismm"	"$(1i_(B")
("gisqf"	"$(1ln(B")
("gitc"	"$(0X>(B")
("gitlj"	"$(1dL(B")
("givif"	"$(1^K(B")
("gixp"	"$(1IL(B")
("giymr"	"$(1c[(B")
("gjp"	"$(1&"(B")
("gjv"	"$(1)R(B")
("gjbc"	"$(0EY(B")
("gjbm"	"$(146(B")
("gjcr"	"$(1B2(B")
("gjhp"	"$(1)S(B")
("gjhne"	"$(0W_(B")
("gjhvo"	"$(1E'(B")
("gjii"	"$(1I@(B")
("gjjn"	"$(1IB(B")
("gjka"	"$(0;Z(B")
("gjkni"	"$(0;[(B")
("gjmu"	"$(1.U(B")
("gjsle"	"$(0@_(B")
("gjtc"	"$(0NB(B")
("gkc"	"$(1g[(B")
("gkf"	"$(0O_(B")
("gkq"	"$(1PV(B")
("gkbt"	"$(1]f(B")
("gkbuc"	"$(0YD(B")
("gkik"	"$(1R"(B")
("gkkk"	"$(0J@(B")
("gklmi"	"$(0W<$(1_5(B")
("gkmb"	"$(1:q(B")
("gkmr"	"$(14G(B")
("gkms"	"$(02T(B")
("gknwf"	"$(1nc(B")
("gkpb"	"$(1IC(B")
("gkrxu"	"$(0^~(B")
("gksj"	"$(0Vx(B")
("gksqf"	"$(1lm(B")
("gkymr"	"$(1cT(B")
("gle"	"$(148(B")
("glq"	"$(1)\(B")
("glbk"	"$(1%w(B")
("glll"	"$(0)b(B")
("glln"	"$(1%t(B")
("glmo"	"$(1)W(B")
("glnc"	"$(0-L(B")
("glwl"	"$(0.^(B")
("glwv"	"$(1IE(B")
("gmc"	"$(1UM(B")
("gmd"	"$(0)h(B")
("gmf"	"$(0+f(B")
("gmn"	"$(1!O(B")
("gmam"	"$(02Q(B")
("gmbb"	"$(1\V$(0^_(B")
("gmbk"	"$(1:g(B")
("gmdm"	"$(0Z0(B")
("gmfj"	"$(0.Z(B")
("gmfm"	"$(1%s(B")
("gmgg"	"$(14H(B")
("gmig"	"$(1)U(B")
("gmlk"	"$(06k(B")
("gmlm"	"$(14E(B")
("gmms"	"$(0)f(B")
("gmnr"	"$(0.Y(B")
("gmrb"	"$(1B5(B")
("gmrw"	"$(1:n(B")
("gmwd"	"$(1B6(B")
("gmwf"	"$(1IM(B")
("gmwg"	"$(1:e(B")
("gno"	"$(0+c(B")
("gnbg"	"$(1.R(B")
("gnhe"	"$(0+d(B")
("gnhx"	"$(14=(B")
("gnhne"	"$(1Bi$(0B'(B")
("gnib"	"$(1.X(B")
("gnkm"	"$(14>(B")
("gnmf"	"$(0Xb(B")
("gnmi"	"$(0JA(B")
("gnmu"	"$(1)X(B")
("gnot"	"$(1Ou(B")
("gnui"	"$(14O(B")
("goc"	"$(1T](B")
("gog"	"$(0;U(B")
("gom"	"$(1%{(B")
("gon"	"$(1"*(B")
("gou"	"$(13)(B")
("goy"	"$(05Z(B")
("goamj"	"$(0M9(B")
("goamo"	"$(1Zg(B")
("gobm"	"$(1@T(B")
("godk"	"$(19X(B")
("gofb"	"$(0M8(B")
("gofh"	"$(19Y(B")
("gofbr"	"$(0Q6(B")
("gogr"	"$(1Gg(B")
("goggu"	"$(1g:(B")
("gohjd"	"$(1Gh(B")
("gohjr"	"$(1Gi(B")
("gohkb"	"$(1g=(B")
("gohnd"	"$(1Gk(B")
("gohne"	"$(1_^(B")
("gohuc"	"$(1q`(B")
("goii"	"$(1&#(B")
("goik"	"$(1)[(B")
("goin"	"$(1#K(B")
("goiv"	"$(0D>(B")
("goimo"	"$(1Gf(B")
("goks"	"$(1-T(B")
("golmo"	"$(1Gn(B")
("golxh"	"$(1@U(B")
("gomj"	"$(13((B")
("gomn"	"$(1:v(B")
("gomr"	"$(1)^(B")
("gomnn"	"$(1Gl(B")
("gonk"	"$(0@b(B")
("gonin"	"$(1Gj(B")
("goog"	"$(1T\(B")
("googf"	"$(1g<(B")
("goohh"	"$(0D@(B")
("gooog"	"$(1N@(B")
("gopfd"	"$(1T[(B")
("gopim"	"$(19Z(B")
("gopuu"	"$(0WX(B")
("goru"	"$(0:E(B")
("gorrd"	"$(1j&(B")
("goshr"	"$(0D?(B")
("gosje"	"$(0Q7(B")
("gosmg"	"$(1lD(B")
("gosmm"	"$(1Gm(B")
("gotcw"	"$(1Zf(B")
("gotmc"	"$(1g;(B")
("gouu"	"$(1@V(B")
("govl"	"$(05[(B")
("gowr"	"$(0EF(B")
("goyaj"	"$(1TZ(B")
("gpd"	"$(0)c(B")
("gpi"	"$(1"+(B")
("gpu"	"$(1#M(B")
("gpbuu"	"$(1N/(B")
("gpim"	"$(0+b(B")
("gpmm"	"$(1:c(B")
("gptd"	"$(1:f(B")
("gqjl"	"$(1.Z(B")
("gqkq"	"$(14B(B")
("gqmb"	"$(14C(B")
("grt"	"$(1)a(B")
("gru"	"$(0)g(B")
("grbc"	"$(1B,(B")
("grbg"	"$(0LX(B")
("grgrr"	"$(1p6(B")
("grhg"	"$(1.O(B")
("grhv"	"$(0:1(B")
("grhaf"	"$(1a((B")
("grhne"	"$(1D%Aw(B")
("grks"	"$(1%V(B")
("grmbc"	"$(0Qo(B")
("grmfr"	"$(1e@(B")
("grno"	"$(1Wk/y(B")
("grrj"	"$(1Ov(B")
("grrk"	"$(1o$(B")
("grrs"	"$(1:r(B")
("grrv"	"$(0@G(B")
("grtf"	"$(0S<(B")
("grtr"	"$(0@FJ.(B")
("grye"	"$(1W<(B")
("gsp"	"$(1%u(B")
("gsu"	"$(1")(B")
("gsav"	"$(0@^(B")
("gsit"	"$(1\X(B")
("gsjt"	"$(1hp(B")
("gsmb"	"$(149(B")
("gsme"	"$(1.Y(B")
("gsok"	"$(0<s(B")
("gsuu"	"$(147(B")
("gsyq"	"$(0N?(B")
("gtj"	"$(0/2(B")
("gtm"	"$(0.[(B")
("gtq"	"$(1)T(B")
("gtu"	"$(1AX(B")
("gtak"	"$(1IO(B")
("gtco"	"$(1Ow(B")
("gtcp"	"$(1B+(B")
("gtdi"	"$(1;=(B")
("gtgr"	"$(1O{(B")
("gtgt"	"$(1\Y(B")
("gthhh"	"$(0A&(B")
("gtiop"	"$(0]a(B")
("gtje"	"$(0Iq(B")
("gtlm"	"$(1IA(B")
("gtmv"	"$(0@[(B")
("gtor"	"$(0EX(B")
("gtss"	"$(1IR(B")
("gtvs"	"$(1IN(B")
("gtwi"	"$(1OsO|(B")
("gubb"	"$(1IF(B")
("guhne"	"$(1RH(B")
("gumt"	"$(1B-(B")
("gumbc"	"$(1lb(B")
("guog"	"$(1IP(B")
("guon"	"$(1.[(B")
("gusmm"	"$(0Y((B")
("gvis"	"$(1%}(B")
("gwd"	"$(14J(B")
("gwg"	"$(06m(B")
("gwj"	"$(1$I(B")
("gwjr"	"$(14K(B")
("gwlb"	"$(1:h(B")
("gwlc"	"$(0Q1(B")
("gwlj"	"$(1VW(B")
("gwlm"	"$(1B7(B")
("gwot"	"$(0E[(B")
("gwyi"	"$(1%y(B")
("gyo"	"$(0-M(B")
("gyr"	"$(1%v(B")
("gyt"	"$(0.X(B")
("gybs"	"$(1B3(B")
("gycb"	"$(1IJ(B")
("gydk"	"$(0NE(B")
("gydl"	"$(1IK(B")
("gyfe"	"$(14L(B")
("gyhn"	"$(0+_(B")
("gyhs"	"$(0+^(B")
("gyib"	"$(06o(B")
("gylc"	"$(1eF(B")
("gylm"	"$(0+`(B")
("gyoj"	"$(14A(B")
("gypm"	"$(0N@(B")
("gypo"	"$(1VV(B")
("gypt"	"$(1eE(B")
("gyrb"	"$(1B4(B")
("gyrd"	"$(141(B")
("gyro"	"$(0UL(B")
("gyrv"	"$(0[g(B")
("gyta"	"$(1:d(B")
("gytg"	"$(1Oz(B")
("gytj"	"$(1.VII(B")
("gytr"	"$(0;\(B")
("gytu"	"$(0J;(B")
("gyvo"	"$(02U(B")
("gywd"	"$(1VT(B")
("gywm"	"$(0RL(B")
("gywv"	"$(0Z.(B")
("h"	"$(0*M(B")
("ha"	"$(0(v(B")
("hd"	"$(0(~(B")
("he"	"$(0'1(B")
("hg"	"$(0'2(B")
("hi"	"$(0:q&>(B")
("hj"	"$(0&F(B")
("hk"	"$(0'6(B")
("hm"	"$(1,e(B")
("hn"	"$(0&.(B")
("ho"	"$(0&-$(1!-(B")
("hp"	"$(1!((B")
("hq"	"$(0'](B")
("hs"	"$(0'C'f(B")
("ht"	"$(0'+(B")
("hx"	"$(0*_(B")
("hae"	"$(03y(B")
("haj"	"$(1$r(B")
("ham"	"$(17x(B")
("hap"	"$(0-1(B")
("hau"	"$(09>$(1"g(B")
("habwi"	"$(1me(B")
("hahe"	"$(04X(B")
("hahi"	"$(0R&(B")
("hahaa"	"$(1r#RE(B")
("hahaj"	"$(1RD(B")
("hahdw"	"$(1]e(B")
("hahgr"	"$(0Bx(B")
("hahqi"	"$(1>>(B")
("hahsk"	"$(1b?(B")
("hail"	"$(0Gh(B")
("haipf"	"$(1i@(B")
("hajbd"	"$(1[l(B")
("hajmu"	"$(0Bw(B")
("hakj"	"$(08t(B")
("haklu"	"$(1`c(B")
("halb"	"$(0/0(B")
("halmy"	"$(1`d(B")
("hamg"	"$(04W(B")
("hamj"	"$(1Ex(B")
("hana"	"$(0X|(B")
("hank"	"$(1bX(B")
("hanw"	"$(0^@(B")
("haoae"	"$(0Yw(B")
("haoii"	"$(11/(B")
("haph"	"$(1O;(B")
("hapi"	"$(00|(B")
("hasp"	"$(1O<(B")
("hatt"	"$(17I(B")
("hatxc"	"$(1h!(B")
("haumt"	"$(0Os(B")
("havt"	"$(1^/(B")
("havid"	"$(1iA(B")
("hawot"	"$(1h"(B")
("hayd"	"$(0=A(B")
("hayf"	"$(0@%(B")
("hayu"	"$(077(B")
("hayv"	"$(0HU(B")
("hayck"	"$(0>4(B")
("haymp"	"$(17J(B")
("hayrb"	"$(1RB(B")
("hbe"	"$(1]<(B")
("hbf"	"$(1ez]O(B")
("hbg"	"$(1V[(B")
("hbk"	"$(0E`(B")
("hbq"	"$(1"f(B")
("hbr"	"$(0)X(B")
("hbt"	"$(0*g(B")
("hbu"	"$(1Vq$(0*](B")
("hbbm"	"$(1ic(B")
("hbbuu"	"$(0\=(B")
("hbddf"	"$(0_G(B")
("hbfe"	"$(0\|(B")
("hbhaf"	"$(1k:ozpvhY(B")
("hbhgr"	"$(1ho(B")
("hbks"	"$(0C3(B")
("hbln"	"$(0.2(B")
("hbmr"	"$(0C0$(1bI(B")
("hbmbc"	"$(1`V(B")
("hbmch"	"$(0_+(B")
("hbmgi"	"$(1i?(B")
("hbmvn"	"$(1K~(B")
("hbnd"	"$(0RQ(B")
("hbnl"	"$(1A#(B")
("hbnbg"	"$(1i{(B")
("hbnwf"	"$(0^y(B")
("hbok"	"$(1W;(B")
("hbsd"	"$(0L/(B")
("hbse"	"$(1Ld(B")
("hbsmm"	"$(0PJ(B")
("hbtmc"	"$(0_2(B")
("hbuf"	"$(0\-(B")
("hbuh"	"$(1Rd(B")
("hbui"	"$(0Sd(B")
("hbut"	"$(0L,(B")
("hbuu"	"$(1Y+$(0Gk(B")
("hbyi"	"$(0*b(B")
("hcq"	"$(0W)(B")
("hcv"	"$(1P$(B")
("hchg"	"$(1o>(B")
("hchaf"	"$(1qR(B")
("hcii"	"$(1mm(B")
("hcjwj"	"$(1lI(B")
("hcln"	"$(1kR$(0N,(B")
("hcmr"	"$(1f0(B")
("hcnl"	"$(1U&n7(B")
("hcno"	"$(0XV(B")
("hcve"	"$(1ml(B")
("hcymr"	"$(0].(B")
("hda"	"$(05~(B")
("hdb"	"$(0C-(B")
("hdd"	"$(1L\(B")
("hdf"	"$(04r(B")
("hdi"	"$(0-4(B")
("hdl"	"$(01'$(1,](B")
("hdm"	"$(0>H(B")
("hdp"	"$(0<?(B")
("hdr"	"$(0.P(B")
("hdu"	"$(01((B")
("hdv"	"$(0.h(B")
("hdw"	"$(0Bm(B")
("hdaiu"	"$(1LN(B")
("hdamj"	"$(0C#(B")
("hdbm"	"$(097(B")
("hdbt"	"$(110(B")
("hdbu"	"$(0P.(B")
("hdbgb"	"$(0L#(B")
("hdbgr"	"$(0Ga(B")
("hdbhx"	"$(0P*(B")
("hdbmp"	"$(0ZX(B")
("hdbnd"	"$(1>^(B")
("hdbof"	"$(1Xy(B")
("hdbwi"	"$(1mi(B")
("hdcnh"	"$(1>](B")
("hdcru"	"$(0C%(B")
("hdcsh"	"$(1,`(B")
("hddj"	"$(095(B")
("hddmq"	"$(1LR(B")
("hdfb"	"$(0C"(B")
("hdfh"	"$(04q(B")
("hdgr"	"$(17i(B")
("hdgce"	"$(0G_(B")
("hdgcg"	"$(1E_(B")
("hdggu"	"$(1^!(B")
("hdgow"	"$(0Xr(B")
("hdhd"	"$(11Y(B")
("hdhp"	"$(1(E(B")
("hdhu"	"$(0-6(B")
("hdhaf"	"$(1m7a,(B")
("hdhah"	"$(0S[(B")
("hdhhj"	"$(1Ec(B")
("hdhjg"	"$(0L"(B")
("hdhkb"	"$(1^#(B")
("hdhne"	"$(1Wp(B")
("hdhpm"	"$(11V(B")
("hdhqo"	"$(099(B")
("hdhqu"	"$(1,^(B")
("hdhsb"	"$(1LQ(B")
("hdhvp"	"$(1,_(B")
("hdir"	"$(11T(B")
("hdiav"	"$(1>\(B")
("hdice"	"$(1>`(B")
("hdiih"	"$(1X{(B")
("hdijc"	"$(11Q(B")
("hdipf"	"$(1iP(B")
("hdirm"	"$(1Ee(B")
("hditc"	"$(1iQ(B")
("hdiua"	"$(0P((B")
("hdiuu"	"$(0@x(B")
("hdjbc"	"$(1R\(B")
("hdjbm"	"$(1Ea(B")
("hdjhp"	"$(17h(B")
("hdjip"	"$(0VU(B")
("hdjmo"	"$(0P&(B")
("hdkkb"	"$(0C&(B")
("hdlc"	"$(0]n(B")
("hdln"	"$(0+4.3(B")
("hdlo"	"$(0V[(B")
("hdlp"	"$(06!(B")
("hdlw"	"$(0I?$(11X(B")
("hdlbk"	"$(096(B")
("hdlxh"	"$(11U(B")
("hdmfj"	"$(094(B")
("hdmfm"	"$(11S(B")
("hdmig"	"$(17k(B")
("hdmrw"	"$(1LM(B")
("hdmvn"	"$(1R6(B")
("hdnd"	"$(0.x(B")
("hdnl"	"$(1-^NZ(B")
("hdnhs"	"$(0-5(B")
("hdnin"	"$(0>D(B")
("hdnmu"	"$(1Y`(B")
("hdnob"	"$(1LO(B")
("hdnwa"	"$(1iR(B")
("hdoe"	"$(0E)(B")
("hdog"	"$(0G`(B")
("hdoo"	"$(1Lf(B")
("hdogf"	"$(1]}(B")
("hdoip"	"$(0Gb(B")
("hdomb"	"$(1Eh(B")
("hdomd"	"$(1>_(B")
("hdph"	"$(09:(B")
("hdpp"	"$(1,\(B")
("hdqmc"	"$(0SY(B")
("hdrhg"	"$(0C$(B")
("hdsp"	"$(11W(B")
("hdss"	"$(11R(B")
("hdsmh"	"$(0S](B")
("hdta"	"$(1Ef(B")
("hdtmc"	"$(1E`^"(B")
("hdtoe"	"$(0ZW(B")
("hdtwv"	"$(0Xt(B")
("hduce"	"$(1LP(B")
("hdvii"	"$(1]~(B")
("hdwd"	"$(0Gd(B")
("hdwce"	"$(0P)(B")
("hdwhd"	"$(1Eg(B")
("hdwjr"	"$(1Eb(B")
("hdwlj"	"$(0\L(B")
("hdyj"	"$(04p(B")
("hdyx"	"$(1f4(B")
("hdymh"	"$(0Xs(B")
("hdyrb"	"$(0P%(B")
("hdyrd"	"$(1Ed(B")
("hdyrv"	"$(1mh(B")
("hdytg"	"$(1]|(B")
("hdyto"	"$(1bN(B")
("hed"	"$(0K8(B")
("heg"	"$(1.T(B")
("hep"	"$(0Jg(B")
("heq"	"$(1JB(B")
("her"	"$(0)W(B")
("hev"	"$(1BE(B")
("hey"	"$(0'w(B")
("heag"	"$(1Y#(B")
("heah"	"$(1bO(B")
("hebt"	"$(0Ou(B")
("heha"	"$(0L.(B")
("hehw"	"$(1kt(B")
("hehee"	"$(1qr(B")
("heii"	"$(0ZZ(B")
("heir"	"$(1LW(B")
("helb"	"$(1Bc(B")
("hemr"	"$(0P$(B")
("henl"	"$(1H2(B")
("heqj"	"$(1#P(B")
("hesu"	"$(17o(B")
("hetc"	"$(1Rg(B")
("hetlj"	"$(1gp(B")
("hevif"	"$(1YE(B")
("heyr"	"$(0X4(B")
("heyhv"	"$(1ZE(B")
("heyli"	"$(1_<(B")
("heyub"	"$(1p'(B")
("hfb"	"$(1Er(B")
("hfd"	"$(0'h-^(B")
("hfn"	"$(1AU(B")
("hfp"	"$(0E{(B")
("hfq"	"$(1C"(B")
("hfv"	"$(1;5(B")
("hfaht"	"$(1h^(B")
("hfate"	"$(1ql(B")
("hfbn"	"$(1Rb(B")
("hfbw"	"$(1f8(B")
("hfdk"	"$(0R+(B")
("hffs"	"$(1bP(B")
("hfhn"	"$(1Hu(B")
("hfhu"	"$(1Rh(B")
("hfhaf"	"$(1k=(B")
("hfhrb"	"$(1m6(B")
("hfhyu"	"$(1m2(B")
("hfice"	"$(1e)(B")
("hfjc"	"$(1\/(B")
("hfjp"	"$(0U7(B")
("hfks"	"$(0R;(B")
("hflmi"	"$(1T((B")
("hfmvn"	"$(1L!(B")
("hfnl"	"$(1H1(B")
("hfno"	"$(1K.(B")
("hfog"	"$(1hZ(B")
("hfomd"	"$(1e&(B")
("hfsqf"	"$(1m5(B")
("hftgi"	"$(1po(B")
("hftmc"	"$(1hM(B")
("hfydk"	"$(1oq(B")
("hgf"	"$(1Kh(B")
("hgg"	"$(1>j(B")
("hgi"	"$(0)$(B")
("hgr"	"$(0+L(B")
("hgcr"	"$(1bT(B")
("hgdi"	"$(0C,(B")
("hgea"	"$(1];(B")
("hgfmu"	"$(1RC(B")
("hghu"	"$(0)@(B")
("hghne"	"$(0F[(B")
("hgit"	"$(1Y'(B")
("hgks"	"$(0;0(B")
("hgmbc"	"$(0]B(B")
("hgni"	"$(0\%(B")
("hgpm"	"$(0Gi(B")
("hgrg"	"$(1iT(B")
("hgrly"	"$(0Qk(B")
("hhj"	"$(0.9(B")
("hhk"	"$(09?(B")
("hhn"	"$(0:F(B")
("hhs"	"$(0>N(B")
("hhw"	"$(08i(B")
("hhag"	"$(0P3(B")
("hhail"	"$(06P(B")
("hhbuc"	"$(0D<(B")
("hhdi"	"$(07-(B")
("hhdn"	"$(1^3Ez(B")
("hhfbr"	"$(0QA(B")
("hhffs"	"$(1gD(B")
("hhgr"	"$(1Ey(B")
("hhgu"	"$(1>l(B")
("hhhj"	"$(0L2(B")
("hhhaf"	"$(1h](B")
("hhhnd"	"$(0I$(B")
("hhjm"	"$(0P4(B")
("hhjr"	"$(1>g(B")
("hhjmc"	"$(1q{(B")
("hhkb"	"$(1bY(B")
("hhlo"	"$(11h(B")
("hhmbc"	"$(0D}(B")
("hhnwf"	"$(1h@(B")
("hhoe"	"$(0R.(B")
("hhol"	"$(1^6(B")
("hhoo"	"$(1^4(B")
("hhqm"	"$(0>L(B")
("hhrb"	"$(0Se(B")
("hhsb"	"$(0P2(B")
("hhsl"	"$(0()(B")
("hhsav"	"$(1Zs(B")
("hhslc"	"$(1n-(B")
("hhsld"	"$(0JN(B")
("hhsle"	"$(1Wo(B")
("hhsli"	"$(0+=(B")
("hhsrr"	"$(0YK(B")
("hhuc"	"$(1q.(B")
("hhwp"	"$(0Sf(B")
("hhwgf"	"$(1kE(B")
("hhxc"	"$(1iX(B")
("hhyu"	"$(1Y-(B")
("hii"	"$(0L*(B")
("hir"	"$(0>M(B")
("hit"	"$(17~(B")
("hiav"	"$(1En(B")
("hibt"	"$(1bR(B")
("hibtv"	"$(0Y~(B")
("hifb"	"$(1`v(B")
("hihq"	"$(1m^(B")
("hihr"	"$(0P0(B")
("hihaf"	"$(0Z'(B")
("hihml"	"$(1OH(B")
("hiih"	"$(1^5(B")
("hiiv"	"$(1V$(B")
("hiikk"	"$(1V%(B")
("hiirm"	"$(1dm(B")
("hijd"	"$(0R%(B")
("hije"	"$(1OG(B")
("himlb"	"$(0Y}(B")
("himwf"	"$(1lv(B")
("hino"	"$(0'g(B")
("hiog"	"$(1do(B")
("hitc"	"$(0ZY(B")
("hitmc"	"$(1dn(B")
("hivii"	"$(1nX(B")
("hixp"	"$(1^((B")
("hiyj"	"$(0Mv(B")
("hiypm"	"$(1nW(B")
("hiyub"	"$(0]K(B")
("hjd"	"$(0*8(B")
("hjr"	"$(0*`(B")
("hjbu"	"$(04b(B")
("hjcm"	"$(1LX(B")
("hjhx"	"$(1-,(B")
("hjhaf"	"$(1h\(B")
("hjhne"	"$(03u(B")
("hjii"	"$(1bQ^+(B")
("hjjj"	"$(1f6(B")
("hjjo"	"$(1^:(B")
("hjju"	"$(0P/(B")
("hjka"	"$(0L0(B")
("hjlo"	"$(1LZ(B")
("hjlp"	"$(0-f(B")
("hjmk"	"$(1^7(B")
("hjmu"	"$(1Em(B")
("hjmbc"	"$(1`T(B")
("hjnl"	"$(19t(B")
("hjrr"	"$(0L((B")
("hjsmm"	"$(0Su(B")
("hjtm"	"$(02N(B")
("hjwg"	"$(05n(B")
("hka"	"$(1'-(B")
("hkd"	"$(1<n(B")
("hkk"	"$(11e(B")
("hkp"	"$(0/@Z4(B")
("hkr"	"$(0+@(B")
("hks"	"$(1(H(B")
("hku"	"$(1Vu(B")
("hkcf"	"$(1bU(B")
("hkhaf"	"$(1pw(B")
("hklq"	"$(0LO(B")
("hklmi"	"$(12l(B")
("hkoo"	"$(1Ep(B")
("hkrbr"	"$(0@S(B")
("hksr"	"$(17v(B")
("hkvif"	"$(1M!(B")
("hkymr"	"$(1j#(B")
("hlo"	"$(0'X(B")
("hlq"	"$(0C.(B")
("hlw"	"$(0>I(B")
("hlx"	"$(0Xw(B")
("hlapv"	"$(1p/(B")
("hlbi"	"$(04n(B")
("hlbuc"	"$(0Q3(B")
("hljbv"	"$(1rE(B")
("hlkn"	"$(1\D(B")
("hlle"	"$(1n{(B")
("hllj"	"$(1bZ(B")
("hlln"	"$(0R:$(17s(B")
("hlmc"	"$(0X{(B")
("hlmj"	"$(0X9(B")
("hlmo"	"$(1>f(B")
("hlmbc"	"$(1Hh(B")
("hlmmf"	"$(0SX(B")
("hlmvn"	"$(1hf(B")
("hlno"	"$(00=(B")
("hlpr"	"$(1hg(B")
("hltwv"	"$(1r*(B")
("hlvk"	"$(1ks(B")
("hlvvu"	"$(1pz(B")
("hlwv"	"$(0VX(B")
("hlwli"	"$(1\|(B")
("hlxh"	"$(17{(B")
("hlypm"	"$(1qW(B")
("hmd"	"$(04v(B")
("hmj"	"$(04u(B")
("hml"	"$(0'I(B")
("hmm"	"$(01+(B")
("hmr"	"$(0)\(B")
("hmt"	"$(11c(B")
("hmy"	"$(0(Y(B")
("hmbc"	"$(1Y.(B")
("hmbg"	"$(1mj(B")
("hmbu"	"$(11:(B")
("hmgn"	"$(1iUL^(B")
("hmgt"	"$(1Eo(B")
("hmhaf"	"$(1m.\:(B")
("hmhqm"	"$(11$(B")
("hmmu"	"$(11i(B")
("hmmvn"	"$(1K}(B")
("hmnd"	"$(0Sa(B")
("hmnj"	"$(0C5(B")
("hmnl"	"$(01WDT$(17p(B")
("hmnq"	"$(1Y0(B")
("hmnr"	"$(17q(B")
("hmoo"	"$(0Gj(B")
("hmrg"	"$(1)`(B")
("hmsl"	"$(1>e(B")
("hmsu"	"$(0(*(B")
("hmsmb"	"$(0XW(B")
("hmua"	"$(0Xy(B")
("hmwd"	"$(1Y((B")
("hmwf"	"$(1^,(B")
("hmwj"	"$(1bS(B")
("hmwks"	"$(0Bj(B")
("hnd"	"$(0*9=@(B")
("hne"	"$(1!@(B")
("hni"	"$(0&<(B")
("hnp"	"$(0F'(B")
("hnq"	"$(0A?(B")
("hnamh"	"$(0Yr(B")
("hnbmc"	"$(0X)(B")
("hncr"	"$(0Z](B")
("hndo"	"$(1L_(B")
("hnef"	"$(1Y/(B")
("hneii"	"$(1g{(B")
("hnhe"	"$(11g(B")
("hnhq"	"$(0=v(B")
("hnhag"	"$(0;*(B")
("hnhhh"	"$(1AS(B")
("hnhhw"	"$(1le(B")
("hnhjr"	"$(0Qr(B")
("hnhli"	"$(05z(B")
("hnhxe"	"$(0[N(B")
("hnib"	"$(1Eq(B")
("hnir"	"$(0Mm(B")
("hnkg"	"$(1Et(B")
("hnkm"	"$(0L+(B")
("hnkcf"	"$(1lc(B")
("hnld"	"$(1Y*(B")
("hnlh"	"$(0>J(B")
("hnmm"	"$(0Sc(B")
("hnmaf"	"$(0Mz(B")
("hnmgh"	"$(1nF(B")
("hnmni"	"$(0)i(B")
("hnmnn"	"$(1Uh(B")
("hnmvh"	"$(1Hi(B")
("hnot"	"$(1bV(B")
("hnpru"	"$(1O7(B")
("hnryo"	"$(1n4(B")
("hnsmh"	"$(1jb(B")
("hnwp"	"$(1dX(B")
("hnyr"	"$(1O6(B")
("hnyhv"	"$(0L|(B")
("hnymr"	"$(1n*(B")
("hoa"	"$(1*w(B")
("hof"	"$(1Q{(B")
("hoi"	"$(0C4(B")
("hop"	"$(0Nk(B")
("hor"	"$(0.V(B")
("hoau"	"$(00h(B")
("hoav"	"$(03!(B")
("hoami"	"$(0<6(B")
("hoamo"	"$(1;\(B")
("hoaue"	"$(1hw(B")
("hobc"	"$(0_L(B")
("hobg"	"$(1Y%(B")
("hobm"	"$(1&W(B")
("hobgn"	"$(0^i(B")
("hobgr"	"$(155(B")
("hobou"	"$(1Bk(B")
("hobrn"	"$(1@)(B")
("hobvk"	"$(1Bj(B")
("hoci"	"$(1#t(B")
("hocmn"	"$(0MW(B")
("hodi"	"$(0>K(B")
("hodhe"	"$(0/?(B")
("hodmq"	"$(1;](B")
("hodoo"	"$(0<;(B")
("hodqn"	"$(0Pl(B")
("hoemn"	"$(05Q(B")
("hofbk"	"$(1J*(B")
("hofbr"	"$(0<<(B")
("hogdi"	"$(03"(B")
("hoggn"	"$(0Cz(B")
("hogyo"	"$(07A(B")
("hohs"	"$(1Ev(B")
("hohaf"	"$(1\3\4(B")
("hohag"	"$(0A)(B")
("hohgn"	"$(0Pm(B")
("hohju"	"$(0A((B")
("hohne"	"$(0,3(B")
("hohpm"	"$(1&Y(B")
("hohqo"	"$(10~(B")
("hohsk"	"$(1W"(B")
("hoii"	"$(17|(B")
("hoim"	"$(0^?(B")
("hoin"	"$(11k(B")
("hoicn"	"$(0?5(B")
("hojmf"	"$(154(B")
("hojrn"	"$(1T,(B")
("hojwp"	"$(0Na(B")
("hoks"	"$(1#2(B")
("hokmr"	"$(153(B")
("hold"	"$(0V\(B")
("holk"	"$(1Eu(B")
("holq"	"$(03$(B")
("holii"	"$(1pC(B")
("holln"	"$(0/>(B")
("holmy"	"$(0<9(B")
("homb"	"$(0^A(B")
("homd"	"$(1Ew(B")
("homg"	"$(1>h(B")
("homk"	"$(1Re(B")
("homo"	"$(0Z\(B")
("homr"	"$(0C1(B")
("homcw"	"$(1*@(B")
("homjn"	"$(1-M(B")
("hommn"	"$(0*h(B")
("homrn"	"$(0HM(B")
("homvm"	"$(07B(B")
("homym"	"$(0/=(B")
("honk"	"$(0P5(B")
("honhe"	"$(1#u(B")
("honkn"	"$(0T0(B")
("hooae"	"$(0A'(B")
("hooii"	"$(1&X(B")
("hooma"	"$(1\j(B")
("hoomd"	"$(07C(B")
("hooml"	"$(0<:(B")
("hoooo"	"$(0<8(B")
("hopa"	"$(03%(B")
("hopi"	"$(1(1"@(B")
("hopru"	"$(11!(B")
("hoqb"	"$(1Y2(B")
("horye"	"$(1;[(B")
("hosj"	"$(0V|(B")
("hosyq"	"$(1PB(B")
("hotq"	"$(03'(B")
("hotcn"	"$(1@((B")
("houfk"	"$(0^]U\$(1nb(B")
("hougk"	"$(0Nb(B")
("hourk"	"$(1\i(B")
("houuk"	"$(0Es(B")
("hovie"	"$(03&(B")
("howr"	"$(03#(B")
("hoyg"	"$(0/<(B")
("hoyj"	"$(1<B(B")
("hoybk"	"$(0Jf(B")
("hoybp"	"$(1eN(B")
("hoybs"	"$(0Er(B")
("hoyhs"	"$(0,2(B")
("hoyin"	"$(196(B")
("hoylo"	"$(0<7(B")
("hoyrv"	"$(1hv(B")
("hpa"	"$(0C20!(B")
("hpm"	"$(0(c(B")
("hpp"	"$(11d(B")
("hpr"	"$(17z(B")
("hpdk"	"$(0Gg(B")
("hphh"	"$(11f(B")
("hphaf"	"$(1e%(B")
("hpim"	"$(11j(B")
("hpln"	"$(0@8(B")
("hpnl"	"$(1H3(B")
("hpru"	"$(18#(B")
("hpsl"	"$(0)N(B")
("hpuu"	"$(1Y1(B")
("hqg"	"$(0-((B")
("hqi"	"$(0,=(B")
("hqm"	"$(0(n(B")
("hqo"	"$(0(C(B")
("hqp"	"$(0*K(B")
("hqr"	"$(1>k(B")
("hqu"	"$(0'T(B")
("hqate"	"$(1e}(B")
("hqbu"	"$(04a(B")
("hqbmc"	"$(1=r(B")
("hqbtu"	"$(1=q(B")
("hqbuk"	"$(1Dm(B")
("hqda"	"$(0\'(B")
("hqfqu"	"$(1=n(B")
("hqgdi"	"$(08X(B")
("hqgwc"	"$(0ZJ(B")
("hqhq"	"$(1'|(B")
("hqhw"	"$(0Z^(B")
("hqhdj"	"$(1Dn(B")
("hqhgr"	"$(17%(B")
("hqhkb"	"$(1XF(B")
("hqhpm"	"$(04?(B")
("hqhqm"	"$(04=(B")
("hqipf"	"$(1e|(B")
("hqiuh"	"$(17#(B")
("hqjm"	"$(1^)(B")
("hqjr"	"$(04>(B")
("hqjbm"	"$(1=p(B")
("hqjnd"	"$(10b(B")
("hqjqr"	"$(1Ko(B")
("hqks"	"$(1"b(B")
("hqkmr"	"$(0BX(B")
("hqlw"	"$(1+|(B")
("hqlxh"	"$(1+{(B")
("hqmb"	"$(1L[(B")
("hqmc"	"$(1^*(B")
("hqmmr"	"$(17"(B")
("hqmqj"	"$(039(B")
("hqmtb"	"$(1f"(B")
("hqmvm"	"$(17$(B")
("hqnbg"	"$(19M(B")
("hqnkq"	"$(1Dk(B")
("hqok"	"$(00l(B")
("hqomg"	"$(10c(B")
("hqpd"	"$(0-)(B")
("hqphh"	"$(00m(B")
("hqpuu"	"$(1Kq(B")
("hqrye"	"$(1Dl(B")
("hqsb"	"$(1L](B")
("hqshi"	"$(1$a(B")
("hqta"	"$(1^-(B")
("hqtb"	"$(1f7(B")
("hqtm"	"$(0L-(B")
("hqtce"	"$(1q)(B")
("hqtgs"	"$(0\w(B")
("hqthb"	"$(1Kp(B")
("hqvvv"	"$(1f!(B")
("hqwj"	"$(1mk(B")
("hqwlp"	"$(1e~(B")
("hqwyi"	"$(1+}(B")
("hqyrb"	"$(0Ka(B")
("hqyrd"	"$(1=o(B")
("hqytg"	"$(1XE(B")
("hrj"	"$(01^(B")
("hru"	"$(1*'(B")
("hrbc"	"$(1Y,(B")
("hrff"	"$(1M4(B")
("hrgb"	"$(18W(B")
("hrhr"	"$(1Es(B")
("hrhaf"	"$(0Z($(1a.a6a-(B")
("hrhkp"	"$(0LZ(B")
("hrhvp"	"$(09l(B")
("hrks"	"$(1)6(B")
("hrlb"	"$(02v(B")
("hrln"	"$(1Lc$(0.1(B")
("hrlmi"	"$(1@$(B")
("hrmr"	"$(1f9(B")
("hrmbc"	"$(1Ug(B")
("hrmlb"	"$(07<(B")
("hrnl"	"$(13A-a(B")
("hrog"	"$(0Me(B")
("hrok"	"$(0<w(B")
("hrrj"	"$(0Xz(B")
("hrtm"	"$(0>((B")
("hruc"	"$(1bW(B")
("hrvp"	"$(17t(B")
("hryf"	"$(08V(B")
("hsb"	"$(017(B")
("hsp"	"$(03,(B")
("hsr"	"$(18!(B")
("hsbr"	"$(1*U(B")
("hsbt"	"$(038(B")
("hsff"	"$(1;v(B")
("hshr"	"$(17u(B")
("hshml"	"$(0/U(B")
("hshne"	"$(085(B")
("hsik"	"$(0/T(B")
("hsit"	"$(0\&(B")
("hsko"	"$(1Ra(B")
("hsly"	"$(1Y)(B")
("hslmy"	"$(0A>(B")
("hsmg"	"$(0C/$(1iV(B")
("hsmr"	"$(17r(B")
("hsog"	"$(0Dw(B")
("hsqf"	"$(0Sb(B")
("hsru"	"$(1$((B")
("hsrau"	"$(0<T(B")
("hssmm"	"$(07T(B")
("hsyj"	"$(1&r(B")
("hsyr"	"$(1*T(B")
("hsyhs"	"$(0/S(B")
("hsyhv"	"$(1/3(B")
("htbn"	"$(0P-(B")
("htce"	"$(0Z[(B")
("htcg"	"$(1^;(B")
("hthaf"	"$(1nm(B")
("htkr"	"$(1Rc(B")
("htmc"	"$(0L)Xx(B")
("htmf"	"$(12r(B")
("htng"	"$(12s(B")
("htsj"	"$(1@'(B")
("htsl"	"$(0.=(B")
("httb"	"$(1Y&(B")
("httwi"	"$(1l7(B")
("hud"	"$(09j(B")
("hup"	"$(0RW7K(B")
("hubuc"	"$(0[&(B")
("huff"	"$(0B((B")
("huhaf"	"$(1h[e,k9(B")
("huhgu"	"$(10$:F(B")
("huhuu"	"$(1=,(B")
("huij"	"$(10'(B")
("huik"	"$(09i(B")
("huije"	"$(0=G(B")
("huikk"	"$(1L/(B")
("hulmc"	"$(1f5(B")
("humbc"	"$(0U&(B")
("humcw"	"$(10&(B")
("hunl"	"$(1-`9r(B")
("huno"	"$(1K/(B")
("hunkq"	"$(0F^(B")
("hunwa"	"$(1ei(B")
("huooo"	"$(1?:(B")
("hutak"	"$(1Q@(B")
("hutca"	"$(1Ws(B")
("huwp"	"$(1D*(B")
("huwml"	"$(0M|(B")
("huytr"	"$(1=*(B")
("hve"	"$(17}(B")
("hvp"	"$(0'U(B")
("hvr"	"$(1>i(B")
("hvbu"	"$(1T;(B")
("hvbjj"	"$(1nz(B")
("hvbuc"	"$(1kG(B")
("hvbuk"	"$(1ny(B")
("hvbuu"	"$(1GD(B")
("hvbvk"	"$(1p-(B")
("hvcsh"	"$(1aA(B")
("hvfi"	"$(1Rf(B")
("hvgdi"	"$(1he(B")
("hvhi"	"$(0Y|(B")
("hvhu"	"$(0;((B")
("hvhey"	"$(1e7(B")
("hvhqm"	"$(1e5(B")
("hvhyu"	"$(1p.(B")
("hvif"	"$(0-8(B")
("hvik"	"$(1a@(B")
("hvil"	"$(1pH(B")
("hvio"	"$(0(k(B")
("hvikk"	"$(1e3(B")
("hvjck"	"$(1nx(B")
("hvlw"	"$(0Z+(B")
("hvmr"	"$(1e4(B")
("hvmmr"	"$(0\_(B")
("hvmvn"	"$(1E)(B")
("hvno"	"$(0P1(B")
("hvnkg"	"$(1kH(B")
("hvpr"	"$(1e6(B")
("hvqmb"	"$(1mA(B")
("hvsl"	"$(1!8(B")
("hvsav"	"$(0^1(B")
("hvtxc"	"$(1p,(B")
("hvyk"	"$(1a?(B")
("hwe"	"$(17y(B")
("hwk"	"$(1"((B")
("hwl"	"$(18"(B")
("hwgti"	"$(1L3(B")
("hwhd"	"$(1Lb(B")
("hwhaf"	"$(1m/p%(B")
("hwim"	"$(1^1(B")
("hwjr"	"$(0L1(B")
("hwkk"	"$(0+Z(B")
("hwks"	"$(1I-(B")
("hwlg"	"$(0_'(B")
("hwli"	"$(0VY(B")
("hwml"	"$(1La(B")
("hwmvs"	"$(0Gn(B")
("hwnl"	"$(0QS(B")
("hwsmm"	"$(0Y)(B")
("hwtj"	"$(1^0(B")
("hxh"	"$(0-O(B")
("hxo"	"$(01<(B")
("hxt"	"$(125(B")
("hxbc"	"$(0S|(B")
("hxbt"	"$(0SO(B")
("hxhu"	"$(0.$(B")
("hxjc"	"$(0Wa(B")
("hxlb"	"$(1*5(B")
("hxle"	"$(06S(B")
("hxno"	"$(1C~(B")
("hxvyv"	"$(0Ir(B")
("hxwks"	"$(0H,(B")
("hxyc"	"$(0LY(B")
("hxyf"	"$(1?>(B")
("hyl"	"$(126(B")
("hym"	"$(1--(B")
("hyr"	"$(17w(B")
("hyt"	"$(0>G(B")
("hyu"	"$(056(B")
("hyv"	"$(1,d(B")
("hyau"	"$(127(B")
("hyabu"	"$(1S3(B")
("hybb"	"$(1f:(B")
("hybg"	"$(0_&(B")
("hybp"	"$(0]m(B")
("hybs"	"$(1Y$(B")
("hybnd"	"$(1FM(B")
("hyck"	"$(1>d(B")
("hycr"	"$(0>t(B")
("hyfb"	"$(1FL(B")
("hyfbw"	"$(1fR(B")
("hyha"	"$(0>s(B")
("hyhe"	"$(09o(B")
("hyhj"	"$(0VZ(B")
("hyhm"	"$(1^'(B")
("hyhn"	"$(11b(B")
("hyhr"	"$(1^2(B")
("hyhs"	"$(1q-8[(B")
("hyhaf"	"$(1a0(B")
("hyhag"	"$(1S5(B")
("hyhej"	"$(1FN(B")
("hyheq"	"$(1?@(B")
("hyhlo"	"$(1bo(B")
("hyhne"	"$(09p(B")
("hyhsb"	"$(1S6(B")
("hyhxe"	"$(0S}(B")
("hyjp"	"$(0>q(B")
("hykms"	"$(1?A(B")
("hykpb"	"$(1^_(B")
("hylw"	"$(18Y(B")
("hylwv"	"$(1^](B")
("hymo"	"$(1^.(B")
("hymnr"	"$(18X(B")
("hyndt"	"$(0L\(B")
("hynkg"	"$(0H-(B")
("hynri"	"$(1o@(B")
("hyoj"	"$(1Le(B")
("hyoge"	"$(1pK(B")
("hyoii"	"$(18\(B")
("hyoir"	"$(0S~(B")
("hyomd"	"$(1FO(B")
("hypt"	"$(1mn(B")
("hypu"	"$(12[L`(B")
("hyptd"	"$(1S2(B")
("hyrb"	"$(0S_(B")
("hyrl"	"$(1^8(B")
("hyrn"	"$(1q^(B")
("hyro"	"$(1iW(B")
("hysd"	"$(1R`(B")
("hysh"	"$(1(R(B")
("hysk"	"$(0VW(B")
("hysy"	"$(1LY(B")
("hyshu"	"$(1FK(B")
("hysit"	"$(0\1(B")
("hytc"	"$(1??(B")
("hytbo"	"$(1id(B")
("hytct"	"$(1Yc(B")
("hytgi"	"$(1fQ(B")
("hythu"	"$(1S1(B")
("hytqm"	"$(1Yb(B")
("hytwa"	"$(1^^(B")
("hyub"	"$(1^9(B")
("hyuce"	"$(1S4(B")
("hywl"	"$(18Z(B")
("hywv"	"$(0S`(B")
("hyyo"	"$(1o=(B")
("hyyx"	"$(1ie(B")
("hyybs"	"$(1Ya(B")
("hyyhn"	"$(09m(B")
("hyyhs"	"$(09n(B")
("hyyps"	"$(1fS(B")
("hyypt"	"$(1mu(B")
("hyytg"	"$(1bn(B")
("hyyvi"	"$(0>r(B")
("i"	"$(0'B(B")
("ib"	"$(1!g(B")
("id"	"$(0,,(B")
("ig"	"$(1"=(B")
("ih"	"$(0(T(B")
("ii"	"$(1&q(B")
("ij"	"$(0*'(B")
("ik"	"$(0'^(B")
("io"	"$(1![(B")
("ip"	"$(1!Z$(0&^(B")
("ir"	"$(0(;(B")
("it"	"$(0,<(P(B")
("iv"	"$(1!](B")
("iav"	"$(0-A(B")
("iaie"	"$(0A$(B")
("ibg"	"$(1B9(B")
("ibcn"	"$(0A"(B")
("ibcv"	"$(1ht(B")
("ibdi"	"$(1.l(B")
("ibhaf"	"$(1nfd~(B")
("ibnl"	"$(139$(0MJ(B")
("ibpp"	"$(09e(B")
("icp"	"$(1*A(B")
("icnl"	"$(1cx(B")
("icno"	"$(1P?(B")
("idg"	"$(1IH(B")
("idq"	"$(0Nw(B")
("idbu"	"$(0A#(B")
("idfd"	"$(0V^(B")
("idhd"	"$(1Xz(B")
("idhi"	"$(0]J(B")
("idhq"	"$(1Q}(B")
("idhqu"	"$(0R-(B")
("idjtc"	"$(1p&(B")
("idlmy"	"$(0[H(B")
("idlyf"	"$(1o7(B")
("idmr"	"$(0ST(B")
("idoo"	"$(15/(B")
("idsje"	"$(1hc(B")
("idvi"	"$(0M{(B")
("idvif"	"$(1^J(B")
("iea"	"$(1*m(B")
("iebt"	"$(1>?(B")
("iedhe"	"$(0By(B")
("ieln"	"$(13m(B")
("ieok"	"$(0<t(B")
("ieyhv"	"$(0HR(B")
("ifg"	"$(01$(B")
("ifl"	"$(1,X(B")
("ifp"	"$(0NiRV(B")
("ifamh"	"$(1LH(B")
("ifamo"	"$(1LG(B")
("ifasm"	"$(1RY(B")
("ifbk"	"$(0N^(B")
("ifbm"	"$(09/(B")
("ifbbr"	"$(0L!(B")
("ifbgr"	"$(1E\(B")
("ifbjj"	"$(1LJ(B")
("ifbme"	"$(1LL(B")
("ifbuu"	"$(0D!(B")
("ifdmq"	"$(1LF(B")
("iffkc"	"$(1pF(B")
("ifgi"	"$(11K(B")
("ifgni"	"$(0ZV(B")
("ifgrr"	"$(0VS(B")
("ifhk"	"$(1,Z(B")
("ifhs"	"$(093(B")
("ifhaf"	"$(0^/(B")
("ifhgr"	"$(1>[(B")
("ifhjd"	"$(17b(B")
("ifhml"	"$(04l(B")
("ifhne"	"$(1,Y(B")
("ifhpm"	"$(092(B")
("ifhqo"	"$(11P(B")
("ifhuc"	"$(1pG(B")
("ifhvp"	"$(04m(B")
("ifhyu"	"$(1RW(B")
("ifit"	"$(1>X(B")
("ifikk"	"$(11N(B")
("ifjr"	"$(11M(B")
("ifjbc"	"$(1RZ(B")
("ifkr"	"$(09,(B")
("iflmo"	"$(17a(B")
("iflwl"	"$(090(B")
("ifmk"	"$(04j(B")
("ifmr"	"$(11L(B")
("ifmbc"	"$(1j_(B")
("ifmfb"	"$(1f3(B")
("ifmmv"	"$(1>Y(B")
("ifmrw"	"$(0K~(B")
("ifmtb"	"$(1iO(B")
("ifmwg"	"$(1LD(B")
("ifmwj"	"$(1]z(B")
("ifnl"	"$(01&$(1@w(B")
("ifnhs"	"$(1$s(B")
("ifnmu"	"$(17c(B")
("ifodi"	"$(11J(B")
("ifohv"	"$(17d(B")
("ifoll"	"$(1,[(B")
("ifoma"	"$(1bM(B")
("ifomb"	"$(1mg(B")
("ifomr"	"$(17e(B")
("ifpd"	"$(1(C(B")
("ifph"	"$(09+(B")
("ifpi"	"$(1(D(B")
("ifpou"	"$(1E^(B")
("ifqhk"	"$(1LC(B")
("ifru"	"$(01%(B")
("ifrhu"	"$(091(B")
("ifrrj"	"$(0VT(B")
("ifryo"	"$(0YE(B")
("ifshr"	"$(11O(B")
("ifsme"	"$(1>Z(B")
("ifsmm"	"$(17`(B")
("ifsmr"	"$(09-(B")
("ifsqf"	"$(1RV(B")
("iftq"	"$(0>A(B")
("iftgf"	"$(1RU(B")
("iftmc"	"$(0GZ(B")
("iftmd"	"$(1LE(B")
("iftwt"	"$(0Xq(B")
("ifvii"	"$(1]{(B")
("ifvne"	"$(0G[(B")
("ifvno"	"$(1LK(B")
("ifwd"	"$(1E[(B")
("ifwp"	"$(1LI(B")
("ifwlm"	"$(1Xx(B")
("ifybb"	"$(1LB(B")
("ifybc"	"$(0K}(B")
("ifyhs"	"$(1,W(B")
("ifylm"	"$(04k(B")
("ifyoj"	"$(1E](B")
("ifyrv"	"$(0]l(B")
("ifyto"	"$(1bL(B")
("igb"	"$(0W!(B")
("igp"	"$(0U](B")
("igce"	"$(15,(B")
("igdi"	"$(1*8(B")
("ighaf"	"$(0^z(B")
("igit"	"$(1Bd(B")
("igow"	"$(1V{(B")
("igsk"	"$(1J%(B")
("igti"	"$(0NZ(B")
("ihi"	"$(1Bf$(0*)(B")
("ihm"	"$(0*((B")
("ihq"	"$(0*J(B")
("ihs"	"$(0**(B")
("ihu"	"$(0&y(B")
("ihhi"	"$(1_4o((B")
("ihhj"	"$(150(B")
("ihhw"	"$(1Bh(B")
("ihhqu"	"$(1QB(B")
("ihln"	"$(1Ao(B")
("ihml"	"$(1#q(B")
("ihmr"	"$(02<(B")
("ihmv"	"$(02e(B")
("ihpm"	"$(0/6(B")
("ihxe"	"$(1Bg(B")
("ihxo"	"$(0</(B")
("ihymf"	"$(0<R(B")
("iib"	"$(07x(B")
("iibt"	"$(0GA(B")
("iiif"	"$(1>{(B")
("iiih"	"$(0;7(B")
("iiil"	"$(0A!(B")
("iiln"	"$(1%T(B")
("iinl"	"$(05i(B")
("iino"	"$(1/|(B")
("iiobo"	"$(0LP(B")
("iiuh"	"$(1.{(B")
("iixp"	"$(1I|(B")
("ijb"	"$(0-.(B")
("ijc"	"$(0([(B")
("ije"	"$(1#m$(0,f(B")
("ijcc"	"$(0@)(B")
("ijjb"	"$(0N[(B")
("ijkd"	"$(1.x(B")
("ijwj"	"$(07=(B")
("ikk"	"$(1!d(B")
("ikp"	"$(1PS(B")
("iku"	"$(0'9(B")
("ikw"	"$(08h(B")
("ikbuc"	"$(1@S(B")
("ikhni"	"$(1ld(B")
("ikikk"	"$(1=t(B")
("ikjwj"	"$(1@p(B")
("iklu"	"$(0<.(B")
("iknf"	"$(044(B")
("ikno"	"$(16>(B")
("ikpb"	"$(1I~(B")
("ikrm"	"$(1.~(B")
("ilb"	"$(0<,(B")
("ile"	"$(0<+(B")
("iln"	"$(0)G(B")
("ilo"	"$(0/3(B")
("ilr"	"$(06U(B")
("ilil"	"$(0)}(B")
("ilmo"	"$(1*;(B")
("iloc"	"$(0Q4(B")
("ilwv"	"$(1J&(B")
("imc"	"$(1.)(B")
("ime"	"$(0)D(B")
("imp"	"$(0A*(B")
("imbgr"	"$(06I(B")
("imbsd"	"$(1.((B")
("imcw"	"$(1.y(B")
("imdw"	"$(06F(B")
("imgce"	"$(06G(B")
("imhgu"	"$(1%O(B")
("imig"	"$(1*9(B")
("imir"	"$(0+0(B")
("imikk"	"$(1#-(B")
("imjlv"	"$(1.&(B")
("immp"	"$(1mO(B")
("immnn"	"$(0.*(B")
("immvm"	"$(1!{(B")
("immwg"	"$(13l(B")
("imno"	"$(0*:(B")
("imog"	"$(06H(B")
("imoii"	"$(0+1(B")
("imoir"	"$(1:G(B")
("imomr"	"$(1%P(B")
("impko"	"$(0R8(B")
("imqmb"	"$(1.%(B")
("imsll"	"$(0LW(B")
("imsqf"	"$(0E&(B")
("imsuf"	"$(1VE(B")
("imtcl"	"$(1I)(B")
("imue"	"$(0Eo(B")
("imuog"	"$(1Ak(B")
("imvh"	"$(1#o(B")
("imwjr"	"$(1.'(B")
("imywd"	"$(0N)(B")
("ine"	"$(0(d(B")
("ino"	"$(0&g(B")
("inbq"	"$(1V}(B")
("infq"	"$(1hu(B")
("inin"	"$(0,*(B")
("inkg"	"$(07>(B")
("inli"	"$(1J#(B")
("inoe"	"$(0NY(B")
("iod"	"$(1*</v(B")
("iok"	"$(0-3(B")
("iop"	"$(07E(B")
("ior"	"$(029(B")
("iov"	"$(02](B")
("iobuc"	"$(0Hr(B")
("iodi"	"$(0/5(B")
("iofd"	"$(1>m(B")
("iohd"	"$(17j(B")
("iohaf"	"$(1hI(B")
("ioin"	"$(1#p(B")
("ioma"	"$(1V~(B")
("iomvn"	"$(0>'(B")
("ioog"	"$(07?(B")
("iooiv"	"$(1Ui(B")
("iord"	"$(1Cl(B")
("iotf"	"$(1P@(B")
("ipc"	"$(0[<(B")
("ipf"	"$(1V<$(0K](B")
("ipg"	"$(0J9(B")
("ipm"	"$(0*#(B")
("ipp"	"$(0,+Ji$(1#vHv(B")
("ipu"	"$(1#n(B")
("ipbm"	"$(1\<(B")
("ipbuc"	"$(13'(B")
("ipfd"	"$(0X3(B")
("ipfdq"	"$(0^\(B")
("iphd"	"$(1\=(B")
("iphn"	"$(0Io(B")
("iphaf"	"$(0My(B")
("iphhi"	"$(0]R(B")
("iphor"	"$(1ha(B")
("iphxu"	"$(1hb(B")
("ipihr"	"$(1k@(B")
("ipipp"	"$(1rC(B")
("iplmi"	"$(1Z;(B")
("ipmc"	"$(1J!(B")
("ipmmc"	"$(0D4(B")
("ipmmv"	"$(1e-(B")
("ipmwd"	"$(1m:(B")
("ipmwm"	"$(1px(B")
("ipnl"	"$(1NS(B")
("ipnsj"	"$(1kA(B")
("ipog"	"$(1:2(B")
("ipru"	"$(0/7(B")
("iprvk"	"$(1e.(B")
("iprye"	"$(1kB(B")
("iptmc"	"$(0[](B")
("ipyg"	"$(1\;(B")
("ipyx"	"$(1qT(B")
("ipyiu"	"$(1a9(B")
("iqhf"	"$(1P=(B")
("iqhaf"	"$(1a1(B")
("iqje"	"$(1.z(B")
("ird"	"$(1+9(B")
("irf"	"$(1+r(B")
("irm"	"$(0/Q(B")
("irp"	"$(03*Ew(B")
("irhaf"	"$(1m#(B")
("irmbc"	"$(1dV(B")
("irmvn"	"$(11#(B")
("irnl"	"$(1(x(B")
("irnbg"	"$(1ZJ(B")
("isbt"	"$(0>7(B")
("isgp"	"$(0_#(B")
("isja"	"$(1J"(B")
("ismh"	"$(0Jb(B")
("isnl"	"$(1-\(B")
("isok"	"$(0O/(B")
("isrj"	"$(1V|(B")
("ita"	"$(15-(B")
("ite"	"$(02z(B")
("itf"	"$(0<-(B")
("itq"	"$(02y(B")
("itt"	"$(1*7(B")
("itcl"	"$(0N\(B")
("ithaf"	"$(1\6(B")
("itlb"	"$(07;(B")
("itlm"	"$(1I}(B")
("itmc"	"$(0N](B")
("itso"	"$(15.(B")
("itxc"	"$(0En(B")
("iuhhh"	"$(1#^(B")
("ivug"	"$(1kZ(B")
("iwcg"	"$(1P>(B")
("iwtc"	"$(1J$(B")
("ixe"	"$(0Nc(B")
("ixf"	"$(1Be(B")
("ixp"	"$(0@'(B")
("iyr"	"$(0/4(B")
("iybp"	"$(0Z2(B")
("iydl"	"$(0Ja(B")
("iyln"	"$(1kQ(B")
("iymp"	"$(1*:(B")
("iypt"	"$(0Z3(B")
("iywd"	"$(1Vz(B")
("j"	"$(0&3(B")
("jb"	"$(1!>(B")
("jc"	"$(0)!(B")
("jd"	"$(0(]+{(B")
("je"	"$(0'F(B")
("jj"	"$(0&](B")
("jk"	"$(0&8(B")
("jm"	"$(0&J(B")
("jp"	"$(0(G(B")
("jr"	"$(0(-(B")
("jt"	"$(0(&(B")
("ju"	"$(0&%(B")
("jv"	"$(0)y(B")
("jaf"	"$(0BU(B")
("jav"	"$(07((B")
("jamo"	"$(1;9(B")
("janl"	"$(0?h(B")
("jasmm"	"$(1M((B")
("jbd"	"$(14v(B")
("jbm"	"$(0.|(B")
("jbhaf"	"$(1k>(B")
("jbhod"	"$(1ea(B")
("jblli"	"$(1c:(B")
("jbmc"	"$(08z(B")
("jbmm"	"$(01!(B")
("jbmrd"	"$(1W\(B")
("jbmri"	"$(0^h(B")
("jbnd"	"$(0+y(B")
("jbof"	"$(0JW(B")
("jbrrv"	"$(0][(B")
("jbtj"	"$(023(B")
("jbvif"	"$(09F(B")
("jbwno"	"$(1L#(B")
("jci"	"$(1PU(B")
("jcm"	"$(01)(B")
("jcn"	"$(1"h$(01*(B")
("jcbu"	"$(11\(B")
("jcbbr"	"$(0L%(B")
("jcegg"	"$(1K:$(0L$(B")
("jcemd"	"$(17l(B")
("jcfdj"	"$(1R](B")
("jcgg"	"$(17n(B")
("jcgfo"	"$(1^$(B")
("jcgwc"	"$(0\#(B")
("jchk"	"$(1,b(B")
("jchs"	"$(09;(B")
("jchaf"	"$(1m(X~(B")
("jchdb"	"$(0^>(B")
("jchdp"	"$(1X}(B")
("jchgr"	"$(0C)(B")
("jchhl"	"$(11^(B")
("jchhn"	"$(0P,(B")
("jchio"	"$(11Z(B")
("jchoo"	"$(1R_(B")
("jchsk"	"$(0Xv(B")
("jchuu"	"$(1^&(B")
("jchvo"	"$(11_(B")
("jchwk"	"$(0C((B")
("jchxv"	"$(0Xu(B")
("jcik"	"$(04t(B")
("jcirm"	"$(1Ej(B")
("jcjbc"	"$(1R^(B")
("jcjkd"	"$(1>a(B")
("jckn"	"$(0-7(B")
("jclb"	"$(0/,(B")
("jclmo"	"$(0>F(B")
("jclwv"	"$(1X|(B")
("jcmd"	"$(1(G(B")
("jcmbc"	"$(0[M(B")
("jcmig"	"$(0>E(B")
("jcmmu"	"$(1^%(B")
("jcmob"	"$(11[(B")
("jcmvh"	"$(04s(B")
("jcni"	"$(1(F(B")
("jcno"	"$(1Wi(B")
("jcnhx"	"$(1Ek(B")
("jcnlm"	"$(0VV(B")
("jcor"	"$(07+(B")
("jcold"	"$(1Y!(B")
("jcomn"	"$(1LU(B")
("jcpu"	"$(1,a(B")
("jcpru"	"$(11`(B")
("jcqhk"	"$(1LT(B")
("jcqou"	"$(0S^(B")
("jcsjl"	"$(1Y"(B")
("jcskr"	"$(0C'(B")
("jcsmm"	"$(1bi(B")
("jcsuu"	"$(0Ge(B")
("jctgf"	"$(0P+(B")
("jcuu"	"$(11](B")
("jcvis"	"$(09<(B")
("jcwd"	"$(0Gf(B")
("jcyck"	"$(17m(B")
("jcyoj"	"$(1Ei(B")
("jcyta"	"$(1LS(B")
("jdi"	"$(0)w(B")
("jdhaf"	"$(1d}(B")
("jdks"	"$(020(B")
("jdnl"	"$(13;(B")
("jdok"	"$(0<u(B")
("jed"	"$(1]-(B")
("jeg"	"$(1VZ(B")
("jeq"	"$(0Ue(B")
("jehaf"	"$(1V4(B")
("jejwj"	"$(1j/(B")
("jelmi"	"$(1ft(B")
("jembc"	"$(1Hg(B")
("jeoju"	"$(1fH(B")
("jese"	"$(1BO(B")
("jesmi"	"$(1W:(B")
("jesmm"	"$(09R(B")
("jevif"	"$(0Z_(B")
("jfb"	"$(07*(B")
("jhk"	"$(1#\(B")
("jhp"	"$(0)x(B")
("jhq"	"$(0-'(B")
("jhdw"	"$(0NP(B")
("jher"	"$(02k(B")
("jhoo"	"$(1BQ(B")
("jhqu"	"$(1#](B")
("jhxf"	"$(0NQ(B")
("jid"	"$(08((B")
("jip"	"$(0A.(B")
("jir"	"$(02;(B")
("jibi"	"$(0@<(B")
("jidi"	"$(0;r(B")
("jihs"	"$(1.k(B")
("jihaf"	"$(1ng(B")
("jijwj"	"$(0I&(B")
("jikf"	"$(1;6(B")
("jiln"	"$(1Am(B")
("jilmi"	"$(1?y(B")
("jimcw"	"$(1Bz(B")
("jimig"	"$(1?;(B")
("jinl"	"$(1NV(B")
("jiog"	"$(0Jq(B")
("jiobo"	"$(1?/(B")
("jiwtc"	"$(0Uc(B")
("jiyhv"	"$(0C{(B")
("jjb"	"$(0Ah(B")
("jji"	"$(0A=(B")
("jjk"	"$(13-(B")
("jju"	"$(01R(B")
("jjapp"	"$(0QJ(B")
("jjapv"	"$(1Zv(B")
("jjbb"	"$(1Tv(B")
("jjbc"	"$(1BP(B")
("jjbgr"	"$(1Tw(B")
("jjbtv"	"$(0QI(B")
("jjcor"	"$(1NQ(B")
("jjdmq"	"$(0X'(B")
("jjeee"	"$(0QD(B")
("jjfb"	"$(1NP(B")
("jjfdq"	"$(0[.(B")
("jjgce"	"$(1Ts(B")
("jjgow"	"$(1j+(B")
("jjgrv"	"$(0W`(B")
("jjhg"	"$(19e(B")
("jjhby"	"$(1H$(B")
("jjhdw"	"$(1gI(B")
("jjher"	"$(1H"(B")
("jjhju"	"$(1Zz(B")
("jjhkb"	"$(0[/(B")
("jjhml"	"$(0<~(B")
("jjhne"	"$(19d(B")
("jjhni"	"$(13.(B")
("jjhpm"	"$(1@k(B")
("jjhqo"	"$(0DK(B")
("jjhqu"	"$(19a(B")
("jjhsn"	"$(1@m(B")
("jjhvo"	"$(1@o(B")
("jjhvp"	"$(19b(B")
("jjhxu"	"$(1Tx(B")
("jjii"	"$(1Tt(B")
("jjir"	"$(1@r(B")
("jjijb"	"$(0M;(B")
("jjikk"	"$(1@d(B")
("jjipm"	"$(0I'(B")
("jjirp"	"$(1j,(B")
("jjixp"	"$(1cs(B")
("jjjii"	"$(0YL(B")
("jjjjj"	"$(0]3(B")
("jjjmu"	"$(1NN(B")
("jjjqr"	"$(0W](B")
("jjjtc"	"$(1gE(B")
("jjkn"	"$(05^(B")
("jjkcf"	"$(1gF(B")
("jjlo"	"$(14u(B")
("jjlw"	"$(0DJ(B")
("jjlbk"	"$(1@h(B")
("jjmj"	"$(0:G(B")
("jjmu"	"$(0:I(B")
("jjmbl"	"$(1H!(B")
("jjmdm"	"$(1oX(B")
("jjmfj"	"$(1@c(B")
("jjmig"	"$(0I((B")
("jjmlb"	"$(0QC(B")
("jjmnr"	"$(0DI(B")
("jjmrw"	"$(0TR(B")
("jjmsu"	"$(0?T(B")
("jjmvm"	"$(0M=(B")
("jjno"	"$(0?U(B")
("jjnau"	"$(0M>(B")
("jjnhd"	"$(1Zu(B")
("jjob"	"$(19c(B")
("jjod"	"$(0K7(B")
("jjon"	"$(0:r(B")
("jjoae"	"$(1Zx(B")
("jjodi"	"$(1@j(B")
("jjohf"	"$(1m)(B")
("jjohh"	"$(1@n(B")
("jjoii"	"$(1@l(B")
("jjoin"	"$(19f(B")
("jjoli"	"$(1Z,(B")
("jjomb"	"$(0QG(B")
("jjomg"	"$(1H#(B")
("jjomj"	"$(0Em(B")
("jjomn"	"$(0TT(B")
("jjoog"	"$(1d?(B")
("jjosm"	"$(0St(B")
("jjoyj"	"$(0K!(B")
("jjpr"	"$(1@i(B")
("jjpu"	"$(19`(B")
("jjpyr"	"$(1Zy(B")
("jjqkd"	"$(1_l(B")
("jjqkk"	"$(0TU(B")
("jjqmb"	"$(1Tr(B")
("jjrc"	"$(1@f(B")
("jjrhu"	"$(1@g(B")
("jjrsj"	"$(0TS(B")
("jjshi"	"$(0:H(B")
("jjshr"	"$(1@e(B")
("jjsit"	"$(1lG(B")
("jjsju"	"$(0M<(B")
("jjskr"	"$(1NO(B")
("jjsmh"	"$(1ct(B")
("jjsnd"	"$(1gG(B")
("jjstv"	"$(0W^(B")
("jjtc"	"$(1G~(B")
("jjtt"	"$(1G}(B")
("jjtav"	"$(1j-(B")
("jjtco"	"$(1gH(B")
("jjtcw"	"$(1Zt(B")
("jjtgi"	"$(1j*lH(B")
("jjumb"	"$(1Zw(B")
("jjvid"	"$(1n6(B")
("jjvvd"	"$(1cu(B")
("jjvvw"	"$(0QH(B")
("jjwd"	"$(1Tu(B")
("jjwlv"	"$(1j.(B")
("jjwot"	"$(1_m(B")
("jjwww"	"$(1n5(B")
("jjyg"	"$(1@q(B")
("jjybk"	"$(0YM(B")
("jjyck"	"$(0I%(B")
("jjyjj"	"$(1cv(B")
("jjypt"	"$(1oW(B")
("jjyrf"	"$(1Tq(B")
("jjyvo"	"$(1G|(B")
("jka"	"$(010(B")
("jkb"	"$(02l(B")
("jki"	"$(0+|(B")
("jkn"	"$(1!T(B")
("jkp"	"$(0*S(B")
("jkcf"	"$(0NN(B")
("jkhaf"	"$(1k((B")
("jkme"	"$(1QE(B")
("jkmr"	"$(0;m(B")
("jkmv"	"$(1I^(B")
("jkmdo"	"$(1eV(B")
("jkmhq"	"$(0Oc(B")
("jkmhu"	"$(1QC(B")
("jkmnd"	"$(1If(B")
("jkmsh"	"$(1Al(B")
("jkmwg"	"$(0YS(B")
("jknd"	"$(0+v(B")
("jkpr"	"$(1,s(B")
("jkss"	"$(0.7(B")
("jkys"	"$(0*T(B")
("jla"	"$(0O2(B")
("jlc"	"$(0[B(B")
("jld"	"$(1Q)(B")
("jlg"	"$(0J>(B")
("jlk"	"$(0)Q(B")
("jlv"	"$(0.g(B")
("jlw"	"$(0.}(B")
("jlln"	"$(0-h(B")
("jlmo"	"$(1)y(B")
("jlmr"	"$(1Xr(B")
("jlryo"	"$(1cr(B")
("jlwv"	"$(1Ig(B")
("jlyo"	"$(1(6(B")
("jmc"	"$(1n;(B")
("jmd"	"$(0)v(B")
("jmn"	"$(1!S(B")
("jmr"	"$(1&:(B")
("jmam"	"$(02h(B")
("jmch"	"$(0JQ(B")
("jmhc"	"$(0M4(B")
("jmig"	"$(02j(B")
("jmjmm"	"$(0^d(B")
("jmlc"	"$(0;l(B")
("jmmc"	"$(1TV(B")
("jmmf"	"$(0.y(B")
("jmmu"	"$(0+z(B")
("jmmv"	"$(07,(B")
("jmrw"	"$(0@o(B")
("jmso"	"$(07'(B")
("jmuc"	"$(0[k(B")
("jmue"	"$(0;k(B")
("jmyo"	"$(0.z(B")
("jnd"	"$(0)t(B")
("jngi"	"$(1\>(B")
("jnhaf"	"$(1qN(B")
("jniu"	"$(0.~(B")
("jnihq"	"$(1a:(B")
("jnln"	"$(1.+(B")
("jnmwl"	"$(0\](B")
("jnon"	"$(1OO(B")
("jnpfd"	"$(0[`(B")
("jnpru"	"$(1\?(B")
("jnqo"	"$(0R,(B")
("jnup"	"$(1;`(B")
("jnujt"	"$(1r<(B")
("jnyub"	"$(1nv(B")
("jogs"	"$(1Vh(B")
("joma"	"$(0;o(B")
("jombc"	"$(1`R(B")
("joni"	"$(0@((B")
("jose"	"$(1;:(B")
("jpa"	"$(09T(B")
("jph"	"$(1&9(B")
("jpbn"	"$(0JP(B")
("jpbq"	"$(1>2(B")
("jpbt"	"$(1;7(B")
("jphi"	"$(0Ln(B")
("jphu"	"$(0;p(B")
("jphqu"	"$(05$(B")
("jpko"	"$(1\e(B")
("jpmig"	"$(0CG(B")
("jqmp"	"$(0RU(B")
("jqmr"	"$(07&(B")
("jrb"	"$(05/(B")
("jrbhf"	"$(1k-(B")
("jrcor"	"$(0WP(B")
("jrhr"	"$(07)(B")
("jrhu"	"$(0+-(B")
("jrhaf"	"$(1m"$(0U8(B")
("jrhne"	"$(1K4(B")
("jrln"	"$(0@5(B")
("jrlr"	"$(0.{(B")
("jrmbc"	"$(0Ym(B")
("jrok"	"$(03K(B")
("jrrp"	"$(1;_(B")
("jrrye"	"$(1I5(B")
("jrytj"	"$(0DL(B")
("jskr"	"$(1.j(B")
("jsll"	"$(1.i$(02i(B")
("jsmh"	"$(0JR(B")
("jtak"	"$(0JO(B")
("jtbc"	"$(0D6(B")
("jtbi"	"$(0NO(B")
("jtcc"	"$(0WT(B")
("jtcd"	"$(0JT(B")
("jtcf"	"$(1m3$(0\V(B")
("jtcg"	"$(0ES(B")
("jtco"	"$(1_k(B")
("jtcq"	"$(0J{(B")
("jtcr"	"$(1_V(B")
("jtcu"	"$(1;8(B")
("jtcv"	"$(1Z?(B")
("jtcy"	"$(0@n(B")
("jtge"	"$(1e2(B")
("juhaf"	"$(1hG(B")
("jujru"	"$(0J!(B")
("juks"	"$(1)5(B")
("juln"	"$(02,6K(B")
("jvd"	"$(07{(B")
("jvhaf"	"$(1hKa%(B")
("jvmb"	"$(1;<(B")
("jvmd"	"$(0@q$(1\d(B")
("jvme"	"$(0JU(B")
("jvmr"	"$(1Ih$(0JV(B")
("jvmbc"	"$(1U`(B")
("jvnl"	"$(19n(B")
("jwj"	"$(0-P(B")
("jwbuu"	"$(1n%(B")
("jwjc"	"$(0JS(B")
("jwlb"	"$(0@p(B")
("jwlv"	"$(0RR(B")
("jybc"	"$(1;;(B")
("jybp"	"$(0Z1(B")
("jyfe"	"$(0;n(B")
("jytj"	"$(07%(B")
("k"	"$(0&L$(1!!(B")
("kb"	"$(1!/$(0*5(B")
("ke"	"$(0'/(B")
("kf"	"$(0*I4S(B")
("ki"	"$(0'5(B")
("kk"	"$(0'Z(B")
("km"	"$(1(7$(0(K(B")
("kn"	"$(0)k&'(B")
("kp"	"$(1$q(B")
("kr"	"$(0(.(B")
("ks"	"$(0&1(B")
("ku"	"$(00y&S(B")
("kam"	"$(08s(B")
("kau"	"$(04Q(B")
("kav"	"$(0>0(B")
("kamh"	"$(0Km(B")
("kanb"	"$(1]d(B")
("karrj"	"$(1o%(B")
("kbb"	"$(1E:(B")
("kbm"	"$(08o(B")
("kbbr"	"$(1L((B")
("kbcv"	"$(1md(B")
("kbhaf"	"$(1e'(B")
("kbhne"	"$(1=)(B")
("kbhqu"	"$(1D&(B")
("kbirm"	"$(1JA(B")
("kbmr"	"$(17F(B")
("kbmvn"	"$(1>1(B")
("kbnl"	"$(05j$(19v3@(B")
("kbno"	"$(16=(B")
("kbof"	"$(1X](B")
("kcano"	"$(1`A(B")
("kchne"	"$(0=E(B")
("kcipm"	"$(0Ep(B")
("kcln"	"$(02'(B")
("kdd"	"$(0G@(B")
("kdhe"	"$(08m(B")
("kdlc"	"$(0\z(B")
("kdln"	"$(1L&(B")
("kefh"	"$(1>5(B")
("keii"	"$(1R;(B")
("kell"	"$(1IS(B")
("kfb"	"$(1>:(B")
("kff"	"$(0G9(B")
("kfp"	"$(157(B")
("kfbt"	"$(0>5(B")
("kfcb"	"$(0Ol(B")
("kffs"	"$(0VC(B")
("kfhaf"	"$(1os(B")
("kgg"	"$(02Y(B")
("kgp"	"$(0Bp(B")
("kgdi"	"$(0>/(B")
("kghaf"	"$(1e*(B")
("khf"	"$(0-*(B")
("khi"	"$(1R>(B")
("khl"	"$(1$e(B")
("khs"	"$(11*(B")
("khaa"	"$(0=y(B")
("khal"	"$(1b9(B")
("kham"	"$(1(&(B")
("khav"	"$(04A(B")
("khahm"	"$(0B](B")
("khapp"	"$(17)(B")
("khapv"	"$(1=z(B")
("khawe"	"$(1Ku(B")
("khbm"	"$(00p(B")
("khbn"	"$(1E6(B")
("khbbb"	"$(0G+(B")
("khbbr"	"$(1=y(B")
("khbmr"	"$(1,&(B")
("khbou"	"$(1Ds(B")
("khbsd"	"$(0={(B")
("khbtt"	"$(1,'(B")
("khbuc"	"$(08[(B")
("khbue"	"$(1o:(B")
("khdc"	"$(1kn(B")
("khdd"	"$(1E;(B")
("khdn"	"$(0Bn(B")
("khdv"	"$(0G>(B")
("khdlc"	"$(0ZL(B")
("khey"	"$(08p(B")
("khefh"	"$(10e(B")
("khfbk"	"$(1R*(B")
("khgr"	"$(1,"(B")
("khggu"	"$(1R$(B")
("khgrv"	"$(0G*(B")
("khhg"	"$(1$h(B")
("khhj"	"$(0G=(B")
("khhl"	"$(1&%(B")
("khhw"	"$(0Oo(B")
("khhbn"	"$(17*(B")
("khhdn"	"$(10l(B")
("khhgf"	"$(1]R(B")
("khhhj"	"$(17,(B")
("khhkb"	"$(1R+(B")
("khhni"	"$(1=|(B")
("khhqm"	"$(1('(B")
("khhrb"	"$(0G)(B")
("khhsb"	"$(17.=~(B")
("khhsk"	"$(1XK(B")
("khhvo"	"$(00r(B")
("khhxe"	"$(1Dt(B")
("khhxf"	"$(1R((B")
("khhxu"	"$(17+(B")
("khij"	"$(1,#(B")
("khio"	"$(11.(B")
("khiv"	"$(1(!(B")
("khiav"	"$(08Y(B")
("khibi"	"$(1Dp(B")
("khice"	"$(10k(B")
("khihu"	"$(1$f(B")
("khitc"	"$(0Xd(B")
("khjc"	"$(1'}(B")
("khjr"	"$(1(#(B")
("khjdi"	"$(04@(B")
("khjjl"	"$(1Kt(B")
("khjkp"	"$(1,$(B")
("khjpn"	"$(0V=(B")
("khjrb"	"$(1=v(B")
("khkn"	"$(1!e(B")
("khkcf"	"$(1R%(B")
("khkkb"	"$(10i(B")
("khkmr"	"$(17'(B")
("khkoo"	"$(08Z(B")
("khlln"	"$(1($(B")
("khlmo"	"$(1,((B")
("khmg"	"$(0-+(B")
("khmj"	"$(1"c(B")
("khmam"	"$(1,%(B")
("khmbb"	"$(1]P(B")
("khmbe"	"$(1b-(B")
("khmce"	"$(1m_(B")
("khmfb"	"$(1]Q(B")
("khmfm"	"$(1("(B")
("khmhf"	"$(1Dq(B")
("khmmf"	"$(1'~(B")
("khmto"	"$(0Oe(B")
("khmvh"	"$(1$c(B")
("khne"	"$(04P(B")
("khng"	"$(1$d(B")
("khni"	"$(0Kn(B")
("khnbq"	"$(1XJ(B")
("khndf"	"$(1Dr(B")
("khndt"	"$(0=x(B")
("khngu"	"$(1.r(B")
("khnhb"	"$(1R&(B")
("khnhd"	"$(1=w(B")
("khnkm"	"$(17-(B")
("khnmb"	"$(1i>(B")
("khok"	"$(0[|$(1b<(B")
("khon"	"$(1"d(B")
("khoo"	"$(1X^(B")
("khoii"	"$(1(((B")
("khoir"	"$(1Du(B")
("khoma"	"$(1XM(B")
("khomd"	"$(10j(B")
("khomo"	"$(1XL(B")
("khomr"	"$(17/(B")
("khonk"	"$(0B\(B")
("khpa"	"$(1E8(B")
("khpr"	"$(00q(B")
("khppg"	"$(10g(B")
("khqhk"	"$(1=u(B")
("khqhl"	"$(10h(B")
("khqkd"	"$(1Dv(B")
("khqmb"	"$(0=w(B")
("khrb"	"$(08](B")
("khrrk"	"$(1o9(B")
("khrye"	"$(1=x(B")
("khsp"	"$(1(%(B")
("khsu"	"$(0(h(B")
("khtav"	"$(1XH(B")
("khtco"	"$(1R'(B")
("khtcw"	"$(0BZ(B")
("khtjl"	"$(1o8(B")
("khtmc"	"$(1R)(B")
("khtoe"	"$(0V>(B")
("khtrg"	"$(1kl(B")
("khub"	"$(0ZR(B")
("khup"	"$(1R=(B")
("khuce"	"$(1=}(B")
("khvp"	"$(1,?(B")
("khvno"	"$(1={(B")
("khvvv"	"$(0Xe(B")
("khwd"	"$(0=z(B")
("khwg"	"$(08\(B")
("khwl"	"$(00o(B")
("khwlg"	"$(0]g(B")
("khwli"	"$(0SB(B")
("khwlv"	"$(1XI(B")
("khwmv"	"$(0B[(B")
("khxe"	"$(0Op(B")
("khxo"	"$(1E7(B")
("khxv"	"$(1b:(B")
("khye"	"$(0Or(B")
("khyy"	"$(1$b(B")
("khyck"	"$(04B(B")
("khyhn"	"$(1$g(B")
("khymh"	"$(1XG(B")
("khymr"	"$(10f(B")
("khyoj"	"$(17&(B")
("khypu"	"$(17((B")
("khyrk"	"$(0Kc(B")
("khyrv"	"$(1i=(B")
("khytg"	"$(1R#(B")
("khytj"	"$(0Kd(B")
("khytu"	"$(1Ks(B")
("kiv"	"$(1"3(B")
("kice"	"$(0Bt(B")
("kijb"	"$(1>7(B")
("kiku"	"$(04T(B")
("kiog"	"$(0Du(B")
("kismm"	"$(12((B")
("kiuh"	"$(1>9(B")
("kjt"	"$(0.e(B")
("kjbc"	"$(1R@(B")
("kjcc"	"$(0^cG;(B")
("kjka"	"$(1E0$(0;^(B")
("kjkd"	"$(1>6(B")
("kjrr"	"$(1E/(B")
("kkb"	"$(018$(17D(B")
("kkn"	"$(0>3(B")
("kks"	"$(1!R(B")
("kkcf"	"$(0VD(B")
("kkhaf"	"$(1qSnh(B")
("kkkk"	"$(0=t(B")
("kklb"	"$(0,)(B")
("kklu"	"$(1E2(B")
("kkog"	"$(1R:(B")
("kkop"	"$(1XY(B")
("kkrb"	"$(0SL(B")
("kksr"	"$(08r(B")
("klb"	"$(0(M(B")
("klg"	"$(0)d(B")
("kln"	"$(0'$(B")
("klll"	"$(1",(B")
("klln"	"$(11,(B")
("klmi"	"$(17E(B")
("klmy"	"$(0G<(B")
("klnd"	"$(0)u(B")
("klwu"	"$(0.d(B")
("kmn"	"$(1$p(B")
("kmaa"	"$(0NG(B")
("kmbw"	"$(1b=(B")
("kmfr"	"$(0Bs(B")
("kmmf"	"$(0.c(B")
("kmmr"	"$(1>8(B")
("kmms"	"$(0)l(B")
("kmnr"	"$(0.b(B")
("kmob"	"$(08k(B")
("kmrt"	"$(0Br(B")
("kmso"	"$(1E1(B")
("kmvm"	"$(0Bq(B")
("kmwf"	"$(1XX(B")
("kmym"	"$(08l(B")
("kna"	"$(0*2$(1"O(B")
("kni"	"$(1!9$(0&;(B")
("kno"	"$(00{(B")
("knbk"	"$(0Kp(B")
("kncr"	"$(1b>(B")
("knfq"	"$(0]k(B")
("knhaf"	"$(0In(B")
("knib"	"$(0Bo(B")
("knin"	"$(1)c7G(B")
("knlm"	"$(1]a(B")
("knlp"	"$(0]j(B")
("knlr"	"$(1E3(B")
("knmbc"	"$(1:4(B")
("knoe"	"$(1]b(B")
("knthu"	"$(1:6(B")
("knymr"	"$(1-R(B")
("knypu"	"$(12Z(B")
("kog"	"$(1E<(B")
("kok"	"$(08j(B")
("kon"	"$(00z(B")
("koo"	"$(0+i(B")
("kogi"	"$(0JE(B")
("kogw"	"$(0RN(B")
("kohh"	"$(08q(B")
("kohaf"	"$(1e!(B")
("koir"	"$(0Oq(B")
("kokr"	"$(0G?(B")
("koll"	"$(04R(B")
("koma"	"$(1b;(B")
("komg"	"$(0>2(B")
("komn"	"$(0Ko(B")
("komp"	"$(0Xk(B")
("kombc"	"$(0U!(B")
("konk"	"$(1L)(B")
("konl"	"$(13<(B")
("koog"	"$(1>;(B")
("kowy"	"$(1><(B")
("kpp"	"$(1,@(B")
("kpr"	"$(11+(B")
("kpt"	"$(11-(B")
("kpblb"	"$(0<((B")
("kpko"	"$(0ZS(B")
("kqhk"	"$(1L%(B")
("kqhp"	"$(1RA(B")
("krc"	"$(11)(B")
("krd"	"$(03_(B")
("krbuc"	"$(0D8(B")
("krhaf"	"$(1\8hN(B")
("krhqu"	"$(1+M(B")
("krje"	"$(1<9(B")
("krln"	"$(1.-(B")
("krmnr"	"$(1.<(B")
("krno"	"$(1=!(B")
("krrj"	"$(1]c(B")
("krru"	"$(0VE(B")
("krsqf"	"$(0Q|(B")
("krye"	"$(1<:L'(B")
("kryhv"	"$(0?7(B")
("ksj"	"$(1,w(B")
("ksr"	"$(0'|(B")
("ksce"	"$(1b8(B")
("kshaf"	"$(1a)(B")
("kshvf"	"$(1F,(B")
("kshvo"	"$(0>%(B")
("ksksb"	"$(09^(B")
("kskss"	"$(1"!(B")
("ksksv"	"$(1)x(B")
("ksln"	"$(1%S(B")
("ksmb"	"$(0SM(B")
("ksmh"	"$(1X[(B")
("ksmi"	"$(06q(B")
("kspru"	"$(0;2(B")
("ksrj"	"$(0Xi(B")
("ksrr"	"$(0JF(B")
("kswp"	"$(0N/(B")
("ktm"	"$(08n(B")
("ktq"	"$(17C,q(B")
("ktak"	"$(1X\(B")
("ktbc"	"$(1E9(B")
("ktjr"	"$(1L*(B")
("ktlm"	"$(1XZ(B")
("ktog"	"$(0^b(B")
("ktor"	"$(0Om(B")
("ktov"	"$(0[{(B")
("ktqm"	"$(1R9(B")
("ktuo"	"$(1R?(B")
("ktwb"	"$(0Xj(B")
("kubbb"	"$(1BS(B")
("kuhaf"	"$(0[[(B")
("kuhjg"	"$(1;>(B")
("kumg"	"$(1#_(B")
("kuoll"	"$(0+}(B")
("kupi"	"$(1"6(B")
("kusit"	"$(0UT(B")
("kvfb"	"$(1r=(B")
("kvug"	"$(1o;(B")
("kwr"	"$(17H(B")
("kwjr"	"$(1E4(B")
("kwle"	"$(1R<(B")
("kwml"	"$(1E5(B")
("kwot"	"$(0On(B")
("kwvf"	"$(1X_(B")
("kyg"	"$(11'(B")
("kyr"	"$(11((B")
("kyx"	"$(1f((B")
("kymp"	"$(0>1(B")
("kyoj"	"$(0G:(B")
("kypm"	"$(0Kl(B")
("kysk"	"$(1XW(B")
("kysy"	"$(0G8(B")
("kyta"	"$(1L$(B")
("kytj"	"$(0SK(B")
("kyvo"	"$(17B(B")
("l"	"$(0&d(B")
("la"	"$(12u(B")
("lb"	"$(0&[(B")
("lk"	"$(0(9(B")
("ll"	"$(0*l$(12v(B")
("ln"	"$(0:o(B")
("lp"	"$(0/A(B")
("lq"	"$(0*X(B")
("lu"	"$(0&+(B")
("lw"	"$(0(r(B")
("lx"	"$(0CI(B")
("laa"	"$(1N&(B")
("lam"	"$(0?9(B")
("lav"	"$(1@6(B")
("lamo"	"$(1T4(B")
("lanb"	"$(1cG(B")
("lanw"	"$(1oM(B")
("laph"	"$(1N'(B")
("lapv"	"$(0Pn(B")
("lasm"	"$(1ZI(B")
("late"	"$(1l:(B")
("lbk"	"$(0(B(B")
("lbm"	"$(19H(B")
("lbt"	"$(04\(B")
("lbu"	"$(1!6(B")
("lbau"	"$(1#k(B")
("lbabu"	"$(0@{(B")
("lbafu"	"$(0El(B")
("lbawe"	"$(0J`(B")
("lbayf"	"$(1P<(B")
("lbbac"	"$(1B`(B")
("lbbhx"	"$(1Bb(B")
("lbcru"	"$(1.w(B")
("lbdhe"	"$(1&P(B")
("lbdmq"	"$(0@}(B")
("lbfb"	"$(1.v(B")
("lbgr"	"$(0M!(B")
("lbgni"	"$(1\g(B")
("lbha"	"$(0//(B")
("lbhal"	"$(1Vy(B")
("lbhdw"	"$(0NX(B")
("lbhni"	"$(0)~(B")
("lbhqo"	"$(1&Q(B")
("lbii"	"$(15+(B")
("lbigi"	"$(1aS(B")
("lbiih"	"$(1I{(B")
("lbikk"	"$(1&O(B")
("lbjj"	"$(1T.(B")
("lbjka"	"$(15*(B")
("lbjmo"	"$(1B_(B")
("lbjqp"	"$(1eM(B")
("lbjtc"	"$(1P9(B")
("lblbu"	"$(1#l(B")
("lbme"	"$(1T6(B")
("lbmn"	"$(1!Y(B")
("lbmbc"	"$(1;YBa(B")
("lbmrw"	"$(0@z(B")
("lbnl"	"$(1@~(B")
("lbncr"	"$(1Vw(B")
("lbog"	"$(0<*(B")
("lbomr"	"$(1*3(B")
("lbotf"	"$(1P;(B")
("lbqmc"	"$(1Iy(B")
("lbrrd"	"$(1Vv(B")
("lbrrj"	"$(1P:(B")
("lbsmg"	"$(1;X(B")
("lbsmv"	"$(0<)(B")
("lbtt"	"$(1*2(B")
("lbtak"	"$(1Iz(B")
("lbtbo"	"$(1\h(B")
("lbtwi"	"$(1aR(B")
("lbwim"	"$(0J_(B")
("lbyr"	"$(0/.(B")
("lbybc"	"$(0@|(B")
("lbyia"	"$(0NW(B")
("lbytg"	"$(0NV(B")
("lbytj"	"$(0J\(B")
("lcnl"	"$(1U#(B")
("lcor"	"$(0HV(B")
("lcru"	"$(1G>(B")
("lcsh"	"$(12{(B")
("ldk"	"$(0:2(B")
("ldbb"	"$(1cA(B")
("lddf"	"$(0Zw(B")
("lddq"	"$(1q<(B")
("ldhe"	"$(0?8(B")
("ldmq"	"$(1T2(B")
("lei"	"$(1-P(B")
("leed"	"$(1ZH(B")
("leee"	"$(1N*(B")
("lff"	"$(1N!(B")
("lfq"	"$(19:(B")
("lfbk"	"$(1_D(B")
("lfbw"	"$(0Zv(B")
("lfqu"	"$(1M~(B")
("lga"	"$(07u(B")
("lgb"	"$(19>(B")
("lgi"	"$(19;(B")
("lgr"	"$(1@*(B")
("lgam"	"$(0=%(B")
("lgce"	"$(1N+(B")
("lggu"	"$(1c@(B")
("lggy"	"$(0Lx(B")
("lgrc"	"$(1l8(B")
("lgwc"	"$(1l9(B")
("lgwm"	"$(0Bl(B")
("lha"	"$(19B(B")
("lhg"	"$(0:3(B")
("lhbk"	"$(0Zx(B")
("lheq"	"$(1@0(B")
("lher"	"$(1@1(B")
("lhhh"	"$(05R(B")
("lhhj"	"$(0L}(B")
("lhjd"	"$(1@/(B")
("lhoo"	"$(1_E(B")
("lhpm"	"$(19C(B")
("lhqo"	"$(19?(B")
("lhsb"	"$(0Ps(B")
("lhul"	"$(1ix(B")
("lhvp"	"$(0:4(B")
("lhyu"	"$(0T4(B")
("lia"	"$(12n(B")
("lid"	"$(12a(B")
("lim"	"$(05N(B")
("liau"	"$(12d(B")
("liav"	"$(1?}(B")
("liabu"	"$(1Sz(B")
("liahu"	"$(1Sw(B")
("liail"	"$(1G2(B")
("liamh"	"$(1Sy(B")
("liamo"	"$(1Sx(B")
("liaph"	"$(0Lr(B")
("liapv"	"$(1S{(B")
("liavo"	"$(0Zs(B")
("liawe"	"$(1_1(B")
("libm"	"$(0?0(B")
("libp"	"$(1Z>(B")
("libac"	"$(0T,(B")
("libbb"	"$(1Z/(B")
("libbr"	"$(0Pf(B")
("libcv"	"$(1oK(B")
("libdi"	"$(1G7(B")
("libgr"	"$(0Lv(B")
("libme"	"$(1S~(B")
("libnd"	"$(1G5(B")
("libue"	"$(1q_(B")
("libug"	"$(1pN(B")
("libuu"	"$(0HK(B")
("libvk"	"$(1Z2(B")
("lici"	"$(0:-(B")
("lick"	"$(12h(B")
("licim"	"$(1Z<(B")
("licru"	"$(0HH(B")
("licsh"	"$(12j(B")
("lidk"	"$(12c(B")
("lidw"	"$(1Mb(B")
("lidci"	"$(1Mf(B")
("lidhe"	"$(195(B")
("lidhl"	"$(0Lq(B")
("lieee"	"$(1Mh(B")
("liesd"	"$(1c?(B")
("lifb"	"$(1G3(B")
("lifbg"	"$(0W9(B")
("lifbw"	"$(1fm(B")
("liffd"	"$(1it(B")
("liffs"	"$(1c)(B")
("lifqu"	"$(0Lu(B")
("ligb"	"$(19)(B")
("ligg"	"$(0Cs(B")
("ligr"	"$(1?z(B")
("liggu"	"$(0Y8(B")
("ligrr"	"$(1c+(B")
("ligth"	"$(1c,(B")
("lihi"	"$(1Z7(B")
("lihn"	"$(1(k(B")
("lihp"	"$(1-I(B")
("lihs"	"$(0?2(B")
("lihad"	"$(1_2(B")
("lihag"	"$(0Pi(B")
("lihdj"	"$(0Pj(B")
("lihdn"	"$(0HL(B")
("lihdp"	"$(0W@(B")
("lihdv"	"$(1Mn(B")
("lihdw"	"$(0Y;(B")
("lihej"	"$(0HI(B")
("lihhj"	"$(1Mt(B")
("lihjd"	"$(0Cv(B")
("lihjg"	"$(1T+(B")
("lihjr"	"$(0Cy(B")
("lihkb"	"$(1c4(B")
("lihlb"	"$(1T"(B")
("lihml"	"$(12f(B")
("lihmy"	"$(19.(B")
("lihpm"	"$(19-(B")
("lihqi"	"$(0HG(B")
("lihqo"	"$(19+(B")
("lihqu"	"$(12o(B")
("lihrb"	"$(1Z8(B")
("lihrf"	"$(1Z5(B")
("lihsb"	"$(0Ph(B")
("lihsk"	"$(1Mx(B")
("lihsu"	"$(12g(B")
("lihuk"	"$(1Z6(B")
("lihup"	"$(1Z4(B")
("lihvo"	"$(19/(B")
("lihvp"	"$(12q(B")
("lihwp"	"$(1_3(B")
("lihxu"	"$(1Ms(B")
("lihyu"	"$(1Z9(B")
("liih"	"$(1_F(B")
("liiav"	"$(1G+(B")
("liihq"	"$(1@&(B")
("liihv"	"$(1Sr(B")
("liiil"	"$(0Pa(B")
("liijb"	"$(1G9(B")
("liije"	"$(1G-(B")
("liikf"	"$(1Sn(B")
("liikk"	"$(19&(B")
("liiku"	"$(12m(B")
("liilr"	"$(1Z*(B")
("liioc"	"$(1fi(B")
("liirm"	"$(1Mc(B")
("liitc"	"$(1fu(B")
("liitf"	"$(1_)(B")
("liitu"	"$(1Sm(B")
("liiuh"	"$(1G0(B")
("liixp"	"$(1_*(B")
("lijb"	"$(0HQ(B")
("lije"	"$(12`(B")
("lijj"	"$(0T2(B")
("lijp"	"$(0?+(B")
("lijr"	"$(0?.(B")
("lijbj"	"$(1T'(B")
("lijcg"	"$(1_>(B")
("lijip"	"$(1c.(B")
("lijjl"	"$(1_,(B")
("lijka"	"$(1Ma(B")
("lijlo"	"$(1M`(B")
("lijmc"	"$(1ir_&(B")
("lijmm"	"$(1Sj(B")
("lijnu"	"$(0Lm(B")
("lijqr"	"$(1Z((B")
("lijrb"	"$(0Pb(B")
("lijtc"	"$(1c*(B")
("likk"	"$(19<(B")
("likn"	"$(1?x(B")
("likcf"	"$(1c0(B")
("likok"	"$(1Z)(B")
("likoo"	"$(1G/(B")
("likpb"	"$(1_/(B")
("lilw"	"$(19*(B")
("lilii"	"$(0Y:(B")
("lilit"	"$(0^H(B")
("lille"	"$(1Mv(B")
("lilmq"	"$(1Ml(B")
("lilwv"	"$(0W=(B")
("lilxl"	"$(1Mu(B")
("lima"	"$(1@%(B")
("limj"	"$(1-H(B")
("limn"	"$(1(h(B")
("limbb"	"$(0\;(B")
("limbc"	"$(1T)(B")
("limbk"	"$(1St(B")
("limfm"	"$(194(B")
("limhf"	"$(1Z-(B")
("limig"	"$(0Ct(B")
("limmu"	"$(12^(B")
("limmv"	"$(1G,(B")
("limnn"	"$(1?{(B")
("limnr"	"$(0?/(B")
("limob"	"$(193(B")
("limrw"	"$(0Pd(B")
("limtb"	"$(0]%(B")
("limvh"	"$(0:.(B")
("limvm"	"$(1G1(B")
("limwf"	"$(1_-(B")
("limwj"	"$(1c-(B")
("limwl"	"$(1Ss(B")
("linl"	"$(0:)(B")
("linao"	"$(1c5(B")
("linbc"	"$(1T$(B")
("lincr"	"$(0Zu(B")
("lindt"	"$(0Lp(B")
("linhd"	"$(1Su(B")
("linhx"	"$(1Mp(B")
("linib"	"$(0HB(B")
("linkg"	"$(0HC(B")
("linkm"	"$(1Mr(B")
("linmu"	"$(1?~(B")
("linob"	"$(1Sv(B")
("linue"	"$(1Mi(B")
("liob"	"$(12e(B")
("liog"	"$(1Mq(B")
("liom"	"$(0?3(B")
("lion"	"$(1-J(B")
("lioae"	"$(1T#(B")
("liodi"	"$(19,(B")
("liogf"	"$(1c6(B")
("lioii"	"$(0?4(B")
("lioin"	"$(12i(B")
("liokr"	"$(0Ls(B")
("lioll"	"$(12k(B")
("liomb"	"$(1Mw(B")
("liomd"	"$(1G8(B")
("liomn"	"$(0Pk(B")
("liomr"	"$(0Cw(B")
("liono"	"$(1G6(B")
("liopc"	"$(1c7(B")
("liosk"	"$(1@!(B")
("lipi"	"$(1-K(B")
("lipp"	"$(12_(B")
("lipr"	"$(192(B")
("lipim"	"$(12p(B")
("lipou"	"$(1Mo(B")
("lippa"	"$(1Sq(B")
("lippg"	"$(1G.(B")
("liptd"	"$(0Pc(B")
("liqj"	"$(0:,(B")
("liqo"	"$(12](B")
("liqkd"	"$(1Z+(B")
("liqmb"	"$(0Lo(B")
("liqmy"	"$(1So(B")
("lirb"	"$(1G4(B")
("lirrj"	"$(0Y9(B")
("liruc"	"$(1c2(B")
("lirvk"	"$(0HD(B")
("lirxu"	"$(0Zr(B")
("lirye"	"$(0Pe(B")
("lish"	"$(1(j(B")
("liso"	"$(12b(B")
("liss"	"$(19%(B")
("lisav"	"$(1Sp(B")
("lisem"	"$(1oJ(B")
("lishr"	"$(19'(B")
("lisjr"	"$(1Mg(B")
("lismg"	"$(1iu(B")
("lismh"	"$(1_0(B")
("lismi"	"$(1c1(B")
("lisqf"	"$(0T-(B")
("lisrg"	"$(1fl(B")
("lisyi"	"$(1qu(B")
("lita"	"$(1Me(B")
("litb"	"$(1ZG(B")
("litm"	"$(0?-(B")
("litq"	"$(1?v(B")
("litt"	"$(1?w(B")
("litw"	"$(0Cx(B")
("litak"	"$(0W;(B")
("litbo"	"$(1iv(B")
("litcw"	"$(1Sl(B")
("litgi"	"$(0Zq(B")
("litgu"	"$(1M_(B")
("litit"	"$(0W:(B")
("litlk"	"$(1T*(B")
("litlm"	"$(1_.(B")
("litlx"	"$(1m}(B")
("litmc"	"$(1c/Md(B")
("litoe"	"$(1iw(B")
("litpd"	"$(1fv(B")
("litrg"	"$(1pM(B")
("litwa"	"$(1_+(B")
("litwi"	"$(1l2(B")
("liuce"	"$(1T!(B")
("liumt"	"$(1Z0(B")
("liuob"	"$(1pO(B")
("livl"	"$(1(i(B")
("livii"	"$(1c8(B")
("livis"	"$(190(B")
("livno"	"$(1S}(B")
("livvv"	"$(0]((B")
("liwb"	"$(1S|(B")
("liwd"	"$(1Mk(B")
("liwr"	"$(0Cu(B")
("liwgf"	"$(1c3(B")
("liwhd"	"$(1Mm(B")
("liwim"	"$(0W?(B")
("liwli"	"$(1fp(B")
("liwlj"	"$(1fo(B")
("liwlv"	"$(1fn(B")
("liwot"	"$(1Z1(B")
("liwvf"	"$(0W>(B")
("liwww"	"$(1l1(B")
("liyg"	"$(0?,(B")
("liyj"	"$(0:((B")
("liyk"	"$(0:'(B")
("liyr"	"$(19((B")
("liyv"	"$(05O(B")
("liyx"	"$(1is(B")
("liyav"	"$(1Z.(B")
("liybp"	"$(1m|(B")
("liybs"	"$(0T+(B")
("liycb"	"$(1_'(B")
("liyck"	"$(0Cr(B")
("liyhn"	"$(12\(B")
("liyia"	"$(1c;(B")
("liyij"	"$(0W7(B")
("liypt"	"$(1m~(B")
("liyra"	"$(1l0(B")
("liyrd"	"$(1M^(B")
("liyrn"	"$(1T&(B")
("liyro"	"$(0\:(B")
("liyrv"	"$(1oH(B")
("liysd"	"$(1Sk(B")
("liytj"	"$(0W8(B")
("liyub"	"$(1_((B")
("liyvi"	"$(19$(B")
("liywm"	"$(1fj(B")
("ljc"	"$(198(B")
("lje"	"$(13!(B")
("ljp"	"$(197(B")
("ljcr"	"$(1ZF(B")
("ljic"	"$(1oL(B")
("ljka"	"$(0L~(B")
("lkbt"	"$(08x(B")
("lkhaf"	"$(0U9(B")
("lkld"	"$(1@-(B")
("lklu"	"$(1N$(B")
("lkma"	"$(1l;(B")
("lkoo"	"$(1GA(B")
("lll"	"$(0&V(B")
("lln"	"$(0(R(B")
("llp"	"$(0<>(B")
("llw"	"$(0?:(B")
("llamh"	"$(0K$(B")
("llbu"	"$(12~(B")
("lldwf"	"$(1Jc(B")
("llfq"	"$(1+y(B")
("llgwc"	"$(0ZI(B")
("llhe"	"$(00k(B")
("llhhj"	"$(0BW(B")
("llhsb"	"$(0Ob(B")
("llii"	"$(1=l(B")
("lllc"	"$(0D|(B")
("llml"	"$(0'[(B")
("llmy"	"$(1N((B")
("llomn"	"$(1Dj(B")
("llpb"	"$(1T3(B")
("llptd"	"$(0G'(B")
("llshr"	"$(1+z(B")
("llwv"	"$(0WD(B")
("llww"	"$(1%2(B")
("llxl"	"$(1N,(B")
("llybs"	"$(1Kn(B")
("lma"	"$(1@,(B")
("lmd"	"$(1-N(B")
("lmi"	"$(0*f(B")
("lmp"	"$(0("(B")
("lmbb"	"$(1iy(B")
("lmbuc"	"$(0D9(B")
("lmfbc"	"$(1Z`(B")
("lmfbt"	"$(0Kq(B")
("lmlb"	"$(1N#(B")
("lmln"	"$(0J#(B")
("lmmm"	"$(05w(B")
("lmmp"	"$(1q9(B")
("lmmv"	"$(1G:(B")
("lmpnl"	"$(01Y(B")
("lmrt"	"$(1G;(B")
("lmrw"	"$(1T/(B")
("lmuo"	"$(0)?(B")
("lmuoc"	"$(0Qp(B")
("lmuou"	"$(0HX(B")
("lmvi"	"$(0T3(B")
("lmwf"	"$(1_B(B")
("lmwu"	"$(1_A(B")
("lmyq"	"$(01/(B")
("lmyyn"	"$(1./(B")
("lmyyy"	"$(01g(B")
("lnao"	"$(1cE(B")
("lnbuc"	"$(0D7(B")
("lncr"	"$(1f|(B")
("lnhe"	"$(12y(B")
("lnhxu"	"$(1dk(B")
("lnii"	"$(1_C(B")
("lnln"	"$(1#.(B")
("lnmjk"	"$(1nU(B")
("lnnau"	"$(18](B")
("lnnxu"	"$(1r5(B")
("lnoe"	"$(1cB(B")
("lntc"	"$(0U5(B")
("lnylb"	"$(0R$(B")
("lob"	"$(12w(B")
("loae"	"$(0Po(B")
("lohh"	"$(19D(B")
("loik"	"$(0C}(B")
("loim"	"$(1oN(B")
("loin"	"$(12z(B")
("loma"	"$(1f}(B")
("lomn"	"$(0Pr(B")
("lomo"	"$(1f~(B")
("lomr"	"$(1@2(B")
("lopd"	"$(19@(B")
("lord"	"$(0Pq(B")
("lpb"	"$(05.(B")
("lpd"	"$(1-O(B")
("lpr"	"$(19A(B")
("lpim"	"$(12x(B")
("lpru"	"$(0?;(B")
("lptd"	"$(1T0(B")
("lpwtc"	"$(0R6(B")
("lqo"	"$(12t(B")
("lqhk"	"$(1T8(B")
("lqmv"	"$(1N"(B")
("lqmat"	"$(1pP(B")
("lrb"	"$(1GB(B")
("lrhg"	"$(1G=(B")
("lrrd"	"$(1g!(B")
("lrrj"	"$(1cC(B")
("lsh"	"$(01P(B")
("lsav"	"$(1T1(B")
("lshr"	"$(19=(B")
("lsit"	"$(0\<(B")
("lsjr"	"$(1N%(B")
("lskr"	"$(0HP(B")
("lsma"	"$(0WB(B")
("lsmi"	"$(1cF(B")
("ltbi"	"$(1q:(B")
("ltco"	"$(1cD(B")
("ltgi"	"$(1q;(B")
("ltor"	"$(0T5(B")
("ltwi"	"$(0])(B")
("ltwv"	"$(1fy(B")
("lue"	"$(1'd(B")
("luhaf"	"$(0R)(B")
("lunl"	"$(1%*(B")
("lvr"	"$(1@3(B")
("lvbu"	"$(053(B")
("lvhaf"	"$(1nl(B")
("lvhqu"	"$(1QA(B")
("lvis"	"$(19I(B")
("lvno"	"$(1T5(B")
("lvok"	"$(0O0(B")
("lwb"	"$(05-2%(B")
("lwd"	"$(0L{$(1G<(B")
("lwg"	"$(0HT(B")
("lwk"	"$(1@.(B")
("lwl"	"$(0(t(B")
("lwp"	"$(0*4(B")
("lwli"	"$(1f{(B")
("lwlj"	"$(1fz(B")
("lwlp"	"$(0]*(B")
("lwlv"	"$(0;`(B")
("lwmvs"	"$(1$o(B")
("lwot"	"$(1Z=(B")
("lxhaf"	"$(1ou(B")
("lyd"	"$(1<k(B")
("lyk"	"$(14Q(B")
("lyp"	"$(0A,(B")
("lyv"	"$(14^(B")
("lyav"	"$(0T1(B")
("lybb"	"$(1T-(B")
("lybp"	"$(1n#(B")
("lydu"	"$(0]s(B")
("lyiu"	"$(1@+(B")
("lyjj"	"$(1_@(B")
("lyjwj"	"$(0QE(B")
("lylmi"	"$(1M{(B")
("lyoiv"	"$(1`X(B")
("lysmm"	"$(0LK(B")
("lyto"	"$(1fx(B")
("lyub"	"$(1_?(B")
("lyvi"	"$(199(B")
("lywm"	"$(1fw(B")
("lyyk"	"$(0AZ(B")
("lyyhv"	"$(0Ly(B")
("m"	"$(0&"(B")
("ma"	"$(0*L(B")
("md"	"$(0&A(B")
("me"	"$(0,g(B")
("mf"	"$(0&c(B")
("mg"	"$(0'_(B")
("mh"	"$(1!%(B")
("mj"	"$(0&\(B")
("mk"	"$(0'3(B")
("ml"	"$(1!'(B")
("mm"	"$(0&)(B")
("mn"	"$(0&$(B")
("mo"	"$(0&w(B")
("mr"	"$(0(|(B")
("ms"	"$(1!&(B")
("mt"	"$(1"<(B")
("mu"	"$(1!+$(0&C(B")
("mv"	"$(1!$(B")
("my"	"$(0&7(B")
("mad"	"$(1ec(B")
("mai"	"$(1J?(B")
("mabk"	"$(0J&(B")
("mahr"	"$(1I/(B")
("mama"	"$(1>=(B")
("mamr"	"$(0Ky(B")
("mand"	"$(025(B")
("manl"	"$(1H/(B")
("mbk"	"$(1,t(B")
("mbm"	"$(0)((B")
("mbp"	"$(1/#(B")
("mbv"	"$(05&(B")
("mbw"	"$(0IY(B")
("mbbhg"	"$(0^"(B")
("mbbhv"	"$(1dF(B")
("mbbmo"	"$(1dG(B")
("mbcsh"	"$(1AN(B")
("mbdd"	"$(0Tw(B")
("mbdi"	"$(05%(B")
("mbdbu"	"$(0X$(B")
("mbddh"	"$(1gm(B")
("mbed"	"$(1UY(B")
("mbebg"	"$(0[F(B")
("mbebr"	"$(1`G(B")
("mbejb"	"$(1UX(B")
("mbemm"	"$(1q|(B")
("mbeni"	"$(1[_(B")
("mbetc"	"$(1`F(B")
("mbetv"	"$(1jW(B")
("mbeyr"	"$(0Tv(B")
("mbfb"	"$(0Qg(B")
("mbhaf"	"$(1qOa*m'(B")
("mbhfd"	"$(1H_(B")
("mbhhh"	"$(1,u(B")
("mbhhw"	"$(0Yh(B")
("mbhok"	"$(1l_(B")
("mbhxu"	"$(0Ty(B")
("mbjlv"	"$(1[](B")
("mbks"	"$(0UE(B")
("mbll"	"$(0*U(B")
("mblbk"	"$(1Ha(B")
("mblmi"	"$(0T/(B")
("mblmo"	"$(1O'(B")
("mblmy"	"$(0Tz(B")
("mbmbl"	"$(0Mf(B")
("mbmdm"	"$(0^q(B")
("mbmgi"	"$(0ZM(B")
("mbmmi"	"$(0Dy(B")
("mbmms"	"$(0?}(B")
("mbmmv"	"$(0Qi(B")
("mbnl"	"$(1(u(B")
("mbnhs"	"$(0[G(B")
("mbnhu"	"$(1nB(B")
("mbnih"	"$(1H^(B")
("mbnkg"	"$(0Qh(B")
("mbnot"	"$(1jX(B")
("mbog"	"$(0Tx(B")
("mboah"	"$(1lu(B")
("mbogg"	"$(1p_(B")
("mboii"	"$(0I\(B")
("mbowy"	"$(0Qj(B")
("mbphe"	"$(0Nh(B")
("mbpru"	"$(0I[(B")
("mbrbc"	"$(1dE(B")
("mbrji"	"$(1l^(B")
("mbrmr"	"$(0]@(B")
("mbrrm"	"$(0^r(B")
("mbrrr"	"$(1`H(B")
("mbrye"	"$(0X%(B")
("mbsm"	"$(0?|(B")
("mbsfi"	"$(1gl(B")
("mbsma"	"$(1gj(B")
("mbsmm"	"$(0Sv(B")
("mbsrj"	"$(0]?(B")
("mbtm"	"$(1H`(B")
("mbtbk"	"$(0\Q(B")
("mbtjb"	"$(0]>(B")
("mbtlk"	"$(1`I(B")
("mbuc"	"$(05y:D(B")
("mbuce"	"$(1h5(B")
("mbwu"	"$(0IZ(B")
("mbwtc"	"$(1gk(B")
("mbyk"	"$(0Dx(B")
("mbyx"	"$(0^!(B")
("mbybp"	"$(1p`(B")
("mbydl"	"$(1gi(B")
("mbyhs"	"$(1AM(B")
("mbymr"	"$(1UW(B")
("mbyrv"	"$(0^s(B")
("mbytn"	"$(1`E(B")
("mbytv"	"$(0Tu(B")
("mcw"	"$(0*j(B")
("mche"	"$(1eH(B")
("mcwm"	"$(0-](B")
("mda"	"$(0Rn(B")
("mdm"	"$(0&m(B")
("mdbt"	"$(00}(B")
("mdhaf"	"$(1m*(B")
("mdmr"	"$(1bD(B")
("mdnl"	"$(1"s(B")
("mdylm"	"$(0S&(B")
("mem"	"$(01h(B")
("menl"	"$(1cz(B")
("mfj"	"$(0(N(B")
("mfk"	"$(1#Q(B")
("mfm"	"$(0'b(B")
("mfp"	"$(0Jh(B")
("mfr"	"$(0+B(B")
("mfbk"	"$(0K`(B")
("mfbq"	"$(04K(B")
("mfbt"	"$(04[(B")
("mfbuc"	"$(0]w(B")
("mfbuu"	"$(1N-(B")
("mfhaf"	"$(1V6(B")
("mfhhh"	"$(1J)(B")
("mfhni"	"$(0\R(B")
("mfhvo"	"$(0SH(B")
("mfln"	"$(0E9(B")
("mfmbc"	"$(1j]$(0[L(B")
("mfmym"	"$(03r(B")
("mfnl"	"$(1NU(B")
("mfsmm"	"$(1^S(B")
("mfvnd"	"$(1.h(B")
("mgb"	"$(00w)C(B")
("mgi"	"$(0(j$(1!f(B")
("mgm"	"$(1$m(B")
("mgt"	"$(0,.(B")
("mgaa"	"$(1>.(B")
("mgau"	"$(0Bd(B")
("mgabu"	"$(0G1(B")
("mgahm"	"$(1E$(B")
("mgahu"	"$(1E#(B")
("mgamh"	"$(1Dz(B")
("mgapp"	"$(0Bi(B")
("mgayf"	"$(0SF(B")
("mgayk"	"$(1>-(B")
("mgbm"	"$(1,4(B")
("mgbt"	"$(04D(B")
("mgby"	"$(1(/(B")
("mgbbe"	"$(0VA(B")
("mgbcd"	"$(0Bg(B")
("mgbcv"	"$(0\y(B")
("mgbgr"	"$(1>*(B")
("mgbjj"	"$(0G2(B")
("mgbme"	"$(1D|(B")
("mgbnd"	"$(17?(B")
("mgbou"	"$(0Ke(B")
("mgbsd"	"$(1>+(B")
("mgbuc"	"$(17:(B")
("mgbuu"	"$(0>#(B")
("mgcnh"	"$(171(B")
("mgcsh"	"$(1(-(B")
("mgcwa"	"$(1XQ(B")
("mgdd"	"$(0B`(B")
("mgdk"	"$(1(,(B")
("mgdhe"	"$(04E(B")
("mgdmq"	"$(1Dy(B")
("mgegi"	"$(0B^(B")
("mgeii"	"$(1Ky(B")
("mgff"	"$(1>$(B")
("mgfbc"	"$(0Kf(B")
("mgfbw"	"$(1]U(B")
("mgfdq"	"$(0SE(B")
("mgfmu"	"$(10p(B")
("mggb"	"$(1,6(B")
("mggg"	"$(08c(B")
("mggnf"	"$(1mb(B")
("mggsk"	"$(1R3(B")
("mgha"	"$(04H(B")
("mghi"	"$(0Kh(B")
("mghae"	"$(1E&(B")
("mghaf"	"$(1V3(B")
("mghby"	"$(10|(B")
("mghdn"	"$(0>$(B")
("mghds"	"$(177(B")
("mghdw"	"$(1XP(B")
("mgher"	"$(08d(B")
("mghgu"	"$(10{(B")
("mghhl"	"$(1,9(B")
("mghjd"	"$(08b(B")
("mghlb"	"$(1D}(B")
("mghnb"	"$(08a(B")
("mghon"	"$(10t(B")
("mghoo"	"$(1R1(B")
("mghqi"	"$(17>(B")
("mghuc"	"$(0^=(B")
("mghwp"	"$(1R0(B")
("mghxc"	"$(1b0(B")
("mgii"	"$(1>&(B")
("mgir"	"$(1,7(B")
("mgiav"	"$(0=}(B")
("mgihr"	"$(1Dx(B")
("mgihs"	"$(1?=(B")
("mgiil"	"$(0G,(B")
("mgije"	"$(0>!(B")
("mgilg"	"$(08_(B")
("mgilr"	"$(0Ki(B")
("mgisk"	"$(1f%(B")
("mgjbc"	"$(1Kx(B")
("mgjch"	"$(1D~(B")
("mgjcr"	"$(1Kv(B")
("mgjii"	"$(1R4(B")
("mgjmc"	"$(1b.(B")
("mgjmf"	"$(1>"(B")
("mgjmm"	"$(1Dw(B")
("mgjnu"	"$(1>#(B")
("mgjrb"	"$(0G-(B")
("mgjrr"	"$(0Bf(B")
("mgkb"	"$(10w(B")
("mgkkb"	"$(17=(B")
("mgkld"	"$(10x(B")
("mgkmr"	"$(0Bh(B")
("mgksr"	"$(1,,(B")
("mgln"	"$(0.0(B")
("mglq"	"$(10v(B")
("mglll"	"$(1$l(B")
("mglmo"	"$(10r(B")
("mglmt"	"$(1b3(B")
("mglmy"	"$(1>0(B")
("mglwl"	"$(1,-(B")
("mgmd"	"$(1$j(B")
("mgmg"	"$(00t(B")
("mgmj"	"$(1$i(B")
("mgmn"	"$(1"e(B")
("mgmbb"	"$(1b/(B")
("mgmbc"	"$(0Ic(B")
("mgmfj"	"$(1,/(B")
("mgmgh"	"$(1]Y(B")
("mgmhl"	"$(0=~(B")
("mgmig"	"$(1?<(B")
("mgmmr"	"$(172(B")
("mgmmu"	"$(00s(B")
("mgmnr"	"$(1,+(B")
("mgmso"	"$(0Ba(B")
("mgmvh"	"$(1(*(B")
("mgmvn"	"$(0Kj(B")
("mgmwd"	"$(1K|(B")
("mgnl"	"$(1-]@x(B")
("mgno"	"$(1C}$(0-,(B")
("mgnbe"	"$(0ZN(B")
("mgnbk"	"$(1E%(B")
("mgnhb"	"$(1XO(B")
("mgnkg"	"$(176(B")
("mgnot"	"$(1XR(B")
("mgoj"	"$(1(0(B")
("mgok"	"$(00v55(B")
("mgohh"	"$(04G(B")
("mgoii"	"$(04F(B")
("mgoin"	"$(0Be(B")
("mgoip"	"$(04I(B")
("mgoir"	"$(1Kz78(B")
("mgoll"	"$(1(.(B")
("mgoma"	"$(1][(B")
("mgomn"	"$(0G5(B")
("mgomr"	"$(10}(B")
("mgono"	"$(175(B")
("mgpa"	"$(10s(B")
("mgph"	"$(0G/$(1,*(B")
("mgpi"	"$(1$k(B")
("mgpp"	"$(0Bc$(1(+(B")
("mgpt"	"$(1,1(B")
("mgppa"	"$(1E"(B")
("mgpru"	"$(1,8(B")
("mgqj"	"$(1()(B")
("mgqkd"	"$(1K{$(0S{(B")
("mgqkq"	"$(1>%(B")
("mgrb"	"$(174(B")
("mgrr"	"$(0R?(B")
("mgrhg"	"$(173(B")
("mgrmr"	"$(1]V(B")
("mgrrd"	"$(1]W(B")
("mgrye"	"$(0G.(B")
("mgryo"	"$(17;(B")
("mgsj"	"$(10o(B")
("mgshr"	"$(1,3(B")
("mgsjr"	"$(1>'(B")
("mgskr"	"$(179(B")
("mgsmh"	"$(1R/(B")
("mgsmi"	"$(1XS(B")
("mgsmj"	"$(1b4(B")
("mgsmm"	"$(10y(B")
("mgsqf"	"$(0Kg(B")
("mgtc"	"$(10n(B")
("mgtm"	"$(1,0(B")
("mgtq"	"$(10u(B")
("mgtbc"	"$(1>/(B")
("mgtbn"	"$(1E!(B")
("mgtco"	"$(0SG(B")
("mgtgt"	"$(1b5(B")
("mgtlb"	"$(1R.(B")
("mgtlk"	"$(0G4(B")
("mgtlm"	"$(0Oi(B")
("mgtmc"	"$(0B_SC(B")
("mgtod"	"$(1R5(B")
("mgtoe"	"$(1b1(B")
("mgtqm"	"$(1Kw(B")
("mgtrg"	"$(1m`(B")
("mgtrk"	"$(1]Z(B")
("mgumb"	"$(0G0(B")
("mguob"	"$(1mc(B")
("mguog"	"$(0Oj(B")
("mguon"	"$(17<(B")
("mgvid"	"$(1f$(B")
("mgvii"	"$(0SD(B")
("mgvne"	"$(1>)(B")
("mgvno"	"$(1D{(B")
("mgvvd"	"$(1R2(B")
("mgvvw"	"$(0G3(B")
("mgwg"	"$(0>"(B")
("mgwk"	"$(10z(B")
("mgwl"	"$(1,5(B")
("mgwlv"	"$(0V@(B")
("mgwww"	"$(1f&(B")
("mgyk"	"$(00u(B")
("mgyr"	"$(04C(B")
("mgyx"	"$(1b2(B")
("mgybj"	"$(1]X(B")
("mgybk"	"$(1pB(B")
("mgybp"	"$(0[z(B")
("mgybu"	"$(0Xg(B")
("mgyck"	"$(10m(B")
("mgyed"	"$(0VB(B")
("mgyfe"	"$(1>((B")
("mgyiu"	"$(1,2$(08`(B")
("mgyjj"	"$(1R-(B")
("mgykg"	"$(0AY(B")
("mgymp"	"$(10q(B")
("mgyog"	"$(1XT(B")
("mgypo"	"$(0V?(B")
("mgypu"	"$(0Bb(B")
("mgyrv"	"$(0\x(B")
("mgyso"	"$(1R,(B")
("mgytj"	"$(0Og(B")
("mgyto"	"$(1]T(B")
("mgytr"	"$(1>,(B")
("mgyub"	"$(0Oh(B")
("mgyvi"	"$(1,.(B")
("mgyyb"	"$(1f#(B")
("mhs"	"$(1#7(B")
("mhaf"	"$(06Q(B")
("mhdd"	"$(1:J(B")
("mhhaf"	"$(0R*(B")
("mhjm"	"$(13t(B")
("mhnl"	"$(0-Z(B")
("mhog"	"$(0Dt(B")
("mhoiv"	"$(0Yv(B")
("mhpm"	"$(1#6(B")
("mig"	"$(0*^(B")
("mibbe"	"$(1qH(B")
("mihi"	"$(0Mw(B")
("miia"	"$(07n(B")
("minl"	"$(1H.(B")
("mioin"	"$(1[^(B")
("miuh"	"$(1):(B")
("miyle"	"$(1p^(B")
("mjf"	"$(10_(B")
("mjbc"	"$(1:K(B")
("mjhaf"	"$(1OLot(B")
("mjixp"	"$(1a8(B")
("mjln"	"$(0'{(B")
("mjmbc"	"$(1AR(B")
("mjnl"	"$(1"r(B")
("mjok"	"$(0AW(B")
("mjwj"	"$(1);(B")
("mkg"	"$(0UM(B")
("mkp"	"$(1W$(B")
("mks"	"$(0'}(B")
("mkv"	"$(1\b(B")
("mkhi"	"$(0^x(B")
("mkhqm"	"$(0Bk(B")
("mkmwl"	"$(0^O(B")
("mknl"	"$(138(B")
("mkoiv"	"$(0^Q(B")
("mkwl"	"$(1e>(B")
("mkwgf"	"$(1qn(B")
("mlm"	"$(0&W(B")
("mlbo"	"$(0.&(B")
("mlby"	"$(01e(B")
("mllm"	"$(0-j(B")
("mlmy"	"$(1.3(B")
("mlvs"	"$(1!.(B")
("mlwk"	"$(0,V(B")
("mmf"	"$(0(}(B")
("mmg"	"$(0;T(B")
("mmi"	"$(0&j(B")
("mml"	"$(1!2(B")
("mmm"	"$(0&6(B")
("mmn"	"$(1!)(B")
("mmp"	"$(0A+(B")
("mmr"	"$(0+A(B")
("mmu"	"$(0&x(B")
("mmbc"	"$(0D{(B")
("mmbbp"	"$(0[^(B")
("mmhaf"	"$(1e"$(0[Y(B")
("mmig"	"$(1%[(B")
("mmks"	"$(021(B")
("mmln"	"$(1)3(B")
("mmlmi"	"$(1Mj(B")
("mmmv"	"$(0-R(B")
("mmmbc"	"$(0U"(B")
("mmnl"	"$(1(w(B")
("mmok"	"$(03J(B")
("mmuu"	"$(1a>(B")
("mmvh"	"$(1"%(B")
("mmvn"	"$(1(2(B")
("mmvs"	"$(0(J(B")
("mmyiu"	"$(1B^(B")
("mmypu"	"$(1Z%(B")
("mnc"	"$(1Nq(B")
("mnf"	"$(08U(B")
("mng"	"$(02O(B")
("mni"	"$(0'Q(B")
("mnl"	"$(1"t(B")
("mnp"	"$(0*<7G(B")
("mnr"	"$(0(,(B")
("mnv"	"$(1)w(B")
("mnbm"	"$(1+H(B")
("mnbnd"	"$(16A(B")
("mngbt"	"$(1Wm(B")
("mngwc"	"$(1eh(B")
("mnhk"	"$(1'L(B")
("mnhaf"	"$(1a2Q?(B")
("mnhbt"	"$(10!(B")
("mnhjd"	"$(083(B")
("mnhpa"	"$(1='(B")
("mnhuk"	"$(1K2(B")
("mnii"	"$(0B%(B")
("mnir"	"$(03t(B")
("mnije"	"$(16@(B")
("mnjbm"	"$(0B&(B")
("mnjmc"	"$(0XX$(1Q<(B")
("mnjru"	"$(16?(B")
("mnklu"	"$(1=&(B")
("mnkoo"	"$(16B(B")
("mnkpb"	"$(1Q>(B")
("mnle"	"$(1=%(B")
("mnln"	"$(0)E(B")
("mnlq"	"$(1/~(B")
("mnlbk"	"$(03s(B")
("mnlmi"	"$(1@#(B")
("mnmbc"	"$(0@"(B")
("mnmem"	"$(1D$(B")
("mnmvm"	"$(16C(B")
("mnmwm"	"$(1]9(B")
("mnne"	"$(00@(B")
("mnnwf"	"$(1`~(B")
("mnoah"	"$(0OF(B")
("mnohh"	"$(1+I(B")
("mnoim"	"$(0\t(B")
("mnomo"	"$(0U~(B")
("mnpa"	"$(084(B")
("mnphh"	"$(1'M(B")
("mnrbc"	"$(1K0(B")
("mnrrj"	"$(1Wn(B")
("mnryo"	"$(1Gz(B")
("mntlj"	"$(0Qn(B")
("mntlm"	"$(1Q=(B")
("mnwot"	"$(1K1(B")
("mnyfu"	"$(1Wl(B")
("mnyhv"	"$(0C|(B")
("mnytr"	"$(1=((B")
("mob"	"$(0'`(B")
("mof"	"$(1b*(B")
("mok"	"$(0,S(B")
("moo"	"$(0,((B")
("moau"	"$(19U(B")
("moav"	"$(1G^(B")
("mobuu"	"$(1N.(B")
("mobvk"	"$(1_a(B")
("mogbt"	"$(1g4(B")
("mohf"	"$(1V9(B")
("mohaf"	"$(1o~(B")
("mohoo"	"$(1c](B")
("mohsn"	"$(1@L(B")
("moju"	"$(1%Z(B")
("mojka"	"$(0Q)(B")
("mojtc"	"$(1g5(B")
("mokkb"	"$(1N;(B")
("moln"	"$(1.0$(0J$(B")
("molmi"	"$(1c>(B")
("momt"	"$(19T(B")
("momhf"	"$(1__(B")
("momso"	"$(1N<(B")
("moog"	"$(0Ds(B")
("morye"	"$(0TI(B")
("mowot"	"$(1_`(B")
("moyvo"	"$(1G](B")
("mphaf"	"$(1r@(B")
("mpnl"	"$(0]{(B")
("mpylm"	"$(00>(B")
("mre"	"$(04*$(1,P(B")
("mrm"	"$(1(>(B")
("mrt"	"$(0-I(B")
("mrav"	"$(17Z(B")
("mramh"	"$(1L8(B")
("mrapv"	"$(0K|(B")
("mrbb"	"$(0GV(B")
("mrbj"	"$(1go(B")
("mrbl"	"$(0:p(B")
("mrbm"	"$(09((B")
("mrby"	"$(1,U(B")
("mrbbr"	"$(1L@(B")
("mrbgr"	"$(0GU(B")
("mrbmr"	"$(17_(B")
("mrbsd"	"$(1EX(B")
("mrbtu"	"$(1EW(B")
("mrbuu"	"$(0C!(B")
("mrbvk"	"$(1RO(B")
("mrcsh"	"$(1,R(B")
("mrcwa"	"$(1]p(B")
("mrdd"	"$(1EP(B")
("mrdm"	"$(11@(B")
("mrdam"	"$(1L7(B")
("mrdci"	"$(1EV(B")
("mrddo"	"$(0Xp(B")
("mrdhe"	"$(09$(B")
("mreed"	"$(1RT(B")
("mresd"	"$(1]u(B")
("mrfb"	"$(0B}(B")
("mrfh"	"$(04f(B")
("mrfbw"	"$(1bK(B")
("mrfdq"	"$(0VN(B")
("mrfff"	"$(1kr(B")
("mrgg"	"$(17^(B")
("mrgi"	"$(09#(B")
("mrgr"	"$(17W(B")
("mrggu"	"$(1]q(B")
("mrgit"	"$(0P"(B")
("mrgrr"	"$(1]r(B")
("mrgsk"	"$(1Xl(B")
("mrhi"	"$(1RQ(B")
("mrhp"	"$(1(A(B")
("mrhs"	"$(09)(B")
("mrhdw"	"$(1]s(B")
("mrher"	"$(17\(B")
("mrhgr"	"$(1>V(B")
("mrhhj"	"$(0GW(B")
("mrhio"	"$(09'(B")
("mrhjd"	"$(0>?(B")
("mrhje"	"$(1L;(B")
("mrhjm"	"$(1L:(B")
("mrhkb"	"$(1]y(B")
("mrhlc"	"$(1iN(B")
("mrhml"	"$(03L(B")
("mrhne"	"$(1,V(B")
("mrhpm"	"$(09&(B")
("mrhqi"	"$(1>Q(B")
("mrhsb"	"$(1L=(B")
("mrhsk"	"$(1bH(B")
("mrhsn"	"$(11B(B")
("mrhuc"	"$(1pE(B")
("mrhyu"	"$(1RR(B")
("mrie"	"$(11A(B")
("mriav"	"$(1>K(B")
("mrihf"	"$(1Xm(B")
("mriih"	"$(1Xq(B")
("mrilr"	"$(1RS(B")
("mritc"	"$(0[}(B")
("mriuh"	"$(1>M(B")
("mrjp"	"$(11=(B")
("mrjbc"	"$(1RM(B")
("mrjcm"	"$(0GY(B")
("mrjii"	"$(0SU(B")
("mrjmc"	"$(1f1(B")
("mrjmo"	"$(1EL(B")
("mrjnu"	"$(0GR(B")
("mrjqr"	"$(1RJ(B")
("mrjwj"	"$(1>U(B")
("mrkkk"	"$(1Xt(B")
("mrkmr"	"$(1EQ(B")
("mrkoo"	"$(1>L(B")
("mrlq"	"$(17Y(B")
("mrlln"	"$(11F(B")
("mrlwl"	"$(09%(B")
("mrmj"	"$(1(=(B")
("mrmr"	"$(11G(B")
("mrmt"	"$(04g(B")
("mrmu"	"$(1(?(B")
("mrmbb"	"$(1f-(B")
("mrmbc"	"$(0K{(B")
("mrmbg"	"$(1kp(B")
("mrmbu"	"$(1mf(B")
("mrmbw"	"$(1bE(B")
("mrmcw"	"$(17X(B")
("mrmfj"	"$(08~(B")
("mrmgi"	"$(11E(B")
("mrmlk"	"$(0B~(B")
("mrmnr"	"$(11?(B")
("mrmpm"	"$(1EN(B")
("mrmrr"	"$(0O~(B")
("mrmtb"	"$(0[~(B")
("mrmtn"	"$(0>@(B")
("mrmvb"	"$(1Xu(B")
("mrmvh"	"$(1,N(B")
("mrmvm"	"$(1>N(B")
("mrmwj"	"$(1]w(B")
("mrmwm"	"$(1bF(B")
("mrnd"	"$(1(B(B")
("mrni"	"$(01#(B")
("mrnl"	"$(1j13:(B")
("mrno"	"$(0K;4i(B")
("mrnr"	"$(06Y(B")
("mrnbg"	"$(1>R(B")
("mrnhe"	"$(1,Q(B")
("mrnmu"	"$(17[(B")
("mrnot"	"$(0VP(B")
("mrnqd"	"$(1RP(B")
("mrog"	"$(0GX(B")
("mrok"	"$(0<{(B")
("mron"	"$(1(@(B")
("mrobg"	"$(0O}(B")
("mrogd"	"$(1]t(B")
("mrogf"	"$(0VR(B")
("mroii"	"$(11I(B")
("mroll"	"$(1,S(B")
("mromb"	"$(1EY(B")
("mromd"	"$(1>W(B")
("mrpp"	"$(1,O(B")
("mrpko"	"$(0ZU(B")
("mrpru"	"$(09*(B")
("mrpsh"	"$(04h(B")
("mrptd"	"$(0Kx(B")
("mrqo"	"$(1,M(B")
("mrqmb"	"$(1EU(B")
("mrqmc"	"$(0SW(B")
("mrqmy"	"$(1ET(B")
("mrrrj"	"$(1]x(B")
("mrrrk"	"$(1q,(B")
("mrrye"	"$(1L?(B")
("mrsec"	"$(1iI(B")
("mrsit"	"$(1f.(B")
("mrslb"	"$(09"(B")
("mrsmh"	"$(1Xv(B")
("mrsqf"	"$(0P#(B")
("mrsrj"	"$(1bG(B")
("mrstv"	"$(0P!(B")
("mrta"	"$(1EO(B")
("mrtbc"	"$(0GS(B")
("mrtbf"	"$(1iM(B")
("mrtbo"	"$(1f2(B")
("mrtgi"	"$(1bJ(B")
("mrtii"	"$(1f/(B")
("mrtlk"	"$(1LA(B")
("mrtmc"	"$(0VO(B")
("mrtmv"	"$(1L6(B")
("mrtqm"	"$(0O{(B")
("mrttc"	"$(0GQ(B")
("mrtvi"	"$(0Kw(B")
("mrtvs"	"$(1Xs(B")
("mrtwi"	"$(1iJ(B")
("mrtxc"	"$(1RL(B")
("mrtyv"	"$(1>O(B")
("mrubb"	"$(1Xp(B")
("mrumf"	"$(0Kz(B")
("mrumt"	"$(1RN(B")
("mruog"	"$(1Xo(B")
("mrvid"	"$(0\"(B")
("mrvii"	"$(0VQ(B")
("mrvne"	"$(0GT(B")
("mrwd"	"$(1>P(B")
("mrwhd"	"$(1ER(B")
("mrwmv"	"$(1L9(B")
("mrwvf"	"$(1Xn(B")
("mrwww"	"$(1iK(B")
("mrwyi"	"$(11H(B")
("mryg"	"$(11D(B")
("mryr"	"$(09!(B")
("mryt"	"$(11>(B")
("mrybb"	"$(1L5(B")
("mrybs"	"$(0O|(B")
("mrydk"	"$(1]v(B")
("mryiu"	"$(0>>(B")
("mryoj"	"$(0GP(B")
("mryrb"	"$(1RK(B")
("mryrn"	"$(1L>(B")
("mrytr"	"$(1EM(B")
("mrywi"	"$(1Xw(B")
("msu"	"$(0'.(B")
("msho"	"$(0-J(B")
("msko"	"$(1(l(B")
("msnl"	"$(1NT(B")
("msok"	"$(1$9(B")
("mta"	"$(06R(B")
("mtm"	"$(13#(B")
("mtq"	"$(1B~(B")
("mthaf"	"$(1V2(B")
("mthhh"	"$(0,1(B")
("mthhj"	"$(1TQ(B")
("mtje"	"$(0?H(B")
("mtjnu"	"$(0Q'(B")
("mtln"	"$(0)F(B")
("mtmbc"	"$(0U%(B")
("mtnl"	"$(0-Y$(137(B")
("mtog"	"$(1AL(B")
("mttxc"	"$(1_](B")
("mtuo"	"$(0@=(B")
("mtwb"	"$(0N0(B")
("mua"	"$(1<N(B")
("mub"	"$(1"p(B")
("mui"	"$(0<S(B")
("muali"	"$(0^g(B")
("muhe"	"$(06p(B")
("mukll"	"$(1:x(B")
("muln"	"$(1!|(B")
("mulmi"	"$(05P(B")
("mumbc"	"$(0Ia(B")
("mumrb"	"$(1dl(B")
("mumso"	"$(13$(B")
("munl"	"$(1%,(B")
("munmu"	"$(1)8(B")
("mvb"	"$(0>k(B")
("mvr"	"$(06f(B")
("mvdh"	"$(0'\(B")
("mvdi"	"$(0:J(B")
("mvku"	"$(1!?(B")
("mvlmi"	"$(0HJ(B")
("mvni"	"$(0(l(B")
("mvnm"	"$(0&l(B")
("mvphh"	"$(1GC(B")
("mvvm"	"$(1#j(B")
("mwd"	"$(08%(B")
("mwg"	"$(1)Z)<(B")
("mwv"	"$(05S(B")
("mwaj"	"$(0C~(B")
("mwahm"	"$(0T_(B")
("mwamo"	"$(1[((B")
("mwbdi"	"$(1N^(B")
("mwbmr"	"$(1H4(B")
("mwbuc"	"$(0Hs(B")
("mwbuu"	"$(0T}(B")
("mwbwi"	"$(1pY(B")
("mwcsh"	"$(19y(B")
("mwdd"	"$(1U+(B")
("mwdi"	"$(13D(B")
("mweee"	"$(1U)(B")
("mwfd"	"$(0C6(B")
("mwhd"	"$(0DX(B")
("mwhi"	"$(0Wk(B")
("mwhs"	"$(1A((B")
("mwhaf"	"$(1k+(B")
("mwher"	"$(0I=(B")
("mwhgf"	"$(0]5(B")
("mwhgr"	"$(0MN(B")
("mwhio"	"$(19J(B")
("mwhne"	"$(19x(B")
("mwhoe"	"$(0Y<(B")
("mwhqu"	"$(19{(B")
("mwhsk"	"$(1g"(B")
("mwhxe"	"$(1_t(B")
("mwii"	"$(1U((B")
("mwice"	"$(0MM(B")
("mwidd"	"$(1pW(B")
("mwijb"	"$(1N\(B")
("mwill"	"$(0I<(B")
("mwilr"	"$(0Wi(B")
("mwjp"	"$(1A%(B")
("mwjr"	"$(1A&(B")
("mwjcs"	"$(1_v(B")
("mwjka"	"$(1[)(B")
("mwjkd"	"$(0ML(B")
("mwjrb"	"$(1[&(B")
("mwklu"	"$(0QW(B")
("mwkrt"	"$(1_r(B")
("mwln"	"$(0;,(B")
("mwlbu"	"$(19w(B")
("mwlii"	"$(1l3(B")
("mwlkt"	"$(1_x(B")
("mwlut"	"$(1[%(B")
("mwmj"	"$(13C(B")
("mwmn"	"$(05m(B")
("mwmbb"	"$(1lM(B")
("mwmbr"	"$(1pX(B")
("mwmmf"	"$(0>B(B")
("mwmmp"	"$(1qb(B")
("mwmnr"	"$(1A)(B")
("mwmwf"	"$(1c|(B")
("mwmwj"	"$(1gM(B")
("mwnir"	"$(0I>(B")
("mwnob"	"$(1['(B")
("mwnoe"	"$(0[3(B")
("mwog"	"$(1U-(B")
("mwogf"	"$(0[4(B")
("mwomd"	"$(0MO(B")
("mwpa"	"$(1H5(B")
("mwpd"	"$(13E(B")
("mwpi"	"$(0:[(B")
("mwpou"	"$(1U,(B")
("mwrhg"	"$(1N](B")
("mwrrk"	"$(0_=(B")
("mwsu"	"$(0:Z(B")
("mwsmh"	"$(1d!(B")
("mwsrr"	"$(1c}(B")
("mwta"	"$(0QV(B")
("mwtm"	"$(0DW(B")
("mwtco"	"$(1gN(B")
("mwtlf"	"$(1oY(B")
("mwtog"	"$(1_s(B")
("mwtqm"	"$(1_w(B")
("mwtwt"	"$(0\K(B")
("mwtwv"	"$(1j5(B")
("mwuk"	"$(0?i(B")
("mwvib"	"$(1N_(B")
("mwvne"	"$(1U*(B")
("mwwlj"	"$(1j6(B")
("mwwot"	"$(0Wj(B")
("mwyl"	"$(05t(B")
("mwyr"	"$(1A'(B")
("mwyfd"	"$(1_q(B")
("mwyoj"	"$(0QU(B")
("mwypo"	"$(1j4(B")
("mwyrd"	"$(0QT(B")
("mwyrv"	"$(0^o(B")
("mwytp"	"$(1j3(B")
("mwytr"	"$(1U'(B")
("mwyub"	"$(1c{(B")
("mwyut"	"$(1c~(B")
("myp"	"$(1#w(B")
("mylf"	"$(0=p(B")
("mylm"	"$(0(`(B")
("mytj"	"$(1)9(B")
("myvs"	"$(0&b(B")
("n"	"$(0&_(B")
("nc"	"$(0&R(B")
("nd"	"$(0&N(B")
("ne"	"$(1!`(B")
("ng"	"$(0&a(B")
("ni"	"$(0&K(Q(B")
("nk"	"$(0&5(B")
("nl"	"$(0'@'?(B")
("nn"	"$(0&((B")
("no"	"$(0&='O(B")
("nq"	"$(1!1(B")
("nu"	"$(0&#(B")
("nx"	"$(1"$(B")
("nau"	"$(1#s$(0*d(B")
("nahu"	"$(0+.(B")
("napo"	"$(0D0(B")
("nbb"	"$(152(B")
("nbg"	"$(0ND-F(B")
("nbk"	"$(02Z(B")
("nbp"	"$(0<=(B")
("nbu"	"$(1P8(B")
("nbam"	"$(1@<(B")
("nbbue"	"$(1Pi(B")
("nbdk"	"$(19K(B")
("nbdl"	"$(1N2(B")
("nbfmu"	"$(1GF(B")
("nbgg"	"$(1GE(B")
("nbhaf"	"$(1ov(B")
("nbher"	"$(1GH(B")
("nbhpm"	"$(1@:(B")
("nbhqu"	"$(1Wq(B")
("nbhvo"	"$(1@;(B")
("nbhxu"	"$(1T>(B")
("nbije"	"$(1N1(B")
("nbjka"	"$(1T=(B")
("nbks"	"$(05T2.(B")
("nbkmr"	"$(1T<(B")
("nbln"	"$(1I*(B")
("nblmi"	"$(1GL(B")
("nbme"	"$(1N3(B")
("nbmgi"	"$(1ma(B")
("nbnbe"	"$(0]t(B")
("nbnhe"	"$(19L(B")
("nbnmu"	"$(1GG(B")
("nbop"	"$(1d>(B")
("nboah"	"$(0Y>(B")
("nbrrj"	"$(1g%(B")
("nbshq"	"$(0HY(B")
("nbtgq"	"$(1_J(B")
("nbtlf"	"$(1oO(B")
("nbuc"	"$(05Y(B")
("nbue"	"$(1o)(B")
("nbuob"	"$(1q=(B")
("nbvl"	"$(1-Q(B")
("nbvid"	"$(1n&(B")
("nbwli"	"$(0\>(B")
("nbyj"	"$(0<}(B")
("ncymr"	"$(0Hj(B")
("ndu"	"$(0'7(B")
("ndbt"	"$(0.v(B")
("ndhaf"	"$(1k1(B")
("ndhvf"	"$(07#(B")
("ndhvo"	"$(0.w(B")
("ndjmf"	"$(14t(B")
("ndlmt"	"$(1\c(B")
("ndmbb"	"$(0US(B")
("ndmlm"	"$(14s(B")
("ndnd"	"$(1"4(B")
("ndok"	"$(0+w(B")
("ndpru"	"$(1&7(B")
("ndyvo"	"$(02g(B")
("nem"	"$(0)#(B")
("nemb"	"$(124(B")
("nemf"	"$(10Q(B")
("nemsu"	"$(1*1(B")
("nfb"	"$(1.}(B")
("nfm"	"$(1OK(B")
("nfp"	"$(1J;(B")
("nfaa"	"$(0[U(B")
("nfagi"	"$(1l{(B")
("nfail"	"$(0Z#(B")
("nfamo"	"$(1j{(B")
("nfapp"	"$(1h:(B")
("nfasm"	"$(1l|(B")
("nfawe"	"$(0^.(B")
("nfbgr"	"$(0[W(B")
("nfbmr"	"$(1`{(B")
("nfbof"	"$(1ne(B")
("nfbou"	"$(1l}(B")
("nfcru"	"$(1du(B")
("nfcsh"	"$(1V+(B")
("nfdn"	"$(0C7(B")
("nfdoo"	"$(1h8(B")
("nffb"	"$(1dz(B")
("nffh"	"$(1V)(B")
("nffba"	"$(1qK(B")
("nffdq"	"$(0^Y(B")
("nfgg"	"$(0X0(B")
("nfgi"	"$(1\$(B")
("nfgr"	"$(1`w(B")
("nfgce"	"$(1h6(B")
("nfgcg"	"$(1hC(B")
("nfggu"	"$(1on(B")
("nfhd"	"$(0S\(B")
("nfhe"	"$(1V/(B")
("nfhp"	"$(1OI(B")
("nfhs"	"$(1\((B")
("nfhag"	"$(1k'(B")
("nfhdd"	"$(1hF(B")
("nfhdf"	"$(0\[(B")
("nfhdw"	"$(1om(B")
("nfher"	"$(1`}(B")
("nfhhw"	"$(1m!(B")
("nfhir"	"$(1qk(B")
("nfhjd"	"$(1a"(B")
("nfhkb"	"$(1op(B")
("nfhor"	"$(1h;(B")
("nfhrb"	"$(1l~(B")
("nfhvf"	"$(0Z%(B")
("nfhxc"	"$(1qL(B")
("nfhxh"	"$(1dw(B")
("nfhxu"	"$(1h<(B")
("nfir"	"$(1\*(B")
("nfihr"	"$(1k&(B")
("nfijb"	"$(1dq(B")
("nfije"	"$(1dy(B")
("nfiku"	"$(0R'(B")
("nfjd"	"$(1\#(B")
("nfjp"	"$(1\!(B")
("nfjr"	"$(1\,(B")
("nfjcr"	"$(1lw(B")
("nfjii"	"$(1n\(B")
("nfjmu"	"$(1dp(B")
("nfjpa"	"$(0]L(B")
("nfjrb"	"$(1k%(B")
("nfkb"	"$(0X/(B")
("nflx"	"$(1oi(B")
("nflmo"	"$(1`|(B")
("nflmy"	"$(1hE(B")
("nfmbl"	"$(1`y(B")
("nfmbm"	"$(1nZ(B")
("nfmfm"	"$(1\%(B")
("nfmgr"	"$(0_A(B")
("nfmlk"	"$(1dt(B")
("nfmmp"	"$(1r?(B")
("nfmmr"	"$(1dr(B")
("nfmnr"	"$(1\+(B")
("nfmtb"	"$(1qj(B")
("nfmto"	"$(0^Z(B")
("nfmvm"	"$(1V((B")
("nfmwf"	"$(0^-(B")
("nfnao"	"$(1oo(B")
("nfnau"	"$(1dv(B")
("nfnhb"	"$(1oj(B")
("nfnhd"	"$(1k"(B")
("nfnkq"	"$(1k#(B")
("nfnmu"	"$(1a#(B")
("nfnoe"	"$(1ok(B")
("nfob"	"$(1V*(B")
("nfop"	"$(1V.(B")
("nfoae"	"$(1j}(B")
("nfodi"	"$(1\)(B")
("nfoip"	"$(1h=(B")
("nfold"	"$(1na(B")
("nfoma"	"$(1pk(B")
("nfomd"	"$(1d{(B")
("nfomr"	"$(1a$(B")
("nfonk"	"$(1j~(B")
("nfpa"	"$(1`x(B")
("nfph"	"$(1\"(B")
("nfpi"	"$(1OJ(B")
("nfpr"	"$(1\.(B")
("nfpu"	"$(1V-(B")
("nfpru"	"$(0U6(B")
("nfptd"	"$(1jz(B")
("nfqka"	"$(1k$(B")
("nfqmb"	"$(0[V(B")
("nfqmc"	"$(1n[(B")
("nfrrd"	"$(1pi(B")
("nfrxu"	"$(1ph(B")
("nfsh"	"$(1Hr(B")
("nfsav"	"$(1jy(B")
("nfseg"	"$(1n](B")
("nfsje"	"$(1h7(B")
("nfsju"	"$(1ds(B")
("nfskr"	"$(1dx(B")
("nfsma"	"$(1n`(B")
("nfsmb"	"$(1h9(B")
("nfsmi"	"$(1oh(B")
("nftm"	"$(1\-(B")
("nftq"	"$(0X-(B")
("nftgr"	"$(0^X(B")
("nftjs"	"$(1n^(B")
("nftmc"	"$(1hD(B")
("nftrg"	"$(1r;(B")
("nftwa"	"$(1nd(B")
("nftwi"	"$(1ogqh(B")
("nftwt"	"$(1pg(B")
("nftxc"	"$(1ly(B")
("nfvid"	"$(1qi(B")
("nfvvw"	"$(1h>(B")
("nfwg"	"$(0Z"(B")
("nfwl"	"$(1\&(B")
("nfwo"	"$(1\'(B")
("nfwp"	"$(0\Z(B")
("nfwlb"	"$(1j|(B")
("nfwle"	"$(0]M(B")
("nfwlv"	"$(1pj(B")
("nfyk"	"$(1V,(B")
("nfyx"	"$(1qM(B")
("nfyck"	"$(0X.(B")
("nfyhn"	"$(1V&(B")
("nfyhs"	"$(1V'(B")
("nfyjj"	"$(0^,(B")
("nfymf"	"$(1`z(B")
("nfymo"	"$(1n_(B")
("nfypk"	"$(1lz(B")
("nfypm"	"$(1ol(B")
("nfypt"	"$(0_B(B")
("nfyrb"	"$(1lx(B")
("nfyrd"	"$(1hB(B")
("nfyrf"	"$(0[T(B")
("nfytj"	"$(1nY(B")
("nfytv"	"$(1hA(B")
("nfywm"	"$(1pf(B")
("ngmbc"	"$(1[g(B")
("ngmwm"	"$(0ZQ(B")
("nhd"	"$(03\(B")
("nhe"	"$(0'0(B")
("nhs"	"$(0&&(B")
("nhbcr"	"$(1>I(B")
("nhli"	"$(01O(B")
("nhlii"	"$(1_7(B")
("nhoin"	"$(04e(B")
("nhoks"	"$(0;.(B")
("nhpm"	"$(1&U(B")
("nhsqf"	"$(1jr(B")
("nhta"	"$(1EK(B")
("nhvo"	"$(0/:(B")
("niq"	"$(0*a(B")
("nir"	"$(0)Y(B")
("niy"	"$(0(A(B")
("nibq"	"$(0--(B")
("nihaf"	"$(1hU(B")
("nijmc"	"$(0JD(B")
("nili"	"$(0<1(B")
("niln"	"$(1e<(B")
("ninh"	"$(0(z(B")
("nini"	"$(0)j(B")
("ninl"	"$(1j2(B")
("ninn"	"$(0&i(B")
("nioiv"	"$(0D~(B")
("nisu"	"$(1!Q(B")
("niymr"	"$(1cZ(B")
("njhaf"	"$(1ON(B")
("njlii"	"$(0Pg(B")
("nkc"	"$(1`,(B")
("nkd"	"$(1Cm(B")
("nkf"	"$(0G"(B")
("nkg"	"$(1:l(B")
("nki"	"$(1B{(B")
("nkv"	"$(1:|(B")
("nkbu"	"$(1L1(B")
("nkhg"	"$(0,-(B")
("nkhaf"	"$(1k<(B")
("nkhml"	"$(19s(B")
("nkhym"	"$(0/8(B")
("nklq"	"$(02{(B")
("nklmi"	"$(1T%(B")
("nknl"	"$(1@{(B")
("nksqf"	"$(0[Q(B")
("nktlj"	"$(1dM(B")
("nlav"	"$(05p(B")
("nlamh"	"$(0Dm(B")
("nlamo"	"$(0Dr(B")
("nlavf"	"$(1`C(B")
("nlbm"	"$(01a(B")
("nlbt"	"$(1,B(B")
("nlbmp"	"$(0X!(B")
("nlbof"	"$(0Mc(B")
("nldw"	"$(0?t(B")
("nldhe"	"$(01c(B")
("nldwk"	"$(1Pf(B")
("nlfhf"	"$(0Ma(B")
("nlgi"	"$(1(y(B")
("nlgce"	"$(0?s(B")
("nlgcg"	"$(0?u(B")
("nlggu"	"$(1UU(B")
("nlgsk"	"$(1O%(B")
("nlgyo"	"$(0:d(B")
("nlhe"	"$(0-c(B")
("nlhi"	"$(1H\(B")
("nlhj"	"$(0*k(B")
("nlhs"	"$(1({(B")
("nlhag"	"$(0Dp(B")
("nlhbk"	"$(1[[(B")
("nlhem"	"$(0Do(B")
("nlheq"	"$(05s(B")
("nlhhj"	"$(0?w(B")
("nlhjd"	"$(1-i(B")
("nlhjg"	"$(1AI(B")
("nlhjm"	"$(0Dq(B")
("nlhpm"	"$(1(|(B")
("nlhtg"	"$(0:i(B")
("nlhxg"	"$(1AG(B")
("nlihu"	"$(1%1(B")
("nlihv"	"$(1AD(B")
("nljp"	"$(01_(B")
("nljka"	"$(1:-(B")
("nljmu"	"$(0:b(B")
("nljwj"	"$(0:c(B")
("nlkb"	"$(1-e(B")
("nlks"	"$(1!i(B")
("nlkmb"	"$(0Dl(B")
("nlkmm"	"$(1HZ(B")
("nlkmr"	"$(1:.(B")
("nlkms"	"$(1-g(B")
("nlkoo"	"$(0:f$(13I(B")
("nllmc"	"$(1UT(B")
("nllmy"	"$(1:/(B")
("nlma"	"$(05r(B")
("nlmu"	"$(1"v(B")
("nlmbk"	"$(1AE(B")
("nlmbl"	"$(1-f(B")
("nlmbv"	"$(05q(B")
("nlmfb"	"$(1`D(B")
("nlmmu"	"$(0-a(B")
("nlmnr"	"$(01`(B")
("nlmob"	"$(1(}(B")
("nlmrb"	"$(0IS(B")
("nlmsu"	"$(1%/(B")
("nlmvm"	"$(0:h(B")
("nlnj"	"$(1"x(B")
("nlnhx"	"$(0?y(B")
("nlnin"	"$(1-h(B")
("nlon"	"$(1"y(B")
("nlodi"	"$(01b(B")
("nloii"	"$(0?v(B")
("nlomb"	"$(1:1(B")
("nlomd"	"$(0:g(B")
("nlomn"	"$(1AH(B")
("nlomo"	"$(0Ts(B")
("nlpd"	"$(1"w(B")
("nlpp"	"$(1%.(B")
("nlpfd"	"$(1:0(B")
("nlpou"	"$(0?x(B")
("nlppa"	"$(0Dk(B")
("nlppg"	"$(0:e(B")
("nlrbc"	"$(0IT(B")
("nlsje"	"$(0?z(B")
("nltt"	"$(0-b(B")
("nltct"	"$(0IR(B")
("nltpo"	"$(0Dj(B")
("nltxc"	"$(1HY(B")
("nlumt"	"$(1H[(B")
("nlwlb"	"$(0Dn(B")
("nlwmv"	"$(1AF(B")
("nlyr"	"$(1(z(B")
("nlyx"	"$(1`B(B")
("nlybp"	"$(0[D(B")
("nlyhm"	"$(1O&(B")
("nlyhn"	"$(0-d(B")
("nlyhs"	"$(0-`(B")
("nlykb"	"$(0Tr(B")
("nlylh"	"$(13J(B")
("nlylm"	"$(1%0(B")
("nlytj"	"$(0Mb(B")
("nlyto"	"$(0Tq(B")
("nlytr"	"$(0?r(B")
("nlyvo"	"$(1-d(B")
("nman"	"$(0A%(B")
("nmfb"	"$(0U[(B")
("nmlmi"	"$(1M}(B")
("nmnim"	"$(07@(B")
("nmnmf"	"$(0]Q(B")
("nmsu"	"$(0)O(B")
("nmvm"	"$(1.|(B")
("nmwm"	"$(0RT(B")
("nmyiu"	"$(0>.(B")
("nnm"	"$(0&O(B")
("nno"	"$(0&P(B")
("nnmbc"	"$(0I`(B")
("nnmrb"	"$(1nV(B")
("nnnao"	"$(0TH(B")
("nnpr"	"$(0;](B")
("nnqo"	"$(0/V(B")
("nnsmm"	"$(1?+(B")
("nnvvu"	"$(1[!(B")
("nob"	"$(05*(B")
("noc"	"$(1jS(B")
("nof"	"$(0-&(B")
("nog"	"$(1Oy$(0NC(B")
("nodi"	"$(1&T(B")
("nohne"	"$(1,A(B")
("nohto"	"$(05{(B")
("nolmi"	"$(0?1(B")
("nomk"	"$(04U(B")
("nomrn"	"$(0J"(B")
("nomrt"	"$(0Bu(B")
("nonhe"	"$(0Bv(B")
("npd"	"$(0*$(B")
("nqd"	"$(08+(B")
("nqlmi"	"$(0Zt(B")
("nrmvn"	"$(1b6(B")
("nrppi"	"$(0V!(B")
("nrrj"	"$(0N_(B")
("nsd"	"$(1].(B")
("nse"	"$(1!;(B")
("nsf"	"$(1"5(B")
("nsj"	"$(02}(B")
("nsp"	"$(03+(B")
("nsbt"	"$(04Y(B")
("nsbul"	"$(1V?(B")
("nshr"	"$(1&R(B")
("nsmv"	"$(0<0(B")
("nsnd"	"$(0(F(B")
("nsrr"	"$(1J'(B")
("nti"	"$(1B}(B")
("ntmc"	"$(1PA(B")
("ntnl"	"$(0QR(B")
("nue"	"$(0.+$(1&S(B")
("nui"	"$(0.#(B")
("nup"	"$(03-(B")
("nuv"	"$(1&5(B")
("nubu"	"$(11;(B")
("nuhaf"	"$(0U<(B")
("nuks"	"$(02/(B")
("numbc"	"$(1Ue`S(B")
("nusqf"	"$(1U{(B")
("nwf"	"$(0@$(B")
("nwfa"	"$(0R((B")
("nwlv"	"$(1W!(B")
("nwlmi"	"$(1_8(B")
("nwtj"	"$(1J((B")
("nxu"	"$(0U@(B")
("nxff"	"$(0SA(B")
("nxno"	"$(1=#(B")
("nyo"	"$(0(u(B")
("nyrf"	"$(151(B")
("nyvi"	"$(0/9(B")
("o"	"$(0&*(B")
("ob"	"$(1!y$(0&z(B")
("oc"	"$(1!5(B")
("od"	"$(0)3(B")
("oe"	"$(1"Y(B")
("of"	"$(0).$(1!U(B")
("og"	"$(0'l1d(B")
("oh"	"$(0&,(B")
("oi"	"$(0)2(B")
("oj"	"$(0&p'*(B")
("ok"	"$(0({(B")
("ol"	"$(0)5(B")
("om"	"$(0'd$(1!G!J(B")
("on"	"$(0&@(B")
("op"	"$(0'($(1!r(B")
("oq"	"$(0*"(B")
("ou"	"$(1!K!X$(0'q(B")
("ow"	"$(0*|(B")
("oy"	"$(0&r(B")
("oaa"	"$(067(B")
("oam"	"$(0+!(B")
("oan"	"$(061(B")
("oav"	"$(1%=(B")
("oahe"	"$(1)b(B")
("oaln"	"$(0N.(B")
("oamo"	"$(13Z(B")
("oanb"	"$(0I~(B")
("oanl"	"$(1[$(B")
("oapp"	"$(1-~(B")
("oapv"	"$(13Y(B")
("oasm"	"$(1:@(B")
("oate"	"$(1\H(B")
("oavf"	"$(1VD(B")
("oawe"	"$(1Aa(B")
("obb"	"$(1-x(B")
("obo"	"$(0*Y(B")
("obp"	"$(0RX(B")
("obq"	"$(0+"(B")
("obv"	"$(1)0(B")
("obau"	"$(1-w(B")
("obbe"	"$(1OW(B")
("obch"	"$(1\J(B")
("obcn"	"$(0;"(B")
("obgb"	"$(13[(B")
("obgr"	"$(1-y(B")
("obhd"	"$(1n~(B")
("obhu"	"$(1!n(B")
("obhaf"	"$(1r6(B")
("obmc"	"$(066(B")
("obmr"	"$(1%?(B")
("obnd"	"$(01u(B")
("obof"	"$(1Ae(B")
("obou"	"$(1:B(B")
("obppa"	"$(1qp(B")
("obuu"	"$(1)'(B")
("obvk"	"$(1:C(B")
("ocb"	"$(0-}(B")
("oci"	"$(1!p(B")
("ocor"	"$(01x(B")
("ocru"	"$(1)*(B")
("ocsh"	"$(0):(B")
("ocwa"	"$(0Is(B")
("odc"	"$(1d:(B")
("odf"	"$(10RD[(B")
("odg"	"$(0@`(B")
("odi"	"$(0'j(B")
("odm"	"$(1"~(B")
("odp"	"$(1*B(B")
("odci"	"$(1-}(B")
("oddf"	"$(1OS(B")
("oddo"	"$(1O[(B")
("odhf"	"$(1a/(B")
("odmq"	"$(0:z(B")
("odog"	"$(1UV(B")
("odok"	"$(0<y(B")
("odsmg"	"$(1mo(B")
("odyj"	"$(0<|(B")
("ofb"	"$(01q(B")
("off"	"$(1-m(B")
("ofp"	"$(0<A(B")
("ofq"	"$(0*s(B")
("ofbc"	"$(0UB(B")
("ofbf"	"$(0]Y(B")
("ofbr"	"$(06:(B")
("ofbw"	"$(0N((B")
("ofdq"	"$(1I&(B")
("offs"	"$(1Hz(B")
("ofhu"	"$(13j(B")
("ofhaf"	"$(1oyo{(B")
("ofln"	"$(1I+(B")
("ofmvn"	"$(1]^(B")
("ofnl"	"$(1U%(B")
("ofqu"	"$(06'(B")
("ogd"	"$(1/w$(0Dv(B")
("oge"	"$(0:jYe(B")
("ogf"	"$(0BQ(B")
("ogg"	"$(0-p(B")
("ogi"	"$(1"}(B")
("ogj"	"$(13K(B")
("ogp"	"$(1/$(B")
("ogr"	"$(1%9$(0;H(B")
("ogbuc"	"$(0Hv(B")
("ogce"	"$(1-o(B")
("ogdi"	"$(0-o(B")
("oggu"	"$(0Iu(B")
("oghq"	"$(1i<(B")
("oghaf"	"$(0]O$(1a3(B")
("ogln"	"$(1)4(B")
("oglms"	"$(0IV(B")
("ogni"	"$(0R3(B")
("ogog"	"$(1[\(B")
("ogogg"	"$(1p](B")
("ogrg"	"$(1VA(B")
("ogrr"	"$(0Iv(B")
("ogsk"	"$(0E.(B")
("ogtj"	"$(06+(B")
("ogwc"	"$(1\F(B")
("ogyrg"	"$(1oQ(B")
("oha"	"$(0+%(B")
("ohg"	"$(0)7(B")
("ohi"	"$(0@/(B")
("ohj"	"$(0($(B")
("ohn"	"$(1!4(B")
("ohq"	"$(0)6(B")
("ohs"	"$(0+#(B")
("ohag"	"$(13a(B")
("ohbt"	"$(1%E(B")
("ohby"	"$(1%F(B")
("ohce"	"$(0E4(B")
("ohdf"	"$(13^(B")
("ohdi"	"$(1)2(B")
("ohdn"	"$(01z(B")
("ohdp"	"$(1Ad(B")
("ohdv"	"$(06=(B")
("ohdw"	"$(1I((B")
("oher"	"$(1%L(B")
("ohey"	"$(1#%(B")
("ohfp"	"$(1OZ(B")
("ohgu"	"$(1%C(B")
("ohhj"	"$(06?(B")
("ohjd"	"$(0-~(B")
("ohjg"	"$(13`(B")
("ohjm"	"$(13_(B")
("ohjr"	"$(1%D(B")
("ohjx"	"$(13\(B")
("ohkb"	"$(0I{(B")
("ohlb"	"$(13](B")
("ohml"	"$(1!z(B")
("ohnb"	"$(0-z(B")
("ohni"	"$(13k(B")
("ohoa"	"$(0:s(B")
("ohoi"	"$(13c(B")
("ohoo"	"$(1Af(B")
("ohpm"	"$(0+&(B")
("ohqi"	"$(01{(B")
("ohqo"	"$(0++(B")
("ohsb"	"$(0;$(B")
("ohsg"	"$(0I|(B")
("ohsk"	"$(1OY(B")
("ohuc"	"$(1kP(B")
("ohvf"	"$(01|(B")
("ohvl"	"$(0)8(B")
("ohwp"	"$(0E5(B")
("ohxu"	"$(06>(B")
("ohyu"	"$(1:D(B")
("oii"	"$(1-r(B")
("oik"	"$(0)4(B")
("oin"	"$(0&u(B")
("oip"	"$(1*O$(0'o(B")
("oir"	"$(1#&(B")
("oiv"	"$(1&6(B")
("oiar"	"$(06A(B")
("oiav"	"$(1(~$(05|(B")
("oiamh"	"$(1`\(B")
("oiapp"	"$(0U+(B")
("oiapv"	"$(1`](B")
("oiawe"	"$(0[O(B")
("oibi"	"$(0@,(B")
("oibv"	"$(0Qu(B")
("oibjj"	"$(1`Y(B")
("oibmr"	"$(1O:(B")
("oice"	"$(01w(B")
("oicyo"	"$(1[k(B")
("oidl"	"$(1Un(B")
("oieee"	"$(1[i(B")
("oiff"	"$(1[h(B")
("oifbd"	"$(1jh(B")
("oigbt"	"$(1jc(B")
("oiggu"	"$(0\S(B")
("oigit"	"$(1dY(B")
("oigrr"	"$(1jd(B")
("oihe"	"$(0E"(B")
("oihf"	"$(1Ai(B")
("oihg"	"$(0E!(B")
("oihi"	"$(0Yu(B")
("oihk"	"$(1AT(B")
("oihn"	"$(0:k(B")
("oihp"	"$(1:5%J(B")
("oihq"	"$(1%G(B")
("oihaf"	"$(0U;(B")
("oihag"	"$(1`_(B")
("oihbr"	"$(0Mq(B")
("oihdv"	"$(1[j(B")
("oihhl"	"$(1Hk(B")
("oihhw"	"$(0Ys(B")
("oihjr"	"$(1O8(B")
("oihon"	"$(1`a(B")
("oihqi"	"$(0Qt(B")
("oihuc"	"$(1r"(B")
("oihxe"	"$(0Yt(B")
("oiii"	"$(0U*(B")
("oiir"	"$(0Ig(B")
("oiibi"	"$(1d[(B")
("oiice"	"$(1Uo(B")
("oiijb"	"$(1Ul(B")
("oije"	"$(1)!(B")
("oijbd"	"$(1Uk(B")
("oijrb"	"$(1`Z(B")
("oijrr"	"$(0U)(B")
("oijtc"	"$(1je(B")
("oikf"	"$(0:t(B")
("oiku"	"$(1!k(B")
("oikkb"	"$(0U-(B")
("oilb"	"$(0E,(B")
("oilmc"	"$(1jg(B")
("oilmi"	"$(0Lt(B")
("oilmm"	"$(1`Q(B")
("oimn"	"$(13L(B")
("oimo"	"$(1%6(B")
("oimbc"	"$(0Mk(B")
("oimbk"	"$(1`[(B")
("oimrt"	"$(1Um(B")
("oimvn"	"$(11"(B")
("oinc"	"$(0?N(B")
("oini"	"$(0'p(B")
("oino"	"$(0E$(B")
("oinp"	"$(0/C(B")
("oinr"	"$(0+W(B")
("oint"	"$(1Xa(B")
("oinv"	"$(12}(B")
("oinw"	"$(19z(B")
("oinhx"	"$(0U,(B")
("oinri"	"$(0_/(B")
("oioi"	"$(06&(B")
("oiok"	"$(01v(B")
("oioks"	"$(0E%(B")
("oiolb"	"$(0Ii(B")
("oiomd"	"$(0Qv(B")
("oiond"	"$(1dZ(B")
("oionk"	"$(1``(B")
("oipf"	"$(1\E(B")
("oiph"	"$(1Hj(B")
("oipu"	"$(0E#(B")
("oipru"	"$(0Ih(B")
("oiruc"	"$(1jf(B")
("oisj"	"$(0Mp(B")
("oismm"	"$(0>d(B")
("oismr"	"$(0If(B")
("oisrr"	"$(1g}(B")
("oitk"	"$(1O9(B")
("oitt"	"$(0Mo(B")
("oitak"	"$(1g~(B")
("oitbo"	"$(1nH(B")
("oitlm"	"$(0[P(B")
("oitqg"	"$(1g|(B")
("oivii"	"$(0\T(B")
("oivno"	"$(1`^(B")
("oiwmv"	"$(0X*(B")
("oiyck"	"$(0Mn(B")
("oiymh"	"$(1lg(B")
("oiyrv"	"$(1qJ(B")
("oiywm"	"$(1lf(B")
("ojb"	"$(1!t(B")
("oje"	"$(1!j(B")
("ojk"	"$(0'n(B")
("ojp"	"$(0*q(B")
("ojr"	"$(0*v(B")
("oju"	"$(0*P(B")
("ojv"	"$(1%I(B")
("ojbc"	"$(1:?(B")
("ojbm"	"$(06-(B")
("ojcm"	"$(06((B")
("ojcr"	"$(1:7(B")
("ojhp"	"$(1%3(B")
("ojii"	"$(0E/(B")
("ojkp"	"$(0-r(B")
("ojlk"	"$(0-q(B")
("ojln"	"$(1-s(B")
("ojlo"	"$(1-n(B")
("ojmc"	"$(0R4(B")
("ojmf"	"$(1-{(B")
("ojmn"	"$(0*p(B")
("ojmo"	"$(0@*(B")
("ojmmr"	"$(14((B")
("ojnu"	"$(1-l(B")
("ojpn"	"$(1V@(B")
("ojrk"	"$(0:y(B")
("ojrr"	"$(06#(B")
("ojtc"	"$(1H{(B")
("ojtg"	"$(1OP(B")
("okb"	"$(0.!(B")
("okf"	"$(16~(B")
("okm"	"$(0*w(B")
("okn"	"$(0&s$(1%8(B")
("okp"	"$(0<@(B")
("okr"	"$(01"*x(B")
("oks"	"$(1!3(B")
("okcf"	"$(0Ix(B")
("okcwa"	"$(1]o(B")
("okhg"	"$(1)-(B")
("okhk"	"$(1,L(B")
("okhae"	"$(1ev(B")
("okhaf"	"$(1\9(B")
("okhdv"	"$(0GO(B")
("okhkb"	"$(0VM(B")
("okkb"	"$(1))(B")
("okkk"	"$(1Aj(B")
("oklb"	"$(0+*(B")
("oklu"	"$(062(B")
("okmf"	"$(1-t(B")
("okmr"	"$(06/(B")
("okms"	"$(1%;(B")
("okmrt"	"$(0B|(B")
("oknl"	"$(1,K(B")
("okog"	"$(0IW(B")
("okoo"	"$(01o(B")
("okoog"	"$(1>J(B")
("okryo"	"$(1NK(B")
("oksr"	"$(0*y(B")
("okss"	"$(08}(B")
("oktoe"	"$(1f,(B")
("okvif"	"$(0Vn(B")
("okwlp"	"$(1iH(B")
("oll"	"$(0&v(B")
("olbk"	"$(1#$(B")
("olln"	"$(0*t(B")
("olmc"	"$(1I#(B")
("olmo"	"$(0-{(B")
("olmt"	"$(0R2(B")
("olmy"	"$(06;(B")
("olnk"	"$(069(B")
("olob"	"$(0>m(B")
("olod"	"$(0=?(B")
("olof"	"$(0Z$Gt$(1e;(B")
("oloh"	"$(06<(B")
("oloj"	"$(1[a(B")
("olok"	"$(0,T;%(B")
("olom"	"$(1F8(B")
("olpb"	"$(13W(B")
("olwl"	"$(0*{(B")
("olws"	"$(1)((B")
("olwv"	"$(1Ab(B")
("oma"	"$(0-w(B")
("omc"	"$(0+/(B")
("omd"	"$(0+((B")
("omf"	"$(1!w(B")
("omg"	"$(0)A(B")
("omh"	"$(0)%(B")
("omi"	"$(0)&(B")
("omm"	"$(0&o(B")
("omn"	"$(0&q$(1!B(B")
("omr"	"$(0)Z(B")
("omu"	"$(0/+(B")
("ombb"	"$(0R1(B")
("ombe"	"$(0UA(B")
("ombl"	"$(1%K(B")
("ombn"	"$(02!(B")
("ombp"	"$(0E|(B")
("ombt"	"$(0-|(B")
("omdm"	"$(1aF$(0)1(B")
("omdp"	"$(158(B")
("omdu"	"$(1.uBZ(B")
("omdw"	"$(1>4(B")
("omfj"	"$(1"{(B")
("omfm"	"$(1#"(B")
("omfr"	"$(1).(B")
("omgn"	"$(060(B")
("omig"	"$(1%<(B")
("omjr"	"$(01=(B")
("omlb"	"$(06,(B")
("omlk"	"$(01n(B")
("ommf"	"$(1#'(B")
("ommi"	"$(1!s(B")
("ommm"	"$(1!F(B")
("ommp"	"$(0\c(B")
("ommr"	"$(1)$(B")
("ommv"	"$(1)#$(0*r(B")
("omnl"	"$(01X(B")
("omnn"	"$(0-t(B")
("omno"	"$(0S%(B")
("omnr"	"$(0*u(B")
("ompm"	"$(1-|(B")
("omrb"	"$(1aC(B")
("omrl"	"$(0.U(B")
("omrm"	"$(0CF(B")
("omro"	"$(1Ah(B")
("omrp"	"$(1n}(B")
("omrq"	"$(07W(B")
("omrr"	"$(1Q:(B")
("omrt"	"$(0>6$(1*=(B")
("omrw"	"$(17A3Q(B")
("omsl"	"$(0.<(B")
("omsp"	"$(1.n(B")
("omtn"	"$(1%7(B")
("omua"	"$(0Iw(B")
("omvh"	"$(1!v(B")
("omvm"	"$(1)"(B")
("omvn"	"$(1#!(B")
("omwa"	"$(0FE(B")
("omwc"	"$(0N$(B")
("omwd"	"$(1H|(B")
("omwf"	"$(1A^(B")
("omwl"	"$(0;'(B")
("omwm"	"$(0N#(B")
("omwu"	"$(1A_(B")
("omwv"	"$(13T(B")
("omyf"	"$(1A[(B")
("ond"	"$(0'k(B")
("onf"	"$(0+$(B")
("onl"	"$(1!x!_(B")
("onp"	"$(1&[(B")
("onu"	"$(1$J(B")
("onao"	"$(0Iz(B")
("onau"	"$(1),(B")
("onbc"	"$(13b(B")
("onbuu"	"$(0T7(B")
("oncr"	"$(1OX(B")
("oncsh"	"$(00B(B")
("onfd"	"$(086(B")
("onff"	"$(0B)(B")
("onhb"	"$(1H~(B")
("onhe"	"$(0)<(B")
("onhs"	"$(0&t(B")
("onhaf"	"$(1V7(B")
("onhey"	"$(1+O(B")
("onhqu"	"$(1D((B")
("onib"	"$(01p(B")
("onin"	"$(0-y(B")
("onjv"	"$(088(B")
("onjru"	"$(16D(B")
("onkg"	"$(1)1(B")
("onkl"	"$(1A"(B")
("onkq"	"$(0:{(B")
("onll"	"$(1"X(B")
("onln"	"$(1!}(B")
("onlll"	"$(1$K(B")
("onlln"	"$(03x(B")
("onlwl"	"$(1+N(B")
("onmk"	"$(01m(B")
("onmu"	"$(1%B(B")
("onmcw"	"$(10((B")
("onmlm"	"$(0B+(B")
("onmvm"	"$(0=H(B")
("onnl"	"$(1A$(B")
("onno"	"$(1D"(B")
("onnhs"	"$(0*=(B")
("onob"	"$(1'O(B")
("onog"	"$(1AJ(B")
("onqd"	"$(0@.(B")
("onqmb"	"$(1=-(B")
("onri"	"$(0Z,(B")
("ontq"	"$(087(B")
("onvne"	"$(0B*(B")
("onwk"	"$(08:(B")
("onwot"	"$(0K<(B")
("onyvo"	"$(089(B")
("oog"	"$(1-z$(0+e(B")
("ooj"	"$(1!m(B")
("oon"	"$(1!I(B")
("oou"	"$(1#+(B")
("ooah"	"$(0E3(B")
("oobg"	"$(1:8(B")
("oobm"	"$(01~(B")
("oobo"	"$(1(L(B")
("ooge"	"$(1.\(B")
("oogf"	"$(1I$(B")
("ooic"	"$(1Ag(B")
("ooii"	"$(0+'(B")
("ooin"	"$(1!o(B")
("ooir"	"$(0@0(B")
("ooll"	"$(1!q(B")
("ooln"	"$(0N-(B")
("ooma"	"$(0N&(B")
("oomb"	"$(06@(B")
("oomg"	"$(0."(B")
("oomn"	"$(0;#(B")
("oomo"	"$(0N'(B")
("oomr"	"$(1%M(B")
("oombc"	"$(1nE(B")
("oono"	"$(1]8(B")
("ooog"	"$(1)+(B")
("oooj"	"$(0@1(B")
("oook"	"$(0Un(B")
("oowy"	"$(01y(B")
("opa"	"$(1%A(B")
("opd"	"$(0'm$(1+F(B")
("oph"	"$(1"z(B")
("opp"	"$(0)9(B")
("opr"	"$(0+)(B")
("opt"	"$(1#)(B")
("opu"	"$(1!u$(0/*(B")
("opbuc"	"$(0D=?M(B")
("ophq"	"$(1+~(B")
("opko"	"$(1VB(B")
("opmc"	"$(0E1(B")
("opok"	"$(1<=(B")
("oppa"	"$(0:~(B")
("optd"	"$(13S(B")
("opwgf"	"$(0X8(B")
("opyhv"	"$(0?<(B")
("oqo"	"$(0)0(B")
("oqhk"	"$(13P(B")
("oqka"	"$(13f(B")
("oqke"	"$(1:<(B")
("oqkq"	"$(06)(B")
("oqmb"	"$(06*(B")
("oqmc"	"$(0E-(B")
("oqmf"	"$(1:=(B")
("oqmv"	"$(1-q(B")
("oqoa"	"$(1I'(B")
("ora"	"$(0Ab(B")
("orc"	"$(1#*(B")
("ord"	"$(01r(B")
("ori"	"$(1J@(B")
("orau"	"$(1)%(B")
("orhr"	"$(01t(B")
("orhu"	"$(0-v(B")
("orhaf"	"$(1h`m1$(0X2(B")
("orijb"	"$(1S0(B")
("orln"	"$(0@7(B")
("ormbc"	"$(0QqU$(B")
("ornl"	"$(05k(B")
("orno"	"$(1/{(B")
("ornin"	"$(0CU(B")
("orrj"	"$(1I"(B")
("orrk"	"$(0]X(B")
("orsj"	"$(13h(B")
("oruc"	"$(0I}(B")
("orvk"	"$(1)&(B")
("orxu"	"$(1OV(B")
("orye"	"$(1/Q$(0:v(B")
("oryo"	"$(01s(B")
("osj"	"$(1%:(B")
("osk"	"$(0)/(B")
("oso"	"$(1!l(B")
("oss"	"$(1"|(B")
("osav"	"$(0:w(B")
("oshi"	"$(0'r(B")
("osjr"	"$(065(B")
("osme"	"$(01l(B")
("osmg"	"$(13U(B")
("osmh"	"$(0E6(B")
("osmr"	"$(0*z(B")
("osmv"	"$(063(B")
("osnd"	"$(1I!(B")
("osqf"	"$(1:>(B")
("osrj"	"$(0N"(B")
("osrr"	"$(1A`(B")
("ossr"	"$(02"(B")
("ostt"	"$(13V(B")
("osuu"	"$(064(B")
("ota"	"$(06.(B")
("otc"	"$(0-s(B")
("otf"	"$(0BS(B")
("otq"	"$(0-m(B")
("ott"	"$(0-x(B")
("otbc"	"$(1.!(B")
("otco"	"$(1H}$(0Iy(B")
("otcw"	"$(13e(B")
("otdd"	"$(1Wh(B")
("otgi"	"$(0N!(B")
("othb"	"$(0@-(B")
("otif"	"$(1OR(B")
("otkr"	"$(0:x(B")
("otlk"	"$(13g(B")
("otlm"	"$(0E0(B")
("otmc"	"$(1-p(B")
("otmv"	"$(13R(B")
("otniq"	"$(0L[(B")
("otog"	"$(1kO(B")
("otqm"	"$(1::(B")
("otrk"	"$(1OT(B")
("otsj"	"$(1:E(B")
("ottb"	"$(1:;(B")
("otwa"	"$(1A](B")
("otwi"	"$(1Hy(B")
("otwn"	"$(1VC(B")
("otwv"	"$(0N%(B")
("otxc"	"$(1:9(B")
("ouf"	"$(10S(B")
("oum"	"$(05!(B")
("oubb"	"$(1Ac(B")
("oudk"	"$(09O(B")
("oudm"	"$(0>`(B")
("ouhmr"	"$(1?%(B")
("oumb"	"$(13i(B")
("oumwj"	"$(0Y'(B")
("ouog"	"$(0E2(B")
("ouon"	"$(1)/(B")
("outt"	"$(1?$(B")
("outrg"	"$(0^e(B")
("ouypd"	"$(1^N(B")
("ouypt"	"$(1mr(B")
("ovr"	"$(1%H(B")
("ovio"	"$(0*~(B")
("ovvv"	"$(1\I(B")
("owg"	"$(01}(B")
("owp"	"$(13X(B")
("owr"	"$(1%@(B")
("owjr"	"$(068(B")
("owlb"	"$(0:|(B")
("owlg"	"$(0\d(B")
("owlv"	"$(1OU(B")
("owmv"	"$(0:}(B")
("owwf"	"$(1o!(B")
("owww"	"$(0UC(B")
("owyi"	"$(0,e(B")
("owyta"	"$(1j[(B")
("oyg"	"$(0*o(B")
("oym"	"$(1!H(B")
("oyr"	"$(0*}(B")
("oyt"	"$(0*n(B")
("oyx"	"$(0R5(B")
("oyaj"	"$(1-u(B")
("oybc"	"$(0;!(B")
("oybp"	"$(1aD(B")
("oybs"	"$(0@+(B")
("oyck"	"$(1%4(B")
("oydu"	"$(1aE(B")
("oyfe"	"$(1-v(B")
("oyfu"	"$(1Hx(B")
("oyhn"	"$(0)-(B")
("oyhs"	"$(0),(B")
("oyhv"	"$(0-n(B")
("oyjj"	"$(1A\(B")
("oykk"	"$(0@2(B")
("oylm"	"$(0);(B")
("oymp"	"$(1%>(B")
("oymr"	"$(01k(B")
("oymy"	"$(1##(B")
("oyoj"	"$(1-k(B")
("oyok"	"$(0<x(B")
("oypd"	"$(1:A(B")
("oypp"	"$(1\G(B")
("oyra"	"$(0UD(B")
("oyrf"	"$(1-j(B")
("oyrn"	"$(0:u(B")
("oyrv"	"$(0;&$(1e:(B")
("oysk"	"$(06%(B")
("oyta"	"$(13d(B")
("oytg"	"$(0It(B")
("oytj"	"$(1AZ(B")
("oytp"	"$(0M~(B")
("oytr"	"$(06$(B")
("oyub"	"$(0G^(B")
("oyvi"	"$(1#((B")
("oyvo"	"$(1%5(B")
("oywm"	"$(1OQ(B")
("oyyiu"	"$(0F](B")
("p"	"$(0'A(B")
("pa"	"$(0*0*1(B")
("pc"	"$(15I(B")
("pd"	"$(0&?(B")
("ph"	"$(0(S(B")
("pi"	"$(0'&&E(B")
("pk"	"$(1"A(B")
("pl"	"$(1#}(B")
("pn"	"$(1!"(B")
("pp"	"$(0'S(B")
("pr"	"$(0(<(B")
("pt"	"$(0'a(B")
("pu"	"$(0';(B")
("pw"	"$(0-0(B")
("pam"	"$(0/P(B")
("pav"	"$(030(B")
("pahm"	"$(0A1(B")
("pahaf"	"$(1k/(B")
("paiu"	"$(0A6(B")
("paks"	"$(13r(B")
("pamh"	"$(1;j(B")
("pamj"	"$(07O(B")
("pamo"	"$(1;s(B")
("panb"	"$(1PP(B")
("pank"	"$(0No(B")
("panl"	"$(1-_(B")
("paph"	"$(0<L(B")
("papp"	"$(15H(B")
("papv"	"$(0A<(B")
("pate"	"$(1aY(B")
("pawe"	"$(0Jk(B")
("payf"	"$(0Nq(B")
("pbg"	"$(1Ox(B")
("pbm"	"$(1&e(B")
("pbac"	"$(1Bv(B")
("pbbb"	"$(1Br(B")
("pbcn"	"$(0A4(B")
("pbgr"	"$(0<M(B")
("pbhx"	"$(1Bt(B")
("pbjj"	"$(1;e(B")
("pbme"	"$(1;u(B")
("pbmr"	"$(035(B")
("pbou"	"$(1Bs(B")
("pbtv"	"$(0<K(B")
("pbue"	"$(1o,(B")
("pbug"	"$(0\k(B")
("pbvk"	"$(1Bx(B")
("pci"	"$(0,;(B")
("pcks"	"$(1I,(B")
("pcnh"	"$(07Q(B")
("pcru"	"$(07R(B")
("pcwa"	"$(0Np(B")
("pdd"	"$(15>(B")
("pdi"	"$(0*&(B")
("pdk"	"$(0,9(B")
("pdl"	"$(07N(B")
("pdhaf"	"$(1hT(B")
("pdlc"	"$(0Z6(B")
("pdmbc"	"$(0SZ(B")
("peg"	"$(0/J(B")
("peee"	"$(15@(B")
("peii"	"$(1Bp(B")
("pembc"	"$(1QD(B")
("pfb"	"$(07L(B")
("pfd"	"$(1%W(B")
("pff"	"$(15=(B")
("pfq"	"$(1&m(B")
("pfbf"	"$(1o+(B")
("pfbr"	"$(15A(B")
("pfdq"	"$(0Nn(B")
("pfmu"	"$(03.(B")
("pfmbc"	"$(1Ql^A(B")
("pfqu"	"$(15<(B")
("pgi"	"$(0/G(B")
("pgr"	"$(1*P(B")
("pgdi"	"$(033(B")
("pggu"	"$(1PH(B")
("pgni"	"$(1\q(B")
("pgth"	"$(1PI(B")
("pgtj"	"$(0<G(B")
("pha"	"$(1'3$(0/K(B")
("phh"	"$(0''(B")
("phi"	"$(0F%(B")
("phj"	"$(1"C(B")
("php"	"$(0/B(B")
("phs"	"$(1&i(B")
("phag"	"$(0A9(B")
("phbk"	"$(0R\(B")
("phbq"	"$(1,<(B")
("phbr"	"$(1*R(B")
("phbt"	"$(037(B")
("phbuu"	"$(1@7(B")
("phcn"	"$(1aZ(B")
("phdb"	"$(1PQ(B")
("phdd"	"$(0<O(B")
("phdf"	"$(0A;(B")
("pher"	"$(036(B")
("phgr"	"$(1/1(B")
("phgs"	"$(0Jm(B")
("phhn"	"$(1:I(B")
("phjr"	"$(034(B")
("phkb"	"$(1PR(B")
("phkp"	"$(15G(B")
("phlc"	"$(1a[(B")
("phln"	"$(0)H(B")
("phml"	"$(1$%(B")
("phnl"	"$(1(t(B")
("phpa"	"$(15D(B")
("phqm"	"$(0/M(B")
("phqo"	"$(1&h(B")
("phsb"	"$(1;l(B")
("phsk"	"$(1W,5E(B")
("phvp"	"$(1$#(B")
("phyhv"	"$(12|(B")
("pim"	"$(0'%(B")
("pir"	"$(0/L(B")
("pit"	"$(1/&(B")
("piv"	"$(1&a(B")
("piav"	"$(1/%(B")
("pice"	"$(1/-(B")
("piih"	"$(0Jo(B")
("pijb"	"$(022(B")
("pijc"	"$(0/H(B")
("pilb"	"$(0Jp(B")
("pile"	"$(0Jj(B")
("pirp"	"$(0R[(B")
("pitc"	"$(1aV(B")
("piyr"	"$(0<D(B")
("pje"	"$(1#{(B")
("pjr"	"$(1&^(B")
("pjbc"	"$(0E}(B")
("pjbd"	"$(07S(B")
("pjbo"	"$(1\p(B")
("pjcm"	"$(159(B")
("pjhr"	"$(1;p(B")
("pjhaf"	"$(1V5(B")
("pjii"	"$(1J/(B")
("pjip"	"$(1PK(B")
("pjjl"	"$(0Jn(B")
("pjkp"	"$(1*F(B")
("pjlv"	"$(0<E(B")
("pjmf"	"$(15:(B")
("pjmm"	"$(1;o(B")
("pjnu"	"$(0<B(B")
("pjpn"	"$(1\n(B")
("pjrr"	"$(15;(B")
("pjsqf"	"$(1OA(B")
("pjtc"	"$(0Ns(B")
("pkf"	"$(031(B")
("pkk"	"$(0(!(B")
("pkn"	"$(1*E!7(B")
("pkcf"	"$(1PM(B")
("pkkb"	"$(1/,(B")
("pkkk"	"$(1J=(B")
("pklb"	"$(0/I(B")
("pklq"	"$(0H!(B")
("pklu"	"$(1.2(B")
("pkmb"	"$(0A3(B")
("pknio"	"$(0Kk(B")
("pksb"	"$(1Bq(B")
("plw"	"$(1&f(B")
("plbk"	"$(0/E(B")
("plbu"	"$(0,8(B")
("plln"	"$(0/O(B")
("plmc"	"$(1PO(B")
("plmo"	"$(1*K(B")
("plmy"	"$(15C(B")
("plpc"	"$(1eO(B")
("plwv"	"$(1J8(B")
("pmf"	"$(1$&(B")
("pmak"	"$(1\r(B")
("pmam"	"$(1rK(B")
("pmbb"	"$(0U`(B")
("pmbc"	"$(1Bw$(0@#(B")
("pmbe"	"$(1aW(B")
("pmbm"	"$(032(B")
("pmcw"	"$(1*G(B")
("pmfj"	"$(1#3&](B")
("pmfm"	"$(1&n(B")
("pmmr"	"$(07M(B")
("pmmu"	"$(1#z(B")
("pmob"	"$(1&_(B")
("pmrw"	"$(0;1$(1;f(B")
("pmua"	"$(1PL(B")
("pmwd"	"$(0F!$(1PN(B")
("pmwf"	"$(1J2(B")
("pmwj"	"$(1PJ(B")
("pmwl"	"$(1;r(B")
("pmym"	"$(0/F(B")
("png"	"$(0,:(B")
("pno"	"$(1$"(B")
("pnau"	"$(1/.(B")
("pnbq"	"$(0R](B")
("pncr"	"$(1W+(B")
("pnhb"	"$(1PG(B")
("pnhe"	"$(1$!(B")
("pnib"	"$(1/'(B")
("pnin"	"$(1*L(B")
("pnyi"	"$(15?(B")
("pod"	"$(1*Q(B")
("pog"	"$(0<N(B")
("poj"	"$(1#~(B")
("pon"	"$(1"B(B")
("poae"	"$(0A8(B")
("poge"	"$(1Bu(B")
("pogf"	"$(0Nt(B")
("poii"	"$(1&p(B")
("poim"	"$(0[n(B")
("poin"	"$(1$'(B")
("poir"	"$(0F$(B")
("poju"	"$(1%X(B")
("pomb"	"$(15J(B")
("pomd"	"$(1//(B")
("pomg"	"$(1*S(B")
("pomn"	"$(0A:(B")
("pomo"	"$(1W-(B")
("pomr"	"$(03/(B")
("pond"	"$(0F#(B")
("ponbg"	"$(1l<(B")
("potf"	"$(0Nu(B")
("powy"	"$(07P(B")
("ppa"	"$(1*I*M(B")
("ppg"	"$(1#O(B")
("pph"	"$(1&\(B")
("ppp"	"$(1;a(B")
("ppr"	"$(1&j(B")
("ppu"	"$(1#|(B")
("ppad"	"$(1;k(B")
("ppfd"	"$(11n(B")
("ppha"	"$(04V(B")
("pphp"	"$(0<P(B")
("pphqu"	"$(1'N(B")
("pppd"	"$(1W[(B")
("pppf"	"$(1bc(B")
("ppph"	"$(1+K(B")
("ppru"	"$(1&o(B")
("pptd"	"$(1;i(B")
("ppuk"	"$(1*N(B")
("pqmb"	"$(0<F(B")
("pqmf"	"$(1Bo(B")
("prb"	"$(1/)(B")
("pru"	"$(0'~(B")
("prau"	"$(1/((B")
("prhg"	"$(1/0(B")
("prhu"	"$(1&d(B")
("prhaf"	"$(1\5(B")
("prhml"	"$(1*k(B")
("prks"	"$(0+:(B")
("prno"	"$(1+G(B")
("prog"	"$(0IX(B")
("prrd"	"$(1W((B")
("prrj"	"$(0Nr(B")
("prrs"	"$(0A2(B")
("prvp"	"$(1&`(B")
("prxu"	"$(1W'(B")
("psh"	"$(1!\$(0'#(B")
("psp"	"$(0/N(B")
("psav"	"$(1;q(B")
("pseg"	"$(1J0(B")
("pshr"	"$(1&b(B")
("psjj"	"$(0\l(B")
("psko"	"$(0A/(B")
("psma"	"$(1J6(B")
("psmg"	"$(1*H(B")
("psmh"	"$(1J5(B")
("psmi"	"$(1PT(B")
("psmv"	"$(0<H(B")
("psrr"	"$(1J<(B")
("pta"	"$(0<I(B")
("ptt"	"$(1*D(B")
("ptak"	"$(1J7(B")
("ptbo"	"$(1\s(B")
("ptbuc"	"$(1@Q(B")
("pthg"	"$(0U^(B")
("ptlb"	"$(1J3(B")
("ptlj"	"$(1;h(B")
("ptlm"	"$(1J4(B")
("ptmv"	"$(1;g(B")
("ptor"	"$(1:H(B")
("ptov"	"$(1a](B")
("ptrg"	"$(1k[(B")
("ptwa"	"$(1J1(B")
("ptwi"	"$(1aX(B")
("ptwu"	"$(0Z7(B")
("ptxc"	"$(1Bn(B")
("ptyu"	"$(0E~(B")
("puf"	"$(1+s(B")
("puk"	"$(1$$$(0)K(B")
("puce"	"$(1;m(B")
("pudhe"	"$(0Ot(B")
("puhaf"	"$(1m-(B")
("puln"	"$(0+6(B")
("pumb"	"$(0A5(B")
("pumt"	"$(0F((B")
("pumbc"	"$(0Ib(B")
("punl"	"$(0I:(B")
("puog"	"$(0Yf$(1J9(B")
("pupu"	"$(09q(B")
("pve"	"$(1&l(B")
("pvis"	"$(1&k(B")
("pvvw"	"$(0A7(B")
("pwc"	"$(1&g(B")
("pwd"	"$(1/+5B(B")
("pwg"	"$(1/*(B")
("pwr"	"$(1*J(B")
("pwim"	"$(1J>(B")
("pwjc"	"$(0Jl(B")
("pwlj"	"$(1W*(B")
("pwls"	"$(0A0(B")
("pwlv"	"$(1W)(B")
("pwmv"	"$(1;t(B")
("pwot"	"$(0F"(B")
("pyr"	"$(1&c(B")
("pyv"	"$(0*%(B")
("pyx"	"$(1\o(B")
("pyy"	"$(1#y(B")
("pyaj"	"$(0<J(B")
("pyck"	"$(1*C(B")
("pyfu"	"$(1PF(B")
("pyhr"	"$(1J:(B")
("pymr"	"$(1-S(B")
("pyoj"	"$(0<C(B")
("pypo"	"$(1W&(B")
("pyrd"	"$(0<Q(B")
("pyrf"	"$(15F(B")
("pyrv"	"$(1hx(B")
("pyta"	"$(1;d(B")
("pytg"	"$(0Nm(B")
("pytj"	"$(1J.(B")
("pytp"	"$(0RZ(B")
("pyvw"	"$(1Bm(B")
("pywd"	"$(0RY(B")
("pywv"	"$(0Z5(B")
("q"	"$(0'D(B")
("qa"	"$(1$.(B")
("qb"	"$(1$4(B")
("qc"	"$(0(W(B")
("qd"	"$(0*V(B")
("qi"	"$(0,G(B")
("qj"	"$(0&e(B")
("qm"	"$(0*,(B")
("qo"	"$(0'4(B")
("qr"	"$(0*+(B")
("qu"	"$(0'E(B")
("qy"	"$(0(X(B")
("qan"	"$(0<d(B")
("qau"	"$(0,E(B")
("qav"	"$(1*\(B")
("qail"	"$(1/<(B")
("qaiu"	"$(1<)(B")
("qamh"	"$(0AS(B")
("qamj"	"$(07f(B")
("qamo"	"$(0AI(B")
("qanb"	"$(1P_(B")
("qang"	"$(1P^(B")
("qank"	"$(1/K(B")
("qanr"	"$(0Uk(B")
("qanw"	"$(0[p(B")
("qapp"	"$(15h(B")
("qapv"	"$(0AL(B")
("qase"	"$(0O&(B")
("qasm"	"$(1C4(B")
("qbb"	"$(15a(B")
("qbd"	"$(0<i(B")
("qbm"	"$(1&|(B")
("qbv"	"$(1/@(B")
("qbbb"	"$(1C3(B")
("qbbe"	"$(0<g(B")
("qbbsd"	"$(0T|(B")
("qbbuu"	"$(1UZ(B")
("qbcd"	"$(0<Y(B")
("qbcv"	"$(1hz(B")
("qbdi"	"$(1/>(B")
("qbhx"	"$(1C7(B")
("qbhaf"	"$(1hJ(B")
("qbjj"	"$(0AM(B")
("qbjmo"	"$(0T{(B")
("qbkf"	"$(0O)(B")
("qbme"	"$(0AO(B")
("qbmr"	"$(1*^(B")
("qbnd"	"$(1/?(B")
("qbnl"	"$(19u(B")
("qbnau"	"$(1O((B")
("qbou"	"$(0F7(B")
("qbsd"	"$(0<h(B")
("qbue"	"$(0^9(B")
("qbuu"	"$(1/L(B")
("qchq"	"$(1;y(B")
("qcks"	"$(0E>(B")
("qcno"	"$(0O-(B")
("qcru"	"$(1/A(B")
("qcsh"	"$(0,M(B")
("qdb"	"$(1*e(B")
("qdj"	"$(0/\(B")
("qdk"	"$(0,C(B")
("qdau"	"$(09W(B")
("qdbms"	"$(1F:(B")
("qdfh"	"$(12+(B")
("qdhe"	"$(0/_(B")
("qdhqu"	"$(09X(B")
("qdir"	"$(18F(B")
("qdksr"	"$(18E(B")
("qdlwv"	"$(1^T(B")
("qdmbc"	"$(1Uf(B")
("qdmbe"	"$(1k~(B")
("qdmmi"	"$(09U(B")
("qdmvi"	"$(0Sw(B")
("qdnd"	"$(1,v(B")
("qdrlr"	"$(0>f(B")
("qdss"	"$(18D(B")
("qdta"	"$(1M*(B")
("qdtt"	"$(09V(B")
("qdttb"	"$(1YR(B")
("qdwf"	"$(0AB(B")
("qdwlb"	"$(0PK(B")
("qdybs"	"$(1YQ(B")
("qei"	"$(1"K(B")
("qeed"	"$(1CA(B")
("qeee"	"$(15X(B")
("qeii"	"$(0F4(B")
("qfb"	"$(07X(B")
("qff"	"$(15Q(B")
("qfh"	"$(0,>(B")
("qfq"	"$(0/X(B")
("qfbf"	"$(1o-(B")
("qfbk"	"$(0Jr(B")
("qfbq"	"$(0N}(B")
("qfbw"	"$(0Ra(B")
("qffs"	"$(0N|(B")
("qfqu"	"$(0<W(B")
("qgb"	"$(1&~(B")
("qgg"	"$(03I(B")
("qgi"	"$(1&v(B")
("qgr"	"$(03?(B")
("qgdi"	"$(03>(B")
("qggu"	"$(0O"(B")
("qggy"	"$(0<c(B")
("qgit"	"$(1C+(B")
("qglc"	"$(1/H(B")
("qgni"	"$(1\v(B")
("qgrc"	"$(0XJ(B")
("qha"	"$(0/j(B")
("qhd"	"$(1/p(B")
("qhe"	"$(10B$(0,I(B")
("qhj"	"$(1"H(B")
("qhk"	"$(02W$(1$5(B")
("qhp"	"$(0*-$(1/!(B")
("qhq"	"$(07V(B")
("qhag"	"$(1</(B")
("qhal"	"$(1W8(B")
("qhau"	"$(0F8(B")
("qhbf"	"$(1o.(B")
("qhbk"	"$(1W9(B")
("qhbu"	"$(0^:(B")
("qhdf"	"$(0AP(B")
("qhdv"	"$(15`(B")
("qhdw"	"$(0O'(B")
("qhej"	"$(1/N(B")
("qher"	"$(1*_(B")
("qhgr"	"$(1/B(B")
("qhhj"	"$(15^(B")
("qhhv"	"$(1*b(B")
("qhio"	"$(1'"(B")
("qhjg"	"$(1<6(B")
("qhjm"	"$(0AN(B")
("qhjr"	"$(03E(B")
("qhju"	"$(1<7(B")
("qhjx"	"$(0AG(B")
("qhkb"	"$(1Pb(B")
("qhkp"	"$(15R(B")
("qhlo"	"$(0,O<m(B")
("qhlmi"	"$(1?|(B")
("qhml"	"$(0,L(B")
("qhmy"	"$(0/q(B")
("qhne"	"$(0,N(B")
("qhnbg"	"$(1GJ(B")
("qhoa"	"$(1<,(B")
("qhoo"	"$(1JU(B")
("qhor"	"$(1Pe(B")
("qhpm"	"$(0/k(B")
("qhqo"	"$(1&x(B")
("qhrf"	"$(1C:(B")
("qhsb"	"$(15_<8(B")
("qhsk"	"$(0<o$(1W4(B")
("qhsm"	"$(1C<(B")
("qhuc"	"$(1mS(B")
("qhul"	"$(1\x(B")
("qhuo"	"$(1\y(B")
("qhuu"	"$(0O*(B")
("qhvl"	"$(0,P(B")
("qhvp"	"$(1$1(B")
("qhvif"	"$(1>z(B")
("qhwp"	"$(1JT(B")
("qhxe"	"$(0F3(B")
("qhxm"	"$(07^(B")
("qhxu"	"$(15](B")
("qhye"	"$(0F1(B")
("qhyu"	"$(1C=(B")
("qhymu"	"$(0]W(B")
("qir"	"$(0/r(B")
("qit"	"$(0/l(B")
("qibi"	"$(0F2(B")
("qice"	"$(1/D(B")
("qidy"	"$(1mQ(B")
("qihf"	"$(1JKC0(B")
("qihu"	"$(1$3(B")
("qiih"	"$(0J}(B")
("qijb"	"$(07[(B")
("qije"	"$(1/8(B")
("qikf"	"$(1<!(B")
("qikk"	"$(0/a(B")
("qiku"	"$(1$2(B")
("qilr"	"$(0F.(B")
("qiok"	"$(07e(B")
("qipd"	"$(1hy(B")
("qipm"	"$(03=(B")
("qirm"	"$(15S(B")
("qirp"	"$(0Rc(B")
("qitc"	"$(0XD(B")
("qitf"	"$(0J|(B")
("qixp"	"$(1JE(B")
("qiyr"	"$(15N(B")
("qje"	"$(0,A(B")
("qjk"	"$(1"J(B")
("qjv"	"$(03;(B")
("qjbc"	"$(1C.(B")
("qjbd"	"$(1/7(B")
("qjbf"	"$(0Ui(B")
("qjbj"	"$(1<2(B")
("qjbv"	"$(1q!(B")
("qjcm"	"$(0<V(B")
("qjcn"	"$(03:(B")
("qjcs"	"$(0F,(B")
("qjcv"	"$(1k\(B")
("qjhp"	"$(1*c(B")
("qjhu"	"$(1&s(B")
("qjii"	"$(1JG(B")
("qjji"	"$(1PY(B")
("qjjj"	"$(1C*(B")
("qjjl"	"$(1JH(B")
("qjks"	"$(03C(B")
("qjlo"	"$(0<[(B")
("qjmc"	"$(1\t(B")
("qjmm"	"$(1;z(B")
("qjmo"	"$(15c(B")
("qjmr"	"$(1,T(B")
("qjmu"	"$(1/6(B")
("qjnl"	"$(1cy$(0-[(B")
("qjnu"	"$(15L(B")
("qjoa"	"$(1JC(B")
("qjpa"	"$(1C,(B")
("qjpn"	"$(0Uh(B")
("qjqp"	"$(1eP(B")
("qjqr"	"$(1C((B")
("qjsm"	"$(0<2(B")
("qjsmp"	"$(0Nd(B")
("qjto"	"$(1h|(B")
("qjtv"	"$(1eQ(B")
("qjwj"	"$(1/F(B")
("qka"	"$(03O(B")
("qke"	"$(08;(B")
("qkf"	"$(1*g(B")
("qkq"	"$(0.a(B")
("qks"	"$(1!^(B")
("qkap"	"$(1Bl(B")
("qkali"	"$(0]&(B")
("qkce"	"$(1JR(B")
("qkcf"	"$(0O$(B")
("qkhd"	"$(098(B")
("qkhk"	"$(02X(B")
("qkhx"	"$(0>p(B")
("qkhxp"	"$(1PD(B")
("qkja"	"$(1JM(B")
("qklb"	"$(1&w(B")
("qkld"	"$(1*Y(B")
("qklu"	"$(0<`(B")
("qkmf"	"$(0<q(B")
("qkmr"	"$(15V(B")
("qkms"	"$(1*Z(B")
("qkoo"	"$(07Y(B")
("qksb"	"$(1C9(B")
("qkso"	"$(1JL(B")
("qkss"	"$(1*](B")
("qkus"	"$(0/b(B")
("qla"	"$(15q(B")
("qlc"	"$(1UN(B")
("qle"	"$(15d(B")
("qlf"	"$(17!(B")
("qlp"	"$(156(B")
("qlr"	"$(06Z(B")
("qlw"	"$(0/e(B")
("qlbk"	"$(1'!(B")
("qlbu"	"$(1$*(B")
("qlln"	"$(0/[(B")
("qllmi"	"$(0HE(B")
("qlmc"	"$(1P`(B")
("qlmo"	"$(03H(B")
("qlmr"	"$(1>T(B")
("qlmy"	"$(0<k(B")
("qlpb"	"$(0AT(B")
("qlryo"	"$(1NJ(B")
("qlvk"	"$(0XI(B")
("qlwl"	"$(1&}(B")
("qlwp"	"$(03@(B")
("qlwv"	"$(0Jw(B")
("qlyhv"	"$(1G@(B")
("qlymr"	"$(0M((B")
("qmb"	"$(01f(B")
("qmd"	"$(1"D(B")
("qmf"	"$(1$-(B")
("qmj"	"$(1"E(B")
("qmn"	"$(0(U(B")
("qmr"	"$(0/`(B")
("qmu"	"$(1"F(B")
("qmv"	"$(01Q(B")
("qmak"	"$(1\w(B")
("qmbb"	"$(1\u(B")
("qmbc"	"$(1C)(B")
("qmbe"	"$(0XF(B")
("qmbg"	"$(1eS(B")
("qmbs"	"$(1JF(B")
("qmbw"	"$(0Rg(B")
("qmbuc"	"$(0?K(B")
("qmfj"	"$(0/d(B")
("qmgg"	"$(0<_(B")
("qmgn"	"$(15W(B")
("qmia"	"$(1C/(B")
("qmig"	"$(1*[(B")
("qmjk"	"$(1PX(B")
("qmlk"	"$(1/G(B")
("qmlm"	"$(15T(B")
("qmmi"	"$(1$+(B")
("qmmp"	"$(1mR(B")
("qmmr"	"$(07\(B")
("qmmu"	"$(1$,(B")
("qmmv"	"$(07Z(B")
("qmrb"	"$(1C-(B")
("qmrw"	"$(1<#(B")
("qmsu"	"$(0,F(B")
("qmto"	"$(1PZ(B")
("qmvm"	"$(1/I(B")
("qmvif"	"$(09E(B")
("qmwd"	"$(1C@(B")
("qmwf"	"$(1JJ(B")
("qmwj"	"$(0O,(B")
("qmwyf"	"$(1q2(B")
("qmwyi"	"$(03v(B")
("qng"	"$(0,D(B")
("qno"	"$(1$0(B")
("qnau"	"$(07b(B")
("qnbg"	"$(1/E(B")
("qnbk"	"$(0AQ(B")
("qncr"	"$(0Rk(B")
("qndf"	"$(1CB(B")
("qnem"	"$(03D(B")
("qnhd"	"$(0AD(B")
("qnhe"	"$(1$/(B")
("qnhs"	"$(0(V(B")
("qnhx"	"$(15Y(B")
("qnib"	"$(1/9(B")
("qnin"	"$(0,J$(1*`(B")
("qnkg"	"$(07`(B")
("qnkm"	"$(15b(B")
("qnkq"	"$(1<((B")
("qnlb"	"$(1Pd(B")
("qnmm"	"$(1C2(B")
("qnob"	"$(1<*(B")
("qnoe"	"$(0O!(B")
("qnok"	"$(0AE(B")
("qnot"	"$(1P\(B")
("qnri"	"$(0[q(B")
("qnwa"	"$(1ad(B")
("qoa"	"$(0Af(B")
("qog"	"$(0<e(B")
("qon"	"$(1"I(B")
("qoah"	"$(1J[(B")
("qobg"	"$(1C%(B")
("qobuu"	"$(0?>(B")
("qodi"	"$(1&y(B")
("qohg"	"$(1*h(B")
("qohh"	"$(1&z(B")
("qohaf"	"$(1V1(B")
("qoii"	"$(0/s(B")
("qoim"	"$(1h{(B")
("qoin"	"$(1$7(B")
("qoip"	"$(0<n(B")
("qoir"	"$(0F6(B")
("qojwj"	"$(0QF(B")
("qoll"	"$(1$8(B")
("qomb"	"$(0<f(B")
("qomd"	"$(1/O(B")
("qomg"	"$(03G(B")
("qomn"	"$(1<.(B")
("qomo"	"$(0Ri(B")
("qomr"	"$(03F<p(B")
("qomt"	"$(1<-(B")
("qonl"	"$(1%+(B")
("qoog"	"$(07d(B")
("qopd"	"$(0/o(B")
("qorq"	"$(1JW(B")
("qotf"	"$(0O((B")
("qowy"	"$(1/C(B")
("qoya"	"$(1JV(B")
("qoyb"	"$(0Rj(B")
("qpa"	"$(03A(B")
("qpd"	"$(1"G(B")
("qpi"	"$(1"L(B")
("qpp"	"$(0,H(B")
("qpr"	"$(0/n(B")
("qpt"	"$(1&t(B")
("qpu"	"$(1$6(B")
("qpfd"	"$(0<j(B")
("qpko"	"$(0Uj(B")
("qpmm"	"$(1;}(B")
("qpou"	"$(0<l(B")
("qppa"	"$(0AC(B")
("qpru"	"$(0/m(B")
("qptd"	"$(1<'(B")
("qpuu"	"$(1C8(B")
("qpyr"	"$(1<5(B")
("qqo"	"$(0,B(B")
("qqq"	"$(1;x(B")
("qqu"	"$(1"M(B")
("qqhk"	"$(1<"(B")
("qqkk"	"$(0AF(B")
("qqkq"	"$(0<\(B")
("qqmb"	"$(15e(B")
("qqoj"	"$(0XG(B")
("qqou"	"$(1JY(B")
("qrb"	"$(07a(B")
("qrau"	"$(1/=(B")
("qrbc"	"$(0F5(B")
("qrrd"	"$(0Rh(B")
("qrrj"	"$(1Pa(B")
("qrsh"	"$(0/g(B")
("qrsj"	"$(0AK(B")
("qrsn"	"$(07g(B")
("qruc"	"$(0N~(B")
("qrvp"	"$(0/Z(B")
("qryo"	"$(07_(B")
("qsj"	"$(1*f(B")
("qsp"	"$(1&{(B")
("qss"	"$(0/](B")
("qsav"	"$(1<$(B")
("qshr"	"$(0/^(B")
("qsje"	"$(15U(B")
("qsjj"	"$(0\m(B")
("qsjl"	"$(1<%(B")
("qsjr"	"$(15Z(B")
("qskr"	"$(1/;(B")
("qsll"	"$(1*X(B")
("qsma"	"$(0Jx(B")
("qsmb"	"$(0<b(B")
("qsmg"	"$(0AJUl(B")
("qsmh"	"$(1JN(B")
("qsmi"	"$(1P](B")
("qsmv"	"$(15f(B")
("qsql"	"$(07c(B")
("qsrj"	"$(1W/(B")
("qsrr"	"$(1JI(B")
("qssr"	"$(1/:(B")
("qstt"	"$(0AR(B")
("qstv"	"$(1C1(B")
("qsuu"	"$(0<](B")
("qswu"	"$(0^`(B")
("qsyq"	"$(1Pc(B")
("qta"	"$(0<^(B")
("qtc"	"$(03B(B")
("qtm"	"$(1&u(B")
("qtt"	"$(03<(B")
("qtw"	"$(0AA(B")
("qtak"	"$(0Jv(B")
("qtav"	"$(1W0(B")
("qtbc"	"$(15\(B")
("qtbf"	"$(1ac(B")
("qtbk"	"$(0O%(B")
("qtbn"	"$(1;~(B")
("qtcl"	"$(0O#(B")
("qtco"	"$(0N{(B")
("qtct"	"$(1C'(B")
("qtcw"	"$(1<1(B")
("qtkl"	"$(0XE(B")
("qtmc"	"$(1P[5g(B")
("qtmv"	"$(1<&(B")
("qtod"	"$(0F0(B")
("qtoe"	"$(0Um(B")
("qtog"	"$(0]b(B")
("qtor"	"$(0F/(B")
("qtov"	"$(1ab(B")
("qtpd"	"$(1W7(B")
("qtqm"	"$(0F+(B")
("qtrk"	"$(1W2(B")
("qttb"	"$(0F9(B")
("qttc"	"$(15P(B")
("qtub"	"$(1C&(B")
("qtwi"	"$(0O+(B")
("qtwv"	"$(1W6(B")
("qtxc"	"$(1C?(B")
("qud"	"$(1Q/(B")
("quu"	"$(0/h(B")
("quv"	"$(1I](B")
("qumb"	"$(0AH(B")
("quob"	"$(0\n(B")
("quog"	"$(0Jz(B")
("qvid"	"$(1a`(B")
("qvis"	"$(0/p(B")
("qvno"	"$(1<+(B")
("qvoi"	"$(1p9(B")
("qvvd"	"$(1J\(B")
("qvvn"	"$(1*a(B")
("qvvv"	"$(1aa(B")
("qwd"	"$(15i$(07](B")
("qwg"	"$(1/J(B")
("qwl"	"$(0/f(B")
("qwp"	"$(1<3(B")
("qwhr"	"$(1JO(B")
("qwim"	"$(0Jy(B")
("qwjc"	"$(1JQ(B")
("qwkp"	"$(1C5(B")
("qwli"	"$(1W3(B")
("qwlj"	"$(0Rf(B")
("qwlp"	"$(0XH(B")
("qwlv"	"$(1W1(B")
("qwmv"	"$(1<4(B")
("qwot"	"$(1C6(B")
("qwvf"	"$(1JP(B")
("qwwv"	"$(1eT(B")
("qwyi"	"$(0/i(B")
("qyg"	"$(0/Y(B")
("qyj"	"$(0,@(B")
("qyk"	"$(0,Q(B")
("qyr"	"$(0/c(B")
("qyt"	"$(0/W(B")
("qyx"	"$(0Ug(B")
("qyy"	"$(1$)(B")
("qyaj"	"$(0<a(B")
("qybb"	"$(1;{$(0Rl(B")
("qybg"	"$(1mP(B")
("qybk"	"$(0Ju(B")
("qybp"	"$(0Z9(B")
("qybs"	"$(1C$(B")
("qycb"	"$(0Js(B")
("qyck"	"$(1*W(B")
("qygq"	"$(0Rb(B")
("qyhj"	"$(1JS(B")
("qyhn"	"$(0,?(B")
("qyhr"	"$(1C;(B")
("qyhv"	"$(1*d(B")
("qyij"	"$(0Jt(B")
("qyjj"	"$(1JZ(B")
("qylh"	"$(1/M(B")
("qylm"	"$(0,K(B")
("qymb"	"$(15[(B")
("qyoj"	"$(15O(B")
("qyok"	"$(0<X(B")
("qypo"	"$(0Rd(B")
("qypp"	"$(1a_(B")
("qyps"	"$(0Re(B")
("qypt"	"$(1eU(B")
("qyrb"	"$(0F-(B")
("qyrf"	"$(0<U(B")
("qyrn"	"$(1eR;|(B")
("qyrv"	"$(0[o(B")
("qysd"	"$(1<0(B")
("qytg"	"$(0Nz(B")
("qytr"	"$(15M(B")
("qytu"	"$(1JX(B")
("qytv"	"$(0<Z(B")
("qyub"	"$(1JD(B")
("qyvg"	"$(0R`(B")
("qyvw"	"$(1C#(B")
("qywm"	"$(0R_(B")
("qyyb"	"$(1a^(B")
("r"	"$(0&H(B")
("rb"	"$(1$v(B")
("rc"	"$(0(8(=(B")
("rd"	"$(0+E(B")
("rf"	"$(1#=(B")
("rg"	"$(0)T(B")
("rp"	"$(0(:(B")
("ru"	"$(0&Z(B")
("raa"	"$(0;A(B")
("ram"	"$(1%d(B")
("rau"	"$(0-X+D(B")
("rav"	"$(1)A(B")
("rail"	"$(06e(B")
("ramj"	"$(1.D(B")
("ranx"	"$(1eC(B")
("rapv"	"$(0@C(B")
("rase"	"$(1Om(B")
("rate"	"$(1aI(B")
("raye"	"$(1CC(B")
("rbd"	"$(14.(B")
("rbm"	"$(0.F(B")
("rbv"	"$(1.F(B")
("rbbe"	"$(0RF(B")
("rbbr"	"$(1:a(B")
("rbcv"	"$(0[d(B")
("rbdi"	"$(1.E(B")
("rbgr"	"$(0;M(B")
("rbhaf"	"$(0Z&(B")
("rbmr"	"$(1)B(B")
("rbou"	"$(1B((B")
("rbsmr"	"$(0EH(B")
("rbuc"	"$(1.=$(06`(B")
("rbwi"	"$(0[f(B")
("rcim"	"$(0EL(B")
("rckn"	"$(1B%(B")
("rcks"	"$(0@;(B")
("rcnl"	"$(1H0(B")
("rcsh"	"$(0+K(B")
("rcwa"	"$(1Ob(B")
("rdi"	"$(0)V(B")
("rdk"	"$(1#9(B")
("rdm"	"$(1%l(B")
("rdam"	"$(0@L(B")
("rddf"	"$(0R@(B")
("rdhqu"	"$(1]:(B")
("rdln"	"$(1O\$(0@I(B")
("rdlo"	"$(0J+(B")
("rdmq"	"$(1:`(B")
("rdnl"	"$(1[#(B")
("rdoo"	"$(14,(B")
("rede"	"$(13u(B")
("reed"	"$(0EB(B")
("reee"	"$(0;I(B")
("refh"	"$(1.4(B")
("reoy"	"$(0EA(B")
("rfb"	"$(06T(B")
("rfd"	"$(02B(B")
("rff"	"$(0;B(B")
("rfh"	"$(0+Q(B")
("rfba"	"$(0UH(B")
("rfbc"	"$(1Az(B")
("rfbw"	"$(0R>(B")
("rffs"	"$(0N1(B")
("rgb"	"$(1%e(B")
("rgg"	"$(02?(B")
("rgi"	"$(1%](B")
("rgr"	"$(1)?(B")
("rgbt"	"$(0N9(B")
("rgcc"	"$(0UJ(B")
("rggu"	"$(1Oc(B")
("rghaf"	"$(1nt(B")
("rgit"	"$(0EG(B")
("rgkc"	"$(1kT(B")
("rglc"	"$(1.8(B")
("rgnl"	"$(0:X(B")
("rgrr"	"$(0N2(B")
("rgsk"	"$(0J1(B")
("rgtj"	"$(14*(B")
("rgyo"	"$(1.6(B")
("rhg"	"$(0+H(B")
("rhp"	"$(0)^(B")
("rhq"	"$(1#A(B")
("rhr"	"$(0+I(B")
("rhs"	"$(0.T(B")
("rht"	"$(1#B(B")
("rhu"	"$(0't(B")
("rhad"	"$(1I<(B")
("rhaf"	"$(0Mx(B")
("rhag"	"$(1:Z(B")
("rhaj"	"$(0EO(B")
("rhbk"	"$(0RH(B")
("rhbu"	"$(02H(B")
("rhdf"	"$(0@U(B")
("rhdn"	"$(1.H(B")
("rher"	"$(02F(B")
("rhey"	"$(0.Q(B")
("rhfd"	"$(0.L(B")
("rhgr"	"$(1.G(B")
("rhhj"	"$(0;F(B")
("rhjd"	"$(1)E(B")
("rhjm"	"$(0@O(B")
("rhjr"	"$(1)G(B")
("rhjx"	"$(1:R(B")
("rhkb"	"$(1Oq(B")
("rhml"	"$(0+Y(B")
("rhmo"	"$(0RG(B")
("rhoa"	"$(1:Y(B")
("rhpm"	"$(1%o(B")
("rhqi"	"$(06d(B")
("rhrf"	"$(0EK(B")
("rhsk"	"$(0;L$(1VN(B")
("rhuc"	"$(1mI(B")
("rhuk"	"$(0EM(B")
("rhvo"	"$(0.N(B")
("rhxe"	"$(1B#(B")
("rhxu"	"$(14&(B")
("rik"	"$(0+S(B")
("rir"	"$(1%i(B")
("rice"	"$(06[(B")
("rihf"	"$(1I7(B")
("rihq"	"$(1)P(B")
("rihr"	"$(0@B(B")
("rihu"	"$(0+P(B")
("riil"	"$(1:P(B")
("rijb"	"$(06\(B")
("rijc"	"$(0J)(B")
("rikf"	"$(1:Q(B")
("riog"	"$(0X#(B")
("riok"	"$(06a(B")
("ritc"	"$(1aK(B")
("rite"	"$(1:N(B")
("riuh"	"$(1.:(B")
("rjd"	"$(0.A(B")
("rje"	"$(0+V(B")
("rji"	"$(0R^F*(B")
("rjr"	"$(0.E(B")
("rjal"	"$(0J3(B")
("rjbc"	"$(1Ax(B")
("rjbd"	"$(1.B(B")
("rjbf"	"$(0EC$(1\L(B")
("rjbj"	"$(0@K(B")
("rjbo"	"$(0UK(B")
("rjbv"	"$(1p~(B")
("rjca"	"$(1\R(B")
("rjhr"	"$(0@?(B")
("rjhaf"	"$(1ow(B")
("rjjb"	"$(0N4(B")
("rjji"	"$(0\f(B")
("rjkd"	"$(06b(B")
("rjkp"	"$(1)N(B")
("rjlo"	"$(13|(B")
("rjmm"	"$(0@@(B")
("rjmo"	"$(13v(B")
("rjmmv"	"$(1gJ(B")
("rjnl"	"$(1U$(B")
("rjon"	"$(1I6(B")
("rjpa"	"$(0EE(B")
("rjpn"	"$(0UG(B")
("rjpu"	"$(1I0(B")
("rjqr"	"$(1As(B")
("rjstv"	"$(1mH(B")
("rjtc"	"$(0N;(B")
("rka"	"$(1CJ(B")
("rki"	"$(1#8#;(B")
("rkn"	"$(02=(B")
("rkp"	"$(0F&(B")
("rks"	"$(0(>(7(B")
("rkbu"	"$(1L2(B")
("rkcf"	"$(0N3(B")
("rkkb"	"$(06h(B")
("rklb"	"$(1%m(B")
("rklu"	"$(14!(B")
("rkoo"	"$(1.C(B")
("rksb"	"$(1At(B")
("rksr"	"$(0.C(B")
("rlb"	"$(0)S(B")
("rlx"	"$(0N=(B")
("rlln"	"$(1%a(B")
("rlmc"	"$(1Ok(B")
("rlmo"	"$(1)D(B")
("rlmt"	"$(1\N(B")
("rlmy"	"$(0;>(B")
("rlwl"	"$(0.G(B")
("rlwv"	"$(0J/(B")
("rmc"	"$(05\(B")
("rmd"	"$(0)U(B")
("rmf"	"$(1#?(B")
("rmn"	"$(0(0(B")
("rmam"	"$(1)=(B")
("rmau"	"$(19_(B")
("rmav"	"$(0Hz(B")
("rmamh"	"$(1Zn(B")
("rmamo"	"$(1Zm(B")
("rmanw"	"$(1pV(B")
("rmaph"	"$(0Q;(B")
("rmasm"	"$(0WZ(B")
("rmbb"	"$(0UI(B")
("rmbc"	"$(1Au(B")
("rmbd"	"$(0Q=(B")
("rmbe"	"$(1aG(B")
("rmbm"	"$(1@_(B")
("rmbt"	"$(0DD(B")
("rmbhx"	"$(0W[(B")
("rmbue"	"$(1qz(B")
("rmbug"	"$(1qB(B")
("rmbvk"	"$(0W\(B")
("rmcw"	"$(02@$(1.7(B")
("rmcwa"	"$(1g>(B")
("rmdk"	"$(19](B")
("rmdm"	"$(1eA(B")
("rmdam"	"$(1Zl(B")
("rmdhe"	"$(0DG(B")
("rmea"	"$(0Q<(B")
("rmfb"	"$(1NG(B")
("rmfj"	"$(1%j(B")
("rmfm"	"$(0.D(B")
("rmfq"	"$(1@W(B")
("rmfbg"	"$(1cn(B")
("rmfcb"	"$(1_i(B")
("rmfdq"	"$(1g?(B")
("rmffe"	"$(1pS(B")
("rmfqu"	"$(0Q?(B")
("rmgg"	"$(1Gq4-(B")
("rmgt"	"$(1.5(B")
("rmgce"	"$(1Tn(B")
("rmgcg"	"$(1Td(B")
("rmgdi"	"$(1Gr(B")
("rmggu"	"$(0[,(B")
("rmgni"	"$(0]0(B")
("rmgyo"	"$(1NC(B")
("rmhdf"	"$(1Zr(B")
("rmhdv"	"$(1Tk(B")
("rmhdw"	"$(1gB(B")
("rmher"	"$(0H|(B")
("rmhgu"	"$(1Gv(B")
("rmhhw"	"$(1_h(B")
("rmhjd"	"$(0I#(B")
("rmhjg"	"$(0TQ(B")
("rmhkb"	"$(1gC(B")
("rmhlb"	"$(1Zo(B")
("rmhlc"	"$(0]y(B")
("rmhml"	"$(1Pj(B")
("rmhmy"	"$(1@b(B")
("rmhnd"	"$(0H~(B")
("rmhoo"	"$(0YH$(1cp(B")
("rmhqo"	"$(0DF(B")
("rmhsb"	"$(1Zp(B")
("rmhsk"	"$(1j((B")
("rmhuc"	"$(1qa(B")
("rmig"	"$(1)@(B")
("rmii"	"$(0Q9(B")
("rmir"	"$(0DH(B")
("rmiav"	"$(1NA(B")
("rmice"	"$(1NI(B")
("rmigi"	"$(1n.(B")
("rmikk"	"$(0DC(B")
("rmite"	"$(0TM(B")
("rmitf"	"$(1cg(B")
("rmiwg"	"$(1n/(B")
("rmixp"	"$(1ch(B")
("rmiyr"	"$(1Tb(B")
("rmje"	"$(19\(B")
("rmjk"	"$(1Of(B")
("rmjp"	"$(0DA(B")
("rmjr"	"$(1@Y(B")
("rmjbc"	"$(1_f(B")
("rmjcv"	"$(1q@(B")
("rmjkd"	"$(1ND(B")
("rmjlo"	"$(1Tc(B")
("rmjnu"	"$(1T^(B")
("rmjoa"	"$(1ce(B")
("rmkn"	"$(1Gp(B")
("rmkmr"	"$(1Th(B")
("rmkms"	"$(0H{(B")
("rmkpb"	"$(1cm(B")
("rmksr"	"$(1@](B")
("rmlb"	"$(13}(B")
("rmlk"	"$(06g(B")
("rmlm"	"$(0;=(B")
("rmlmc"	"$(1gA(B")
("rmlmo"	"$(0H}(B")
("rmlwp"	"$(1Gu(B")
("rmmd"	"$(13,(B")
("rmmp"	"$(1Od(B")
("rmmr"	"$(06]$(1@[(B")
("rmmt"	"$(19[(B")
("rmmcw"	"$(1G{(B")
("rmmfb"	"$(1lE(B")
("rmmig"	"$(1Gs(B")
("rmmrw"	"$(1Zi(B")
("rmmto"	"$(0[*(B")
("rmnn"	"$(02K(B")
("rmnr"	"$(0.B(B")
("rmnbs"	"$(0TN(B")
("rmnhd"	"$(0TO(B")
("rmnhe"	"$(19^(B")
("rmnib"	"$(1NF(B")
("rmnin"	"$(1Gw(B")
("rmnmu"	"$(0I!(B")
("rmnoe"	"$(1g@(B")
("rmnot"	"$(0[+(B")
("rmog"	"$(1Tm(B")
("rmon"	"$(13+(B")
("rmodi"	"$(1@a(B")
("rmohh"	"$(1@`(B")
("rmoip"	"$(1To(B")
("rmoir"	"$(1_j(B")
("rmokr"	"$(0Q>(B")
("rmomb"	"$(1Tp(B")
("rmomg"	"$(1Gx(B")
("rmomn"	"$(1Zq(B")
("rmomr"	"$(1Gy(B")
("rmotq"	"$(1lF(B")
("rmowy"	"$(1NH(B")
("rmpi"	"$(13*(B")
("rmpt"	"$(1@Z(B")
("rmpfd"	"$(1Tl(B")
("rmpmc"	"$(1cj(B")
("rmpru"	"$(0DE(B")
("rmptd"	"$(1Zk(B")
("rmqo"	"$(0?S(B")
("rmqka"	"$(1Zh(B")
("rmqkx"	"$(1ci(B")
("rmqmc"	"$(0YI(B")
("rmrb"	"$(1Av(B")
("rmrrd"	"$(0\H(B")
("rmryo"	"$(1NL(B")
("rmso"	"$(0;<(B")
("rmsp"	"$(1@\(B")
("rmss"	"$(0DB(B")
("rmsu"	"$(0+F(B")
("rmsje"	"$(1Tg(B")
("rmsjj"	"$(0_*(B")
("rmsjr"	"$(0Q@(B")
("rmsju"	"$(1NB(B")
("rmsmg"	"$(0]1(B")
("rmssr"	"$(0M:(B")
("rmstv"	"$(1_g(B")
("rmsup"	"$(1NE(B")
("rmta"	"$(1Te(B")
("rmto"	"$(1Oh(B")
("rmtt"	"$(1Go(B")
("rmtag"	"$(0_<(B")
("rmtce"	"$(1r/(B")
("rmtco"	"$(0['(B")
("rmtja"	"$(0[)(B")
("rmtkl"	"$(0]x(B")
("rmtlb"	"$(0YF(B")
("rmtmc"	"$(1Tf(B")
("rmtmv"	"$(1Zj(B")
("rmtqa"	"$(1qA(B")
("rmtqm"	"$(0WY(B")
("rmttc"	"$(0Q8(B")
("rmtwa"	"$(1cl(B")
("rmtwi"	"$(0[((B")
("rmua"	"$(1Og(B")
("rmue"	"$(1Ay(B")
("rmui"	"$(0J0(B")
("rmubb"	"$(0YG(B")
("rmumb"	"$(0TP(B")
("rmvh"	"$(0+U(B")
("rmvi"	"$(1B!(B")
("rmvid"	"$(1n1(B")
("rmvim"	"$(1n3(B")
("rmvmi"	"$(1co(B")
("rmvvv"	"$(1n2(B")
("rmwd"	"$(0Q:(B")
("rmwf"	"$(1I2(B")
("rmwg"	"$(0@T(B")
("rmwj"	"$(1On(B")
("rmwl"	"$(1:_(B")
("rmwv"	"$(1:S(B")
("rmwli"	"$(0\I(B")
("rmwtj"	"$(0YJ(B")
("rmyf"	"$(1I1(B")
("rmyg"	"$(1@X(B")
("rmyr"	"$(1@^(B")
("rmyx"	"$(0]2(B")
("rmyaj"	"$(1Tj(B")
("rmybb"	"$(0TL(B")
("rmybp"	"$(1oV(B")
("rmycb"	"$(1cf(B")
("rmyck"	"$(0I"(B")
("rmyfe"	"$(1Ti(B")
("rmyfu"	"$(0[-(B")
("rmygq"	"$(0\J(B")
("rmyjj"	"$(1ck(B")
("rmylc"	"$(0Hy(B")
("rmylh"	"$(1NM(B")
("rmylm"	"$(0?R(B")
("rmymp"	"$(1Gt(B")
("rmymu"	"$(1n0(B")
("rmyoj"	"$(1Ta(B")
("rmypo"	"$(1j'(B")
("rmyrv"	"$(1pT(B")
("rmytr"	"$(1T_(B")
("rmytv"	"$(1T`(B")
("rnd"	"$(1"&(B")
("rng"	"$(1#>(B")
("rno"	"$(0+M(B")
("rnbg"	"$(1.I(B")
("rnbj"	"$(1I;(B")
("rnbk"	"$(0@Q(B")
("rndu"	"$(0+T(B")
("rnhb"	"$(1Oe(B")
("rnhe"	"$(0+O(B")
("rnhx"	"$(0;N(B")
("rnin"	"$(1)I(B")
("rnkm"	"$(14%(B")
("rnlr"	"$(0;@(B")
("rnri"	"$(1hn(B")
("rnwa"	"$(0X<(B")
("rob"	"$(0+R(B")
("rod"	"$(02I(B")
("rog"	"$(0;E(B")
("roj"	"$(1#@(B")
("ron"	"$(0)[(B")
("rop"	"$(1#:(B")
("roq"	"$(1)F(B")
("rodi"	"$(0.M(B")
("roic"	"$(1I=(B")
("roii"	"$(1%p(B")
("roin"	"$(0+X(B")
("roip"	"$(0;G(B")
("roir"	"$(0EN$(1.A(B")
("roll"	"$(1#E(B")
("roma"	"$(1VO(B")
("romd"	"$(1.J(B")
("roml"	"$(0;K(B")
("romn"	"$(0@R(B")
("romo"	"$(1VP(B")
("romr"	"$(14'$(02E(B")
("romt"	"$(1:[(B")
("ronk"	"$(0@V(B")
("roog"	"$(1.@(B")
("rosk"	"$(02L(B")
("rotf"	"$(1Oo(B")
("royb"	"$(0R<(B")
("rpa"	"$(1)Q(B")
("rph"	"$(1%\(B")
("rpr"	"$(1%g(B")
("rpu"	"$(1#D(B")
("rphh"	"$(0+N(B")
("rpim"	"$(1#C(B")
("rpln"	"$(1#0(B")
("rpok"	"$(1*j(B")
("rpou"	"$(0;D(B")
("rppa"	"$(1:T(B")
("rpru"	"$(0.K(B")
("rptd"	"$(0@J(B")
("rpuc"	"$(0RA(B")
("rpuk"	"$(1)H(B")
("rqha"	"$(0;:(B")
("rqhk"	"$(0@W(B")
("rqhl"	"$(1.9(B")
("rqhu"	"$(1p5(B")
("rqjm"	"$(1I3(B")
("rqkq"	"$(13{(B")
("rqmc"	"$(0J2(B")
("rqmf"	"$(0EP(B")
("rqmn"	"$(1%_(B")
("rqyt"	"$(0;;(B")
("rrf"	"$(1:X(B")
("rrr"	"$(02C(B")
("rrau"	"$(1.>(B")
("rrbyj"	"$(1<A(B")
("rrhn"	"$(0.J(B")
("rrhaf"	"$(0^{(B")
("rrik"	"$(06_ZK(B")
("rrikr"	"$(0RC(B")
("rrill"	"$(1:\(B")
("rrms"	"$(1%c(B")
("rrmcr"	"$(0\g(B")
("rrmmk"	"$(0[e(B")
("rrmms"	"$(1)M(B")
("rrnl"	"$(13>(B")
("rrrd"	"$(0RB$(1A{(B")
("rrrj"	"$(1Ol(B")
("rrrr"	"$(1L<(B")
("rrru"	"$(1:];K(B")
("rrslr"	"$(1aJ(B")
("rruc"	"$(1Oj(B")
("rrvp"	"$(1%k(B")
("rrvlr"	"$(1I9(B")
("rrwj"	"$(0@M(B")
("rrwmu"	"$(1qV(B")
("rryo"	"$(1.?(B")
("rsh"	"$(0(2(B")
("rsj"	"$(1)>)J(B")
("rsl"	"$(0(1(B")
("rsm"	"$(0(3(B")
("rso"	"$(0+C(B")
("rsp"	"$(0.R(B")
("rsbn"	"$(14"(B")
("rshaf"	"$(1k6\2(B")
("rsit"	"$(1\S(B")
("rsjj"	"$(0\e(B")
("rslb"	"$(1%`(B")
("rsln"	"$(0+2(B")
("rsme"	"$(1.;(B")
("rsmg"	"$(0@H$(1\U(B")
("rsmh"	"$(0J5(B")
("rsmi"	"$(1Oi(B")
("rsmj"	"$(1\T(B")
("rsmbc"	"$(0Yp(B")
("rsnl"	"$(0DS(B")
("rsqf"	"$(0ED(B")
("rsql"	"$(06c(B")
("rsrr"	"$(0J,(B")
("rsuu"	"$(14#(B")
("rsyi"	"$(0^^(B")
("rsypu"	"$(0HA(B")
("rta"	"$(13~(B")
("rtc"	"$(02D(B")
("rtk"	"$(02:(B")
("rtm"	"$(1%^(B")
("rtq"	"$(02J(B")
("rtw"	"$(1:V(B")
("rtak"	"$(1I4(B")
("rtav"	"$(0RI(B")
("rtcl"	"$(0N<(B")
("rtco"	"$(0N:(B")
("rtct"	"$(1Ar(B")
("rtgi"	"$(0]Z(B")
("rtgu"	"$(13z(B")
("rtkr"	"$(1:U(B")
("rtlf"	"$(0Z-(B")
("rtlo"	"$(0J-(B")
("rtmc"	"$(14+(B")
("rtmj"	"$(0N7(B")
("rtmv"	"$(1:^(B")
("rtnd"	"$(0^5(B")
("rtod"	"$(1A~(B")
("rtoe"	"$(1\P(B")
("rtor"	"$(1A|(B")
("rtqm"	"$(0E@(B")
("rtrg"	"$(1kU(B")
("rtub"	"$(1B&(B")
("rtwa"	"$(0J4(B")
("rtwi"	"$(1OamG(B")
("rtwv"	"$(0RD(B")
("rtxc"	"$(1Aq(B")
("rtyb"	"$(1\O(B")
("ruu"	"$(0.I(B")
("rumb"	"$(0@D(B")
("rumi"	"$(0EI(B")
("runl"	"$(1["(B")
("ruog"	"$(1I:(B")
("ruoiv"	"$(0^&(B")
("rutc"	"$(0@y(B")
("rve"	"$(0.O(B")
("rvi"	"$(0)](B")
("rvl"	"$(0(6(B")
("rvp"	"$(0(b(B")
("rvfi"	"$(0@P(B")
("rvii"	"$(0N>(B")
("rvis"	"$(1%h(B")
("rvnk"	"$(0+G(B")
("rvno"	"$(0@X(B")
("rvvu"	"$(1B$(B")
("rwb"	"$(0@N(B")
("rwc"	"$(1%f(B")
("rwg"	"$(06^(B")
("rwk"	"$(02A(B")
("rwl"	"$(0.H(B")
("rwgf"	"$(0N5(B")
("rwgg"	"$(1aH(B")
("rwim"	"$(1I8(B")
("rwkp"	"$(0EJ(B")
("rwlb"	"$(1:W(B")
("rwlc"	"$(1Op(B")
("rwlg"	"$(0]\(B")
("rwli"	"$(1VM(B")
("rwlv"	"$(1VJ(B")
("rwmv"	"$(0@E(B")
("rwnl"	"$(0MI(B")
("rwot"	"$(1B"(B")
("rwtj"	"$(0J6(B")
("rwyi"	"$(1%n(B")
("rxu"	"$(1Hw(B")
("ryk"	"$(1#<(B")
("ryo"	"$(0-N(B")
("ryr"	"$(1%b(B")
("ryx"	"$(1\M(B")
("ryaj"	"$(14$(B")
("ryao"	"$(1VQ(B")
("rybb"	"$(0@A(B")
("rybp"	"$(0[b(B")
("rybs"	"$(1B'(B")
("rycb"	"$(0J((B")
("ryck"	"$(027(B")
("rydg"	"$(1kS(B")
("rydu"	"$(1e?(B")
("ryfu"	"$(1O`(B")
("rygq"	"$(1VI(B")
("ryhc"	"$(1eD(B")
("ryhh"	"$(1:O(B")
("ryhn"	"$(0+?(B")
("ryib"	"$(06W(B")
("ryjj"	"$(1I>(B")
("rymb"	"$(0;?(B")
("rymh"	"$(1VL(B")
("rymp"	"$(1)O(B")
("rymr"	"$(06V(B")
("rymu"	"$(1aL(B")
("ryoj"	"$(13y(B")
("rypb"	"$(0N6(B")
("rypd"	"$(1A}(B")
("rypk"	"$(1VK(B")
("rypm"	"$(0N8(B")
("rypo"	"$(0RE(B")
("rypt"	"$(1eB(B")
("rypu"	"$(0;J(B")
("ryrb"	"$(1Ap(B")
("ryrd"	"$(13x(B")
("ryrn"	"$(06X(B")
("ryro"	"$(0UF(B")
("ryru"	"$(1:M(B")
("ryrv"	"$(0[c(B")
("rysk"	"$(0J'(B")
("rysy"	"$(14)(B")
("ryta"	"$(1:L(B")
("rytp"	"$(0R=(B")
("rytv"	"$(13w(B")
("ryvg"	"$(1VH(B")
("ryvo"	"$(02>(B")
("rywe"	"$(1\Q(B")
("s"	"$(0&T(B")
("sc"	"$(0')(B")
("se"	"$(0,"(B")
("sh"	"$(0&/(B")
("sj"	"$(0*W(B")
("sk"	"$(0&h(B")
("sm"	"$(0&0(B")
("so"	"$(0':(B")
("sp"	"$(0(H(B")
("sr"	"$(0(5(B")
("ss"	"$(0(I(B")
("su"	"$(0&X&Y(B")
("sw"	"$(1&<(B")
("sav"	"$(1)7(B")
("sahaf"	"$(1ns(B")
("sahni"	"$(1ja(B")
("sammu"	"$(1S"(B")
("sbcc"	"$(1p8(B")
("sbhg"	"$(1Jd(B")
("sbln"	"$(0..(B")
("sbug"	"$(1hl(B")
("schaf"	"$(1V;(B")
("schne"	"$(0F\(B")
("scwa"	"$(0NR(B")
("seb"	"$(0CNW#(B")
("sec"	"$(1[P(B")
("sed"	"$(1<j(B")
("sef"	"$(1=d(B")
("seg"	"$(1VY$(0;S(B")
("seq"	"$(1;w(B")
("sev"	"$(1I_$(0;_$(14r(B")
("sebuc"	"$(0Q0$(1cd(B")
("sehaf"	"$(1nr(B")
("selmi"	"$(1My(B")
("semr"	"$(1EZ(B")
("semcw"	"$(0YQ(B")
("semgi"	"$(1XN(B")
("semoo"	"$(1av(B")
("semrt"	"$(0Q((B")
("seog"	"$(0E?(B")
("seooo"	"$(0LN(B")
("sesmm"	"$(0Vv(B")
("sevif"	"$(0L<$(1^L(B")
("sewgf"	"$(1p)(B")
("sfa"	"$(1O>(B")
("sfb"	"$(07.(B")
("sfd"	"$(02n(B")
("sfe"	"$(0E'(B")
("sfk"	"$(0Ik(B")
("sfl"	"$(1OB(B")
("sft"	"$(1Ho(B")
("sfajv"	"$(1jj(B")
("sfamj"	"$(1`l(B")
("sfamo"	"$(1h*(B")
("sfapp"	"$(1d^(B")
("sfapv"	"$(1h/(B")
("sfbm"	"$(1Ut(B")
("sfbr"	"$(1Uv(B")
("sfbbr"	"$(1h+(B")
("sfbgr"	"$(1de(B")
("sfbmr"	"$(1[u(B")
("sfbvk"	"$(1jk(B")
("sfcru"	"$(1`n(B")
("sfcwa"	"$(1nJ(B")
("sfdi"	"$(0;q(B")
("sfdk"	"$(1O=(B")
("sfdl"	"$(1`h(B")
("sfdoo"	"$(1d](B")
("sfeii"	"$(0\X(B")
("sffdq"	"$(1nI(B")
("sfggu"	"$(0^((B")
("sfhi"	"$(1jo(B")
("sfhp"	"$(1Hm(B")
("sfhag"	"$(1h.(B")
("sfhdp"	"$(1jl(B")
("sfher"	"$(0U0(B")
("sfhgu"	"$(1[s(B")
("sfhhw"	"$(1jp(B")
("sfhkb"	"$(0^'(B")
("sfhni"	"$(1gx(B")
("sfhsb"	"$(0[R(B")
("sfhsm"	"$(1jq(B")
("sfhwp"	"$(1lk(B")
("sfhxe"	"$(1jm(B")
("sfij"	"$(1[o(B")
("sfir"	"$(1Ux(B")
("sfit"	"$(1`g(B")
("sfiav"	"$(1`f(B")
("sfice"	"$(0X,(B")
("sfihu"	"$(1O?(B")
("sfiih"	"$(1ll(B")
("sfiok"	"$(1`p(B")
("sfiuh"	"$(1`i(B")
("sfjp"	"$(0Qw(B")
("sfjig"	"$(1ob(B")
("sfjmc"	"$(1pc(B")
("sfkk"	"$(0Mr(B")
("sfkmr"	"$(0Yx(B")
("sflk"	"$(0Qz(B")
("sflw"	"$(1Uu(B")
("sflx"	"$(1nL(B")
("sflll"	"$(0Il(B")
("sflmo"	"$(1[r(B")
("sflmy"	"$(1da(B")
("sflpc"	"$(0_9(B")
("sflws"	"$(0X+(B")
("sfmj"	"$(1Hl(B")
("sfmbu"	"$(1r%(B")
("sfmfj"	"$(1Uq(B")
("sfmfm"	"$(1Us(B")
("sfmhf"	"$(0\Y(B")
("sfmig"	"$(1[p(B")
("sfmmp"	"$(0_H(B")
("sfmwf"	"$(0]F(B")
("sfmwj"	"$(1nK(B")
("sfmwv"	"$(1h$(B")
("sfnhb"	"$(1nN(B")
("sfnhd"	"$(1h%(B")
("sfnhe"	"$(1O@(B")
("sfnkq"	"$(1h&(B")
("sfnok"	"$(1h'(B")
("sfnoo"	"$(1h((B")
("sfog"	"$(1dc(B")
("sfok"	"$(1OC(B")
("sfodi"	"$(0Q~(B")
("sfohh"	"$(1Uz(B")
("sfoii"	"$(1Uw(B")
("sfomd"	"$(1`o(B")
("sfomg"	"$(1[t(B")
("sfomo"	"$(0^T(B")
("sfomr"	"$(1dd(B")
("sfpd"	"$(0Ij(B")
("sfph"	"$(1Up(B")
("sfpi"	"$(1Hn(B")
("sfpr"	"$(0Q}(B")
("sfpou"	"$(1db(B")
("sfpuu"	"$(1jn(B")
("sfqjr"	"$(1h-(B")
("sfrb"	"$(1`m(B")
("sfrrj"	"$(1nQ(B")
("sfrye"	"$(1h)(B")
("sfsj"	"$(1[n(B")
("sfss"	"$(1Ur(B")
("sfseo"	"$(0^v(B")
("sfsff"	"$(1r>(B")
("sfshr"	"$(1Uy(B")
("sfsma"	"$(1li(B")
("sfsme"	"$(1`j(B")
("sfsnd"	"$(1nM(B")
("sfsrr"	"$(0]E(B")
("sfssr"	"$(1`k(B")
("sftt"	"$(0U/(B")
("sftaj"	"$(1ji(B")
("sftbn"	"$(1h#(B")
("sftjd"	"$(1r&(B")
("sftlf"	"$(1qg(B")
("sftlm"	"$(1lh(B")
("sftmc"	"$(1d\(B")
("sftmj"	"$(1nO(B")
("sftrg"	"$(1r3(B")
("sfuce"	"$(1h,(B")
("sfuob"	"$(1r4(B")
("sfvne"	"$(1d`(B")
("sfwc"	"$(0Qy(B")
("sfwd"	"$(1d_(B")
("sfwk"	"$(1[q(B")
("sfwlj"	"$(0^S(B")
("sfwtj"	"$(1lj(B")
("sfwvf"	"$(0]H(B")
("sfyg"	"$(0Qx(B")
("sfyck"	"$(1[m(B")
("sfydk"	"$(1nR(B")
("sfyhv"	"$(1ZB(B")
("sfypm"	"$(1nP(B")
("sfypt"	"$(0_8(B")
("sfyrv"	"$(1r$(B")
("sfytj"	"$(1`elo(B")
("sfyvo"	"$(0U.(B")
("sfywm"	"$(1oc(B")
("sgi"	"$(0XC(B")
("sghaf"	"$(1qP(B")
("sgjwp"	"$(0]p(B")
("sgks"	"$(0.5(B")
("sgln"	"$(13n(B")
("shi"	"$(0Nv&D(B")
("shr"	"$(0(/(B")
("shaf"	"$(1OM(B")
("shaph"	"$(1di(B")
("shawe"	"$(1ls(B")
("shbb"	"$(1dj(B")
("shbt"	"$(1VF(B")
("shcwa"	"$(1nT(B")
("shdbn"	"$(1h3(B")
("shdci"	"$(0Y{(B")
("shdhe"	"$(1V"(B")
("shfb"	"$(1`r(B")
("shfqu"	"$(1dh(B")
("shgb"	"$(0R#(B")
("shgr"	"$(0U3(B")
("shhaf"	"$(1Htni(B")
("shhdn"	"$(1`t(B")
("shhej"	"$(1`u(B")
("shhhc"	"$(0^*(B")
("shhjr"	"$(1[{(B")
("shhqu"	"$(0Mu(B")
("shiih"	"$(1lt(B")
("shikk"	"$(0R"(B")
("shjbc"	"$(1jw(B")
("shjmc"	"$(0^w(B")
("shjmf"	"$(0Yz(B")
("shjpa"	"$(1jv(B")
("shjrb"	"$(0[S(B")
("shkmb"	"$(1h4(B")
("shlbu"	"$(1OF(B")
("shml"	"$(0)M(B")
("shmu"	"$(0Im(B")
("shmbc"	"$(1j`(B")
("shmfm"	"$(1U}(B")
("shnl"	"$(1NW(B")
("shnih"	"$(1V!(B")
("shob"	"$(1aO(B")
("shod"	"$(1[|P,(B")
("shoe"	"$(0NS70(B")
("shog"	"$(1gh(B")
("shoo"	"$(1Ii(B")
("shot"	"$(0;u(B")
("shov"	"$(0UU(B")
("shoma"	"$(1of(B")
("shoog"	"$(1`s(B")
("shpru"	"$(1V#(B")
("shqu"	"$(0,#(B")
("shqka"	"$(1h2(B")
("shsb"	"$(0;6(B")
("shsj"	"$(1[z(B")
("shshr"	"$(1U~(B")
("shtw"	"$(1[}(B")
("shtak"	"$(1lq(B")
("shtbn"	"$(1h1(B")
("shtlb"	"$(1lr(B")
("shtwv"	"$(1od(B")
("shtxc"	"$(1jx(B")
("shvvv"	"$(0_1(B")
("shwlv"	"$(1oe(B")
("shyhs"	"$(1OE(B")
("shymp"	"$(0U4(B")
("shyrv"	"$(1r'(B")
("sif"	"$(0Oa(B")
("sip"	"$(0Nj,7(B")
("sibt"	"$(0Kr(B")
("sihk"	"$(1:*(B")
("sihq"	"$(1Q~(B")
("sihhh"	"$(13M(B")
("sihml"	"$(1q"(B")
("sihqo"	"$(1A@(B")
("sikcf"	"$(1ge(B")
("silq"	"$(0G~(B")
("sinl"	"$(1U"(B")
("sisuu"	"$(1UO(B")
("siyhv"	"$(0WE(B")
("sjb"	"$(0W"(B")
("sjc"	"$(1&;(B")
("sjd"	"$(0Uz(B")
("sje"	"$(0.>(B")
("sjf"	"$(09Z(B")
("sjg"	"$(0RJ(B")
("sjp"	"$(07F$(1\l(B")
("sjq"	"$(0Uf(B")
("sjr"	"$(0/#(B")
("sju"	"$(1$t(B")
("sjv"	"$(1Vc(B")
("sjcim"	"$(1YS(B")
("sjenl"	"$(19o(B")
("sjfd"	"$(1f<(B")
("sjgb"	"$(18H(B")
("sjgr"	"$(1?.(B")
("sjhaf"	"$(1pu(B")
("sjhhl"	"$(0>g(B")
("sjhjr"	"$(0CH(B")
("sjhqu"	"$(10"(B")
("sjhwp"	"$(0Vz(B")
("sjirm"	"$(1M+(B")
("sjjn"	"$(13s(B")
("sjjcm"	"$(1M,(B")
("sjjpn"	"$(1i`(B")
("sjka"	"$(0;t(B")
("sjkf"	"$(1aP(B")
("sjki"	"$(12,(B")
("sjlb"	"$(1Vx(B")
("sjln"	"$(1%Q(B")
("sjlbu"	"$(09Y(B")
("sjlmc"	"$(1bj(B")
("sjlws"	"$(0G}(B")
("sjmn"	"$(1(K(B")
("sjmbc"	"$(1q}(B")
("sjmbl"	"$(1?-(B")
("sjmgi"	"$(0Xf(B")
("sjmvn"	"$(1b7(B")
("sjmym"	"$(18G(B")
("sjnl"	"$(05((B")
("sjncr"	"$(1fN(B")
("sjnok"	"$(1S((B")
("sjoii"	"$(0>h(B")
("sjoin"	"$(12-(B")
("sjrxu"	"$(1qo(B")
("sjryo"	"$(1j)(B")
("sjsh"	"$(0N+(B")
("sjsj"	"$(1?,(B")
("sjsjj"	"$(0Y+(B")
("sjvif"	"$(1fE(B")
("sjvis"	"$(18I(B")
("sjvit"	"$(0V{(B")
("sjyhv"	"$(0Zy(B")
("sjyia"	"$(0Y*(B")
("sjymr"	"$(0\@(B")
("sjyrn"	"$(1S'(B")
("skn"	"$(1!V(B")
("skr"	"$(0+J(B")
("slb"	"$(0(#(B")
("slo"	"$(01;(B")
("slmc"	"$(0J%(B")
("slmy"	"$(0;v6O(B")
("slmbc"	"$(0U'(B")
("slorr"	"$(0W((B")
("slqmc"	"$(1ca(B")
("slsl"	"$(0*\(B")
("slsll"	"$(1?9(B")
("slwv"	"$(0JY(B")
("smg"	"$(0)L(B")
("sml"	"$(12*(B")
("smm"	"$(1,r(B")
("smr"	"$(0(4(B")
("smt"	"$(05#(B")
("smv"	"$(01\(B")
("smamo"	"$(1S&(B")
("smbjj"	"$(1S$(B")
("smblb"	"$(0/-(B")
("smcsh"	"$(12)(B")
("smdhe"	"$(18>(B")
("smha"	"$(0>e(B")
("smhaf"	"$(1a5(B")
("smhqo"	"$(18?(B")
("smhqu"	"$(10%(B")
("smig"	"$(02q(B")
("smikk"	"$(18A(B")
("smkoo"	"$(1F9(B")
("smmbc"	"$(1Ud(B")
("smmri"	"$(0@s(B")
("smnp"	"$(02p(B")
("smog"	"$(0LL(B")
("smohh"	"$(18B(B")
("smonk"	"$(1S!(B")
("smpr"	"$(18@(B")
("smsim"	"$(0*R(B")
("smuce"	"$(1S#(B")
("smwtc"	"$(0Vw(B")
("smyt"	"$(0>c$(18=(B")
("smyjj"	"$(1^R(B")
("smyoj"	"$(0LJ(B")
("smyrb"	"$(1YP(B")
("smyrf"	"$(1M)(B")
("smytv"	"$(1M'(B")
("sndd"	"$(0@m(B")
("snlr"	"$(14w(B")
("somr"	"$(1%Y(B")
("sonl"	"$(0Wh(B")
("sorc"	"$(02G(B")
("spd"	"$(1!M(B")
("spp"	"$(0,!(B")
("sphh"	"$(1""(B")
("sphaf"	"$(1e#(B")
("sqnl"	"$(0-\(B")
("sqsf"	"$(0:l(B")
("srf"	"$(16s(B")
("srp"	"$(0Nf(B")
("srbt"	"$(1bA(B")
("srbuu"	"$(1@9(B")
("srhg"	"$(0G|(B")
("srhaf"	"$(1hP$(0^0$(1e+(B")
("srhne"	"$(0OH(B")
("srks"	"$(1#1(B")
("srlb"	"$(1)z(B")
("srmbc"	"$(1[e(B")
("srmvn"	"$(0SI(B")
("srnl"	"$(01V:V(B")
("srno"	"$(0OD(B")
("srrj"	"$(1I.(B")
("srrr"	"$(0;5(B")
("srsl"	"$(1#5(B")
("srtq"	"$(0G{(B")
("srye"	"$(1Pg(B")
("srytj"	"$(0I)(B")
("ssf"	"$(1XD(B")
("ssr"	"$(0+~(B")
("ssu"	"$(0'x(B")
("sskll"	"$(1^\(B")
("sslii"	"$(1_9(B")
("stt"	"$(02o(B")
("stv"	"$(07/(B")
("stkr"	"$(0;4(B")
("stqq"	"$(0]!(B")
("suf"	"$(0K[(B")
("sug"	"$(0/$(B")
("sup"	"$(0,5(B")
("sut"	"$(1">(B")
("suu"	"$(0/"(B")
("suv"	"$(1BN"-(B")
("suhu"	"$(0.%(B")
("suhaf"	"$(1hQ(B")
("sund"	"$(07$(B")
("sunl"	"$(1"u(B")
("suok"	"$(0,R(B")
("svhaf"	"$(1k0(B")
("svnl"	"$(0DV(B")
("swc"	"$(0]~(B")
("swl"	"$(0+;(B")
("swbt"	"$(0^}(B")
("swbuu"	"$(0]+(B")
("syhn"	"$(1"#(B")
("sytj"	"$(1.m(B")
("syyi"	"$(0\i(B")
("syyq"	"$(0BY(B")
("t"	"$(0'>(B")
("ta"	"$(0/x(B")
("tc"	"$(0)B$(1?e(B")
("tf"	"$(1(c(B")
("tg"	"$(1${(B")
("tj"	"$(0',(B")
("tk"	"$(0*e(B")
("tm"	"$(0(m(B")
("tn"	"$(1$}(B")
("tp"	"$(01H(B")
("tq"	"$(0*Q(B")
("tt"	"$(0*!&k$(1!N(B")
("tw"	"$(05B*3(B")
("taa"	"$(1?\(B")
("tab"	"$(0Ce(B")
("taj"	"$(09x(B")
("tak"	"$(0>|(B")
("tan"	"$(1?t(B")
("tau"	"$(01A(B")
("tav"	"$(12F(B")
("tabu"	"$(1Fg(B")
("tadhe"	"$(1E>(B")
("tagi"	"$(1MK(B")
("tahs"	"$(1Fj(B")
("tahaf"	"$(0[Z(B")
("tahml"	"$(1<C(B")
("taiu"	"$(1Fd(B")
("taka"	"$(0O1(B")
("takb"	"$(0J^(B")
("takf"	"$(0]G(B")
("takg"	"$(0J<(B")
("takp"	"$(0Ng(B")
("takq"	"$(0Ny(B")
("taks"	"$(0E:(B")
("taln"	"$(1.,(B")
("tanb"	"$(1Yq(B")
("tang"	"$(0\5(B")
("tanp"	"$(1Yp(B")
("tanw"	"$(0]#(B")
("tapp"	"$(1?[(B")
("tapv"	"$(0H7(B")
("tase"	"$(0T*(B")
("tawe"	"$(0PX(B")
("tbc"	"$(0.)(B")
("tbd"	"$(1J|$(0Cm(B")
("tbg"	"$(0ET(B")
("tbm"	"$(1-9(B")
("tbp"	"$(1J+(B")
("tbu"	"$(05E(B")
("tbv"	"$(18m(B")
("tbac"	"$(1M;(B")
("tbau"	"$(1?_(B")
("tbbb"	"$(1ML(B")
("tbbe"	"$(1^u(B")
("tbbq"	"$(1Ys(B")
("tbbr"	"$(0H9(B")
("tbbu"	"$(1^v(B")
("tbbuu"	"$(1_H(B")
("tbcn"	"$(1Fh(B")
("tbcv"	"$(1l+(B")
("tbcsh"	"$(1\B(B")
("tbfe"	"$(0Zn(B")
("tbhg"	"$(1c"(B")
("tbhs"	"$(1G%(B")
("tbhu"	"$(0Y2(B")
("tbijb"	"$(1hd(B")
("tbikk"	"$(1a=(B")
("tbjj"	"$(0H/(B")
("tbks"	"$(1O^(B")
("tbli"	"$(0Z`(B")
("tbln"	"$(02*$(1MP(B")
("tbme"	"$(1Fl(B")
("tbmo"	"$(0La(B")
("tbmr"	"$(12I(B")
("tbms"	"$(18|(B")
("tbmw"	"$(1FU(B")
("tbmbc"	"$(1gtj^(B")
("tbnd"	"$(18l(B")
("tbnf"	"$(0Fu(B")
("tbnh"	"$(0;+(B")
("tbni"	"$(1M<(B")
("tbnm"	"$(1S%(B")
("tbof"	"$(0P[(B")
("tbok"	"$(0AX(B")
("tbpr"	"$(1Fp(B")
("tbse"	"$(0Co(B")
("tbtv"	"$(1?](B")
("tbud"	"$(1SV(B")
("tbuk"	"$(1b}(B")
("tbul"	"$(1^o(B")
("tbut"	"$(1?s(B")
("tbuu"	"$(0?((B")
("tbyj"	"$(1J^(B")
("tca"	"$(0A\(B")
("tcb"	"$(0Ag(B")
("tcg"	"$(0;X(B")
("tcp"	"$(07I$(1;b(B")
("tcq"	"$(1/4(B")
("tcbt"	"$(08v(B")
("tcfb"	"$(1AV(B")
("tche"	"$(0\h(B")
("tchaf"	"$(1p!m$(B")
("tchml"	"$(0A[(B")
("tcim"	"$(0Ll(B")
("tcjwj"	"$(1H%(B")
("tclmi"	"$(1@"(B")
("tcmr"	"$(1rG(B")
("tcno"	"$(0B#K:(B")
("tcru"	"$(18o$(02t(B")
("tcsd"	"$(0B!(B")
("tcsh"	"$(01F(B")
("tcst"	"$(1G*(B")
("tctd"	"$(0FG(B")
("tcte"	"$(0X;(B")
("tcvif"	"$(1L~(B")
("tcwm"	"$(05l(B")
("tcyg"	"$(1a;(B")
("tcyj"	"$(1W=(B")
("tcymr"	"$(1TJ(B")
("tdb"	"$(12A(B")
("tdd"	"$(1?p(B")
("tdj"	"$(05@(B")
("tdk"	"$(1(Y(B")
("tdm"	"$(05K(B")
("tdr"	"$(18h(B")
("tdw"	"$(1?o(B")
("tdbb"	"$(1Yk(B")
("tdbk"	"$(1MZ(B")
("tdbn"	"$(1?S(B")
("tdbu"	"$(1F`(B")
("tdci"	"$(1?W(B")
("tdhl"	"$(1?V(B")
("tdhaf"	"$(1nj(B")
("tdlc"	"$(1ii(B")
("tdlo"	"$(1SG(B")
("tdmq"	"$(0H3(B")
("tdnl"	"$(0T^(B")
("tdoo"	"$(0Cc(B")
("tdsr"	"$(1f](B")
("tdwf"	"$(1F\(B")
("tec"	"$(0_E(B")
("ted"	"$(18v(B")
("tem"	"$(128(B")
("teah"	"$(0T%(B")
("tebm"	"$(1?E(B")
("tede"	"$(0C[(B")
("tefh"	"$(0>u(B")
("tege"	"$(0P`(B")
("tehr"	"$(0H0$(1FQ(B")
("tehv"	"$(1F|(B")
("tehw"	"$(0Zj(B")
("teib"	"$(0Lc(B")
("teii"	"$(0W,(B")
("teiv"	"$(1M5(B")
("telu"	"$(18^(B")
("temf"	"$(1c%(B")
("temj"	"$(0CZ$(1fT(B")
("temr"	"$(1?D(B")
("tene"	"$(18w(B")
("teod"	"$(1M6(B")
("teom"	"$(1pL(B")
("teon"	"$(1Yg(B")
("teot"	"$(0Lb(B")
("terd"	"$(0\2(B")
("tesd"	"$(1Yd(B")
("tesr"	"$(1?m(B")
("tess"	"$(1?l(B")
("tesu"	"$(058(B")
("tett"	"$(1FP(B")
("tewb"	"$(1Ye(B")
("tewt"	"$(1^a(B")
("teyb"	"$(1^`(B")
("teye"	"$(1Sf(B")
("teyu"	"$(1F{(B")
("teyv"	"$(09r(B")
("tfb"	"$(18{(B")
("tff"	"$(1?L(B")
("tfaj"	"$(1S@(B")
("tfbk"	"$(0PS(B")
("tfbn"	"$(1Ff(B")
("tfff"	"$(1br(B")
("tfkc"	"$(1oE(B")
("tfku"	"$(1r.(B")
("tfmc"	"$(1^e(B")
("tfmu"	"$(12G(B")
("tfnl"	"$(1gK(B")
("tfqu"	"$(1?K(B")
("tgb"	"$(05A(B")
("tgf"	"$(09Q(B")
("tgg"	"$(12=(B")
("tgk"	"$(05"(B")
("tgp"	"$(1o*$(07D(B")
("tgv"	"$(02[(B")
("tgbuu"	"$(0_)(B")
("tgce"	"$(0C`(B")
("tgdi"	"$(0JX(B")
("tgeno"	"$(0Gz(B")
("tgftk"	"$(0Zg(B")
("tggi"	"$(1SEFX(B")
("tggu"	"$(1Yj(B")
("tghu"	"$(01.(B")
("tghaf"	"$(0_J(B")
("tghds"	"$(0Ss(B")
("tghni"	"$(1r!(B")
("tghqi"	"$(0Gy(B")
("tgif"	"$(1ey(B")
("tgii"	"$(0Zk(B")
("tgit"	"$(0Le(B")
("tgimo"	"$(1?*(B")
("tgine"	"$(188(B")
("tgje"	"$(1Z"(B")
("tgji"	"$(1SC(B")
("tgks"	"$(0[a(B")
("tglln"	"$(18;(B")
("tgmbc"	"$(1q~(B")
("tgni"	"$(1bv(B")
("tgnl"	"$(1lK(B")
("tgno"	"$(1,p$(0]d$(18y(B")
("tgow"	"$(0W0(B")
("tgobo"	"$(1q5(B")
("tgpm"	"$(18b(B")
("tgrg"	"$(0Y6(B")
("tgsk"	"$(1SB(B")
("tgte"	"$(1^g(B")
("tgtr"	"$(0CD(B")
("tgwc"	"$(1fZ(B")
("tgyv"	"$(1oG(B")
("thi"	"$(0Li(B")
("thj"	"$(1%"(B")
("thk"	"$(1(^(B")
("ths"	"$(1-<(B")
("thaf"	"$(1c$S](B")
("thag"	"$(1Ft(B")
("thai"	"$(1?d(B")
("thau"	"$(0H<(B")
("thbh"	"$(1r8(B")
("thbk"	"$(1^y(B")
("thbu"	"$(05}(B")
("thcn"	"$(1fd(B")
("thda"	"$(1G&(B")
("thdb"	"$(1Yv(B")
("thde"	"$(1_#(B")
("thdf"	"$(1Fn(B")
("thdh"	"$(1?aYu(B")
("thdm"	"$(1MO(B")
("thdn"	"$(0?"(B")
("thds"	"$(0?#(B")
("thdv"	"$(0Ck$(1c#(B")
("thdw"	"$(0T&(B")
("ther"	"$(12K(B")
("they"	"$(1-F(B")
("thgf"	"$(0Y4(B")
("thhc"	"$(1Y~(B")
("thhd"	"$(1Yt(B")
("thhe"	"$(1fb(B")
("thhj"	"$(1?c(B")
("thhl"	"$(05L(B")
("thhaf"	"$(1k2(B")
("thjd"	"$(0:#[j(B")
("thje"	"$(1G)(B")
("thjg"	"$(0H;(B")
("thjm"	"$(1Fo(B")
("thjo"	"$(1pU(B")
("thkb"	"$(1Yw(B")
("thkp"	"$(1?u(B")
("thlb"	"$(1Fs(B")
("thlf"	"$(1ip(B")
("thmb"	"$(1my(B")
("thml"	"$(01D(B")
("thmr"	"$(12P(B")
("thne"	"$(01C(B")
("thni"	"$(1%#(B")
("thoe"	"$(1Y{(B")
("thok"	"$(0W3$(1fh(B")
("thol"	"$(1Sb(B")
("thon"	"$(12Qio(B")
("thoo"	"$(1MUS`SaMW(B")
("thoq"	"$(1Fw(B")
("thqi"	"$(18r(B")
("thqo"	"$(1-=(B")
("thqu"	"$(1(\(B")
("thrj"	"$(0W2(B")
("thsb"	"$(1?gFv(B")
("thse"	"$(1M\(B")
("thsk"	"$(1^{(B")
("thsu"	"$(1Se(B")
("thup"	"$(1MV(B")
("thvi"	"$(1m{(B")
("thwp"	"$(1MR$(0P^(B")
("thxc"	"$(1bx(B")
("thxf"	"$(1Yx(B")
("thxo"	"$(0Cj(B")
("thye"	"$(1M[(B")
("tih"	"$(05?(B")
("tij"	"$(12;(B")
("tip"	"$(1$|aU(B")
("tir"	"$(05F(B")
("tiav"	"$(18`(B")
("tibi"	"$(1MC(B")
("tice"	"$(18t(B")
("tidq"	"$(1fe(B")
("tidr"	"$(0\4(B")
("tidy"	"$(1oD(B")
("tihc"	"$(1Yl(B")
("tihm"	"$(1?J(B")
("tihr"	"$(1FaMH(B")
("tihs"	"$(18z(B")
("tihv"	"$(1Fb(B")
("tihaf"	"$(1or(B")
("tiih"	"$(1Sc(B")
("tijb"	"$(0?'(B")
("tije"	"$(18a(B")
("tikf"	"$(1FV(B")
("tikk"	"$(1-2(B")
("tikt"	"$(0>{(B")
("tilo"	"$(1?n(B")
("tilr"	"$(1M:(B")
("timo"	"$(0:$(B")
("tims"	"$(0Y/(B")
("tino"	"$(01?(B")
("tioc"	"$(1^f(B")
("tipd"	"$(1l#(B")
("tipf"	"$(1fY(B")
("titb"	"$(0L_(B")
("titc"	"$(1^d(B")
("titf"	"$(0PR(B")
("tixf"	"$(0Y7(B")
("tixp"	"$(1S>(B")
("tjb"	"$(01L(B")
("tje"	"$(01K(B")
("tjr"	"$(05<(B")
("tjv"	"$(12S(B")
("tjam"	"$(0Mg(B")
("tjau"	"$(0I_(B")
("tjav"	"$(1U\(B")
("tjamo"	"$(1dI(B")
("tjapv"	"$(1dJ(B")
("tjavf"	"$(1o`(B")
("tjbd"	"$(0>x(B")
("tjbj"	"$(1G"(B")
("tjbm"	"$(1?kO/(B")
("tjck"	"$(1FR(B")
("tjcn"	"$(1fV(B")
("tjcr"	"$(0L](B")
("tjdj"	"$(1O*(B")
("tjds"	"$(1F[(B")
("tjdhe"	"$(1O1(B")
("tjea"	"$(1`L(B")
("tjef"	"$(1oF(B")
("tjfb"	"$(0T~(B")
("tjfq"	"$(1O)(B")
("tjfbr"	"$(1`N(B")
("tjgg"	"$(0Qm(B")
("tjgr"	"$(1U[(B")
("tjgwc"	"$(1pa(B")
("tjhd"	"$(1O.(B")
("tjhaf"	"$(1p$(B")
("tjhdf"	"$(0Yj(B")
("tjhhj"	"$(1`M(B")
("tjhml"	"$(1Hb(B")
("tjii"	"$(1SH(B")
("tjip"	"$(0T"(B")
("tjjj"	"$(1MY(B")
("tjjl"	"$(1SI(B")
("tjjv"	"$(0Ql(B")
("tjjcm"	"$(1`J(B")
("tjka"	"$(0Cb(B")
("tjkp"	"$(12>(B")
("tjks"	"$(0;-(B")
("tjlo"	"$(1?N(B")
("tjlv"	"$(0C](B")
("tjlbk"	"$(0Mh(B")
("tjlwv"	"$(1jZ(B")
("tjmc"	"$(1S;(B")
("tjme"	"$(1S8(B")
("tjmj"	"$(1AO(B")
("tjmm"	"$(0H1(B")
("tjmn"	"$(057$(1:3(B")
("tjmo"	"$(1?F(B")
("tjmr"	"$(1?j(B")
("tjmu"	"$(1AP$(0>v(B")
("tjmwm"	"$(0^$(B")
("tjni"	"$(1O,(B")
("tjnl"	"$(1gLHc(B")
("tjnu"	"$(1?G(B")
("tjnau"	"$(1[b(B")
("tjnhd"	"$(0Yi(B")
("tjnhe"	"$(1Hd(B")
("tjnkq"	"$(1dH(B")
("tjoa"	"$(0P_(B")
("tjop"	"$(0I^(B")
("tjoin"	"$(1He(B")
("tjomk"	"$(0Yk(B")
("tjomr"	"$(1U](B")
("tjomt"	"$(1dO(B")
("tjpa"	"$(1MB(B")
("tjpi"	"$(1AQ(B")
("tjpn"	"$(1bp(B")
("tjpt"	"$(1O+(B")
("tjpu"	"$(1S7(B")
("tjpfd"	"$(0X&(B")
("tjpru"	"$(1O0(B")
("tjptd"	"$(1dN(B")
("tjpyr"	"$(1dK(B")
("tjqyt"	"$(1`K(B")
("tjrb"	"$(0H4$(1[`(B")
("tjrr"	"$(0C\(B")
("tjshr"	"$(1O-(B")
("tjtc"	"$(1Yi(B")
("tjtq"	"$(1bq(B")
("tjtif"	"$(0_7(B")
("tjtoe"	"$(1o_(B")
("tjtor"	"$(1gn(B")
("tjvii"	"$(1l`(B")
("tjvis"	"$(1O2(B")
("tjwj"	"$(18x(B")
("tjydl"	"$(1jY(B")
("tjygq"	"$(0^#(B")
("tjymu"	"$(0^t(B")
("tkd"	"$(0U|(B")
("tke"	"$(1(e(B")
("tkn"	"$(1"m2<(B")
("tkp"	"$(1\m(B")
("tkq"	"$(0Ud(B")
("tkr"	"$(05>(B")
("tkce"	"$(1S\(B")
("tkhf"	"$(0?%(B")
("tkhg"	"$(18u(B")
("tkhi"	"$(1fU(B")
("tkhw"	"$(1Yz(B")
("tkhaf"	"$(1a+k?(B")
("tkkb"	"$(18n(B")
("tkld"	"$(09w(B")
("tklg"	"$(12V(B")
("tklu"	"$(0Ca(B")
("tklmi"	"$(1fr(B")
("tkms"	"$(12D(B")
("tkni"	"$(1%$(B")
("tknl"	"$(1NX$(0QQ(B")
("tkok"	"$(1M9(B")
("tkoo"	"$(0>y(B")
("tkpb"	"$(1SK(B")
("tkrp"	"$(0Ez(B")
("tksr"	"$(05=(B")
("tkss"	"$(09t(B")
("tksqf"	"$(0^R(B")
("tkymr"	"$(0\A(B")
("tlj"	"$(05u(B")
("tlw"	"$(1-8(B")
("tlx"	"$(0T((B")
("tlbk"	"$(05C(B")
("tlln"	"$(1-4(B")
("tllmi"	"$(1c=(B")
("tlmc"	"$(1Yo(B")
("tlmi"	"$(12X(B")
("tlmt"	"$(1b|(B")
("tlmy"	"$(0Ch(B")
("tlpf"	"$(1o}$(0S;(B")
("tlqm"	"$(14?(B")
("tlvk"	"$(0Zl(B")
("tlwv"	"$(1SZ(B")
("tmd"	"$(0-C3](B")
("tmf"	"$(01J(B")
("tmn"	"$(1"k(B")
("tmy"	"$(1$z(B")
("tmam"	"$(12@(B")
("tmbb"	"$(1c&(B")
("tmbg"	"$(1ig(B")
("tmbi"	"$(1_!Yh(B")
("tmbl"	"$(12W(B")
("tmbr"	"$(1l$(B")
("tmbw"	"$(0W-(B")
("tmbuu"	"$(0Y=(B")
("tmcw"	"$(12B8d(B")
("tmdm"	"$(1il(B")
("tmfb"	"$(1c'(B")
("tmff"	"$(0Ld(B")
("tmfj"	"$(1-1(B")
("tmfm"	"$(1-C(B")
("tmgf"	"$(0^F(B")
("tmgn"	"$(1?Xbw(B")
("tmgr"	"$(1ih(B")
("tmhf"	"$(1MG(B")
("tmhg"	"$(1Z#(B")
("tmhml"	"$(1Pk(B")
("tmig"	"$(12E(B")
("tmks"	"$(0E<(B")
("tmlm"	"$(1?Q(B")
("tmmc"	"$(0.((B")
("tmmi"	"$(01I(B")
("tmms"	"$(1Fc(B")
("tmmu"	"$(1(U(B")
("tmmv"	"$(04J(B")
("tmnh"	"$(1^j(B")
("tmnj"	"$(12?(B")
("tmnl"	"$(0MK$(1(v(B")
("tmnm"	"$(1^i(B")
("tmnn"	"$(12C(B")
("tmnr"	"$(05;(B")
("tmnv"	"$(1^kFZ(B")
("tmoa"	"$(1f^(B")
("tmob"	"$(1-B(B")
("tmom"	"$(1Ym(B")
("tmoo"	"$(18g(B")
("tmpt"	"$(0H6(B")
("tmrb"	"$(1MD(B")
("tmrr"	"$(1fg(B")
("tmrt"	"$(18c(B")
("tmrw"	"$(1F](B")
("tmtj"	"$(0C_(B")
("tmtn"	"$(09u(B")
("tmto"	"$(0T$(B")
("tmvh"	"$(01B(B")
("tmvi"	"$(1MF(B")
("tmvm"	"$(0>z(B")
("tmwc"	"$(0E((B")
("tmwf"	"$(1SF(B")
("tmwj"	"$(0T#(B")
("tmwm"	"$(0W/(B")
("tmwv"	"$(1F^(B")
("tmyf"	"$(1SD(B")
("tmymu"	"$(1q[(B")
("tnd"	"$(1%!(B")
("tni"	"$(1-A(B")
("tno"	"$(1(a(B")
("tnbc"	"$(1Fq(B")
("tnbe"	"$(1fc(B")
("tnbq"	"$(1^z(B")
("tncr"	"$(1^x(B")
("tndf"	"$(0Lg(B")
("tndo"	"$(0Cd(B")
("tndu"	"$(1(d(B")
("tnef"	"$(0Lf(B")
("tnfd"	"$(0\8(B")
("tnfn"	"$(0W5(B")
("tnfq"	"$(0]$(B")
("tnhd"	"$(1F~(B")
("tnhe"	"$(1(`(B")
("tnhs"	"$(1SR"n(B")
("tnhx"	"$(1?`(B")
("tnih"	"$(059(B")
("tnin"	"$(12L(Z(B")
("tniq"	"$(12Y(B")
("tnir"	"$(0:!(B")
("tniu"	"$(05G(B")
("tniv"	"$(1Yy(B")
("tnkg"	"$(18q(B")
("tnkm"	"$(19!(B")
("tnlc"	"$(1f\(B")
("tnld"	"$(1MJ(B")
("tnli"	"$(0PW(B")
("tnlm"	"$(0Y0(B")
("tnlp"	"$(1l%(B")
("tnlw"	"$(1Sh(B")
("tnmm"	"$(1MI(B")
("tnmu"	"$(0PV(B")
("tnnc"	"$(1^l(B")
("tnnl"	"$(1_p(B")
("tnok"	"$(0H2(B")
("tnsj"	"$(1Fe(B")
("tntg"	"$(1q7(B")
("tnue"	"$(1?Y(B")
("tnui"	"$(0Cp(B")
("tnup"	"$(1G$(B")
("tnus"	"$(1Fr(B")
("tob"	"$(1([(B")
("tod"	"$(12M$(09~(B")
("tof"	"$(1-@(B")
("tog"	"$(1AK->?b(B")
("toi"	"$(12N(B")
("top"	"$(01E(B")
("toav"	"$(0W*(B")
("tobg"	"$(1M=(B")
("todi"	"$(1-?(B")
("togf"	"$(0T'(B")
("togx"	"$(0Y.(B")
("tohg"	"$(09{(B")
("tohs"	"$(18s(B")
("tohaf"	"$(1qQ(B")
("tohqu"	"$(1aw(B")
("toie"	"$(1Fu(B")
("toii"	"$(05I(B")
("toik"	"$(12O(B")
("toin"	"$(1(b(B")
("toir"	"$(0Lj(B")
("toiav"	"$(0Qs(B")
("tokf"	"$(1l-(B")
("tokg"	"$(1^w(B")
("tolb"	"$(1S_(B")
("told"	"$(1S^(B")
("toll"	"$(01G(B")
("toma"	"$(1^|(B")
("tomb"	"$(1?fl/(B")
("tomd"	"$(0?&(B")
("tomg"	"$(0:%(B")
("tomm"	"$(1(g(B")
("tomn"	"$(1(](B")
("tomo"	"$(1_$(B")
("tomr"	"$(0?$$(12R(B")
("tonk"	"$(1G((B")
("tono"	"$(0OE(B")
("tonwf"	"$(1h?(B")
("tooe"	"$(1MM(B")
("toog"	"$(18p$(0[E(B")
("took"	"$(1l.(B")
("toom"	"$(1Fm(B")
("toqb"	"$(1MQ(B")
("tord"	"$(0H>(B")
("tose"	"$(1G'(B")
("totf"	"$(0T)(B")
("touk"	"$(1MN(B")
("towy"	"$(0?!(B")
("toyr"	"$(0Lh(B")
("tpa"	"$(0:"(B")
("tph"	"$(1-0(B")
("tpi"	"$(0-D$(1(f(B")
("tpp"	"$(1(W(B")
("tpr"	"$(05J$(1)C(B")
("tpu"	"$(1(V(B")
("tpfd"	"$(0Ci(B")
("tphh"	"$(1(_(B")
("tpib"	"$(0H:(B")
("tpko"	"$(1bz(B")
("tpmw"	"$(0P\(B")
("tpou"	"$(0Cl(B")
("tppp"	"$(0T!(B")
("tpru"	"$(05H(B")
("tptd"	"$(0H5(B")
("tpyv"	"$(1oC(B")
("tqm"	"$(07:(B")
("tqo"	"$(01@(B")
("tqapv"	"$(0PI(B")
("tqcsh"	"$(12'(B")
("tqda"	"$(0Y3(B")
("tqdb"	"$(0Zm(B")
("tqfh"	"$(18f(B")
("tqhr"	"$(1FY(B")
("tqhdw"	"$(1bg(B")
("tqhne"	"$(12&(B")
("tqhpm"	"$(18:(B")
("tqib"	"$(1ME(B")
("tqij"	"$(1?((B")
("tqik"	"$(1?U(B")
("tqice"	"$(1F7(B")
("tqihr"	"$(1R|(B")
("tqixe"	"$(1k}(B")
("tqjm"	"$(1SA(B")
("tqjmn"	"$(189(B")
("tqjmu"	"$(1F5(B")
("tqjtc"	"$(1bf(B")
("tqka"	"$(1G!(B")
("tqkd"	"$(1MA(B")
("tqkn"	"$(1?)(B")
("tqkq"	"$(1?M(B")
("tqlw"	"$(1?q(B")
("tqmb"	"$(0C^(B")
("tqmbb"	"$(1i^(B")
("tqmhf"	"$(1YO(B")
("tqmvm"	"$(1F6(B")
("tqng"	"$(0>a(B")
("tqog"	"$(1SL(B")
("tqoii"	"$(0>b(B")
("tqomn"	"$(1R~(B")
("tqomo"	"$(1fK(B")
("tqpu"	"$(1?r(B")
("tqqo"	"$(18e(B")
("tqsmm"	"$(0CE(B")
("tqumf"	"$(1R}(B")
("tqwj"	"$(1ik(B")
("tqyt"	"$(1?P(B")
("tqywm"	"$(0Zf(B")
("trhr"	"$(0>}(B")
("trjd"	"$(1?Z(B")
("trji"	"$(1^p(B")
("trjl"	"$(1im(B")
("trmr"	"$(1^r(B")
("trnl"	"$(1T~A!(B")
("trog"	"$(1S[(B")
("trok"	"$(0F:(B")
("tron"	"$(18~(B")
("trrg"	"$(1d@(B")
("trrj"	"$(1Yr(B")
("trrr"	"$(1q8(B")
("trrs"	"$(0H8(B")
("trsj"	"$(1Fi(B")
("trvp"	"$(1-D(B")
("trye"	"$(0H=(B")
("tsh"	"$(1"l(B")
("tsj"	"$(09v(B")
("tsk"	"$(1(X(B")
("tsp"	"$(1-3\k(B")
("tss"	"$(05:(B")
("tsu"	"$(1$~(B")
("tsem"	"$(1l((B")
("tseo"	"$(1bt(B")
("tsfi"	"$(0PT(B")
("tshr"	"$(1-5(B")
("tsic"	"$(1^h(B")
("tsip"	"$(18jff(B")
("tsiq"	"$(1^m(B")
("tsit"	"$(0Y1(B")
("tsja"	"$(1mw(B")
("tsjd"	"$(0]"(B")
("tsje"	"$(1?O(B")
("tskr"	"$(18i(B")
("tsle"	"$(1?R(B")
("tsll"	"$(12U(B")
("tsmg"	"$(1b{(B")
("tsmh"	"$(1SO(B")
("tsmi"	"$(1Yn(B")
("tsmv"	"$(0Cn(B")
("tsrf"	"$(1SP(B")
("tsrj"	"$(0W.(B")
("tsrr"	"$(1SJ(B")
("ttc"	"$(0-e(B")
("tti"	"$(1!E(B")
("ttt"	"$(12T(B")
("ttbn"	"$(1FW(B")
("ttcf"	"$(1by(B")
("ttcg"	"$(1l&mx(B")
("ttgb"	"$(1.$(B")
("ttgf"	"$(1MX(B")
("ttgi"	"$(1c!(B")
("tthaf"	"$(1m%a'(B")
("ttjd"	"$(1l'(B")
("ttlm"	"$(1SN(B")
("ttmc"	"$(1?T(B")
("ttmv"	"$(1F_(B")
("ttmbc"	"$(1Uc(B")
("ttmvn"	"$(0>&(B")
("ttnl"	"$(1-Y(B")
("ttnau"	"$(1?B(B")
("ttqm"	"$(1M>(B")
("ttshi"	"$(1%U(B")
("ttub"	"$(1M@(B")
("ttvb"	"$(1ij(B")
("ttwli"	"$(1oI(B")
("ttxc"	"$(1M?(B")
("tub"	"$(07v(B")
("tuu"	"$(05D(B")
("tuirm"	"$(1`b(B")
("tujt"	"$(1mv(B")
("tvi"	"$(0F)(B")
("tvr"	"$(09}(B")
("tvff"	"$(1Z$(B")
("tvfh"	"$(1MT(B")
("tvfi"	"$(1Fz(B")
("tvfm"	"$(1Fy(B")
("tvft"	"$(0\9(B")
("tvfu"	"$(1Z!(B")
("tvfy"	"$(1Sd(B")
("tvhl"	"$(1Y}(B")
("tvid"	"$(0@lZo(B")
("tvif"	"$(1k;(B")
("tvii"	"$(09|(B")
("tvio"	"$(1-;(B")
("tvip"	"$(0Ev(B")
("tvis"	"$(1-G(B")
("tvjr"	"$(1?h(B")
("tvks"	"$(0;/(B")
("tvlk"	"$(12J(B")
("tvmg"	"$(0>~(B")
("tvmi"	"$(1^}$(0PZ(B")
("tvmw"	"$(1l,(B")
("tvne"	"$(1?^(B")
("tvno"	"$(1D#(B")
("tvrf"	"$(1Y|(B")
("tvrq"	"$(1MS(B")
("tvvv"	"$(1Fx(B")
("tvvw"	"$(1?i(B")
("tvyj"	"$(0F;(B")
("twa"	"$(0=+(B")
("twk"	"$(09y@e(B")
("two"	"$(1-:(B")
("twp"	"$(1Fk(B")
("twr"	"$(09z(B")
("twbi"	"$(1fq(B")
("twbo"	"$(0\G(B")
("twcb"	"$(18k(B")
("twdi"	"$(0@r(B")
("twfu"	"$(1SU(B")
("twhd"	"$(0Cf(B")
("twik"	"$(0G((B")
("twim"	"$(1SW(B")
("twks"	"$(18}(B")
("twla"	"$(0W1(B")
("twlb"	"$(0G](B")
("twle"	"$(1in(B")
("twlg"	"$(0^G(B")
("twli"	"$(0PY$(1^s(B")
("twln"	"$(1b~l*$(0SJJC(B")
("twlp"	"$(1fa$(0W4(B")
("twlu"	"$(1Xg(B")
("twlii"	"$(1l4(B")
("twmv"	"$(1G#(B")
("twmmv"	"$(0I*(B")
("twmrt"	"$(1G\(B")
("twtj"	"$(1SY(B")
("twvf"	"$(1SX(B")
("twwf"	"$(1q6(B")
("twwg"	"$(1mz(B")
("twww"	"$(1f`(B")
("twyi"	"$(1-E(B")
("txc"	"$(06B(B")
("tyk"	"$(1(S(B")
("tyr"	"$(1-7(B")
("tyt"	"$(1-/(B")
("tyv"	"$(0-B(B")
("tyx"	"$(0Y5(B")
("tybb"	"$(0H.$(1^t(B")
("tybg"	"$(1oA(B")
("tybo"	"$(1bs(B")
("tybp"	"$(1if(B")
("tybs"	"$(1M7(B")
("tycb"	"$(1S9(B")
("tyck"	"$(129(B")
("tycu"	"$(1?I(B")
("tycv"	"$(1S=(B")
("tydl"	"$(0W+(B")
("tydo"	"$(1f[(B")
("tydu"	"$(1iq(B")
("tyfe"	"$(0Cg(B")
("tygq"	"$(1_"(B")
("tygv"	"$(1bu(B")
("tyhc"	"$(0\7(B")
("tyhj"	"$(0P](B")
("tyhn"	"$(1(T(B")
("tyhs"	"$(01>(B")
("tyiu"	"$(1-6(B")
("tyjj"	"$(0PU(B")
("tylm"	"$(01M(B")
("tymh"	"$(1^n(B")
("tymo"	"$(1SM(B")
("tymp"	"$(12H(B")
("tynb"	"$(1SQ(B")
("tyoe"	"$(1fW(B")
("tyoj"	"$(0CX(B")
("typm"	"$(1SS(B")
("typp"	"$(1f_(B")
("typt"	"$(0\6(B")
("tyra"	"$(0Zp(B")
("tyrb"	"$(0L^(B")
("tyre"	"$(1S<^q(B")
("tyrl"	"$(1S:(B")
("tyrn"	"$(1FS(B")
("tyrp"	"$(1^c(B")
("tyrv"	"$(1l"$(0\3(B")
("tysd"	"$(1FT(B")
("tysk"	"$(1S?(B")
("tysm"	"$(1oB(B")
("tyso"	"$(1Sg(B")
("tysy"	"$(0CY(B")
("tyta"	"$(1F}(B")
("tytg"	"$(1Yf(B")
("tytj"	"$(0>w(B")
("tytp"	"$(1^b(B")
("tytr"	"$(0CW$(1M8(B")
("tytv"	"$(1?H(B")
("tyvg"	"$(1^~(B")
("tyvo"	"$(12:(B")
("tyvp"	"$(18_(B")
("tyvu"	"$(09s(B")
("tyvw"	"$(0L`(B")
("tywi"	"$(1ST(B")
("tywv"	"$(0Lk(B")
("tyyb"	"$(1fX(B")
("tyyo"	"$(1l)(B")
("u"	"$(0&U(B")
("uc"	"$(15((B")
("uh"	"$(0&2(B")
("uk"	"$(0'!(B")
("ul"	"$(1!,(B")
("uu"	"$(0'y$(1"j":(B")
("uav"	"$(1*.(B")
("uahu"	"$(1;C(B")
("uamh"	"$(1;E(B")
("uamo"	"$(1;S(B")
("uapp"	"$(0;}(B")
("uapv"	"$(1;F(B")
("ubb"	"$(0;~(B")
("ubm"	"$(1&B(B")
("ubcn"	"$(1;M(B")
("ubln"	"$(13oAn(B")
("ubmr"	"$(02s(B")
("ubmbc"	"$(0Yq(B")
("ubnl"	"$(1lL(B")
("ubno"	"$(1D!(B")
("ubsd"	"$(0;|(B")
("ubtu"	"$(0<%(B")
("ubuu"	"$(079(B")
("ucno"	"$(0NU(B")
("ucor"	"$(074(B")
("ucwa"	"$(1P0(B")
("udw"	"$(14|(B")
("udci"	"$(0<$(B")
("udhe"	"$(1&K(B")
("udoo"	"$(15!(B")
("udsmg"	"$(1q/(B")
("udyg"	"$(1;V(B")
("ufb"	"$(071(B")
("ufdq"	"$(1P-(B")
("uffd"	"$(0UY(B")
("uffr"	"$(1hr(B")
("uffs"	"$(1P.(B")
("ufgi"	"$(1aQ(B")
("ugce"	"$(14{(B")
("ugdi"	"$(02r(B")
("uggi"	"$(1;U(B")
("uggu"	"$(1P1(B")
("ugno"	"$(078(B")
("uha"	"$(1&L(B")
("uhi"	"$(1BY(B")
("uhk"	"$(1#g(B")
("uhs"	"$(1&J(B")
("uhag"	"$(1;T(B")
("uhdj"	"$(1;N(B")
("uhdp"	"$(1BV(B")
("uhdv"	"$(15'(B")
("uhdw"	"$(1P2(B")
("uhej"	"$(076(B")
("uher"	"$(1*%*,(B")
("uhhj"	"$(15#(B")
("uhhw"	"$(1B\(B")
("uhkb"	"$(1P4(B")
("uhmb"	"$(1kX(B")
("uhml"	"$(1#h(B")
("uhni"	"$(0@v(B")
("uhoo"	"$(1Ip(B")
("uhoq"	"$(1;O(B")
("uhpa"	"$(15$(B")
("uhqi"	"$(075(B")
("uhrf"	"$(1B[(B")
("uhrj"	"$(1Vs(B")
("uhuc"	"$(1mN(B")
("uhud"	"$(1BX(B")
("uhvi"	"$(0\j(B")
("uhxc"	"$(0UV(B")
("uip"	"$(13N(B")
("uiav"	"$(1.t(B")
("uice"	"$(073(B")
("uihr"	"$(1;W(B")
("uihs"	"$(1*0(B")
("uihv"	"$(0@w(B")
("uiih"	"$(1It(B")
("uijb"	"$(1.o(B")
("uilr"	"$(1BU(B")
("ujc"	"$(1&>(B")
("ujd"	"$(1i((B")
("uje"	"$(0,$(B")
("ujp"	"$(1&=(B")
("ujr"	"$(1&@(B")
("ujv"	"$(1*((B")
("ujcc"	"$(0]^(B")
("ujcm"	"$(0;x(B")
("ujcr"	"$(1BT(B")
("ujfd"	"$(1mp(B")
("ujjl"	"$(0JZ(B")
("ujkp"	"$(1**(B")
("ujlo"	"$(14~(B")
("ujlmi"	"$(1n"(B")
("ujmf"	"$(0;w(B")
("ujmrt"	"$(0YC(B")
("ukb"	"$(1*/(B")
("ukg"	"$(1*$(B")
("ukn"	"$(1*)(B")
("uks"	"$(1!W(B")
("ukcf"	"$(1P7(B")
("ukhk"	"$(0UX(B")
("ukhu"	"$(0)>(B")
("ukjj"	"$(1H&(B")
("ukkb"	"$(0<#(B")
("uklu"	"$(15"(B")
("ukmr"	"$(0;y(B")
("ukoo"	"$(072(B")
("ukpb"	"$(1Il(B")
("ulw"	"$(0/)(B")
("ulbk"	"$(1&D(B")
("ulln"	"$(1&H(B")
("ulwv"	"$(1Io(B")
("umf"	"$(048(B")
("umr"	"$(0/((B")
("umt"	"$(1#`(B")
("umu"	"$(1"7(B")
("umam"	"$(1)|(B")
("umbc"	"$(1;R(B")
("umbl"	"$(1*+$(05'(B")
("umbs"	"$(1Ik(B")
("umfm"	"$(1&A(B")
("umgg"	"$(0;{(B")
("umig"	"$(1)}(B")
("umli"	"$(0:+(B")
("ummj"	"$(0/'(B")
("ummr"	"$(1.p(B")
("ummu"	"$(1#a(B")
("umnc"	"$(1Ix(B")
("umnn"	"$(1*"(B")
("umnr"	"$(1&G(B")
("umoo"	"$(0WR(B")
("umrt"	"$(0:@(B")
("umtj"	"$(14y(B")
("umto"	"$(1P6(B")
("umua"	"$(1P5(B")
("umvh"	"$(1#b(B")
("unbq"	"$(1Vn(B")
("unhe"	"$(1#c$(0,'(B")
("unii"	"$(1Iw(B")
("unmu"	"$(1)~*#(B")
("unot"	"$(0NT(B")
("unqd"	"$(1BW(B")
("unri"	"$(0[l(B")
("uog"	"$(0<!(B")
("uon"	"$(0)|(B")
("uogb"	"$(1dBdA(B")
("uogf"	"$(1P3(B")
("uogs"	"$(1Vr(B")
("uoic"	"$(0UW(B")
("uoii"	"$(1&F(B")
("uoin"	"$(1#e$(0,%(B")
("uoir"	"$(1B](B")
("uoll"	"$(1#i(B")
("uomb"	"$(0<"(B")
("uomn"	"$(1;I(B")
("uomo"	"$(1Vo(B")
("uomr"	"$(1*-*&(B")
("upa"	"$(1*!(B")
("upr"	"$(1&E(B")
("uphh"	"$(1#d(B")
("upko"	"$(1\f(B")
("uqmb"	"$(14z(B")
("uqog"	"$(1Iq(B")
("urji"	"$(1Vt(B")
("urog"	"$(1Ir(B")
("urrk"	"$(0^6(B")
("urrs"	"$(1;D(B")
("urvp"	"$(0/%(B")
("uss"	"$(1&?(B")
("usu"	"$(1"8(B")
("ushi"	"$(1"9(B")
("ushr"	"$(1&I(B")
("usjr"	"$(14}(B")
("uskr"	"$(1.q(B")
("usma"	"$(1Iv(B")
("usmh"	"$(1In(B")
("usrr"	"$(0J[(B")
("usuu"	"$(0;z(B")
("utav"	"$(1Vj(B")
("utbuu"	"$(0WF(B")
("utcd"	"$(1Vp(B")
("utcw"	"$(1;?(B")
("utgi"	"$(1Vi(B")
("utgit"	"$(0_D(B")
("uthn"	"$(0@4(B")
("uthv"	"$(1mM(B")
("uthni"	"$(1gy(B")
("utik"	"$(1Kr(B")
("utln"	"$(0@6(B")
("utmo"	"$(0@u(B")
("utmv"	"$(1;B(B")
("utmbc"	"$(1gw(B")
("utnl"	"$(1lJ(B")
("utnau"	"$(0^m(B")
("utok"	"$(1J](B")
("utqm"	"$(0Ek(B")
("utrg"	"$(1kY(B")
("utvi"	"$(1;A(B")
("utwa"	"$(1Im(B")
("utwi"	"$(1P/(B")
("utwv"	"$(1Vk(B")
("uuu"	"$(1-.(B")
("uuce"	"$(1;H(B")
("uummf"	"$(09.(B")
("uuuu"	"$(1?C(B")
("uvii"	"$(02x(B")
("uvis"	"$(1&M(B")
("uvmi"	"$(1Is(B")
("uvvw"	"$(15%(B")
("uwl"	"$(1&C(B")
("uwp"	"$(1;L(B")
("uwjr"	"$(15)(B")
("uwlb"	"$(1;G(B")
("uwlj"	"$(1Vl(B")
("uwly"	"$(1Vm(B")
("uyt"	"$(1&N(B")
("uybb"	"$(1;P(B")
("uybk"	"$(1o'(B")
("uybp"	"$(1eL(B")
("uyhh"	"$(1;@(B")
("uyhm"	"$(1Iu(B")
("uyoj"	"$(15&(B")
("uyrb"	"$(0Ej(B")
("uyrd"	"$(14x(B")
("uyrn"	"$(1;Q(B")
("uysd"	"$(1;J(B")
("uyti"	"$(1hs(B")
("uytj"	"$(1Ij.s(B")
("uyvo"	"$(1){(B")
("v"	"$(0&M(B")
("ve"	"$(0(D(B")
("vl"	"$(1!#(B")
("vm"	"$(1"/(B")
("vr"	"$(0)r(B")
("vu"	"$(1"1(B")
("vv"	"$(1"0(B")
("vaa"	"$(0;e(B")
("vam"	"$(1&*(B")
("vabu"	"$(1:}(B")
("vahu"	"$(0@g(B")
("vamh"	"$(1;!(B")
("vamo"	"$(1:~(B")
("vanb"	"$(1rM(B")
("vand"	"$(0NI(B")
("vawe"	"$(1IY(B")
("vbd"	"$(14n(B")
("vbm"	"$(0.m(B")
("vbt"	"$(0.n(B")
("vbv"	"$(1.f(B")
("vbac"	"$(1B;(B")
("vbbe"	"$(1V_(B")
("vbbr"	"$(0@k(B")
("vbgr"	"$(14_(B")
("vbhg"	"$(14](B")
("vbhx"	"$(1BL(B")
("vbme"	"$(0@j(B")
("vbmr"	"$(1)q(B")
("vbou"	"$(1B@(B")
("vbuu"	"$(1.e(B")
("vci"	"$(1#X(B")
("vcnh"	"$(06|(B")
("vcsh"	"$(1#W(B")
("vdj"	"$(1&'(B")
("vdl"	"$(1.b(B")
("vdks"	"$(0E;(B")
("vdlc"	"$(1eJ(B")
("vdlk"	"$(0JI(B")
("vdln"	"$(0E7(B")
("vdnl"	"$(1N[(B")
("ven"	"$(0/;(B")
("vep"	"$(03((B")
("veq"	"$(1*V(B")
("vebt"	"$(1E?(B")
("veks"	"$(0+9(B")
("velb"	"$(0/1(B")
("veln"	"$(06N(B")
("vemr"	"$(11C(B")
("vend"	"$(1&8(B")
("vesqf"	"$(0Q{(B")
("vfa"	"$(1o0(B")
("vfc"	"$(0_?(B")
("vfd"	"$(1o2(B")
("vff"	"$(14c(B")
("vfh"	"$(0+o(B")
("vfk"	"$(1mJ(B")
("vfm"	"$(04y(B")
("vfn"	"$(0]`(B")
("vfp"	"$(0^7(B")
("vfq"	"$(0^8.u(B")
("vfr"	"$(0]z(B")
("vfu"	"$(0]_(B")
("vfv"	"$(1mL(B")
("vfw"	"$(0>Y(B")
("vfamo"	"$(0PF(B")
("vfaph"	"$(1Lv(B")
("vfapp"	"$(1Lu(B")
("vfase"	"$(1be(B")
("vfawe"	"$(0Vr(B")
("vfbb"	"$(0JH(B")
("vfbd"	"$(0LC(B")
("vfbm"	"$(0>[(B")
("vfbr"	"$(18-(B")
("vfbu"	"$(1pD(B")
("vfbv"	"$(0Gs(B")
("vfbbb"	"$(1Y?(B")
("vfbbe"	"$(0LH(B")
("vfbbr"	"$(1Rt(B")
("vfbcv"	"$(0^B(B")
("vfbgr"	"$(0LA(B")
("vfbhx"	"$(1YB(B")
("vfbjj"	"$(1Rm(B")
("vfbme"	"$(0PB(B")
("vfbmr"	"$(1>v(B")
("vfbnd"	"$(1F/(B")
("vfbof"	"$(1^G(B")
("vfbsh"	"$(1F*(B")
("vfbtu"	"$(0L?(B")
("vfbtv"	"$(0L>(B")
("vfbuh"	"$(0PE(B")
("vfbuo"	"$(1^D(B")
("vfcnh"	"$(1E~(B")
("vfcor"	"$(1F+(B")
("vfcsh"	"$(09N(B")
("vfcwa"	"$(0Y%(B")
("vfdd"	"$(1Ls(B")
("vfdi"	"$(04x(B")
("vfdl"	"$(1F"(B")
("vfdm"	"$(184(B")
("vfdbu"	"$(1Rq(B")
("vfdmq"	"$(0P9(B")
("vfdwf"	"$(0P8(B")
("vfeed"	"$(1YH(B")
("vfeee"	"$(0L=(B")
("vffb"	"$(1F)(B")
("vfff"	"$(1Lm(B")
("vffh"	"$(09B(B")
("vffq"	"$(0>R(B")
("vffdq"	"$(1bd(B")
("vffmu"	"$(1>u(B")
("vffqu"	"$(1Ln(B")
("vfgg"	"$(1>t(B")
("vfgi"	"$(18+(B")
("vfgr"	"$(0C9(B")
("vfgce"	"$(0L:(B")
("vfggu"	"$(0Y"(B")
("vfgrc"	"$(1kx(B")
("vfgwc"	"$(0\~(B")
("vfhg"	"$(11t(B")
("vfhab"	"$(0LB(B")
("vfhae"	"$(0P@(B")
("vfhaf"	"$(0_K^[(B")
("vfhce"	"$(1^H(B")
("vfhdv"	"$(1Lx(B")
("vfhdw"	"$(0Y&(B")
("vfheq"	"$(0CC(B")
("vfher"	"$(0C?(B")
("vfhey"	"$(0>](B")
("vfhgf"	"$(1i\(B")
("vfhhj"	"$(1L|(B")
("vfhjd"	"$(1?!(B")
("vfhje"	"$(0PA(B")
("vfhjg"	"$(1Rz(B")
("vfhjm"	"$(0PC(B")
("vfhkb"	"$(1bb(B")
("vfhon"	"$(1?#(B")
("vfhoo"	"$(1^I$(0Vl(B")
("vfhor"	"$(1Lz(B")
("vfhqo"	"$(18/(B")
("vfhsb"	"$(0P>(B")
("vfhsk"	"$(0Ze$(1L}(B")
("vfhuc"	"$(1q1(B")
("vfhvp"	"$(09M(B")
("vfhwp"	"$(0Vk(B")
("vfij"	"$(0C:(B")
("vfik"	"$(11v,n(B")
("vfir"	"$(183(B")
("vfibi"	"$(0Sl(B")
("vfihr"	"$(0P;(B")
("vfiih"	"$(0Vs(B")
("vfije"	"$(1F$(B")
("vfikk"	"$(0>_(B")
("vfiku"	"$(11}(B")
("vfill"	"$(1>|(B")
("vfimo"	"$(1>q(B")
("vfirm"	"$(1Lt(B")
("vfitc"	"$(1kv(B")
("vfiwg"	"$(0\}(B")
("vfjp"	"$(18)(B")
("vfjbc"	"$(0So(B")
("vfjbd"	"$(1F#(B")
("vfjii"	"$(1^@(B")
("vfjip"	"$(1b\(B")
("vfjka"	"$(0LF(B")
("vfjlo"	"$(1Lp(B")
("vfjlv"	"$(1Lq(B")
("vfjmc"	"$(0Vt\+(B")
("vfjmf"	"$(0L8(B")
("vfjmn"	"$(18((B")
("vfjmo"	"$(0L6(B")
("vfjmu"	"$(1F-(B")
("vfjnu"	"$(1M"(B")
("vfjoa"	"$(0Vd(B")
("vfjqr"	"$(1YF(B")
("vfjrr"	"$(0L7(B")
("vfjyj"	"$(1Y9(B")
("vfki"	"$(11w(B")
("vfkcf"	"$(0Y#(B")
("vfkkb"	"$(1F&(B")
("vfkmr"	"$(0L@(B")
("vfkni"	"$(1,m(B")
("vflw"	"$(18.(B")
("vflx"	"$(0Y$(B")
("vflbk"	"$(185(B")
("vflbu"	"$(11s(B")
("vflgm"	"$(1b^(B")
("vflll"	"$(1,l(B")
("vflln"	"$(0>W(B")
("vflmc"	"$(1b`(B")
("vflmi"	"$(0_((B")
("vflmo"	"$(1>~(B")
("vflmy"	"$(1Lw(B")
("vflwl"	"$(0>Z(B")
("vflwp"	"$(1>x(B")
("vflwv"	"$(0Vg(B")
("vfma"	"$(1>}(B")
("vfmd"	"$(04~(B")
("vfmf"	"$(11u(B")
("vfmn"	"$(1(J(B")
("vfmbb"	"$(1iZ(B")
("vfmbe"	"$(1ky(B")
("vfmbk"	"$(1Rn(B")
("vfmgk"	"$(0P:(B")
("vfmhf"	"$(1Y>(B")
("vfmia"	"$(0Sp(B")
("vfmig"	"$(0CB(B")
("vfmlb"	"$(1M$(B")
("vfmlk"	"$(1F!(B")
("vfmmi"	"$(09K(B")
("vfmmp"	"$(1q0(B")
("vfmvi"	"$(1Y<(B")
("vfmvm"	"$(0Go(B")
("vfmwf"	"$(0Vp(B")
("vfmwl"	"$(0P<(B")
("vfnd"	"$(0]](B")
("vfng"	"$(09H(B")
("vfnl"	"$(11x(B")
("vfnau"	"$(1F((B")
("vfnbq"	"$(1fD(B")
("vfnhb"	"$(1b_(B")
("vfnhe"	"$(09J(B")
("vfnii"	"$(0Vq(B")
("vfnin"	"$(11y(B")
("vfnkf"	"$(1fC(B")
("vfnkg"	"$(1F'(B")
("vfnkm"	"$(1L{(B")
("vfnob"	"$(1Rs(B")
("vfnri"	"$(0^D(B")
("vfob"	"$(09L(B")
("vfog"	"$(0LE(B")
("vfok"	"$(0^I(B")
("vfon"	"$(04|(B")
("vfoae"	"$(1Ry(B")
("vfobo"	"$(1q4(B")
("vfodi"	"$(186(B")
("vfohh"	"$(182(B")
("vfoim"	"$(0^C(B")
("vfoin"	"$(11z(B")
("vfoll"	"$(11{(B")
("vfoma"	"$(0Zc(B")
("vfomb"	"$(0LD(B")
("vfomg"	"$(1?"(B")
("vfomk"	"$(1Rv(B")
("vfomn"	"$(1Rx(B")
("vfomr"	"$(0C@(B")
("vfonk"	"$(1Rw(B")
("vfopd"	"$(180(B")
("vfoto"	"$(1i](B")
("vfpa"	"$(0CA(B")
("vfpi"	"$(04}(B")
("vfpp"	"$(09I(B")
("vfpr"	"$(181(B")
("vfpt"	"$(0>^(B")
("vfpu"	"$(09G(B")
("vfpmm"	"$(1Ro(B")
("vfpou"	"$(1Ly(B")
("vfpuu"	"$(0Sq(B")
("vfqu"	"$(14S(B")
("vfqjl"	"$(0Gr(B")
("vfqkd"	"$(1YI(B")
("vfqmb"	"$(1Lo(B")
("vfqmc"	"$(0Ve(B")
("vfqmf"	"$(1YJ(B")
("vfrb"	"$(0Gp(B")
("vfrbc"	"$(1Y@(B")
("vfrhr"	"$(1F.(B")
("vfrpa"	"$(1Rr(B")
("vfrrd"	"$(1f@(B")
("vfrrj"	"$(1ba(B")
("vfrsj"	"$(0P=(B")
("vfrxu"	"$(0Zb(B")
("vfsu"	"$(04z(B")
("vfshi"	"$(04{(B")
("vfshr"	"$(0>V(B")
("vfshu"	"$(0C;(B")
("vfsje"	"$(1Lr(B")
("vfsme"	"$(1F%(B")
("vfsmh"	"$(0Vf(B")
("vfswu"	"$(0_:(B")
("vftm"	"$(18,(B")
("vftt"	"$(1>s(B")
("vftak"	"$(1^B(B")
("vftbk"	"$(1b](B")
("vftct"	"$(0Si(B")
("vftcw"	"$(1Rp(B")
("vftgr"	"$(0Y!(B")
("vftlj"	"$(0PD(B")
("vftqm"	"$(1Y8(B")
("vftwi"	"$(1b[(B")
("vftwv"	"$(1fA(B")
("vftxc"	"$(0Sj(B")
("vfuu"	"$(0>X(B")
("vfubb"	"$(0Vi(B")
("vfuob"	"$(1pI(B")
("vfuog"	"$(1^E(B")
("vfvl"	"$(01,(B")
("vfvif"	"$(0C>(B")
("vfvne"	"$(0L;(B")
("vfvno"	"$(0P?(B")
("vfvvd"	"$(0Vm(B")
("vfvvi"	"$(0\,(B")
("vfvvw"	"$(0LG(B")
("vfwd"	"$(0Gq(B")
("vfwk"	"$(1>w(B")
("vfwp"	"$(1Ru(B")
("vfwgg"	"$(1kz(B")
("vfwlg"	"$(1q3(B")
("vfwlj"	"$(0Za(B")
("vfwlv"	"$(1fB(B")
("vfwot"	"$(1YA(B")
("vfwtj"	"$(1^C(B")
("vfwvf"	"$(0Vh(B")
("vfyg"	"$(18*(B")
("vfyj"	"$(11|(B")
("vfyk"	"$(09C(B")
("vfyaj"	"$(0L9(B")
("vfybb"	"$(0P7(B")
("vfybs"	"$(1YG(B")
("vfyck"	"$(0C8(B")
("vfygq"	"$(1fF(B")
("vfyhj"	"$(0Vj(B")
("vfyhr"	"$(1YD(B")
("vfyhs"	"$(09A(B")
("vfyia"	"$(0X~(B")
("vfyij"	"$(1^?(B")
("vfyiu"	"$(0>T(B")
("vfyjj"	"$(1^M(B")
("vfylr"	"$(1i[(B")
("vfyoj"	"$(1Ll(B")
("vfypt"	"$(1mq(B")
("vfyrb"	"$(0Sn(B")
("vfyrd"	"$(1Lk(B")
("vfyrf"	"$(1M#(B")
("vfyrv"	"$(1o?(B")
("vfyso"	"$(1^>(B")
("vfyto"	"$(1f?(B")
("vfytp"	"$(1f=(B")
("vfytu"	"$(1Y;(B")
("vfyub"	"$(1^=(B")
("vfyvi"	"$(0>S(B")
("vfyvo"	"$(1>r(B")
("vfyvq"	"$(0Vo(B")
("vfywm"	"$(1f>(B")
("vfywv"	"$(1Y:(B")
("vgb"	"$(1&+(B")
("vgf"	"$(16}(B")
("vgg"	"$(02`(B")
("vgk"	"$(06r$(1.](B")
("vgr"	"$(1)e(B")
("vgce"	"$(14f(B")
("vggu"	"$(0NM(B")
("vgni"	"$(1\`(B")
("vgow"	"$(1V](B")
("vgrg"	"$(1\a(B")
("vgrr"	"$(0NH(B")
("vgrv"	"$(1BJ(B")
("vgtj"	"$(14V(B")
("vgyhv"	"$(0HS(B")
("vhd"	"$(1&3(B")
("vhg"	"$(0+t(B")
("vhi"	"$(1BC(B")
("vhj"	"$(1"2(B")
("vhk"	"$(0+p(B")
("vhp"	"$(1".(B")
("vhs"	"$(0+k(B")
("vhab"	"$(14q(B")
("vhag"	"$(1;4(B")
("vhav"	"$(0RO(B")
("vhbr"	"$(1)u(B")
("vhcn"	"$(1aN(B")
("vhdn"	"$(1.g(B")
("vhdv"	"$(14o(B")
("vhdw"	"$(1P+(B")
("vhgu"	"$(1)j(B")
("vhhj"	"$(0;f(B")
("vhhw"	"$(1BM(B")
("vhiil"	"$(0DU(B")
("vhjd"	"$(1)i(B")
("vhjm"	"$(1;((B")
("vhjr"	"$(1)d(B")
("vhkb"	"$(0NL(B")
("vhkp"	"$(14p(B")
("vhml"	"$(1#[(B")
("vhmr"	"$(1)n(B")
("vhnb"	"$(1)t(B")
("vhpa"	"$(0;g(B")
("vhqi"	"$(06~(B")
("vhqm"	"$(0.p(B")
("vhsb"	"$(1;$(B")
("vhsk"	"$(1Va(B")
("vhup"	"$(0Eg(B")
("vhwp"	"$(0Ei(B")
("vhxe"	"$(0Eh(B")
("vhxu"	"$(14`(B")
("vid"	"$(0O?O@(B")
("vie"	"$(0OI(B")
("vif"	"$(0*O(B")
("vig"	"$(1IQ(B")
("vij"	"$(1)g(B")
("vio"	"$(0'i(B")
("vir"	"$(0.o(B")
("vis"	"$(0'=(B")
("viw"	"$(0Ok(B")
("viav"	"$(06u(B")
("vidi"	"$(0UR(B")
("vihi"	"$(0@~(B")
("vihml"	"$(0XK(B")
("viik"	"$(0Od(B")
("vikf"	"$(1:y(B")
("viks"	"$(0(O(B")
("viksf"	"$(1\7(B")
("vilb"	"$(1Ia(B")
("vile"	"$(1Ib(B")
("viln"	"$(1o"(B")
("vilmi"	"$(1_:(B")
("vimcw"	"$(0YR(B")
("viok"	"$(1.`(B")
("vitc"	"$(1Ve(B")
("vitf"	"$(1I`(B")
("viuh"	"$(1.c(B")
("vjd"	"$(0.i(B")
("vje"	"$(0+s(B")
("vjr"	"$(0.k(B")
("vjv"	"$(1)o(B")
("vjbj"	"$(1;/(B")
("vjcr"	"$(1BF(B")
("vjhw"	"$(0X@(B")
("vjii"	"$(1IV(B")
("vjka"	"$(14g(B")
("vjkp"	"$(02a(B")
("vjlo"	"$(14T(B")
("vjmc"	"$(0UQ(B")
("vjmf"	"$(14a(B")
("vjmm"	"$(1;+(B")
("vjmo"	"$(0Ea$(14b(B")
("vjnu"	"$(0;a(B")
("vjpn"	"$(1\](B")
("vjrb"	"$(1;.(B")
("vjrj"	"$(1O~(B")
("vjrr"	"$(14R(B")
("vkb"	"$(1)p(B")
("vkn"	"$(02_(B")
("vkbt"	"$(1iC(B")
("vkcf"	"$(1P!(B")
("vkmr"	"$(14i(B")
("vkms"	"$(1)h(B")
("vkok"	"$(0Eb(B")
("vlm"	"$(1!C(B")
("vlw"	"$(0.r(B")
("vlbk"	"$(1&)(B")
("vlgm"	"$(1O}(B")
("vlhbr"	"$(0X=(B")
("vlllm"	"$(1!D(B")
("vllmi"	"$(1c<(B")
("vlmc"	"$(1P)(B")
("vlmo"	"$(02c(B")
("vlmt"	"$(1\_(B")
("vlok"	"$(0*.(B")
("vloiv"	"$(0]D(B")
("vlwl"	"$(1&2(B")
("vlws"	"$(07"(B")
("vlxh"	"$(0.q(B")
("vlyta"	"$(0]A(B")
("vmg"	"$(0+h(B")
("vmi"	"$(0/R(B")
("vmj"	"$(0)n(B")
("vmt"	"$(0+q(B")
("vmv"	"$(0+j(B")
("vmam"	"$(1)f(B")
("vmbb"	"$(1\^(B")
("vmbs"	"$(1IU(B")
("vmbu"	"$(0[h(B")
("vmbdi"	"$(0;s(B")
("vmbwd"	"$(0Eq(B")
("vmfb"	"$(1\Z(B")
("vmfft"	"$(0XA(B")
("vmgg"	"$(14h(B")
("vmgow"	"$(0V<(B")
("vmhf"	"$(1B<(B")
("vmhml"	"$(1'$(B")
("vmig"	"$(02b(B")
("vmik"	"$(00n(B")
("vmlm"	"$(14Y(B")
("vmlii"	"$(1qw(B")
("vmmi"	"$(1#S(B")
("vmmp"	"$(1mK(B")
("vmmu"	"$(1#Z(B")
("vmmv"	"$(06{(B")
("vmmnr"	"$(1+x(B")
("vmoir"	"$(1Km(B")
("vmpop"	"$(1;Z(B")
("vmtq"	"$(10a(B")
("vmvi"	"$(1BG(B")
("vmvm"	"$(1.^(B")
("vmwf"	"$(0JK(B")
("vmwl"	"$(1:z(B")
("vmyf"	"$(0JM(B")
("vmym"	"$(1&/(B")
("vnd"	"$(0)p(B")
("vnf"	"$(0.s(B")
("vng"	"$(0+m(B")
("vnau"	"$(06}(B")
("vnhd"	"$(1;,(B")
("vnhs"	"$(0(E(B")
("vnin"	"$(1)l$(0+r(B")
("vnir"	"$(1)s(B")
("vnkg"	"$(1.d(B")
("vnlb"	"$(1P"(B")
("vnlr"	"$(0;d(B")
("vnme"	"$(1&V(B")
("vnmm"	"$(1B=(B")
("vnmo"	"$(1*?(B")
("vnmu"	"$(1)k(B")
("vnob"	"$(0@h(B")
("vnot"	"$(1P((B")
("vnum"	"$(1V`(B")
("vnyi"	"$(14j(B")
("vob"	"$(1#T(B")
("voq"	"$(1)r(B")
("voge"	"$(1kW(B")
("vogf"	"$(1P#(B")
("vohaf"	"$(1k8(B")
("voii"	"$(1&4(B")
("voim"	"$(1hq(B")
("voin"	"$(1#U(B")
("voll"	"$(1#V(B")
("volii"	"$(0]'(B")
("vomg"	"$(1)v(B")
("vomn"	"$(1;'(B")
("vomo"	"$(1Vb(B")
("vomr"	"$(1)m(B")
("vomt"	"$(1;&(B")
("vord"	"$(1;%(B")
("votf"	"$(0NK(B")
("vpd"	"$(0)q(B")
("vph"	"$(1&.(B")
("vpi"	"$(0)s(B")
("vpp"	"$(0+n(B")
("vpr"	"$(1&,(B")
("vptd"	"$(1:{(B")
("vpuu"	"$(1BB(B")
("vqj"	"$(1#R(B")
("vqka"	"$(1;-(B")
("vqkd"	"$(1BH(B")
("vqmb"	"$(14U(B")
("vqmf"	"$(1BI(B")
("vqmv"	"$(0;i(B")
("vrb"	"$(06w(B")
("vrp"	"$(07H(B")
("vrq"	"$(1/5(B")
("vrhaf"	"$(1a4(B")
("vrlb"	"$(1*6(B")
("vrrd"	"$(1Vf(B")
("vrrj"	"$(0NJ(B")
("vrrk"	"$(1o&(B")
("vrvk"	"$(06x(B")
("vrvif"	"$(0C=(B")
("vrye"	"$(1;0(B")
("vryo"	"$(1._(B")
("vsp"	"$(0.j(B")
("vss"	"$(1&0(B")
("vsu"	"$(0)o(B")
("vshr"	"$(1&1(B")
("vshu"	"$(06y(B")
("vshaf"	"$(1m4(B")
("vsje"	"$(14X(B")
("vskp"	"$(1IW(B")
("vsll"	"$(06z(B")
("vsmb"	"$(0;b(B")
("vsmg"	"$(1\[(B")
("vsmh"	"$(1IX(B")
("vsqf"	"$(0Ee(B")
("vsql"	"$(06v(B")
("vsrr"	"$(0JJ(B")
("vstr"	"$(1Ie(B")
("vsyi"	"$(1p7(B")
("vtm"	"$(1&((B")
("vtt"	"$(02\(B")
("vtw"	"$(1;1(B")
("vtak"	"$(1I[(B")
("vtbc"	"$(14l(B")
("vtbn"	"$(1;*(B")
("vtgk"	"$(1;)(B")
("vtgr"	"$(1P%(B")
("vthg"	"$(1Vg(B")
("vtkr"	"$(1;#(B")
("vtlf"	"$(1eK(B")
("vtlo"	"$(1Id(B")
("vtmc"	"$(1P'4W(B")
("vtmd"	"$(0@i(B")
("vtmj"	"$(1P*(B")
("vtsj"	"$(1BK(B")
("vttb"	"$(0Ed(B")
("vtvp"	"$(1Vd(B")
("vtxc"	"$(0Ec(B")
("vumb"	"$(1;3(B")
("vumi"	"$(1B?(B")
("vumj"	"$(14m(B")
("vuob"	"$(1kV(B")
("vuog"	"$(1dD(B")
("vuuk"	"$(1B>(B")
("vvf"	"$(0-%(B")
("vvv"	"$(02d(B")
("vvw"	"$(1(5(B")
("vvio"	"$(0.t(B")
("vvrau"	"$(0:U(B")
("vvwd"	"$(0<&(B")
("vwb"	"$(1;"(B")
("vwd"	"$(14Z(B")
("vwg"	"$(07!(B")
("vwk"	"$(02f(B")
("vwhaf"	"$(1hX(B")
("vwjr"	"$(14[(B")
("vwjlo"	"$(1XV(B")
("vwlk"	"$(1eI(B")
("vwlv"	"$(1V^(B")
("vwot"	"$(0Ef(B")
("vwvf"	"$(0JL(B")
("vwyi"	"$(0.l(B")
("vyg"	"$(1&&(B")
("vyk"	"$(1#Y(B")
("vyaj"	"$(14\(B")
("vybc"	"$(1;2(B")
("vycb"	"$(0JG(B")
("vyck"	"$(02^(B")
("vyfe"	"$(14k(B")
("vyhs"	"$(0+l(B")
("vyia"	"$(1P&(B")
("vymr"	"$(1.a(B")
("vypd"	"$(1IZ(B")
("vyrf"	"$(14e(B")
("vyrn"	"$(0@f(B")
("vyrv"	"$(0[i(B")
("vyso"	"$(1Ic(B")
("vytj"	"$(1IT(B")
("vytr"	"$(14d(B")
("vyvi"	"$(1&-(B")
("vywm"	"$(1V\(B")
("w"	"$(0(q(B")
("wb"	"$(05,(B")
("wc"	"$(0(?(B")
("wd"	"$(00++[(B")
("wg"	"$(0-_(B")
("wj"	"$(0'R$(1!A(B")
("wk"	"$(0)_(B")
("wl"	"$(0(s(B")
("wo"	"$(0(@(B")
("wp"	"$(03)(B")
("wr"	"$(0)`(B")
("wv"	"$(1"'(B")
("wbp"	"$(0Et(B")
("wbmbc"	"$(1dW(B")
("wcb"	"$(1#H(B")
("wche"	"$(11&(B")
("wchaf"	"$(1ox(B")
("wdhv"	"$(1@5(B")
("wdmq"	"$(0@Y(B")
("wdmbc"	"$(0X((B")
("wdnin"	"$(0JB(B")
("wdye"	"$(1<<(B")
("weee"	"$(1E-(B")
("wfq"	"$(08e(B")
("wfdq"	"$(1]`(B")
("wfgr"	"$(0Z)(B")
("wfgwc"	"$(0_C(B")
("wfik"	"$(0U=(B")
("wfip"	"$(1V=(B")
("wfiih"	"$(1p((B")
("wfjbc"	"$(1nw(B")
("wfjnu"	"$(1kF(B")
("wfklu"	"$(1kD(B")
("wflbu"	"$(1\@(B")
("wfmvu"	"$(1\A(B")
("wfmwg"	"$(1m;(B")
("wfncr"	"$(1qU(B")
("wfnin"	"$(1e/(B")
("wfoin"	"$(0U>(B")
("wfomt"	"$(1m=(B")
("wfqu"	"$(0;O(B")
("wftm"	"$(1a<(B")
("wftmv"	"$(1m<(B")
("wfuu"	"$(0X6(B")
("wfvis"	"$(0X7(B")
("wfyr"	"$(0X5(B")
("wfyrf"	"$(1kC(B")
("wfyta"	"$(0]S(B")
("wgf"	"$(0E*(B")
("wgg"	"$(0>+(B")
("wgdi"	"$(17@(B")
("wgfg"	"$(0R/(B")
("wgit"	"$(1B)(B")
("wgni"	"$(0ZP(B")
("wgnin"	"$(0?j(B")
("wgrv"	"$(0EQ(B")
("wgtj"	"$(0;Q(B")
("whd"	"$(1%q(B")
("whe"	"$(1,>(B")
("wher"	"$(0>*(B")
("whjg"	"$(1L"(B")
("wik"	"$(04N(B")
("wice"	"$(1>3(B")
("wihaf"	"$(1pr(B")
("wijb"	"$(06i(B")
("wino"	"$(0U}(B")
("wirm"	"$(0;P(B")
("wiye"	"$(1\{(B")
("wjr"	"$(0.W(B")
("wjbuc"	"$(0?L(B")
("wjhaf"	"$(1pqnu(B")
("wjii"	"$(0J7(B")
("wjnu"	"$(1E,(B")
("wjok"	"$(1\z(B")
("wkb"	"$(02M(B")
("wkp"	"$(07J(B")
("wks"	"$(0-/(B")
("wkmr"	"$(0G7(B")
("wkno"	"$(1/z(B")
("wlbi"	"$(04o(B")
("wlbm"	"$(12$(B")
("wlbnd"	"$(1?'(B")
("wlbuc"	"$(0D:(B")
("wlcwa"	"$(1^P(B")
("wldd"	"$(1F2(B")
("wleee"	"$(1F4(B")
("wlgg"	"$(187(B")
("wlggy"	"$(1F1(B")
("wlgrv"	"$(1RG(B")
("wlgtj"	"$(0GI(B")
("wlhaf"	"$(0U:(B")
("wlhhw"	"$(1R{(B")
("wlhvo"	"$(12%(B")
("wlibp"	"$(0PH(B")
("wlipf"	"$(1fJ(B")
("wlirm"	"$(1F0(B")
("wljr"	"$(09P(B")
("wljbm"	"$(0Gu(B")
("wljka"	"$(0Gx(B")
("wlklu"	"$(1F3(B")
("wlll"	"$(00x(B")
("wllmy"	"$(0Gw(B")
("wlmc"	"$(1Or(B")
("wlmf"	"$(1,o(B")
("wlmfn"	"$(1^Q(B")
("wlmym"	"$(12!(B")
("wlnih"	"$(12"(B")
("wlooo"	"$(0>9(B")
("wlpli"	"$(0HF(B")
("wlpog"	"$(0Sr(B")
("wlrb"	"$(1?&(B")
("wlrvp"	"$(12#(B")
("wlsfi"	"$(1YL(B")
("wlsqf"	"$(0PG(B")
("wltab"	"$(1fI(B")
("wltjf"	"$(0^f(B")
("wltjr"	"$(1ms(B")
("wlvff"	"$(1pJ(B")
("wlvfg"	"$(0Zd(B")
("wlvvd"	"$(1YN(B")
("wlwp"	"$(1M%(B")
("wlwtj"	"$(1YM(B")
("wlwwk"	"$(1aM(B")
("wlyg"	"$(11~(B")
("wlyaj"	"$(0Gv(B")
("wlymr"	"$(1@G(B")
("wlyrn"	"$(0LI(B")
("wlytg"	"$(1^O(B")
("wml"	"$(1(4(B")
("wmn"	"$(1$n(B")
("wmv"	"$(04L(B")
("wmmr"	"$(06j(B")
("wmso"	"$(1.L(B")
("wnd"	"$(0)a(B")
("wng"	"$(0J?(B")
("wok"	"$(04O(B")
("wop"	"$(1#GJ-(B")
("wohh"	"$(11%(B")
("woii"	"$(1%r(B")
("woll"	"$(04M(B")
("womb"	"$(140(B")
("wpp"	"$(1+L$(03w(B")
("wpu"	"$(0+\(B")
("wphh"	"$(0+](B")
("wpim"	"$(1,=(B")
("wqmb"	"$(14/(B")
("wrbc"	"$(0ER(B")
("wryw"	"$(0J8(B")
("wsvws"	"$(1\\(B")
("wtc"	"$(0>-(B")
("wtj"	"$(0>,(B")
("wumb"	"$(1:b(B")
("wvfd"	"$(1q\(B")
("wvif"	"$(0>\(B")
("wvsmm"	"$(1fM(B")
("www"	"$(1R8(B")
("wwhaf"	"$(1qm(B")
("wwlj"	"$(1VS(B")
("wwlv"	"$(1VR(B")
("wwwd"	"$(1eb(B")
("wwwf"	"$(1k{(B")
("wwwg"	"$(0X?(B")
("wwwm"	"$(0]i(B")
("wwwr"	"$(1iL(B")
("wwwu"	"$(1k|(B")
("wwwwg"	"$(1o#(B")
("wyi"	"$(0(a(B")
("wyv"	"$(1(3(B")
("wyhn"	"$(1#I(B")
("wymr"	"$(1.K(B")
("xl"	"$(1ri(B")
("xm"	"$(1rj(B")
("xaf"	"$(1rZ(B")
("xah"	"$(1rc(B")
("xao"	"$(1rm(B")
("xar"	"$(1rQ(B")
("xcf"	"$(1r_(B")
("xch"	"$(1rh(B")
("xcr"	"$(1rV(B")
("xdf"	"$(1r\(B")
("xdh"	"$(1re(B")
("xdr"	"$(1rS(B")
("xef"	"$(1rY(B")
("xeh"	"$(1rb(B")
("xer"	"$(1rP(B")
("xqf"	"$(1rW(B")
("xqh"	"$(1r`(B")
("xqo"	"$(1rk(B")
("xqr"	"$(1rN(B")
("xsf"	"$(1r[(B")
("xsh"	"$(1rd(B")
("xso"	"$(1rn(B")
("xsr"	"$(1rR(B")
("xwf"	"$(1rX(B")
("xwh"	"$(1ra(B")
("xwo"	"$(1rl(B")
("xwr"	"$(1rO(B")
("xxf"	"$(1r^(B")
("xxh"	"$(1rg(B")
("xxr"	"$(1rU(B")
("xzf"	"$(1r](B")
("xzh"	"$(1rf(B")
("xzr"	"$(1rT(B")
("y"	"$(0&4(B")
("yc"	"$(0&{(B")
("yg"	"$(0'e(B")
("yj"	"$(0'H(B")
("yk"	"$(0'G(B")
("ym"	"$(0&9(B")
("yp"	"$(1"o(B")
("yr"	"$(0(((B")
("ys"	"$(1%&(B")
("yt"	"$(0)"(B")
("yu"	"$(1%'(B")
("yv"	"$(0&B(B")
("yx"	"$(0M}(B")
("yy"	"$(0'-(B")
("yad"	"$(08&(B")
("yai"	"$(1By(B")
("yaj"	"$(0.8(B")
("yav"	"$(0:N(B")
("yahag"	"$(0Yl(B")
("yahej"	"$(1[d(B")
("yamh"	"$(1H((B")
("yano"	"$(1C|(B")
("yaog"	"$(0Rp(B")
("yapv"	"$(0I4(B")
("yarbc"	"$(0[J(B")
("yasm"	"$(0MF(B")
("yashr"	"$(0Mi(B")
("yatlk"	"$(1dT(B")
("yatoe"	"$(1oa(B")
("ybr"	"$(05c(B")
("ybaht"	"$(1dg(B")
("ybbr"	"$(0I5(B")
("ybgr"	"$(0DO(B")
("ybhg"	"$(0=-(B")
("ybhu"	"$(0YP(B")
("ybhaf"	"$(1k)(B")
("ybhne"	"$(1K3(B")
("ybik"	"$(0[y(B")
("ybjj"	"$(0I+(B")
("yblb"	"$(02u(B")
("yblbr"	"$(0@>(B")
("ybmo"	"$(1T{(B")
("ybmr"	"$(130(B")
("ybmcu"	"$(0Ku(B")
("ybmvn"	"$(1kmXU(B")
("ybnl"	"$(0I;(B")
("ybno"	"$(1K-6<(B")
("ybog"	"$(0Yc(B")
("ybok"	"$(0O.(B")
("ybou"	"$(0MD(B")
("ybuc"	"$(05X(B")
("ybye"	"$(0J~(B")
("ybyhs"	"$(07k(B")
("ybysp"	"$(0U?(B")
("yck"	"$(02V))(B")
("ycp"	"$(1r+(B")
("yct"	"$(02|(B")
("ycbr"	"$(0;9(B")
("ychaf"	"$(1k.(B")
("ychhj"	"$(0^u(B")
("yclb"	"$(02w(B")
("ycrhu"	"$(02#(B")
("ycrhv"	"$(0?6(B")
("ydl"	"$(0?[(B")
("ydbuu"	"$(0T6(B")
("ydhaf"	"$(0[X(B")
("ydhhh"	"$(1_%(B")
("ydhml"	"$(0F<(B")
("ydkni"	"$(0;j(B")
("ydlk"	"$(1T}(B")
("ydmq"	"$(0I1(B")
("ydnl"	"$(0?g(B")
("ydno"	"$(1Q;(B")
("ydog"	"$(0Yd(B")
("ydok"	"$(1Ph$(0AV(B")
("ydrrj"	"$(1hm(B")
("yec"	"$(1[Q(B")
("yeg"	"$(0UN(B")
("yep"	"$(1;c(B")
("yebu"	"$(0GG(B")
("yefd"	"$(1E{(B")
("yefh"	"$(19g(B")
("yelmm"	"$(1[c(B")
("yeoiv"	"$(0U((B")
("yeyhv"	"$(1N)(B")
("yfb"	"$(0?W(B")
("yfd"	"$(0:M(B")
("yfe"	"$(0.?(B")
("yfdq"	"$(0TY(B")
("yfhaf"	"$(1hH(B")
("yfiku"	"$(0@t(B")
("yfks"	"$(1.1(B")
("yfye"	"$(1/P(B")
("ygr"	"$(135(B")
("ygcg"	"$(0DN(B")
("yggu"	"$(1Z{(B")
("yghne"	"$(1+J(B")
("yghqu"	"$(1Wr(B")
("ygiv"	"$(0WA(B")
("ygmms"	"$(0W6(B")
("ygrv"	"$(0M@(B")
("ygsk"	"$(0QM(B")
("ygtq"	"$(0I/(B")
("yha"	"$(05e(B")
("yhe"	"$(01T(B")
("yhk"	"$(1(s(B")
("yhn"	"$(0&n(B")
("yhs"	"$(0'J$(1-W(B")
("yhv"	"$(0*i(B")
("yhaf"	"$(1Hs(B")
("yhag"	"$(0I7(B")
("yhbm"	"$(1mF(B")
("yhds"	"$(0?a(B")
("yhdv"	"$(0DR$(1T7(B")
("yhee"	"$(1j0(B")
("yhej"	"$(0?b(B")
("yheq"	"$(134(B")
("yhgr"	"$(0?`(B")
("yhhw"	"$(0MH(B")
("yhhhh"	"$(02~(B")
("yhhqm"	"$(0>)(B")
("yhiv"	"$(1ZD(B")
("yhjr"	"$(131(B")
("yhju"	"$(0I9(B")
("yhln"	"$(1O](B")
("yhml"	"$(01U(B")
("yhmo"	"$(1_o(B")
("yhmr"	"$(0:S(B")
("yhmbc"	"$(0U#$(1nD$(0Yn(B")
("yhqo"	"$(05d(B")
("yhrr"	"$(0:R(B")
("yhsb"	"$(0I6(B")
("yhsk"	"$(0Wg(B")
("yhsmm"	"$(1fL(B")
("yhus"	"$(0[1(B")
("yhvl"	"$(01S(B")
("yhxv"	"$(0HW(B")
("yhyu"	"$(0ME(B")
("yib"	"$(0-@(B")
("yif"	"$(0O^(B")
("yig"	"$(0J:(B")
("yik"	"$(1(q(B")
("yir"	"$(05g(B")
("yice"	"$(19l(B")
("yifh"	"$(1,)(B")
("yihu"	"$(0's(B")
("yihxo"	"$(1c9ae(B")
("yijb"	"$(19h(B")
("yijc"	"$(05_(B")
("yije"	"$(19i(B")
("yioj"	"$(0=|(B")
("yiohv"	"$(170(B")
("yirv"	"$(19F(B")
("yitd"	"$(0=:(B")
("yitf"	"$(0QL(B")
("yiyvi"	"$(08^(B")
("yjco"	"$(0YO(B")
("yjdl"	"$(0M?(B")
("yjhaf"	"$(1hS(B")
("yjhec"	"$(0^n(B")
("yjhee"	"$(1iS(B")
("yjhhh"	"$(0Je(B")
("yjhoj"	"$(0ZO(B")
("yjilj"	"$(0TV(B")
("yjksj"	"$(0TW(B")
("yjnl"	"$(1NR(B")
("yjrr"	"$(1@s(B")
("yjvfj"	"$(0\*(B")
("yjwj"	"$(0?Z(B")
("yjyrj"	"$(0]4(B")
("ykb"	"$(136(B")
("ykp"	"$(1&ZW#(B")
("ykq"	"$(1W5(B")
("ykr"	"$(0+>(B")
("ykanw"	"$(0\o(B")
("ykcf"	"$(0T\(B")
("ykhf"	"$(0?c(B")
("ykhg"	"$(0?d(B")
("ykhaf"	"$(1a&ppV0nn(B")
("ykhbm"	"$(1o/(B")
("ykhsb"	"$(1CD(B")
("ykmbc"	"$(1Ua(B")
("ykmpm"	"$(1<@(B")
("yknl"	"$(05h(B")
("ykok"	"$(07h(B")
("ykpb"	"$(1Tz(B")
("yksr"	"$(05`(B")
("ykvif"	"$(09D(B")
("ykymu"	"$(1rD(B")
("ylb"	"$(0(L(B")
("yle"	"$(0DM(B")
("ylm"	"$(0'P(B")
("ylw"	"$(05b(B")
("ylhv"	"$(0:0(B")
("ylmc"	"$(0T](B")
("ylmh"	"$(0,d(B")
("ylmo"	"$(0:Q(B")
("ylmr"	"$(0MC(B")
("ylnc"	"$(0)*(B")
("ymb"	"$(01:(B")
("ymd"	"$(0-S(B")
("ymg"	"$(1(n(B")
("ymp"	"$(0*;$(1#x(B")
("ymy"	"$(0('(B")
("ymbuc"	"$(1g8(B")
("ymbuu"	"$(1g#(B")
("ymcw"	"$(0:O(B")
("ymdhe"	"$(1X`b@(B")
("ymfb"	"$(0YN(B")
("ymgdi"	"$(1/}(B")
("ymhaf"	"$(1pn(B")
("ymhqu"	"$(0V"(B")
("ymihh"	"$(0FZ(B")
("ymje"	"$(00?(B")
("ymks"	"$(1O_(B")
("ymln"	"$(0E8(B")
("ymmp"	"$(0^J(B")
("ymmr"	"$(19j$(0-G(B")
("ymmbc"	"$(0^%(B")
("ymnn"	"$(13/(B")
("ymno"	"$(1Wj(B")
("ympog"	"$(0Md(B")
("ymrt"	"$(0?Y(B")
("ymrw"	"$(0I0(B")
("ymso"	"$(0?](B")
("ymuoo"	"$(0R0(B")
("ymvh"	"$(1(o(B")
("ymvm"	"$(0?^(B")
("ymwu"	"$(0QO(B")
("ynj"	"$(0-U(B")
("ynbq"	"$(0Wf(B")
("yndf"	"$(0MB(B")
("ynhb"	"$(1Z|(B")
("ynhv"	"$(19E(B")
("ynib"	"$(0?X(B")
("ynin"	"$(133(B")
("yniv"	"$(1@4(B")
("ynmbc"	"$(1Hf(B")
("ynnl"	"$(1%((B")
("ynot"	"$(1Z~(B")
("ynui"	"$(0DP(B")
("yog"	"$(0DQ(B")
("yoj"	"$(1(r(B")
("yon"	"$(0-V(B")
("yobuc"	"$(1Gc(B")
("yodv"	"$(0Pp(B")
("yohne"	"$(0OG(B")
("yoks"	"$(0.4(B")
("yoln"	"$(0.,N*(B")
("yomd"	"$(0?e(B")
("yomn"	"$(0I8(B")
("yombc"	"$(1Ub(B")
("yonk"	"$(0.`(B")
("yono"	"$(1/x(B")
("yooj"	"$(0.6(B")
("yopd"	"$(05f(B")
("ypa"	"$(132(B")
("ypc"	"$(1O$(B")
("ypd"	"$(0-T8)(B")
("ypg"	"$(0Z/(B")
("ypr"	"$(1)K(B")
("ypt"	"$(1-U(B")
("ypu"	"$(1(p(B")
("ypbu"	"$(17T(B")
("ypbuc"	"$(0Hu(B")
("yphu"	"$(01N(B")
("yphaf"	"$(1r)pm(B")
("yphen"	"$(0?)(B")
("yphfd"	"$(19#(B")
("ypks"	"$(1\K(B")
("yplmi"	"$(1n!(B")
("ypmk"	"$(1kN(B")
("ypmm"	"$(0-i(B")
("ypmr"	"$(1kq7](B")
("ypmmf"	"$(1mE7f(B")
("ypmrb"	"$(1[~(B")
("ypmso"	"$(1G_(B")
("ypnbg"	"$(1GK(B")
("ypnwf"	"$(1a!(B")
("ypobo"	"$(1?0(B")
("ypoiv"	"$(1Uj(B")
("ypph"	"$(19"(B")
("yprvk"	"$(0H?(B")
("ypsj"	"$(0]o(B")
("ypsm"	"$(05M(B")
("yptc"	"$(0^4(B")
("yptm"	"$(0Cq(B")
("yptmc"	"$(1M](B")
("ypuv"	"$(19G(B")
("ypvif"	"$(0C<(B")
("ypwb"	"$(0PP(B")
("ypwp"	"$(0Ne(B")
("ypwbt"	"$(0SN(B")
("ypwks"	"$(0H@(B")
("ypwlb"	"$(1R[(B")
("ypyk"	"$(0:&(B")
("ypybp"	"$(1rF(B")
("ypyhv"	"$(0]r(B")
("ypymr"	"$(0Hl$(1oR(B")
("yqhl"	"$(0?\(B")
("yrf"	"$(0-l(B")
("yrj"	"$(05U(B")
("yrm"	"$(0:8(B")
("yru"	"$(0)':9(B")
("yry"	"$(05W(B")
("yrav"	"$(1G?(B")
("yramo"	"$(1ZS(B")
("yranb"	"$(1g-(B")
("yranw"	"$(1pR(B")
("yrapv"	"$(0TA(B")
("yrawe"	"$(1cQ(B")
("yrbb"	"$(0LR(B")
("yrbm"	"$(0D)(B")
("yrbn"	"$(01i(B")
("yrbo"	"$(0M1(B")
("yrbp"	"$(06"(B")
("yrbr"	"$(0:n$(1@B(B")
("yrbu"	"$(0=F1j(B")
("yrbbn"	"$(0\E(B")
("yrbgr"	"$(0P~(B")
("yrbhn"	"$(1ps(B")
("yrbjj"	"$(1ZL(B")
("yrbln"	"$(1fk(B")
("yrbme"	"$(0TG(B")
("yrbmr"	"$(1GR(B")
("yrbou"	"$(0WL(B")
("yrbsd"	"$(0Q#(B")
("yrbtn"	"$(0Zh(B")
("yrbuu"	"$(1@8(B")
("yrbvk"	"$(1_O(B")
("yrbvn"	"$(0RP(B")
("yrbwn"	"$(1l!(B")
("yrci"	"$(0?E(B")
("yrcmt"	"$(1ZW(B")
("yrcru"	"$(0M*(B")
("yrdd"	"$(1TL(B")
("yrdi"	"$(0:7(B")
("yrdk"	"$(0?A(B")
("yrdhe"	"$(0D/(B")
("yrdmq"	"$(0T;(B")
("yrdoo"	"$(1TM(B")
("yrdwf"	"$(0T:(B")
("yrea"	"$(1TF(B")
("yrfb"	"$(0M/(B")
("yrff"	"$(0Pv(B")
("yrfh"	"$(19P(B")
("yrfq"	"$(1@I(B")
("yrfbf"	"$(0_;(B")
("yrgg"	"$(1GO(B")
("yrgp"	"$(0M#(B")
("yrgr"	"$(0H_(B")
("yrgcr"	"$(1r9(B")
("yrgdi"	"$(0H^(B")
("yrggu"	"$(1g((B")
("yrgni"	"$(1l>(B")
("yrgrr"	"$(0[#(B")
("yrgwc"	"$(0]u(B")
("yrhg"	"$(0?_(B")
("yrhk"	"$(19Q(B")
("yrhp"	"$(0:;(B")
("yrhs"	"$(0D*(B")
("yrhv"	"$(028(B")
("yrhag"	"$(1Z[(B")
("yrhdn"	"$(1cY(B")
("yrhds"	"$(0M-(B")
("yrhdv"	"$(0P|(B")
("yrhdw"	"$(1g1(B")
("yrher"	"$(0Hk(B")
("yrhge"	"$(1j%(B")
("yrhgr"	"$(0M+(B")
("yrhgu"	"$(1GU(B")
("yrhhi"	"$(0WM(B")
("yrhhj"	"$(1TI(B")
("yrhjd"	"$(0He(B")
("yrhjm"	"$(1ZU(B")
("yrhjr"	"$(0Hd(B")
("yrhkb"	"$(1g/(B")
("yrhml"	"$(0?G(B")
("yrhmr"	"$(0Hi(B")
("yrhmy"	"$(0D,(B")
("yrhne"	"$(0?D(B")
("yrhni"	"$(0TC(B")
("yrhor"	"$(1g2(B")
("yrhpa"	"$(1TO(B")
("yrhpm"	"$(0D+(B")
("yrhqo"	"$(1@D(B")
("yrhsb"	"$(1ZV(B")
("yrhsm"	"$(1_Y(B")
("yrhuc"	"$(0_5(B")
("yrhwp"	"$(1cS(B")
("yrhxe"	"$(1_S(B")
("yrhxo"	"$(0Q&(B")
("yrhxu"	"$(1TN(B")
("yrhyu"	"$(1_U(B")
("yrii"	"$(1TB(B")
("yrir"	"$(1@F(B")
("yrit"	"$(0M'(B")
("yriav"	"$(1N8(B")
("yrihr"	"$(1ZN(B")
("yrihs"	"$(0Hc(B")
("yrijb"	"$(0M0(B")
("yrijc"	"$(1@?(B")
("yrikk"	"$(1@@(B")
("yriku"	"$(19O(B")
("yrill"	"$(1GM(B")
("yrine"	"$(0D#(B")
("yriok"	"$(1N7(B")
("yrior"	"$(0T?(B")
("yripm"	"$(0H](B")
("yritc"	"$(1j$(B")
("yritf"	"$(1cV(B")
("yrjp"	"$(1@H(B")
("yrjr"	"$(0D'(B")
("yrjbc"	"$(1_[(B")
("yrjbd"	"$(1N9(B")
("yrjbj"	"$(1ZO(B")
("yrjbm"	"$(0Pt(B")
("yrjhp"	"$(0HZ(B")
("yrjhw"	"$(1n+(B")
("yrjip"	"$(1g*(B")
("yrjka"	"$(0Pz(B")
("yrjmm"	"$(1ZK(B")
("yrkb"	"$(1GX(B")
("yrkf"	"$(0Ha(B")
("yrkhg"	"$(0M.(B")
("yrkja"	"$(1cN(B")
("yrkms"	"$(0H`(B")
("yrln"	"$(06J(B")
("yrlll"	"$(0:<(B")
("yrlmo"	"$(1GS(B")
("yrlmy"	"$(0Q%(B")
("yrlwv"	"$(1cR(B")
("yrmd"	"$(0:>(B")
("yrmj"	"$(0:6(B")
("yrmn"	"$(05V(B")
("yrmbs"	"$(1cJ(B")
("yrmdm"	"$(1oS(B")
("yrmfj"	"$(0D$(B")
("yrmhf"	"$(1_Z(B")
("yrmjk"	"$(1g)(B")
("yrmmr"	"$(0M$(B")
("yrmmv"	"$(1N4(B")
("yrmnr"	"$(0D.(B")
("yrmoo"	"$(0M%(B")
("yrmrw"	"$(1ZX(B")
("yrmso"	"$(1TC(B")
("yrmua"	"$(1g+(B")
("yrmvh"	"$(0?@(B")
("yrmvm"	"$(1N5(B")
("yrmvn"	"$(1E((B")
("yrmwf"	"$(1cX(B")
("yrmwg"	"$(1ZM(B")
("yrmwj"	"$(0Z~(B")
("yrmym"	"$(0D&(B")
("yrnd"	"$(0-k(B")
("yrnf"	"$(0=o(B")
("yrnj"	"$(0::(B")
("yrnl"	"$(0?f(B")
("yrnn"	"$(0*m(B")
("yrnbe"	"$(1n)(B")
("yrncr"	"$(0\D(B")
("yrnhb"	"$(0[!(B")
("yrnhx"	"$(0P}(B")
("yrnib"	"$(0M"(B")
("yrnin"	"$(1GV(B")
("yrnir"	"$(1GY(B")
("yrnkm"	"$(0Px(B")
("yrnlp"	"$(1pQ(B")
("yrnmu"	"$(0Hf(B")
("yrnob"	"$(1ZP(B")
("yrnot"	"$(0Z}(B")
("yrnqd"	"$(1_Q(B")
("yrnri"	"$(0^k(B")
("yrnyi"	"$(1TA(B")
("yrob"	"$(0?B(B")
("yrog"	"$(0Q!(B")
("yroj"	"$(0?C(B")
("yrok"	"$(1<>(B")
("yron"	"$(0:=(B")
("yrop"	"$(0?F(B")
("yroge"	"$(1_R(B")
("yrogf"	"$(0[$(B")
("yrohh"	"$(0D-(B")
("yroii"	"$(1@E(B")
("yroim"	"$(0^l(B")
("yroip"	"$(1TG(B")
("yroir"	"$(1_T(B")
("yromb"	"$(0Q"(B")
("yromg"	"$(0Hh(B")
("yromn"	"$(0TD(B")
("yromo"	"$(1j"(B")
("yrotf"	"$(1g.(B")
("yrowy"	"$(0M,(B")
("yrpa"	"$(0HgHb(B")
("yrpd"	"$(0:?(B")
("yrpt"	"$(1@>(B")
("yrpu"	"$(19N(B")
("yrpht"	"$(0WO(B")
("yrpko"	"$(1l@(B")
("yrppa"	"$(0T>(B")
("yrptd"	"$(0T=(B")
("yrpuu"	"$(1_P(B")
("yrqd"	"$(1GT(B")
("yrqjp"	"$(1n,(B")
("yrqmb"	"$(0Py(B")
("yrqmc"	"$(1cW(B")
("yrqmv"	"$(1TK(B")
("yrru"	"$(1Z}(B")
("yrrv"	"$(0WC(B")
("yrrrd"	"$(0\C(B")
("yrrrj"	"$(1g0(B")
("yrrrs"	"$(1ZR(B")
("yrrsj"	"$(1ZY(B")
("yrruc"	"$(1g,(B")
("yrrvk"	"$(0M)(B")
("yrrxu"	"$(1i~(B")
("yrss"	"$(1@=(B")
("yrsu"	"$(0:5(B")
("yrshi"	"$(13"(B")
("yrshr"	"$(0D((B")
("yrsim"	"$(1l?(B")
("yrsip"	"$(0M&(B")
("yrsje"	"$(1T?(B")
("yrsjj"	"$(1q>(B")
("yrsma"	"$(1cM(B")
("yrsmg"	"$(1GN(B")
("yrsmh"	"$(0YA(B")
("yrsmm"	"$(1GP(B")
("yrsmr"	"$(0D%(B")
("yrsrr"	"$(1cK(B")
("yrsup"	"$(1N6(B")
("yrsyj"	"$(1_M(B")
("yrtm"	"$(1@J(B")
("yrtq"	"$(0H\(B")
("yrtt"	"$(1GW(B")
("yrtak"	"$(0Y?(B")
("yrtav"	"$(1i}(B")
("yrtbm"	"$(1n'(B")
("yrtca"	"$(0Z{(B")
("yrtct"	"$(1_\(B")
("yrtgi"	"$(0\?(B")
("yrtkr"	"$(0T@(B")
("yrtlf"	"$(1oP(B")
("yrtlm"	"$(0Y@(B")
("yrtmc"	"$(1T@(B")
("yrtmd"	"$(0T<(B")
("yrtmj"	"$(0Zz(B")
("yrtmv"	"$(0TF(B")
("yrtoe"	"$(0]-(B")
("yrtrg"	"$(1q?(B")
("yrttb"	"$(0WJ(B")
("yrtwi"	"$(1g&(B")
("yrtwv"	"$(1j!(B")
("yrtxc"	"$(0WI(B")
("yrtyu"	"$(0WK(B")
("yruc"	"$(0TZ(B")
("yruu"	"$(1@C(B")
("yrumb"	"$(1ZZ(B")
("yrvii"	"$(0["(B")
("yrvis"	"$(1@K(B")
("yrwb"	"$(0TB(B")
("yrwd"	"$(0P{(B")
("yrwp"	"$(1ZT(B")
("yrwce"	"$(1_N(B")
("yrwlj"	"$(0\B(B")
("yrwww"	"$(1n((B")
("yrye"	"$(1*i$(0I2(B")
("yryg"	"$(0D"(B")
("yryr"	"$(1@A(B")
("yrybb"	"$(0T8(B")
("yrybk"	"$(1qx(B")
("yrybs"	"$(0WH(B")
("yrycb"	"$(0YB$(1cH(B")
("yryck"	"$(0Hm(B")
("yrydk"	"$(1g'(B")
("yryfd"	"$(0WG(B")
("yryfe"	"$(1TD(B")
("yryhh"	"$(0T9(B")
("yryhs"	"$(0??(B")
("yryia"	"$(0Z|(B")
("yryjj"	"$(1cL(B")
("yrylr"	"$(0],(B")
("yrymp"	"$(1GQ(B")
("yryoj"	"$(0Q$(B")
("yrypd"	"$(1cP(B")
("yrypm"	"$(1ZQcO(B")
("yrypu"	"$(1TE(B")
("yryrb"	"$(1_L(B")
("yryrd"	"$(0Pw(B")
("yryrf"	"$(0Pu(B")
("yryro"	"$(1l=(B")
("yryrv"	"$(0^j(B")
("yryta"	"$(0TE(B")
("yryub"	"$(1cI(B")
("yryvo"	"$(0H[(B")
("yrywm"	"$(1i|(B")
("ysm"	"$(1!0(B")
("ysp"	"$(1-V(B")
("ysfv"	"$(1Z@(B")
("yshr"	"$(05a(B")
("ysmvn"	"$(1,:(B")
("ysnl"	"$(1%)(B")
("ysok"	"$(0/t(B")
("ysoy"	"$(0/v(B")
("ysoby"	"$(1/S(B")
("ysofb"	"$(1CE(B")
("ysohc"	"$(1h}(B")
("ysohl"	"$(1/U(B")
("ysohm"	"$(0=#(B")
("ysohn"	"$(1'%(B")
("ysohu"	"$(1/T(B")
("ysohv"	"$(07l(B")
("ysohw"	"$(1af(B")
("ysojb"	"$(1/R(B")
("ysokr"	"$(0K#(B")
("ysolo"	"$(1<D(B")
("ysomf"	"$(1\}(B")
("ysond"	"$(1*l(B")
("ysono"	"$(0="(B")
("ysooa"	"$(1eX(B")
("ysooi"	"$(15k(B")
("ysook"	"$(0=!(B")
("ysopd"	"$(03M(B")
("ysosp"	"$(0=$(B")
("ysotc"	"$(0K"(B")
("ysoyu"	"$(1<E(B")
("ysrj"	"$(0Wb(B")
("ysyq"	"$(0T[(B")
("ysyoo"	"$(1eW(B")
("yta"	"$(05x(B")
("yti"	"$(0Ub(B")
("ytj"	"$(0-Q(B")
("ytk"	"$(0:K(B")
("ytt"	"$(0:T(B")
("ytu"	"$(0:L(B")
("ytv"	"$(0.f(B")
("ytaj"	"$(0?~(B")
("ytap"	"$(0Eu(B")
("ytahu"	"$(0@!(B")
("ytapv"	"$(0L&(B")
("ytbsd"	"$(1El(B")
("ytcw"	"$(1H'(B")
("ytdl"	"$(1>b(B")
("ythu"	"$(0I-(B")
("ythaf"	"$(1r(\0(B")
("ythni"	"$(0Ml(B")
("ytice"	"$(0C+(B")
("ytjki"	"$(1>c(B")
("ytki"	"$(1,c(B")
("ytkr"	"$(1H+(B")
("ytmbc"	"$(0_.(B")
("ytog"	"$(1Ty(B")
("ytpo"	"$(0I.(B")
("ytpr"	"$(11a(B")
("ytqmb"	"$(0I](B")
("ytsmm"	"$(18<(B")
("ytstt"	"$(1LV(B")
("yttb"	"$(0MA(B")
("ytumb"	"$(0L'(B")
("ytwa"	"$(0QN(B")
("ytwb"	"$(0We(B")
("ytwg"	"$(0C*(B")
("ytwi"	"$(0TX(B")
("ytyr"	"$(09=(B")
("yue"	"$(1VG(B")
("yup"	"$(1aB(B")
("yuav"	"$(0]V(B")
("yubm"	"$(0\`(B")
("yubuc"	"$(1oU(B")
("yubuu"	"$(1T:(B")
("yudi"	"$(0RS(B")
("yuhaf"	"$(1o|(B")
("yuhhh"	"$(0?*(B")
("yuhlb"	"$(0_"(B")
("yuhml"	"$(1hj(B")
("yuhxu"	"$(1p4(B")
("yuii"	"$(1Z&(B")
("yuir"	"$(1kL(B")
("yujbc"	"$(1qY(B")
("yukb"	"$(17g(B")
("yukmr"	"$(1p3(B")
("yulwp"	"$(1mC(B")
("yumb"	"$(1H)(B")
("yummr"	"$(0^2(B")
("yumvh"	"$(1hi(B")
("yuon"	"$(1e9(B")
("yuoii"	"$(0\b(B")
("yuolf"	"$(1qt(B")
("yuoll"	"$(1hk(B")
("yupr"	"$(0\a(B")
("yupt"	"$(1kI(B")
("yupru"	"$(1kM(B")
("yupuu"	"$(1qZ(B")
("yurc"	"$(1kK(B")
("yurrs"	"$(1p}(B")
("yuryo"	"$(0^3(B")
("yushr"	"$(1kJ(B")
("yusje"	"$(1p1(B")
("yusmg"	"$(0_!(B")
("yuta"	"$(1p2(B")
("yutm"	"$(1E+(B")
("yutct"	"$(1qX(B")
("yuwd"	"$(1n|(B")
("yuwlb"	"$(1p|(B")
("yuyhh"	"$(1p{(B")
("yuymp"	"$(0]U(B")
("yuypu"	"$(1Z'(B")
("yuytu"	"$(0\$(B")
("yvb"	"$(0LV-;(B")
("yvd"	"$(0,c(B")
("yvi"	"$(0(i(B")
("yvp"	"$(0,4(B")
("yvv"	"$(0)m(B")
("yvbq"	"$(0=u(B")
("yvbu"	"$(00~(B")
("yvbcr"	"$(0HO(B")
("yvgg"	"$(0RM(B")
("yvgn"	"$(0Xh(B")
("yvgu"	"$(1fG(B")
("yvgv"	"$(1nG(B")
("yvhg"	"$(0IU(B")
("yvho"	"$(0)+(B")
("yvhbt"	"$(1-L(B")
("yvhlu"	"$(1";(B")
("yvhvo"	"$(0]h(B")
("yviw"	"$(08g(B")
("yvks"	"$(1e=(B")
("yvne"	"$(1@u(B")
("yvnl"	"$(1"q(B")
("yvrvp"	"$(00A(B")
("yvvv"	"$(0-W[2(B")
("ywr"	"$(0:P(B")
("yws"	"$(1#4(B")
("ywdv"	"$(0Lz(B")
("ywgv"	"$(1rI(B")
("ywii"	"$(0@&(B")
("ywihr"	"$(0\\(B")
("ywlb"	"$(0I3(B")
("ywle"	"$(0MG(B")
("ywlg"	"$(0^K(B")
("ywlv"	"$(0Wd$(1ZC(B")
("ywmv"	"$(0:/(B")
("ywnl"	"$(1H,(B")
("ywno"	"$(08f(B")
("ywomo"	"$(0^|(B")
("ywrd"	"$(0Gc(B")
("ywrm"	"$(1AY(B")
("ywtqm"	"$(1m9(B")
("yxf"	"$(1e8$(0X:(B")
("yxbt"	"$(1hh(B")
("yxbuc"	"$(1mB(B")
("yxln"	"$(0R9(B")
("yxlmm"	"$(1p0(B")
("yyr"	"$(1-X(B")
("yyaj"	"$(1@t(B")
("yybc"	"$(1H*(B")
("yycb"	"$(0QK(B")
("yyhn"	"$(1(m(B")
("yymr"	"$(0?V(B")
("yypo"	"$(0Wc(B")
("yysd"	"$(0I,(B")
("yytj"	"$(1T|(B")
("yywm"	"$(1_n(B")
("yyws"	"$(19k(B")
;v "z\,"	"$(0!"!#!.!/(B")
;v "z\."	"$(0!%!$!&!0!1(B")
("z\;"	"$(0!'!2!"!#!.!/(B")
("z\:"	"$(0!(!+!3!%!$!&!0!1(B")
("z\'"	"$(0!e!d(B")
("z\""	"$(0!g!f!h!i!q(B")
("z\\"	"$(0"`"b#M(B")
("z\|"	"$(0!6!8!:"^(B")
("z\/"	"$(0"_"a#L(B")
("z\?"	"$(0!)!4(B")
("z\<"	"$(0!R"6"A!T"H(B")
("z\>"	"$(0!S"7"B!U(B")
("z\["	"$(0!F!J!b!H!L!V!Z!X!\(B")
("z\]"	"$(0!G!K!c!I!M!W![!Y!](B")
("z\{"	"$(0!B!`!D(B ")
("z\}"	"$(0!C!a!E(B")
("z\`"	"$(0!j!k(B")
("z\~"	"$(0"D"+",!<!=(B")
("z\!"	"$(0!*!5(B")
("z\@"	"$(0"i"n(B")
("z\#"	"$(0!l"-(B")
("z\$"	"$(0"c"l(B")
("z\%"	"$(0"h"m(B")
("z\&"	"$(0!m".(B")
("z\*"	"$(0!n"/!o!w!x(B")
("z\("	"$(0!>!^!@(B")
("z\)"	"$(0!?!_!A(B")
("z\-"	"$(0!7!9"#"$"1"@(B")
("z\_"	"$(0"%"&(B")
("z\="	"$(0"8"C(B")
("z\+"	"$(0"0"?(B")
)
