
#include "bitmap.h"

/**************************************************************************
 *
 * METHOD:	WRITE AS GIF
 *
 * FUNCTION:	Write out the bitmap as a GIF file
 *
 * PARAMETERS:	The filename
 *
 * RETURNS:	Nil
 *
 *************************************************************************/ 

static Bitmap *the_bitmap;

static 
int M_W_GIFPixel( x, y )
int x, y;
{
	int c;

	c = Bitmap_Get( the_bitmap, x, y );
	return c;
}

#define MAX_COLORS 256

static int g_red[ MAX_COLORS ], g_green[ MAX_COLORS ], g_blue[ MAX_COLORS ];

Bitmap_WriteAsGIF( bitmap, fname, interlace )
Bitmap *bitmap;		/* Pointer to the bitmap area */
char *fname;
int interlace;
{
	int i;
	the_bitmap = bitmap;

	for( i=0; i<bitmap->BColors; i++ ) {
		g_red[i] = bitmap->pal[i].red;
		g_green[i] = bitmap->pal[i].green;
		g_blue[i] = bitmap->pal[i].blue;
	}

	GIFEncode( fname, bitmap->BWidth, bitmap->BHeight, interlace, 0,
		bitmap->BBits, g_red, g_green, g_blue, M_W_GIFPixel );

}
