/*
 File: CrossTable.c
 Author: K.R. Sloan
 Last Modified: 17 December 1992
 Purpose: print CrossTable
 */
#include <stdio.h>
#include <strings.h>
#include <malloc.h>
#include "Header.h"
#include "PairingCards.h"

extern VERBOSE;

static int Center(s,str,w)
 FILE *s;
 char *str;
 int w;
 {
  int l,pad,p;

  l = strlen(str);
  pad = (w-l)/2;
  for(p=0;p<pad;p++)fprintf(s," ");
  fprintf(s,"%s",str);
 }

static PlayerType *P;
static double *Score;
static int *Index;
static int *ReverseIndex;

static int CTCompare(i,j)
 int *i, *j;
 {
  if (Score[*i] < Score[*j]) return(-1);
  if (Score[*i] > Score[*j]) return( 1);
  if (P[*i].Ro  < P[*j].Ro ) return(-1);
  if (P[*i].Ro  > P[*j].Ro ) return( 1);
  return(0);
 } 

int CrossTable(s,PLAYERS,ROUNDS,GAMES,PairingCards)
 FILE *s;
 int PLAYERS;
 int ROUNDS;
 int GAMES;
 PlayerType *PairingCards;
 {
  int p,r;
  double ThisScore;
  char N[NameLength], V[ValueLength];

  P = PairingCards; /* pass to sorting comparison routine */  

  if (!(Score = (double *)malloc(PLAYERS*sizeof(double))))
   {
    fprintf(stderr,"CrossTable: no memory for Score");
    exit(-1);
   }
  if (!(Index = (int *)malloc(PLAYERS*sizeof(int))))
   {
    fprintf(stderr,"CrossTable: no memory for Index");
    exit(-1);
   }
  if (!(ReverseIndex = (int *)malloc(PLAYERS*sizeof(int))))
   {
    fprintf(stderr,"CrossTable: no memory for ReverseIndex");
    exit(-1);
   }

  /* Score */
  for(p=0;p<PLAYERS;p++)
   {
    PlayerType *PC;
    double score;

    score = 0.0;
    PC = &(PairingCards[p]);
    for(r=0;r<ROUNDS;r++)
     {
      GameType *G;
      int o;

      G = &(PC->Games[r]);
      o = G->Opponent;
      if (0 <= o)
       { /* played */
        switch(G->Result)
         {
          case 'W': score += 1.0; break;
          case 'D': score += 0.5; break;
          default:            break;
         }
       }
      else
       { /* unplayed */
        switch(G->Result)
         {
          case 'B': score += 1.0; break;
          case 'H': score += 0.5; break;
          default:            break;
         }
       }
     }
    Score[p] = score;
   }
  for(p=0;p<PLAYERS;p++) Index[p] = p;
  qsort((char *)Index,PLAYERS,sizeof(int),CTCompare);

  for(p=0;p<PLAYERS;p++) ReverseIndex[Index[p]] = p;

  fprintf(s,"\n");
  strcpy(N,"TOURNAMENT");
  if (SUCCESS == GetDescriptor(N,V))
   { Center(s,V,72);   fprintf(s,"\n"); }
  strcpy(N,"DATE");
  if (SUCCESS == GetDescriptor(N,V))
   { Center(s,V,72);   fprintf(s,"\n"); }
  strcpy(N,"SECTION");
  if (SUCCESS == GetDescriptor(N,V))
   { Center(s,V,72);   fprintf(s,"\n"); }


  fprintf(s,"Player                   Prev Perf Post");
  if (GAMES)
   for(r=0;r<ROUNDS;r++)
    fprintf(s," R%02d ",r+1);
  fprintf(s, " Score\n");
  for(p=0;p<PLAYERS;p++)
   {
    PlayerType *PC;
    int i;

    i = Index[PLAYERS-p-1]; /* print in decreasing order */

    PC = &(PairingCards[i]);
    fprintf(s,"%3d %20.20s %04d %04d %04d",
            p+1,PC->Name,PC->Ro,PC->Rp,PC->Rn);
    if (GAMES)
     for(r=0;r<ROUNDS;r++)
      {
       int opponent;

       fprintf(s," %c",PC->Games[r].Result);
       if (0 <= (opponent = PC->Games[r].Opponent))
        fprintf(s,"%03d",PLAYERS-ReverseIndex[opponent]);
       else
        fprintf(s,"   ");
      }
    fprintf(s," %4.1f\n",Score[i]);
   }

  free((char *) ReverseIndex);
  free((char *) Index);
  free((char *) Score);
  return(0);
 }
