/*
  File: Header.c
  Authors: K.R. Sloan,
  Last Modified: 16 September 1992
  Purpose: ASCII Headers for various file types
           We provide a general Name-Value pair database, plus
            a routine to read  NV-pairs from the beginning of an ASCII file
 */
#include <stdio.h>
#include <strings.h>
#include "Header.h"

extern int VERBOSE;

typedef struct
 {
  char Name[NameLength];
  char Value[ValueLength];
 } NVtype;

/*
  our little database
 */
static NVtype NV[MaxNV];

static int
FindByName(ThisName)
 char *ThisName;
 {
  char s[NameLength];
  int i;

  for (i=0; i<MaxNV; i++) /* look for match */
   if (0 == strcmp(NV[i].Name, ThisName)) return(i);
  for (i=0; i<MaxNV; i++) /* else return empty slot */
   if ('\0' == NV[i].Name[0]) return(i);
 }

int
InitHeader()
 {
  int i;
  for(i=0;i<MaxNV;i++)
   { NV[i].Name[0] = '\0'; NV[i].Value[0] = '\0';}
  return(SUCCESS);
 }

int 
ReadHeader(FileDesc)
 FILE *FileDesc;
 {
  int i,N;
  char Name[NameLength], Value[ValueLength], c;

  for(N=0;N<MaxNV;N++)
   {
    c = getc(FileDesc);
    if ( ferror(FileDesc) || feof(FileDesc) )
     {
      fprintf(stderr,"ReadHeader: error?\n");
      return(FAILURE);
     }
    if ('\f' == c) break;
    if ('%'  == c)
     { /* ignore comments */
      fscanf(FileDesc,"%*[^\n]");
      fscanf(FileDesc,"%*c");
      N--; 
     }
    else
     {
      Name[0] = c;
      if (1 != fscanf(FileDesc,"%s",&Name[1]))
       {
         fprintf(stderr,"ReadHeader: error!\n");
         return(FAILURE);
       }
      fscanf(FileDesc," %[^\n]%c",Value,&c);
      SetDescriptor(Name,Value);
     }
   }
  for(;'\f' != c;)
   {
    c = getc(FileDesc);
    if (ferror(FileDesc) || feof(FileDesc))
     {
      fprintf(stderr,"ReadHeader: error?\n");
      return(FAILURE);
     }
   }

  for (;N<MaxNV;N++)
   { 
    NV[N].Name[0] = '\0';
    NV[N].Value[0] = '\0';
   }
  return(SUCCESS);
 }

int SetDescriptor(Name, Value)
 char *Name;
 char *Value;
 {
  int i;
  i = FindByName(Name);
  strcpy(NV[i].Name, Name);
  strcpy(NV[i].Value, Value);
  if (VERBOSE)
   fprintf(stderr,"SetDescriptor(%s,%s) put in slot %d\n",Name,Value,i);
  return(SUCCESS);
 }
 
int GetDescriptor(Name, Value)
 char *Name;
 char *Value;
 {
  int i;
  i = FindByName(Name);
  if (0 != strcmp(NV[i].Name, Name)) return(FAILURE);
  strcpy(Value, NV[i].Value);
  if (VERBOSE)
   fprintf(stderr,"GetDescriptor(%s,%s) found in slot %d\n",Name,Value,i);
  return(SUCCESS);
 }

int GetDescriptorN(N, Name, Value)
 int N; 
 char *Name;
 char *Value;
 {
  int i;

  strcpy(Name, NV[N].Name);
  strcpy(Value, NV[N].Value);
  return(SUCCESS);
 }
