/*****************************************************************************/
/* module count.c							     */
/*									     */
/* Author: Krassimir TODOROV						     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   August 1989							     */
/* Modifications:							     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <math.h>

#include "define.h"
#include "global.h"
#include "structure.h"
#include "type.h"

#define MY_DEBUG

#ifdef MY_DEBUG
static void
Stop()
{
    int             I = 0;
}
#define Test_Error(error)				    \
{if (error) {fprintf(stderr,"%cERROR at line %d in %s!\n",  \
		    7,__LINE__,__FILE__); Stop();}}
#else
#define Test_Error(error)
#endif

#define max(x,y) (((x) > (y)) ? (x) : (y))
#define min(x,y) (((x) < (y)) ? (x) : (y))
#define abs(x) (((x) < 0) ? (-x) : (x))

#define MAGIC_1	    11
#define MAGIC_2	    22
#define CONN8	    2
#define BACKGR	    1
#define VIDE 0			/* Couleur des pixels vides    : a ne pas
				 * modifier !! */
#define CONTOUR_C 0xffff	/* Couleur des pixels contours : a ne pas
				 * modifier !! */

#define MAX_OBJETS CONTOUR_C-1	/* nombre maximal d' objets enregistres */

static Frame    frame_cut, frame_count;
static Panel    panel_cut, panel_count;
static Panel_item Xmin_i, Xmax_i, Ymin_i, Ymax_i;
static Panel_item Smin, Xet, Yet, Set, Sfn;
static int      flag_regime, Vide_x, cut_plan;
int            *Histogramme[MAX_IMAGE];

extern struct fname *fname_panel();

static struct ligne
{				/* Structre de remplissage d'une ligne : */
    short           X, Y, Min, Max;	/* passe par X et Y et va de XMin a
					 * XMax */
};

static int      Hist[CONTOUR_C];/* Tableau temporaire pour le stocage des
				 * tailles des objets */

static unsigned short *VRAM_SAVE;	/* Pointeur vers l'image a traiter */

static int      Couleur_Courante = 0;	/* Compteur de la couleur courante */
static int      Conn8;		/* Flag de remplissage en connectivite 8 */
static unsigned int Taille_Objet_Courant;
static int      XXMax, YYMax;	/* Taille de l'image */

extern char *paneltabs[];
extern char *mastertabs[];
extern char *labeltabs[];

extern void hproc_fill_bc8();
extern void hproc_fill_bc4();
extern void hproc_fill_cc8();
extern void hproc_fill_cc4();
extern void hproc_sauver_objets_comptes();
extern void hproc_decoupages();





/*****************************************************************************/
/* unsigned int Adresse(X,Y)  calcule le deplacement pour le pixel en X et Y*/
/*     entree : Coordonnees X et Y en pixels                                */
/*     sortie : deplacement dans la memoire correspondant                   */

/*****************************************************************************/
static unsigned int
Adresse(X, Y)
    unsigned int    X, Y;
{
    return ((unsigned int) ((unsigned int) XXMax * Y + X));

}


/*****************************************************************************/

static          Panel_setting
lire_count(item, event)
    Panel_item      item;
    Event          *event;

{
    static struct count_s counts;
    if (event_id(event) == CTRLC)
    {
	/* demande d'interruption de l'interaction par l'utilisateur */
	flag_break = TRUE;
	window_return(NULL);
	window_destroy(frame_count);
	return ((Panel_setting) 0);
    } else
    {
	if (event_id(event) == '\t')
	    return (PANEL_NEXT);
	else
	{
	    if (panel_get(Smin, PANEL_VALUE) != NULL)
		counts.SMin = atoi((char *) panel_get(Smin, PANEL_VALUE));
	    if (panel_get(Xet, PANEL_VALUE) != NULL)
		counts.XEt = atoi((char *) panel_get(Xet, PANEL_VALUE));
	    if (panel_get(Yet, PANEL_VALUE) != NULL)
		counts.YEt = atoi((char *) panel_get(Yet, PANEL_VALUE));
	    if (panel_get(Set, PANEL_VALUE) != NULL)
		counts.SEt = atoi((char *) panel_get(Set, PANEL_VALUE));
	    if (panel_get(Sfn, PANEL_VALUE) != NULL)
		strcpy(counts.FN_Res, (char *) panel_get(Sfn, PANEL_VALUE));
	    window_return(&counts);
	    window_destroy(frame_count);
	    return ((Panel_setting) 0);
	}
    }
}
/*****************************************************************************/

static struct count_s *
write_count_res_panel()
{
    Panel_item      titre;
    char            rep[20];
    struct count_s *counts;
    rep[0] = 0;
    frame_count = window_create(frame, FRAME, WIN_X, 500, WIN_Y, 500,
				FRAME_NO_CONFIRM, TRUE, 0);
    panel_count = window_create(frame_count, PANEL, PANEL_LABEL_BOLD,
				TRUE, 0);

    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	counts = (struct count_s *) (macro_cour->param);
    else
	counts = NULL;

    titre = panel_create_item(panel_count, PANEL_MESSAGE,
			      PANEL_SHOW_ITEM, TRUE,
			      PANEL_LABEL_X, ATTR_COL(0),
			      PANEL_LABEL_Y, ATTR_ROW(0),
		      PANEL_LABEL_STRING, paneltabs[229],
			      0);

    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	sprintf(rep, "%s", counts->FN_Res);
    else
	rep[0] = 0;
    Sfn = panel_create_item(panel_count, PANEL_TEXT,
			    PANEL_SHOW_ITEM, TRUE,
			    PANEL_LABEL_X, ATTR_COL(1),
			    PANEL_LABEL_Y, ATTR_ROW(2),
			    PANEL_VALUE_DISPLAY_LENGTH, 20,
			    PANEL_VALUE_STORED_LENGTH, 20,
			PANEL_LABEL_STRING, paneltabs[32],
			    PANEL_VALUE, rep,
			    PANEL_NOTIFY_STRING, "\r\n\t\03",
			    PANEL_NOTIFY_PROC, lire_count,
			    0);
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	sprintf(rep, "%d", counts->SMin);
    else
	strcpy(rep,"0");
    Smin = panel_create_item(panel_count, PANEL_TEXT,
			     PANEL_SHOW_ITEM, TRUE,
			     PANEL_LABEL_X, ATTR_COL(1),
			     PANEL_LABEL_Y, ATTR_ROW(3),
			     PANEL_VALUE_DISPLAY_LENGTH, 20,
			     PANEL_VALUE_STORED_LENGTH, 20,
	PANEL_LABEL_STRING, paneltabs[230],
			     PANEL_VALUE, rep,
			     PANEL_NOTIFY_STRING, "\r\n\t\03",
			     PANEL_NOTIFY_PROC, lire_count,
			     0);
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	sprintf(rep, "%d", counts->XEt);
    else
	rep[0] = 0;
    Xet = panel_create_item(panel_count, PANEL_TEXT,
			    PANEL_SHOW_ITEM, TRUE,
			    PANEL_LABEL_X, ATTR_COL(1),
			    PANEL_LABEL_Y, ATTR_ROW(4),
			    PANEL_VALUE_DISPLAY_LENGTH, 20,
			    PANEL_VALUE_STORED_LENGTH, 20,
	  PANEL_LABEL_STRING, paneltabs[231],
			    PANEL_VALUE, rep,
			    PANEL_NOTIFY_STRING, "\r\n\t\03",
			    PANEL_NOTIFY_PROC, lire_count,
			    0);
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	sprintf(rep, "%d", counts->YEt);
    else
	rep[0] = 0;
    Yet = panel_create_item(panel_count, PANEL_TEXT,
			    PANEL_SHOW_ITEM, TRUE,
			    PANEL_LABEL_X, ATTR_COL(1),
			    PANEL_LABEL_Y, ATTR_ROW(5),
			    PANEL_VALUE_DISPLAY_LENGTH, 20,
			    PANEL_VALUE_STORED_LENGTH, 20,
	  PANEL_LABEL_STRING, paneltabs[232],
			    PANEL_VALUE, rep,
			    PANEL_NOTIFY_STRING, "\r\n\t\03",
			    PANEL_NOTIFY_PROC, lire_count,
			    0);
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	sprintf(rep, "%d", counts->SEt);
    else
	strcpy(rep,"0");
    Set = panel_create_item(panel_count, PANEL_TEXT,
			    PANEL_SHOW_ITEM, TRUE,
			    PANEL_LABEL_X, ATTR_COL(1),
			    PANEL_LABEL_Y, ATTR_ROW(6),
			    PANEL_VALUE_DISPLAY_LENGTH, 20,
			    PANEL_VALUE_STORED_LENGTH, 20,
			  PANEL_LABEL_STRING, paneltabs[233],
			    PANEL_VALUE, rep,
			    PANEL_NOTIFY_STRING, "\r\n\t\03",
			    PANEL_NOTIFY_PROC, lire_count,
			    0);
    window_fit(panel_count);
    window_fit(frame_count);
    window_set(panel_count, PANEL_CARET_ITEM, Sfn, 0);
    counts = (struct count_s *) window_loop(frame_count);
    return (counts);
}
/*****************************************************************************/

static void
write_res_count(N, str)
    int             N;
    struct count_s *str;
{
    FILE           *FO;
    int             IMin = VIDE + 1;
    int		    N_O = 0, Coul_e, XEt, YEt, S_All, S_Front = 0, I;
    int             XX, Y;
    unsigned short *Coords, *Adr, Coul;
    float           coeff, coeff_l;
    XEt = min(dir_desc[N].ncolonne - 1, str->XEt);
    if (XEt < 0)
	XEt = 0;
    YEt = min(dir_desc[N].nligne - 1, str->YEt);
    if (YEt < 0)
	YEt = 0;
    FO = fopen(str->FN_Res, "wt");
    if (FO == NULL)
    {
	write_erreur(931);
	return;
    }
    S_All = dir_desc[N].ncolonne * dir_desc[N].nligne;
    Coords = (unsigned short *) malloc(2 * sizeof(short) * (*Histogramme[N]));
    if (Coords == NULL)
    {
	write_erreur(900);
	fclose(FO);
	return;
    }
    memset(Coords, 0xff, 2 * sizeof(short) * (*Histogramme[N]));
    Adr = (unsigned short *) dir_image[N].image;
    for (Y = 0; Y < dir_desc[N].nligne; Y++)
	for (XX = 0; XX < dir_desc[N].ncolonne; XX++, Adr++)
	{
	    if (!(*Adr))
		continue;
	    Coul = *Adr - 1;
	    if ((*Adr != 0xffff) && (*(Coords + Coul + Coul) == 0xffff))
	    {
		*(Coords + Coul + Coul) = XX;
		*(Coords + Coul + Coul + 1) = Y;
	    }
	    if ((XX == dir_desc[N].ncolonne - 3) &&
		(Y == dir_desc[N].nligne - 1))
		break;
	}
    for (I = 1; I <= *Histogramme[N]; I++)
    {
	if (*(Histogramme[N] + I) >= str->SMin)
	    N_O++;
	S_Front += *(Histogramme[N] + I);
    }
    S_Front = S_All - S_Front;
    Coul_e = *((short *) dir_image[N].image + Adresse(XEt, YEt));
    fprintf(FO,
	    "/***************************************************************************/\n");
    fprintf(FO,filetabs[0]);
	    
    fprintf(FO,
	    "/*                                                                         */\n");
    fprintf(FO, filetabs[1]);
	    
    fprintf(FO,
	    "/***************************************************************************/\n");
    fprintf(FO,filetabs[2], dir_desc[N].filename); 
    fprintf(FO, filetabs[3], dir_desc[N].ncolonne, dir_desc[N].nligne);
    fprintf(FO, filetabs[4], str->SMin);
    if (str->SEt)
    {
	fprintf(FO, filetabs[5]);
	fprintf(FO, "X = %d pix, Y = %d pix S = %d pix.\n",
		str->XEt, str->YEt, str->SEt);
	coeff = (float) str->SEt / (float) *(Histogramme[N] + Coul_e);
	coeff_l = (float) sqrt((double) coeff);
	if (flag_regime & BACKGR)
	{
	    N_O--;
	    IMin++;
	    fprintf(FO, filetabs[6],
		    *(Histogramme[N] + 1),
		    (float) ((float) *(Histogramme[N] + 1) * coeff));
	    fprintf(FO,filetabs[7],
		    S_Front, (float) ((float) S_Front * coeff));
	}
	if (N_O == 1)
	    fprintf(FO, filetabs[8], N_O);
	else
	    fprintf(FO, filetabs[9], N_O);
	for (I = IMin; I <= *Histogramme[N]; I++)
	{
	    if (*(Histogramme[N] + I) < str->SMin)
		continue;
	    fprintf(FO,filetabs[10], I,
		(float) ((float) *(Coords + I + I - 2) * coeff_l),
		(float) ((float) *(Coords + I + I - 1) * coeff_l),
		(float) ((float) *(Histogramme[N] + I) * coeff));
	    if (I == Coul_e)
		fprintf(FO, filetabs[11]);
	    fprintf(FO, "\n");
	}
	fprintf(FO, "\n");
}
    else
    {
	if (flag_regime & BACKGR)
	{
	    N_O--;
	    IMin++;
	    fprintf(FO, filetabs[12],
		    *(Histogramme[N] + 1));
	    fprintf(FO, filetabs[13],
		    S_Front);
	}
	if (N_O == 1)
	    fprintf(FO, filetabs[14], N_O);
	else
	    fprintf(FO, filetabs[15], N_O);
	for (I = IMin; I <= *Histogramme[N]; I++)
	{
	    if (*(Histogramme[N] + I) < str->SMin)
		continue;
	    fprintf(FO, filetabs[16], I,
		*(Coords + I + I - 2), *(Coords + I + I - 1),
		*(Histogramme[N] + I));
	}
    }
    free(Coords);
    fclose(FO);
}
/*****************************************************************************/

caddr_t
proc_write_N(m, mi)
    Menu            m;
    Menu_item       mi;
{
    struct commande *com;
    struct count_s *params, *copyparams;
    struct fname   *fn;
    int             taille;
    unsigned short *Adr;

    if (flag_bother) {
	hproc_sauver_objets_comptes();
	return;
    }
    if (flag_help) hproc_sauver_objets_comptes();
    if (flag_creer)
    {
	com = (struct commande *) new_commande(&macro_cour);
	strcpy(com->nom, "MEACRESCO");
	com->code = 3010;
    } else
    {
	sprintf(buf, mastertabs[111]);
	write_master(buf);
    }
    if ((flag_exec == FROMTO_AUTO) || (flag_exec == AUTO))
	index_image[0] = macro_cour->from[0];
    else
	fromto(FROM, DEFAUT);
    if (flag_break)
    {
	interruption();
	return ((caddr_t) 0);
    }
    if (!flag_creer)
    {
	Adr = (unsigned short *) dir_image[index_image[0]].image;
	sprintf(buf, "Image %d", index_image[0]);
	write_master(buf);
	if (Adr == NULL)
	{
	    write_erreur(9);
	    return ((caddr_t) 0);
	}
	if (Histogramme[index_image[0]] == NULL)
	{
	    write_erreur(930);
	    return ((caddr_t) 0);
	}
	taille = dir_desc[index_image[0]].ncolonne *
	    dir_desc[index_image[0]].nligne;
	if ((*(Adr + taille - 2) != MAGIC_1) &&
	    (*(Adr + taille - 1) != MAGIC_2))
	{
	    write_erreur(930);
	    free(Histogramme[index_image[0]]);
	    Histogramme[index_image[0]] = NULL;
	    return ((caddr_t) 0);
	}
    }
    if ((flag_exec == PARAM_AUTO) || (flag_exec == AUTO))
    {
	params = (struct count_s *) malloc(sizeof(*params));
	*params = *((struct count_s *) macro_cour->param);
    } else
	params = write_count_res_panel();
    if (flag_break)
    {
	interruption();
	return ((caddr_t) 0);
    }
    if (flag_creer)
    {
	com->from[0] = index_image[0];
	sprintf(buf, "%s FROM %d WITH %d %d %d %d %s\n",
		com->nom, index_image[0],
		params->SMin, params->XEt, params->YEt, params->SEt,
		params->FN_Res);
	write_macro(buf);
	copyparams = (struct count_s *) malloc(sizeof(*params));
	*copyparams = *params;
	com->param = (char *) params;
	return ((caddr_t) 0);
    }
    sprintf(buf, mastertabs[112],
	    params->FN_Res,params->XEt, params->YEt, params->SEt, params->SMin);
    write_master(buf);
    write_res_count(index_image[0], params);
}
/* -------------------------------------------------------------------------*/
/* static void Tracer_Ligne(LAdr) Remplit une ligne avec la Couleur_Courante*/
/*             et met a jour les limites (*LAdr).XMin et (*LAdr).XMax       */
/*     entree : pointeur vers la structure LIGNE a remplir                  */
/*     sortie : rien                                                        */
/* -------------------------------------------------------------------------*/
static void
Tracer_Ligne(LAdr)
    struct ligne   *LAdr;
{
    unsigned short *Adr;
    (*LAdr).Min = (*LAdr).X;	/* initialise les points gauche et droite */
    (*LAdr).Max = (*LAdr).X + 1;
    for (Adr = (unsigned short *) (VRAM_SAVE + Adresse((*LAdr).X, (*LAdr).Y))
	 ;; Adr--, (*LAdr).Min--)	/* on cherche la fin a gauche de X */
    {
	if (((*LAdr).Min < 0) || (*Adr != Vide_x))
	    break;		/* si on arrive au bord gauche ou a un pixel
				 * plein */
	*Adr = Couleur_Courante;/* Autrement on remplit le pixel */
	Taille_Objet_Courant++;	/* et on incremente la Taille de l'objet */
    }
    (*LAdr).Min++;
    for (Adr = (unsigned short *) (VRAM_SAVE + Adresse((*LAdr).X + 1, (*LAdr).Y))
	 ;; Adr++, (*LAdr).Max++)	/* on cherche la fin a droite de X */
    {
	if (((*LAdr).Max >= XXMax) || (*Adr != Vide_x))
	    break;		/* si on arrive au bord droit ou a un pixel
				 * plein */
	*Adr = Couleur_Courante;/* Autrement on remplit le pixel */
	Taille_Objet_Courant++;	/* et on incremente la Taille de l'Objet */
    }
}
/* ------------------------------------------------------------------------- */
/* static void Colorer_Region(X,Y) Remplit la region autour de X et Y	     */
/*     entree : coordonnees X et Y appartenant a la region		     */
/*     sortie : rien                                                         */
/* ------------------------------------------------------------------------- */
static void
Colorer_Region(X, Y)
    int             X, Y;
{
    struct ligne    L;
    int             I;
    unsigned short *Adr;
    L.X = X;			/* Met les valeurs initiales de X et Y dans
				 * la */
    L.Y = Y;			/* structure LIGNE L */
    Tracer_Ligne(&L);		/* Remplit cette ligne passant par X et Y */
    if (Conn8)			/* Si on remplit en connectivite 8,a lors on */
    {				/* permet a ses voisines immediates d'etre  */
	if (L.Min > 0)		/* plus longs de un pixel de chaque cote,
				 * sans */
	    L.Min--;		/* toutefois depasser les bords de l'image */
	if (L.Max < XXMax)
	    L.Max++;
    }
    if (Y > 0)			/* si il y a une ligne au dessus, on essaye
				 * de la */
    {				/* remplir aussi	 */
	Adr = (unsigned short *) (VRAM_SAVE + Adresse(0, Y - 1));
	for (I = L.Min; I < L.Max; I++)
	    if (*(Adr + I) == Vide_x)
		Colorer_Region(I, Y - 1);
    }
    if (Y < YYMax - 1)		/* si il y a une ligne au dessous, on essaye
				 * de la */
    {				/* remplir aussi	 */
	Adr = (unsigned short *) (VRAM_SAVE + Adresse(0, Y + 1));
	for (I = L.Min; I < L.Max; I++)
	    if (*(Adr + I) == Vide_x)
		Colorer_Region(I, Y + 1);
    }
}
/* ------------------------------------------------------------------------- */
static void
Count_Obj(XM, YM, NN)
    int             XM, YM, NN;
{
    int             X, Y;
    int             Taille_X_Image;	/* On met a jour les variables
					 * globales necessaires */
    int             N;
    Couleur_Courante = 0;
    XXMax = XM;
    YYMax = YM;
    Taille_X_Image = XM * YM;	/* taille de l'image en pixels */
    for (Y = 0; Y < YYMax; Y++)
	for (X = 0; X < XXMax; X++)
	    /* On parcourt tous les pixels de l'image */
	    if (*(VRAM_SAVE + Adresse(X, Y)) == Vide_x)	/* si le pixel est vide */
	    {			/* alors */
		Couleur_Courante++;	/* on choisit une nouvelle couleur */
		if (Couleur_Courante > MAX_OBJETS)
		{		/* si il n'y a plus de couleurs disponibles */
		    write_erreur(920);
		    Histogramme[NN] = NULL;
		    return;	/* on retourne */
		}
		Taille_Objet_Courant = 0;	/* sinon on met a 0 la taille
						 * de l'objet */
		Colorer_Region(X, Y);	/* on remplit la region autour du
					 * pixel */
		Hist[Couleur_Courante - 1] = Taille_Objet_Courant;
		/*
		 * on sauvegarde la taille obtenue dans l'histogramme 
		 */
	    }
    if (Histogramme[NN] != NULL)
	free(Histogramme[NN]);
    if (Couleur_Courante == 0)	/* si il n'y a aucun objet dans l'image */
	Histogramme[NN] = NULL;	/* on retourne vecteur des tailles pointant
				 * vers NUL */
    else			/* sinon on aloue de la place pour ce vecteur */
    {
	Histogramme[NN] = (int *) malloc((Couleur_Courante + 1) * sizeof(int));
	if (Histogramme[NN] == NULL)	/* si il n'y a plus de place */
	{
	    write_erreur(900);
	    return;		/* retour si pas de memoire */
	}
	*Histogramme[NN] = Couleur_Courante;
	memcpy((char *) (Histogramme[NN] + 1), (char *) Hist,	/* on recopie les */
	       Couleur_Courante * sizeof(int));	/* valeurs trouvees dans le */
    }				/* vecteur */
    *(VRAM_SAVE + Taille_X_Image - 2) = MAGIC_1;
    *(VRAM_SAVE + Taille_X_Image - 1) = MAGIC_2;
}
/*****************************************************************************/

static void
make_count(ni, no)
    int             ni, no;
{
    int             ssize, xsize, nn;
    unsigned char  *Adr_c;
    unsigned short *Adr_s;
    if (dir_image[no].image != NULL)
    {
	free(dir_image[no].image);
	dir_image[no].image = NULL;
    }
    xsize = dir_desc[ni].ncolonne * dir_desc[ni].nligne;
    ssize = xsize * sizeof(short);
    dir_image[no].image = (unsigned char *) malloc(ssize);
    if (dir_image[no].image == NULL)
    {
	write_erreur(900);
	return;
    }
    Adr_c = dir_image[ni].image;
    Adr_s = (unsigned short *) dir_image[no].image;
    for (nn = 0; nn < xsize; nn++, Adr_c++, Adr_s++)
    {
	if (*Adr_c == 0)
	    *Adr_s = 0;
	else
	    *Adr_s = 0xffff;
    }
    VRAM_SAVE = (unsigned short *) dir_image[no].image;
    if (flag_regime & CONN8)
	Conn8 = 1;
    else
	Conn8 = 0;
    if (flag_regime & BACKGR)
	Vide_x = VIDE;
    else
	Vide_x = CONTOUR_C;
    Count_Obj(dir_desc[ni].ncolonne, dir_desc[ni].nligne, no);
}
/*****************************************************************************/

static void
proc_remplir_c()
{
    struct commande *com;
    struct count_s *ccount_s, *copyccount_s;
    switch (flag_regime)
    {
    case CONN8 + BACKGR:
	if (flag_creer)
	{
	    com = (struct commande *) new_commande(&macro_cour);
	    strcpy(com->nom, "MEACREFREBC8");
	    com->code = 3001;
	} else
	{
	    sprintf(buf,mastertabs[113]); 
	    write_master(buf);
	}
	break;
    case CONN8:
	if (flag_creer)
	{
	    com = (struct commande *) new_commande(&macro_cour);
	    strcpy(com->nom, "MEACREFRECC8");
	    com->code = 3002;
	} else
	{
	    sprintf(buf, mastertabs[114]);
	    write_master(buf);
	}
	break;
    case BACKGR:
	if (flag_creer)
	{
	    com = (struct commande *) new_commande(&macro_cour);
	    strcpy(com->nom, "MEACREFREBC4");
	    com->code = 3003;
	} else
	{
	    sprintf(buf, mastertabs[115]);
	    write_master(buf);
	}
	break;
    case 0:
	if (flag_creer)
	{
	    com = (struct commande *) new_commande(&macro_cour);
	    strcpy(com->nom, "MEACREFRECC4");
	    com->code = 3004;
	} else
	{
	    sprintf(buf, mastertabs[116]);
	    write_master(buf);
	}
    }
    if ((flag_exec == FROMTO_AUTO) || (flag_exec == AUTO))
    {
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    } else
	fromto(FROMTO, DEFAUT);
    if (flag_break)
    {
	interruption();
	return;
    }
    if (!flag_creer)
    {
	sprintf(buf, "%d --> %d ", index_image[0],
		index_image[1]);
	write_master(buf);
	if (dir_image[index_image[0]].image == NULL)
	{
	    write_erreur(9);
	    return;
	}
    }
    if (flag_creer)
    {
	com->from[0] = index_image[0];
	com->to[0] = index_image[1];
	switch (flag_regime)
	{
	case CONN8 + BACKGR:
	    sprintf(buf, "MEACREFREBC8 FROM %d TO %d\n",
		    index_image[0], index_image[1]);
	    break;
	case CONN8:
	    sprintf(buf, "MEACREFRECC8 FROM %d TO %d\n",
		    index_image[0], index_image[1]);
	    break;
	case BACKGR:
	    sprintf(buf, "MEACREFREBC4 FROM %d TO %d\n",
		    index_image[0], index_image[1]);
	    break;
	case 0:
	    sprintf(buf, "MEACREFRECC4 FROM %d TO %d\n",
		    index_image[0], index_image[1]);
	    break;
	}
	write_macro(buf);
	return;
    }
    if (dir_desc[index_image[0]].type != -1)
    {
	write_erreur(17);
	return;
    }
    if (flag_break)
    {
	interruption();
	return;
    }
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].type = 1;
    make_count(index_image[0], index_image[1]);
    sprintf(buf,mastertabs[117],Couleur_Courante);
    write_master(buf);
    statis(dir_image[index_image[1]].image,
	   dir_desc[index_image[1]].type,
	   dir_desc[index_image[1]].nligne,
	   dir_desc[index_image[1]].ncolonne,
	   &(dir_desc[index_image[1]].mmin),
	   &(dir_desc[index_image[1]].mmax),
	   &(dir_desc[index_image[1]].mu),
	   &(dir_desc[index_image[1]].ecart));
}
/*****************************************************************************/

caddr_t
proc_rc_f_8(m, mi)
    Menu            m;
    Menu_item       mi;
{
    if (flag_bother){
	 hproc_fill_bc8();
	 return;
    }
    if (flag_help) hproc_fill_bc8();
    flag_regime = CONN8 + BACKGR;
    proc_remplir_c();
}
/*****************************************************************************/

caddr_t
proc_rc_f_4(m, mi)
    Menu            m;
    Menu_item       mi;
{
    if (flag_bother){
	 hproc_fill_bc4();
	 return;
    }
    if (flag_help) hproc_fill_bc4();
    flag_regime = BACKGR;
    proc_remplir_c();
}
/*****************************************************************************/

caddr_t
proc_rc_c_8(m, mi)
    Menu            m;
    Menu_item       mi;
{
    if (flag_bother){
	 hproc_fill_cc8();
	 return;
    }
    if (flag_help) hproc_fill_cc8();
    flag_regime = CONN8;
    proc_remplir_c();
}
/*****************************************************************************/

caddr_t
proc_rc_c_4(m, mi)
    Menu            m;
    Menu_item       mi;
{
    if (flag_bother){
	 hproc_fill_cc4();
	 return;
    }
    if (flag_help) hproc_fill_cc4();
    flag_regime = 0;
    proc_remplir_c();
}
/*****************************************************************************/

static void
ccut(n_in, n_out, size)
    int             n_in, n_out;
    struct cut_s    size;
{
    int             y, lelem, step1, step2, ssize, ll;
    unsigned char  *Adr1, *Adr2;
    lelem = element(dir_desc[n_in].type);
    if (dir_image[n_out].image != NULL)
    {
	free(dir_image[n_out].image);
	dir_image[n_out].image = NULL;
    }
    ll = size.XMax - size.XMin;
    ssize = ll * (size.YMax - size.YMin) * lelem;
    if (!ssize)
	return;
    dir_image[n_out].image = (unsigned char *) malloc(ssize);
    if (dir_image[n_out].image == NULL)
    {
	write_erreur(900);
	return;
    }
    Adr1 = dir_image[n_in].image +
	(size.XMin + size.YMin * dir_desc[n_in].ncolonne) * lelem;
    Adr2 = dir_image[n_out].image;
    step1 = dir_desc[n_in].ncolonne * lelem;
    step2 = ll * lelem;
    for (y = size.YMin; y < size.YMax; y++)
    {
	Test_Error(Adr1 >= dir_image[n_in].image+dir_desc[n_in].ncolonne*
				dir_desc[n_in].nligne*lelem);
	Test_Error(Adr2 >= dir_image[n_out].image+ssize);
	memcpy(Adr2, Adr1, step2);
	Adr1 += step1;
	Adr2 += step2;
    }
}
/*****************************************************************************/

static          Panel_setting
lire_cut(item, event)
    Panel_item      item;
    Event          *event;

{
    static struct cut_s ccut_s;
    if (event_id(event) == CTRLC)
    {
	/* demande d'interruption de l'interaction par l'utilisateur */
	flag_break = TRUE;
	window_return(NULL);
	window_destroy(frame_cut);
	return;
    } else
    {
	if (event_id(event) == '\t')
	    return (PANEL_NEXT);
	else
	{
	    if (Xmin_i != NULL)
		ccut_s.XMin = atoi((char *) panel_get(Xmin_i, PANEL_VALUE));
	    if (Ymin_i != NULL)
		ccut_s.YMin = atoi((char *) panel_get(Ymin_i, PANEL_VALUE));
	    if (Xmax_i != NULL)
		ccut_s.XMax = atoi((char *) panel_get(Xmax_i, PANEL_VALUE));
	    if (Ymin_i != NULL)
		ccut_s.YMax = atoi((char *) panel_get(Ymax_i, PANEL_VALUE));
	    window_return(&ccut_s);
	    window_destroy(frame_cut);
	    return;
	}
    }
}
/*****************************************************************************/

static struct cut_s *
cut_in_panel()
{
    Panel_item      titre;
    char            rep[20], Str_x[100];
    struct cut_s   *ccut_s;
    frame_cut = window_create(frame, FRAME, WIN_X, 500, WIN_Y, 500,
			      FRAME_NO_CONFIRM, TRUE, 0);
    panel_cut = window_create(frame_cut, PANEL, PANEL_LABEL_BOLD,
			      TRUE, 0);

    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	ccut_s = (struct cut_s *) (macro_cour->param);
    else
	ccut_s = NULL;

    sprintf(Str_x,mastertabs[118],
	    dir_desc[cut_plan].ncolonne,dir_desc[cut_plan].nligne);
    titre = panel_create_item(panel_cut, PANEL_MESSAGE,
			      PANEL_SHOW_ITEM, TRUE,
			      PANEL_LABEL_X, ATTR_COL(0),
			      PANEL_LABEL_Y, ATTR_ROW(0),
			      PANEL_LABEL_STRING, Str_x,
			      0);

    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	sprintf(rep, "%d", ccut_s->XMin);
    else
	rep[0] = 0;
    Xmin_i = panel_create_item(panel_cut, PANEL_TEXT,
			       PANEL_SHOW_ITEM, TRUE,
			       PANEL_LABEL_X, ATTR_COL(1),
			       PANEL_LABEL_Y, ATTR_ROW(2),
			       PANEL_VALUE_DISPLAY_LENGTH, 20,
			       PANEL_VALUE_STORED_LENGTH, 20,
		  PANEL_LABEL_STRING, paneltabs[234],
			       PANEL_VALUE, rep,
			       PANEL_NOTIFY_STRING, "\r\n\t\03",
			       PANEL_NOTIFY_PROC, lire_cut,
			       0);
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	sprintf(rep, "%d", ccut_s->YMin);
    else
	rep[0] = 0;
    Ymin_i = panel_create_item(panel_cut, PANEL_TEXT,
			       PANEL_SHOW_ITEM, TRUE,
			       PANEL_LABEL_X, ATTR_COL(1),
			       PANEL_LABEL_Y, ATTR_ROW(3),
			       PANEL_VALUE_DISPLAY_LENGTH, 20,
			       PANEL_VALUE_STORED_LENGTH, 20,
		  PANEL_LABEL_STRING, paneltabs[235],
			       PANEL_VALUE, rep,
			       PANEL_NOTIFY_STRING, "\r\n\t\03",
			       PANEL_NOTIFY_PROC, lire_cut,
			       0);
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	sprintf(rep, "%d", ccut_s->XMax);
    else
	rep[0] = 0;
    Xmax_i = panel_create_item(panel_cut, PANEL_TEXT,
			       PANEL_SHOW_ITEM, TRUE,
			       PANEL_LABEL_X, ATTR_COL(1),
			       PANEL_LABEL_Y, ATTR_ROW(4),
			       PANEL_VALUE_DISPLAY_LENGTH, 20,
			       PANEL_VALUE_STORED_LENGTH, 20,
		  PANEL_LABEL_STRING, paneltabs[236],
			       PANEL_VALUE, rep,
			       PANEL_NOTIFY_STRING, "\r\n\t\03",
			       PANEL_NOTIFY_PROC, lire_cut,
			       0);
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	sprintf(rep, "%d", ccut_s->YMax);
    else
	rep[0] = 0;
    Ymax_i = panel_create_item(panel_cut, PANEL_TEXT,
			       PANEL_SHOW_ITEM, TRUE,
			       PANEL_LABEL_X, ATTR_COL(1),
			       PANEL_LABEL_Y, ATTR_ROW(5),
			       PANEL_VALUE_DISPLAY_LENGTH, 20,
			       PANEL_VALUE_STORED_LENGTH, 20,
		  PANEL_LABEL_STRING, paneltabs[237],
			       PANEL_VALUE, rep,
			       PANEL_NOTIFY_STRING, "\r\n\t\03",
			       PANEL_NOTIFY_PROC, lire_cut,
			       0);
    window_fit(panel_cut);
    window_fit(frame_cut);
    window_set(panel_cut, PANEL_CARET_ITEM, Xmin_i, 0);
    ccut_s = (struct cut_s *) window_loop(frame_cut);
    return (ccut_s);
}
/*****************************************************************************/

static void
Order_Min_Max(i,j)
int *i, *j;
{
    int I, J;
    I = *i;
    J = *j;
    *i = min(I,J);
    *j = max(I,J);
}

/*****************************************************************************/

caddr_t
proc_cut(m, mi)
    Menu            m;
    Menu_item       mi;
{
    struct commande *com;
    struct cut_s   *ccut_s, *copyccut_s;
    int             ZMin, ZMax;
   
    if (flag_bother){
	 hproc_decoupages();
	 return;
    }
    if (flag_help) hproc_decoupages();
    if (flag_creer)
    {
	com = (struct commande *) new_commande(&macro_cour);
	strcpy(com->nom, "AUXMODCAP");
	com->code = 117;
    } else
    {
	sprintf(buf, mastertabs[119]);
	write_master(buf);
    }
    if ((flag_exec == FROMTO_AUTO) || (flag_exec == AUTO))
    {
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    } else
	fromto(FROMTO, DEFAUT);
    if (flag_break)
    {
	interruption();
	return ((caddr_t) 0);
    }
    cut_plan = index_image[0];
    if (!flag_creer)
    {
	if (dir_image[index_image[0]].image == NULL)
	{
	    write_erreur(9);
	    return ((caddr_t) 0);
	}
	sprintf(buf, "%d --> %d", index_image[0],
		index_image[1]);
	write_master(buf);
    }
    if ((flag_exec == PARAM_AUTO) || (flag_exec == AUTO))
    {
	ccut_s = (struct cut_s *) malloc(sizeof(*ccut_s));
	*ccut_s = *((struct cut_s *) macro_cour->param);
    } else
	ccut_s = cut_in_panel();
    if (flag_break)
    {
	interruption();
	return ((caddr_t) 0);
    }
    if (flag_creer)
    {
	com->from[0] = index_image[0];
	com->to[0] = index_image[1];
	sprintf(buf, "AUXMODCAP FROM %d TO %d WITH %d %d %d %d\n",
		index_image[0], index_image[1],
		ccut_s->XMin, ccut_s->YMin, ccut_s->XMax, ccut_s->YMax);
	write_macro(buf);
	copyccut_s = (struct cut_s *) malloc(sizeof(*ccut_s));
	*copyccut_s = *ccut_s;
	com->param = (char *) copyccut_s;
	return ((caddr_t) 0);
    }
    if (dir_desc[index_image[0]].type < 0)
    {
	write_erreur(910);
	return;
    }
    if (dir_desc[index_image[0]].type > 3)
    {
	write_erreur(911);
	return;
    }
    sprintf(buf, mastertabs[120],
	    ccut_s->XMin, ccut_s->YMin,
	    ccut_s->XMax, ccut_s->YMax);
    write_master(buf);
    if (flag_break)
    {
	interruption();
	return ((caddr_t) 0);
    }
    Order_Min_Max(&ccut_s->XMin,&ccut_s->XMax);
    ccut_s->XMin = max(0, ccut_s->XMin);
    ccut_s->XMax = min(dir_desc[index_image[0]].ncolonne, ccut_s->XMax);
    Order_Min_Max(&ccut_s->YMin,&ccut_s->YMax);
    ccut_s->YMin = max(0, ccut_s->YMin);
    ccut_s->YMax = min(dir_desc[index_image[0]].nligne, ccut_s->YMax);
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].ncolonne = ccut_s->XMax - ccut_s->XMin;
    dir_desc[index_image[1]].nligne = ccut_s->YMax - ccut_s->YMin;
    ccut(index_image[0], index_image[1], *ccut_s);
    statis(dir_image[index_image[1]].image,
	   dir_desc[index_image[1]].type,
	   dir_desc[index_image[1]].nligne,
	   dir_desc[index_image[1]].ncolonne,
	   &(dir_desc[index_image[1]].mmin),
	   &(dir_desc[index_image[1]].mmax),
	   &(dir_desc[index_image[1]].mu),
	   &(dir_desc[index_image[1]].ecart));

}
#undef CONN8
#undef BACKGR
#undef VIDE 0
#undef CONTOUR_C
#undef MAX_OBJETS
#undef MAGIC_1
#undef MAGIC_2

#ifdef MY_DEBUG
#undef MY_DEBUG
#endif
