; lispbreak.cl 	Copyright 1983, University of Maryland, College Park
(eval-when (compile)  (load "uomfuncs")
                      (load "uommacs"))

(defvar LBattempt-level nil)
(defvar LBlevel 0)
(defvar Standard-Output)

(or (boundp 'LBlevel) (setq LBlevel 0))
(or (boundp 'LBattempt-level) (setq LBattempt-level nil))

(defun LBbegin-attempt nil
  (push1 LBattempt-level (1+ LBlevel)))

(defun LBend-attempt nil
  (pop LBattempt-level))
 
(defmacro attempt (x)
   (declare (inline LBend-attempt))
  `(unwind-protect (progn (LBbegin-attempt) (catch 'LBattempt ,x))
		   (LBend-attempt)))

(defun fail (&optional (val '$$FAIL))
 val
  (throw 'LBattempt val))

(defun lispbreak ()
   (break))
