%{

/************************************************************************
**
**  scan.l - the following lex code is used to parse the config. file
**
************************************************************************/

/*
 * $Log: scan.l,v $
 * Revision 1.3  1991/10/21  17:37:22  jplevyak
 * Fixed minor external declaration error.
 *
 * Revision 1.2  1991/10/14  22:19:50  jefft
 * Fixed problem with path definitiion with AGENT statements
 *
 * Revision 1.1  1991/10/11  23:16:09  jefft
 * Initial revision
 *
 */

#include	<string.h>
#include	"y.tab.h"

#undef		input
#undef		unput

#ifdef DEBUG

YYSTYPE yylval;

main()
{
  int	tmp;
  char buf[256];

  while (gets(buf))  {
    lexi_buf(buf);
    while (tmp = yylex())
       fprintf(stderr, "yylex = %d, yytext = '%s'\n", tmp, yytext);
    }

}
#endif

%}

space [ \t\n]
white [ \t]
sep	[,\(\)]

%%

{space}+	;
"#".*$		;

AGENT		{
                yylval.y_int = AOP;
		return AOP;
                }

INVOKE		{
		yylval.y_int = IOP;
		return IOP;
		}

CONNECT		{
		yylval.y_int = COP;
		return COP;
		}

\.		|
\:		|
\(		|
\)		|
\,		|
\/		{
		return yytext[0];
		}

->		{
		return CSYM;
		}

\|		{
		return PORTSEP;
		}

[0-9]+[0-9\.]*	|
[a-zA-Z\-\/][a-zA-Z0-9\/]*	{
		yylval.y_str = strdup(yytext);
		return Sconstant;
                }


.		;

%%

typedef struct stream {
  char	*buf, *bp;
  struct stream	*prev;
  } Stream;

static Stream	_in, *in = &_in;

lexi_buf(buf)
  char	*buf;
{
  extern long	yyprevious;
  char		*strcat();

  in->buf = in->bp = strcat(buf, "\n");
  NLSTATE;
}

int input()
{
  register char	ch;

  if (ch = *in->bp)
    ++in->bp;

  return ch;
}


unput(ch)
  int ch;
{

  if (ch)
    --in->bp;

  if (*in->bp != ch)  {
    fprintf(stderr, "error: unput\n");
    exit(-1);
    }
}

