#include "globals.h"
#include "object.h"
/************************************************************************
*																		*
*	Copy8Mask(srcData, srcMask, dest, destRect, xColor)					*
*	Draw srcData onto dest.												*
*		srcData 	- pointer to source data.							*
*		srcMask		- pointer to source mask.							*
*					  Draw only where mask is not zero.					*
*		dest 		- pointer to destination record.					*
*		destRect	- Destination rectangle to draw srcData.			*
*					  This also defines the dimensions of srcData 		*
*					  and srcMask.										*
*		xColor		- the color that is transparent						*
*																		*
************************************************************************/
int Copy8Mask(srcData, srcMask, dest, destRect, xColor)
	unsigned char *srcData, *srcMask;
	PixMap *dest;
	Rect *destRect;
	unsigned int xColor;
{
	Rect sectRect;
	int srcWidth, dstWidth, sectWidth, sectHeight;
	int srcStart, dstStart;
	unsigned char *srcEnd;

	register unsigned char *srcPtr, *dstPtr, *maskPtr;

	if(SectRect(destRect, &dest->bounds, &sectRect) < 0)
		return(-1);
	srcWidth = destRect->right - destRect->left;
	dstWidth = dest->bounds.right - dest->bounds.left;
	sectWidth = sectRect.right - sectRect.left;
	sectHeight = sectRect.bottom - sectRect.top;
	srcStart = sectRect.left - destRect->left + 
				srcWidth*(sectRect.top - destRect->top);
	dstStart = sectRect.left - dest->bounds.left + 
				dstWidth*(sectRect.top - dest->bounds.top);
	srcPtr = srcData + srcStart;
	dstPtr = dest->data + dstStart;
	maskPtr = srcMask + srcStart;
	srcEnd = srcPtr + sectHeight*srcWidth;
	while(srcPtr < srcEnd) {
		if(xColor > 255)
			CopyRowData(srcPtr, dstPtr, maskPtr, srcPtr + sectWidth);
		else
			CopyXparentRowData(srcPtr, dstPtr, maskPtr, srcPtr + sectWidth, xColor);
		srcPtr += srcWidth;
		dstPtr += dstWidth;
		maskPtr += srcWidth;
	}
	return(0);
}

/************************************************************************
*																		*
*	CopyRowData(srcPtr, dstPtr, maskPtr, srcEnd)						*
*	Copy one row of source onto dest using mask.						*
*																		*
************************************************************************/
CopyRowData(srcPtr, dstPtr, maskPtr, srcEnd)
	register unsigned char *srcPtr, *dstPtr, *maskPtr, *srcEnd;
{
	while(srcPtr < srcEnd)
		if(*maskPtr++)
			*dstPtr++ = *srcPtr++;
		else
			{ dstPtr++; srcPtr++;}
}

/************************************************************************
*																		*
*	CopyXparentRowData(srcPtr, dstPtr, maskPtr, srcEnd, xColor)			*
*	Copy one row of source onto dest using mask and xColor.				*
*																		*
************************************************************************/
CopyXparentRowData(srcPtr, dstPtr, maskPtr, srcEnd, xColor)
	register unsigned char *srcPtr, *dstPtr, *maskPtr, *srcEnd;
	unsigned int xColor;
{
	while(srcPtr < srcEnd)
		if(*maskPtr++ && *srcPtr != xColor)
			*dstPtr++ = *srcPtr++;
		else
			{ dstPtr++; srcPtr++;}
}






/************************************************************************
*																		*
*	DrawFontCharacter(style, mask, dest, destRect, offset, color)		*
*	Draw srcData onto dest.												*
*		style 		- pointer to the style record.						*
*		mask		- pointer to mask record.							*
*					  Draw only where mask is not zero.					*
*		dest		- pointer to the dest record.						*
*		destRect	- Destination rectangle of where to draw the 		*
*					  character.										*
*		offset		- offset in bytes into the style data				*
*		color		- color of the font character to be drawn			*
*																		*
************************************************************************/
int DrawFontCharacter(style, mask, dest, destRect, offset, color)
	StyleRec *style;
	PixMap *mask, *dest;
	Rect *destRect;
	int offset;
	unsigned int color;
{
	Rect sectRect;
	int dstWidth, maskWidth, sectWidth, sectHeight, rowBytes;
	int srcStart, dstStart, maskStart;
	int srcInc, dstInc, maskInc;
	unsigned char *srcEnd;

	register unsigned char *srcPtr, *dstPtr, *maskPtr, *srcEnd1;

	if(SectRect(destRect, &dest->bounds, &sectRect) < 0)
		return(-1);
	rowBytes = style->rowBytes*8;
	dstWidth = dest->bounds.right - dest->bounds.left;
	maskWidth = mask->bounds.right - mask->bounds.left;
	sectWidth = sectRect.right - sectRect.left;
	sectHeight = sectRect.bottom - sectRect.top;
	srcStart = sectRect.left - destRect->left + 
				rowBytes*(sectRect.top - destRect->top) + offset;
	dstStart = sectRect.left - dest->bounds.left + 
				dstWidth*(sectRect.top - dest->bounds.top);
	maskStart = sectRect.left - mask->bounds.left + 
				maskWidth*(sectRect.top - mask->bounds.top);
	srcInc = rowBytes - sectWidth;
	dstInc = dstWidth - sectWidth;
	maskInc = maskWidth - sectWidth;

	srcPtr = style->mask + srcStart;
	dstPtr = dest->data + dstStart;
	maskPtr = mask->data + maskStart;
	srcEnd = srcPtr + sectHeight*rowBytes;
	while(srcPtr < srcEnd) {
		srcEnd1 = srcPtr + sectWidth;
		for(;srcPtr < srcEnd1; maskPtr++, srcPtr++, dstPtr++)
			if(*maskPtr && *srcPtr)
				*dstPtr = color;
		srcPtr += srcInc;
		dstPtr += dstInc;
		maskPtr += maskInc;
		
	}
	return(0);
}



	