#include "globals.h"

unsigned char *mMalloc(size)
	int size;
{
	unsigned char *data;
	
	if((data = (unsigned char *)malloc(size)) == NULL) {
		printf("Can't allocate %d bytes  Not enough memory.\n", size);
		return (NULL);
	}
	return(data);
}


int countDigits(number)
	int number;
{
	int dig;
	
	dig = 1;
	while((number = number/10) != 0)
		dig++;
	return(dig);
}

SectRect(r1, r2, r3)
Rect *r1, *r2, *r3;
{
	r3->top = MAX(r1->top, r2->top);
	r3->left = MAX(r1->left, r2->left);
	r3->bottom = MIN(r1->bottom, r2->bottom);
	r3->right = MIN(r1->right, r2->right);
	if(r3->right < r3->left || r3->bottom < r3->top)
		return(-1);
	else
		return(0);
}

dumpHex(theData, size)
unsigned char *theData;
int size;
{
int i, j, k;
unsigned char c;
	for(i = 0; i < size; theData += 16) {
		printf("\n%08X   ", theData);
		for(j = 0; j < 16 && i < size; i++, j++)  {
			printf("%02X ", (int)theData[j]);
		}
		for(k = j; k <= 16; k++)
			printf("   ");
		for(k = 0; k < j; k++) {
			c = theData[k];
			if(c < 32 || c > 0x7e)
				c = '.';
			printf("%c", c);
		}
	}
	printf("\n");
}


unsigned char *Expand1to8(bits1, x, y)
	unsigned char *bits1;
	int x, y;
{
	int i, j;
	unsigned char k, *p, *q;
	unsigned char *bits8;

	if((bits8 = mMalloc(x*y)) == NULL)
		return(NULL);
	for(i = 0, p = bits1, q = bits8; i < y; i++, p++)
		for(j = 0, k = 0x80; j < x; j++, k = k>>1) {
			if(!k) {
				k = 0x80;
				p++;
			}
			*q++ = (*p & k) ? 255 : 0;
		}
	return(bits8);
}
