/* types.h 
 * File conversion package.  Global type definitions 
 *
 * Peter Webb, Summer 1990
 */

#ifndef types_h
#define types_h

#include "error.h"

typedef unsigned char byte;

/* File types */

typedef enum ft {
  exec, dir, link, plain, unknown
} FileType;
  

/* Constants for the various data file types - Leave tiff at the end. */

typedef enum dt {
 none = -1, hdf=0, fits, gif, xwd, sunrast, raw8, tiff
} DataType;

#define NUM_TYPES ((int)tiff+1)

/* These are also the names of the command line options.  Therefore they
 * cannot contain spaces.
 */

#define HDF  "hdf"
#define TIFF "tiff"
#define GIF  "gif"
#define FITS "fits"
#define XWD "xwd"
#define SUNRAST "sunrast"
#define RAW8 "raw8"

/* Type and a string */

typedef struct fcvt
{
  char *str;
  DataType t;
} FileCvt;

/* Search directions */

typedef enum sd {
  Forward=1, Backward
} Direction;

/* List of conversion operations */

typedef struct c_blk
{
  DataType from_type, to_type;
  char *from_file, *to_file;
  struct c_blk *next;
} CvtBlk, *CvtBlkPtr;

#define NEXT_BLK(p)  ((p)->next)
#define FROM_FILE(p) ((p)->from_file)
#define FROM_TYPE(p) ((p)->from_type)
#define TO_FILE(p) ((p)->to_file)
#define TO_TYPE(p) ((p)->to_type)

/* List of strings */

typedef struct str_l
{
  char *str;
  struct str_l *next;
} StrList, *StrListPtr;

#define NEXT_STR(p) ((p)->next)
#define LIST_STR(p)   ((p)->str)

/* Structure containing information about a file */

#define MAX_PAL  768        /* Maximum size of a palette */

typedef unsigned long BitMask;

typedef struct finfo
{
  BitMask values;        /* Bitmask indicating which fields are valid */
  char *name;            /* Always valid */
  DataType file_data;
  byte *image;
  float *data;
  float min, max;
  long dimension;   /* Number of dimensions */
  long *ranks;      /* Size of each dimension */
  unsigned char palette[MAX_PAL];  /* Palette data */
  long width, height;
} FileInfo;

/* Bitmask enum.  Must be powers of two */

typedef enum {
 CvtNone = 0, CvtPalette=1, CvtData=2, CvtImage=4, CvtMinMax=8,
} InfoMaskVal;

/* Function pointer */

typedef ErrorCode (*ErrorFuncPtr)() ;

#endif
