/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this
 * code in part or whole into a product for resale.  Free distribution of
 * unmodified source and use of NCSA software is not considered
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: connect.c,v 1.4 1993/08/30 15:55:46 gbourhis Exp $";
#endif


#include <stdio.h>

#include "net.h"


extern void ClearLegend();
extern void InitLegend();
extern void NetDestroyPort();
extern void NetTryResend();
extern int NetSendDisconnect();
extern NetPort *NetCreateInPort();
extern NetPort *NetCreateOutPort();

/*
extern char inPortName[];
 */

NetPort *inP = NULL;
NetPort *outP = NULL;


void
NewConnect(inPort, outPort)
	char *inPort;
	char *outPort;
{
	int i;

	if ((inPort == NULL)&&(outPort == NULL))
	{
		return;
	}

	if (outP != NULL)
	{
		if (!NetSendDisconnect(outP, NULL, NULL)) {
			sleep(1);
			NetTryResend();
		}
		NetDestroyPort(outP);
		outP = NULL;
		ClearLegend();
		InitLegend();
	}
	if (inP != NULL)
	{
		NetDestroyPort(inP);
		inP = NULL;
	}

	inP = NetCreateInPort(inPort);
	outP = NetCreateOutPort(outPort);
/*
	if (outP == NULL)
	{
		ReturnInOut(inP->portName, NULL);
	}
	else
	{
		ReturnInOut(inP->portName, outP->portName);
	}
*/
/*	strcpy(inPortName, inP->portName); */
}
