/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <dtm/dtm.h>

#include "viewer.h"
#include "view.h"
#include "net.h"
#include "mode.h"


#define ABS(x)  ((x)>0) ? (x): (-1.0*(x))


extern int NetSendPointSelect();
extern Cdata *CdataSearchByName();
extern void SheetSelOn();
extern void SheetSelOff();
extern void MoveSheet();


extern NetPort *outP;
extern GC	selGC;
extern Display	*myDpy;
extern int	SdrawWidth, SdrawHeight, SdrawAscent;



void
RubberPoint(V, w, draw)
	View *V;
	Widget w;
	int draw;
{
	int x, y;
	unsigned int width, height;

	if (V->type == V_RASTER)
	{
		x = V->pt_x;
		width = 0;
		y = V->pt_y;
		height = 0;
		XDrawRectangle(myDpy, XtWindow(w), selGC, (x - 2), (y - 2),
			(width + 4), (height + 4));
	}
	else if (V->type == V_SHEET)
	{
		if (draw)
		{
			SheetSelOn(V, w, V->pt_x, V->pt_y);
		}
		else
		{
			SheetSelOff(V, w, V->pt_x, V->pt_y, POINTSEL);
		}
	}
}



void
InitPointSelect(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	if (V->pointSelect)
	{
		RubberPoint(V, w, 0);
	}
	V->pointSelect = True;

	V->pt_x = win_x;
	V->pt_y = win_y;
	RubberPoint(V, w, 1);
}


void
PointSelect(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	if (win_x < 0)
		win_x = 0;
	if (win_y < 0)
		win_y = 0;
	if (win_x >= V->cData->xdim)
		win_x = V->cData->xdim - 1;
	if (win_y >= V->cData->ydim)
		win_y = V->cData->ydim - 1;

	if ((win_x != V->pt_x)||(win_y != V->pt_y))
	{
		RubberPoint(V, w, 0);
		V->pt_x = win_x;
		V->pt_y = win_y;
		RubberPoint(V, w, 1);
	}
}


void
DonePointSelect(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	int x, y;

	x = V->pt_x;
	y = V->pt_y;

	if ((V->cData)&&(V->ispub))
	{
		NetSendPointSelect(outP, V->cData->name, "VALUE", x, y);
	}
}


void
DrawCollabSelectPoint(title, id, x, y)
	char *title;
	char *id;
	int x, y;
{
	Cdata *d;

	d = CdataSearchByName(title);
	if (d)
	{
		if (!(d->V->isUp))
		{
			XtPopup(d->V->shell, XtGrabNone);
			XFlush(myDpy);
		}

		if ((d->V->pointSelect)&&(d->V->isUp))
		{
			RubberPoint(d->V, d->V->drawArea, 0);
		}
		d->V->pointSelect = True;

		d->V->pt_x = x;
		d->V->pt_y = y;

		if (d->V->isUp)
		{
			RubberPoint(d->V, d->V->drawArea, 1);
		}

		if (d->V->next != NULL)
		{
			View *V = d->V->next;
			int X, Y;
			int mx, my;

			if (V->type == V_SHEET)
			{
				X = x / d->xmag;
				Y = y / d->ymag;
			}
			else
			{
				X = x * V->cData->xmag;
				Y = y * V->cData->ymag;
			}

			if ((V->pointSelect)&&(V->isUp))
			{
				RubberPoint(V, V->drawArea, 0);
			}
			V->pointSelect = True;

			if (V->type == V_SHEET)
			{
				mx = (X * SdrawWidth * S_DIGITS) - V->Scroll_x;
				my = (Y * SdrawHeight) - V->Scroll_y;
				MoveSheet(V, V->drawArea, mx, my);
			}

			V->pt_x = X;
			V->pt_y = Y;

			if (V->isUp)
			{
				RubberPoint(V, V->drawArea, 1);
			}

		}
	}
}

