
/***************************************************************************/
/* FUNCTION: int img_quant2()
/*
/* DESCRIPTION:
/*    Quantizes a 24-bit image into an 8-bit image using a 
/*    sophisticated algorithm with excellent results.
/*
/* USAGE:
/*    error_ret = img_quant2(buf24,buf8,xsiz,ysiz,pal);
/*
/* ARGUMENTS:
/*    unsigned char  *buf24     (in) : input 24-bit image array
/*    unsigned char  *buf8     (out) : output 8-bit image array
/*    int            xsiz       (in) : X dimension of image
/*    int            ysiz       (in) : Y dimension of image
/*    unsigned char  pal       (out) : palette for 8-bit image
/*
/* RETURNS: (int)
/*    0 : function call completed successfully
/*
/* COMMENTS:
/*    The 24-bit image input array must be in pixel interleaved format.
/*
/* SEE ALSO:
/*
/* INFO:
/*    Author : NCSA
/*    Date   : May 9, 1990
/*    email  : rayi@ncsa.uiuc.edu
/***************************************************************************/

#define PALBUFSIZE 256

img_quant2(dat24,dat8,xres,yres,pal)
unsigned char *dat24,*dat8;
long xres,yres;
unsigned char *pal;
{
	register int ct,xct,yct;
	register int rres,rd,rr,rn,rct;
	register int gres,gd,gr,gn,gct;
	register int bres,bd,br,bn,bct;
	register int coff,cres;
	register unsigned int *idat[2];
	register unsigned int *cp,*np;
	register unsigned char *dip,*dop,*rp,*gp,*bp;
	unsigned char cdat[PALBUFSIZE * 3],*p;

	if ((idat[0] = (unsigned int *)malloc(6*xres*sizeof(unsigned int))) == NULL){
		printf("error: Memory allocation fault\n");
		return -1;
	}

	cres = 256;
	idat[1] = idat[0] + (3 * xres);

	rres = 6;
	gres = 7;
	bres = 6;
	coff = 2;

	rr = gr = br = 255;
	rn = rres - 1;
	gn = gres - 1;
	bn = bres - 1;

	rp = cdat + coff;
	gp = rp + cres;
	bp = gp + cres;

	for (rct=0; rct<rres; rct++){
		for (gct=0; gct<gres; gct++){
			for (bct=0; bct<bres; bct++){
				*rp++ = (unsigned char)(rr * rct / rn);
				*gp++ = (unsigned char)(gr * gct / gn);
				*bp++ = (unsigned char)(br * bct / bn);
			}
		}
	}

	rp = cdat;
	gp = rp + cres;
	bp = gp + cres;
	cp = idat[0];
	np = idat[1];
	dip = dat24;
	dop = dat8;

	for (xct=3*xres; --xct>=0; )
		*cp++ = *dip++;

	for (yct=0; yct<(yres-1); yct++){
		np = idat[(yct+1)%2];
		for (xct=3*xres; --xct>=0; )
			*np++ = *dip++;

		cp = idat[yct%2];
		np = idat[(yct+1)%2];

		if ((rct = (cp[0] * rn / rr)) > rn) rct = rn;
		if ((gct = (cp[1] * gn / gr)) > gn) gct = gn;
		if ((bct = (cp[2] * bn / br)) > bn) bct = bn;

		*dop++ = ct = (rct * gres + gct) * bres + bct + coff;

		rd = cp[0] - rp[ct];
		gd = cp[1] - gp[ct];
		bd = cp[2] - bp[ct];

		cp += 3;
		np += 3;

		cp[0]  += (rd * 7) >> 4;
		cp[1]  += (gd * 7) >> 4;
		cp[2]  += (bd * 7) >> 4;
		np[-3] += (rd * 5) >> 4;
		np[-2] += (gd * 5) >> 4;
		np[-1] += (bd * 5) >> 4;
		np[0]  += rd >> 4;
		np[1]  += gd >> 4;
		np[2]  += bd >> 4;

		for (xct=2; xct<xres; xct++){
			if ((rct = (cp[0] * rn / rr)) > rn) rct = rn;
			if ((gct = (cp[1] * gn / gr)) > gn) gct = gn;
			if ((bct = (cp[2] * bn / br)) > bn) bct = bn;

			*dop++ = ct = (rct * gres + gct) * bres + bct + coff;

			rd = cp[0] - rp[ct];
			gd = cp[1] - gp[ct];
			bd = cp[2] - bp[ct];

			cp += 3;
			np += 3;

			cp[0]  += (rd * 7) >> 4;
			cp[1]  += (gd * 7) >> 4;
			cp[2]  += (bd * 7) >> 4;
			np[-6] += (rd * 3) >> 4;
			np[-5] += (gd * 3) >> 4;
			np[-4] += (bd * 3) >> 4;
			np[-3] += (rd * 5) >> 4;
			np[-2] += (gd * 5) >> 4;
			np[-1] += (bd * 5) >> 4;
			np[0]  += rd >> 4;
			np[1]  += gd >> 4;
			np[2]  += bd >> 4;
		}

		if ((rct = (cp[0] * rn / rr)) > rn) rct = rn;
		if ((gct = (cp[1] * gn / gr)) > gn) gct = gn;
		if ((bct = (cp[2] * bn / br)) > bn) bct = bn;

		*dop++ = ct = (rct * gres + gct) * bres + bct + coff;

		rd = cp[0] - rp[ct];
		gd = cp[1] - gp[ct];
		bd = cp[2] - bp[ct];

		cp += 3;
		np += 3;

		np[-6] += (rd * 3) >> 4;
		np[-5] += (gd * 3) >> 4;
		np[-4] += (bd * 3) >> 4;
		np[-3] += (rd * 5) >> 4;
		np[-2] += (gd * 5) >> 4;
		np[-1] += (bd * 5) >> 4;
	}

	cp = idat[yct%2];

	if ((rct = (cp[0] * rn / rr)) > rn) rct = rn;
	if ((gct = (cp[1] * gn / gr)) > gn) gct = gn;
	if ((bct = (cp[2] * bn / br)) > bn) bct = bn;

	*dop++ = ct = (rct * gres + gct) * bres + bct + coff;

	rd = cp[0] - rp[ct];
	gd = cp[1] - gp[ct];
	bd = cp[2] - bp[ct];

	cp += 3;

	cp[0]  += (rd * 7) >> 4;
	cp[1]  += (gd * 7) >> 4;
	cp[2]  += (bd * 7) >> 4;

	for (xct=2; xct<xres; xct++){
		if ((rct = (cp[0] * rn / rr)) > rn) rct = rn;
		if ((gct = (cp[1] * gn / gr)) > gn) gct = gn;
		if ((bct = (cp[2] * bn / br)) > bn) bct = bn;

		*dop++ = ct = (rct * gres + gct) * bres + bct + coff;

		rd = cp[0] - rp[ct];
		gd = cp[1] - gp[ct];
		bd = cp[2] - bp[ct];

		cp += 3;

		cp[0]  += (rd * 7) >> 4;
		cp[1]  += (gd * 7) >> 4;
		cp[2]  += (bd * 7) >> 4;
	}

	if ((rct = (cp[0] * rn / rr)) > rn) rct = rn;
	if ((gct = (cp[1] * gn / gr)) > gn) gct = gn;
	if ((bct = (cp[2] * bn / br)) > bn) bct = bn;

	*dop++ = (rct * gres + gct) * bres + bct + coff;

	free(idat[0]);

	p = pal;
	for(xct=0; xct<256; xct++){
		*p++ = cdat[xct];
		*p++ = cdat[xct + PALBUFSIZE];
		*p++ = cdat[xct + (PALBUFSIZE + PALBUFSIZE)];
	}

	return(0);
}

