Render-p3d is a tool for viewing models in a P3D model file.  It
provides a renderer to draw pictures of the models in the file,
marching throught the file one model at a time.  This document will
describe the version of render-p3d that uses the Painter renderer;
this is the renderer used under this program name at the PSC.  A
different renderer can be used to build render-p3d, resulting in
images with a somewhat different appearance.  However, the basic
function of the program is always the same.

On the PSC machines, render-p3d uses the Painter renderer.  This
renderer uses lines and polygons to draw objects from back to front,
so that near things cover up things which are farther away.  This is
called the Painter's Algorithm, because it is what real painters
supposedly do.  This algorithm is fairly fast and general, but it is
not perfect.  Sometimes, from some angles, render-p3d will show an
object which should be hidden by another object, or vice versa.  We're
sorry about this, but using this simple renderer allows render-p3d to
be used by users with the widest possible range of home equipment.
The algorithm will work best if all the objects (polygons, lines,
etc.) in a model are around the same size.

Render-p3d draws on your terminal or workstation screen using the
same set of device drivers used by our CGM translator, GPlot.  Some
of the devices which may be available are:

	xws		X Window System
	xl		X Window System (better for monochrome devices)
	tek4014		tektronix 4014
	tek4010		tektronix 4010
	tek4207		tektronix 4207
	ps		postscript
	cgmb		binary cgm
	cgmc		clear text cgm
	excl		excl page description language
	qms		qms page description language

A number of other devices can also be installed.  You can find the
full list of supported device drivers in the documentation for GPlot.
By default, render-p3d will use the tektronix 4014 device driver.  If
you would rather it used another device driver, you can change it as
follows.  If you want to use device "ps" (the Postscript driver, for
example) place a file named p3d_dflts.lsp in the directory from which
you will be running render-p3d.  The file should contain the
following line:

	(setq p3d-device "ps")

When you start up render-p3d, that file will be read and the "ps"
device will be used.  A number of other parameters, for example the
default attributes used by render-p3d, can be changed by the
same mechanism.  We hope to add a more convenient mechanism in
the future.

You may also choose to add the line:

	(setq p3d-controller "tty")

to your p3d_dflts.lsp file as well, to cause render-p3d to pause after
drawing each model until you hit return.  A number of other
parameters, for example the default attributes used by render-p3d,
can be changed by the same mechanism.

Once the appropriate display device is set, you can proceed to render
your P3D file.  If the file you want to examine is mymodel.p3d, the
appropriate command under VMS is:

$ render_p3d mymodel.p3d	(note the underscore character)

while on Unix systems it is:

% render-p3d mymodel.p3d

When the command is entered, the lisp code which makes up the model
will be parsed by the lisp interpreter within render-p3d.  (If you
want to use the interpreter directly, give the render-p3d command
without a file name).  A number of words will be printed on the
screen as the various parts of your model are parsed.  Eventually,
and for a large model it may take some time, your model will be drawn.

If you have set P3D's controller to "tty" by adding the line given
above to your p3d_dflts.lsp file, you should press the "return" key
on your teminal.  This will cause render-p3d to proceed to draw the
next model in your P3D file.  If you haven't set the controller to
"tty", render-p3d will proceed immediately on to the next model
without waiting.  When all the models have been shown, render-p3d
exits.

If you are using the "xws" device driver and the colors of your model
don't look correct, it may be because the software is having
difficulty controlling the color map of your display.  A quick fix is
to try the Unix command "xstdcmap -all".  If this doesn't work, call
PSC user services or send mail to welling@psc.edu for advice.  Color
map handling is unfortunately rather vendor-dependent and it is not
always easy to convince the display to produce the colors desired.

