.TH TRACE_SNAPS L "11/12/91" "release 1.0"
.SH NAME
trace_snaps takes a trace file generated by a P3D renderer and converts it
via spline interpolation into a P3D file containing a flyby of a model.

.SH SYNOPSIS
.nf
.B "trace_snaps objname tracefile count"
.fi

.SH DESCRIPTION
Trace_snaps is a utility for producing fly-by and walk-through animations
of P3D models.  It does so by taking a trace file from one of the user 
interfaces to P3D and using spline interpolation to move from viewpoint to 
viewpoint so that the motion appears smooth.  It's a little cumbersome; 
hopefully we will have a better tool in the future.

To use it, display the model you are interested in with display-p3d, such
that you can see the view and control the viewing direction from the keyboard.
(We assume that there is only one model and only one view of it in the
P3D file).  Move the viewpoint to the point where you want your animation to 
start.  Use the "t" command to start a trace.  Move through the path you want
your animation to follow;  your viewpoints are being saved to a file
called kui_trace.dat.  When you have finished following the path of your
animation, quit from display-p3d.

Now, copy and edit the P3D file you want to animate.  Look for a line
of the form "(snap object lights camera)".  Comment out that line by
putting a semicolon (";") in front of it, and note the actual name used
for the object.  We will say for the moment that it is "myobject".

Save the file and exit the editor.  You are now ready to use the trace_snaps
command.  Assume that the file name of the P3D file is mymodel.p3d, and
that we want the animation to last 30 seconds.  Thirty seconds at 30
frames per second will require 900 frames of animation, so that is the
number of interpolated viewpoints that we want to use.  The appropriate
trace_snaps command is:

$ trace_snaps myobject kui_trace.dat 900 > flyby.p3d

Trace_snaps writes its output to the standard output, so we have directed
that to the file trace.p3d .

The last step in this long and involved process is to create a P3D file
which will apply the trace you have generated to the original model.
That file, which we will call result.p3d, should contain the following:

;P3D 2.0
(load "p3d.lsp")
(load "mymodel.p3d")
(load "flyby.p3d")

This file will fire up P3D, load your model, and then execute the flyby.
You can preview it by using the command:

$ render-p3d result.p3d

and use it with any of the usual high-quality rendering methods for P3D
to produce the final animation.

.SH COPYRIGHT
Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon
University
.nf
.B "Author Julie Roskies"
.fi
