/****************************************************************************
 * test_stream.c
 * Author Joel Welling and Chris Nuuja
 * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/
/*
This module generates a huge stream of floats and passes it out stdout,
as a test for marchp3d.
*/
#include <stdio.h>
#include <math.h>

#define nx 20
#define ny 20
#define nz 20
#define value (2.0)

static void emit_data()
{
	register int i, j, k, retcnt=0;
	register float x, y, z, radius, theta;
	float dx, dy, dz, datum;

	dx= 1.0/(nx-1);
	dy= 1.0/(ny-1);
	dz= 1.0/(nz-1);
	x= -0.5;
	for (i=0; i<nx; i++) {
		y= -0.5;
		for (j=0; j<ny; j++) {
			z= -0.5;
			for (k=0; k<nz; k++) {
				radius= (float) 
					sqrt( (double)( x*x + y*y +z*z ) );
				theta= asin( z/radius );
				datum= (1.0/(3*radius*radius))*( 
					3.0* cos(theta)*cos(theta) -1.0 );
				printf("%f ",datum);
				if (!(++retcnt % 7)) putchar('\n');
				z += dz;
				}
			y += dy;
			}
		x += dx;
		}
}

main()
{
	emit_data();
}



