!****************************************************************************
!* descrip.mss
!* Author Joel Welling and Doug Wagner
!* Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
!*
!* Permission use, copy, and modify this software and its documentation
!* without fee for personal use or use within your organization is hereby
!* granted, provided that the above copyright notice is preserved in all
!* copies and that that copyright and this permission notice appear in
!* supporting documentation.  Permission to redistribute this software to
!* other organizations or individuals is not granted;  that must be
!* negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
!* University make any representations about the suitability of this
!* software for any purpose.  It is provided "as is" without express or
!* implied warranty.
!*****************************************************************************

PAINTER = [.painter]painter_ren.obj,[.painter]painter.obj, -
	[.painter]painter_clip.obj,[.painter]painter_util.obj, -
	[.painter]paintr_trans.obj

MOTIF_UI = mouse_ui.obj,motif_mi.obj,motif_flyby.obj,motif_view.obj, -
	flyby.obj

!----------------------------------------------------------------------------
! Change this section to select renderers and user interfaces, and to
! customize for your directory structure.
!----------------------------------------------------------------------------
!  To install a given renderer, list the given files on the RENDERER = 
!  and RENDER_LIB = lines.
!
!	renderer:		RENDERER	RENDER_LIB
!
!	Painter renderer	$(PAINTER) 	drawcgm.olb (you must supply 
!						  a copy of the DrawCGM lib)
!
!  To install a given user interface, list the given files on the UI = line.
!
!	user interface:		requires:
!
!	keyboard UI		kui.obj
!	flying UI		fui.obj
!	rocket UI		rui.obj
!	motif UI		$(MOTIF_UI)
!

RENDERER = $(PAINTER)

RENDER_LIB = psc$lib:drawcgmx.olb

UI = $(MOTIF_UI)

!
!  Change the directory given in the following line to the absolute
!  directory to be searched by the lisp (load) function.  This should
!  be the directory which includes p3d.lsp and related files.
!

LOAD_PATH = """p3d$root:[load]"""

! Installer should not have to change anything beyond this point.
!-----------------------------------------------------------------------------

CONTROLLERS = tty.obj,lvr.obj,lvr_io.obj

ALISP = interp.obj,construct.obj,prims.obj,alisp_util.obj,env.obj,mem.obj, -
	lexer.obj,parse.obj,key.obj,ge_error.obj,alisp.obj,scan_token.obj

P3D = render_ctrl.obj,matrix_ops.obj,p3d.obj,control.obj,assist.obj, -
	assist_text.obj,assist_spln.obj,assist_attr.obj,assist_nrml.obj, -
	material.obj,color.obj,vector.obj,point.obj,vertex.obj, -
	$(CONTROLLERS)

all : alisp.exe,hershey.h,dump_p3d.exe,tdump_p3d.exe,render_p3d.exe, -
	display_p3d.exe 
        write sys$output "All done."

alisp_def = alisp.h alisp_node.h

alisp.exe : $(ALISP), call_out.obj, syscall.obj, alisp_main.obj
	$(LINK)/EXECUTABLE=alisp.exe call_out.obj, syscall.obj, -
	alisp_main.obj, $(ALISP), cc/opt

dump_p3d.exe : $(ALISP),call_render.obj,syscall.obj,$(P3D),tui.obj, -
	dump_ren.obj,indent.obj
	$(LINK)/EXECUTABLE=dump_p3d.exe call_render.obj, -
	syscall.obj, tui.obj, dump_ren.obj, indent.obj, $(ALISP), -
	$(P3D), cc/opt

tdump_p3d.exe : $(ALISP),call_render.obj,syscall.obj,$(P3D), -
	tui.obj, tdump_ren.obj,indent.obj
	$(LINK)/EXECUTABLE=tdump_p3d.exe call_render.obj, -
	syscall.obj, tui.obj, tdump_ren.obj, indent.obj, $(ALISP), -
	$(P3D), cc/opt

render_p3d.exe : $(ALISP),call_render.obj,syscall.obj,$(P3D), -
	tui.obj, $(RENDERER), $(RENDER_LIB)
	$(LINK)/EXECUTABLE=render_p3d.exe call_render.obj, -
	syscall.obj, tui.obj, $(ALISP), $(P3D), -
	cc/opt, $(RENDERER), $(RENDER_LIB)/lib

display_p3d.exe : $(ALISP),call_render.obj,syscall.obj,$(P3D), -
	$(UI), $(RENDERER), $(RENDER_LIB)
	$(LINK)/EXECUTABLE=display_p3d.exe call_render.obj, -
	syscall.obj, $(UI), $(ALISP), $(P3D), cc/opt, -
	$(RENDERER), $(RENDER_LIB)/lib

hershey.h : make_hershey.exe hfonts.bin
	$RUN make_hershey

make_hershey.exe : make_hershey.obj
	$(LINK) make_hershey.obj, cc/opt

make_hershey.obj : make_hershey.c hfonts.h
	$(CC) make_hershey.c

! Files related to Painter renderer (in [.painter] subdirectory)
paint_make :
	set default [.painter]
	mms
	set default [-]

[.painter]painter_ren.obj : paint_make
	continue

[.painter]painter.obj : paint_make
	continue

[.painter]painter_clip.obj : paint_make
	continue

[.painter]painter_util.obj : paint_make
	continue

[.painter]paintr_trans.obj : paint_make
	continue

! dumping renderer
dump_ren.obj : dump_ren.c $(alisp_def) p3d.h ge_error.h matrix_ops.h indent.h
	$(CC) dump_ren.c

! traversal dumping renderer
tdump_ren.obj : tdump_ren.c $(alisp_def) p3d.h ge_error.h matrix_ops.h indent.h
	$(CC) tdump_ren.c

! indented writing package
indent.obj : indent.c indent.h ge_error.h alisp_node.h
	$(CC) indent.c

! trivial user interface

tui.obj : tui.c $(alisp_def) p3d.h ge_error.h ren.h control.h ui.h
	$(CC) tui.c

! keyboard user interface
kui.obj : kui.c $(alisp_def) p3d.h ge_error.h ren.h control.h ui.h -
	matrix_ops.h
	$(CC) kui.c

! flying user interface
fui.obj : fui.c $(alisp_def) p3d.h ge_error.h ren.h control.h ui.h -
	matrix_ops.h
	$(CC) fui.c

! rocket user interface
rui.obj : rui.c $(alisp_def) p3d.h ge_error.h ren.h control.h ui.h -
	matrix_ops.h
	$(CC) rui.c

! mouse user interface with Motif
mouse_ui.obj : mouse_ui.c $(alisp_def) p3d.h assist.h ge_error.h -
	matrix_ops.h control.h ren.h ui.h mi.h
	$(CC) mouse_ui.c

motif_mi.obj : motif_mi.c ge_error.h mi.h
	$(CC) motif_mi.c

! P3D core modules
call_render.obj : call_out.c $(alisp_def) render_ctrl.h
	$(CC) /DEFINE="incp3d"/OBJECT=call_render.obj call_out.c

call_out.obj : call_out.c $(alisp_def)
	$(CC) call_out.c

syscall.obj : syscall.c syscall.h ge_error.h $(alisp_def)
	$(CC) syscall.c

assist.obj : assist.c alisp.h ge_error.h p3d.h assist.h sphere.h cylinder.h
	$(CC) assist.c

assist_text.obj : assist_text.c alisp.h alisp_node.h ge_error.h p3d.h -
	matrix_ops.h assist.h hershey.h
	$(CC) assist_text.c

assist_spln.obj : assist_spln.c alisp.h alisp_node.h ge_error.h p3d.h assist.h
	$(CC) assist_spln.c

assist_nrml.obj : assist_nrml.c alisp.h alisp_node.h ge_error.h p3d.h assist.h
	$(CC) assist_nrml.c

assist_attr.obj : assist_attr.c alisp.c alisp_node.h ge_error.h p3d.h assist.h
	$(CC) assist_attr.c

render_ctrl.obj : render_ctrl.c $(alisp_def) p3d.h ge_error.h matrix_ops.h -
	control.h ren.h
	$(CC) render_ctrl.c

matrix_ops.obj : matrix_ops.c $(alisp_def) p3d.h matrix_ops.h ge_error.h
	$(CC) matrix_ops.c

p3d.obj : p3d.c $(alisp_def) p3d.h ge_error.h
	$(CC) p3d.c

control.obj : control.c defs.h $(alisp_def) lvr_defines.h
	$(CC) control.c

material.obj : material.c ge_error.h $(alisp_def) p3d.h ren.h
	$(CC) material.c

! alisp
parse.obj : parse.c $(alisp_def)
	$(CC) parse.c

key.obj : key.c $(alisp_def)
	$(CC) key.c

lexer.obj : lexer.c $(alisp_def)
	$(CC) lexer.c

scan_token.obj : scan_token.c 
	$(CC) scan_token.c
alisp_util.obj : alisp_util.c $(alisp_def)
	$(CC) alisp_util.c

mem.obj : mem.c $(alisp_def)
	$(CC) mem.c

env.obj : env.c $(alisp_def)
	$(CC) env.c

interp.obj : interp.c $(alisp_def)
	$(CC) interp.c

prims.obj : prims.c $(alisp_def)
	$(CC)/DEFINE=(LOAD_PATH=$(LOAD_PATH)) prims.c

construct.obj : construct.c $(alisp_def)
	$(CC) construct.c

alisp.obj : alisp.c $(alisp_def)
	$(CC) alisp.c

alisp_main.o : alisp_main.c
	$(CC) alisp_main.c

! tty controller
tty.obj : tty.c defs.h
	$(CC) tty.c
	
! Sony LVR video disk controller
lvr.obj : lvr.c defs.h lvr_defines.h
	$(CC) lvr.c

lvr_io.obj : lvr_io.c lvr_defines.h
	$(CC) lvr_io.c

ge_error.obj : ge_error.c
	$(CC) ge_error.c

clean :
	if f$search("*.obj") .nes. "" then del *.obj;*
	set default [.painter]
	mms clean
	set default [-]

clobber : clean
	if f$search("*.exe") .nes. "" then del *.exe;*
	set default [.painter]
	mms clobber
	set default [-]

