/****************************************************************************
 * lvr_defines.h
 * Author Grace Giras
 * Copyright 1991, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission to use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/
/* This is included for both lvr.c, the gplot controller module and the
   modules of lvr_do utility program.
 */
#ifdef ardent
#define SYSV
#endif

#ifdef sgi
#define SYSV
#endif

#ifdef vms
#ifndef DEFAULT_PORT
#define DEFAULT_PORT "TTA1:"       /* for laser video */
#endif
#define SYNCHRONIZED 0             /* frame accurate tapeoff */
#define REAL_TIME 1		   /* continuous tapoeoff */
#define GMT_ADJUST 14400	   /* 4 hours in seconds to adjust seconds 
                                      since start 1970 VMS to seconds since
                                      GMT start 1970 */
#ifndef DIAQUEST_PORT
#define DIAQUEST_PORT "TTA0:"	   /* for diaquest used in tapeoff */
#endif
#define START_DIAQUEST 360	   /* New Tape start frame - 12 sec in */
#ifndef TAPEOFF_AUDIT_FILE
#define TAPEOFF_AUDIT_FILE    "lvr_tapeoff.dat"  /* lvr_do tapeoff audit */
#endif
#else  		/* not vms */
#ifdef ultrix   /* decstation 5000*/
#ifndef DEFAULT_PORT
#define DEFAULT_PORT "/dev/tty01"  /* second  serial port */
#endif
#endif

#ifdef sgi	/* silicon graphics?? */
#ifndef DEFAULT_PORT
#define DEFAULT_PORT "/dev/ttyd2"  /* second serial port */
#endif
#endif

#ifndef DEFAULT_PORT
#define DEFAULT_PORT "/dev/tty01"
#endif

#endif          /* if vms; else */

#ifndef AUDIT_FILE
#define AUDIT_FILE "lvr_gplot.dat"	/* for gplot recording audit */
#endif

enum bool_enum  { NO, YES };
typedef unsigned char byte;
typedef enum bool_enum bool;

#define MAX_STRING 256

#define END_VIDEO_FRAME   43500
#define START_DATA_FRAME  90001
#define END_DATA_FRAME    91024
#define USER_DATA_LEN     64

#define FAILED   NO
#define BOO      NO
#define OK       YES

#define FALSE    NO
#define TRUE     YES

#define NOT_DONE NO
#define DONE     YES

#define OFF      NO
#define ON       YES


#define UNTIL_COMPLETE 0
#define END_INPUT   '!'
#define ABORT_INPUT '#'

/* *** return codes *** */
#define COMPLETION                0X01      /* operation completed */
#define ERROR			  0X02      /* Error condition raised */
#define LID_OPEN                  0x03      /* detection of disk ejection */
#define NOT_TARGET                0X05      /* target frame not found -
					       disk dirty or flawed */
#define NO_FRAME_NUMBER           0x06      /* illegal frame */
#define MARK_RETURN               0x07      /* detection of mark set locatn */
#define ACK                       0X0A      /* effective command received */
#define NAK                       0X0B      /* command execution impossible */

#define TIMED_OUT 	          0         /* Timeout waiting for complete */
#define USER_INTERRUPT            0XFF      /* User interrupted during wait
					       for completion from device */
/* Miscellaneous  Recording Codes */
#define FRAME_REC               0XE6

/* Miscellaneous Playback Codes */
#define FWD_STEP	  	0X3D
#define REPEAT                  0X44
#define FWD_STEP_STILL  	0X2B
#define REV_STEP_STILL  	0X2C
#define CONTINUE                0X61
#define PLAY  			0X3A	/* in forward direction */
#define SLOW_PLAY		0X3C	/* .. */
#define FAST_PLAY		0X3B	/* .. */
#define MENU			0X42
#define STILL			0X4F
#define STOP			0X3f

/* Miscellaneous System Setting Codes */
#define CLEAR			0X56
#define EJECT  			0X2A
#define FRAME_MODE		0X55

/* Miscellaneous Status Inquiry Codes */
#define ADDR_INQ		0X60   /* returns 5 byte frame # */ 
#define CURRENT_BLANK_INQ	0XBC   /* returns 5 byte IN, 5 byte OUT  */

/* Commands which return COMPLETION */
#define SEARCH			0x43
#define REC_STANDBY     	0xe0
#define REC             	0xe9
#define EDGE_RIGHT      	0xb9
#define EDGE_LEFT       	0xba
#define BLANK_AREA_SEARCH 	0xbb
#define READ_DATA 		0xe2
#define SET_DATA 		0xe1
#define WRITE_DATA 		0xe3

#define ENTER	 		0x40

#define NO_OP                   0		/* use for timing */

struct record_data_rec
  {
  unsigned char type[4];        /* organization  */
#define USER_RECORD_DATA  0xff
#ifdef SYSV
  long timestamp;
#else
  time_t timestamp;		/* seconds since 1970 type */
#endif
  unsigned short start;         /* start record 1-43500 */
  unsigned short end;           /*  ... end record   */
  unsigned short copies;        /*  # copies playback speed divisor */
#define MAXUSER 12
  char username[MAXUSER];
#define MAXCGM 38 
  char cgm[MAXCGM];             /* filename */
  char checksum;
  };

struct disk_data_rec
  {
  unsigned char type[4];        /* organization  */
#define DISK_INIT_DATA  0xfe
#ifdef SYSV
  long timestamp;
#else
  time_t timestamp;		/* seconds since 1970 type */
#endif
  char not_used[56];
  char checksum;
  };

