
/****************************************************************************
 *                                                                          *
 *	paintr_trans.c                                                      *
 *      Copyright 1989, Pittsburgh Supercomputing Center                    *
 *                      All Rights Reserved                                 *
 *			Authors Joel Welling and Chris Nuuja                *
 *                                                                          *
 ****************************************************************************/

      /*   
      This file defines the functions used for matrix creation and 
      multiplication
      */

#include <ctype.h>
#include <math.h>


#define DegtoRad  0.017453292;	/* = 2pie/360 */
/*				VARIABLE DECLARATION			*/



float *make3dScale(Sx,Sy,Sz)
float Sx,Sy,Sz;
{
	float *newScale;
	register int row,column;
#ifndef NOMALLOCDEF
	char *malloc();
#endif
	
	newScale = (float *) malloc(16*sizeof(float));
	for (row=0;row<4;row++)
		for(column=0;column<4;column++)
			{
			if (column == row)	newScale[4*row+column] = 1.0;
			else newScale[4*row+column] = 0.0;
			}
	newScale[0]= newScale[0] * Sx;
	newScale[5]= newScale[5] * Sy;
	newScale[10]= newScale[10] * Sz;
	return(newScale);
}

float *make3dRotate(Angle,Axis)
float Angle;
char *Axis;
{
	register float *newRotat,radAngle;
	int row,column,i;
#ifndef NOMALLOCDEF
	char *malloc();
#endif
	
	radAngle = Angle * DegtoRad;
	newRotat = (float *) malloc(16*sizeof(float));
	for (i=0;i<16;i++) newRotat[i]=0.0;


	switch(Axis[0])
		{
		case 'x':
			newRotat[0]= 1.0;
			newRotat[5]= cos(radAngle);
			newRotat[6]= sin(radAngle);
			newRotat[9]= 0.0-sin(radAngle);
			newRotat[10]= cos(radAngle);
			newRotat[15]= 1.0;
			break;
		case 'y':
			newRotat[0]= cos(radAngle);
			newRotat[2]= 0.0-sin(radAngle);
			newRotat[5]= 1.0;
			newRotat[8]= sin(radAngle);
			newRotat[10]= cos(radAngle);
			newRotat[15]= 1.0;
			break;
		case 'z':
			newRotat[0]= cos(radAngle);
			newRotat[1]= sin(radAngle);
			newRotat[4]= 0.0-sin(radAngle);
			newRotat[5]= cos(radAngle);
			newRotat[10]= 1.0;
			newRotat[15]= 1.0;
			break;
		default :
			printf("UNKOWN AXIS %s INPUT USING Z \n",Axis);
			newRotat[0]= cos(radAngle);
			newRotat[1]= sin(radAngle);
			newRotat[4]= 0.0-sin(radAngle);
			newRotat[5]= cos(radAngle);
			newRotat[10]= 1.0;
			newRotat[15]= 1.0;
			break;
		}

	return(newRotat);
}

float *make3dTrans(Tx,Ty,Tz)
float Tx,Ty,Tz;
{
	float *newTrans;
	register int row,column;
#ifndef NOMALLOCDEF
	char *malloc();
#endif
	
	newTrans = (float *) malloc(16*sizeof(float));
	for (row=0;row<4;row++)
		for(column=0;column<4;column++)
			{
			if (column == row)	newTrans[4*row+column] = 1.0;
			else newTrans[4*row+column] = 0.0;
			}
	newTrans[12]=Tx;
	newTrans[13]=Ty;
	newTrans[14]=Tz;
	return(newTrans);
}

float *mult3dMatrices(M1,M2)
register float M1[16], M2[16];
{
	register int row,column,i;
	register float *newMatrix;
#ifndef NOMALLOCDEF
	char *malloc();
#endif

	newMatrix = (float *) malloc(16*sizeof(float));

	for (i=0;i<16;i++)	newMatrix[i]=0.0;
	for (row = 0;row<4;row++)
		for (column= 0;column<4;column++)
			for (i=0;i<4;i++)
				newMatrix[(4*row)+column] += M1[(4*row)+i]*
				   M2[(4*i)+column];
	

	return(newMatrix);
}

