/*
 * list.c
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Id: list.c,v 1.1 1991/01/04 18:35:05 welling Exp $
 *
 * $Log: list.c,v $
 * Revision 1.1  1991/01/04  18:35:05  welling
 * Initial revision
 *
 * Revision 3.0  89/10/27  02:05:54  craig
 * Baseline for first official release.
 * 
 */
#include <stdio.h>
#include "constants.h"
#include "typedefs.h"
#include "funcdefs.h"
/*
 * Take a list whose DATA field points to a linked list of objects and
 * turn it into a List.
 */
make_list(obj)
ray_Object *obj;
{
	int i;
	ray_List *list;
	extern ray_ObjList *find_bounds();

	list = (ray_List *)Malloc(sizeof(ray_List));
	/*
	 * Find the unbounded objects on the list as well as the
	 * bounding box of the list.
	 */
	list->unbounded = find_bounds((ray_ObjList **)&obj->data, obj->bounds);
	/*
	 * Transform bounding box if necessary.
	 */
	if (obj->trans)
		transform_bounds(&obj->trans->obj2world, obj->bounds);
	for (i = 0; i < 3; i++) {
		list->bounds[LOW][i] = obj->bounds[LOW][i];
		list->bounds[HIGH][i] = obj->bounds[HIGH][i];
	}
	/*
	 * obj->data now holds list of bounded objects.
	 */
	list->list = (ray_ObjList *)obj->data;
	obj->data = (char *)list;
}

/*
 * Intersect ray & list of objects.
 */
double
int_list(list, source, ray, hitinfo)
ray_List *list;
ray_Primitive *source;
ray_Ray *ray;
ray_HitInfo *hitinfo;
{
	register ray_ObjList *objlist;
	double offset;
	ray_HitInfo hittmp;
	double dist, mindist;
	extern double intersect();

	mindist = FAR_AWAY;
	hittmp.totaltrans = hitinfo->totaltrans;
	/*
	 * Intersect with unbounded objects.
	 */
	for (objlist = list->unbounded; objlist ; objlist = objlist->next) {
		dist = intersect((ray_Object *)objlist->data, source, ray,
					&hittmp);
		if (dist > EPSILON && dist < mindist) {
			mindist = dist;
			*hitinfo = hittmp;
		}
	}
	/*
	 * Check for intersection with bounding box.
	 */
	if (OutOfBounds(&ray->pos, list->bounds)) {
		offset = IntBounds(ray, list->bounds);
		if (offset < EPSILON)
			/*
			 * Ray never hit list.
			 */
			return (mindist == FAR_AWAY ? 0. : mindist);
		else if (mindist < offset)
			/*
			 * Ray hit unbounded object closer than bounding box.
			 */
			return mindist;
		/*
		 * Else the ray enters list-space before it hits an
		 * unbounded object.
		 */
	}
	/*
	 * Intersect with objects on list.
	 */
	for (objlist = list->list; objlist ; objlist = objlist->next) {
		dist = intersect((ray_Object *)objlist->data, source, ray,
						&hittmp);
		if (dist > EPSILON && dist < mindist) {
			mindist = dist;
			*hitinfo = hittmp;
		}
	}

	return (mindist == FAR_AWAY ? 0. : mindist);
}
