#include <stdio.h>
#include <gl.h>
#include <device.h>
#include "knobs.h"

/*
 *
 *   ChemTool revision 2.0  3/89
 *   (C) Copyright Cray Research, Inc. 1989
 *
 *   slider_methods.c: Methods for handling sliders
 */

#define ITEMMITRE     5               /* Width of button mitre */
#define TEXTCREEP     5               /* Vertical text move */
#define TICKH         6
#define SPEED         1.

extern double atof();

/*
 *    Draw the complete slider panel.
 */

int slider_draw (control,mode)

ControlType *control;   /* The slider's data structure */
int mode;               /* -1 - Dropshadow, 0 - inactive, 1 - active */

{

   if (control->type != SLIDER)      /* Are we the right stuff? */
      return (-1);

   if (control->x_size == 0)   /* Auto sizing */
      control->x_size = 300;
   if (control->y_size == 0)
   {
      if (control->name[0] != '\0')
         control->y_size = getheight()*3 + TICKH + 4*MITRE;
      else
         control->y_size = getheight()*2 + TICKH + 3*MITRE + 12;
   }


   if (mode == -1)   /* Draw the drop shadow */
   {
      setpattern (1);      /* Checked pattern */
      KnobColor (3);       /* Black shadow */
      rectf ((Coord) (control->x + DROPOFF), (Coord) (control->y - DROPOFF),
             (Coord) (control->x + control->x_size + DROPOFF),
             (Coord) (control->y + control->y_size - DROPOFF));
      setpattern (0);
   }
   else
   {
/*
 *   Draw the basic form.
 */

      KnobPanel (control->x, control->y, control->x_size, control->y_size);
      slider_update (control, mode);
   }
}

/*
 *   SLIDER_SERVICE: Service the sliders.
 */

int slider_service(control, mode)

ControlType *control;
int mode;               /* -1 - Dropshadow, 0 - inactive, 1 - active */

{
    int old_pos,i,j, ret_code = 0;
    short l,r,t,b;
    long orgx,orgy;
    short data;
    char new_char;
    double value, x;
    double slider_x, slider_x_size, slider_y, slider_y_size;
    int buffer;

    if (control->type != SLIDER)	/* Are we the right stuff? */
        return(-1);

                                       /* Is mouse within slider margin? */
    if ( mouse_x > control->x && 
        mouse_x < control->x + control->x_size &&
        mouse_y > control->y &&
        mouse_y < control->y + control->y_size)
    {
       if (mouse_state)   /* They are using the slider */
       {
          slider_x = control->x + MITRE + TEXTMARGIN;
          slider_x_size = control->x_size - 2*MITRE - 2*TEXTMARGIN;
  
          old_pos = control->pos;
  
          control->pos = mouse_x;
  
          x = (double)(mouse_x - slider_x)/(double)slider_x_size;
                      /* percentage mouse is along slider 0 = start; 1 = end */
          value = x * control->scale + control->base;
                      /* value of slider based on scale */

          if (value < control->base)  /* Slide */
              control->base -= (control->base - value)*SPEED;
          if (value > control->base + control->scale)
              control->base += (value - control->scale - control->base)*SPEED;
          if (value < control->min)  /* Clip */
              value = control->min;
          if (value > control->max)
              value = control->max;
          if (control->base < control->min)
             control->base = control->min;
          if (control->base + control->scale > control->max)
             control->base = control->max - control->scale;
  
          if (value != control->new)  /* We've changed */
          {
             buffer = getbuffer();
             frontbuffer(1);
             control->new = value;
             slider_update(control,1);
             if (!(buffer &2))
                frontbuffer(0);

             if (control->old_string != NULL)  /* Delete typing buffer */
                control->old_string[0] = '\0';

             ret_code = 1;
          }
       }
      else if (control->old_string != NULL)  /* There is a typing buffer */
      {
         getviewport (&l,&r,&b,&t);
         getorigin (&orgx,&orgy);
         orgx += l;
         orgy += b;

         while ( !mouse_state && mouse_x > control->x && 
             mouse_x < control->x + control->x_size &&
             mouse_y > control->y &&
             mouse_y < control->y + control->y_size)
         {
            i = qtest();
            if (qtest() == KEYBD)   /* There is a keyboard event in there */
            {
               qread (&data);   /* Get the character */

               new_char = (char) data;
               if (new_char == '\025' || new_char == '\033') /* Delete line */
                  control->old_string[0] = '\0';
               else if (new_char == '377' || new_char == '\010') /* Erase */
               {
                  i = strlen (control->old_string);
                  if (i > 0)
                     control->old_string[i-1] = '\0';
                  else
                     ringbell();
               }
               else if (new_char == '\015' || new_char == '\012') /* Return */
               {
                  control->new = atof (control->old_string);
                  control->old_string[0] = '\0';
                  buffer = getbuffer();
                  frontbuffer (1);
                  slider_update (control,1);
                  if (!(buffer & 2))
                     frontbuffer (0);
                  ret_code = 1;
                  break;
               }
               else
               {
                  i = strlen(control->old_string);
                  control->old_string[i] = new_char;
                  control->old_string[i+1] = '\0';
               }

               buffer = getbuffer();
               frontbuffer (1);
               slider_update (control,1);
               if (!(buffer & 2))
                  frontbuffer (0);
            }
            else if (i != 0)
               break;  /* Go service this event */

            mouse_x = getvaluator (MOUSEX) - orgx;
            mouse_y = getvaluator (MOUSEY) - orgy;

            i = getbutton (MOUSEBUTTON);
            if (i != mouse_state)
            {
               mouse_state = i;
               mouse_transition = 1;
            }
            else
               mouse_transition = 0;
         }
      }
   }

   return (ret_code);
}

/*
 *   SLIDER_UPDATE: Draw the insides of the slider.
 */

slider_update(control, mode)

ControlType *control;
int mode;               /* -1 - Dropshadow, 0 - inactive, 1 - active */

{

   int x,y;
   int i,j,n;
   int label_ticks;
   double tick_value,xx,yy;
   char number[80];
   Scoord l, r, b, t;
   Scoord vl,vr,vb,vt;
   double slider_x, slider_x_size, slider_y, slider_y_size;
   double slider_y1, slider_y2;


    if (control->type != SLIDER)	/* Are we the right stuff? */
        return(-1);

   gsync();


/*
 *   Make sure the values are reasonable.
 */

   if (control->new < control->base)     /* Slide the base */
       control->base = control->new;
   if (control->new > control->base + control->scale)
      control->base = control->new - control->scale;
   if (control->new < control->min)  /* Clip */
       control->new = control->min;
   if (control->new > control->max)
       control->new = control->max;
   if (control->base < control->min)
      control->base = control->min;
   if (control->base + control->scale > control->max)
      control->base = control->max - control->scale;
/*
 *   Draw scale background and outline.
 */
   slider_x = control->x + MITRE + TEXTMARGIN;
   slider_x_size = control->x_size - 2*MITRE - 2*TEXTMARGIN;
   slider_y = control->y + MITRE;
   slider_y_size = control->y_size - 2*MITRE;

   if (control->name[0] != '\0')   /* Is there a label */
   {
      slider_y1 = (slider_y_size - TICKH - getheight())/2;
      slider_y2 = slider_y_size - slider_y1;
   }
   else
   {
      slider_y2 = slider_y_size - 12;
      slider_y1 = slider_y2 - TICKH - getheight();
   }
/*
 *   See if we have enough room to label ticks.
 */
   if (slider_y1 < getheight())
   {
      label_ticks = 0;
      if (control->name[0] != '\0')   /* Is there a label */
      {
         slider_y1 = (slider_y_size - TICKH - 2) /2;
         slider_y2 = slider_y_size - slider_y1;
      }
      else
      {
         slider_y2 = slider_y_size - 12;
         slider_y1 = slider_y2 - TICKH - 2;
      }
   }
   else
      label_ticks = 1;

   KnobColor(0);  /* clean up the background */
   rectf((Coord) (control->x + MITRE), (Coord) (control->y + MITRE),
          (Coord) (control->x + control->x_size - MITRE),
          (Coord) (control->y + control->y_size - MITRE));

   if (mode == 1)  /* Filled in */
   {
      KnobColor (1);
      rectf ((Coord) (slider_x ), (Coord) (slider_y + slider_y1 ),
            (Coord) (slider_x + slider_x_size ),
            (Coord) (slider_y + slider_y2 ));
      KnobColor (3);   /* Outline box of slider */
   }
   else KnobColor (1);

   rect ((Coord) (control->x + MITRE), (Coord) (control->y + MITRE),
         (Coord) (control->x + control->x_size - MITRE),
         (Coord) (control->y + control->y_size - MITRE));

   rect((Coord) (slider_x ), (Coord) (slider_y + slider_y1),
        (Coord) (slider_x + slider_x_size ),
        (Coord) (slider_y + slider_y2 ));

   if (control->name[0] != '\0')
   {
      cmov2 ((Coord) (slider_x + (slider_x_size -
              strwidth (control->name))/2),
             (Coord) (slider_y + TEXTVFUDGE +
                     (slider_y_size + slider_y2 - getheight())/2));
      charstr (control->name);
   }

   linewidth ((short) 3);
   move2 ((Coord) (slider_x - 2),
          (Coord) (slider_y + slider_y2));
   draw2 ((Coord) (slider_x + slider_x_size + 2),
          (Coord) (slider_y + slider_y2));
   linewidth ((short) 1);

                     /* Draw tick marks */
   if (!control->notick) {
      tick_value = control->incr *
              (int) (control->base/control->incr);
      if (tick_value < control->base)
         tick_value += control->incr;


      getscrmask(&l, &r, &b, &t);
      getviewport (&vl,&vr,&vb,&vt);
      scrmask((Scoord) (slider_x + vl),
              (Scoord) (slider_x + slider_x_size + vl),
              (Scoord) (slider_y + slider_y1 + vb),
              (Scoord) (slider_y + slider_y2 + vb));

      if (tick_value - control->incr/2. >= control->base)
      {
         tick_value -= control->incr/2.;   /* Start on small tick */
         i = 1;
      }
      else
         i = 0;

      while (tick_value <= control->base + control->scale)
      {
         x = slider_x + slider_x_size
             * ((tick_value - control->base)/control->scale);
         move2 ((Coord) x, (Coord) (slider_y + slider_y2));
         if (i%2)
         rdr2 ((Coord) 0, (Coord) -TICKH/2);
         else
         {
            rdr2 ((Coord) 0, (Coord) -TICKH);

            if (label_ticks)
            {
               sprintf (number,"%.4f",tick_value);  /* Label the tick mark */
               cmov2 ((Coord) (x - strwidth(number)/2),
                      (Coord) (slider_y + slider_y1 + 3));
               charstr (number);
            }
         }
         tick_value += control->incr/2.0;
         i++;
      }

      scrmask (l, r, b, t);
   }
/*
 *   Draw the value and name.
 */

   if (control->old_string != NULL && control->old_string[0] != '\0')
   {
      if (control->new_string == NULL)  /* Use standard format */
      {
         x = slider_x + (slider_x_size - 7*strwidth("M"))/2;
         y = slider_y + TEXTVFUDGE + (slider_y1 - getheight())/2;
      
         cmov2 ((Coord) x, (Coord) y);
         charstr (control->old_string);
         if (mode != 0 && mouse_x > control->x && mouse_y > control->y &&
             mouse_x < (control->x + control->x_size) &&
             mouse_y < (control->y + control->y_size))
         {
            KnobColor(4);
            x += strwidth (control->old_string);
            rectf (x, y - 2, x+strwidth("M"), y);
         }
      }
      else
      {
/*
 *   Insert typing buffer into the format string either at the
 *   end or in place of a %f.
 */
         for (i = 0 ; control->new_string[i] != NULL &&
              control->new_string[i] != '%' ; i++)
            number[i] = control->new_string[i];

         number[i] = '\0';
         strcat (number,control->old_string);

         j = strlen (number);
         for ( ; control->new_string[i] != NULL &&
                 control->new_string[i] != 'f' ; i++);

         if (control->new_string[i] == 'f')  /* there may be more */
            for (i++ ; control->new_string[i] != '\0' ; 
                 number[j++] = control->new_string[i++]);
   
         number[j] = '\0';
            
         x = slider_x + (slider_x_size - strwidth(number))/2;
         y = slider_y + TEXTVFUDGE + (slider_y1 - getheight())/2;
         cmov2 ((Coord) x, (Coord) y);
         charstr (number);

         if (mode != 0 && mouse_x > control->x && mouse_y > control->y &&
             mouse_x < (control->x + control->x_size) &&
             mouse_y < (control->y + control->y_size))
         {
            KnobColor(4);
            x += strwidth (number);
            rectf (x, y - 2, x+strwidth("M"), y);
         }
      }
   }
   else
   {
      if (control->new_string == NULL) /* Use standard format */
         sprintf (number,"%.4f",control->new);
      else
         sprintf (number,control->new_string,control->new);

      cmov2 ((Coord) (slider_x + (slider_x_size - strwidth (number))/2),
              (Coord) (slider_y + TEXTVFUDGE +
                       (slider_y1 - getheight())/2));
      charstr (number);
   }
   

/*
 *   Draw the current value indicator
 */
   n =  (control->new - control->base)/control->scale
        * slider_x_size + slider_x;  /* get x pixel loc of value */

   if (mode == 1)
   {
      KnobColor (4);
      pmv2  ((Coord) n, (Coord) slider_y + slider_y2 + 3);
      rpdr2 ((Coord) -4, (Coord) 7);
      rpdr2 ((Coord) 8, (Coord) 0);
      pclos ();
      KnobColor(3);
   }
   else
      KnobColor (1);
   move2 ((Coord) n, (Coord) slider_y + slider_y2);
   draw2 ((Coord) n, (Coord) slider_y + slider_y2 + 3);
   rdr2  ((Coord) -4, (Coord) 7);
   rdr2  ((Coord) 8, (Coord) 0);
   draw2 ((Coord) n, (Coord) slider_y + slider_y2 + 3);

/*
 *   If there are undisplayed regions of the scale draw end arrows
 *   otherwise draw end caps.
 */

   if (control->base > control->min) /* Down arrow */
   {
      pmv2  ((Coord) (slider_x-3),
             (Coord) (slider_y + slider_y2));
      rpdr2 ((Coord) 0, (Coord) 5);
      rpdr2 ((Coord) -4, (Coord) -5);
      rpdr2 ((Coord) 4, (Coord) -5);
      pclos();
   }
   else
   {
      rectf ((Coord) (slider_x - 3),
             (Coord) (slider_y + slider_y2 + 5),
             (Coord) (slider_x - 4),
             (Coord) (slider_y + slider_y2 - 5));
   }

   if (control->base + control->scale < control->max)
   {
      pmv2  ((Coord) (slider_x + slider_x_size + 3),
             (Coord) (slider_y + slider_y2));
      rpdr2 ((Coord) 0, (Coord) 5);
      rpdr2 ((Coord) 4, (Coord) -5);
      rpdr2 ((Coord) -4, (Coord) -5);
      pclos();
   }
   else
   {
      rectf ((Coord) (slider_x + slider_x_size + 3),
             (Coord) (slider_y + slider_y2  + 5),
             (Coord) (slider_x + slider_x_size + 4),
             (Coord) (slider_y + slider_y2 - 5));
   }
}

