/****************************************************************************
 * syscall.c
 * Author Joel Welling
 * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/
/* This module provides access to operating system facilities */
#include "alisp.h"
#include "ge_error.h"
#include <ctype.h>
#include <string.h>
#include "syscall.h"

static char *allowed_commands[]= {
	"ls",
	"df",
	"beginlog",
#ifdef never
	"copydown",
#endif
	"endlog",
	(char *)NULL	/* this should come last */
};

/* 
This routine takes a command line, and if the first word is in an
'allowed' list causes a shell to execute the line.
*/
NODE *shellcall(cmdline)
NODE *cmdline;
{
	char *cmdstring;
	int i=0, match=0;

	/* Extract the string from the NODE* */
	cmdstring= getstring( car(cmdline) );

	ger_debug("shellcall: command is <%s>", cmdstring);

	/* Advance through the line to drop leading unprintable characters */
	while ( isspace(*cmdstring) ) cmdstring++;

	/* Check for legality and execute */
	while ( allowed_commands[i] && !match )
		{
		if ( !strncmp( cmdstring, allowed_commands[i], 
			strlen( allowed_commands[i] ) ) )
			{
			system( cmdstring );
			match= 1;
			}
		i++;
		}

	if (!match) ger_error(
		"shellcall: unknown or illegal command <%s>", cmdstring);

	return(NIL);

}
