/****************************************************************************
 * tty.c
 * Author Phil Andrews
 * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/
#include <stdio.h>
#include "defs.h"
#ifdef VMS
#include ssdef		/* systems services */
#include iodef		/* for QIO's */
#include ttdef		/* tty flags */
#include dcdef		/* device flags */
#include descrip	/* descriptors */
#include stat		/* UNIX fstat command */
/* the tty controller module */
/*now define some globals that are useful to have if we muck with the screen*/
/* keep the original terminal characteristics in here */
static struct qio_buffer {
	char class;
	char type;
	short width;
	char basic[3];
	char length;
	int extended;
	} tt_c_buf;
static int fix_screen = -1;  /* need to reset the tty char when done */
static short s_channel, funct_code, iosb[4];
static int channel;
int SYS$ASSIGN(), SYS$QIOW(), LIB$SIGNAL();
#endif
#define ctrl_g	'\007'	/* ring bell */
static int deb;
/* check on the terminal characteristics */
tty_begin()
{

#ifdef VMS	/* don't know what to do on UNIX yet */

/*  plan: find out SYS$OUTPUT device name, open a channel on it, find out 
    if it is a terminal, if various silly characteristics are set, unset
    them and put them back at the end of the job 
*/
int ret, i;
struct stat buffer;
struct dsc$descriptor_s dev_desc;
int dev_class, ret_len, wrap_set, form_set, page_length, have_term,
page_width;
int event_flag = 0, *flag_ptr;
struct qio_buffer  new_buf;


	if (stat("SYS$OUTPUT", &buffer))
	    fprintf(stderr, "trouble with fstat !\n");

	if (deb) fprintf(stderr, "dev = [%s]\n", buffer.st_dev);
	
	dev_desc.dsc$w_length = strlen(buffer.st_dev);
	dev_desc.dsc$a_pointer = buffer.st_dev;
	dev_desc.dsc$b_class	= DSC$K_CLASS_S;
	dev_desc.dsc$b_dtype	= DSC$K_DTYPE_T;

	if (SS$_NORMAL != (ret = SYS$ASSIGN(&dev_desc, &channel, 0, 0)))
	    LIB$SIGNAL(ret);

	if (deb) fprintf(stderr, "channel = %d\n", channel);

	/* see if we have a terminal, wrap, form, page_length */
	funct_code = IO$_SENSEMODE;
	s_channel = channel;
	event_flag = 0;

	if (SS$_NORMAL != (ret = SYS$QIOW(event_flag, s_channel, funct_code, 
	    iosb, NULL, NULL, &tt_c_buf, (sizeof tt_c_buf), NULL,
	    NULL, NULL, NULL)))
		LIB$SIGNAL(ret);

	have_term = (tt_c_buf.class == DC$_TERM);
	page_length = tt_c_buf.length;	
	page_width = tt_c_buf.width;	
	flag_ptr = tt_c_buf.basic;
	wrap_set = *flag_ptr & TT$M_WRAP ? 1 : 0;
	form_set = *flag_ptr & TT$M_MECHFORM ? 1 : 0;

	if (deb) fprintf(stderr, 
	    "term = %d, form = %d, wrap = %d, length = %d, width = %d\n",
		have_term, form_set, wrap_set, page_length, page_width);

	if (!have_term)	/* not talking to a terminal ! */
	    return(1);

	if ( (form_set) && (!wrap_set) ) { /* as we want it */
	    fix_screen = 0;
	    return(1);
	}
	fix_screen = 1;
	new_buf.class = tt_c_buf.class;
	new_buf.type = tt_c_buf.type;
	new_buf.width = tt_c_buf.width;
	for (i=0; i<3; ++i) new_buf.basic[i] = tt_c_buf.basic[i];
	new_buf.length = tt_c_buf.length;
	new_buf.extended = tt_c_buf.extended;

	flag_ptr = new_buf.basic;

	(*flag_ptr) |= TT$M_MECHFORM;	/* set form */
	(*flag_ptr) &= (~TT$M_WRAP);	/* no wrap */

	funct_code = IO$_SETMODE;
	event_flag = 0;

	if (SS$_NORMAL != (ret = SYS$QIOW(event_flag, s_channel, funct_code, 
	    iosb, NULL, NULL, &new_buf, (sizeof new_buf), NULL,
	    NULL, NULL, NULL)))
		LIB$SIGNAL(ret);
#endif
	return(1);
}
/* tty controller stuff */
tty_bpage()
{
	return(1);
}

tty_epage()
{
	putchar(ctrl_g);
	fflush(stdout);
	getchar();	/* give user time to read page */
	return(1);
}
tty_end()
{
int event_flag, ret;
#ifdef VMS
	if (fix_screen > 0) {	/* clean up */
	    if (deb) fprintf(stderr, "resetting terminal\n");
	    funct_code = IO$_SETMODE;
	    event_flag = 0;

	    if (SS$_NORMAL != (ret = SYS$QIOW(event_flag, s_channel, funct_code, 
	        iosb, NULL, NULL, &tt_c_buf, (sizeof tt_c_buf), NULL,
	        NULL, NULL, NULL)))
	    	LIB$SIGNAL(ret);
	
	}
#endif
	return(1);
}
/* set up everything here */
void tty_ctrl(ctrl, opt)
int (*ctrl[])();	/* controller functions, out only */
struct one_opt *opt;	/* the command line options, in only */
{
	/* the controller delimiter functions */
	ctrl[(int) B_Mf] 	= tty_begin;
	ctrl[(int) B_Pic_Body]	= tty_bpage;
	ctrl[(int) E_Pic]	= tty_epage;
	ctrl[(int) E_Mf]	= tty_end;

	deb = opt[(int) debug].set;	/* do we want to debug ? */

}
