.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DEWOD 3D "Dore"
.SH NAME
FORTRAN only)
.SH SYNOPSIS
.nf
.ft 3 
FORTRAN:
.in  +.5i
DEWOD(OBJECT, FROMDATA, SIZE)
INTEGER*4 OBJECT
REAL*8 FROMDATA(*)
INTEGER*4 SIZE
.fi 
.SH DESCRIPTION
.IX DEWOD
.LP
FORTRAN user-defined
primitives to write to the private
data of the object with which the method is called.
It copies \f2SIZE\fP bytes from \f2FROMDATA\fP
to the private data of the object \f2OBJECT\fP.
.LP
Note that the type of \f2FROMDATA\fP is not important since
\f2DEWOD\fP only uses the address of it as a starting point for the
copy.  Typically, \f2FROMDATA\fP will be an array containing
variables of different types (via an EQUIVALENCE statement).
.SH SEE ALSO
DeCreateObject(3D), DEROD(3D), DEDOD(3D)
