.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DdInqColorEntries 3D  "Dore"
.SH NAME
DdInqColorEntries \- Return color lookup table entries of a device
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DdInqColorEntries(device, colormodel, start, count, 
		entries)
DtObject device;
DtColorModel colormodel;
DtInt start;
DtInt count;
DtReal entries[\|];
.sp
.in  -.5i
.(z
FORTRAN:
.in  +.5i
CALL DDQCE(DEVICE, COLMOD, START, COUNT, 
		ENTRYS)
INTEGER*4 DEVICE
INTEGER*4 COLMOD
INTEGER*4 START
INTEGER*4 COUNT
REAL*8 ENTRYS(*)
.in  -.5i
.)z
.fi
.SH DESCRIPTION
.IX DDQCE
.IX DdInqColorEntries
.I DdInqColorEntries
returns, in the supplied array \f2entries\fP, all the color entries in
the color lookup table, starting at the \f2start\fP location for
\f2count\fP number of entries on the specified device
\f2device\fP.  Each entry's length is determined by
the \f2colormodel\fP parameter, which specifies the color model used to
represent color information.
.PP
Many actual devices use a color lookup table or a fixed set of colors
or grey values.  \f2DdInqColorEntries\fP allows the user to determine
the values of the user-writable or fixed set of tables.  
.SH ERRORS
.I DdInqColorEntries
will fail if the device handle is invalid.
.TP 15
[WARNING - invalid device handle]
.PP
\f2DdInqColorEntries\fP will also fail if the \f2start\fP or \f2count\fP
parameters refer to entries outside the color lookup table boundaries.
.TP 15
[WARNING - bad start and/or count values]
.SH "SEE ALSO"
.na
.nh
DdSetColorEntries(3D), DdInqColorTableSize(3D), DdInqVisualType(3D)
.ad
.hy
