.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DdInqPickPathOrder 3D "Dore"
.SH NAME
DdInqPickPathOrder \- Return the pick path order of a device
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtPickPathOrder DdInqPickPathOrder(device)
DtObject device;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DDQPPO(DEVICE)
INTEGER*4 DEVICE
.in -.5i
.fi
.SH DESCRIPTION
.IX DDQPPO
.IX DdInqPickPathOrder
.I DdInqPickPathOrder
returns the pick path order on the device, \f2device\fP.
A device's pick path order specifies the order in which
elements in the pick paths are returned on a device, \f2device\fP,
by \f2DdPickObjs\fP <\f2DDPO\fP>.  See \f2DdSetPickCallback\fP
for a description of pick paths.
.PP
The two possible values returned for a device's pick path order 
are:
.IP "\f2DcTopFirst\fP  <\f2DCTOPF\fP>"
This pick path starts with the group at the root
of the display tree containing the picked primitive object
and ends with the picked primitive object itself.
.IP "\f2DcBottomFirst\fP <\f2DCBOTF\fP>"
This pick path starts with the picked primitive
object and ends with the group at the root of the same display
tree.
.PP
Note: the value of the pick path order affects only the order of pick
path elements in paths returned from \f2DdPickObjs\fP <\f2DDPO\fP> 
and does NOT affect the order of elements as seen by the pick
callback functions (see \f2DdSetPickCallback\fP).
.SH ERRORS
.I DdInqPickPathOrder
will fail if passed an invalid device handle; the returned value is undefined.
.TP 15
[WARNING - invalid device handle]
.SH "SEE ALSO"
DdSetPickPathOrder(3D), DdPickObjs(3D), DdSetPickCallback(3D)
