.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DdUpdate 3D  "Dore"
.SH NAME
DdUpdate \- Update the specified device
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DdUpdate(device)
DtObject device;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DDU(DEVICE)
INTEGER*4 DEVICE
.in -.5i
.fi
.SH DESCRIPTION
.IX DDU
.IX DdUpdate
.I DdUpdate
causes the indicated device \f2device\fP to update
itself.  If the device has no frame attached to it, this
operation does nothing.  If the device has a frame attached
to it, all views attached to that frame will be updated.
.SH ERRORS
.I DdUpdate
will fail if the device handle is invalid.
.TP 15
[WARNING - invalid device handle]
.PP
.I DdUpdate
will fail if an update is in progress.
.TP 15
[WARNING - traversal already in progress]
.SH "SEE ALSO"
DfUpdate(3D), DvSetUpdateType(3D) DvUpdate(3D)
